<div class="">

    <ul id="tabAC" class="nav nav-pills bordered">
        <li class="active">
            <a href="#general" role="tab" data-toggle="pill">@lang("content.general")</a>
        </li>

        <li class="">
            <a href="#weights" role="tab" data-toggle="pill">@lang("content.aircraft_weight_index")</a>
        </li>

        <li class="">
            <a href="#parts" role="tab" data-toggle="pill">@lang("content.aircraft_parts")</a>
        </li>

     </ul>

    @php $active = 0 @endphp
    <div class="pill-content padding-10 background-white">

    <div class="pill-pane active" id="general">

        <div class="btn-group margin-bottom-10">
            <a target="_blank" href="{{ route("homepage")."#aircraft/maintenance/{$aircraft->id}" }}" class="btn btn-sm btn-warning">@lang("content.maintenance")</a>
        </div>

        <div class="col-sm-12">

            <div class="col-sm-6">

                <div>
                    <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.name")</label>
                    <div class="col-sm-9">
                        <h6>{{ $aircraft->name }}</h6>
                    </div>
                </div>
                <div class="clearfix"></div>

                <div>
                    <label class="control-label margin-top-bottom-10  col-sm-3">MVT @lang("content.name")</label>
                    <div class="col-sm-9">
                        <h6>{{ $aircraft->mvt_name }}</h6>
                    </div>
                </div>
                <div class="clearfix"></div>

                @if (isset($types[$aircraft->aircraft_type_id]))
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.type")</label>
                        <div class="col-sm-9">
                            <h6>{{ $types[$aircraft->aircraft_type_id] }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if (isset($airlines[$aircraft->airline_id]))
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.airline")</label>
                        <div class="col-sm-9">
                            <h6>{{ $airlines[$aircraft->airline_id]  }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif



                @if ($aircraft->description)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.description")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->description }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->msn)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.construction_number"), MSN</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->msn }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->line_number)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.line_number")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->line_number }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->first_flight)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.first_flight")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->first_flight }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->airframe_status)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.airframe_status")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->airframe_status }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->noise_category)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.noise_category")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->noise_category }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->cargo_compartments)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.cargo_compartments")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->cargo_compartments }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->cargo_volume)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.total_cargo_volume")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->cargo_volume }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->hourly_fuel_consumption)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.hourly_fuel_consumption")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->hourly_fuel_consumption }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->email_recipients)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.email_recipients")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->email_recipients }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->stop_emails)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.stop_email_forwarding")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->stop_emails }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                @endif
            </div>

            <div class="col-sm-6">

{{--                @if ($aircraft->config_a)--}}
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">F</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->config_a }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
{{--                @endif--}}

                <div>
                    <label class="control-label margin-top-bottom-10  col-sm-3">C</label>
                    <div class="col-sm-9">
                        <h6>{{ $aircraft->config_c }}</h6>
                    </div>
                </div>

                <div class="clearfix"></div>

{{--                @if ($aircraft->config_w)--}}
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">W</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->config_w }}</h6>
                        </div>
                    </div>
                    <div class="clearfix"></div>
{{--                @endif--}}

                <div>
                    <label class="control-label margin-top-bottom-10  col-sm-3">Y</label>
                    <div class="col-sm-9">
                        <h6>{{ $aircraft->config_y }}</h6>
                    </div>
                </div>

                <div class="clearfix"></div>

                @if ($aircraft->decks)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.number_of_decks")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->decks }}</h6>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                @endif

                @if ($aircraft->aisles)
                    <div>
                        <label class="control-label margin-top-bottom-10  col-sm-3">@lang("content.number_of_aisles")</label>
                        <div class="col-sm-9">
                            <h6>{{ $aircraft->aisles }}</h6>
                        </div>
                    </div>
                @endif
            </div>

        </div>

        <div class="clearfix"></div>

        @if (isset($seatConfig["e"]) && count($seatConfig["e"]))
            <div style="width: 100%; overflow: auto;">
                <div id="seat-map" class="col-lg-12 seatCharts-container"></div>
            </div>
            <div id="legend"></div>
            @include('template.seat-info')

            <div class="clearfix"></div>
        @endif

    </div>

    <div class="pill-pane" id="weights">

        <div id="message-parameters"></div>
        <table class="table table-bordered table-hover" data-aircraft_id="{{ $aircraft->id }}">
            <thead>
                <tr>
                    <th>@lang("content.name")</th>
                    <th>@lang("content.value")</th>
                </tr>
            </thead>

            <tbody>
            @foreach ($aircraftParameters as $key => $parameter)
                @if ($parameter == "Max Take-Off")
                    <tr>
                        <td colspan="3" class="bg-color-gray"><strong>@lang("content.weights"), @lang("content.tons")</strong></td>
                    </tr>
                @elseif($parameter == "Usable Fuel")
                    <tr>
                        <td colspan="3" class="bg-color-gray"><strong>@lang("content.fuel_capacity"), @lang("content.tons")</strong></td>
                    </tr>
                @endif
                <tr>
                    <td>{!! $parameter !!}</td>
                    <td>
                        @php $currentValue = (isset($aircraftCurrentParameters[$key]) && ($aircraftCurrentParameters[$key] || $aircraftCurrentParameters[$key] === "0")) ? $aircraftCurrentParameters[$key] : null @endphp
                        {!! ($currentValue || $currentValue === "0") ? $currentValue : "&mdash;" !!}
                    </td>
                </tr>
            @endforeach
            </tbody>

        </table>
    </div>

    <div class="pill-pane" id="parts">

        <div class="col-sm-12" style="min-height: 450px;">

            <h4>@lang("content.aircraft_parts")</h4>

            @if (isset($aircraftParts) && count($aircraftParts))
                <table class="table table-bordered table-hover margin-top-10">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>@lang("content.part_type")</th>
                        <th>@lang("content.part_number")</th>
                        <th>@lang("content.serial_number")</th>
                    </tr>
                    </thead>

                    <tbody>
                        @foreach ($aircraftParts as $aircraftPart)
                            <tr>
                                <td>{!! $aircraftPart->id !!}</td>
                                <td>{!! $aircraftPart->part_type !!}</td>
                                <td>{!! $aircraftPart->part_number !!}</td>
                                <td>{!! $aircraftPart->serial_number !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            @endif

        </div>

        <div class="clearfix"></div>

    </div>

    </div>

</div>
