@if (count($maintenance))
    <table class="table table-bordered table-striped table-hover">
        <thead>
        <tr>
            <th>No</th>
            <th>@lang("content.ac_reg")</th>
            <th>@lang("content.notes")</th>
            <th>@lang("content.location")</th>
            <th>@lang("content.start_date")</th>
            <th>@lang("content.end_date")</th>

            @if (checkAuthorization(ADMIN))
                <th>@lang("content.updated_by")</th>
                <th>@lang("content.last_updated")</th>
            @endif

            <th>@lang("content.actions")</th>
        </tr>
        </thead>

        <tbody>
        @foreach ($maintenance as $i => $item)
            @php $user = App\Models\User::find($item->user_id) @endphp
            <tr class="records">
                <td>{{ $i + 1 }}</td>
                <td>{{ getAircraft($item->aircraft) }}</td>
                <td class="editable" data-item="note" data-model = 'Maintenance' data-var_type = 'varchar'>{{ $item->note }}</td>
                <td class="editable" data-item="location_code" data-model = 'Maintenance' data-var_type = 'varchar'>{{ $item->location_code }}</td>
                <td class="editable" data-item="arrival_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'>{{ date('d M Y H:i', strtotime($item->arrival_time)) }}</td>
                <td class="editable" data-item="departure_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'>{{ date('d M Y H:i', strtotime($item->departure_time)) }}</td>

                @if (checkAuthorization(ADMIN))
                    <td>{{ $user ? $user->first_name.' '.$user->last_name : '' }}</td>
                    <td>{{ date('M d, Y H:i', strtotime($item->updated_at)) }}</td>
                @endif

                <td>
                    <a class="btn btn-warning" target="_blank" href="{{ route("homepage")."#".url("aircraft/maintenance/{$item->aircraft_id}") }}">@lang("content.view")</a>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@else
    <p class="alert alert-info">@lang("content.found") 0 @lang("content.records")</p>
@endif