<div class="">

    <ul id="tabAC" class="nav nav-pills bordered">
        <li class="active">
            <a href="#general" role="tab" data-toggle="pill">@lang("content.general")</a>
        </li>

        <li class="">
            <a href="#weights" role="tab" data-toggle="pill">@lang("content.aircraft_weight_index")</a>
        </li>

        <li class="">
            <a href="#parts" role="tab" data-toggle="pill">@lang("content.aircraft_parts")</a>
        </li>

     </ul>

    @php $active = 0 @endphp
    <div class="pill-content padding-10 background-white">

    <div class="pill-pane active" id="general">

        <div class="btn-group margin-bottom-10">
            <a target="_blank" href="{{ route("homepage")."#aircraft/maintenance/{$aircraft->id}" }}" class="btn btn-sm btn-warning">@lang("content.maintenance")</a>
        </div>

        {!! Form::open(['method' => 'POST', 'url' => url("aircraft/{$aircraft->id}/edit"), 'class' => 'form-horizontal', 'id' => 'formEdit']) !!}

        <div class="col-sm-12">

            <div class="col-sm-6">

                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">@lang("content.name")</label>
                    <div class="col-sm-9">
                        {!! Form::hidden('current_airline_id', \request("current_airline_id")) !!}
                        {!! Form::text('name', $aircraft->name, ['class'=>'form-control input-sm', 'placeholder'=>'Name', 'id'=>'name']) !!}
                        <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">MVT @lang("content.name")</label>
                    <div class="col-sm-9">
                        {!! Form::text('mvt_name', $aircraft->mvt_name, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">HEX @lang("content.code")</label>
                    <div class="col-sm-9">
                        {!! Form::text('hex_code', $aircraft->hex_code, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.type")</label>
                    <div class="col-sm-9">
                        {!! Form::select('aircraft_type_id', $types, $aircraft->aircraft_type_id, ['class'=>'form-control input-sm', 'id'=>'type_id']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.airline")</label>
                    <div class="col-sm-9">
                        {!! Form::select('airline_id', $airlines, $aircraft->airline_id, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.engine")</label>
                    <div class="col-sm-9">
                        {!! Form::select('engine_id', $engines, $aircraft->engine_id, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.delivery_date")</label>
                    <div class="col-sm-9">
                        {!! Form::text('delivery_date', $aircraft->delivery_date, ['class'=>'form-control date input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.description")</label>
                    <div class="col-sm-9">
                        {!! Form::textarea('description', $aircraft->description, ['rows' => 3, 'class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.construction_number"), MSN</label>
                    <div class="col-sm-9">
                        {!! Form::text('msn', $aircraft->msn, ['class'=>'form-control input-sm', 'id'=>'msn']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.line_number")</label>
                    <div class="col-sm-9">
                        {!! Form::text('line_number', $aircraft->line_number, ['class'=>'form-control input-sm', 'id'=>'line_number']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.first_flight")</label>
                    <div class="col-sm-9">
                        {!! Form::text('first_flight', $aircraft->first_flight, ['class'=>'form-control datepicker input-sm', 'id'=>'first_flight']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.airframe_status")</label>
                    <div class="col-sm-9">
                        {!! Form::select('airframe_status', ["0" => "Inactive", "1" => "Active"], $aircraft->airframe_status, ['class'=>'form-control input-sm', 'id'=>'airframe_status']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.noise_category")</label>
                    <div class="col-sm-9">
                        {!! Form::text('noise_category', $aircraft->noise_category, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.cargo_compartments")</label>
                    <div class="col-sm-9">
                        {!! Form::text('cargo_compartments', $aircraft->cargo_compartments, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.total_cargo_volume")</label>
                    <div class="col-sm-9">
                        {!! Form::text('cargo_volume', $aircraft->cargo_volume, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.hourly_fuel_consumption")</label>
                    <div class="col-sm-9">
                        {!! Form::text('hourly_fuel_consumption', $aircraft->hourly_fuel_consumption, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.email_recipients")</label>
                    <div class="col-sm-9">
                        {!! Form::textarea('email_recipients', $aircraft->email_recipients, ['class'=>'form-control input-sm', 'rows' => 3]) !!}
                    </div>

                </div>

                <div class="form-group">
                    <span class="col-sm-9 col-sm-offset-3 color-red">* Separate emails recipients with ";"</span>

                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.stop_email_forwarding")</label>
                    <div class="col-sm-9">
                        {!! Form::checkbox('stop_emails', 1, $aircraft->stop_emails, ['class'=>'form-control']) !!}
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-sm-offset-3 col-sm-9">
                        {{--<a href="{{ route("homepage")."#".url("fleet-management") }}" class="btn btn-warning">Fleet Management</a>--}}
                        {!! Form::submit(trans("content.save_changes"), [ 'class' => "btn btn-primary"]) !!}
                        {!! Form::hidden('id', \request("id")) !!}
                        {!! Form::hidden('tab', 'aircraft_data') !!}
                        <a href="{{ route("homepage")."#".url("aircraft") }}" class="btn btn-default">@lang("content.back")</a>
                    </div>
                </div>
            </div>

            <div class="col-sm-6">

                 <ul id="tabConfig" class="nav nav-tabs bordered">
                    <li class="">
                        <a href="#config_a" role="tab" data-toggle="tab">@lang("content.first_class") (F)</a>
                    </li>
                    <li class="">
                        <a href="#config_c" role="tab" data-toggle="tab">@lang("content.business_class") (C)</a>
                    </li>
                     <li class="">
                         <a href="#config_w" role="tab" data-toggle="tab">Premium @lang("content.economy_class") (W)</a>
                     </li>
                    <li class="active">
                        <a href="#config_y" role="tab" data-toggle="tab">@lang("content.economy_class") (Y)</a>
                    </li>
                </ul>

                <div id="tabConfigContent" class="pill-content padding-10 background-white">

                    <div class="pill-pane" id="config_a">
                        @include("aircraft.layouts.config-properties", ["class" => "a", "configData" => $seatConfig["a"]])
                    </div>

                    <div class="pill-pane" id="config_c">
                        @include("aircraft.layouts.config-properties", ["class" => "c", "configData" => $seatConfig["b"]])
                    </div>

                    <div class="pill-pane" id="config_w">
                        @include("aircraft.layouts.config-properties", ["class" => "w", "configData" => $seatConfig["w"]])
                    </div>

                    <div class="pill-pane active" id="config_y">
                        @include("aircraft.layouts.config-properties", ["class" => "y", "configData" => $seatConfig["e"]])
                    </div>

                </div>

                <div class="clearfix"></div>

{{--                <div class="form-group">--}}
{{--                    <label class="control-label col-sm-3">@lang("content.fleet_type")</label>--}}

{{--                    <div class="col-md-9 smart-form">--}}
{{--                        <div class="inline-group">--}}
{{--                            <label class="radio">--}}
{{--                                <input type="radio" value="1" name="wide_board" {!! $aircraft->wide_board ? "checked" : "" !!}>--}}
{{--                                <i></i>@lang("content.wide_body")</label>--}}
{{--                            <label class="radio">--}}
{{--                                <input type="radio" name="wide_board" {!! !$aircraft->wide_board ? "checked" : "" !!}>--}}
{{--                                <i></i>@lang("content.narrow_body")</label>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.flexi_config")</label>
                    <div class="col-sm-1 smart-form">
                        <label class="toggle">
                            <input value="1" type="checkbox" name="flexi_config" {!! $aircraft->flexi_config ? "checked" : ""!!}>
                            <i data-swchon-text="YES" data-swchoff-text="NO"></i>
{{--                            <label class="label">@lang("content.flexi_config")</label>--}}
                        </label>
                    </div>
                </div>

                <div class="form-group margin-top-10">
                    <label class="control-label col-sm-3">@lang("content.number_of_decks")</label>
                    <div class="col-sm-9">
                        {!! Form::text('decks', $aircraft->decks, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>

{{--                <div class="form-group">--}}
{{--                    <label class="control-label col-sm-3 color-red">@lang("content.number_of_aisles")</label>--}}
{{--                    <div class="col-sm-3">--}}
{{--                        <label class="control-label col-sm-3">1</label>--}}
{{--                        {!! Form::radio( 'aisles', 1, !$aircraft->aisles || $aircraft->aisles == 1, ['class' => 'form-control input-sm aisles']) !!}--}}
{{--                    </div>--}}
{{--                    <div class="col-sm-3">--}}
{{--                        <label class="control-label col-sm-3">2</label>--}}
{{--                        {!! Form::radio( 'aisles', 2, $aircraft->aisles == 2, ['class' => 'form-control input-sm aisles']) !!}--}}
{{--                    </div>--}}
{{--                </div>--}}

                <div class="form-group">
                    <label class="control-label col-sm-6 color-red">@lang("content.set_as_aircraft_type_default_configuration")(4)</label>
                    <div class="col-sm-3">
                        {!! Form::checkbox( 'aircraft_type_defaults', null, null, ['class' => 'form-control input-sm']) !!}
                    </div>
                </div>

                <div class="form-group margin-top-10 padding-10" style="border-top: 1px solid #9b9b9b;">
                    <div class="col-sm-12">* @lang("content.input") '_' @lang("content.for_walkway")</div>
                    <div class="col-sm-12">** @lang("content.separate_rows_and_seats_with") ';'</div>
                    <div class="col-sm-12">*** @lang("content.extra_space_after_specified_rows")</div>
                    <div class="col-sm-12">(4) @lang("content.sets_current_aircraft_seat_configurations_to_aircraft_type")</div>
                </div>

            </div>

        </div>

        {!! Form::close() !!}

        <div class="clearfix"></div>

        @if (isset($seatConfig["e"]) && count($seatConfig["e"]))
            <div style="width: 100%; overflow: auto;">
                <div id="seat-map" class="col-lg-12 seatCharts-container"></div>
            </div>
            <div id="legend"></div>
            @include('template.seat-info')

            <div class="clearfix"></div>
        @else
            <div class="alert alert-info">
                @lang("content.please_fill_out_seat_configuration_for_seat_chart")
            </div>
        @endif

    </div>

    <div class="pill-pane" id="weights">

        <div id="message-parameters"></div>
        <table class="table table-bordered table-hover" data-aircraft_id="{{ $aircraft->id }}">
            <thead>
                <tr>
                    <th>@lang("content.name")</th>
                    <th>@lang("content.value")</th>
                    <th>@lang("content.actions")</th>
                </tr>
            </thead>

            <tbody>
            @foreach ($aircraftParameters as $key => $parameter)
                @if ($parameter == "Max Take-Off")
                    <tr>
                        <td colspan="3" class="bg-color-gray"><strong>@lang("content.weights"), @lang("content.tons")</strong></td>
                    </tr>
                @elseif($parameter == "Usable Fuel")
                    <tr>
                        <td colspan="3" class="bg-color-gray"><strong>@lang("content.fuel_capacity"), @lang("content.tons")</strong></td>
                    </tr>
                @endif
                <tr>
                    <td>{!! $parameter !!}</td>
                    <td>
                        @php $currentValue = (isset($aircraftCurrentParameters[$key]) && ($aircraftCurrentParameters[$key] || $aircraftCurrentParameters[$key] === "0")) ? $aircraftCurrentParameters[$key] : null @endphp
                        {!! ($currentValue || $currentValue === "0") ? $currentValue : "&mdash;" !!}
                    </td>
                    <td>
                        <div class="btn-group">
                            <button data-value="{!! $currentValue !!}" data-param="{!! $key !!}" class="edit-param btn btn-primary btn-sm">@lang("content.edit")</button>
                            <button data-value="{!! $currentValue !!}" style="display: none" data-param="{!! $key !!}" class="save-param btn btn-danger btn-sm">@lang("content.save")</button>
                            <button data-value="{!! $currentValue !!}" style="display: none" data-param="{!! $key !!}" class="cancel-param btn btn-info btn-sm">@lang("content.cancel")</button>
                            <!--<button class="btn btn-info btn-sm">Certificate</button>-->
                            {{--<button class="btn btn-default btn-sm">Show History</button>--}}
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>

        </table>
    </div>

    <div class="pill-pane" id="parts">

        <div class="col-sm-12" style="min-height: 450px;">

            <h4>@lang("content.aircraft_parts")
                <a href="{{ route("homepage")."#".url("aircraft/add-part?aircraft_id={$aircraft->id}") }}" class="btn btn-primary btn-sm">@lang("content.add_part")</a>
            </h4>

            @if (isset($aircraftParts) && count($aircraftParts))
                <table class="table table-bordered table-hover margin-top-10">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>@lang("content.part_type")</th>
                        <th>@lang("content.part_number")</th>
                        <th>@lang("content.serial_number")</th>
                        <th>@lang("content.actions")</th>
                    </tr>
                    </thead>

                    <tbody>
                    @foreach ($aircraftParts as $aircraftPart)
                        <tr>
                            <td>{!! $aircraftPart->id !!}</td>
                            <td>{!! $aircraftPart->part_type !!}</td>
                            <td>{!! $aircraftPart->part_number !!}</td>
                            <td>{!! $aircraftPart->serial_number !!}</td>
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="{{ route("homepage")."#".url("aircraft/edit-part?id={$aircraftPart->id}") }}" class="btn btn-sm btn-primary">@lang("content.edit")</a>
                                    <a data-confirm-text="Are you sure?" href="{{ route("homepage")."#".url("aircraft/delete-part?id={$aircraftPart->id}") }}" class="btn confirm btn-sm btn-danger">@lang("content.delete")</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach

                    </tbody>
                </table>

            @endif

        </div>

        <div class="clearfix"></div>

    </div>

    </div>

</div>
