<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">

                <ul id="tabStations" class="nav nav-tabs bordered">
                    <li class="active">
                        <a href="#airlines" role="tab" data-toggle="tab">@lang("content.aircraft")</a>
                    </li>

                    <li>
                        <a href="#certificates" role="tab" data-toggle="tab">@lang("content.certificates")</a>
                    </li>

                    <li>
                        <a href="#engines" role="tab" data-toggle="tab">@lang("content.engines")</a>
                    </li>
                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">

                    <div class="tab-pane active" id="airlines">
                        @if (isset($aircraftType))
                            <h1 class="padding-0 margin-top-5">AC Type: {{ getAircraftType($aircraftType, true) }} / {{ getAircraftType($aircraftType) }}</h1>
                        @endif

                        @include("aircraft.list-aircraft")
                    </div>

                    <div class="tab-pane" id="certificates">
                        @include("aircraft-certificate.layouts.aircraft-certificate-list")
                    </div>

                    <div class="tab-pane" id="engines">
                        @include("aircraft-engine.layouts.aircraft-engines-list")
                    </div>
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    pagefunction();

</script>