<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.ac_type")." | ".trans("content.edit").": ".$aircraftType->name])

            <div class="col-sm-12">
                    @if ($errors->all())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal']) !!}

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.name")</label>

                            <div class="col-sm-6">
                                {!! Form::hidden('current_airline_id', \request("current_airline_id")) !!}
                                {!! Form::text('name', $aircraftType->name, ['class'=>'form-control', 'placeholder'=>'Name', 'id'=>'name']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.airline")</label>

                            <div class="col-sm-6">
                                {!! Form::select('airline_id', $airlines, $aircraftType->airline_id, ['class'=>'form-control input-sm', 'required']) !!}
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">IATA</label>

                            <div class="col-sm-6">
                                {!! Form::text('iata_name', $aircraftType->iata_name, ['class'=>'form-control', 'placeholder' => 'IATA', 'required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">ICAO</label>

                            <div class="col-sm-6">
                                {!! Form::text('icao', $aircraftType->icao, ['class'=>'form-control', 'placeholder'=>'ICAO', 'required']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.config")</label>

                            <div class="col-sm-6">
                                <label class="control-label col-sm-1">F</label>
                                <div class="col-sm-2">
                                    {!! Form::text('config_a', $aircraftType->config_a, ['class'=>'form-control input-sm']) !!}
                                </div>

                                <label class="control-label col-sm-1">C</label>
                                <div class="col-sm-2">
                                    {!! Form::text('config_c', $aircraftType->config_c, ['class'=>'form-control input-sm']) !!}
                                </div>

                                <label class="control-label col-sm-1">W</label>
                                <div class="col-sm-2">
                                    {!! Form::text('config_w', $aircraftType->config_w, ['class'=>'form-control input-sm']) !!}
                                </div>

                                <label class="control-label col-sm-1">Y</label>
                                <div class="col-sm-2">
                                    {!! Form::text('config_y', $aircraftType->config_y, ['class'=>'form-control input-sm']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.fleet_type")</label>

                            <div class="col-md-5 smart-form">
                                <div class="inline-group">
                                    <label class="radio">
                                        <input type="radio" value="1" name="wide_board" {!! $aircraftType->wide_board ? "checked" : "" !!}>
                                        <i></i>@lang("content.wide_body")</label>
                                    <label class="radio">
                                        <input type="radio" name="wide_board" {!! !$aircraftType->wide_board ? "checked" : "" !!}>
                                        <i></i>@lang("content.narrow_body")</label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-1"></label>
                            <div class="col-md-5 smart-form">
                                <label class="toggle col-md-2 col-sm-6">
                                    <input value="1" type="checkbox" name="flexi_config" {!! $aircraftType->flexi_config ? "checked" : ""!!}>
                                    <i data-swchon-text="YES" data-swchoff-text="NO"></i>
                                    <label class="label">@lang("content.flexi_config")</label>
                                </label>
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.wake_category")</label>

                            <div class="col-sm-6">
                                {!! Form::text('wake_category', $aircraftType->wake_category, ['class'=>'form-control', 'placeholder'=>'Wake Category']) !!}
                            </div>
                        </div>

                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-2">@lang("content.details")</label>

                            <div class="col-sm-6">
                                {!! Form::text('details', $aircraftType->details, ['class'=>'form-control', 'placeholder'=>'Details', 'id'=>'details']) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.fcm_requirements")</label>

                            <label class="control-label col-sm-2">@lang("content.minimum")</label>
                            <div class="col-sm-1">
                                {!! Form::text('min_fcm', $aircraftType->min_fcm, ['class'=>'form-control input-sm']) !!}
                            </div>

                            <label class="control-label col-sm-2">@lang("content.policy")</label>
                            <div class="col-sm-1">
                                {!! Form::text('policy_fcm', $aircraftType->policy_fcm, ['class'=>'form-control input-sm', 'id'=>'policy_fcm']) !!}
                            </div>

                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-2">@lang("content.ccm_requirements")</label>

                            <label class="control-label col-sm-2">@lang("content.minimum")</label>
                            <div class="col-sm-1">
                                {!! Form::text('min_ccm', $aircraftType->min_ccm, ['class'=>'form-control input-sm', 'id'=>'min_ccm']) !!}
                            </div>

                            <label class="control-label col-sm-2">@lang("content.policy")</label>
                            <div class="col-sm-1">
                                {!! Form::text('policy_ccm', $aircraftType->policy_ccm, ['class'=>'form-control input-sm', 'id'=>'policy_ccm']) !!}
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-primary">@lang("content.save_changes")</button>
                                <a href="{{ route("homepage")."#". url("aircraft/types") }}" class="btn btn-default">@lang("content.back")</a>
                                {!! Form::hidden("id", $aircraftType->id) !!}
                            </div>
                        </div>
                    {!! Form::close() !!}
                </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    pagefunction();

</script>
