<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div>

                @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => "Edit '".$part->part_number."'' part of aircraft:".$aircraft->name])

                {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal']) !!}
                    <div class="row">
                        <div class="col-sm-5">
                            @if ($errors->all())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                    <li>{!! $error !!}</li>
                                    @endforeach
                                </ul>
                            </div>
                            @endif

                            <div class="form-group">
                                <label class="control-label col-sm-6">@lang("content.type")</label>
                                <div class="col-sm-6">
                                    {!! Form::select('part_type', $types, $part->part_type, ['class'=>'form-control input-sm', 'id'=>'part_type']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">Part Number</label>
                                <div class="col-sm-6">
                                    {!! Form::text('part_number', $part->part_number, ['class'=>'form-control input-sm', 'id'=>'part_number']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">Serial Number</label>
                                <div class="col-sm-6">
                                    {!! Form::text('serial_number', $part->serial_number, ['class'=>'form-control input-sm', 'id'=>'serial_number']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">@lang("content.type") Model</label>
                                <div class="col-sm-6">
                                    {!! Form::text('type_model', $part->type_model, ['class'=>'form-control input-sm', 'id'=>'type_model']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">@lang("content.position")</label>
                                <div class="col-sm-6">
                                    {!! Form::select('position', $positions, $part->position, ['class'=>'form-control input-sm', 'id'=>'position']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">TSN</label>
                                <div class="col-sm-6">
                                    {!! Form::text('tsn', $part->tsn, ['class'=>'form-control input-sm', 'id'=>'tsn']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">CSN</label>
                                <div class="col-sm-6">
                                    {!! Form::text('csn', $part->csn, ['class' => 'form-control input-sm', 'id' => 'csn']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group">
                                <label class="control-label col-sm-6">Installation Date</label>
                                <div class="col-sm-6">
                                    {!! Form::text('installation_date', $part->installation_date, ['class'=>'form-control input-sm datepicker', 'id'=>'installation_date']) !!}
                                </div>
                            </div>
                             <div class="form-group">
                                <label class="control-label col-sm-6">TSLSV</label>
                                <div class="col-sm-6">
                                    {!! Form::text('tslsv', $part->tslsv, ['class'=>'form-control input-sm', 'id'=>'tslsv']) !!}
                                </div>
                            </div>
                             <div class="form-group">
                                <label class="control-label col-sm-6">CSLSV</label>
                                <div class="col-sm-6">
                                    {!! Form::text('cslsv', $part->cslsv, ['class'=>'form-control input-sm', 'id'=>'cslsv']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">Thrust Category</label>
                                <div class="col-sm-6">
                                    {!! Form::text('thrust_category', $part->thrust_category, ['class'=>'form-control input-sm', 'id'=>'thrust_category']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">First LLP remaining FC</label>
                                <div class="col-sm-6">
                                    {!! Form::text('first_llp_remaining_fc', $part->first_llp_remaining_fc, ['class'=>'form-control input-sm', 'id'=>'first_llp_remaining_fc']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">Last Overhaul Date</label>
                                <div class="col-sm-6">
                                    {!! Form::text('last_overhaul_date', $part->last_overhaul_date, ['class'=>'form-control input-sm datepicker', 'id'=>'last_overhaul_date']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-6">Next Overhaul Date</label>
                                <div class="col-sm-6">
                                    {!! Form::text('next_overhaul_date', $part->next_overhaul_date, ['class'=>'form-control input-sm datepicker', 'id'=>'next_overhaul_date']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr/>
                    <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                            <input type="hidden" name="aircraft_id" value="{{ $aircraft->id }}" id="aircraft_id"/>
                            <input type="hidden" name="part_id" value="{!! $part->id !!}" id="part_id"/>
                            <button type="submit" class="btn btn-primary">Update</button>
                            {!! Form::hidden('id', $aircraft->id) !!}
                            <a href="{!! route("homepage")."#". url("aircraft/{$aircraft->id}/edit?s=".rand(100, 999)) !!}" class="btn btn-default">@lang("content.back")</a>
                        </div>
                    </div>
                {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>

<link rel="stylesheet" href="{{ asset("assets/css/jquery.datetimepicker.css") }}"/>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("/assets/js/vendor/jquery.datetimepicker.js") }}", function(){
        loadScript("{{ asset("/assets/js/views/aircraft/add-part.js") }}", pagefunction);
    });

</script>
