<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>


        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-8 col-lg-8">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.add_aircraft")])

            <div>

            {!! Form::open(['method' => "POST", 'class' => 'form-horizontal', 'id' => 'formSearch']) !!}

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.name")</label>
                    <div class="col-sm-6">
                        {!! Form::text('name', null, ['class'=>'form-control', 'placeholder'=>'Name', 'id'=>'name']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.type")</label>
                    <div class="col-sm-6">
                        {!! Form::select('aircraft_type_id', $types, null, ['class'=>'form-control', 'id'=>'type_id']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.airline")</label>
                    <div class="col-sm-6">
                        @if (isset($airlineId) && $airlineId)
                            {!! Form::hidden('current_airline_id', $airlineId) !!}
                            {!! Form::hidden('airline_id', $airlineId) !!}
                            {!! Form::select('airline_id', $airlines, null, ['class'=>'form-control input-sm', 'id'=>'type_id', "disabled"]) !!}
                        @else
                            {!! Form::select('airline_id', $airlines, null, ['class'=>'form-control input-sm', 'id'=>'type_id']) !!}
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.engine")</label>
                    <div class="col-sm-6">
                        {!! Form::select('engine_id', $engines, null, ['class'=>'form-control input-sm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.construction_number"), MSN</label>
                    <div class="col-sm-6">
                        {!! Form::text('msn', null, ['class'=>'form-control input-sm', 'id'=>'msn']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.line_number")</label>
                    <div class="col-sm-6">
                        {!! Form::text('line_number', null, ['class'=>'form-control input-sm', 'id'=>'line_number']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.first_flight")</label>
                    <div class="col-sm-6">
                        {!! Form::text('first_flight', null, ['class'=>'form-control datepicker input-sm', 'id'=>'first_flight']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.airframe_status")</label>
                    <div class="col-sm-6">
                        {!! Form::select('airframe_status', ["0" => "Inactive", "1" => "Active"], null, ['class'=>'form-control input-sm', 'id'=>'airframe_status']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.config") - C</label>
                    <div class="col-sm-6">
                        {!! Form::text('config_c', null, ['class'=>'form-control', 'id'=>'config_c']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.config") - Y</label>
                    <div class="col-sm-6">
                        {!! Form::text('config_y', null, ['class'=>'form-control', 'id'=>'config_y']) !!}
                    </div>
                </div>
                <hr/>
                <div class="form-group">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-primary">@lang("content.add")</button>
                        <a href="{{ route("homepage")."#".url("aircraft") }}" class="btn btn-default">@lang("content.back")</a>
                    </div>
                </div>
            {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>



<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    };

    pagefunction();

</script>
