<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
?>
<?php require_once(public_path("smart/inc/init.php")); ?>


        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => 'Add New Aircraft Type'])

            <div>
                {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'id' => 'formAdd']) !!}
                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">@lang("content.name")</label>

                    <div class="col-sm-6">
                        {!! Form::text('name', null, ['class'=>'form-control', 'placeholder'=>'Name', 'id'=>'name', 'required' => 'required']) !!}
                        <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.airline")</label>

                    <div class="col-sm-6">
                        {!! Form::select('airline_id', $airlines, $airlineID, ['class'=>'form-control input-sm', 'required']) !!}
                    </div>
                </div>

                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">IATA</label>

                    <div class="col-sm-6">
                        {!! Form::text('iata_name', null, ['class'=>'form-control', 'placeholder'=>'Name', 'id'=>'name', 'required']) !!}
                        <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                    </div>
                </div>
                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">ICAO</label>

                    <div class="col-sm-6">
                        {!! Form::text('icao',null, ['class'=>'form-control', 'placeholder'=>'ICAO', 'required']) !!}
                        <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                    </div>
                </div>

                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">@lang("content.wake_category")</label>

                    <div class="col-sm-6">
                        {!! Form::text('wake_category', null, ['class'=>'form-control', 'placeholder'=>'Wake Category']) !!}
                    </div>
                </div>

                <div class="form-group has-feedback">
                    <label class="control-label col-sm-3">@lang("content.details")</label>

                    <div class="col-sm-6">
                        {!! Form::text('details', null, ['class'=>'form-control', 'placeholder'=>'Details', 'id'=>'details']) !!}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.minimum_flight_crew_requirement")</label>

                    <div class="col-sm-6">
                        {!! Form::text('min_fcm', null, ['class'=>'form-control input-sm', 'id'=>'min_fcm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.flight_crew_policy")</label>

                    <div class="col-sm-6">
                        {!! Form::text('policy_fcm', null, ['class'=>'form-control input-sm', 'id'=>'policy_fcm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.minimum_cabin_crew_requirement")</label>

                    <div class="col-sm-6">
                        {!! Form::text('min_ccm', null, ['class'=>'form-control input-sm', 'id'=>'min_ccm']) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label col-sm-3">@lang("content.cabin_crew_policy")</label>

                    <div class="col-sm-6">
                        {!! Form::text('policy_ccm', null, ['class'=>'form-control input-sm', 'id'=>'policy_ccm']) !!}
                    </div>
                </div>
                <hr/>
                <div class="form-group">
                    <div class="col-sm-offset-3 col-sm-9">
                        {!! Form::hidden("current_airline_id", \request()->get("current_airline_id")) !!}
                        <button type="submit" class="btn btn-primary">@lang("content.add")</button>
                        <a href="{{ route("homepage")."#".url("aircraft/types") }}" class="btn btn-default">@lang("content.back")</a>
                    </div>
                </div>
                {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();
    };

    pagefunction();

</script>
