@if (isset($data[$index]) && count($data[$index]))
    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $index }}-widget-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="table-{{ $index }}" style="min-width: 100% !important;">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2">@lang("content.sector")</th>
                            <th rowspan="2">@lang("content.takeoffs")</th>
                            <th rowspan="2">@lang("content.landings")</th>
                            <th colspan="2" data-center>@lang("content.block_hours")</th>
                            <th data-center>@lang("content.flight_hours")</th>
                        </tr>
                        <tr>
                            <th data-center>@lang("content.planned")</th>
                            <th data-center>@lang("content.actual")</th>
                            <th data-center>@lang("content.actual")</th>
                        </tr>

                        </thead>

                        <tbody>

                        @php $j = 0 @endphp
                        @foreach($data[$index] as $each)

                            <tr>
                                <td>{{ ++$j }}</td>
                                <td>{{ $each['sector'] }}</td>
                                <td data-center>{{ $each['flights'] }}</td>
                                <td data-center>{{ $each['flights'] }}</td>
                                <td data-center>{!! !$each['planned'] ? "<span class='color-red'>".hoursToTime($each['planned'], true)."</span>" : hoursToTime($each['planned'], true) !!}</td>
                                <td data-center>{!! !$each['actual'] ? "<span class='color-red'>".hoursToTime($each['actual'], true)."</span>" : hoursToTime($each['actual'], true) !!}</td>
                                <td data-center>{!! !$each['flying'] ? "<span class='color-red'>".hoursToTime($each['flying'], true)."</span>" : hoursToTime($each['flying'], true) !!}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td></td>
                            <td><strong>@lang("content.total"):</strong></td>
                            <td data-center><strong>{{ $data['totalFlights'] }}</strong></td>
                            <td data-center><strong>{{ $data['totalFlights'] }}</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalPlanned'], true) }}</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalActual'], true) }}</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalFlying'], true) }}</strong></td>
                        </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>
@endif