@if (isset($data[$index]) && count($data[$index]))
    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $index }}-widget-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="table-{{ $index }}" style="min-width: 100% !important;">
                        <thead>
                        <tr>
                            <th rowspan="3">No</th>
                            <th rowspan="3">@lang("content.date")</th>
                            <th rowspan="3">@lang("content.flight")</th>
                            <th rowspan="3">@lang("content.sector")</th>
                            <th rowspan="3">@lang("content.ac_type")</th>
                            <th rowspan="3">@lang("content.ac")</th>

                            <th colspan="6" data-center>@lang("content.block_hours")</th>
                            <th colspan="3" data-center>@lang("content.flight_hours")</th>
                        </tr>
                        <tr>
                            <th colspan="3" data-center>@lang("content.planned")</th>
                            <th colspan="3" data-center>@lang("content.actual")</th>
                            <th colspan="3" data-center>@lang("content.actual")</th>
                        </tr>
                        <tr>
                            <th data-center>STD</th>
                            <th data-center>STA</th>
                            <th data-center>@lang("content.hours")</th>

                            <th data-center>ATD</th>
                            <th data-center>ATA</th>
                            <th data-center>@lang("content.hours")</th>

                            <th data-center>ABN</th>
                            <th data-center>TDN</th>
                            <th data-center>@lang("content.hours")</th>
                        </tr>

                        </thead>

                        <tbody>

                        @php $j = 0 @endphp


                        @foreach($data[$index] as $each)
                            @php $flight = $each['flight'] @endphp
                            <tr>
                                <td>{{ ++$j }}</td>
                                <td>{{ getFlightDepartureInitialDate($flight, true) }}</td>
                                <td><a target="_blank" href="{{ url("flight-tracker/{$flight->id}") }}">{{ getFlightNumber($flight) }}</a></td>
                                <td>{{ getFlightSector($flight) }}</td>

                                @php $aircraftType = getFlightAircraftType($flight, true) @endphp
                                @if ($aircraftType)
                                    <td><a target="_blank" href="{{ route("homepage")."#".url("aircraft/type/{$aircraftType->id}") }}">{{ getAircraftType($aircraftType) }}</a></td>
                                @else
                                    <td>{{ getFlightAircraftType($flight) }}</td>
                                @endif

                                @php $aircraft = getFlightAircraft($flight, true) @endphp
                                @if ($aircraft)
                                    <td><a target="_blank" href="{{ route("homepage")."#".url("aircraft/{$aircraft->id}/edit") }}">{{ getAircraft($aircraft) }}</a></td>
                                @else
                                    <td>{{ getAircraft($aircraft) }}</td>
                                @endif

                                <td data-center>{!! $each['initialDep'] ? baseTimeFormat($each['initialDep']) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! $each['initialArr'] ? baseTimeFormat($each['initialArr']) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! !$each['planned'] ? "<span class='color-red'>".hoursToTime($each['planned'], true)."</span>" : hoursToTime($each['planned'], true) !!}</td>

                                <td data-center>{!! $flight->atd ? baseTimeFormat($flight->atd) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! $flight->ata ? baseTimeFormat($flight->ata) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! !$each['actual'] ? "<span class='color-red'>".hoursToTime($each['actual'], true)."</span>" : hoursToTime($each['actual'], true) !!}</td>

                                <td data-center>{!! $flight->abn ? baseTimeFormat($flight->abn) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! $flight->tdn ? baseTimeFormat($flight->tdn) : "<span class='color-red'>-</span>" !!}</td>
                                <td data-center>{!! !$each['flying'] ? "<span class='color-red'>".hoursToTime($each['flying'], true)."</span>" : hoursToTime($each['flying'], true) !!}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>

                            <td></td>
                            <td><strong>@lang("content.total"):</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalPlanned'], true) }}</strong></td>

                            <td></td>
                            <td><strong>@lang("content.total"):</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalActual'], true) }}</strong></td>

                            <td></td>
                            <td><strong>@lang("content.total"):</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalFlying'], true) }}</strong></td>
                        </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>
@endif