@if (isset($data[$index]) && count($data[$index]))
    <div class="jarviswidget jarviswidget-color-blueDark" id="{{ $index }}-widget-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        <header>
            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
            <h2>@lang("content.list")</h2>
        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding" style="min-height: 50px !important;">

                <div class="table-responsive">

                    <table class="table table-bordered table-hover" id="table-{{ $index }}" style="min-width: 100% !important;">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2">@lang("content.ac_registration")</th>
                            <th colspan="2" data-center>@lang("content.cycles")</th>
                            <th colspan="2" data-center>@lang("content.ratio")</th>
                            <th colspan="2" data-center>@lang("content.block_hours")</th>
                            <th colspan="1" data-center>@lang("content.flight_hours")</th>
                        </tr>
                        <tr>
                            <th data-center>@lang("content.planned")</th>
                            <th data-center>@lang("content.actual")</th>

                            <th data-center>@lang("content.planned")</th>
                            <th data-center>@lang("content.actual")</th>

                            <th data-center>@lang("content.planned")</th>
                            <th data-center>@lang("content.actual")</th>

                            <th data-center>@lang("content.actual")</th>
                        </tr>


                        </thead>

                        <tbody>

                        @php $actualCycles = $j = 0 @endphp
                        @foreach($data[$index] as $each)

                            <tr>
                                <td>{{ ++$j }}</td>
                                @if ($each['aircraft'])
                                    <td><a target="_blank" href="{{ route("homepage")."#".url("aircraft/{$each['aircraft']->id}/edit") }}">{{ getAircraft($each['aircraft']) }}</a></td>
                                @else
                                    <td>{{ getAircraft($each['aircraft']) }}</td>
                                @endif

                                @php $cycles = $each['flights'] @endphp
                                @php $pRatio = $cycles != 0 ? $each['planned'] / $cycles : 0 @endphp
                                <td data-center>{{ $cycles }}</td>

                                @php $aRatio = 0 @endphp
                                @php $aCycles = $each['actualFlights'] @endphp

                                @if ($aCycles)
                                    @php $aRatio = $cycles != 0 ? $each['actual'] / $aCycles : 0 @endphp
                                @endif
                                <td data-center>{{ $aCycles }}</td>

                                <td data-center>{{ round($pRatio, 2) }}</td>
                                <td data-center>{{ round($aRatio, 2) }}</td>

                                <td data-center>{!! !$each['planned'] ? "<span class='color-red'>".hoursToTime($each['planned'], true)."</span>" : hoursToTime($each['planned'], true) !!}</td>
                                <td data-center>{!! !$each['actual'] ? "<span class='color-red'>".hoursToTime($each['actual'], true)."</span>" : hoursToTime($each['actual'], true) !!}</td>

                                <td data-center>{!! !$each['flying'] ? "<span class='color-red'>".hoursToTime($each['flying'], true)."</span>" : hoursToTime($each['flying'], true) !!}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td></td>
                            <td><strong>@lang("content.total"):</strong></td>
                            @php $cycles = $data['totalFlights'] @endphp
                            @php $aCycles = $data['totalActualFlights'] @endphp
                            <td data-center><strong>{{ $cycles }}</strong></td>
                            <td data-center><strong>{{ $aCycles }}</strong></td>

                            @php $pRatio = $cycles != 0 ? $data['totalPlanned'] / $cycles : 0 @endphp
                            @php $aRatio = $aCycles != 0 ? $data['totalActual'] / $aCycles : 0 @endphp
                            <td data-center>{{ round($pRatio, 2) }}</td>
                            <td data-center>{{ round($aRatio, 2) }}</td>

                            <td data-center><strong>{{ hoursToTime($data['totalPlanned'], true) }}</strong></td>
                            <td data-center><strong>{{ hoursToTime($data['totalActual'], true) }}</strong></td>

                            <td data-center><strong>{{ hoursToTime($data['totalFlying'], true) }}</strong></td>
                        </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>
@endif