<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            @include('aircraft-utilization.layouts.index-form')
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#flights" role="tab" data-toggle="tab">@lang("content.flight_data")</a>
                </li>
                <li class="">
                    <a href="#ac_types" role="tab" data-toggle="tab">@lang("content.ac_types")</a>
                </li>
                <li class="">
                    <a href="#ac" role="tab" data-toggle="tab">@lang("content.ac_registration")</a>
                </li>
                <li class="">
                    <a href="#sectors" role="tab" data-toggle="tab">@lang("content.sectors")</a>
                </li>
                <li class="">
                    <a href="#flight_numbers" role="tab" data-toggle="tab">@lang("content.flight_numbers")</a>
                </li>
            </ul>

            @php $active = 0 @endphp
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="flights">
                    @include("aircraft-utilization.layouts.index-flights-tab", ["index" => "flights"])
                </div>
                <div class="tab-pane" id="ac_types">
                    @include("aircraft-utilization.layouts.index-ac-type-tab", ["index" => "acTypes"])
                </div>
                <div class="tab-pane " id="ac">
                    @include("aircraft-utilization.layouts.index-ac-tab", ["index" => "aircraft"])
                </div>
                <div class="tab-pane " id="sectors">
                    @include("aircraft-utilization.layouts.index-sectors-tab", ["index" => "sectors"])
                </div>
                <div class="tab-pane" id="flight_numbers">
                    @include("aircraft-utilization.layouts.index-flight-numbers-tab", ["index" => "flightNumbers"])
                </div>


            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        @if (ghaModule())
            ApplyOperationsFormFilter({!! json_encode($flightNumbers) !!}, {!! json_encode(\request("flightNumber")) !!}, {!! json_encode($sectors) !!}, {!! json_encode($sectorsByAirlines) !!}, {!! json_encode(\request("sector")) !!});
        @endif

        @foreach($data as $index => $each)
            ApplyTableFilter("#table-{{ $index }}");
        @endforeach
    };

    pagefunction();

</script>
