<?php require_once(public_path("smart/inc/init.php")); ?>

<link rel="stylesheet" href="{{ asset("/assets/css/editable.css") }}" />

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Commercial', 'moduleName' => 'Agency'])

            <div class="col-md-4">
                <div class="panel panel-primary" style="">
                    <div class="panel-heading" style="position: relative;overflow:hidden; ">
                        <h3 class="panel-title">
                            <span style="float: left">{{ $agency->agency }}</span>
                            <span style="float: right; font-weight: bold">{{ $agency->city_id ? $agency->city->city : '' }}</span>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div style="width: 100%; margin: 0 auto;">
                            {{--Upload Photo Form--}}
                            <div class="col-lg-6">
                                @include('forms/general/upload-picture', ['postUrl' => url("agency/upload-photo/{$agency->id}")])
                            </div>

                            <div class="tabbable" style="float: none; clear: both; height: 400px"> <!-- Only required for left/right tabs -->
                                <ul class="nav nav-tabs">
                                    <li class="active"><a href="#tab1" data-toggle="tab">@lang("content.general")</a></li>
                                    {{--<li><a href="#tab2" data-toggle="tab">Info</a></li>--}}
                                </ul>
                                <div class="tab-content">
                                    {{-- General Tab --}}
                                    @include('agency.edit.general-tab')
                                    {{--<div class="tab-pane" id="tab2" style="padding: 10px 0;overflow: auto; height: 380px"></div>--}}
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-8">
                <div class="panel panel-primary" style="height: 750px">
                    <div class="panel-heading">
                        <h3 class="panel-title">@lang("content.flights")</h3>
                    </div>
                    <div class="panel-body" style="height: 650px">
                        <div class="col-xs-12" style="margin-bottom: 10px;">
                            @include('forms/passenger/flightSearch')
                        </div>
                        <div class="alert alert-success" style="clear:both; display: block; height: 50px">
                            @if (\request("dateFrom") || \request("dateTo"))
                                <h5 class="info-regular">{{ 'From: '.baseDateFormat(\request("dateFrom")).(\request("dateTo") ? ' To: '.baseDateFormat(\request("dateTo")) : '') }}</h5>
                            @else
                            <h5 class="info-regular">Last ~20 Sales.</h5>
                            @endif
                        </div>
                        <div class="col-xs-12 tab-content" style="height: 550px; overflow: auto;">
                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>@lang("content.sales_date")</th>
                                    <th>@lang("content.flight_number")</th>
                                    <th>@lang("content.sector")</th>
                                    <th>@lang("content.departure")</th>
                                    <th>@lang("content.ticket_number")</th>
                                    <th>@lang("content.coupon")</th>
                                    <th>@lang("content.status")</th>
                                    <th>@lang("content.fare_basis")</th>
                                    <th>@lang("content.fare")</th>
                                </tr>
                                </thead>
                                <tbody>
                                @php $fareSum = 0 @endphp
                                @php $j = 1 @endphp
                                @foreach($passengerOrders as $order)
                                    @php $passengerFlights = $order->passengerFlight @endphp
                                    @foreach($passengerFlights as $i => $each)
                                        @php $departure = $each->flight ? $each->flight->std : $each->departure @endphp
                                        @if (\request("dateFrom") && strtotime($departure) < strtotime(\request("dateFrom")))
                                            @continue
                                        @endif
                                        @if (\request("dateTo") && strtotime($departure) > strtotime(\request("dateTo")))
                                            @continue
                                        @endif
                                        <tr>
                                            <td>{{ $j++ }}</td>
                                            <td>{{ baseDateFormat($each->passengerOrder->sales_date) }}</td>
                                            @if ($each->flight)
                                                <td><a target="_blank" href="{{ route("homepage")."#". url("flight/details")."?id={$each->flight_id}" }}">{{ $each->flightNumber ? $each->flightNumber->flight_number_iata : ''}}</a></td>
                                            @else
                                                <td>{{ $each->flightNumber ? $each->flightNumber->flight_number_iata : ''}}</td>
                                            @endif
                                            <td>{{ $each->flightNumber ? $each->flightNumber->flight_sector : '' }}</td>
                                            <td>{{ baseDateFormat($departure, true) }}</td>
                                            <td><a target='_blank' href='{{ route("homepage")."#". url('revenue-data/ticket-number').'/'. $each->passengerOrder->ticket_number}}'>{{ $each->passengerOrder->ticket_number }}</a></td>
                                            <td>{{ $each->coupon }}</td>
                                            <td>{{ $each->flightOrderStatus ? $each->flightOrderStatus->order_status : '' }}</td>
                                            <td>{{ $each->flightFareBasis   ? $each->flightFareBasis->fare_basis : '' }}</td>
                                            <td>{{ $each->fare ? '$'.number_format($each->fare) : '' }}</td>
                                            @php $fareSum += ($each->fare ? $each->fare : 0) @endphp
                                        </tr>
                                    @endforeach
                                @endforeach
                                <tr class="headerRow">
                                    <td class="text-center" colspan="9">@lang("content.total")</td>
                                    <td>$ {{ number_format($fareSum) }}</td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    pagefunction();

</script>