<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-lg-7 col-lg-offset-1">

                {!! Form::open(['method' => 'POST', 'class' => "form-horizontal", 'url' => url("agency")]) !!}

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.name")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('agency', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => trans("content.name")]) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>


                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.country")</label>
                        <div class="col-sm-9">
                            {!! Form::select('country_id', $countries, null, ['class' => 'form-control', 'id' => 'country']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.city")</label>
                        <div class="col-sm-9">
                            {!! Form::select('city_id', [], null, ['class' => 'form-control', 'id' => 'city']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.sales_channel")</label>
                        <div class="col-sm-9">
                            {!! Form::select('sales_channel_id', $salesChannels, null, ['class' => 'form-control', 'id' => 'sales_channel_id']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.email")</label>
                        <div class="col-sm-9">
                            {!! Form::email('email', null, ['class' => 'form-control', 'placeholder' => trans("content.email")]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.website")</label>
                        <div class="col-sm-9">
                            {!! Form::text('website', null, ['class' => 'form-control', 'placeholder' => trans("content.website")]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.phone")</label>
                        <div class="col-sm-9">
                            {!! Form::text('phone', null, ['class' => 'form-control', 'placeholder' => trans("content.phone")]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.mobile")</label>
                        <div class="col-sm-9">
                            {!! Form::text('mobile', null, ['class' => 'form-control', 'placeholder' => trans("content.mobile")]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.address")</label>
                        <div class="col-sm-9">
                            {!! Form::text('address', null, ['class' => 'form-control', 'placeholder' => trans("content.address")]) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                            <button type="submit" class="btn btn-primary">@lang("content.add")</button>
                        </div>
                    </div>

                {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        ApplyOperationsFormCountryFilter({!! json_encode($citiesByCountry) !!}, false, {!! json_encode(\request("country")) !!}, {!! json_encode(\request("city")) !!});

    };

    pagefunction();

</script>
