<div class="col-md-12 no-padding margin-bottom-10">
    <a href="{{ route("homepage")."#".url('agency') }}" class="btn btn-success">@lang("content.agencies")</a>
    <a href="{{ route("homepage")."#".url('agency-code/add') }}" class="btn btn-primary">@lang("content.add")</a>
</div>

<div class="clearfix"></div>

<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-aircraft" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>

        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.list")</h2>


    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding">

            <div class="table-responsive">

                {!! Form::open(["method" => "GET", "url" => 'agency-code/link', "class" => "form-inline"]) !!}

                <div class="col-sm-12 padding-10">
                    <label>
                        Link to agency
                        {!! Form::select("agency", $agenciesByCountry, null, ["class" => "form-control"]) !!}
                    </label>
                    {!! Form::submit("Submit", ["class" => "btn btn-success"]) !!}
                </div>

                <table class="table table-bordered table-hover" id="agencyTable" style="min-width: 100% !important;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>@lang("content.select")</th>
                            <th>@lang("content.tech_address")</th>
                            <th>@lang("content.code")</th>
                            <th>TCH @lang("content.code")</th>
                            <th>@lang("content.agency")</th>
                            <th>@lang("content.city")</th>
                            <th>@lang("content.country")</th>
                            <th>@lang("content.actions")</th>
                        </tr>
                    </thead>

                    <tbody>
                    {{-- @foreach($agencyCodes['pagination'] as $j => $each)--}}
                    @foreach($agencyCodes as $j => $each)
                        {{-- @if ($j >= ($currentPage - 1) * $perPage && $j < ($currentPage - 1) * $perPage + $perPage)--}}
                            <tr>
                                <td>{{ $j + 1 }}</td>
                                <td>{!! Form::checkbox("code[]", $each->id, null) !!}</td>
                                <td>{{ $each->tap }}</td>
                                <td>{{ $each->code }}</td>
                                <td>{{ $each->tch_code }}</td>
                                <td>{{ $each->agency    ? $each->agency->agency : "" }}</td>
                                <td>{{ getAgencyCodeCity($each) }}</td>
                                <td>{{ getAgencyCodeCountry($each) }}</td>
                                <td><a target="_blank" href="{{ route("homepage") ."#agency-code/{$each->id}/edit" }}" class="btn btn-warning">@lang("content.edit")</a></td>
                            </tr>
                        {{--@endif--}}
                    @endforeach
                    {{--@endforeach--}}
                    </tbody>
                </table>

                {!! Form::close() !!}

            </div>

        </div>

    </div>

{{--@include('general.pager')--}}

{{--{!! $agencyCodes['pagination']->appends(request()->all())->render() !!}--}}

</div>
