<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-lg-7 col-lg-offset-1">

                {!! Form::open(['method' => 'POST', 'class' => "form-horizontal", 'url' => url("agency-code")]) !!}

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.tech_address")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('tap', null, ['class' => 'form-control', 'placeholder' => trans("content.code"), 'id' => 'code']) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.code")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('code', null, ['class' => 'form-control', 'placeholder' => trans("content.code"), 'id' => 'code']) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red">@lang("content.tch_code")*</label>
                        <div class="col-sm-9">
                            {!! Form::text('tch_code', null, ['class' => 'form-control', 'placeholder' => trans("content.tch_code"), 'id' => 'tch_code']) !!}
                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.country")</label>
                        <div class="col-sm-9">
                            {!! Form::select('country_id', $countries, null, ['class' => 'form-control', 'id' => 'country']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.city")</label>
                        <div class="col-sm-9">
                            {!! Form::select('city_id', [], null, ['class' => 'form-control', 'id' => 'city']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3">@lang("content.agency")</label>
                        <div class="col-sm-9">
                            {!! Form::select('agency_id', [], null, ['class' => 'form-control', 'id' => 'agency']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                            <button id="save_changes" type="submit" class="btn btn-success">@lang("content.add")</button>
                        </div>
                    </div>

                {!! Form::close() !!}

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    $("#save_changes").on("click", function(){

        var code = $("#code").val(), tchCode = $("#tch_code").val();

        if (code == "" && tchCode == ""){
            if (code == ""){
                code.focus();
            }
            else {
                tchCode.focus();
            }

            return false;
        }

        return true;
    });

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

        ApplyOperationsFormCountryFilter({!! json_encode($citiesByCountry) !!}, {!! json_encode($agenciesByCountry) !!});

    };

    pagefunction();

</script>
