<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            {!! Form::open(['method' => 'GET', 'class' => 'form-inline formUsers', 'id' => 'formSearch']) !!}

                <div class="form-group marginBottomRight">
                    {!! Form::label('name', trans("content.first_name"), ['class' => 'control-label']) !!}
                    {!! Form::input('text', 'first_name', \request("first_name"), ['class' => 'form-control']) !!}
                </div>
                <div class="form-group marginBottomRight">
                    {!! Form::label('name', trans("content.last_name"), ['class' => 'control-label']) !!}
                    {!! Form::input('text', 'last_name', \request("last_name"), ['class' => 'form-control']) !!}
                </div>
                <div class="form-group marginBottomRight">
                    {!! Form::label('department', trans("content.department"), ['class' => 'control-label']) !!}
                    {!! Form::select('department', $departments, \request("department"), ['class' => 'form-control']) !!}
                </div>

                @if (in_array(Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                    <div class="form-group marginBottomRight">
                        {!! Form::label('status', trans("content.status"), ['class' => 'control-label']) !!}
                        {!! Form::select('status', $statuses, \request("status") ? \request("status") : ACTIVATED, ['class' => 'form-control']) !!}
                    </div>

                    <div class="form-group marginBottomRight">
                        {!! Form::label('privilege', trans("content.privilege"), ['class' => 'control-label']) !!}
                        {!! Form::select('privilege', ['' => "All"] + $roles, \request("privilege"), ['class' => 'form-control']) !!}
                    </div>
                @endif

                <div class="form-group marginBottomRight">
                    {!! Form::submit(trans("content.search"), ['name' => 'search', 'class' => 'btn btn-primary']) !!}
                    <a class="btn btn-success add" href = "{{ route("homepage")."#". url("staff/create?s=".rand(100, 999)) }}">{{  trans("content.add_new_staff") }}</a>
                    <input type="hidden" id="tokenInput" name="_token" value="{{ csrf_token() }}">
                </div>

            {!!Form::close()!!}

            <div class="clearfix"></div>

            @if (count($users))
                <div class="col-sm-12 data margin-top-10">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-staff-list" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>@lang("content.list")</h2>
                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="min-height: 50px !important;">


                                <div class="table-responsive">

                                    <table class="table table-bordered table-striped table-hover" id="users-table">
                                        <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>@lang("content.picture")</th>
                                            <th>@lang("content.first_name")</th>
                                            <th>@lang("content.last_name")</th>
                                            <th>@lang("content.email")</th>
                                            <th>@lang("content.base")</th>
                                            <th>@lang("content.position")</th>
                                            <th>@lang("content.department")</th>
                                            <th>@lang("content.status")</th>
                                            @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                                                <th style="min-width: 200px;">@lang("content.privilege")</th>
                                            @endif
                                            <th style="min-width: 400px;">@lang("content.actions")</th>
                                        </tr>
                                        </thead>

                                        <tbody>

                                        @forelse($users as $i => $each)
                                            {{--@if ($each->id == 44)--}}
                                                {{--@continue--}}
                                            {{--@endif--}}
                                            @php $picture = !is_null($each->thumb) ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png'; @endphp
                                            <tr data-user_id = {{ $each->id  }}>
                                                <td>{{ $i + 1 }}</td>
                                                <td><a target="_blank" href="{{ route("homepage")."#".url("/staff/$each->id/edit?s=".rand(100, 999)) }}" ><img src="{{ $picture }}" width="100" class="img-thumbnail thumb_report_prev"  /></a></td>
                                                <td><a target="_blank" href="{{ route("homepage")."#".url("/staff/$each->id/edit?s=".rand(100, 999)) }}" >{{ $each->first_name }}</a></td>
                                                <td><a target="_blank" href="{{ route("homepage")."#".url("/staff/$each->id/edit?s=".rand(100, 999)) }}" >{{ $each->last_name }}</a></td>
                                                <td>{{ $each->email }}</td>
                                                <td>{{ $each->location && $each->location->airport ? $each->location->airport->iata : "" }}</td>
                                                <td>{{ $each->position_title }}</td>
                                                <td>{{ $each->department_name }}</td>
                                                @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                                                    @if (is_null($each->deleted_at))
                                                        <td>{!! $each->activated ? '<span class="activated">Activated</span>' : '<span class="deactivated">Deactivated</span>' !!}</td>
                                                    @else
                                                        <td><span class="deleted">@lang("content.deleted")</span></td>
                                                    @endif

                                                    <td>
                                                        {!! Form::open(['method' => 'GET', 'class' => 'form-inline formUsers']) !!}
                                                            {!! Form::hidden('department', \request("department")) !!}
                                                            {!! Form::hidden('search', \request("search")) !!}
                                                            {!! Form::hidden("user_id", $each->id) !!}
                                                            <select name="role_id" class="form-control input-sm floatOnly" style ="width: 130px; margin-right: 5px;">
                                                                @foreach($roles as $key => $value)
                                                                    <option value="{{ $key }}" {!! $each->user_role_id == $key ? "selected" : "" !!}>{{ $value }}</option>
                                                                @endforeach
                                                            </select>
{{--                                                            {!! Form::select("role_id", $roles, $each->user_role_id, ["class" => "form-control input-sm floatOnly", "style" => "width: 130px; margin-right: 5px;" ]) !!}--}}
                                                            {!! Form::submit( trans("content.save"),["name" => "Role", "class" => "btn btn-primary btn-sm floatOnly" ]) !!}
                                                        {!! Form::close() !!}
                                                    </td>

                                                @else
                                                    <td>{!! $each->activated ? '<span class="activated">Activated</span>' : '<span class="deactivated">Deactivated</span>' !!}</td>
                                                @endif
                                                <td class="activation_deletion">
                                                    <div class="btn-group" style="min-width: 320px">
                                                        @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
                                                            @if ($each->deleted_at)
                                                                <a class="btn btn-warning btn-sm remove" data-title="Restore User">{{  trans("content.restore") }}</a>
                                                            @else
                                                                {{--<a href="{{ route("homepage")."#".url("user/{$each->id}") }}" class="btn btn-success btn-sm edit">View</a>--}}
                                                                <a target="_blank" href="{{ route("homepage")."#".url("/staff/$each->id/edit?s=".rand(100, 999)) }}" class="btn btn-primary btn-sm edit">@lang("content.edit")</a>
                                                                <a class="btn btn-danger btn-sm remove" data-title="Delete User">@lang("content.delete")</a>
                                                                {!! $each->activated ? '<a class="btn btn-info btn-sm activation">'.trans("content.deactivate").'</a>' : '<a class="btn btn-warning btn-sm activation">'.trans("content.activate").'</a>' !!}
                                                            @endif

                                                            @if (in_array(\Auth::user()->user_role_id, [ROLE_SUPER_ADMIN]))
                                                                <a class="btn btn-success btn-sm remove" data-title="Permanent Deletion">{{  trans("content.permanent_deletion") }}</a>
                                                            @endif

                                                        @else
                                                            {{--<a href="{{ route("homepage")."#".url("user/{$each->id}") }}" class="btn btn-success btn-sm edit">View</a>--}}
                                                            <a target="_blank" href="{{ route("homepage")."#".url("/user/$each->id/edit?s=".rand(100, 999)) }}" class="btn btn-primary btn-sm edit">@lang("content.edit")</a>
                                                            <a class="btn btn-danger btn-sm remove" data-title="Delete User">{{  trans("content.delete") }}</a>
                                                            {!! $each->activated ? '<a class="btn btn-info btn-sm activation">'.trans("content.deactivate").'</a>' : '<a class="btn btn-success btn-sm activation">'.trans("content.activate").'</a>' !!}
                                                        @endif
                                                        <a class="btn btn-primary btn-sm send-email">{{  trans("content.send_temp_password") }}</a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                        @endforelse
                                        </tbody>
                                    </table>

                                </div>
                            </div>

                            {{--{!! $users->appends($_GET)->render() !!}--}}

                        </div>
                    </div>

                </div>

                <div class="col-lg-12" style="height: 100px; margin-top: 10px;"></div>
            @endif

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#users-table");
    };

    loadScript("{{ asset("assets/js/views/admin/users.js?4") }}", pagefunction);

</script>


