<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('admin.form-search-users')

            @php $n = \request("page") ? (\request("page") - 1 ) * 10 + 1  : 1 @endphp

            @forelse($users as $i => $user)

                @php $picture = $user->picture ? '/storage/users/'.$user->picture : '/assets/img/default-user-picture.png' @endphp
                @php $userModules = $user->userModule->groupBy('module_id') @endphp
                @php $user_module_list = [] @endphp
                @php $userModules_all = [] @endphp
                @php $userModules_department = [] @endphp

                @if ($i == 0)
                <div class="panel-heading background_orange" style="height: 40px; margin: 10px 0 0 0">
                    <div class="col-sm-3">
                        <h4 class="panel-title">@lang("content.full_name")</h4>
                    </div>

                    <div class="col-sm-1">
                        <h4 class="panel-title">@lang("content.base")</h4>
                    </div>

                    <div class="col-sm-2">
                        <h4 class="panel-title">@lang("content.user_role")</h4>
                    </div>

                    <div class="col-sm-2">
                        <h4 class="panel-title">@lang("content.department")</h4>
                    </div>

                    <div class="col-sm-3">
                        <h4 class="panel-title">@lang("content.position")</h4>
                    </div>

                    <div class="col-sm-1">
                        <h4 class="panel-title">@lang("content.modules")</h4>
                    </div>
                </div>
                @endif

                @foreach($userModules as $k => $user_module)
                    @foreach($user_module as $j => $module)
                        @if (!$module || !$module->module)
                            @continue
                        @endif

                        @php $user_module_list[$module->module->id] = $module->module->name @endphp
                        @php $userModules_department[$module->module->department_id][$module->module->id] = $module->module->name @endphp
                    @endforeach
                @endforeach

                @if (isset($user_module_list))
                    @php $user_module_list = array_unique($user_module_list) @endphp
                @endif

                <div class="panel panel-primary" style="margin: 0; border: 0; border-bottom: 1px solid #028DBA">
                    <div class="accordion" id="accordion{{$user->id}}">
                        <div class="accordion-group">
                            <div class="accordion-heading">
                                <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion2" href="#collapse{{$user->id}}">
                                    <div class="panel-heading background_blue" style=" height: 40px; color: #ffffff; padding: 0; margin: 0">

                                        <div class="col-sm-3" style="height: 100%;">
                                            <h4 class="panel-list">
                                                {{ $n++ ." | ". $user->last_name." ".$user->first_name }}
                                            </h4>
                                        </div>

                                        <div class="col-sm-1">
                                            <h4 class="panel-list">
                                                {{ $user->location && $user->location->airport ? $user->location->airport->iata : "" }}
                                            </h4>
                                        </div>

                                        <div class="col-sm-2">
                                            <h4 class="panel-list">
                                                {{ $user->role ? $user->role->label : ""}}
                                            </h4>
                                        </div>


                                        <div class="col-sm-2">
                                            <h4 class="panel-list">
                                                {{ $user->department && isset($user->department[0]) ? str_limit($user->department[0]->name, 25) : "" }}
                                            </h4>
                                        </div>


                                        <div class="col-sm-3">
                                            <h4 class="panel-list">
                                                {{ $user->position && isset($user->position[0]) ? str_limit($user->position[0]->name, 25) : "" }}
                                            </h4>
                                        </div>

                                        <div class="col-sm-1">
                                            <h4 class="panel-list">
                                                <span class="badge"> {{ count($user_module_list) }}</span>
                                            </h4>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <div id="collapse{{$user->id}}" class="accordion-body collapse">
                                <div class="accordion-inner">
                                    <div class="panel-body">
                                        <div class="message_box"></div>
                                        <div class="col-lg-12 group0" data-user_id="{{ $user->id }}">

                                            {{--IMG--}}
                                            <div class="col-md-2">
                                                <a href="{{ route("homepage")."#".url("/staff/$user->id/edit?s=".rand(100, 999)) }}" target="_blank">
                                                    <img style="float: left; width: 100%" src="{{ $picture }}"/>
                                                </a>
                                            </div>

                                            {{--DEPARTMENT's LIST--}}

                                            {{--USER's ACTIVE MODULES LIST--}}
                                            <div class="list-group modules-show col-md-10" data-department_id="0" style="overflow: auto; max-height: 365px; margin-bottom: 0">
                                                <a class="list-group-item active" style="width: 100%;display: inline-block;">
                                                    <span class="badge">{{ $user->module ? count($user->module) : 0}}</span>
                                                    <span style="width:200px; display:block; float:left;">@lang("content.module")</span>
                                                    {{--<span>Department</span>--}}
                                                    <span style="float: right; margin-right: 20px;">@lang("content.total_permissions")</span>
                                                </a>

                                                @foreach($userModules as $k => $user_module)
                                                    @foreach($user_module as $j => $module)
                                                        @if ($module->module)
                                                            @if ($j == 0)
                                                                <a style="clear: both; line-height: 25px; height: {{count($user_module) > 6 ? '110px' : '70px' }}" class="list-group-item data_content">
                                                                   <span class="module" style="width:30%;display:block; float: left">
                                                                        <label>{!! Form::checkbox('user_module'.$user->id.'[]', 1, true, ['disabled' => 'disabled', 'data-module_id'=>$module->module->id, 'data-permission_count' => count($user_module)] )." ". trans("modules.{$module->module->lang}") !!}</label>
                                                                   </span>

                                                                   @php $permissions = $module->module->permission @endphp
                                                                   <span style="width: 65%; display: block; float: left">
                                                                   @foreach($permissions as $permission)
                                                                       @if (!$permission->deleted_at)
                                                                            @php $user_module_array[$user->id][$module->module->id][] = $permission->id @endphp
                                                                            @php $userModules_all[$permission->id] = $permission->name @endphp
                                                                            <span class="permission" style="float: right; margin-right: 20px;">
                                                                               <label>{!! Form::checkbox('user_permission'.$user->id.'[]', 1, true, ['disabled' => 'disabled', 'data-permission_id'=>$permission->id])." ".trans("content.".strtolower($permission->name)) !!}</label>
                                                                            </span>
                                                                       @endif
                                                                   @endforeach
                                                                   </span>
                                                                   <span style="width: 5%; display: block; float: left">
                                                                        <span class="badge">{{ count($user_module) }}</span>
                                                                   </span>
                                                                </a>
                                                            @endif
                                                        @endif
                                                    @endforeach
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @empty
                @if (\request("search") || \request("page"))
                    <div class="alert alert-dismissable alert-info">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong>No Matches Found!</strong> This Please Try Again.
                    </div>
                @endif
            @endforelse

            {!! count($users) ? $users->withPath(route("homepage")."#admin/users-modules")->appends($_GET)->render() : '' !!}

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{ asset("assets/js/views/user/users-modules.js") }}", pagefunction);

</script>



