{!! Form::open(['method' => 'GET', 'class' => 'form-inline', 'id' => 'formSearch']) !!}
    <div class="form-group marginBottomRight">
        {!! Form::label('name', trans("content.first_name"), ['class' => 'control-label']) !!}
        {!! Form::input('text', 'first_name', \request("first_name"), ['class' => 'form-control'])!!}
    </div>

    <div class="form-group marginBottomRight">
        {!! Form::label('name', trans("content.last_name"), ['class' => 'control-label']) !!}
        {!! Form::input('text', 'last_name', \request("last_name"), ['class' => 'form-control'])!!}
    </div>

    <div class="form-group marginBottomRight">
        {!! Form::label('department', trans("content.department"), ['class' => 'control-label']) !!}
        {!! Form::select('department', $departments, \request("department"), ['class' => 'form-control']) !!}
    </div>

    @if (in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN]))
        <div class="form-group marginBottomRight">
            {!! Form::label('privilege', trans("content.privilege"), ['class' => 'control-label']) !!}
            {!! Form::select('privilege', ['' => "All"] + $roles, \request("privilege"), ['class' => 'form-control']) !!}
        </div>
    @endif

    <div class="form-group">
        {!! Form::submit(trans("content.search"), ['name' => 'search', 'class' => 'btn btn-primary']) !!}
    </div>

{!! Form::close() !!}
