<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 19.08.14

 */

?>

<?php require_once(public_path("smart/inc/init.php")); ?>

<style type="text/css">
    div.form-inline .form-group {
        margin-left: 15px;
    }
</style>

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'Admin', 'moduleName' => trans("content.add_user")])

            <div>
                <div class="col-lg-6 col-lg-offset-1">
                    {!! Form::open(['method' => 'POST', 'class' => "form-horizontal"]) !!}
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.first_name")</label>
                            <div class="col-sm-9">
                                {!! Form::text('first_name', null, ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name', "required" => "required"]) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.last_name")</label>
                            <div class="col-sm-9">
                                {!! Form::text('last_name', null, ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name', "required" => "required"]) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.email")</label>
                            <div class="col-sm-9">
                                {!! Form::text('email', null, ['class'=>'form-control', 'placeholder'=>'Email', 'id'=>'email', "required" => "required"]) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.new") @lang("content.password")</label>
                            <div class="col-sm-9">
                                {!! Form::password('password', ['class'=>'form-control', 'id'=>'password', 'data-container'=>"body", 'data-toggle'=>"popover", 'data-placement'=>"right", 'data-content'=>"This Field Is Required"]) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.confirm") @lang("content.new") @lang("content.password")</label>
                            <div class="col-sm-9">
                                {!! Form::password('password_confirmation', ['class'=>'form-control', 'id'=>'password_confirmation', 'data-container'=>"body", 'data-toggle'=>"popover", 'data-placement'=>"right", 'data-content'=>"This Field Is Required"]) !!}
                            </div>
                        </div>
                        <div class="form-group has-feedback">
                            <label class="control-label col-sm-3">@lang("content.date_of_birth")</label>
                            <div class="col-sm-9">
                                {!! Form::text('dob', null, ['class'=>'form-control datepicker', 'placeholder'=>'YYYY-MM-DD', 'id'=>'dob']) !!}
                                <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.place_of_birth")</label>
                            <div class="col-sm-9">
                                {!! Form::select('birth_place', $placeOfBirth, null, ['class'=>'form-control ', 'id'=>'birth_place']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">@lang("content.department")</label>
                            <div class="col-sm-9">
                                {!! Form::select('department_id', $departments, null, ['class' => 'form-control', 'id' =>
                                'department_id', "required" => "required"]) !!}
                            </div>
                        </div>

                        <div class="form-group" id="subdepartment">
                            <label for="subdepartment_id" class="col-sm-3 control-label">@lang("content.subdepartment")</label>
                            <div class="col-sm-9">
                                {!! Form::select('subdepartment_id', $subDepartments,  null, ['class' => 'form-control','id'=>'subdepartment_id']) !!}
                            </div>
                        </div>
                        <div class="form-group" id="position">
                            <label for="position_id" class="col-sm-3 control-label">@lang("content.position")</label>
                            <div class="col-sm-9">
                                {!! Form::select('position_id', $positions, null, ['class' => 'form-control', 'id'=>'position_id'])!!}
                            </div>
                        </div>
                        <div class="form-group" id="other_position" style="display: none">
                             <label for="other_position_value" class="col-sm-3 control-label">@lang("content.other_position")</label>
                            <div class="col-sm-9">
                                {!! Form::text('other_position', null, array('class'=>'input-block-level form-control',
                                'placeholder'=>'Position', 'autocomplete' => 'off', 'id' => 'other_position_value')) !!}
                                <span class="help-block">Please specify your current position</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.contractor")</label>
                            <div class="col-sm-9">
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('is_contractor', 1, null, ['id'=>'is_contractor']) !!} @lang("content.yes_no")
                                </label>
                           </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.language")</label>
                            <div class="col-sm-9">
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('language[]', 'tajik', null, ['id'=>'language-tajik']) !!} Tajik
                                </label>
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('language[]', 'russian', null, ['id'=>'language-russian']) !!} Russian
                                </label>
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('language[]', 'english', null, ['id'=>'language-english']) !!} English
                                </label>
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('language[]', 'german', null, ['id'=>'language-german']) !!} German
                                </label>
                                <label class="checkbox-inline">
                                    {!! Form::checkbox('language[]', 'chinese', null, ['id'=>'language-chinese']) !!} Chinese
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.location")</label>
                            <div class="col-sm-9">
                                {!! Form::select('location',$location, null, ['class'=>'form-control', 'id'=>'location']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.nationality")</label>
                            <div class="col-sm-9">
                                {!! Form::select('nationality', $nationality, null, ['class'=>'form-control ', 'id'=>'nationality']) !!}
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.passport")</label>
                            <div class="col-sm-9">
                                <div class="form-inline">
                                    <div class="form-group">
                                        <label>No.</label>
                                        {!! Form::text('p_number', null, ['class'=>'form-control input-sm', 'id'=>'p_number']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label>@lang("content.issued")</label>
                                        {!! Form::text('p_issued_date', null, ['class'=>'form-control input-sm datepicker', 'id'=>'p_issued_date']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label>Exp.</label>
                                        {!! Form::text('p_exp_date', null, ['class'=>'form-control input-sm datepicker', 'id'=>'p_exp_date']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">ID Card</label>
                            <div class="col-sm-9">
                                <div class="form-inline">
                                    <div class="form-group">
                                        <label>No.</label>
                                        {!! Form::text('idcard_number', null, ['class'=>'form-control input-sm', 'id'=>'idcard_number']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label>@lang("content.expiry")</label>
                                        {!! Form::text('idcard_expiration', null, ['class'=>'form-control input-sm datepicker', 'id'=>'idcard_expiration']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.phone")</label>
                            <div class="col-sm-9">
                                <div class="form-inline" style="width: 120%">
                                    <div class="form-group">
                                        <label>@lang("content.office")</label>
                                        {!! Form::text('phone_office', null, ['class'=>'form-control input-sm', 'id'=>'phone_office']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label>@lang("content.home_phone")</label>
                                        {!! Form::text('phone_home', null, ['class'=>'form-control input-sm', 'id'=>'phone_home']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-sm-3">@lang("content.mobile")</label>
                            <div class="col-sm-9">
                                <div class="form-inline" style="width: 120%">
                                    <div class="form-group">
                                        <label>No 1</label>
                                        {!! Form::text('phone_mobile1', null, ['class'=>'form-control input-sm', 'id'=>'phone_mobile1']) !!}
                                    </div>
                                    <div class="form-group">
                                        <label>No 2</label>
                                        {!! Form::text('phone_mobile2', null, ['class'=>'form-control input-sm', 'id'=>'phone_mobile2']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-primary">@lang("content.add_user")</button>
                                <a href="{!! route("homepage")."#". url("admin/users") !!}" class="btn btn-default">@lang("content.back")</a>
                            </div>
                        </div>
                    {!! Form::close() !!}
                </div>



            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("{{  asset("/assets/js/views/user/add-user.js?2") }}", pagefunction);

</script>


