<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */
    'accepted'             => ':attribute должeн быть принят. ',
    'active_url'           => ':attribute не является допустимой ссылкой URL. ',
    'after'                => ':attribute должны быть дата, после :date ',
    'alpha'                => ':attribute может содержать только буквы. ',
    'alpha_dash'           => ':attribute может содержать только буквы, цифры и дефис. ',
    'alpha_num'            => ':attribute может содержать только буквы и цифры. ',
    'array'                => ':attribute должен быть массивом. ',
    'before'               => ':attribute должны быть дата перед :date ',
    'between'              => [
        'numeric' => ':attribute должны находиться в пределах :min и :max ',
        'file'    => ':attribute должны находиться в пределах :min и :max килобайт ',
        'string'  => ':attribute должны находиться в пределах :min и :max символов ',
        'array'   => ':attribute должны быть между :min и :max пунктов ',
    ],
    'boolean'              => ':attribute поле должно быть истинным или ложным. ',
    'confirmed'            => ':attribute подтверждение не совпадает. ',
    'date'                 => ':attribute не является допустимой датой. ',
    'date_format'          => ':attribute не соответствует формату :format ',
    'different'            => ':attribute и :other должны быть разными ',
    'digits'               => ':attribute должны быть :digits цифры ',
    'digits_between'       => ':attribute должны находиться в пределах :min и :max цифр ',
    'email'                => ':attribute адрес эл. почты должен быть действительным.',
    'exists'               => 'Выбранный :attribute является недействительным. ',
    'filled'               => ':attribute поле, обязательное для заполнения.',
    'image'                => ':attribute файл должен быть. ',
    'in'                   => 'Выбранный :attribute является недействительным. ',
    'integer'              => ':attribute должен быть целым числом. ',
    'ip'                   => ':attribute должен быть действительным IP-адрес. ',
    'json'                 => ':attribute должен быть действительным строка JSON. ',
    'max'                  => [
        'numeric' => ':attribute не может быть больше, чем :max ',
        'file'    => ':attribute Не может быть больше, чем :max килобайт ',
        'string'  => ':attribute не может быть больше, чем :max символов ',
        'array'   => ':attribute не может иметь более :max пунктов ',
    ],
    'mimes'                => ':attribute должны быть файл типа: :values ',
    'min'                  => [
        'numeric' => ':attribute должно быть не менее :min ',
        'file'    => ':attribute должно быть не менее :min килобайт ',
        'string'  => ':attribute должно быть не менее :min символов ',
        'array'   => ':attribute должны иметь по крайней мере :min пунктов ',
    ],
    'not_in'               => 'Выбранный :attribute является недействительным. ',
    'numeric'              => ':attribute должен быть числом.',
    'regex'                => ':attribute Формат является недействительным. ',
    'required'             => ':attribute поле, обязательное для заполнения.',
    'required_if'          => ':attribute поле является обязательным, если :other является :value. ',
    'required_with'        => ':attribute поле является обязательным, если :values присутствует ',
    'required_with_all'    => ':attribute поле является обязательным, если :values присутствует ',
    'required_without'     => ':attribute поле является обязательным, если :values нет ',
   'required_without_all' => ':attribute поле является обязательным, если ни один из :values не присутствуют ',
   'same'                 => ':attribute и :other должны соответствовать ',
   'size'                 => [
    'numeric' => ':attribute должны быть :size ',
    'file'    => ':attribute должны быть :size килобайт ',
    'string'  => ':attribute должны быть :size символы',
    'array'   => ':attribute должен содержать :size пункты ',
],
   'string'               => ':attribute должен быть строкой. ',
   'timezone'             => ':attribute должен быть действительным зона.',
   'unique'               => ':attribute уже был взят.',
   'url'                  => ':attribute формат является недействительным. ',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [],

];
