// array for datatable data...
let data1 = [[]],
    numberOfColumnsInFirstTable = 50,
    counter1=0

// this will be used to determine addresses of cells being merged later (on export) in excel
let lettersAndIndexes = { 'A': 1, 'B': 2, 'C': 3, 'D': 4, 'E': 5, 'F': 6, 'G': 7, 'H': 8, 'I': 9, 'J': 10, 'K': 11, 'L': 12, 'M': 13, 'N': 14, 'O': 15, 'P': 16, 'Q': 17, 'R': 18, 'S': 19, 'T': 20, 'U': 21, 'V': 22, 'W': 23, 'X': 24, 'Y': 25, 'Z': 26 }
let indexesAndLetters = { 1: 'A', 2: 'B', 3: 'C', 4: 'D', 5: 'E', 6: 'F', 7: 'G', 8: 'H', 9: 'I', 10: 'J', 11: 'K', 12: 'L', 13: 'M', 14: 'N', 15: 'O', 16: 'P', 17: 'Q', 18: 'R', 19: 'S', 20: 'T', 21: 'U', 22: 'V', 23: 'W', 24: 'X', 25: 'Y', 26: 'Z' }
function getLetterCodeByNumIndex(numIndex) {
    let letterCode;
    if (numIndex > 702) { // 3 symbols
        let lastLetter, left, firstLetterNumber;
        if (numIndex % 26 === 0) {
            lastLetter = indexesAndLetters[26];
            left = numIndex - 26;
        } else {
            lastLetter = indexesAndLetters[numIndex % 26];
            left = numIndex - (numIndex % 26);
        }

        if ((left / 676) % 1 === 0) {
            firstLetterNumber = Math.floor(left / 676) - 1;
        } else {
            firstLetterNumber = Math.floor(left / 676);
        }

        let firstLetter = indexesAndLetters[firstLetterNumber];
        left = left - firstLetterNumber * 676;
        let middleLetter = indexesAndLetters[(left / 26).toFixed(0)];

        letterCode = firstLetter + middleLetter + lastLetter;
    } else if (numIndex > 26) { // 2 symbols
        let lastLetter, left;
        if (numIndex % 26 === 0) {
            lastLetter = indexesAndLetters[26];
            left = numIndex - 26;
        } else {
            lastLetter = indexesAndLetters[numIndex % 26];
            left = numIndex - (numIndex % 26);
        }
        let firstLetter = indexesAndLetters[(left / 26).toFixed(0)];
        letterCode = firstLetter + lastLetter;
    } else { // 1 symbol
        letterCode = indexesAndLetters[numIndex];
    }
    return letterCode;
}
function getNumIndexByLetterCode(letterCode) {
    letterCode = letterCode.toUpperCase();
    let numIndex;
    switch (letterCode.length) {
        case 1: {
            numIndex = lettersAndIndexes[letterCode]
            break;
        }
        case 2: {
            let [firstLetter, secondLetter] = letterCode.split('');
            numIndex = lettersAndIndexes[firstLetter] * 26 + lettersAndIndexes[secondLetter];
            break;
        }
        case 3: {
            let [firstLetter, secondLetter, thirdLetter] = letterCode.split('');
            numIndex = lettersAndIndexes[firstLetter] * 676 + lettersAndIndexes[secondLetter] * 26 + lettersAndIndexes[thirdLetter];
            break;
        }
        default:
            console.log(`unhandled letterCode.length: ${letterCode.length} ${letterCode}`);
            break;
    }
    return numIndex;
}

// initializing the first datatable
$('#financeReport').DataTable({
    // 'data': data1,
    // "aaSorting": sortingArray,  // [[ -1, "desc" ]]
    "sDom": "BTlfrtip",
    // "bFilter": filter,
    "iDisplayLength": 500,
    "aLengthMenu": [[50, 200, 500, 1000, -1], [50, 200, 500, 1000, "All"]],
    // dom: 'Bfrtip',
    // "bInfo": false,
    // "bPaginate": false,
    // "bSort": false,
    // "searching": false,
    buttons: [
        {
            extend: 'excelHtml5',
            text: 'export to Excel',
            title: '',
            customize: function (xlsx) {
                function _createNode(doc, nodeName, opts) {
                    var tempNode = doc.createElement(nodeName);
                    if (opts) {
                        if (opts.attr) {
                            $(tempNode).attr(opts.attr);
                        }
                        if (opts.children) {
                            $.each(opts.children, function (key, value) {
                                tempNode.appendChild(value);
                            });
                        }
                        if (opts.text !== null && opts.text !== undefined) {
                            tempNode.appendChild(doc.createTextNode(opts.text));
                        }
                    }
                    return tempNode;
                }
                var sheet = xlsx.xl.worksheets['sheet1.xml'];
                function mergeFunction(referenceString = false) {
                    // reference string format: 'B1:E1'
                    var mergeCells = $('mergeCells', sheet);
                    var rows = $('row', sheet);
                    if (!referenceString) {
                        alert('no reference string on merge function call');
                        return
                    }
                    mergeCells[0].appendChild(_createNode(sheet, 'mergeCell', {
                        attr: {
                            ref: referenceString
                        }
                    }));
                    mergeCells.attr('count', mergeCells.attr('count') + 1);
                }

                $(`row:nth-child(2) c`, sheet).attr('s', '67'); // custom style
                // loop to merge cells by 3 in second row
                for(let iterator=1; iterator<=numberOfColumnsInFirstTable; iterator++){
                    let startOfMergedCell = getLetterCodeByNumIndex(iterator*3-2);
                    let endOfMergedCell = getLetterCodeByNumIndex(iterator*3);
                    mergeFunction(`${startOfMergedCell}1:${endOfMergedCell}1`);
                }
            }
        }
    ]
});