function applyTableHeaderFreeze(){
    ;(function($) {
        $.fn.fixMe = function() {
            return this.each(function() {
                var $this = $(this),
                    $t_fixed;
                function init() {
                    $this.wrap('<div class="container" />');
                    $t_fixed = $this.clone();
                    $t_fixed.find("tbody").remove().end().addClass("fixed").insertBefore($this);
                    resizeFixed();
                }
                function resizeFixed() {
                    $t_fixed.find("th").each(function(index) {
                        $(this).css("width",$this.find("th").eq(index).outerWidth()+"px");
                    });
                }
                function scrollFixed() {
                    var offset = $(this).scrollTop(),
                        tableOffsetTop = $this.offset().top,
                        tableOffsetBottom = tableOffsetTop + $this.height() - $this.find("thead").height();
                    if(offset < tableOffsetTop || offset > tableOffsetBottom)
                        $t_fixed.hide();
                    else if(offset >= tableOffsetTop && offset <= tableOffsetBottom && $t_fixed.is(":hidden"))
                        $t_fixed.show();
                }
                $(window).resize(resizeFixed);
                $(window).scroll(scrollFixed);
                init();
            });
        };
    })(jQuery);

    $(document).ready(function(){
        $(".table").fixMe();
        $(".up").click(function() {
            $('html, body').animate({
                scrollTop: 0
            }, 2000);
        });
    });
}



function FormAjaxLoad(form, container, url, fileIncluded) {

    if (typeof url === "undefined"){
        url = $(form).attr("action");
    }

    $(form).submit(function () {
        var request;
        $(container).children().fadeOut();
        var loading = $('<h1 class="ajax-loading-animation"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
        $(container).prepend(loading);

        if (typeof fileIncluded !== "undefined"){
            var file_data = $('input[type=file]').prop('files')[0];
            var form_data = new FormData();

            form_data.append('file', file_data);

            $.each($(form).serialize(), function(key, value)
            {
                form_data.append(key, value);
            });

            request = $.ajax({
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                url: url,
                type: $(form).attr("method") // not POST, laravel won't allow it
            });
        }
        else {

            request = $.ajax({
                data: $(form).serialize(),
                url: url,
                type: $(form).attr("method") // not POST, laravel won't allow it
            });

        }

        request.success(function(data){
            var $data = $(data); // the HTML content your controller has produced
            $(container).html($data);
        });

        request.always(function(){
            loading.hide();
        });

        return false;
    });

}

function ApplyInputSubmit(){
    $(document).on("click", "input[type=submit]", function() {
        var _form = $(this).parents("form").first();
        var _formData = _form.serializeArray();
        _formData.push({ name: this.name, value: this.value });
        //now use formData, it includes the submit button
        FormSubmitProcess(_form, _formData);

        return false;
    });
}

function ApplyFormInputSubmit(form){

    $(document).on("click", form + " input[type=submit]", function() {
        var _form = $(this).parents("form").first();
        var _formData = _form.serializeArray();
        _formData.push({ name: this.name, value: this.value });

        //now use formData, it includes the submit button
        FormSubmitProcess(_form, _formData);

        return false;
    });
}

function ApplySubmitEvent(btn){
    btn.on("click", function() {
        var _this = $(this), _form = _this.closest("form").first();

        var fileIncluded = _form.find('input[type=file]');
        if (fileIncluded.length){
            FormWithFileProcess(_form, _this);
            //FormSubmitProcess(_form, "undefined", btn);
        }
        else {
            var _formData = _form.serializeArray();
            _formData.push({ name: $(this).attr("name"), value: $(this).val() });
            FormSubmitProcess(_form, _formData);
        }

        return false;
    });
}


function ApplyFormSubmit(){

    $("form").submit(function () {

        FormSubmitProcess($(this));

        return false;

    });
}

function ApplySpecificFormSubmit(_form){

    _form.submit(function () {

        FormSubmitProcess($(this));

        return false;

    });
}

function ApplyMultipleFormSubmit(){

     $("form").not(".exclude-form").each(function () {
         $(this).submit(function () {
             FormSubmitProcess($(this));
             return false;
         });
     });
}

function FormWithFileProcess(_form, _submitBtn){
    var fileIncluded = _form.find('input[type=file]');
    var file_data = fileIncluded.prop('files')[0];
    var form_data = new FormData();

    form_data.append(fileIncluded.attr("name"), file_data);

    _form.find("input, select").not(':file, [type=submit], [name=_token]').each(function () {
        if ($.isArray($(this).val()) > 0){
            var items = $(this).val();
            for(var i = 0; i < items.length; i++){
                form_data.append($(this).attr("name"),items[i]);
            }
        }
        else {
            form_data.append($(this).attr("name"), $(this).val());
        }
    });

    if (_submitBtn && typeof _submitBtn === "undefined"){
        form_data.append(_submitBtn.attr("name"), _submitBtn.val());
    }

    return $.ajax({
        headers: {
            'x-csrf-token': _form.find('input[name=_token]').val()
        },
        cache: false,
        contentType: false,
        processData: false,
        data: form_data,
        url: _form.attr("action"),
        type: _form.attr("method") // not POST, laravel won't allow it
    });
}

function FormWithoutFileProcess(_form, _formData){

    if (typeof _formData === "undefined"){
        _formData = _form.serialize();
    }

    return $.ajax({
        headers: {
            'x-csrf-token': _form.find('input[name=_token]').val()
        },
        data: _formData,
        url: _form.attr("action"),
        type: _form.attr("method") // not POST, laravel won't allow it
    });
}

function FormSubmitProcess(_form, _formData, _submitBtn){

    var container = $("#widget-grid");

    var request;

    container.children().fadeOut();

    var loading = $('<h1 class="ajax-loading-animation"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
    container.prepend(loading);

    var fileIncluded = _form.find('input[type=file]');

    if (fileIncluded.length > 0){
        request = FormWithFileProcess(_form, _submitBtn);
    }
    else {
        request = FormWithoutFileProcess(_form, _formData);
    }

    // var pathname = window.location.pathname; // Returns path only (/path/example.html)
    // var url      = window.location.href;     // Returns full URL (https://example.com/path/example.html)
    // var origin   = window.location.origin;   // Returns base URL (https://example.com)
    // console.log(currentUrl)
    // console.log(prevUrl)

    request.success(function(data){
        var $data = $(data); // the HTML content your controller has produced
        container.html($data);
        // processAjaxData(data, baseUrl);
        // window.history.pushState($data, '', document.referrer);
    });

    request.always(function(){
        loading.hide();
    });
}

function processAjaxData(response, urlPath){
    //document.getElementById("content").innerHTML = response.html;
    document.title = response.pageTitle;
    window.history.pushState({"html":response.html,"pageTitle":response.pageTitle},"", urlPath);
}

function ApplyDateFormats(useMask){

    var useMask = typeof useMask !== "undefined" && useMask ? true : false;

    var startDateTime;
    $(".dateTimeFrom").datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,
        mask:useMask,
        closeOnTimeSelect: true,
        onChangeDateTime: function(dp,$input){
            startDateTime = $(".dateTimeFrom").val();
        },
        onClose: function(current_time, $input){
            var startDateTime = $(".dateTimeFrom").val();
            var endDateTime = $(".dateTimeTo").val();
            if(startDateTime > endDateTime){
                alert('Please select correct date');
            }
        }
    });
    $(".dateTimeTo").datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,
        mask:useMask,
        closeOnTimeSelect: true,
        onClose: function(current_time, $input){
            var endDateTime = $(".dateTimeTo").val();
            if(startDateTime>endDateTime){
                alert('Please select correct date');
            }
        }
    });

    var startDate;
    $(".dateFrom").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false,
        mask:useMask,
        onChangeDateTime: function(dp,$input){
            startDate = $(".dateFrom").val();
        },
        onClose: function(current_time, $input){
            var startDate = $(".dateFrom").val();
            var endDate = $(".dateTo").val();
            if(endDate && startDate > endDate){
                alert('Please select correct date');
            }
        }
    });
    $(".dateTo").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false,
        mask:useMask,
        onClose: function(current_time, $input){
            var startDate = $(".dateFrom").val();
            var endDate = $(".dateTo").val();
            if(startDate && startDate > endDate){
                alert('Please select correct date');
            }
        }
    });

    var timeObj = $(document).find('.timepicker');
    if (timeObj.length > 0) {
        timeObj.datetimepicker({
            datepicker:false,
            format:'H:i',
            step:5,
            mask:useMask,
        });
    }

    var dateObj = $(document).find('.date');
    if (dateObj.length > 0) {
        dateObj.datetimepicker({
            format: 'Y-m-d',
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: false,
            mask:useMask,
        });
    }

    var dateTimeObj = $(document).find('.datetimepicker');
    if (dateTimeObj.length > 0) {
        dateTimeObj.datetimepicker({
            format: 'Y-m-d H:i',
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: true,
            mask:useMask,
        });
    }
}

function ApplyValidationDateFormats(){

    var startDateTime;
    $(".dateTimeFrom").datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,

        closeOnTimeSelect: true,
        onChangeDateTime: function(dp,$input){
            startDateTime = $(".dateTimeFrom").val();
        },
        onClose: function(current_time, $input){
            var startDateTime = $(".dateTimeFrom").val();
            var endDateTime = $(".dateTimeTo").val();
            if(startDateTime > endDateTime){
                alert('Please select correct date');
            }
        }
    });
    $(".dateTimeTo").datetimepicker({
        format: 'Y-m-d H:i',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: true,

        closeOnTimeSelect: true,
        onClose: function(current_time, $input){
            var endDateTime = $(".dateTimeTo").val();
            if(startDateTime>endDateTime){
                alert('Please select correct date');
            }
        }
    });

    var startDate;
    $(".dateFrom").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false,
        onChangeDateTime: function(dp,$input){
            startDate = $(".dateFrom").val();
        },
        onClose: function(current_time, $input){
            var startDate = $(".dateFrom").val();
            var endDate = $(".dateTo").val();
            if(startDate > endDate){
                alert('Please select correct date');
            }
        }
    });
    $(".dateTo").datetimepicker({
        format: 'Y-m-d',
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false,
        onClose: function(current_time, $input){
            var endDate = $(".dateTo").val();
            if(startDate>endDate){
                alert('Please select correct date');
            }
        }
    });

    var timeObj = $(document).find('.timepicker');
    var dateObj = $(document).find('.date');

    if (timeObj.length > 0) {
        timeObj.datetimepicker({
            datepicker:false,
            format:'H:i',
            step:5,
        });
    }

    if (dateObj.length > 0) {
        dateObj.datetimepicker({
            format: 'Y-m-d',
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: false,
        });
    }

    var dateTimeObj = $(document).find('.datetimepicker');
    if (dateTimeObj.length > 0) {
        dateTimeObj.datetimepicker({
            format: 'Y-m-d H:i',
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: true,
            // mask:useMask,
        });
    }

}


function GetChartJsBarOptions(){

    return {
        scales: {
            yAxes: [{
                ticks: {
                    beginAtZero:true
                }
            }],
            xAxes: [{
                ticks: {
                    beginAtZero:true
                }
            }]
        },
        legend: {
            display: false,
            labels: {
                fontColor: 'rgb(255, 99, 132)'
            }
        },
        ticks: {
            min: 0
        },
        //Boolean - Whether grid lines are shown across the chart
        scaleShowGridLines : true,
        //String - Colour of the grid lines
        scaleGridLineColor : "rgba(0,0,0,.05)",
        //Number - Width of the grid lines
        scaleGridLineWidth : 1,
        //Boolean - If there is a stroke on each bar
        barShowStroke : true,
        //Number - Pixel width of the bar stroke
        barStrokeWidth : 1,
        //Number - Spacing between each of the X value sets
        barValueSpacing : 5,
        //Number - Spacing between data sets within X values
        barDatasetSpacing : 1,
        //Boolean - Re-draw chart on page resize
        responsive: true,

        //String - A legend template
        legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
    }
}

function GetChartJsLineOptions(legend, hideDots){
   return {
       scales: {
           yAxes: [{
               display: true,
               ticks: {
                   suggestedMin: 0,    // minimum will be 0, unless there is a lower value.
                   suggestedMax: 100,
                   // OR //
                   //beginAtZero: true   // minimum value will be 0.
               }
           }]
       },
       legend: {
           display: (typeof legend !== "undefined"),
        },
        ///Boolean - Whether grid lines are shown across the chart
        scaleShowGridLines : true,
        //String - Colour of the grid lines
        scaleGridLineColor : "rgba(0,0,0,.05)",
        //Number - Width of the grid lines
        scaleGridLineWidth : 1,
        //Boolean - Whether the line is curved between points
        bezierCurve : true,
        //Number - Tension of the bezier curve between points
        bezierCurveTension : 0.4,
        //Boolean - Whether to show a dot for each point
        pointDot : (typeof hideDots === "undefined"),
        //Number - Radius of each point dot in pixels
        pointDotRadius : 4,
        //Number - Pixel width of point dot stroke
        pointDotStrokeWidth : 1,
        //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
        pointHitDetectionRadius : 20,
        //Boolean - Whether to show a stroke for datasets
        datasetStroke : true,
        //Number - Pixel width of dataset stroke
        datasetStrokeWidth : 2,
        //Boolean - Whether to fill the dataset with a colour
        datasetFill : true,
        //Boolean - Re-draw chart on page resize
        responsive: true,
        //String - A legend template
        legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"
    };
}

function ExportToExcel(type, fn, dl, tableID) {
    var table = document.getElementById(tableID);
    var wb = XLSX.utils.table_to_book(table, { sheet: "sheet1" });
    return dl ?
        XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' }):
        XLSX.writeFile(wb, fn || ('MySheetName.' + (type || 'xlsx')));
}


function ApplyTableFilter(tableSelector, excludeSearch, sortingArray){
    /*
    var table = $(tableSelector).DataTable( {
        lengthChange: false,
        buttons: [ 'copy', 'excel', 'pdf', 'colvis' ]
    } );

    table.buttons().container()
        .appendTo( '#example_wrapper .col-sm-6:eq(0)' );
    */

    var title = $(tableSelector).data("filename");
    let filename = $(tableSelector).parents(".jarviswidget").find("header.ui-sortable-handle h2").text();
    var filter = !excludeSearch || typeof excludeSearch === "undefined";

    if (!filename || filename == "List"){
        filename = $(document).find("ol.breadcrumb li:last-child").text();
    }
    if (!filename || filename == ""){
        filename = "Report";
    }

    if (typeof sortingArray === "undefined" || !sortingArray){
        sortingArray = [];
    }

    var options = {
        //dom: 'Bfrtip',
        "aaSorting": sortingArray,  // [[ -1, "desc" ]]
        "sDom": "BTlfrtip",
        "bFilter": filter,
        "iDisplayLength": 500,
        "aLengthMenu": [[50, 200, 500, 1000, -1], [50, 200, 500, 1000, "All"]],
        buttons: [
            // 'copy', 'excel', 'pdf',
            // {
            //     extend: 'copyHtml5',
            //     exportOptions: {
            //         columns: ':contains("Office")'
            //     }
            // },
            // {
            //     extend: 'excelHtml5',
            //     title: title
            // },
            {
                text: "Export To Excel",
                action: function ( e, dt, node, config ) {
                    // ExportToExcel('xlsx', 'financeReport')
                    var table;
                    if (tableSelector.indexOf(".") >= 0){
                        table = document.querySelector(tableSelector);
                        let wb = XLSX.utils.table_to_book(table, { sheet: "sheet1" });
                        return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');

                        // table = document.getElementsByClassName(tableSelector.replace('.',''));
                        // Array.from(table).forEach(
                        //     function(element, index, array) {
                        //         var wb = XLSX.utils.table_to_book(element, { sheet: "sheet1" });
                        //         return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');
                        //     }
                        // );
                    }
                    else {
                        try {
                            table = tableSelector.indexOf("#") >= 0 ? document.getElementById(tableSelector.replace('#',''))
                                : document.getElementById(tableSelector);

                            let wb = XLSX.utils.table_to_book(table, { sheet: "sheet1" });
                            return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');
                        }
                        catch (e) {

                        }
                    }

                }
            }
            //'excelHtml5',
            // 'csvHtml5',
            // 'pdfHtml5'
        ]
    };

    $(tableSelector).DataTable( options );
}

function ApplyTableFilterSortingOff(tableSelector, excludeSearch){
    /*
    var table = $(tableSelector).DataTable( {
        lengthChange: false,
        buttons: [ 'copy', 'excel', 'pdf', 'colvis' ]
    } );

    table.buttons().container()
        .appendTo( '#example_wrapper .col-sm-6:eq(0)' );
    */

    var title = $(tableSelector).data("filename");
    let filename = $(tableSelector).parents(".jarviswidget").find("header.ui-sortable-handle h2").text();
    var filter = !excludeSearch || typeof excludeSearch === "undefined";

    if (!filename || filename == "List"){
        filename = $(document).find("ol.breadcrumb li:last-child").text();
    }
    if (!filename || filename == ""){
        filename = "Report";
    }

    var options = {
        //dom: 'Bfrtip',
        "ordering": false,
        "sDom": "BTlfrtip",
        "bFilter": filter,
        "iDisplayLength": 500,
        "aLengthMenu": [[50, 200, 500, 1000, -1], [50, 200, 500, 1000, "All"]],

        buttons: [
            {
                text: "Export To Excel",
                action: function ( e, dt, node, config ) {
                    // ExportToExcel('xlsx', 'financeReport')
                    var table;
                    if (tableSelector.indexOf(".") >= 0){
                        table = document.querySelector(tableSelector);
                        let wb = XLSX.utils.table_to_book(table, { sheet: "sheet1" });
                        return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');

                        // table = document.querySelectorAll(tableSelector);
                        // table.forEach((obj)=>{
                        //     if(isVisible(obj)){
                        //         let wb = XLSX.utils.table_to_book(obj, { sheet: "sheet1" });
                        //         return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');
                        //     }
                        // })

                        // table = document.getElementsByClassName(tableSelector.replace('.',''));
                        // Array.from(table).forEach(
                        //     function(element, index, array) {
                        //         var wb = XLSX.utils.table_to_book(element, { sheet: "sheet1" });
                        //         return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');
                        //     }
                        // );
                    }
                    else {
                        try {
                            table = tableSelector.indexOf("#") >= 0 ? document.getElementById(tableSelector.replace('#',''))
                                : document.getElementById(tableSelector);

                            var wb = XLSX.utils.table_to_book(table, { sheet: "sheet1" });
                            return XLSX.writeFile(wb, (filename ?? "Report") + '.xlsx');
                        }
                        catch (e) {

                        }
                    }

                }
            }
        ]
    };

    $(tableSelector).DataTable( options );
}


function isVisible (ele) {
    var style = window.getComputedStyle(ele);
    return  style.width !== "0" &&
        style.height !== "0" &&
        style.opacity !== "0" &&
        style.display!=='none' &&
        style.visibility!== 'hidden';
}

function ApplyTableFilter2(tableSelector, assetURL){
    var responsiveHelper_datatable_fixed_column = undefined;
    var responsiveHelper_dt_basic = undefined;
    var responsiveHelper_datatable_col_reorder = undefined;
    var responsiveHelper_datatable_tabletools = undefined;

    var breakpointDefinition = {
        tablet : 1024,
        phone : 480
    };


    if ($(tableSelector).length == 0)
        return;

    /* COLUMN FILTER  */
    var otable = $(tableSelector).DataTable({
        "pageLength": 50,
        "lengthMenu": [[50, 200, 1000, -1], [50, 200, 1000, "All"]],
        "aaSorting" : [],  // [[ -1, "desc" ]]

        //"sDom": 'T<"clear">lfrtip<"clear spacer">T',
        //"bFilter": false,
        //"bInfo": false,
        //"bLengthChange": true,
        //"bAutoWidth": false,
        //"bPaginate": true,
        //"bStateSave": true // saves sort state using localStorage
        "sDom": "<'dt-toolbar'<'col-sm-5 col-xs-12'f><'col-sm-5 col-xs-12 hidden-xs'T><'col-sm-2 col-xs-12 hidden-xs'l>r>"+
            "t"+ "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
        // Tabletools options:
        "oTableTools": {
            //"bLengthChange": true,
            "aButtons2": [
                "copy",
                "csv",
                "xls",

                {
                    "sExtends": "pdf",
                    "sTitle": "Aviation-BIS Reports",
                    //"sPdfMessage": "SmartAdmin PDF Export",
                    "sPdfSize": "letter",
                },
                {
                    "sExtends": "print",
                    "sMessage": "Generated by Aviation-BIS <i>(press Esc to close)</i>"
                },

            ],
            "sSwfPath": assetURL +  "/js/plugin/datatables/swf/copy_csv_xls_pdf.swf"
        },

        "autoWidth" : true,
        "preDrawCallback" : function() {
            // Initialize the responsive datatables helper once.
            if (!responsiveHelper_datatable_fixed_column) {
                responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($(tableSelector), breakpointDefinition);
            }
        },
        "rowCallback" : function(nRow) {
            responsiveHelper_datatable_fixed_column.createExpandIcon(nRow);
        },
        "drawCallback" : function(oSettings) {
            responsiveHelper_datatable_fixed_column.respond();
        }

    });

    // custom toolbar
    //$("div.toolbar").html('<div class="text-right"><img src="img/logo.png" alt="SmartAdmin" style="width: 111px; margin-top: 3px; margin-right: 10px;"></div>');

    // Apply the filter

    $(tableSelector + " thead th input[type=text]").on( 'keyup change', function () {

       otable
            .column( $(this).parent().index()+':visible' )
            .search( this.value )
            .draw();

    } );

}


function FormPeriod(){
    $(document).ready(function(){
        function check_frm_submit_action(periodData){
            var frm_period = $('#frm_period');
            if (typeof period === 'undefined')
                var period = periodData;

        if (period <= 5){
            frm_period.attr('action', baseUrl + "#" + 'forwardrevenue');
            $('#flight_number').parent('div').hide();
        }
        else if (period == 6){
            frm_period.attr('action', baseUrl + "#" + 'forwardrevenue/flightdaily');
            $('#flight_number').parent('div').show();
        }
        else if (period == 7){
            frm_period.attr('action', baseUrl + "#" + 'forwardrevenue/flightdailysales');
            $('#flight_number').parent('div').hide();
        }
    };

    check_frm_submit_action();

    $('#period').change(function(){
        var period = $(this).val();
        if (period == 6)
            $('#flight_number').parent('div').show();
        else
            $('#flight_number').parent('div').hide();
        check_frm_submit_action(period);

    });

    $('#frm_period').submit(function(){
        var period = $('#period');
        if (period.val() == ''){
            return false;
        }
        else{
            return true;
        }
    });

});
}

function ltrim(str, char){
    if (!str || typeof str === "undefined" || str == "" || !char || typeof char === "undefined"){
        return str;
    }

    var newStr = "";
    var foundNonZeroSymbol = false;
    for (var i = 0, len = str.length; i < len; i++) {
        if (!foundNonZeroSymbol && str[i] == char){
            continue;
        }
        else {
            foundNonZeroSymbol = true;
        }

        newStr += str[i];
    }

    return newStr;
}

function ApplyOperationsFormFilter(flightNumbers, selectedFlightNumbers, sectors, sectorsByAirlines, selectedSectors, singleselect, airline_selector, flight_number_selector){

    var airline = "#airline";

    if (typeof airline_selector !== "undefined" && airline_selector){
        airline = airline_selector;
    }

    OperationsFormFilter(flightNumbers, selectedFlightNumbers, sectors, sectorsByAirlines, selectedSectors, $(airline).val(), singleselect, flight_number_selector);

    $(document).on("change", airline, function () {
        var _this = $(this), airlineIds = _this.val();

        console.log("AIRLINE changes")

        OperationsFormFilter(flightNumbers, null, sectors, sectorsByAirlines, null, airlineIds, singleselect, flight_number_selector);
    });

}

function OperationsFormFilter(flightNumbers, selectedFlightNumbers, sectors, sectorsByAirlines, selectedSectors, airlineIds, singleselect, flight_number_selector){
    var flightNumber = $("#flight_number"),
        sector = $("#sector");

    if (typeof flight_number_selector !== "undefined" && flight_number_selector){
        flightNumber = $(flight_number_selector);
    }

    flightNumber.children().remove();

    if (sector && sector !== "undefined"){
        sector.children().remove();
    }

    airlineIds = $.isArray(airlineIds) ? airlineIds : [airlineIds];

    if (!airlineIds || airlineIds.length == 0){

        $.each(flightNumbers, function (i, each) {
            flightNumber.append("<option value='" + each.id  + "'" + (selectedFlightNumbers && $.inArray(each.id + "", selectedFlightNumbers) != -1 ? " selected" : "") + ">" + each.sector + "</option>");
        });

        if (sectors && sectors !== "undefined"){
            $.each(sectors, function (i, each) {
                sector.append("<option value='" + i + "'" + (selectedSectors && $.inArray(i + "", selectedSectors) != -1 ? " selected" : "") +">" + each + "</option>");
            });
        }
    }
    else {
        $.each(flightNumbers, function (i, each) {
            if ($.inArray(each.airline_id + "", airlineIds) != -1) {
                flightNumber.append("<option value='" + each.id + "'" + (selectedFlightNumbers && $.inArray(each.id + "", selectedFlightNumbers) != -1 ? " selected" : "") + ">" + each.sector + "</option>");
            }
        });

        if (sectorsByAirlines && sectorsByAirlines !== "undefined") {
            $.each(sectorsByAirlines, function (i, each) {
                if ($.inArray(each.airline_id + "", airlineIds) != -1) {
                    sector.append("<option value='" + each.id + "'" + (selectedSectors && $.inArray(each.id + "", selectedSectors) != -1 ? " selected" : "") +">"  + each.sector + "</option>");
                }
            });
        }
    }

    if (typeof singleselect !== "undefined" && singleselect){

    }
    else {
        flightNumber.multiselect('rebuild');

        if (sector && sector !== "undefined") {
            sector.multiselect('rebuild');
        }
    }
}

function ApplyOperationsFormCountryFilter(citiesByCountry, agenciesByCountry, selectedCountries, selectedCities, selectedAgencies){

    var country = $("#country");

    if (selectedCountries){
        OperationsFormCityFilter(selectedCountries, citiesByCountry[selectedCountries], selectedCities);

        if (agenciesByCountry && typeof agenciesByCountry !== "undefined"){
            OperationsFormAgencyFilter(selectedCountries, agenciesByCountry[selectedCountries], selectedAgencies)
        }
    }

    country.on("change", function () {

        var _this = $(this), selectedCountryIDs = _this.val();

        OperationsFormCityFilter(selectedCountryIDs, citiesByCountry[selectedCountryIDs], null);

        if (agenciesByCountry && typeof agenciesByCountry !== "undefined"){
            OperationsFormAgencyFilter(selectedCountryIDs, agenciesByCountry[selectedCountryIDs], null)
        }

    });
}

function OperationsFormCityFilter(selectedCountries, citiesByCountry, selectedCities){
    //selectedCountries = $.isArray(selectedCountries) ? selectedCountries : [selectedCountries];

    var city = $("#city");

    if (!city || city.length == 0){
        return;
    }

    city.children().remove();

    if (selectedCountries && citiesByCountry) // || selectedCountries.length == 0)
    {
        city.append("<option value=''>Select</option>");
        $.each(citiesByCountry, function (i, each) {

            city.append("<option value='" + each.id  + "'" + (selectedCities && (each.id + "" == selectedCities) ? " selected" : "") + ">" + each.city + "</option>");
            //city.append("<option value='" + each.id  + "'" + (selectedCities && $.inArray(each.id + "", selectedCities) != -1 ? " selected" : "") + ">" + each.city + "</option>");
        });
    }

    city.multiselect('rebuild');
}

function OperationsFormAgencyFilter(selectedCountries, agenciesByCountry, selectedAgencies){
    //selectedCountries = $.isArray(selectedCountries) ? selectedCountries : [selectedCountries];

    var agency = $("#agency");

    if (!agency || agency.length == 0){
        return;
    }

    agency.children().remove();

    if (agenciesByCountry) // || selectedCountries.length == 0)
    {
        agency.append("<option value=''>Select</option>");
        $.each(agenciesByCountry, function (i, each) {
            agency.append("<option value='" + each.id  + "'" + (selectedAgencies && (each.id + "" == selectedAgencies) ? " selected" : "") + ">" + each.agency + "</option>");
            //city.append("<option value='" + each.id  + "'" + (selectedCities && $.inArray(each.id + "", selectedCities) != -1 ? " selected" : "") + ">" + each.city + "</option>");
        });
    }

    agency.multiselect('rebuild');
}


function getFlightDepartureInitialDate(flight)
{
    var date = null;

    var EMPTY_DATETIME = "0000-00-00 00:00:00";

    if (flight)
    {
        if (flight.std && flight.std != EMPTY_DATETIME)
        {
            date = flight.std;
        }
        else if (flight.ptd && flight.ptd != EMPTY_DATETIME)
        {
            date = flight.ptd;
        }
        else if (flight.etd && flight.etd != EMPTY_DATETIME)
        {
            date = flight.etd;
        }
        else if (flight.atd && flight.atd != EMPTY_DATETIME)
        {
            date = flight.atd;
        }

    }
    return date;
}

function getFlightArrivalInitialDate(flight, applyMoment)
{
    var date = null;
    var EMPTY_DATETIME = "0000-00-00 00:00:00";

    if (flight)
    {
        if (flight.sta && flight.sta != EMPTY_DATETIME)
        {
            date = flight.sta;
        }
        else if (flight.pta && flight.pta != EMPTY_DATETIME)
        {
            date = flight.pta;
        }
        else if (flight.eta && flight.eta != EMPTY_DATETIME)
        {
            date = flight.eta;
        }
        else if (flight.ata && flight.ata != EMPTY_DATETIME)
        {
            date = flight.ata;
        }

    }
    return (typeof applyMoment !== "undefined" ? moment(date) : date);
}

function getFlightDepartureDate(flight)
{
    var date = null;
    var EMPTY_DATETIME = "0000-00-00 00:00:00";

    if (flight)
    {
        if (flight.atd && flight.atd != EMPTY_DATETIME)
        {
            date = flight.atd;
        }
        else if (flight.etd && flight.etd != EMPTY_DATETIME)
        {
            date = flight.etd;
        }
        else if (flight.ptd && flight.ptd != EMPTY_DATETIME)
        {
            date = flight.ptd;
        }
        else if (flight.std && flight.std != EMPTY_DATETIME)
        {
            date = flight.std;
        }
    }
    return date;
}

function getFlightArrivalDate(flight, applyMoment)
{
    var date = null;
    var EMPTY_DATETIME = "0000-00-00 00:00:00";

    if (flight)
    {
        if (flight.ata && flight.ata != EMPTY_DATETIME)
        {
            date = flight.ata;
        }
        else if (flight.eta && flight.eta != EMPTY_DATETIME)
        {
            date = flight.eta;
        }
        else if (flight.pta && flight.pta != EMPTY_DATETIME)
        {
            date = flight.pta;
        }
        else if (flight.sta && flight.sta != EMPTY_DATETIME)
        {
            date = flight.sta;
        }
    }
    return (typeof applyMoment !== "undefined" ? moment(date) : date);
}

function getFlightDepartureAirport(flight, type){
    var obj = flight.departure_airport_id ? flight.departure_airport : flight.flight_number.departure_airport;

    if (!obj || typeof obj === "undefined"){
        return null;
    }

    if (typeof type !== "undefined"){

        switch (type){
            case "IATA":
                return obj.iata;

            case "NAME":
                return obj.name;
        }
    }

    return obj;
}


function getFlightArrivalAirport(flight, type, showOriginalDestination){
    var obj = flight.arrival_airport_id ? flight.arrival_airport : flight.flight_number.arrival_airport;

    if (typeof showOriginalDestination !== "undefined"){
        obj = flight.flight_number.arrival_airport;
    }

    if (!obj || typeof obj === "undefined"){
        return null;
    }

    if (typeof type !== "undefined"){

        switch (type){
            case "IATA":
                return obj.iata;

            case "NAME":
                return obj.name;
        }
    }

    return obj;
}


function getPassengerLink(passengerID){

    switch(AIRLINE){
        case "GSRM":
        case "FRAAI":
        case "AVIAM":
        case "SCO":
            return "#";

        case "QAZAQ_AIR":
        case "TAJIK_AIR":
        default:
            return baseUrl + "#passenger/" + passengerID;

    }
}

function dailyChart(type, title, elementID, bgColor, data, max) {
    var ctx = document.getElementById(elementID);
    ctx.height = 400;

    var yTick = {
        beginAtZero: true,
        stepSize: 1,
    };

    if (typeof max !== "undefined" && max){
        yTick = {
            beginAtZero: true,
            // max: max,
            stepSize: 1,
        };
    }

    var myChart = new Chart(ctx, {
        type: type,
        data: {
            // labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
            datasets: [{
                data: data,
                label: title,
                // borderWidth: 2
                lineTension: 0.2,
                // fill: true,
                borderColor: 'rgb(182,123,105)',
                backgroundColor: 'transparent',
                // borderDash: [2, 2],
                pointBorderColor: 'rgb(182,123,105)',
                pointBackgroundColor: 'rgb(209,128,96)',
                pointRadius: 4,
                pointHoverRadius: 8,
                pointHitRadius: 24,
                pointBorderWidth: 2,
                pointStyle: 'rectRounded'
            }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            //
            legend: {
                display: true,
                position: 'top',
                // labels: {
                //     boxWidth: 80,
                //     fontColor: 'black'
                // }
            },
            scales: {
                xAxes: [{
                    type: "time",
                    time: {
                        unit: 'hour',
                        unitStepSize: 1,
                        // round: 'hour',
                        tooltipFormat: "HH:mm",
                        displayFormats: {
                            hour: 'MMM D, HH:mm'
                        }
                    }
                }],
                yAxes: [{
                    ticks: yTick,
                    stepSize: 1,
                    // gridLines: {
                        // color: "black",
                        // borderDash: [2, 5],
                    // },
                    scaleLabel: {
                        display: true,
                        labelString: title,
                        fontColor: "green"
                    }
                }]
            },
            /*
            scales: {
                yAxes: [{
                    ticks: yTick
                }],
                xAxes: [{
                    type: 'time',
                    offset: true,
                    xValueType: "dateTime",
                }]
            }
            */
        }
    });
}

function dailyChartMultiple(type, title, elementID, bgColor, data, max) {
    var ctx = document.getElementById(elementID);
    ctx.height = 400;

    var yTick = {
        beginAtZero: true,
    };

    if (typeof max !== "undefined" && max){
        yTick = {
            beginAtZero: true,
            // max: max,
        };
    }

    var myChart = new Chart(ctx, {
        type: type,
        data: {
            // labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
            datasets: [{
                    data: data.sla,
                    label: data.title,
                    lineTension: 0.2,
                    fill: false,
                    borderColor: 'rgb(13,165,5)',
                    backgroundColor: 'transparent',
                    borderDash: [2, 2],
                    pointBorderColor: 'rgb(13,165,5)',
                    pointBackgroundColor: 'rgba(255,150,0,0.62)',
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointHitRadius: 24,
                    pointBorderWidth: 2,
                    pointStyle: 'rectRounded'
                }
                ,{
                    data: data.sla2,
                    label: data.title2,
                    // borderWidth: 2
                    lineTension: 0.2,
                    // fill: true,
                    borderColor: 'rgb(58,115,255)',
                    backgroundColor: 'transparent',
                    // borderDash: [2, 2],
                    pointBorderColor: 'rgb(58,115,255)',
                    pointBackgroundColor: 'rgba(255,150,0,0.62)',
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointHitRadius: 24,
                    pointBorderWidth: 2,
                    pointStyle: 'rectRounded'
                },
                /*
                {
                    data: data.flt,
                    label: data.title3,
                    // borderWidth: 2
                    lineTension: 0.2,
                    // fill: true,
                    borderColor: 'rgb(149,133,127)',
                    backgroundColor: 'transparent',
                    // borderDash: [2, 2],
                    pointBorderColor: 'rgb(149,133,127)',
                    pointBackgroundColor: 'rgba(177,147,126,0.62)',
                    pointRadius: 4,
                    pointHoverRadius: 8,
                    pointHitRadius: 24,
                    pointBorderWidth: 2,
                    pointStyle: 'rectRounded'
                }
                 */
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            //
            legend: {
                display: true,
                position: 'top',
                // labels: {
                //     boxWidth: 80,
                //     fontColor: 'black'
                // }
            },
            scales: {
                xAxes: [{
                    type: "time",
                    time: {
                        unit: 'hour',
                        unitStepSize: 1,
                        // round: 'hour',
                        tooltipFormat: "HH:mm",
                        displayFormats: {
                            hour: 'HH:mm'
                        }
                    }
                }],
                yAxes: [{
                    ticks: yTick,
                    // gridLines: {
                    // color: "black",
                    // borderDash: [2, 5],
                    // },
                    scaleLabel: {
                        display: true,
                        labelString: title,
                        fontColor: "green"
                    }
                }]
            },
            /*
            scales: {
                yAxes: [{
                    ticks: yTick
                }],
                xAxes: [{
                    type: 'time',
                    offset: true,
                    xValueType: "dateTime",
                }]
            }
            */
        }
    });
}