/**
 * Created by Compas on 28.08.14.
 */

$(function () {

    var
        _department_id = $('#department_id'),
        _position_id = $('#position_id'),
        _subdepartment_id = $('#subdepartment_id');

    _department_id.on('change', function () {
        var _this = $(this), department_id = _this.val(), request;

        if (!department_id) {
            return false;
        }

        _department_id.attr("disabled", true);
        _position_id.find("option:not(:first)").remove();
        _subdepartment_id.find("option:not(:first)").remove();

        $("#position").hide();
        $("#subdepartment").hide();

        request = $.ajax({
            url: baseUrl + '/department/children',
            type: 'GET',
            dataType: 'json',
            data: {
                department_id: department_id
            }
        });
        request.done(function (data) {
            var i, l;
            if (data.success) {
                if (data.type == "positions") {
                    if (data.child.length) {
                        for (i = 0, l = data.child.length; i < l; i++) {
                            _position_id.append("<option value='" + data.child[i].id + "'>"+ data.child[i].title +"</option>");
                        }
                        _position_id.append("<option value='other'>Other</option>");
                    }
                    _subdepartment_id.attr("required", false);
                    $('#position').show();
                } else if (data.type == "subdepartments") {
                    if (data.child.length) {
                        for (i = 0, l = data.child.length; i < l; i++) {
                            _subdepartment_id.append("<option value='" + data.child[i].id + "'>"+ data.child[i].name +"</option>");
                        }
                    }
                    _subdepartment_id.attr("required", true);
                    $('#subdepartment').show();
                }
            } else {
                showMessage(data.message, "Error!", MESSAGE_DANGER, $("#messages"));
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "AJAX Error!", MESSAGE_DANGER, $("#messages"));
        });
        request.always(function() {
            _department_id.attr("disabled", false);
        });
    });

    /**
     * On change sub department select box event handler
     * @return void
     */
    _subdepartment_id.on("change", function() {
        var _this = $(this), sub_department_id = _this.val(), request;

        if (!sub_department_id) {
            return false;
        }

        _this.attr("disabled", true);
        _position_id.find("option:not(:first)").remove();
        _position_id.show().attr("disabled", true);
        $("#position").show();
        request = $.ajax({
            url: baseUrl + '/position/ajax-positions',
            type: 'GET',
            dataType: 'json',
            data: {
                sub_department_id: sub_department_id
            }
        });
        request.done(function (data) {
            var i, l;
            if (typeof data.success !== "undefined") {
                if (data.positions.length) {
                    for (i = 0, l = data.positions.length; i < l; i++) {
                        _position_id.append("<option value='" + data.positions[i].id + "'>"+ data.positions[i].name +"</option>");
                    }
                }
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "AJAX Error!", MESSAGE_DANGER, $("#messages"));
        });
        request.always(function() {
            _this.attr("disabled", false);
            _position_id.attr("disabled", false);
            _position_id.append("<option value='other'>Other</option>");
        });
    });

    /**
     * On change position event handler
     * @return void
     */
    _position_id.on("change", function() {
        var _this = $(this), _other_position = $('#other_position');
        if (_this.val() == 'other') {
            _other_position.show();
            $("#other_position_value").attr("required", true);
        } else {
            _other_position.hide();
            $("#other_position_value").attr("required", false);
        }
    });

});
