/**
 * Created by Compas on 14.10.2014.
 */

$(function() {

    var
        _department_id = $('#department_id'),
        _position_id = $('#position_id'),
        _subdepartment_id = $('#subdepartment_id');

    $(".datepicker").datetimepicker({
        format: "Y-m-d",
        closeOnDateSelect: true,
        yearEnd: new Date().getFullYear(),
        dayOfWeekStart: 1,
        timepicker: false
    });
    $('input[type="password"]').popover({
        trigger: 'focus'
    });


    function checkPositionIfEmpty(){
        if (_department_id.val() && !_position_id.val()){
            _department_id.trigger('change');
        }
    };



    _department_id.on('change', function () {
        var _this = $(this), department_id = _this.val(), request;

        if (!department_id) {
            return false;
        }

        _department_id.attr("disabled", true);
        //_position_id.find("option:not(:first)").remove();
        _position_id.find("option").remove();
        //_subdepartment_id.find("option:not(:first)").remove();
        _subdepartment_id.find("option").remove();

        $("#position").hide();
        $("#subdepartment").hide();

        request = $.ajax({
            url: baseUrl + '/department/children',
            type: 'GET',
            dataType: 'json',
            data: {
                department_id: department_id
            }
        });
        request.done(function (data) {
            var i, l;
            if (data.success) {
                if (data.type == "positions") {
                    if (data.child.length) {
                        _position_id.append("<option value=''>Select</option>");
                        for (i = 0, l = data.child.length; i < l; i++) {
                            _position_id.append("<option value='" + data.child[i].id + "'>"+ data.child[i].title +"</option>");
                        }
                        _position_id.append("<option value='other'>Other</option>");
                    }
                    _subdepartment_id.attr("required", false);
                    $('#position').show();
                    _position_id.trigger('change');
                } else if (data.type == "subdepartments") {
                    if (data.child.length) {
                        _subdepartment_id.append("<option value=''>Select</option>");
                        for (i = 0, l = data.child.length; i < l; i++) {
                            _subdepartment_id.append("<option value='" + data.child[i].id + "'>"+ data.child[i].name +"</option>");
                        }
                    }
                    _subdepartment_id.attr("required", true);
                    $('#subdepartment').show();
                    _subdepartment_id.trigger('change');

                }
            } else {
                showMessage(data.message, "Error!", MESSAGE_DANGER, $("#messages"));
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "AJAX Error!", MESSAGE_DANGER, $("#messages"));
        });
        request.always(function() {
            _department_id.attr("disabled", false);
        });
    });//.trigger('change');

    /**
     * On change sub department select box event handler
     * @return void
     */
    _subdepartment_id.on("change", function() {
        var _this = $(this), sub_department_id = _this.val(), request;

       /* if (!sub_department_id) {
            return false;
        }*/

        _this.attr("disabled", true);
        _position_id.find("option").remove();
        //_position_id.find("option:not(:first)").remove();
        _position_id.show().attr("disabled", true);
        $("#position").show();
        request = $.ajax({
            url: baseUrl + '/position/ajax-positions',
            type: 'GET',
            dataType: 'json',
            data: {
                sub_department_id: sub_department_id,
                department_id: _department_id.val()
            }
        });
        request.done(function (data) {
            var i, l;
            if (typeof data.success !== "undefined") {
                if (data.positions.length) {
                    _position_id.append("<option value=''>Select</option>");
                    for (i = 0, l = data.positions.length; i < l; i++) {
                        _position_id.append("<option value='" + data.positions[i].id + "'>"+ data.positions[i].name +"</option>");
                    }
                }
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "AJAX Error!", MESSAGE_DANGER, $("#messages"));
        });
        request.always(function() {
            _this.attr("disabled", false);
            _position_id.attr("disabled", false);
            _position_id.append("<option value='other'>Other</option>");
            _position_id.trigger('change');
        });
    });

    /**
     * On change position event handler
     * @return void
     */
    _position_id.on("change", function() {
        var _this = $(this), _other_position = $('#other_position');
        if (_this.val() == 'other') {
            _other_position.show();
            $("#other_position_value").attr("required", true);
        } else {
            _other_position.hide();
            $("#other_position_value").attr("required", false);
        }
    });

    Add_Date_Format('dMY');
    var staff_travel = $('.staff_travel');
    var tr_data = $('tr.data');

    staff_travel.on('click', 'span.edit', function () {
          var _this = $(this), parent = _this.parents('tr.data'),
        inputs = parent.find('input'), selects = parent.find('select');
        if (inputs.attr('disabled')) {
            parent.find('input').removeAttr('disabled')
                                .removeClass('no_borders');
            _this.attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');
            selects.removeAttr('disabled');
        }
        else {
            parent.find('input').attr('disabled', 'disabled');
            selects.attr('disabled', 'disabled');
        }
    }).on('click', 'span.save', function () {
         var _this = $(this), parent = _this.parents('tr.data'), condition = parent.find('select').val(),
             parent_mytable = _this.parents('.mytable'), user_id = parent_mytable.attr('data-user_id'), request,
             table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
             from_date = parent.find('input[name="condition_from"]').val(), to_date = parent.find('input[name="condition_to"]').val(),
             message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');


        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-user-history",
            type: 'GET',
            dataType: 'json',
            data: {
                user_id       : user_id,
                table         : table,
                condition_id  : condition,
                from_date     : from_date,
                to_date       : to_date,
                date_format   : date_format,
                history_id    : history_id
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                if (data.success)
                    getMessageDiv("Success", message_div, data.message);
                else
                    getMessageDiv("Error", message_div,'Error! Changes Not Saved.');

                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
        });

        request.always(function () {
            parent.find('input').attr('disabled', 'disabled')
                                .addClass('no_borders');

            _this.attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
        })


    }).on('click', 'span.remove', function () {
        var _this = $(this);
        _this.confirm({
            text: 'Are You Sure You want to Remove This ?',
            title: 'Profile Update',
            confirm: function (button) {
                deleteUserHistory(_this);
            },
            cancel: function (button) {
                //
            },
            confirmButton: "Yes",
            cancelButton: "No",
            post: true,
            confirmButtonClass: "btn-primary"
        });

    });

    function deleteUserHistory(element){
        var _this = $(element), parent = _this.parents('tr.data'), condition = parent.find('select').val(),
            parent_mytable = _this.parents('.mytable'), user_id = parent_mytable.attr('data-user_id'), request,
            table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
            from_date = parent.find('input[name="condition_from"]').val(), to_date = parent.find('input[name="condition_to"]').val(),
            message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');

        request = $.ajax({
            url: baseUrl + "/change-record/ajax-remove-user-history",
            type: 'POST',
            dataType: 'json',
            data: {
                user_id: user_id,
                table: table,
                condition_id: condition,
                from_date: from_date,
                to_date: to_date,
                date_format: date_format,
                history_id: history_id
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                if (data.success) {
                    getMessageDiv("Success", message_div, data.message);

                }
                else {
                    getMessageDiv("Warning", message_div, data.message);
                    _this.parent().prev().find('span').attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
                }
                parent.remove();
                Cancel_Change();

            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_div, 'Error! Changes Not Saved.');
        });

        request.always(function () {
            parent.find('input').attr('disabled', 'disabled');
        });
    }

    staff_travel.on('click', 'a.add', function () {
        var _this = $(this), parent = _this.parents('.staff_travel'), row = parent.find('tbody > tr[class="data"]:last'),
            duplicate = row.clone(), label = duplicate.find('label').text(), inputs = duplicate.find('input'),
            selects =  duplicate.find('select'), checkboxes =  duplicate.find('input[type="checkbox"]');

        if (label.length > 0){
            label = parseInt(label);
            duplicate.find('label').text(++label);
        }
       duplicate.attr('data-history_id', 'add');
       duplicate.find('span.edit').attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');

       inputs.val('')
             .removeAttr('disabled')
            .removeClass('no_borders');
       selects.val('')
              .removeAttr('disabled');
       checkboxes.prop('checked', false)
                 .removeAttr('disabled');

        duplicate.insertAfter(row);
        Add_Date_Format('dMY');
    });

    staff_travel.on('click', 'a.check', function () {
        var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'),
            marital_status = parent.attr('data-marital_status'), relationship, nominee,
            relationships_single = parent.find('input[name="relationships_single"]').val(),
            relationships_married = parent.find('input[name="relationship_married"]').val();

        console.log($.isObject(relationships_single))
        console.log(relationships_single)
        rows.each(function () {
            relationship = $(this).find('select[name="relationship_id"]');
            nominee = $(this).find('input[name="is_nominee"]');
            switch (marital_status){
                case "Single":

                    break;
                case "Married":
                    break;
                default :
                    break;
            }
        })
    });

    staff_travel.on('click', 'a.remove', function () {
        var _this = $(this), parent = _this.parents('.staff_travel'), all_rows = parent.find('tbody > tr[class="data"]'),
            row = all_rows.last();

        row.remove();
    });

    staff_travel.on('click', 'a.save', function () {
        var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'), records,
            data = [], select, input, i = 0, property, omit = false, request, user_id = parent.attr('data-user_id'),
            table = parent.attr('data-table'), date_format = parent.attr('data-date_format'), nominee,
            checkbox = rows.find('input[type="checkbox"]:checked'), message_div = parent.parents('div.active');


        if (checkbox.length > 3) {
            getMessageDiv("Warning", message_div, "Warning. Only 3 Nominees Are Allowed. Please Pick Not More Than 3.");
            return false;
        }

        rows.each(function () {
            data[i] = {};
            omit = false;
            records = $(this).find('td');
            records.each(function () {
                select = $(this).find('select');
                input = $(this).find('input');
                nominee = $(this).find('input[type="checkbox"]');

                if (select.length > 0) {
                    property = select.attr('name');
                    data[i][property] = select.val();
                }
                else if (nominee.length > 0){
                    property = nominee.attr('name');
                    data[i][property] = nominee.is(':checked') ? 1 : 0;
                }
                else {
                    property = input.attr('name');
                    data[i][property] = input.val();
                }
                if (select.val() == '' || input.val() == '') {
                    omit = true;
                    data[i] = null;
                    return false;
                }
            });
            if (omit == false)
                i++;
            else
                omit = false;
        });

        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-records",
            type: 'POST',
            dataType: 'json',
            data: {
                user_id : user_id,
                table : table,
                data : data,
                date_format : date_format
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_div, data.message);
                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
        });

    });

    var parent = $(".details");
    parent.on('dblclick', 'p.editable_values', function () {
        // Cancel All Others
        Cancel_Change();
        var _this = $(this), _content = _this.children(), oriVal = _this.text(), item = _this.attr('data-item'),
            table = _this.attr('data-table'), date_format = _this.attr('data-date_format'),
            var_type = _this.attr('data-var_type'), options, selected_values, original_value,
            parent = _this.parents('.details'), type = parent.attr('data-type'), input, save;

        _this.text("");

        if (typeof var_type !== 'undefined'){
            if (item == 'nationality'){
                input = $("<select class='editable'></select>");
                options = Nationalities();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'birth_place'){
                input = $("<select class='editable'></select>");
                options = CountryList();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'languages'){
                input = $("<select class='multiselect editable' multiple='multiple'></select>");
                selected_values = oriVal.split(", ");
                options = Languages();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });

                input.val(selected_values);

            }
            else if (item == 'location'){
                input = $("<select class='editable margin_right'></select>");
                options = Location_Bases();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'marital_status'){
                input = $("<select class='editable margin_right'></select>");
                options = Marital_Status();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });

                input.val(oriVal);
            }
            else if (item == 'english_level'){
                input = $("<select class='editable margin_right'></select>");
                options = English_Levels();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'aircraft_types') {
                input = $("<select class='multiselect editable' multiple='multiple'></select>");
                selected_values = oriVal.split(", ");
                options = Get_Aircraft('type', 'static');
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(selected_values);

            }
            else if ($.inArray(item, ['is_captain', 'is_purser']) != -1){
                oriVal = _content;
                input = $('<input />', { type: 'checkbox', name: 'crew_designation',  class:'editable' });
                //input = $("<input type='checkbox' class='editable' />");
                if (_content.hasClass('glyphicon-ok')) {
                    input.attr('checked', true);
                }
                else
                    input.attr('checked', false);

            }
            else
                input = $("<input class = 'editable long' type='text' value='"+oriVal+"' />");
        }
        else {
            input = $("<input class = 'date_format editable' type='text' value='"+oriVal+"' />");
        }

        original_value = $("<input class = 'original_value editable long' type='hidden' value='"+oriVal+"' />");

        save = $('<div class="btn-group change_values"><a href="#" class="btn btn-sm btn-primary" id="save_changes">Save</a>' +
        '<a href="#" class="btn btn-sm btn-warning" id="empty_text">Empty</a>'+'<a href="#" class="btn btn-sm btn-danger" id="cancel_changes">Cancel</a>');

        input.appendTo(_this);
        original_value.appendTo(_this);
        save.appendTo(_this);
        Add_Date_Format(date_format);
        Apply_Multiselect();
        input.focus();
        Load_Buttons();
    });


    parent.on('click', '#save_changes', function () {
        var _this = $(this),
        value, p_editable = _this.parents('p.editable_values'),
        date_format = p_editable.attr('data-date_format'), item = p_editable.attr('data-item'), table = p_editable.attr('data-table'),
        input = p_editable.find('input.editable').not('[type=hidden]'), originalValue = p_editable.find('input.original_value').val(),
        select = p_editable.find('select'), div_active = _this.parents('div.active'),
        grandparent = _this.parents('.details'), type = grandparent.attr('data-type'), id = grandparent.attr('data-user_id');

        if (typeof date_format === 'undefined'){
            date_format = "not_applicable";
        }
        if (input.length > 0) {
            if (input.attr('type') == 'checkbox') {
                if ($(input).prop('checked'))
                    value = 1;
                else
                    value = 0;
            }
            else
                value = input.val();
        }
        else if (select.length > 0){
            value = select.val();
        }

        console.log(select.val())
        if (originalValue != value){
            AjaxSaveChanges(id, value, item, div_active, type, table, date_format);
        }

    });

    function AjaxSaveChanges(id, value, item, parent, type, table, date_format){
        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-changes",
            type: 'POST',
            dataType: 'json',
            data: {
                type        : type,
                table       : table,
                crew_id     : id,
                item        : item,
                value       : value,
                date_format : date_format
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", parent, data.message);
                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", parent,'Error! Changes Not Saved.');
        });
    }

    function Load_Buttons(){

        $('#cancel_changes').click(function () {
            Cancel_Change();
        });

        $('#empty_text').click(function () {
            var _this =  $('input.date_format.editable');
            _this.val("");
        });

        $('input.date_format.editable').on('change', function () {
            $(this).addClass('edited');
        })
    }

    function Cancel_Change(){
        var _this = $('p.editable_values > input.editable[type="text"]'), value, is_checkbox = 0;
        if (_this.length == 0)
            _this = $('p.editable_values > select.editable');
        if (_this.length == 0) {
            _this = $('p.editable_values > input.editable[type="checkbox"]');
            is_checkbox = 1;
        }

        if (is_checkbox == 1) {
            value = _this.is(':checked');
            if (value)
                value = '<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>';
            else
                value = '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>';

            _this.parent().html(value);
        }
        else {
            value = _this.val();
            if ($.isArray(value)) {
                value = value.join(', ');
            }

            _this.parent().text(value);
        }

        _this.remove();

    }





});