
$(document).on('change', 'select[name=structure_department_id]', function () {
    select_department_change($(this));
});


/**
 * Department Change Event Listener
 * @param _this
 */
function select_department_change(_this) {
    var department_id = _this.val(), positions = $('select[name=structure_position_id]'),
        parent = positions.parents('div.form-group').first(), grand_parent = _this.parents('.active');

    if (positions.length){
        parent.remove();
    }

    if (department_id) {

        $.get(baseUrl + '/template/ajax-positions-by-department-id', {
            'department_id'     : department_id,
            'additional_class'  : 'form-group'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    //data = $(data);
                    grand_parent.append(data);
                    console.log(grand_parent)
                    //Apply_Multiselect(grand_parent);
                }
            });
    }
}


var staff_travel = $(document).find('.staff_travel');
var tr_data = $(document).find('tr.data');

staff_travel.on('click', 'span.edit', function () {
    var _this = $(this), parent = _this.parents('tr.data'), parent_mytable = _this.parents('table'),
        inputs = parent.find('input'), selects = parent.find('select'),
        date_format_inputs = parent.find('input.date_format'),
        date_format = parent_mytable.attr('data-date_format');

    if (inputs.attr('disabled')) {
        parent.find('input').removeAttr('disabled')
            .removeClass('no_borders');
        _this.attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');
        selects.removeAttr('disabled');
        AddDateFormatElement(date_format_inputs, date_format);
    }
    else {
        parent.find('input').attr('disabled', 'disabled');
        selects.attr('disabled', 'disabled');
    }

    return false;
})
    .on('click', 'span.save', function () {
        var _this = $(this), parent = _this.parents('tr.data'),
            condition = parent.find('select[name=condition]').val(),
            airline_id = parent.find('select[name=airline_id]').val(),
            parent_mytable = _this.parents('table'), user_id = parent_mytable.attr('data-user_id'), request,
            table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
            from_date = parent.find('input[name="condition_from"]').val(),
            to_date = parent.find('input[name="condition_to"]').val(),
            notes = parent.find('input[name="notes"]').val(),
            message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');


        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-user-history",
            type: 'GET',
            dataType: 'json',
            data: {
                user_id       : user_id,
                table         : table,
                condition_id  : condition,
                airline_id    : airline_id,
                from_date     : from_date,
                to_date       : to_date,
                date_format   : date_format,
                history_id    : history_id,
                notes    : notes
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                if (data.success){
                    parent.attr('data-history_id', data.history_id);
                    getMessageDiv("Success", message_div, data.message);
                }
                else
                    getMessageDiv("Error", message_div,'Error! Changes Not Saved.');

                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
        });

        request.always(function () {
            parent.find('input').attr('disabled', 'disabled')
                .addClass('no_borders');

            parent.find('select').attr('disabled', 'disabled');

            _this.attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
        });

        return false;

    }).on('click', 'span.remove', function () {

        var _this = $(this);

        _this.confirm({
            text: 'Are You Sure You want to Remove This ?',
            title: 'Profile Update',
            confirm: function (button) {
                deleteUserHistory(_this);
            },
            cancel: function (button) {
                //
            },
            confirmButton: "Yes",
            cancelButton: "No",
            post: true,
            confirmButtonClass: "btn-primary"
        });

        return false;

    });

function deleteUserHistory(element){
    var _this = $(element), parent = _this.parents('tr.data'),
        condition = parent.find('select[name=condition]').val(), airline_id = parent.find('select[name=airline_id]').val(),
        parent_mytable = _this.parents('.mytable'), user_id = parent_mytable.attr('data-user_id'), request,
        table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
        from_date = parent.find('input[name="condition_from"]').val(),
        to_date = parent.find('input[name="condition_to"]').val(),
        notes = parent.find('input[name="notes"]').val(),
        message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');

    request = $.ajax({
        url: baseUrl + "/change-record/ajax-remove-user-history",
        type: 'GET',
        dataType: 'json',
        data: {
            user_id       : user_id,
            table         : table,
            condition_id  : condition,
            airline_id  : airline_id,
            from_date     : from_date,
            to_date       : to_date,
            date_format   : date_format,
            history_id    : history_id,
            notes         : notes,
        }
    });

    request.done(function (data) {
        console.log(data)
        if (typeof data.success !== 'undefined') {
            if (data.success) {
                getMessageDiv("Success", message_div, data.message);

            }
            else {
                getMessageDiv("Warning", message_div, data.message);
                _this.parent().prev().find('span').attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
            }
            parent.remove();
            Cancel_Change();

        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_div, 'Error! Changes Not Saved.');
    });

    request.always(function () {
        parent.find('input').attr('disabled', 'disabled');
    });
}

staff_travel.on('click', 'a.add', function () {
    var _this = $(this), parent = _this.parents('tr'), row = parent.prev(), //.find('tbody > tr[class="data"]:last'),
        duplicate = row.clone(), label = duplicate.find('label').text(), inputs = duplicate.find('input'),
        selects =  duplicate.find('select'), checkboxes =  duplicate.find('input[type="checkbox"]');

    console.log(label.length);

    if (label.length > 0){
        label = parseInt(label);
        duplicate.find('label').text(++label);
    }
    duplicate.attr('data-history_id', 'add');
    duplicate.find('span.edit').attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');

    inputs.val('')
        .removeAttr('disabled')
        .removeClass('no_borders');
    selects.val('')
        .removeAttr('disabled');
    checkboxes.prop('checked', false)
        .removeAttr('disabled');

    duplicate.insertAfter(row);
    ApplyDateFormatToInputs(duplicate);
    // ApplyDateFormats();

    return false;

});


function ApplyDateFormatToInputs(parentElement) {
    parentElement.find(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    parentElement.find(".datetimepicker-current").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1,
        // maxDate: new Date(moment.utc().format("YYYY-MM-DD HH:mm")),
        onChangeDateTime: function(date, $input) {
            var maxDate = moment.utc().format("YYYY-MM-DD HH:mm");
            if (moment(maxDate).isBefore(moment(date))) {
                alert("Time is in future!");
                $input.val("");
            }
        }
    });
}

staff_travel.on('click', 'a.check', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'),
        marital_status = parent.attr('data-marital_status'), relationship, nominee,
        relationships_single = parent.find('input[name="relationships_single"]').val(),
        relationships_married = parent.find('input[name="relationship_married"]').val();

    console.log($.isObject(relationships_single))
    console.log(relationships_single)
    rows.each(function () {
        relationship = $(this).find('select[name="relationship_id"]');
        nominee = $(this).find('input[name="is_nominee"]');
        switch (marital_status){
            case "Single":

                break;
            case "Married":
                break;
            default :
                break;
        }
    })

    return false;

});

staff_travel.on('click', 'a.remove', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), all_rows = parent.find('tbody > tr[class="data"]'),
        row = all_rows.last();

    row.remove();

    return false;

});

staff_travel.on('click', 'a.save', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'), records,
        data = [], select, input, i = 0, property, omit = false, request, user_id = parent.attr('data-user_id'),
        table = parent.attr('data-table'), date_format = parent.attr('data-date_format'), nominee,
        checkbox = rows.find('input[type="checkbox"]:checked'), message_div = parent.parents('div.active');


    if (checkbox.length > 3) {
        getMessageDiv("Warning", message_div, "Warning. Only 3 Nominees Are Allowed. Please Pick Not More Than 3.");
        return false;
    }

    rows.each(function () {
        data[i] = {};
        omit = false;
        records = $(this).find('td');
        records.each(function () {
            select = $(this).find('select');
            input = $(this).find('input');
            nominee = $(this).find('input[type="checkbox"]');

            if (select.length > 0) {

                property = select.attr('name');
                if (select.val() !== "") {
                    data[i][property] = select.val();
                }

            }
            else if (nominee.length > 0){
                property = nominee.attr('name');
                data[i][property] = nominee.is(':checked') ? 1 : 0;
            }
            else {
                property = input.attr('name');
                data[i][property] = input.val();
            }
            if (select.val() == '' || input.val() == '') {
                omit = true;
                data.splice(i, 1);
                return false;
            }
        });
        if (omit == false)
            i++;
        else
            omit = false;

        console.log(data)

    });

    request = $.ajax({
        headers: {
            'x-csrf-token': $(this).parents('form').find('input[name=_token]').val()
        },
        url: baseUrl + "/change-record/ajax-save-records",
        type: 'POST',
        dataType: 'json',
        data: {
            user_id : user_id,
            table : table,
            data : data,
            date_format : date_format
        }
    });

    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            getMessageDiv("Success", message_div, data.message);
            Cancel_Change();
        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
    });

    return false;

});

function Cancel_Change(){
    var _this = $('p.editable_values > input.editable[type="text"]'), value, is_checkbox = 0;
    if (_this.length == 0)
        _this = $('p.editable_values > select.editable');
    if (_this.length == 0) {
        _this = $('p.editable_values > input.editable[type="checkbox"]');
        is_checkbox = 1;
    }

    if (is_checkbox == 1) {
        value = _this.is(':checked');
        if (value)
            value = '<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>';
        else
            value = '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>';

        _this.parent().html(value);
    }
    else {
        value = _this.val();
        if ($.isArray(value)) {
            value = value.join(', ');
        }

        _this.parent().text(value);
    }

    _this.remove();
}

