/**
 * Created by Dilovar Tursunov on 27.08.14.
 */

"use strict";

var _MS_PER_DAY = 1000 * 60 * 60 * $timelinePeriod,
    FLIGHT_CREW_CAPTAINS = "captains",
    FLIGHT_CREW_FIRST_OFFICERS = "first_officers",
    FLIGHT_CREW_FLIGHT_ATTENDANTS = "flight_attendants",
    T_FLIGHT = "flight",
    T_LEAVE = "leave",
    FLIGHT_AVAILABLE = "available",
    FLIGHT_DELAYED = "delayed",
    FLIGHT_CANCELLED = "cancelled",
    FLIGHT_DIVERTED = "diversion",
    MAX_HOURS_FOR_MOVE = $timelinePeriod,

    CREW_TYPE_SUP = "SUP",
    CREW_TYPE_STANDBY = "STANDBY",
    CREW_TYPE_DHC = "DHC",
    CREW_TYPE_IN_FLIGHT = "IN_FLIGHT",

    EMPTY_DATE = "0000-00-00",
    EMPTY_TIME = "00:00:00",
    EMPTY_DATETIME = "0000-00-00 00:00:00",

    timeline = null,
    inputDateFormat = "YYYY-MM-DD HH:mm:ss",
    outputDateOnlyFormat = "MMM DD",
    outputDateFormat = "MMM DD, HH:mm",
    outputTimeFormat = "HH:mm",

    popupFlight = null,
    messageBlock = $("#fleetwatch_message_block"),
    flight_info_modal = $("#flight_info_modal"),
    DEPARTURE_SERVICE = "departure_service",
    ARRIVAL_SERVICE = "arrival_service",
    TURNAROUND_SERVICE = "turnaround_service";

    function initializeTime(){
        updateTime();
        window.setInterval(updateTime, 1000);
    }

    initializeTime();
    /**
     * Time UTC in Real Time
     */
    function updateTime(){
        var timeNow = $('#timeNow'), now;
        if (timeNow.length > 0){
            //   time.innerText = new Date().toUTCString();
            now = new Date().toUTCString();
            now = now.split(' ')[4];
            timeNow.text(now +" GMT");
        }
    }

    try {
        google.load("visualization", "1");
    }
    catch(e){
        // Nothing
    }

    $(document).ready(function(){

        google.setOnLoadCallback(drawVisualization);

    });

    // Set callback to run when API is loaded


    // Called when the Visualization API is loaded.
    function drawVisualization() {

        // Create and populate a data table.
        try {
            var data = new google.visualization.DataTable();
        }
        catch(e){
            return;
        }

        var today = new Date(), date = new Date(), date2 = new Date(),
            start_time = date.setHours(date.getHours() - 12),
            end_time = date2.setHours(date2.getHours() + 12);

        start_time = moment(start_time).utc();
        end_time = moment(end_time).utc();

        var visibleYear = date.getFullYear() + 2,
            visibleMonth = date.getMonth(),
            visibleDay = date.getDate();

        // if was set go to date, use it as default date for timeline
        if (typeof goToDate !== "undefined" && goToDate != false) {
            date = new Date(goToDate);
            date2 = new Date(goToDate);
            start_time = date.setHours(0, 0, 0);
            end_time = date2.setHours(23, 59, 59);
            var d = date, d2 = date2,
                start_visible_time = moment(d.setHours(today.getHours() - 12)).format("YYYY-MM-DD HH:mm:ss"),
                end_visible_time = moment(d2.setHours(today.getHours() + 12)).format("YYYY-MM-DD HH:mm:ss");


            $("#start_visible_period").val(start_visible_time);
            $("#end_visible_period").val(end_visible_time);
        }

        start_time = moment(start_time).format("YYYY-MM-DD HH:mm:ss");
        end_time = moment(end_time).format("YYYY-MM-DD HH:mm:ss");


        if (typeof startVisibleDate !== "undefined" && startVisibleDate != false && typeof endVisibleDate !== "undefined" && endVisibleDate != false) {
            start_time = moment(startVisibleDate).format("YYYY-MM-DD HH:mm:ss");
            end_time = moment(endVisibleDate).format("YYYY-MM-DD HH:mm:ss");
        }


        data.addColumn("datetime", "start");
        data.addColumn("datetime", "end");
        data.addColumn("string", "content");
        data.addColumn("string", "group");
        data.addColumn("string", "className");

        if (json.length) {
            var flights = prepareDataForTimeline(json);
            data.addRows(flights);
        }

        // specify options
        var options = {
            clusterMaxItems: 50,
            stackEvents: true,
            //start: start_time,
            //end: end_time,
            editable: true,
            animate: true,
            eventMargin: 1,
            eventMarginAxis: 2,
            cluster: true,
            axisOnTop: true,
            snapEvents: false,
            dragAreaWidth: 10,
            groupMinHeight: 35,
            groupsWidth: $groupsWidth,
            // min: new Date(2013, 1, 1),
            max: new Date(visibleYear, visibleMonth, visibleDay),     // upper limit of visible range
            zoomable: false,
            zoomMin: 1000 * 60 * 60 * $timelinePeriod,     // 4 hours in milliseconds
            zoomMax: 1000 * 60 * 60 * $timelinePeriod,     // 7 days in milliseconds
            showButtonNew: false,
            showNavigation: false,
            showMajorLabels: true,
            width: "100%",
            height: "auto",
            layout: "box",
            /* Have disabled on Nov 15, 19 */
            groupsChangeable: true,
            groupsOrder: function (a, b) {
                if (a.content == b.content) {
                    return 0;
                }
                return (a.content < b.content) ? -1 : 1;
            }
        };

        // Instantiate our timeline object
        timeline = new links.Timeline(document.getElementById("mytimeline"));

        // Draw our timeline with the created data and options
        timeline.setOptions(options);

        timeline.draw(data);
        //timeline.draw(data, options);

        //new Date(year, month, day, hours, minutes, seconds, milliseconds)
        var start = new Date(
            moment(start_time).get('year'),
            moment(start_time).get('month'),
            moment(start_time).get('date'),
            moment(start_time).get('hour'),
            moment(start_time).get('minute'),
            moment(start_time).get('second')
        );

        var end = new Date(
            moment(end_time).get('year'),
            moment(end_time).get('month'),
            moment(end_time).get('date'),
            moment(end_time).get('hour'),
            moment(end_time).get('minute'),
            moment(end_time).get('second')
        );


        timeline.setVisibleChartRange(start, end);

        var now = new Date();
        var current_datetime = moment({
            year: now.getUTCFullYear(),
            month: now.getUTCMonth(),
            day: now.getUTCDate(),
            hour: now.getUTCHours(),
            minute: now.getUTCMinutes(),
            second: now.getUTCSeconds()
        });

        timeline.setCurrentTime(current_datetime);

        //
        /**
         * Delete flight item event listener
         * @return void
         */
        google.visualization.events.addListener(timeline, "delete",
            function () {
                timeline.cancelDelete();

                if (!editable) {
                    // My Temp Edit
                    return false;
                }

                return false;

                var sel = timeline.getSelection(), row;
                if (sel.length) {
                    if (sel[0].row != undefined) {
                        row = sel[0].row;
                    }
                }

                bootbox.confirm("Flight will be cancelled, are you sure?", function (result) {
                    if (result) {
                        var $body = $("body"), flightData = getSelectedEvent(),
                            request, requestData = $.ajaxSetup({
                                type: "GET",
                                dataType: "json"
                            });

                        if (!flightData) {
                            return false;
                        }

                        $body.addClass("loading");
                        if (flightData.type == T_LEAVE) {
                            requestData = {
                                url: baseUrl + "/aircraft/ajax-delete-leave",
                                data: {
                                    leave_id: flightData.id
                                }
                            };
                        } else if (flightData.type == T_FLIGHT) {
                            requestData = {
                                url: baseUrl + "/flight/ajax-delete-flight",
                                data: {
                                    flight_id: flightData.id
                                }
                            };
                        }
                        request = $.ajax(requestData);
                        request.done(function (data) {
                            if (typeof data.success !== "undefined") {
                                showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                                if (flightData.type == T_FLIGHT) {
                                    // clear the bottom form
                                    clearFlightForm();
                                } else if (flightData.type == T_LEAVE) {
                                    //
                                }
                                timeline.deleteItem(row);
                            }
                        });
                        request.fail(function (jqXHR, textStatus) {
                            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                        });
                        request.always(function () {
                            $body.removeClass("loading");
                        });
                    } else {
                        timeline.setSelection([]);
                    }
                });
            }
        );

        /**
         * Change flight item position event listener
         * @return void
         */
        google.visualization.events.addListener(timeline, "changed",
            function () {
                var sel = timeline.getSelection();
                // My Temp Edit
                timeline.cancelChange();

                //console.log(timeline)
                return false;
                ///

                if (sel.length) {
                    if (sel[0].row != undefined) {
                        var row = sel[0].row;
                        var item = timeline.getItem(row);
                    }
                }

                if (typeof item === "undefined") {
                    timeline.cancelChange();
                    timeline.setSelection([]);
                    return false;
                }

                var content = $(item.content), id = content.data("id"), flightID = content.data("flight_id");

                //console.log("id: "+id);
                //console.log(item);

                // validate available hours
                var arrivalDate = moment(item.end),
                    duration = moment.duration(moment().diff(arrivalDate)),
                    hours = duration.asHours();

                if (hours > MAX_HOURS_FOR_MOVE) {
                    showMessage("Flight cannot be updated due to exceeding  " + MAX_HOURS_FOR_MOVE + " hours period", "Warning!",
                        MESSAGE_WARNING, messageBlock);
                    timeline.cancelChange();
                    return false;
                }

                if (confirm("Flight dates was changed. Do you want to save change?") === true) {
                    var $body = $("body"), flightData = getSelectedEvent(),
                        startTime = moment(itemFlight.start).format("YYYY-MM-DD HH:mm:ss"),
                        endDate = moment(itemFlight.end).format("YYYY-MM-DD HH:mm:ss"),
                        request, requestData = $.ajaxSetup({
                            type: "GET",
                            dataType: "json"
                        });

                    if (!flightData) {
                        return false;
                    }

                    $body.addClass("loading");
                    if (flightData.type == T_LEAVE) {
                        requestData = {
                            url: baseUrl + "/aircraft/ajax-change-leave",
                            data: {
                                start_date: startTime,
                                end_date: endDate,
                                leave_id: flightData.id,
                                aircraft_name: itemFlight.group
                            }
                        };
                    } else if (flightData.type == T_FLIGHT) {
                        requestData = {
                            url: baseUrl + "/flight/ajax-change-flight",
                            data: {
                                start_date: startTime,
                                end_date: endDate,
                                flight_id: flightData.id,
                                aircraft_name: itemFlight.group
                            }
                        };
                    }
                    request = $.ajax(requestData);
                    request.done(function (data) {
                        if (typeof data.success !== "undefined") {
                            showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                            if (flightData.type == T_FLIGHT) {
                                //
                            } else if (flightData.type == T_LEAVE) {
                                //
                            }

                        } else {
                            showMessage(data.message, data.title, MESSAGE_DANGER, messageBlock);
                            timeline.setSelection([]);
                            timeline.changeItem(row, itemFlight);
                        }
                        // update page
                        window.location = baseUrl + "/fleetwatch/index?go_to_date=" + moment(itemFlight.start).format("YYYY-MM-DD");
                    });
                    request.fail(function (jqXHR, textStatus) {
                        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                    });
                    request.always(function () {
                        $body.removeClass("loading");
                    });
                } else {
                    timeline.cancelChange();
                    timeline.setSelection([]);
                    return false;
                }
            }
        );

        /**
         * Timeline range was changed event handler
         * @return void
         */
        google.visualization.events.addListener(timeline, "rangechanged",
            function (dates) {
                var now = new Date();

                /*
                 if ((dates.start <= now && now <= dates.end) && dateDiffInDays(dates.start, dates.end) <= 4) {
                 // range is not changed so many to send AJAX request
                 return false;
                 }
                 */

                var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
                    airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

                var item;
                $.each(airportSelected, function(i, item){
                    if (item = $(item).attr("data-id")){
                        airportIDs.push(item);
                    }
                });

                $.each(airlineSelected, function(i, item){
                    if (item = $(item).attr("data-id")){
                        airlineIDs.push(item);
                    }
                });

                var request, loading = $("#loading-fleetwatch-data"),
                    requestData = {
                        type: "GET",
                        dataType: "JSON",
                        url: baseUrl + "/staff-watch/ajax-get-range",
                        data: {
                            airport_id: airportIDs,
                            airline_id: $("#airline").val(), //airlineIDs,
                            start_date: moment(dates.start).format("YYYY-MM-DD HH:mm:ss"),
                            end_date: moment(dates.end).format("YYYY-MM-DD HH:mm:ss"),
                            occ     : $("a#occ_sla").hasClass("btn-warning") ? 1 : 0

                        }
                    };

                loading.show();
                request = $.ajax(requestData);
                request.done(function (data) {
                    if (typeof data.success !== "undefined") {
                        var flights = [], flightItem, leaveItem, flt, jsonData = data.jsonData;
                        // recreate timeline
                        /*if (typeof data.flights !== "undefined" && data.flights.length) {
                         for (i = 0, l = data.flights.length; i < l; i++) {
                         flightItem = data.flights[i];
                         flt = {
                         "start": getStartDate(flightItem),
                         "end": getEndDate(flightItem),
                         "group": getFlightGroup(flightItem),
                         "className": getFlightClassName(flightItem)
                         };

                         flt.content = getFlightContent(flightItem, flt.start, flt.end);

                         flights.push(flt);
                         }
                         }

                         if (typeof data.aircraftLeave !== "undefined" && data.aircraftLeave.length) {
                         for (i = 0, l = data.aircraftLeave.length; i < l; i++) {
                         leaveItem = data.aircraftLeave[i];
                         flights.push({
                         "start": moment(leaveItem.arrival_time).toDate(),
                         "end": moment(leaveItem.departure_time).toDate(),
                         "content": getLeaveContent(leaveItem),
                         "group": getFlightGroup(leaveItem),
                         "className": FLIGHT_LEAVE
                         });
                         }
                         }*/
                        flights = prepareDataForTimeline(jsonData, true);
                        //if (flights.length) {
                            timeline.setData(flights);
                            timeline.redraw();
                        //}

                        // Update Flight tracker
                        // updateFlightTracker(data);

                    } else {
                        showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
                    }
                    $("#start_visible_period").val(moment(dates.start).format("YYYY-MM-DD HH:mm:ss"));
                    $("#end_visible_period").val(moment(dates.end).format("YYYY-MM-DD HH:mm:ss"));

                });
                request.fail(function (jqXHR, textStatus) {
                    showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                });
                request.always(function () {
                    loading.hide();
                });
            }
        );

        // Update Timeline Every
        window.setInterval(updateTimeline, 120000);
    }

    function resetLineSelection(){
        $("#create_all").val(0);
        $("#lineTitle").text("");
        $("#lineHeader").hide();
        $("#tableFltLine").find("tbody > tr").remove();
    }

    $(document).on("click", "a#save_line", function(){
        var _this = $(this), header = _this.parents("#lineHeader"),
            line = header.data("line"),
            rows = $(document).find("#tableFltLine > tbody > tr");

        var flightIDs = [], id, row;
        $.each(rows, function(i, item){
            row = $(item);
            if (row.find("td.checkbox-column > input").is(":checked")){
                id = row.data("id");
                if (id){
                    flightIDs.push(id)
                }
            }
        });

        //console.log(flightIDs)

        var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form input[name=_token]').val()
            },
            url:  baseUrl + "/staff-watch/save-line",
            type: 'POST',
            dataType: 'json',
            data : {
                aircraft_type_id    : $("#aircraft_type_id").val(),
                ac_type             : $("#ac_type").val(),
                aircraft_id         : $("#aircraft_id").val(),
                ac                  : $("#ac").val(),
                flight_ids          : flightIDs,
                line                : line,
            }
        });

        request.done(function (data) {
            if (typeof data.success !== "undefined") {

                if (typeof data.error !== "undefined" && data.error){
                    messageBlock.html("<span class='text-red'>" + data.message + "</span>");
                    return;
                }

                var jsonData = data.jsonData,
                    flights = prepareDataForTimeline(jsonData, true);

                if (flights.length) {
                    timeline.setData(flights);
                    timeline.redraw();
                }

                updatedAircraftByTypeAndAirlineList(data);

                // updateFlightTracker(data);

                resetLineSelection();
            }
        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
    });

    $(document).on("click", "th.checkbox-column", function(){
        var _this = $(this);

        if (_this.text() === "Select"){
            _this.parents("table").find("tbody td.checkbox-column > input").prop("checked", true);
            _this.text("Deselect");
        }
        else {
            _this.parents("table").find("tbody td.checkbox-column > input").prop("checked", false);
            _this.text("Select");
        }
    });

    $(document).on("click", "a.left_sidebar", function(){
        var _this = $(this), line =  _this.data("line"), ac = _this.text(),
            aircraftID = _this.data("ac_id"), aircraftTypeID = _this.data("ac_type_id"),
            lineHeader = $("#lineHeader"), lineTitle = $("#lineTitle"), table = $("#tableFltLine"), tableAll = $("#tableFltAll"),
            // rows = loadedAllFlights.find("tr[data-line=" + line + "]");
            rows = $(document).find("#tableFltAll tr[data-line=" + line + "]").clone();

        rows.find(".checkbox-column").show();
        rows.find("td.checkbox-column > input").prop("checked", true);
        table.find("th.checkbox-column").text("Deselect");

        $("#cancel_btn1").click();
        activateTab("flight_watch_main_tab", "flightInformationTab");
        activateTab("flight_by_type_tab", "tabLine");
        lineHeader.data("line", line);
        // lineHeader.data("ac_id", aircraftID);
        // lineHeader.data("ac_type_id", aircraftTypeID);
        lineHeader.show();
        lineTitle.text(ac);
        table.find("tbody > tr").remove();
        table.append(rows);

        //console.log("AC: " + aircraftID + " | Type: " + aircraftTypeID);

        AircraftTypeChange(false);

        AircraftChange(false, false, aircraftTypeID);

        if (aircraftID){
            $("#aircraft_id").val(aircraftID);

            if (aircraftTypeID){
                $("#aircraft_type_id").val(aircraftTypeID);
            }
        }
        else {
            $("#aircraft_type_id").val(aircraftTypeID);
        }
    });

    function activateTab(tabID, pageID){
        $('#' + tabID + ' a[href="#' + pageID + '"]').tab('show');
    };

    function updateFlightTracker(data){
        var tabDepartures = $("#tabDepartures"),
            tabArrivals = $("#tabArrivals"),
            tabAll = $("#tabAll"),
            airlinesSelector = $("#airline_id");

        var flightTables = data.flightTables;

        tabDepartures.children().remove();
        tabDepartures.html(flightTables["DEPARTURE"]);
        ApplyTableFilter("#tableFltDepartures");

        tabArrivals.children().remove();
        tabArrivals.html(flightTables["ARRIVAL"]);
        ApplyTableFilter("#tableFltArrivals");

        // loadedAllFlights = flightTables["ALL"];
        tabAll.children().remove();
        tabAll.html(flightTables["ALL"]);
        ApplyTableFilter("#tableFltAll");

        if (typeof data.airlines !== "undefined") {
            //airlinesSelector.children().remove();
            // airlinesSelector.append('<option value="">Select</option>');
            $.each(data.airlines, function (key, obj) {
                if (!airlinesSelector.find("option[value=" + obj.id+"]").length){
                    airlinesSelector.append('<option value=' + obj.id + '>' + obj.code + '</option>');
                }
            });
        }
    }

    function updateTimeline () {
        var now = new Date();

        var timeObj = timeline.getVisibleChartRange();

        var start_visible_time = moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"),
            end_visible_time = moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss"),
            start_visible_date = moment(timeObj.start),
            end_visible_date = moment(timeObj.end),
            todays_date = moment(now);

        if (start_visible_date.isAfter(todays_date, 'day') || end_visible_date.isBefore(todays_date, 'day')){
            return;
        }
        //end_visible_time = moment(now.setHours(now.getHours() + 12)).format("YYYY-MM-DD HH:mm:ss");

        var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
            airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

        $.each(airportSelected, function(i, item){
            airportIDs.push($(item).attr("data-id"));
        });

        $.each(airlineSelected, function(i, item){
            airlineIDs.push($(item).attr("data-id"));
        });

        var request, loading = $("#loading-fleetwatch-data"),
            requestData = {
                type: "GET",
                dataType: "JSON",
                url: baseUrl + "/staff-watch/ajax-get-range",
                data: {
                    airport_id: airportIDs,
                    airline_id: $("#airline").val(), //airlineIDs,
                    start_date: start_visible_time,
                    end_date:   end_visible_time,
                    flight_tracker : true,
                    occ     : $("a#occ_sla").hasClass("btn-warning") ? 1 : 0
                }
            };

        loading.show();
        request = $.ajax(requestData);
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                var jsonData = data.jsonData,
                    flights = prepareDataForTimeline(jsonData, true);

                if (flights.length) {
                    timeline.setData(flights);
                    timeline.redraw();

                    // Update Flight tracker
                    // updateFlightTracker(data);
                }
            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
            }
            $("#start_visible_period").val(start_visible_time);
            $("#end_visible_period").val(end_visible_time);

        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            loading.hide();
        });
    }

    function DisableStdSta(autoCreated) {
        var std = $('#std'), sta = $("#sta");

        if (autoCreated || $userAnyAdmin){
            std.removeAttr('disabled');
            sta.removeAttr('disabled');
        }
        else {
            std.attr('disabled', 'disabled');
            sta.attr('disabled', 'disabled');
        }

        std.removeAttr('required');
        sta.removeAttr('required');
    }

    /**
     * Get start date
     * @param flight
     * @returns {*}
     */
    function getStartDate(flight) {
        var date;
        if (flight.atd) {
            date = moment(flight.atd, inputDateFormat).toDate();
        } else if (flight.etd) {
            date = moment(flight.etd, inputDateFormat).toDate();
        } else if (flight.ptd) {
            date = moment(flight.ptd, inputDateFormat).toDate();
        } else {
            date = moment(flight.std, inputDateFormat).toDate();
        }
        return date;
    }

    /**
     * Get end date
     * @param flight
     * @returns {*}
     */
    function getEndDate(flight) {
        var date;
        if (flight.ata) {
            date = moment(flight.ata, inputDateFormat).toDate();
        } else if (flight.eta) {
            date = moment(flight.eta, inputDateFormat).toDate();
        } else if (flight.pta) {
            date = moment(flight.pta, inputDateFormat).toDate();
        } else {
            date = moment(flight.sta, inputDateFormat).toDate();
        }
        return date;
    }

    function getSLAFlightDeparture(flight) {
        var date;
        /*
        if (flight.atd && flight.atd != EMPTY_DATETIME) {
            date = moment(flight.atd, inputDateFormat).toDate();
        }
        else if (flight.etd && flight.etd != EMPTY_DATETIME) {
            date = moment(flight.etd, inputDateFormat).toDate();
        }
        else
        */
        if (flight.ptd && flight.ptd != EMPTY_DATETIME) {
            date = moment(flight.ptd, inputDateFormat).toDate();
        }
        else {
            date = moment(flight.std, inputDateFormat).toDate();
        }
        return date;
    }

    /**
     * Get end date
     * @param flight
     * @returns {*}
     */
    function getSLAFlightArrival(flight) {
        var date;
        /*
        if (flight.ata && flight.ata != EMPTY_DATETIME) {
            date = moment(flight.ata, inputDateFormat).toDate();
        }
        else if (flight.eta && flight.eta != EMPTY_DATETIME) {
            date = moment(flight.eta, inputDateFormat).toDate();
        }
        else
        */
        if (flight.pta && flight.pta != EMPTY_DATETIME) {
            date = moment(flight.pta, inputDateFormat).toDate();
        }
        else {
            date = moment(flight.sta, inputDateFormat).toDate();
        }
        return date;
    }

    /**
     * Get flight content
     * @param flight
     * @return string
     */
    function getFlightContent(flight, departure, arrival) {
        var diff = moment(arrival).diff(departure, 'm'), result, diversion;

        if (flight.is_diversion) {
            diversion = flight.diversion;
            result = "<div id='flight-" + flight.id + "' class='row fw-flight-item diversion'>" +
                "<div class='flight_number_diversion_box_left diversionBox'>" +
                "<span class='flight_number_diversion_box_left'>" + flight.flight_number.departure_airport + "</span>" +
                "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
                "<span class='flight_number_diversion_box_right'>" + diversion['diversion_airport_code'] + "</span>" +
                "</div>" +
                "<div class='flight_number_diversion_box_center flightStandard'>" +
                "<span class='text-center'>" + CURRENT_IATA_CODE + " " + flight.flight_number.flight_number + "</span>" +
                "</div>" +
                "<div class='flight_number_diversion_box_right diversionBox'>" +
                "<span class='flight_number_diversion_box_left'>" + diversion['diversion_airport_code'] + "</span>" +
                "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
                "<span class='flight_number_diversion_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
                "</div>" +
                "</div>";
        }
        else {
            if (diff < 90) {
                result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                    "<div class='col-sm-12 flightStandard'>" +
                    "<span class='flight_number_box_small'>" + flight.flight_number.flight_number + "</span>" +
                    "</div>" +
                    "</div>";
            }
            else {

                var fNo;
                if ($.inArray(flight.flightNumber.flightType.type, [ TAJIKAIR, OTHERAIRLINES ])){
                    fNo = flight.flight_number.flight_number;
                }
                else {
                    fNo = CURRENT_IATA_CODE + " " + flight.flight_number.flight_number;
                }
                result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                    "<div class='col-sm-12 flightStandard'>" +
                    "<span class='flight_number_box_left'>" + flight.flight_number.departure_airport + "</span>" +
                    "<span class='flight_number_box_center'>" + fNo + "</span>" +
                    "<span class='flight_number_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
                    "</div>" +
                    "</div>";
            }
        }
        return result;
    }

    /**
     *
     * @param leave
     * @returns {string}
     */
    function getLeaveContent(leave) {
        return "<div id='leave-" + leave.id + "' class='fw-flight-item'>" +
            leave.note + " (" + leave.location_code + ")" +
            "</div>";
    }

    /**
     * Get flight group name
     * @param flight
     * @returns {*}
     */
    function getFlightGroup(flight) {
        return flight.aircraft.name;
    }

    /**
     * Get flight class name
     * @param flight
     */
    function getFlightClassName(flight) {
        var className = FLIGHT_AVAILABLE;
        if (flight.is_diversion) {
            className = FLIGHT_DIVERTED;
        } else {
            if (flight.delay_id) {
                className = FLIGHT_DELAYED;
            } else {
                var atd, etd, std, diff;
                if (flight.atd) {
                    atd = moment(flight.atd, inputDateFormat);
                    std = moment(flight.std, inputDateFormat);
                    diff = atd.diff(std, "minutes");

                    if (atd > std && diff >= 3) {
                        className = FLIGHT_DELAYED;
                    }
                } else if (flight.etd) {
                    etd = moment(flight.etd, inputDateFormat);
                    std = moment(flight.std, inputDateFormat);
                    diff = etd.diff(std, "minutes");

                    if (etd > std && diff >= 3) {
                        className = FLIGHT_DELAYED;
                    }
                }
            }
        }
        return className;
    }

    /**
     * Parse flight information
     * @param data
     */
    var generalTabTemplateHTML = $("#general_tab_template");

    function parseFlight(data, flightStaffID) {
        var flight = data.flight, generalTabTemplate, templateData,
            _general_tab_template = generalTabTemplateHTML.clone(),
            _title = $("#modal_title"), flightNumber = flight.flight_number,
            flightNumText = (flightNumber.airline ?
                (flightNumber.airline.iata ? flightNumber.airline.iata : (flightNumber.airline.icao ? flightNumber.airline.icao : flightNumber.airline.airline)+ "-") : "" ) + flightNumber.flight_number,
            aircraftDetails = "",
            flightNumRadar = (flightNumber.airline ? (flightNumber.airline.iata ? flightNumber.airline.iata : (flightNumber.airline.icao ? flightNumber.airline.icao : "")).toUpperCase() : "") + ltrim(flightNumber.flight_number, "0"),
            flightNumAware = (flightNumber.airline ? (flightNumber.airline.icao ? flightNumber.airline.icao : (flightNumber.airline.icao ? flightNumber.airline.icao : "")).toUpperCase() : "") + flightNumber.flight_number;

        // Load Staff
        loadStaff(flight, data.serviceData);

        var remark = "<span style='font-weight:bold; color:red; font-size:18px;'>";

        if (flight.diverted_airport_id){
            remark += " | DIVERTED";
        }

        if (flight.cancelled_at){
            remark += "| Cancelled";

            if (flight.remark){
                remark += " | Reason:" + flight.remark;
            }
        }
        else {
            if (flight.remark){
                remark += " | " + flight.remark;
            }
        }

        remark += "</span>";

        var flt_date = moment(getFlightDepartureInitialDate(flight)).format("YYYY-MM-DD");

        _title.html("<div class='col-md-12'>" +
                        "<table style='width: 100%;'>" +
                            "<tr>"+
                                "<td rowspan='2'>" +
                                    "<a style='font-size:18px;' target='_blank' href='" + baseUrl + '/flight-info/handling/' + flight.id + "'>" + flightNumText + "</a>" +
                                    "<a>"  + aircraftDetails + "</a>" +
                                    remark +
                                "</td>" +
                                // "<td rowspan='2' style=''><a style='font-size: 18px;border: 1px solid;padding: 5px 10px;' target='_blank' href='" + baseUrl + "/flight-com?date=" + flt_date + "&flight_id=" + flight.id + "&refresh=1'>Flight Comms</a></td>"+
                                // "<td style='width: 70px;'><a style='font-size:12px;' target='_blank' href='" + baseUrl + "/flight-tracker/" + flight.id + "'>FlightTracker</a>" +
                                "<td rowspan='2' style='width: 30px; text-align: right;'>" +
                                    "<button type='button' class='close close-btn font-lg' data-dismiss='modal'>" +
                                        "<span class='font-lg' aria-hidden='true'>&times;</span>" +
                                        "<span class='sr-only'>Close</span>" +
                                    "</button>" +
                                "</td>" +
                            "</tr>" +
                            // "<tr>" +
                            //     "<td><a style='font-size:12px;' target='_blank' href='https://flightaware.com/live/flight/" + flightNumAware + "'>FlightAware</a></tr>" +
                            // "</tr>" +
                        "</table>" +
                    "</div>");

        // www.flightradar24.com/flight/bt221

        if (generalTabTemplateHTML.length) {
            var html = _general_tab_template.html();
            generalTabTemplate = _.template(html);

            if (Object.keys(flight.staffList).length){
                $("#staff_tab").addClass("has-message");
            }
            else {
                $("#staff_tab").removeClass("has-message");
            }

            var departureAP = getFlightDepartureAirport(flight, "IATA"),
                arrivalAP = getFlightArrivalAirport(flight, "IATA", true),
                divertedAP = "", originalDestinationLabel = "";

            if (flight.diverted_airport_id){
                divertedAP = flight.diverted_airport.iata;
                originalDestinationLabel = "ORIGINAL DESTINATION: ";

                if (flight.prev_flight_id){
                    divertedAP = arrivalAP;
                    arrivalAP = "";
                    originalDestinationLabel = "DIVERTED";
                }
            }

            templateData = {
                cancelled: flight.cancelled_at ? true : false,
                flightBarPosition: getFlightProgressBarFlownPercentage(flight),
                planeWidth: getPlaneWidth(),
                planePosition: getPlanePosition(),

                departureCityCode: departureAP,
                arrivalCityCode: arrivalAP,

                departureDateType : flight.departure_date_type,
                arrivalDateType : flight.arrival_date_type,

                departureLocalDate: flight.departure_local_date  ? flight.departure_local_date    : "",
                departureLocalTime: flight.departure_local_time  ? flight.departure_local_time    : "",

                arrivalLocalDate:   flight.arrival_local_date    ? flight.arrival_local_date      : "",
                arrivalLocalTime:   flight.arrival_local_time    ? flight.arrival_local_time      : "",

                departureCity: getFlightDepartureAirport(flight, "NAME"), // data.departure_city,
                arrivalCity: getFlightArrivalAirport(flight, "NAME", true), // data.arrival_city,

                flightInfoHeaderBgColor : flight.diverted_airport_id ? "#ffd3d3" : "#ffffff",
                progressStatus : flight.diverted_airport_id ? "info" : ((flight.is_delayed || (flight.delays && flight.delays.length > 0)) ? "danger" : "success"),
                progressBarPerc: flight.diverted_airport_id ? 53 : 83,
                arrAirportColor: flight.diverted_airport_id ? "red" : "",
                divAirport: divertedAP,
                divAirportPerc: flight.diverted_airport_id ? 10 : 0,
                divPanelPerc: flight.diverted_airport_id ? 20 : 0,
                originalDestinationLabel: originalDestinationLabel,

                std: flight.std,
                ptd: flight.ptd,
                etd: flight.etd,
                atd: flight.atd,
                abn: flight.abn,

                sta: flight.sta,
                pta: flight.pta,
                eta: flight.eta,
                tdn: flight.tdn,
                ata: flight.ata,

            };

            $("#general").html(
                generalTabTemplate(templateData)
            );

            generalTabTemplateHTML = _general_tab_template;
            // Tooltip
            $("[data-toggle='tooltip']").popover({trigger: "hover"});


        }
    }

    var leaveTabTemplateHTML = $("#leave_tab_template");

    function parseLeave(data) {
        var leaveTabTemplate, templateData,_leave_tab_template = leaveTabTemplateHTML.clone();

        if (_leave_tab_template.length) {
            leaveTabTemplate = _.template(
                _leave_tab_template.html()
            );
        }

        console.log(data);

        templateData = {
            userFullName: data.staff,
            location: data.location,
            startDate: moment(data.from, inputDateFormat).format(outputDateFormat),
            endDate: moment(data.to, inputDateFormat).format(outputDateFormat),
            leave: data.leave,
            airline: data.airline,
            rmks: data.rmks,
        };

        $("#general_leave").html(
            leaveTabTemplate(templateData)
        );

        leaveTabTemplateHTML = _leave_tab_template;
    }

    function getDuration(from, to){
        var duration = moment.duration(moment(to).diff(from));
        var hours = duration.hours(), mins = duration.minutes();

        if (mins > 60) {
            mins -= (hours * 60);
        }

        return (hours < 10 ? "0" + hours : hours) + ":" + (mins < 10 ? "0" + (mins < 0 ? 0 : mins) : mins);
    }

    function loadStaff(flight, airlineService){
        console.log(airlineService)
        var staffTableBody = $("#staff-table-body"), tr = "", foundStaff, user, k,
            serviceType = airlineService.service_type,
            staffList = flight.staffList, flightDepArr;


        staffTableBody.empty();

        var service_type, req, min, report, release, spanType, spanClass;



        //duration = moment.duration(moment(to).diff(from));
        //minutes = duration.asMinutes();

        var obj, pReportTime, pReleaseTime, pDuration, reportTime, releaseTime, duration, pReport,
            pRelease, plannedDuration;

        if (airlineService.service_timings == 1) {
            if (airlineService.service[service_type] != 1) {
                // Continue
                // return true;
            }
            obj = airlineService.service;
        }
        else {
            if (airlineService[service_type] != 1) {
                // Continue
                // return true;
            }
            obj = airlineService;
        }

        switch (serviceType) {
            case ARRIVAL_SERVICE:
                service_type = "arrival_service";
                req = "arr_staff_req";
                min = "arr_staff_min";
                report = "arr_report_time";
                release = "arr_release_time";
                flightDepArr = getSLAFlightArrival(flight);
                pReport = moment(flightDepArr).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).add(obj[release], 'm');

                spanType = "<span class='label label-success'>ARRIVAL</span>";
                spanClass = "label-success";
                break;

            case DEPARTURE_SERVICE:
                service_type = "departure_service";
                req = "dep_staff_req";
                min = "dep_staff_min";
                report = "dep_report_time";
                release = "dep_release_time";
                flightDepArr = getSLAFlightDeparture(flight);
                pReport = moment(flightDepArr).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                spanType = "<span class='label label-primary'>DEPARTURE</span>";
                spanClass = "label-primary";

                break;

            case TURNAROUND_SERVICE:
                service_type = "turnaround_service";
                req = "turn_staff_req";
                min = "turn_staff_min";
                report = "turn_report_time";
                release = "turn_release_time";
                flightDepArr = getSLAFlightDeparture(flight);
                var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                flightDepArr = getSLAFlightDeparture(flight);

                pReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                spanType = "<span class='label label-warning'>TURNAROUND</span>";
                spanClass = "label-warning";
                break;
        }

        plannedDuration = getDuration(pReport, pRelease);

        tr += "<tr class='sla-header'>" +
                "<td data-center><span class='label font-sm "+ spanClass + "'>" + airlineService.service.abbr + "</span></td>" +
                "<td>" +
                spanType +
                "<span class='margin-left-10'><strong>Required: " + obj[req] + "</strong></span>" +
                "</td>" +
                "<td>" + (pReport ? pReport.format("MMM DD, HH:mm") : "N/A") + " <span class='label label-warning'>SLA</span></td>" +
                "<td>" + (pRelease ? pRelease.format("MMM DD, HH:mm") : "N/A") + " <span class='label label-warning'>SLA</span></td>" +
                "<td data-center>" + plannedDuration + " <span class='label label-warning'>SLA</span></td>" +
            "</tr>";

        foundStaff = false;
        //console.log(staffList)
        if (staffList.hasOwnProperty(airlineService.service.abbr) && staffList[airlineService.service.abbr].length > 0) {
            k = 0;
            $.each(staffList[airlineService.service.abbr], function (j, staffDetail) {
                if (airlineService.service_id == staffDetail.service_id) {
                    user = staffDetail.user;
                    pReportTime = staffDetail.planned_report_time && staffDetail.planned_report_time != EMPTY_DATETIME ? moment(staffDetail.planned_report_time) : "";
                    pReleaseTime = staffDetail.planned_release_time && staffDetail.planned_release_time != EMPTY_DATETIME ? moment(staffDetail.planned_release_time) : "";
                    pDuration = pReportTime && pReleaseTime ? getDuration(pReportTime, pReleaseTime) : "";

                    reportTime = staffDetail.report_time && staffDetail.report_time != EMPTY_DATETIME ? moment(staffDetail.report_time) : "";
                    releaseTime = staffDetail.release_time && staffDetail.release_time != EMPTY_DATETIME ? moment(staffDetail.release_time) : "";
                    duration = reportTime && releaseTime ? getDuration(reportTime, releaseTime) : "";

                    //console.log(staffDetail)

                    tr += "<tr>" +
                        "<td style='vertical-align: middle' data-center>" + (++k) + "</td>" +
                        "<td class='staff-name'>" + (staffDetail.location ? staffDetail.location.iata + " - " : "") + (user ? user.first_name + " " + user.last_name : "") + "</td>" +

                        "<td>" + (pReportTime ? (pReportTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                        (reportTime ? (reportTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                        "</td>" +

                        "<td>" + (pReleaseTime ? (pReleaseTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                        (releaseTime ? (releaseTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                        "</td>" +

                        "<td data-center>" + (pDuration ? pDuration + " <span class='label label-success'>PLN</span>" : "") + "<br/>" +
                        (duration ? duration + " <span class='label label-primary'>ACT</span>" : "") +
                        "</td>" +

                        "</tr>";

                    foundStaff = true;
                }
            });
        }

        staffTableBody.append(tr);
    }

    function showDateInFlightTimings(flight, type){
        var dep = [
            "std",
            "ptd",
            "etd",
            "atd",
            "abn",
        ];

        var arr = [
            "sta",
            "pta",
            "eta",
            "tdn",
            "ata",
        ];

        if (!flight[type] || flight[type] == EMPTY_DATETIME){
            return "&mdash;"
        }

        var searchArray = ($.inArray(type, dep) !== -1) ? dep : arr;

        var newValue = moment(flight[type], inputDateFormat).format(outputTimeFormat);
        var valueDate =  moment(flight[type], inputDateFormat).format(outputDateOnlyFormat);
        var foundDate;
        var previousTypeDate = true;
        $.each(searchArray, function(i, val){

            if (flight[val] && flight[val] != EMPTY_DATETIME){

                foundDate = moment(flight[val], inputDateFormat).format(outputDateOnlyFormat);
                if (valueDate != foundDate){
                    return;
                }

                if (val == type){
                    newValue = moment(flight[val], inputDateFormat).format(outputDateFormat)
                    previousTypeDate = false;
                }

                return false;
            }
        });

        if (previousTypeDate && foundDate && foundDate !== "undefined" &&
                moment(flight[type], inputDateFormat).format(outputDateOnlyFormat) != foundDate){
            newValue = moment(flight[type], inputDateFormat).format(outputDateFormat)
        }

        return newValue;
    }

    /**
     * Prepare Raw Data For FleetWatch Timeline
     * @param json
     * @returns {Array}
     */
    function prepareDataForTimeline(json, object) {
        var flights = [];
        if (json.length) {
            var item, start_date, end_date;
            for (var i = 0, l = json.length; i < l; i++) {
                item = json[i];
                start_date = item.start_date;
                end_date = item.end_date;

                if (object) {
                    flights.push({
                        "start": new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        "end": new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                        "content": item.content,
                        "group": item.group,
                        "className": item.className
                    });
                }
                else {
                    flights.push([
                        new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                        item.content,
                        item.group,
                        item.className
                    ]);
                }
            }
        }
        return flights;
    }

    /**
     * Get selected flight ID and type
     * @returns {*}
     */
    function getSelectedEvent(flight) {
        flight = flight || $(".timeline-event-selected > div.timeline-event-content > div");
        if (flight.length) {
            return {
                "id": flight.data("id"),
                "flight_id" : flight.data("flight_id"),
                "airline_service_id" : flight.data("airline_service_id"),
                "service_type" : flight.data("service_type"),
                "sla" : flight.data("sla"),

                "staff" : flight.data("staff"),
                "location" : flight.data("location"),
                "leave" : flight.data("leave"),
                "from" : flight.data("from"),
                "to" : flight.data("to"),
                "airline" : flight.data("airline"),
                "rmks" : flight.data("rmks"),
            }
        }
        return false;
    }

    function getPlanePosition() {
        var screenWidth = $(document).width(),
            position = (-1) * (screenWidth) * 13 / 1200;
        return screenWidth < 1000 ? 0 : position;
    }

    function getPlaneWidth() {
        var screenWidth = $(document).width(),
            proportionateWidth = Math.round(screenWidth * 100 / 1300);
        return proportionateWidth > 100 ? 100 : proportionateWidth;
    }

    function getFlightPosition(flight) {
        var progressbar_container = $(document).find("#progressbar_container"),
            progressbar_line = $(document).find("#progressbar_line"),
            //progressbar_plane = $(document).find("#progressbar_plane"),
            LINE_WIDTH = progressbar_container.width(),
            //PLANE_WIDTH = progressbar_plane.width(),
            PLANE_AND_LINE_OFFSET = 0,
            result = 0;

        if (flight.std && flight.sta && flight.atd) {
            var flightStartTime = moment(flight.atd),
                flightEndTime = moment(flight.sta),
                now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
                currentTime = moment(now);

            if (flight.ata){
                flightEndTime = moment(flight.ata);
            }
            else if (flight.eta){
                flightEndTime = moment(flight.eta);
            }

            /*if (currentTime.isAfter(flightEndTime)) {
                result = PLANE_WIDTH + (2 * PLANE_AND_LINE_OFFSET) + LINE_WIDTH;
            } else if (currentTime.isBefore(flightStartTime)) {
                result = 0;
            } else {
                var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                    flownRoute = currentTime.diff(flightStartTime, "seconds");

                result = PLANE_WIDTH + PLANE_AND_LINE_OFFSET + (LINE_WIDTH * flownRoute / totalFlightTimeInSeconds);
            }*/
        }

        //progressbar_plane.attr("style", progressbar_plane.attr("style") + ";left:" + result + "px;");

        return result;
    }

    function getFlightProgressBarFlownPercentage(flight) {
        var OFFSET = 1;
        if (flight.atd) {

            var flightStartTime = moment(flight.atd),
                flightEndTime = getFlightArrivalDate(flight, true),
                now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
                currentTime = moment(now);

            if (currentTime.isAfter(flightEndTime)) {
                return 100;
            } else if (currentTime.isBefore(flightStartTime)) {
                return 0;
            } else {
                var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                    flownRoute = currentTime.diff(flightStartTime, "seconds");
                return OFFSET + 100 * (flownRoute / totalFlightTimeInSeconds);
            }
        }
        return 0;
    }

    /**
     * Get Flight Crew
     * @param type
     * @param data
     * @param crew_type
     * @returns {*}
     */
    function getFlightCrewItems(type, data, crew_type) {
        if (typeof data.flightCrew === "undefined" || data.flightCrew == false) {
            return "";
        }
        var flightCrew = data.flightCrew, crew = [];
        switch (type) {
            case FLIGHT_CREW_CAPTAINS:
                if (typeof flightCrew.captains !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.captains.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.captains.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.captains.standby;
                    }
                }
                break;
            case FLIGHT_CREW_FIRST_OFFICERS:
                if (typeof flightCrew.firstOfficers !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.firstOfficers.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.firstOfficers.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.firstOfficers.standby;
                    }
                }
                break;
            case FLIGHT_CREW_FLIGHT_ATTENDANTS:
                if (typeof flightCrew.flightAttendants !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.flightAttendants.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.flightAttendants.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.flightAttendants.standby;
                    } else if (crew_type == CREW_TYPE_SUP) {
                        crew = flightCrew.flightAttendants.sup;
                    }

                }
                break;
            default:
                break;
        }
        if (crew.length) {
            var result = [];
            var url = crew_type == CREW_TYPE_SUP ? "staff/" : "crew/profile?id=";
            for (var i = 0, l = crew.length; i < l; i++) {
                if (crew[i] && $.isPlainObject(crew[i])) {
                    result.push("<a target='_blank' href='" + baseHomeUrl + "#" + url + crew[i].id + "' id='user-" + crew[i].id +
                        "' class='crew-item-person'>" + crew[i].last_name + " " + crew[i].first_name + "</a>");
                }
            }
            return result;
        }
        return "";
    }

    /**
     * Implode array to string with delimiter
     * @param arr
     * @param delimiter
     * @returns {string|*}
     */
    function implode(arr, delimiter) {
        return (arr instanceof Array) ? arr.join(delimiter) : arr;
    }

    function implodeWithCheck(arr, delimiter) {
        if (arr instanceof Array) {
            var newString = '';
            $.each(arr, function (i, item) {
                var each = $(item);
                if (each.val() != 'undefined undefined') {
                    newString += item + delimiter;
                }
            });

            return newString;
        }
        return arr;
    }

    function getFlightDepDate(flight, departure, type, format){
        if (!departure || departure == EMPTY_DATETIME){
            if (flight.etd && flight.etd != EMPTY_DATETIME) {
                departure = moment(flight.etd);
            }
            else {
                if (flight.ptd && flight.ptd != EMPTY_DATETIME) {
                    departure = moment(flight.ptd);
                }
                else if (flight.std && flight.std != EMPTY_DATETIME) {
                    departure = moment(flight.std);
                }
            }

            if (type == ABN){
                departure = moment(departure).add(10, 'm');
            }
        }

        if (format !== "undefined"){
            return moment(departure).format(format);
        }

        return moment(departure);
    }

    function getFlightArrDate(flight, arrival, type, format){
        if (!arrival || arrival == EMPTY_DATETIME){
            if (flight.eta && flight.eta != EMPTY_DATETIME) {
                arrival = moment(flight.eta);
            }
            else {
                if (flight.pta && flight.pta != EMPTY_DATETIME) {
                    arrival = moment(flight.pta);
                }
                else if (flight.sta && flight.sta != EMPTY_DATETIME) {
                    arrival = moment(flight.sta);
                }
            }

            if (type == TDN){
                arrival = moment(arrival).subtract(10, 'm');
            }
        }

        if (format !== "undefined"){
            return moment(arrival).format(format);
        }

        return moment(arrival);
    }

    /**
     * Fill MVT messages
     * @param data
     */
    function fillMVTMessages(data) {
        var arrival_message_mvt = $("#arrival_message_mvt"), arrival_message_subject = $('#arrival_message_subject'),
            departure_message_mvt = $("#departure_message_mvt"), departure_message_subject = $('#departure_message_subject'),
            send_departure_message_btn = $("#send-departure-message-btn"), diverted_flight = $("#diverted_flight"),
            send_arrival_message_btn = $("#send-arrival-message-btn"),
            flight = data.flight, i, l, j,
            flightNumber = flight.flight_number,
            departureAirport = flight.departure_airport ? flight.departure_airport : flightNumber.departure_airport,
            arrivalAirport =  flight.arrival_airport ? flight.arrival_airport : flightNumber.arrival_airport,
            aircraft = flight.aircraft,
            user = data.user,
            _departure_airport,
            _arrival_airport,

            // DEP FIELDS
            dep_message_layout = $("#dep_message_layout"),
            arr_message_layout = $("#arr_message_layout"),
            // dep_message_copy = $("#dep_message_copy"),
            // arr_message_copy = $("#arr_message_copy"),
            mvt_type = $("#mvt_type"), mvt_flt_no = $("#mvt_flt_no"), mvt_dep_date = $("#mvt_dep_date"), mvt_ac = $("#mvt_ac"), mvt_dep_ap = $("#mvt_dep_ap"),
            mvt_etd = $("#mvt_etd"),
            mvt_atd = $("#mvt_atd"), mvt_abn = $("#mvt_abn"), mvt_eta = $("#mvt_eta"), mvt_arr_ap = $("#mvt_arr_ap"),
            mvt_dl_code = [], mvt_dl_time = [],

            mvt_pax_total = $("#mvt_pax_total"), mvt_pax_a = $("#mvt_pax_a"), mvt_pax_c = $("#mvt_pax_c"), mvt_pax_w = $("#mvt_pax_w"),
            mvt_pax_y = $("#mvt_pax_y"), mvt_pax_inf = $("#mvt_pax_inf"),
            mvt_fob = $("#mvt_fob"), mvt_tof = $("#mvt_tof"), mvt_eet = $("#mvt_eet"),
            mvt_baggage = $("#mvt_baggage"), mvt_cargo = $("#mvt_cargo"), mvt_mail = $("#mvt_mail"), mvt_eic = $("#mvt_eic"),
            mvt_pic = $("#mvt_pic"), mvt_si = $("#mvt_si"),

            // ARR FIELDS
            arr_mvt_flt_no = $("#arr_mvt_flt_no"), arr_mvt_dep_date = $("#arr_mvt_dep_date"), arr_mvt_ac = $("#arr_mvt_ac"),
            arr_mvt_ap = $("#arr_mvt_ap"), arr_mvt_tdn = $("#arr_mvt_tdn"), arr_mvt_ata = $("#arr_mvt_ata"),
            arr_mvt_si = $("#arr_mvt_si"), arr_mvt_rf = $("#arr_mvt_rf"),
            arr_mvt_pic = $("#arr_mvt_pic");

        // Clear MVT Boxes Before Loading
        clearMVTForm();

        mvt_dl_code.push($("#mvt_dl1_code"));
        mvt_dl_code.push($("#mvt_dl2_code"));
        mvt_dl_code.push($("#mvt_dl3_code"));

        mvt_dl_time.push($("#mvt_dl1_time"));
        mvt_dl_time.push($("#mvt_dl2_time"));
        mvt_dl_time.push($("#mvt_dl3_time"));

        var fltNo = flightNumber.airline.iata + flightNumber.flight_number,
            pax_c = parseInt(flight.pax_c_actual),
            pax_y = parseInt(flight.pax_y_actual),
            // std = moment(flight.std),
            // sta = moment(flight.sta),
            // atd = moment(flight.atd),
            // abn = moment(flight.abn),
            // eta = moment(flight.eta),
            // ata = moment(flight.ata),
            depAP = departureAirport ? departureAirport.iata : "",
            arrAP = arrivalAirport ? arrivalAirport.iata : "",
            ac = aircraft ? aircraft.mvt_name   : "",
            readyDEP = "", readyARR = "";

        var initDate = moment(getFlightDepartureInitialDate(flight)).format("DD");

        // DEP FIELDS

        mvt_flt_no.text(fltNo);

        mvt_dep_date.text(initDate);
        mvt_ac.val(ac);
        mvt_dep_ap.text(depAP);

        // HIDE AUTOFILL

        var etd = getFlightDepDate(flight, flight.etd, ETD, "HHmm"),
            atd = getFlightDepDate(flight, flight.atd, ATD, "HHmm"),
            abn = getFlightDepDate(flight, flight.abn, ABN, "HHmm"),
            eta = getFlightArrDate(flight, flight.eta, ETA, "HHmm");

        mvt_etd.attr("placeholder", "Ex. " + etd);
        mvt_atd.attr("placeholder", "Ex. " + atd);
        mvt_abn.attr("placeholder", "Ex. " + abn);
        mvt_eta.attr("placeholder", "Ex. " + eta);

        //mvt_eta.val(getFlightArrDate(flight, flight.eta, ETA, "DDHHmm"));

        mvt_arr_ap.text(arrAP);



        // DIVERSION
        if (flight.is_diversion && flight.arrival_airport_id && flight.diverted_airport_id){
            mvt_type.text("DIV");
            mvt_type.addClass("color-red");
        }


        // DELAYS
        var time, dCodes = [], dTimes = [];
        if (flight.delays && flight.delays.length){
            $.each(flight.delays, function(i, each){
                time = moment(each.duration, "HH:mm:ss").format("HHmm");

                mvt_dl_code[i].val(each.delay.code);
                mvt_dl_time[i].val(time);

                dCodes.push(each.delay.code);
                dTimes.push(time);
            });
        }

        if (ac && depAP) {
            var depText = "MVT\n"
                + fltNo + "/" + initDate + "." + ac + "." + depAP + "\n";

            if (atd) {
                depText += "AD" + atd;
                if (abn) {
                    depText += "/" + abn;
                }
                if (eta) {
                    depText += " EA" + eta;
                }
            } else if (etd) {
                depText += "ED" + etd;
            }

            depText += " " + arrAP + "\n";

            if (dCodes.length) {
                depText += "DL" + dCodes.join('/');
                if (dTimes.length) {
                    depText += "/" + dTimes.join('/');
                }
            }
            // for copying
            dep_message_layout.val(depText);
        }


        mvt_pax_total.val(flight.pax_mvt_total);
        mvt_pax_inf.val(flight.pax_mvt_inf ? flight.pax_mvt_inf : (flight.pax_inf_actual ? flight.pax_inf_actual : ""));
        mvt_pax_a.val(flight.pax_a_actual ? flight.pax_a_actual : (flight.pax_a_booked ? flight.pax_a_booked : "" ));
        mvt_pax_c.val(flight.pax_c_actual ? flight.pax_c_actual : (flight.pax_c_booked ? flight.pax_c_booked : "" ));
        mvt_pax_w.val(flight.pax_w_actual ? flight.pax_w_actual : (flight.pax_w_booked ? flight.pax_w_booked : "" ));
        mvt_pax_y.val(flight.pax_y_actual ? flight.pax_y_actual : (flight.pax_y_booked ? flight.pax_y_booked : "" ));

        mvt_fob.val(getDepartureFuel(flight));

        mvt_tof.val(flight.tof);
        mvt_pic.val(flight.pic);

        mvt_baggage.val(flight.baggage);
        mvt_cargo.val(flight.cargo);
        mvt_mail.val(flight.mail);
        mvt_eic.val(flight.eic);

        if (flight.eet && flight.eet != EMPTY_TIME){
            mvt_eet.val(moment(flight.eet, "HH:mm:ss").format("HHmm"));
        }
        else {
            mvt_eet.val("");
        }
        //mvt_si.val("");



        // ARRIVAL
        arr_mvt_flt_no.text(fltNo);
        arr_mvt_dep_date.text(initDate);
        arr_mvt_ac.val(ac);
        arr_mvt_ap.text(arrAP);

        // HIDE AUTOFILL
        var tdn = getFlightArrDate(flight, flight.tdn, TDN, "HHmm"),
            ata = getFlightArrDate(flight, flight.ata, ATA, "HHmm");

        arr_mvt_tdn.attr("placeholder", "Ex. " + tdn);
        arr_mvt_ata.attr("placeholder", "Ex. " + ata);
        //arr_mvt_tdn.val(getFlightArrDate(flight, flight.tdn, TDN, "DDHHmm"));
        //arr_mvt_ata.val(getFlightArrDate(flight, flight.ata, ATA, "DDHHmm"));


        // Set Arrival Fuel
        arr_mvt_rf.val(getArrivalFuel(flight));
        arr_mvt_pic.val(flight.pic_arr ? flight.pic_arr : flight.pic);
        //arr_mvt_pic.val("");
        //arr_mvt_si.val("");

        if (ac && arrAP) {
            var arrText = "MVT\n"
                + fltNo + "/" + initDate + "." + ac + "." + arrAP + "\n";

            if (tdn || ata) {
                arrText += "AA";
                if (tdn) {
                    arrText += tdn;
                    if (ata) {
                        arrText += "/" + ata;
                    }
                } else if (eta) {
                    arrText += eta;
                }
            }

            arr_message_layout.val(arrText);
        }

        return;

        _departure_airport = flightNumber.departure_airport ? flightNumber.departure_airport.iata : "";
        _arrival_airport = flightNumber.arrival_airport ? flightNumber.arrival_airport.iata : "";

        // set Departure MVT message
        if (flight.atd && flight.abn && flight.eta && aircraft) {
            var departureMessageSubject, arrivalMessageSubject,

                departure_MVT_message,
                arrival_MVT_message;

            if (flight.is_diversion) {
                _departure_airport = departureAirport.abbr;
                _arrival_airport = arrivalAirport.abbr;
            }

            departure_MVT_message = "MVT\n" + flightNumber.airline.iata + flightNumber.flight_number + "/" + atd.format("DD") + "." +
                aircraft.mvt_name + "." + _departure_airport + "\nAD" + atd.format("DDHHmm") + "/" +
                abn.format("DDHHmm") + " EA" + eta.format("HHmm") + " " + _arrival_airport + "\n";
            // set Subject of The Message
            departureMessageSubject = 'MVT ' + flightNumber.airline.iata + flightNumber.flight_number + '/' + atd.format("DD") + ' ' +
                _departure_airport + '-' + _arrival_airport;
            departure_message_subject.val(departureMessageSubject);




            arrivalMessageSubject = 'MVT ' + flightNumber.airline.iata + flightNumber.flight_number + '/' + ata.format("DD") + ' ' +
                _departure_airport + '-' + _arrival_airport;
            arrival_message_subject.val(arrivalMessageSubject);

            // set delay part of message
            if (flight.delay_id && flight.delay) {
                var diff_hours = atd.diff(std, "hours").toString();
                var diff_minutes = atd.diff(std, "minutes").toString();

                if (diff_hours.length == 1) {
                    diff_hours = "0" + diff_hours.toString();
                }
                if (parseInt(diff_minutes) > 60) {
                    diff_minutes = parseInt(diff_minutes) % 60;
                    diff_minutes = diff_minutes.toString();
                }
                if (diff_minutes.length == 1) {
                    diff_minutes = "0" + diff_minutes;
                }
                departure_MVT_message += "DL" + flight.delay.code + "/" + diff_hours + diff_minutes + "\n";
                if (flight.delay.description) {
                    departure_MVT_message += "SI " + flight.delay.description + "\n";
                }
            }

            // set PAX part of message
            if (isNumber(pax_c) && isNumber(pax_y)) {
                var total = parseInt(pax_c) + parseInt(pax_y);
                if (total > 0) {
                    departure_MVT_message += "PX" + total + "\n";
                }
            }

            // set user name
            if (user) {
                departure_MVT_message += "OCC/" + user.last_name + " " + user.first_name;
            }
            departure_message_mvt.val(departure_MVT_message);

            // validate available hours
            var arrivalDate = moment(flight.abn),
                duration = moment.duration(moment().diff(arrivalDate)),
                hours = duration.asHours();
            if (hours > MAX_HOURS_FOR_MOVE) {
                send_departure_message_btn.attr("disabled", true);
                send_arrival_message_btn.attr("disabled", true);
            } else {
                send_departure_message_btn.attr("disabled", false);
                send_arrival_message_btn.attr("disabled", false);
            }
        }

        // set arrival MVT message
        if (flight.tdn && flight.ata && aircraft) {
            tdn = moment(flight.tdn);
            ata = moment(flight.ata);

                arrival_MVT_message = "MVT\n" + flightNumber.airline.iata + flightNumber.flight_number + "/" + ata.format("DD") + "." +
                    aircraft.mvt_name + "." + _arrival_airport + "\nAA" + tdn.format("DDHHmm") + "/" +
                    ata.format("DDHHmm") + "\n";

            // set user name
            if (user) {
                arrival_MVT_message += "OCC/" + user.first_name + " " + user.last_name;
            }
            arrival_message_mvt.val(arrival_MVT_message);
        }
    }

    function getArrivalFuel(flight){
        if (flight.rf){
            return flight.rf;
        }

        var in_tanks = flight.in_tanks  ? flight.in_tanks : 0,
            uplifted = flight.uplifted  ? flight.uplifted : 0,
            utilised = flight.utilised  ? flight.utilised : 0,
            departure_fuel = flight.fob ? flight.fob : (in_tanks + uplifted);

        return departure_fuel  - utilised;
    }

    function getDepartureFuel(flight){
        if (flight.fob){
            return flight.fob;
        }

        var in_tanks = flight.in_tanks  ? flight.in_tanks : 0,
            uplifted = flight.uplifted  ? flight.uplifted : 0;

        return in_tanks + uplifted;
    }

    var multiSelectOptionsSearch = {
        includeSelectAllOption: true,
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true
    };

    function ApplyDateFormatToInputs(parentElement) {
        parentElement.find(".datetimepicker").datetimepicker({
            format: "Y-m-d H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            step: 1
        });

        parentElement.find(".datetimepicker-current").datetimepicker({
            format: "Y-m-d H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            step: 1,
            // maxDate: new Date(moment.utc().format("YYYY-MM-DD HH:mm")),
            onChangeDateTime: function(date, $input) {
                var maxDate = moment.utc().format("YYYY-MM-DD HH:mm");
                if (moment(maxDate).isBefore(moment(date))) {
                    alert("Time is in future!");
                    $input.val("");
                }
            }
        });
    }

    $(document).on("change", ".assigned-staff", function(){
        var _this = $(this), assignedContainer = _this.parents(".assigned-container");
        //console.log("Changed");
        //console.log(assignedContainer);
        if (_this.val()){
            assignedContainer.find(".p-report-time").attr("required", "required");
            assignedContainer.find(".p-release-time").attr("required", "required");
        }
        else {
            assignedContainer.find(".p-report-time").removeAttr("required");
            assignedContainer.find(".p-release-time").removeAttr("required");
        }
    });

    $("#staff-container").on("click", ".add-staff", function(){
        var _this = $(this), assignedContainer = _this.parents(".assigned-container"),
            staffContainer = $("#staff-container"), newContainer, staff;

        newContainer = assignedContainer.clone();

        newContainer.find(".assigned-service").text("");

        newContainer.find(".assigned-staff").val("");

        newContainer.find(".report-time").val("");

        newContainer.find(".release-time").val("");

        assignedContainer.find(".staff-operations").hide();

        assignedContainer.removeClass("gray-border-bottom");

        newContainer.insertAfter(assignedContainer);

        newContainer.find(".sla-info").hide();

        newContainer.addClass("gray-border-bottom");

        ApplyDateFormatToInputs(newContainer);

    })
    .on("click", ".remove-staff", function(){
        var _this = $(this), assignedContainer = _this.parents(".assigned-container"),
            staffContainer = $("#staff-container"), assignedService;

        assignedService = assignedContainer.find(".assigned-service");

        if (assignedService.text() == ""){

            assignedContainer.prev().find(".staff-operations").show();

            assignedContainer.prev().addClass("gray-border-bottom");

            assignedContainer.remove();
        }
        else {

            assignedContainer.find(".assigned-staff").val("");

            assignedContainer.find(".p-report-time").val("");
            assignedContainer.find(".p-report-time").removeAttr("required");

            assignedContainer.find(".p-release-time").val("");
            assignedContainer.find(".p-release-time").removeAttr("required");

            assignedContainer.find(".report-time").val("");

            assignedContainer.find(".release-time").val("");

            assignedContainer.find(".staff-operations").show();
        }
    })
    .on("click", ".copy-pln-report-time", function(){
        var _this = $(this), plnReportTime = _this.parent().find(".p-report-time"),
            container = _this.parents(".assigned-container");

        var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

        if (moment(utcDate).isBefore(moment(plnReportTime.val(), "YYYY-MM-DD HH:mm"))){
            alert("Time is in future!");
            return;
        }

        container.find(".report-time").val(plnReportTime.val());

    })
    .on("click", ".copy-pln-release-time", function(){
        var _this = $(this), plnReleaseTime = _this.parent().find(".p-release-time"),
            container = _this.parents(".assigned-container");

        var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

        if (moment(utcDate).isBefore(moment(plnReleaseTime.val(), "YYYY-MM-DD HH:mm"))){
            alert("Time is in future!");
            return;
        }

        container.find(".release-time").val(plnReleaseTime.val());

    });

    function fillSingleStaffForm(data){

        var staffContainer = $("#staff-container"),
            _form = staffContainer.parents('form'),
            airlineService = data.serviceData, serviceType = airlineService.service_type,
            assignedFlights = _form.find(".flight-container"), num = assignedFlights.length,
            assignedContainer = _form.find(".assigned-container[data-initial=1]");
        num++;

        var flightContainer = $("<div class='col-md-12 flight-container no-padding' data-num='" + num + "'></div>");

        // Delete
        staffContainer.children().remove();
        //_form.find(".assigned-container").not(".hidden").remove();

        var staffObjects = data.flight.staffList;

        var foundStaff = false;

        var obj;

        if (airlineService.service_timings == 1) {
            if (airlineService.service[serviceType] != 1) {
                // Continue
                // return true;
            }
            obj = airlineService.service;
        }
        else {
            if (airlineService[serviceType] != 1) {
                // Continue
                // return true;
            }
            obj = airlineService;
        }

        foundStaff = false;
        if (staffObjects.hasOwnProperty(airlineService.service.abbr) && staffObjects[airlineService.service.abbr].length > 0) {
            //console.log(staffObjects[airlineService.service.abbr])
            $.each(staffObjects[airlineService.service.abbr], function (j, staffDetail) {
                if (airlineService.service_id == staffDetail.service_id) {
                    flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, !foundStaff, staffDetail);
                    foundStaff = true;
                }
            });
        }

        //console.log("Found: " + foundStaff)

        if (!foundStaff) {
            flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, true);
        }

        flightContainer.find(".staff-operations").last().find("i.add-staff").hide();
        flightContainer.find(".staff-operations").last().find("i.remove-staff").show();
        flightContainer.find(".staff-operations").last().show();
        // flightContainer.find(".assigned-container").last().addClass("gray-border-bottom");
        staffContainer.append(flightContainer);

        ApplyDateFormatToInputs(staffContainer);
    }

    function fillStaffForm(data){

        var staffContainer = $("#staff-container"),
            _form = staffContainer.parents('form'),
            flightsData = data.serviceData, newStaff,
            assignedFlights = _form.find(".flight-container"), num = assignedFlights.length,
            assignedContainer = _form.find(".assigned-container[data-initial=1]");

        num++;

        var flightContainer = $("<div class='col-md-12 flight-container no-padding' data-num='" + num + "'></div>");

        // Delete
        staffContainer.children().remove();
        //_form.find(".assigned-container").not(".hidden").remove();

        var staffObjects = data.flight.staffList;

        var foundStaff = false, serviceType;

        var obj;

        if (flightsData.services) {
            $.each(flightsData.services, function (key, airlineService) {

                console.log("i: " + key)
                console.log(airlineService)
                serviceType = airlineService.serviceType;

                if (airlineService.service_timings == 1) {
                    if (airlineService.service[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService.service;
                }
                else {
                    if (airlineService[serviceType] != 1) {
                        // Continue
                        return true;
                    }
                    obj = airlineService;
                }

                foundStaff = false;
                if (staffObjects.hasOwnProperty(airlineService.service.abbr) && staffObjects[airlineService.service.abbr].length > 0) {
                    $.each(staffObjects[airlineService.service.abbr], function (j, staffDetail) {
                        if (airlineService.service_id == staffDetail.service_id) {
                            flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, !foundStaff, staffDetail);
                            foundStaff = true;
                        }
                    });
                }

                if (!foundStaff) {
                    flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, true);
                }

                flightContainer.find(".staff-operations").last().find("i.add-staff").show();
                flightContainer.find(".staff-operations").last().find("i.remove-staff").show();
                flightContainer.find(".staff-operations").last().show();
                // flightContainer.find(".assigned-container").last().addClass("gray-border-bottom");

                staffContainer.append(flightContainer);

            });

            ApplyDateFormatToInputs(staffContainer);
        }
    }


    function createStaffContainer(airlineService, obj, flight, serviceType, assignedContainer, flightContainer, showLabel, selectedStaff){
        var slaInfo, slaStaffReq, newStaff, pReportTime, pReleaseTime, reportTime, releaseTime, newContainer, newService;

        newContainer = assignedContainer.clone();
        newContainer.removeAttr("data-initial");
        slaInfo = newContainer.find(".sla-info");

        console.log("Service Type: " + serviceType)
        if (showLabel && showLabel !== "undefined"){
            var service_type, slaType, req, min, report, release, pReport, pRelease, pDuration, flightDepArr;

            slaType = newContainer.find(".assigned-sla-type");
            slaType.attr("name", "t_" + airlineService.service_id);

            switch (serviceType) {
                case ARRIVAL_SERVICE:
                    req = "arr_staff_req";
                    report = "arr_report_time";
                    release = "arr_release_time";
                    flightDepArr = getSLAFlightArrival(flight);

                    newContainer.find(".assigned-service").addClass("label-success").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-success").text("ARRIVAL");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("a");

                    pReport = moment(flightDepArr).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).add(obj[release], 'm');
                    break;

                case DEPARTURE_SERVICE:
                    req = "dep_staff_req";
                    report = "dep_report_time";
                    release = "dep_release_time";
                    flightDepArr = getSLAFlightDeparture(flight);

                    newContainer.find(".assigned-service").addClass("label-primary").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-primary").text("DEPARTURE");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("d");

                    pReport = moment(flightDepArr).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).subtract(obj[release], 'm');
                    break;

                case TURNAROUND_SERVICE:
                    req = "turn_staff_req";
                    report = "turn_report_time";
                    release = "turn_release_time";

                    newContainer.find(".assigned-service").addClass("label-warning").text(airlineService.service.abbr);
                    newContainer.find(".assigned-service-type").addClass("label-warning").text("TURNAROUND");
                    newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                    // Service Type sent to form
                    slaType.val("t");

                    var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                    flightDepArr = getSLAFlightDeparture(flight);

                    pReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                    pRelease = moment(flightDepArr).subtract(obj[release], 'm');
                    break;
            }


            console.log("Report: " + pReport.format("YYYY-MM-DD HH:mm") + " - Release: " + pRelease.format("YYYY-MM-DD HH:mm"))
            console.log(obj);

            pDuration = getDuration(pReport, pRelease);

            newContainer.find(".sla-report-time").text(pReport.format("YYYY-MM-DD HH:mm"));
            newContainer.find(".sla-release-time").text(pRelease.format("YYYY-MM-DD HH:mm"));
            // newContainer.find(".sla-report-time").text(obj.report_time.format("YYYY-MM-DD HH:mm"));
            // newContainer.find(".sla-release-time").text(obj.release_time.format("YYYY-MM-DD HH:mm"));
        }
        else{
            slaInfo.hide();
        }

        newStaff = newContainer.find(".assigned-staff");
        newStaff.attr("name", "s_" + airlineService.service_id + "[]");
        newStaff.append($("<option value=''>-Select Staff-</option>"));
        $.each(airlineService.eligibleStaff, function(j, staff){
            newStaff.append($("<option value='" + staff.user_id + "'>" + staff.iata + " - " + staff.first_name + " " + staff.last_name + "</option>"));
        });

        //newStaff.multiselect(multiSelectOptionsSearch);

        pReportTime = newContainer.find(".p-report-time");
        pReportTime.attr("name", "pr_" + airlineService.service_id + "[]");
        pReportTime.attr("required", "required");

        pReleaseTime = newContainer.find(".p-release-time");
        pReleaseTime.attr("name", "pf_" + airlineService.service_id + "[]");
        pReleaseTime.attr("required", "required");

        reportTime = newContainer.find(".report-time");
        reportTime.attr("name", "r_" + airlineService.service_id + "[]");

        releaseTime = newContainer.find(".release-time");
        releaseTime.attr("name", "f_" + airlineService.service_id + "[]");

        if (selectedStaff && selectedStaff !== "undefined"){
            newStaff.val(selectedStaff.user_id);
            // PLANNED
            if (selectedStaff.planned_report_time && selectedStaff.planned_report_time != EMPTY_DATETIME)
            {
                pReportTime.val(correctDateFormat(selectedStaff.planned_report_time));
            }
            else if (pReport && pReport != EMPTY_DATETIME)
            {
                pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
            }

            if (selectedStaff.planned_release_time && selectedStaff.planned_release_time != EMPTY_DATETIME)
            {
                pReleaseTime.val(correctDateFormat(selectedStaff.planned_release_time));
            }
            else if (pRelease && pRelease != EMPTY_DATETIME)
            {
                pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
            }

            // ACTUALS
            reportTime.val(selectedStaff.report_time && selectedStaff.report_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.report_time) : "");
            releaseTime.val(selectedStaff.release_time && selectedStaff.release_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.release_time) : "");
        }
        else {
            console.log(pReport +" -> " + obj.report_time);
            console.log(pRelease +" -> " + obj.release_time);

            if (pReport && pReport != EMPTY_DATETIME)
            {
                pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
            }

            if (pRelease && pRelease != EMPTY_DATETIME)
            {
                pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
            }
        }


        newContainer.removeClass("hidden");
        flightContainer.append(newContainer);

        return flightContainer;
    }

    /**
     * Fill Flight Form with flight information
     * @param data
     */
    function fillFlightForm(data) {
        var _form_flight_messages = $("#form_flight_messages"),
            _form = _form_flight_messages.parents('form'),
            _edit_flight_title = $("#edit_flight_title"),
            flight = data.flight, i, l, j,
            flightNumber = flight.flight_number, is_etd, is_atd,
            aircraft = flight.aircraft, titleTemplateHTML,
            delays = flight.delays,
            titleTemplate =
                _.template(CURRENT_IATA_CODE + "-<%= flightNumber %> \"<%= departureCityCode %>\" - \"<%= arrivalCityCode %>\"");

        titleTemplateHTML = titleTemplate({
            flightNumber: flightNumber.flight_number,
            departureCityCode: flightNumber.departure_airport,
            arrivalCityCode: flightNumber.arrival_airport
        });

        // clean form from old values
        clearFlightForm();

        $("#flight_restore_btn").hide();

        $("#flight_update_btn1").show();
        $("#flight_update_btn2").show();

        $("#cancel_flight_div").show();
        $("#remove_flight_div").show();

        _form.find("input").removeAttr("disabled");
        _form.find("select").removeAttr("disabled");
        _form.find("a").removeAttr("disabled");
        _form.find("button").removeAttr("disabled");

        $("#cancel_btn1").show();
        $("#cancel_btn2").show();

    }

    function OperationsFormFilter(airlineIds){
        var flightNumber = $("#flight_number_id");

        flightNumber.children().remove();

        if (typeof airlineIds !== "undefined"){
            airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);
        }
        else {
            airlineIds = false;
        }

        if (!airlineIds || airlineIds.length == 0){
            $.each(flightNumbersObj, function (i, each) {
                flightNumber.append("<option value='" + each.id  + "'>" + each.sector + "</option>");
            });
        }
        else {
            $.each(flightNumbersObj, function (i, each) {
                if ($.inArray(each.airline_id + "", airlineIds) != -1) {
                    flightNumber.append("<option value='" + each.id + "'>" + each.sector + "</option>");
                }
            });
        }
    }

    function AircraftTypeChange(airlineIds){
        var aircraftType = $("#aircraft_type_id");

        aircraftType.children().remove();

        airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);

        if ($airlineModule){
            $.each(acTypesByAirline, function (j, each) {
                // $.each(array, function (j, each) {
                aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
                // });
            });
        }
        else {
            if (!airlineIds || airlineIds.length == 0) {
                $.each(acTypesByAirline, function (i, array) {
                    $.each(array, function (j, each) {
                        aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
                    });
                });
            } else {
                $.each(airlineIds, function (i, airlineID) {
                    if (airlineID in acTypesByAirline) {
                        $.each(acTypesByAirline[airlineID], function (j, each) {
                            aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
                        });
                    }
                });
            }
        }
    }

    function AircraftChange(airlineIds, flight, typeID){
        var aircraftList = $("#aircraft_id");

        aircraftList.children().remove();

        airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);

        if (typeof typeID === "undefined" || !typeID) {
            if (typeof flight !== "undefined" && flight) {
                if (flight.aircraft) {
                    if (flight.aircraft.aircraft_type_id) {
                        typeID = flight.aircraft.aircraft_type_id;
                    }
                }
                else if (flight.aircraft_type_id) {
                    typeID = flight.aircraft_type_id
                }
            }
        }

        if (typeID){
            if (typeID in aircraftByType) {

                var aType = [];
                $.each(aircraftByType[typeID], function (id, name) {
                    aType.push([id, name]);
                });

                aType.sort(function(a, b)
                {
                    if (a[1] == b[1]) { return 0; }
                    return a[1] > b[1] ? 1 : -1;
                });

                $.each(aType, function (i, eachType) {
                    aircraftList.append("<option value='" + eachType[0] + "'>" + eachType[1] + "</option>");
                });

                /*
                $.each(aircraftByType[typeID], function (id, name) {
                    aircraftList.append("<option value='" + id + "'>" + name + "</option>");
                });
                */
            }
        }
        else {
            if ($airlineModule) {
                $.each(aircraftByAirline, function (j, each) {
                    // $.each(array, function (j, each) {
                    aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                    // });
                });
            }
            else {
                if (!airlineIds || airlineIds.length == 0) {
                    $.each(aircraftByAirline, function (i, array) {
                        $.each(array, function (j, each) {
                            aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                        });
                    });
                } else {
                    $.each(airlineIds, function (i, airlineID) {
                        if (airlineID in aircraftByAirline) {
                            $.each(aircraftByAirline[airlineID], function (j, each) {
                                aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                            });
                        }
                    });
                }
            }
        }
    }

    $(document).on("change", "#airline_id", function () {
        OperationsFormFilter($(this).val());

        AircraftTypeChange($(this).val());

        AircraftChange($(this).val());
    });

    $(document).on("change", "#aircraft_type_id", function () {
        AircraftChange($("#airline_id").val(), false, $(this).val());
    });

    function updatedAircraftByTypeAndAirlineList(data){
        if (typeof data === "undefined" || !data){
            return;
        }

        // Update Flight Number object
        flightNumbersObj = data.flightNumbersObj;
        OperationsFormFilter();
        // end

        // Update other list vars
        //aircraftByAirline = acTypesByAirline = aircraftByType = [];

        if ("acTypesByAirline" in data){
            $.each(data["acTypesByAirline"], function(airlineID, values){
                acTypesByAirline[airlineID] = values;
            })
        }

        if ("aircraftByAirline" in data){
            $.each(data["aircraftByAirline"], function(airlineID, values){
                aircraftByAirline[airlineID] = values;
            })
        }

        if ("aircraftByType" in data){
            // aircraftByType[typeID], function (id, name)
            $.each(data["aircraftByType"], function(typeID, values){
                $.each(values, function(id, name){
                    if (typeof aircraftByType[typeID] === "undefined" || !aircraftByType[typeID]){
                        aircraftByType[typeID] = [];
                    }
                    aircraftByType[typeID][id] = name;
                })
            })
        }
    }

    function setFlightFormCrew(flight){
        if (typeof flight.flightCrew !== "undefined") {
            var captains = flight.flightCrew.captains,
                firstOfficers = flight.flightCrew.firstOfficers,
                flightAttendants = flight.flightCrew.flightAttendants,
                item, item_new, l, j, i, itemEach,
                reasonSpanParent, reportTime;

            var elements = [], ids = [], templates = [], objects = [];

            if (typeof captains === "object") {
                elements.push("#captain");
                elements.push("#captain_dhc");
                elements.push("#captain_standby");

                ids.push("captain");
                ids.push("captain_dhc");
                ids.push("captain_standby");

                templates.push("#flight_captains_crew");
                templates.push("#flight_captains_dhc_crew");
                templates.push("#flight_captain_standby_crew");

                objects.push(captains.general);
                objects.push(captains.dhc);
                objects.push(captains.standby);
            }

            if (typeof  firstOfficers === "object"){
                elements.push("#first_officer");
                elements.push("#first_officer_dhc");
                elements.push("#first_officer_standby");

                ids.push("first_officer");
                ids.push("first_officer_dhc");
                ids.push("first_officer_standby");

                templates.push("#flight_first_officers_crew");
                templates.push("#flight_first_officers_dhc_crew");
                templates.push("#flight_first_officers_standby_crew");

                objects.push(firstOfficers.general);
                objects.push(firstOfficers.dhc);
                objects.push(firstOfficers.standby);
            }

            if (typeof flightAttendants === "object"){
                elements.push("#cabin_crew");
                elements.push("#cabin_crew_dhc");
                elements.push("#cabin_crew_standby");
                elements.push("#cabin_crew_sup");

                ids.push("cabin_crew");
                ids.push("cabin_crew_dhc");
                ids.push("cabin_crew_standby");
                ids.push("cabin_crew_sup");

                templates.push("#flight_cabin_crew_crew");
                templates.push("#flight_cabin_crew_dhc_crew");
                templates.push("#flight_cabin_crew_standby_crew");
                templates.push("#flight_cabin_crew_sup_crew");

                objects.push(flightAttendants.general);
                objects.push(flightAttendants.dhc);
                objects.push(flightAttendants.standby);
                objects.push(flightAttendants.sup);
            }

            $.each(objects, function(n, eachObj){
                $.each(eachObj, function(i, obj){
                //for (i = 0; i < obj.length; i++){
                    j = parseInt(i) + 1;
                    itemEach = $(elements[n] + "" + j);
                    if (i > 0) {
                        // add additional field
                        if (!itemEach.length) {
                            item = $(templates[n]).find("span.item:last");
                            item_new = item.clone();
                            item_new.attr("data-item-number", j);
                            item_new.find("label").html("#" + j);
                            item_new.find("select").attr("id", ids[n] + j);
                            item_new.insertAfter(item);
                        }
                    }
                    itemEach = $(elements[n] + "" + j);
                    //console.log("plain obj " + typeof obj)

                    if ($.isPlainObject(obj)) {
                        itemEach.val(obj.id);

                        // Show Report Time If Exists
                        if (obj.settings.report_time && obj.settings.report_time !== 'undefined' && obj.settings.report_time != EMPTY_DATETIME) {
                            reportTime = moment(obj.settings.report_time).format('YYYY-MM-DD HH:mm');
                        }
                        else {
                            var depInitDate = getFlightDepartureInitialDate(flight);
                            reportTime = moment(depInitDate).subtract({
                                hours: 1,
                                minutes: 15
                            }).format('YYYY-MM-DD HH:mm');
                        }
                        itemEach.parents('span').find('input.reportTime').val(reportTime);

                        // Show Reason If Exists
                        if (obj.settings.reason && obj.settings.reason !== 'undefined') {
                            reasonSpanParent = itemEach.parent().find('span.reason');
                            reasonSpanParent.show();
                            reasonSpanParent.find('select.crewReason').val(obj.settings.reason);
                        }
                    }
                //}
                });
            });
        }
    }

    $(document).on("change", "#cancel_reason", function () {
        cancelReasonCheck();
    });

    function cancelReasonCheck(){
        var _this = $("#cancel_reason"), flight_cancel_btn = $("#flight_cancel_btn");

        if (_this.val() == ""){
            flight_cancel_btn.attr("disabled", "disabled");
        }
        else {
            flight_cancel_btn.removeAttr("disabled");
        }
    }

    $(document).on("change", "#remove_reason", function () {
        removeReasonCheck();
    });

    function removeReasonCheck(){
        var _this = $("#remove_reason"), flight_remove_btn = $("#flight_remove_btn");

        if (_this.val() == ""){
            flight_remove_btn.attr("disabled", "disabled");
        }
        else {
            flight_remove_btn.removeAttr("disabled");
        }
    }

    function addNewDelayAndFill(first_delay, delay) {
        var next_delay = first_delay.clone(),
            duration = moment(delay.duration, "HH:mm:ss");

        next_delay.find("select").val(delay.delay_id);
        next_delay.find("input").val(duration.format("HH:mm"));
        first_delay.after(next_delay);
    }

    /**
     * Hide flight popup event handler
     * @return void
     */
    $("#flight_info_modal, #leave_modal").on("hidden.bs.modal", function (e) {
        //timeline.setSelection([]);
    });

    /**
     * Mouse enter on crew item person to load his image
     */
    $(document).on({
        mouseenter: function () {
            var _this = $(this), user_id = _this.attr("id").replace("user-", ""),
                request;

            _this.attr("data-toggle", "popover")
                .attr("data-trigger", "focus")
                .attr("title", _this.text())
                .attr("data-content", "<div class='user-image center-block'>" +
                "<img src='" + baseUrl + "/assets/img/2.GIF' alt='User Image'/></div>");
            _this.popover({
                "html": true
            });
            _this.popover("show");
            $.ajaxSetup({
                url: baseUrl + "/user/ajaxgetuserimage",
                type: "GET",
                dataType: "json"
            });
            request = $.ajax({
                data: {
                    user_id: user_id
                }
            });
            request.done(function (data) {
                if (typeof data.success !== "undefined") {
                    $(".user-image").empty().append("<img src='" + data.image + "' alt='User Image' width='120' />");
                } else {

                }
            });
            request.fail(function (jqXHR, text_status) {
                showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, $("#da"));
            });
            request.always(function () {
            });
        },
        mouseleave: function () {
            var _this = $(this);
            _this.attr("data-content", "");
            _this.popover("hide");
        }
    }, ".crew-item-person");


    function correctDateFormat(date, format) {
        if (format)
            return moment(date, inputDateFormat).format(format);
        else
            return moment(date, inputDateFormat).format("YYYY-MM-DD HH:mm");
    }

    /**
     * a and b are javascript Date objects
     * @param a
     * @param b
     * @returns {number}
     */
    function dateDiffInDays(a, b) {
        // Discard the time and time-zone information.
        var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
        var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

        return Math.floor((utc2 - utc1) / _MS_PER_DAY);
    }

    /**
     * Mouse over|move|click variables
     * @type {number}
     */
    var delay = 1000, setTimeoutConst, flightHover = null;
    var clicking = false, clickingAndMove = false, doubleClicking = false;

    /* $(document).mousedown(function() {
     clicking = true;
     });
     $(document).mouseup(function() {
     clicking = false;
     });
     $(document).mousemove(function() {
     doubleClicking = false;
     clickingAndMove = !(clicking == false);
     });

     $(document).dblclick(function(){
     doubleClicking = true;
     clicking = false;
     });*/

    $(document).on("click touchstart", ".timeline-event", function () {
        var _this = $(this), flightHover = _this.find(".timeline-event-content>div");
            //flight_info_modal = $('#flight_info_modal');

        /* if (clickingAndMove === true || doubleClicking === true ){ // || clicking === true || _this.hasClass("timeline-event-selected") == true ||
         flightHover = false;
         return false;
         }*/
//            setTimeoutConst = setTimeout(function () {
        /* if (_this.hasClass("timeline-event-selected") == true || clickingAndMove === true || clicking === true) {
         flightHover = false;
         return false;
         }*/

        var flightData = getSelectedEvent(flightHover);

        //console.log(flightData)

        if (!flightData ||
            (!flightData.flight_id && !flightData.airline_service_id && !flightData.leave)) {
            clearFlightForm();
            $("#flight_panel").hide();
            $("#save_panel").hide();

            return false;
        }

        resetLineSelection();


        selectFunction(flightData);

        //}, delay);
    });

    function selectFunction(flightData){
        var requestData, loading = $("#loading-fleetwatch-form");

        airportId = $(".quick-airports.btn-warning").first().attr("data-id");
        console.log("AP ID: " + airportId)
        flightData.airport_id = airportId;

        if (flightData.id) {
            $("#create_all").val(0);
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/staff-watch/ajax-get-flight-staff/" + flightData.id,
                data: flightData
            };
        }
        else if (flightData.airline_service_id) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/staff-watch/ajax-get-flight-staff",
                data: flightData
            };
        }
        else if (flightData.leave) {
            $("#create_all").val(0);
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/staff-watch/ajax-get-flight-staff/" + flightData.id,
                data: flightData
            };

            parseLeave(flightData);
            popupFlight = $("#leave_modal").bPopup({
                closeClass: 'close-btn',
                modal: true
            });

            $("#leave_modal a:first").tab("show");
            // $("#leave_modal").attr("data-leave_id", flightData.id);

            return;
        }
        var create_all = $("#create_all").val();

        var request = $.ajax(requestData);
        request.done(function (data) {

            // activateTab("flight_watch_main_tab", "flightInformationTab");
            // activateTab("flight_by_type_tab", "tabDetails");

            if (typeof data.success !== "undefined") {

                $("#flight_panel").show();
                $("#save_panel").show();

                if (flightData.id || flightData.airline_service_id) {
                    //clearFlightForm();

                    fillFlightForm(data);

                    if (!create_all || create_all == 0){
                        var topOffset, leftOffset,
                            modal_height = $airlineModule ? 630 : 440, // flight_info_modal.outerHeight() > 500 ? 630 : 450, // flight_info_modal.outerHeight(),
                            modal_width  = 980; //flight_info_modal.outerWidth()  > 500 ? 650 : flight_info_modal.outerWidth();

                        topOffset  = Math.max(0, (($(window).height() - modal_height) / 2) + $(window).scrollTop());
                        leftOffset = Math.max(0, (($(window).width() - modal_width) / 2) + $(window).scrollLeft());

                        popupFlight = flight_info_modal.bPopup({
                            //modalClose: false,
                            //opacity: 1,
                            //positionStyle: 'fixed', //'fixed' or 'absolute'
                            //fadeSpeed: 'fast', //can be a string ('slow'/'fast') or int
                            //followSpeed: "fast", //can be a string ('slow'/'fast') or int
                            closeClass: 'close-btn',
                            modal: true,
                            follow: [false, false], //x, y
                            position: [leftOffset, topOffset],
                            /*
                            onOpen: function() {
                                $('#accordion').on('shown.bs.collapse', function () {

                                    setTimeout(function() {
                                        var crew_panel = $("#crew_information_panel"),
                                            fuel_panel = $("#fuel_information_panel"),
                                            crew_panel_height = crew_panel.height(),
                                            fuel_panel_height = fuel_panel.height();
                                        if (crew_panel_height > fuel_panel_height) {
                                            fuel_panel.height(crew_panel_height);
                                        } else {
                                            crew_panel.height(fuel_panel_height);
                                        }
                                    }, 1);
                                });
                            }
                            */
                        });

                        $("#flight_info_modal ul.nav a:first").tab("show");

                        parseFlight(data, flightData.id);

                        $("#id").val(flightData.id);

                        flight_info_modal.attr('data-id', flightData.id);
                        flight_info_modal.attr('data-flight_id', flightData.flight_id);
                        flight_info_modal.attr('data-airline_service_id', flightData.airline_service_id);
                        flight_info_modal.attr('data-sla', flightData.sla);
                        flight_info_modal.attr('data-flight_number_id', data.flight.flight_number_id);
                        flight_info_modal.attr('data-std', data.flight.std);
                    }

                    // update vars
                    //console.log(flightData)
                    $("#airline_service_id").val(flightData.airline_service_id);
                    $("#flight_id").val(flightData.flight_id);
                    $("#flight_number_id").val(data.flight.flight_number_id);

                    //console.log(data.flight.id)

                    //var generalTab = $(document).find("#progressbar_container");
                    // getFlightPosition(data.flight)

                    var header = $("<div></div>");
                    header.append($("<h2 class='margin-0'>").text(data.flight.fn + " | " + data.flight.sector));
                    var loadSLA = $("<a class='color-red font-sm' style='border-bottom: 1px solid red; cursor:pointer'>").text("(Load all SLAs')");
                    loadSLA.on("click", function () {
                        loading.show();
                        $("#create_all").val(1);
                        flightData.id = 0;
                        flightData.all = 1;
                        selectFunction(flightData);
                    });
                    header.append(loadSLA)
                    $("#fn").html(header);


                    if (flightData.all) {
                        // Hide if no services found
                        if (!data.serviceData || !data.serviceData.services || !data.serviceData.services.length){
                            $("#create_all").val(0);
                            $("#flight_panel").hide();
                            $("#save_panel").hide();
                        }
                        else {
                            fillStaffForm(data);
                        }
                    }
                    else {
                        fillSingleStaffForm(data);
                    }
                    // fillMVTMessages(data);
                }
            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            loading.hide();
            $("body").removeClass("loading");
        });
    }

    $(document).on("mouseleave", ".timeline-event", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;
    });

/**
 * On document ready
 */
$(function () {
    $("#go_to_date").datetimepicker({
        format: "Y-m-d",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
    });

    /**
     * Reset button click event handler
     * @return void
     */
    $("#btn-clear-go-to-date").on("click", function () {
        if ($("#go_to_date").val()) {
            $(this).attr("disabled", true);
            $("#btn-go-to-date").attr("disabled", true);
            $("#go_to_date").val("");
            $("#go_to_date_form").submit();
            //return true;
        }
        //return false
    });
});
