"use strict";

/**
 * Created by Compas on 26.08.14.
 */
// Applies + 1
var MAX_ALLOWED_FLIGHT_CREW = 2,
    MAX_ALLOWED_FLIGHT_CREW_DHC = 4,
    MAX_ALLOWED_FLIGHT_CREW_STANDBY = 2,
    MIN_ALLOWED_FLIGHT_CREW = 0,
    MIN_ALLOWED_FLIGHT_CREW_DHC = 0,
    MIN_ALLOWED_FLIGHT_CREW_STANDBY = 0,

    MAX_ALLOWED_CABIN_CREW = 7,
    MAX_ALLOWED_CABIN_CREW_DHC = 9,
    MAX_ALLOWED_CABIN_CREW_SUP = 9,
    MAX_ALLOWED_CABIN_CREW_STANDBY = 2,
    MIN_ALLOWED_CABIN_CREW = 3,
    MIN_ALLOWED_CABIN_CREW_DHC = 0,
    MIN_ALLOWED_CABIN_CREW_STANDBY = 0,

    MAX_ALLOWED_DIVERSIONS = 3;

/**
 * Captains sync all fields
 */
/*
 var captainsSync = new SelectSync([
 "#captain1",
 "#captain2",
 "#captain3",
 "#captain_dhc1",
 "#captain_dhc2",
 "#captain_dhc3",
 "#captain_standby1"
 ]);
 */

var _form_flight_messages = $("#form_flight_messages");

/**
 * Clear Crew SelectBoxes
 * @param maxNumber
 * @param selector
 */
function clearCrewSelectboxes(maxNumber, selector){
    var crew;
    for (var i = 0; i <= maxNumber; i++){
        crew = $(selector + i);
        if (crew.length)
            crew.val('');
    }
}

/*
$('input.airport').typeahead({
    name:   'typeahead',
    remote: baseUrl + 'operation/ajax-search-airport?key=%QUERY',
    limit : 10
});
*/

var searchAirports = new Bloodhound({

    datumTokenizer: Bloodhound.tokenizers.obj.whitespace('value'),
    queryTokenizer: Bloodhound.tokenizers.whitespace,
    remote: {
        url: baseUrl + '/staff-watch/ajax-search-airport?key=%QUERY',
        wildcard: '%QUERY'
    }
});

// Initializing the typeahead with remote dataset without highlighting
$('.typeahead').typeahead(null, {
    name: 'countries',
    source: searchAirports,
    limit: 10 /* Specify max number of suggestions to be displayed */
});


$(document).on("click", "i.add-staff", function () {
    var _this = $(this), staff_container = _this.parent().prev("div.staff-container"),
        num = parseInt(staff_container.attr("data-num")), max = parseInt(staff_container.attr("data-max")),
        new_container = staff_container.clone();

    if (num < max){
        new_container.attr("data-num", ++num);
        new_container.insertAfter(staff_container);
    }
}).on("click", "i.remove-staff", function () {
    var _this = $(this), staff_container = _this.parent().prev("div.staff-container"),
        num = parseInt(staff_container.attr("data-num")), max = parseInt(staff_container.attr("data-max"));

    if (num > 1){
        staff_container.remove();
    }
});

$(document).on("click", "a#occ_sla", function () {

    var _this = $(this), loading = $("#loading-fleetwatch-data"), airportId = "", airportIds = [], airlineIds = [];

    loading.show();

    var occ_selected = _this.hasClass("btn-warning");

    if (occ_selected){
        airportId = _this.parent().find(".quick-airports.btn-warning").attr("data-id");
        if (!airportId){
            var item = _this.parent().find(".quick-airports").first();
            airportId = item.attr("data-id");
            item.addClass("btn-warning");
        }
    }
    else {
        _this.parent().find(".quick-airports.btn-warning").removeClass("btn-warning");
    }
    /*
    var selectedAirports = _this.parent().find(".quick-airports.btn-warning");

    selectedAirports.each(function(){
        airportIds.push($(this).attr("data-id"));
    });
    */

    var selectedAirlines = _this.parent().find(".quick-airlines.selected");

    selectedAirlines.each(function(){
        airlineIds.push($(this).attr("data-id"));
    });

    var timeObj = timeline.getVisibleChartRange();

    var start_visible_time = moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"),
        end_visible_time = moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss");


    console.log("AP ID: " + airportId);
    var request = $.ajax({
        url:  baseUrl + "/staff-watch/quick-link",

        data : {
            start_visible_time  : start_visible_time,
            end_visible_time    : end_visible_time,
            airport_id          : airportId,
            airport_ids         : airportIds,
            airline_ids         : $("#airline").val(), //airlineIds,
            occ                 : occ_selected ? 0 : 1,
        }
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true),
                start_time = moment(data.start_visible_period).format("YYYY-MM-DD HH:mm:ss"),
                end_time = moment(data.end_visible_period).format("YYYY-MM-DD HH:mm:ss");

            //new Date(year, month, day, hours, minutes, seconds, milliseconds)
            var start = new Date(
                moment(start_time).get('year'),
                moment(start_time).get('month'),
                moment(start_time).get('date'),
                moment(start_time).get('hour'),
                moment(start_time).get('minute'),
                moment(start_time).get('second')
            );

            var end = new Date(
                moment(end_time).get('year'),
                moment(end_time).get('month'),
                moment(end_time).get('date'),
                moment(end_time).get('hour'),
                moment(end_time).get('minute'),
                moment(end_time).get('second')
            );

            timeline.setVisibleChartRange(start, end);
            //timeline.setVisibleChartRange(start_time, end_time);

            //if (flights.length) {
            timeline.setData(flights);
            timeline.redraw();
            //}

            // $(document).find("a.quick-airports").removeClass("btn-warning");
            if (occ_selected){
                _this.removeClass("btn-warning");
            }
            else {
                _this.addClass("btn-warning");
            }

            /*
            if (_this.text() == "ALL"){
                $(document).find("a.quick-airports").removeClass("btn-warning");

                _this.addClass("btn-warning");
            }
            else {
                $(document).find("#all_stations").removeClass("btn-warning");

                if (_this.hasClass("btn-warning")){
                    _this.removeClass("btn-warning");
                }
                else {
                    _this.addClass("btn-warning");
                }
            }
             */
        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});


$(document).on("click", "a.quick-airports", function () {

    var _this = $(this), airportId = _this.attr("data-id"), loading = $("#loading-fleetwatch-data"),
        date = $(".cancel_btn"), airportIds = [], airlineIds = [];

    loading.show();

    airportIds.push($(this).attr("data-id"));
    /*
    var selectedAirports = _this.parent().find(".quick-airports.btn-warning");

    selectedAirports.each(function(){
        airportIds.push($(this).attr("data-id"));
    });
    */

    // Remove OCC
    $("a#occ_sla").removeClass("btn-warning");

    var selectedAirlines = _this.parent().find(".quick-airlines.selected");

    selectedAirlines.each(function(){
        airlineIds.push($(this).attr("data-id"));
    });

    var timeObj = timeline.getVisibleChartRange();

    var start_visible_time = moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"),
        end_visible_time = moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss");

    console.log("AP ID: " + airportId);
    var request = $.ajax({
        url:  baseUrl + "/staff-watch/quick-link",

        data : {
            start_visible_time  : start_visible_time,
            end_visible_time    : end_visible_time,
            airport_id          : airportId,
            airport_ids         : airportIds,
            airline_ids         : $("#airline").val(), //airlineIds,
            occ                 : $("a#occ_sla").hasClass("btn-warning") ? 1 : 0
        }
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true),
                start_time = moment(data.start_visible_period).format("YYYY-MM-DD HH:mm:ss"),
                end_time = moment(data.end_visible_period).format("YYYY-MM-DD HH:mm:ss");

            //new Date(year, month, day, hours, minutes, seconds, milliseconds)
            var start = new Date(
                moment(start_time).get('year'),
                moment(start_time).get('month'),
                moment(start_time).get('date'),
                moment(start_time).get('hour'),
                moment(start_time).get('minute'),
                moment(start_time).get('second')
            );

            var end = new Date(
                moment(end_time).get('year'),
                moment(end_time).get('month'),
                moment(end_time).get('date'),
                moment(end_time).get('hour'),
                moment(end_time).get('minute'),
                moment(end_time).get('second')
            );

            timeline.setVisibleChartRange(start, end);
            //timeline.setVisibleChartRange(start_time, end_time);

            //if (flights.length) {
            timeline.setData(flights);
            timeline.redraw();
            //}

            $(document).find("a.quick-airports").removeClass("btn-warning");
            _this.addClass("btn-warning");

            /*
            if (_this.text() == "ALL"){
                $(document).find("a.quick-airports").removeClass("btn-warning");

                _this.addClass("btn-warning");
            }
            else {
                $(document).find("#all_stations").removeClass("btn-warning");

                if (_this.hasClass("btn-warning")){
                    _this.removeClass("btn-warning");
                }
                else {
                    _this.addClass("btn-warning");
                }
            }
             */
        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});

$(document).on("click", ".quick-airlines", function () {

    var _this = $(this), airlineId = _this.attr("data-id"), loading = $("#loading-fleetwatch-data"),
        date = $(".cancel_btn"), airlineIds = [], airportIds = [];

    var selectedAirlines = _this.parent().find(".quick-airlines.selected");

    selectedAirlines.each(function(){
        airlineIds.push($(this).attr("data-id"));
    });

    var selectedAirports = _this.parent().find(".quick-airports.btn-warning");

    selectedAirports.each(function(){
        airportIds.push($(this).attr("data-id"));
    });

    loading.show();

    var timeObj = timeline.getVisibleChartRange();

    var start_visible_time = moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"),
        end_visible_time = moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss");

    console.log("AP ID: " + airportId);
    var request = $.ajax({
        url:  baseUrl + "/staff-watch/quick-link",

        data : {
            start_visible_time  : start_visible_time,
            end_visible_time    : end_visible_time,
            airline_id          : airlineId,
            airport_ids         : airportIds,
            airline_ids         : $("#airline").val(), //airlineIds,
            occ                 : $("a#occ_sla").hasClass("btn-warning") ? 1 : 0

        }
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true),
                start_time = moment(data.start_visible_period).format("YYYY-MM-DD HH:mm:ss"),
                end_time = moment(data.end_visible_period).format("YYYY-MM-DD HH:mm:ss");

            //new Date(year, month, day, hours, minutes, seconds, milliseconds)
            var start = new Date(
                moment(start_time).get('year'),
                moment(start_time).get('month'),
                moment(start_time).get('date'),
                moment(start_time).get('hour'),
                moment(start_time).get('minute'),
                moment(start_time).get('second')
            );

            var end = new Date(
                moment(end_time).get('year'),
                moment(end_time).get('month'),
                moment(end_time).get('date'),
                moment(end_time).get('hour'),
                moment(end_time).get('minute'),
                moment(end_time).get('second')
            );

            timeline.setVisibleChartRange(start, end);
            //timeline.setVisibleChartRange(start_time, end_time);

            //if (flights.length) {
            timeline.setData(flights);
            timeline.redraw();
            //}

            if (_this.text() == "ALL"){
                $(document).find(".quick-airlines").removeClass("selected");

                _this.addClass("selected");
            }
            else {
                $(document).find("#all_airlines").removeClass("selected");

                if (_this.hasClass("selected")){
                    _this.removeClass("selected");
                }
                else {
                    _this.addClass("selected");
                }
            }
        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});

$(document).on("click", "#btn_go_to_date", function () {

    prevNextCurrDate($(this));

    return false;
});

$(document).on("click", "#btn_prev_date", function () {

    var go_to_date = $("#go_to_date"), curr_date = moment(go_to_date.val());
    var prev = curr_date.subtract(1, 'd').format("YYYY-MM-DD");
    go_to_date.val(prev);

    prevNextCurrDate($(this));

    return false;
});

$(document).on("click", "#btn_next_date", function () {

    var go_to_date = $("#go_to_date"), curr_date = moment(go_to_date.val());
    var next = curr_date.add(1, 'd').format("YYYY-MM-DD");
    go_to_date.val(next);

    prevNextCurrDate($(this));

    return false;
});


function prevNextCurrDate(container){
    var  parent = container.parents("form"), url = parent.attr("action"), loading = $("#loading-fleetwatch-data"),
         cancel_btn = $("#cancel_btn1");

    loading.show();

    var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
        airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

    $.each(airportSelected, function(i, item){
        airportIDs.push($(item).attr("data-id"));
    });

    // $.each(airlineSelected, function(i, item){
    //     airlineIDs.push($(item).attr("data-id"));
    // });

    $("#go_to_date_airport_id").val(airportIDs);
    // $("#go_to_date_airline_id").val(airlineIDs);

    var request = $.ajax({
        data: {
            "go_to_date"   : $("#go_to_date").val(),
            "airport_id"   : airportIDs,
            "airline_id"   : $("#airline").val(), //airlineIDs,
            occ            : $("a#occ_sla").hasClass("btn-warning") ? 1 : 0
        },
        url:  url,
        type: parent.attr("method") // not POST, laravel won't allow it
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true),
                start_time = moment(data.start_visible_period).format("YYYY-MM-DD HH:mm:ss"),
                end_time = moment(data.end_visible_period).format("YYYY-MM-DD HH:mm:ss");

            //new Date(year, month, day, hours, minutes, seconds, milliseconds)
            var start = new Date(
                moment(start_time).get('year'),
                moment(start_time).get('month'),
                moment(start_time).get('date'),
                moment(start_time).get('hour'),
                moment(start_time).get('minute'),
                moment(start_time).get('second')
            );

            var end = new Date(
                moment(end_time).get('year'),
                moment(end_time).get('month'),
                moment(end_time).get('date'),
                moment(end_time).get('hour'),
                moment(end_time).get('minute'),
                moment(end_time).get('second')
            );

            timeline.setVisibleChartRange(start, end);
            //timeline.setVisibleChartRange(start_time, end_time);

            //if (flights.length) {
            timeline.setData(flights);
            timeline.redraw();
            //}

            // Update Flight tracker
            // updateFlightTracker(data);

            cancel_btn.click();
        }

    });

    request.always(function(){
        loading.hide();
    });

}

$(document).on("submit", "#form_flight_watch", function () {

    var _this = $(this), url = _this.attr("action"), loading = $("#loading-fleetwatch-form"),
        start_date_input = _this.find("#start_date"), end_date_input = _this.find("#end_date"),
        cancel_btn = $("#cancel_btn1");

    var id = _this.find("#id").val(), flightID = _this.find("#flight_id").val(), airline_service_id = _this.find("#airline_service_id").val();
    console.log("ID: " + id);

    var timeObj = timeline.getVisibleChartRange();
    start_date_input.val(moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"));
    end_date_input.val(moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss"));

    console.log("VISIBLE RANGE:");
    console.log(timeline.getVisibleChartRange());

    var formUrl =  baseUrl + (id && id > 0 ? '/staff-watch/' + id + '/edit' : "/staff-watch/create") ;

    loading.show();


    // Airport IDs filters
    var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
        airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

    airportId = $(".quick-airports.btn-warning").first().attr("data-id");
    console.log(airportId)
    // $.each(airportSelected, function(i, item){
    //     airportIDs.push($(item).attr("data-id"));
    // });
    $("#create_airport_id").val(airportId);
    $("#create_airline_id").val($("#airline").val());

    // $.each(airlineSelected, function(i, item){
    //     airlineIDs.push($(item).attr("data-id"));
    // });

    // $("#create_airport_id").val(implode(airportIDs, ","));
    // $("#create_airline_id").val(implode(airlineIDs, ","));

    var request = $.ajax({
        data: _this.serialize(),
        url:  formUrl,
        type: _this.attr("method") // not POST, laravel won't allow it
    });

    request.success(function(data){

        if (typeof data.success !== "undefined") {

            if (typeof data.error !== "undefined" && data.error){
                messageBlock.html("<span class='text-red'>" + data.message + "</span>");
                return;
            }

            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true);

            if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();
            }

            updatedAircraftByTypeAndAirlineList(data);

            // updateFlightTracker(data);

            cancel_btn.click();
        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});

$(document).on("submit", "#form_flight_watch_cancellation, #form_flight_watch_remove", function () {

    var _this = $(this), url = _this.attr("action"), loading = $("#loading-fleetwatch-form"),
        cancel_btn = $("#cancel_btn1");

    var flightID = _this.find("#flight_id").val();

    loading.show();

    var request = $.ajax({
        data: _this.serialize(),
        url:  url,
        type: _this.attr("method") // not POST, laravel won't allow it
    });

    request.success(function(data){

        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true);

            if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();
            }

            updatedAircraftByTypeAndAirlineList(data);

            cancel_btn.click();
        }


    });

    request.always(function(){
        loading.hide();
    });

    return false;
});


/**
 * Clear Fleet Watch Input Form
 */
function clearFlightForm() {
    var i, crew, _edit_flight_title = $("#edit_flight_title");
    _form_flight_messages.empty();
    _edit_flight_title.empty().hide();
    _edit_flight_title.find("legend").html("");


    $("#airline_id, #aircraft_type_id").val("");
    $("#flight_id, #aircraft_id, #flight_number_id").val("");
    $("#capacity_c, #capacity_y").val("");
    $("#std, #ptd, #sta, #eta, #ata, #pta, #etd, #atd, #abn, #tdn").val("");
    $("#gate_parking, #gate_boarding").val("");
    $("#pax_a_booked,#pax_c_booked, #pax_w_booked, #pax_y_booked, #pax_inf_booked").val("");
    $("#pax_a_actual,#pax_c_actual, #pax_w_actual, #pax_y_actual, #pax_inf_actual").val("");
    $("#baggage, #baggage_pcs, #cargo, #cargo_pcs, #eic, #mail, #deportees, #in_tanks, #uplifted, #utilised, #defuel, #departure_fuel, #arrival_fuel").val("");
    $("#diverted_flight").val("");


    //  Added on APR 19
    OperationsFormFilter(false);

    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW, "#first_officer");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_STANDBY, "#first_officer_standby");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_DHC, "#first_officer_dhc");

    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW, "#captain");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_STANDBY, "#captain_standby");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_DHC, "#captain_dhc");

    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW, "#cabin_crew");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_STANDBY, "#cabin_crew_standby");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_DHC, "#cabin_crew_dhc");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_SUP, "#cabin_crew_sup");

    $("#flight_captains_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW + ")").remove();
    $("#flight_captain_standby_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_STANDBY + ")").remove();
    $("#flight_captains_dhc_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_DHC + ")").remove();

    $("#flight_first_officers_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW + ")").remove();
    $("#flight_first_officers_standby_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_STANDBY + ")").remove();
    $("#flight_first_officers_dhc_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_DHC + ")").remove();

    $("#flight_cabin_crew_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW + ")").remove();
    $("#flight_cabin_crew_standby_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW_STANDBY + ")").remove();
    $("#flight_cabin_crew_dhc_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW_DHC + ")").remove();

    $("#is_diversion").attr("checked", false);
    $("input.reportTime").val("");
    $("span.reason").hide();

    $("#diversion_airport").removeAttr("required");
    $("#diversion_airport").val("");
    $("#diversion_airport_block").hide();
    $("#diversion_panel").hide();
    $("#diversion_pta, #diversion_eta, #diversion_ata, #diversion_abn, #diversion_ptd, #diversion_etd, #diversion_tdn, #diversion_atd").val("");

    $("#remark").val("");

    $("#cancel_reason").val("");
    $("#remove_reason").val("");
    $("#flight_cancel_btn").attr("disabled", "disabled");
    $("#flight_remove_btn").attr("disabled", "disabled");

    $("#manual_operator").attr("checked", false);
    $("#manual_ac_type").attr("checked", false);
    $("#manual_ac").attr("checked", false);
    $("#ac_type").val("");
    $("#ac").val("");
    $("#ac_type, #ac").removeAttr("required");

    $("#manual_flt_no").attr("checked", false);
    $("#manual_flt_no_div").hide();
    $("#flt_no").val("");
    $("#departure_airport").val("");
    $("#arrival_airport").val("");
    $("#flight_type").val("");

    $("#manual_operator_container, #manual_ac_type_container, #manual_ac_container").hide();


    var delayIds = $(".delay_id"), delayTimes = $(".delay_time");
    delayIds.val("");
    delayTimes.val("");
    $("#delay_total").val("");

    // Remove every element except staff list element initial;
    $("div.staff-list").not("#initial-staff-list").remove();

    // Remove Staff Info
    $("#staff-container").children().remove();
}

/**
 * Clear MVT Form
 */
function clearMVTForm(){
    $("#mvt_type").removeClass("color-red").text("MVT");

    $("#mvt_correction").attr("checked", false);
    $("#arr_mvt_correction").attr("checked", false);

    $("#mvt_flt_no, #mvt_dep_date, #mvt_dep_ap, #mvt_arr_ap").text("");
    $("#mvt_ac, #mvt_atd, #mvt_etd, #mvt_abn, #mvt_eta, #mvt_pax_total, #mvt_pax_a, #mvt_pax_c, #mvt_pax_w, #mvt_pax_y, #mvt_pax_inf, #mvt_fob, #mvt_tof, #mvt_eet, #mvt_pic, #mvt_si").val("");

    $("#dep_message_layout, #arr_message_layout").val("");
    $("#mvt_baggage, #mvt_cargo, #mvt_mail, #mvt_eic").val("");

    $("#mvt_dl1_code, #mvt_dl2_code, #mvt_dl3_code, #mvt_dl1_time, #mvt_dl2_time, #mvt_dl3_time").val("");

        // ARR FIELDS
    $("#arr_mvt_flt_no, #arr_mvt_dep_date, #arr_mvt_ap").text("");
    $("#arr_mvt_ac, #arr_mvt_tdn, #arr_mvt_ata, #arr_mvt_rf,#arr_mvt_pic, #arr_mvt_si").val("");
    //$("#arr_mvt_pic").val("");

    // Clear MVT Boxes Before Loading

    $('#departure_message_mvt').val('');
    $('#departure_message_subject').val('');

    $('#arrival_message_mvt').val('');
    $('#arrival_message_subject').val('');
}


function DelayFieldSet(){
    var std = $('#std'), etd = $('#etd'), atd = $('#atd');

    if (atd.val() || etd.val()) {
        var stdDate = moment(std.val()), etdDate = moment(etd.val()), atdDate = moment(atd.val()), delayTotal = "00:00";
        var etd_delay = etd.val() && etdDate.isAfter(stdDate) ? etdDate.diff(stdDate, 'm') : false;
        var atd_delay = atd.val() && atdDate.isAfter(stdDate) ? atdDate.diff(stdDate, 'm') : false;
        if ((etd_delay && etd_delay >= 1) || (atd_delay && atd_delay >= 1)) {
            var delay_timing = atd_delay ? atd_delay : etd_delay;
            var hours = Math.floor( delay_timing / 60);
            var minutes = delay_timing % 60;
            delayTotal = ( hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes);
            $("#delay_total").val(delayTotal);

            $(".delay_id").attr("disabled", false);
            $(".delay_time").attr("disabled", false);
            $("#add-delay-btn").attr("disabled", false);
            $("#remove-delay-btn").attr("disabled", false);
            return;
        }
    }

    $(".delay_id").attr("disabled", true);
    $(".delay_time").attr("disabled", true);
    $("#add-delay-btn").attr("disabled", true);
    $("#remove-delay-btn").attr("disabled", true);
}


function CheckDelayTimeForLimitation(element) {

    var delays = element.find("input").not("[name=delay_total]"), first_delay = delays.first(), total_delay = moment($("#delay_total").val(), "HH:mm"),
        total_delay_duration = moment.duration(total_delay), delay_each, delay_each_duration, currentVal, delay_each_mins = 0,
        total_duration_mins = total_delay_duration.asMinutes(), delay_message = $('#delay_message');

    for (var i = 0, l = delays.length; i < l; i++) {
        currentVal = $(delays[i]).val();
        delay_each = moment(currentVal, "HH:mm");
        delay_each_duration = moment.duration(delay_each);
        delay_each_mins += delay_each_duration.asMinutes();
    }
    if (delay_each_mins > total_duration_mins){
        delay_message.show();
    }
    else {
        delay_message.hide();
    }
}

function CleanCrewChangeForm(){
    var crewChangeLayout = $('.crew-change-process');

    crewChangeLayout.find('#crew-position').text("");
    crewChangeLayout.find('#crew-name').text("");
    crewChangeLayout.find('#crew-last-ytd').text("");
    crewChangeLayout.find('#crew-last-365').text("");
    crewChangeLayout.find('#crew-last-28').text("");
    crewChangeLayout.find('#crew-last-7').text("");
    crewChangeLayout.find('#crew-message-box').html("");
    crewChangeLayout.find('#flights-table').hide();
    crewChangeLayout.find('#flights-table-body').html("");
    //crewChangeLayout.find('.crew-indicators-label').text("");

}

$(function () {

    var TAB_GENERAL = "general",
        TAB_STAFF = "staff",
        TAB_PNL = "pnl",
        TAB_PRL = "prl",
        TAB_MVT = "mvt",
        TAB_LDM = "ldm",
        TAB_CPM = "cpm",
        TAB_PSM = "psm",
        TAB_PTM = "ptm",
        TAB_UCM = "ucm",
        TAB_TPM = "tpm",
        TAB_SLS = "sls",
        TAB_LPM = "lpm",
        TAB_LDS = "lds",
        TAB_NOT = "not",
        TAB_OTHS = "oths",
        TAB_FHR = "fhr",

        crew = $(".crew"),
        crewChangeLayout = $('.crew-change-process');

    $(document).on("change", ".crew", function () {
        return;

        var _this = $(this), crewType = _this.attr("data-crew-type"), position = _this.attr("data-crew-position"),
            pos = _this.offset();

        crewChangeLayout.show();

        var loading = crewChangeLayout.find("#crew-loading"),
            layoutCrewPosition = crewChangeLayout.find('#crew-position'),
            layoutCrewName =  crewChangeLayout.find('#crew-name'),
            layoutCrewYTD =  crewChangeLayout.find('#crew-last-ytd'),
            layoutCrew365 =  crewChangeLayout.find('#crew-last-365'),
            layoutCrew28 =  crewChangeLayout.find('#crew-last-28'),
            layoutCrew7 =  crewChangeLayout.find('#crew-last-7'),
            layoutMessageBox =  crewChangeLayout.find('#crew-message-box'),
            layoutflightsTable =  crewChangeLayout.find('#flights-table'),
            layoutflightsTableBody =  crewChangeLayout.find('#flights-table-body');

        crewType = crewType === undefined ? "" : crewType;

        crewChangeLayout.css({
            top: (pos.top + 20) + "px",
            left: (pos.left) + "px"
        }).show();

        console.log("60".toHHMMSS());

        CleanCrewChangeForm();
        loading.show();

        var request = $.ajax({
            url: baseUrl + "/fleetwatch/ajax-get-crew-info",
            type: "GET",
            data: {
                id :        _this.val(),
                crew_type : crewType,
            }
        });



        request.done(function (data) {
            if (data.success){
                var hours = data.hours,
                    flights = data.flights,
                    user = data.user;

                layoutCrewPosition.text("(" + user.position_title + ")");
                layoutCrewName.text(user.first_name + " " + user.last_name);

                layoutCrewYTD.text(hours.yearToDate ? (hours.yearToDate * 3600).toString().toHHMM() : "-");
                layoutCrew365.text(hours.last365days ? (hours.last365days * 3600).toString().toHHMM() : "-");
                layoutCrew28.text(hours.last28days ? (hours.last28days * 3600).toString().toHHMM() : "-");
                layoutCrew7.text(hours.last7days ? (hours.last7days * 3600).toString().toHHMM() : "-");

                layoutflightsTable.show();
                layoutflightsTableBody.html(data.flightsTable);
            }
            else {
                layoutMessageBox.html(error_box.text(data.message));
            }
        });

        request.fail(function () {
            layoutMessageBox.html(error_box.text("Error! Request failed. Please try again"));
        });

        request.always(function () {
            loading.hide();
        });
    });

    $(document).on("click", ".crew-change-process button.close", function () {
       crewChangeLayout.hide();
    });

    $(document).on('change', '#atd, #etd', function () {
         DelayFieldSet();
    });

    $(document).on('change', '.delay_time', function () {
        CheckDelayTimeForLimitation($(this).parents('.form-inline'));
    });

    /**
     * Create date time picker fields
     * @return void
     */
    $(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    $(".timepicker").datetimepicker({
        format: "H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1,
        datepicker: false,
        value: "00:00"
    });


    $(document).on("click", "#remove-delay-btn", function() {
        var _this = $(this), parent = _this.parents(".delay-panel"), all_delays = parent.find('.item-delay'),
            item_delay = parent.find('.item-delay:last');
        if (all_delays.length > 1){
            item_delay.remove();
        }
        else {
            item_delay.find("select").val("");
            item_delay.find("input[type='text']").val("00:00");
        }
    });


    /**
     * Add delay button click handler
     * @return void
     */
    $(document).on("click", "#add-delay-btn", function() {
        var _this = $(this), parent = _this.parents(".delay-panel"),
            item_delay = parent.find('.item-delay:first'), last, duration;

        var clone_item_delay = item_delay.clone(), p = $("<p/>");
        clone_item_delay.find("select").val("");
        duration = clone_item_delay.find("input[type='text']").val("00:00");

        last = parent.find(".item-delay:last");
        clone_item_delay.insertAfter(last);

        duration.datetimepicker({
            format: "H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            step: 1,
            dayOfWeekStart: 1,
            datepicker: false
        });
    });

    /**
     * Add person button click handler
     * @return {Boolean}
     */
    $(".add-person").on("click", function () {
        var _this = $(this), _prev = _this.prev().clone(), maxAllowed = parseInt(_this.attr('data-maxAllowed')),
            field_name = _this.attr("data-field"), dateInput,
            item_number = parseInt(_prev.attr("data-item-number"));

        // Enable Remove Button
        _this.next('.remove-person').attr('disabled', false);

        if (item_number == maxAllowed) {
            _this.attr("disabled", true);
            showMessage("Not more available", "Information", MESSAGE_INFO, $("#form_flight_messages"));
            return false;
        }

        item_number++;
        _prev.attr("data-item-number", item_number);
        _prev.find("label:first").html("No." + item_number);
        _prev.find("select:first")
            .val("")
            .attr("id", field_name + item_number);
        _prev.find('span.reason').hide();

        var html = $("<div></div>").append(_prev).html();
        $(html).insertBefore(_this);

        AddDateFormatElement($("input.reportTime"), "Y-m-d H:i", true, 5);
        reasonShowOnCrewChange();

        return true;
    });

    reasonShowOnCrewChange();

    $(document).on("click", "input[type=radio].mvt_dep_type", function () {
        var _this = $(this),
            // DEP FIELDS
            mvt_atd = $("#mvt_atd"),
            mvt_abn = $("#mvt_abn"),
            mvt_eta = $("#mvt_eta"),

            mvt_etd = $("#mvt_etd"),

            mvt_ad_container = $("#mvt_ad_container"),
            mvt_ed_container = $("#mvt_ed_container"),
            mvt_pax_container = $("#mvt_pax_container"),
            mvt_baggage_container = $("#mvt_baggage_container"),
            mvt_fuel_container = $("#mvt_fuel_container"),
            mvt_pic_container = $("#mvt_pic_container");

        switch (_this.val()){
            case "ad":
                mvt_atd.attr("required", "required");
                mvt_etd.removeAttr("required");

                mvt_ad_container.show();
                mvt_ed_container.hide();

                mvt_pax_container.show();
                mvt_baggage_container.show();
                mvt_fuel_container.show();
                mvt_pic_container.show();
                break;

            case "ed":
                mvt_atd.removeAttr("required");
                mvt_etd.attr("required", "required");

                mvt_ad_container.hide();
                mvt_ed_container.show();

                mvt_pax_container.hide();
                mvt_baggage_container.hide();
                mvt_fuel_container.hide();
                mvt_pic_container.hide();
                break;
        }


        console.log(_this.val())
    });


    $(".remove-person").on('click', function(){
        var _this = $(this), parent = _this.parent('div'), lastCrew = parent.find('span.item:last'),
            minAllowed = _this.attr('data-minAllowed'), itemNumber = lastCrew.attr('data-item-number');

        // Enable Add Person Button
        _this.prev('.add-person').attr('disabled', false);

        if (itemNumber == minAllowed){
            if (minAllowed == 1){
                lastCrew.find('select, input').val('');
                lastCrew.find('span.reason').hide();
            }
            else {
                _this.attr('disabled', true);
            }
            return false;
        }

        lastCrew.remove();
        return true;

    });

    /**
     * Tab click handler, load appropriate tab content
     * @return void
     */
    $('#main-tabs > li > a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
        var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", "");

        if (current_tab_name == "crew_list"){
            current_tab_name = "crew list";
        }

        switch (current_tab_name) {
            case TAB_GENERAL:
                break;

            case TAB_STAFF:
                break;

            case TAB_MVT:
                loadMVTMessages();
                break;

            case TAB_PRL:
                loadPLList(PRL);
                break;

            case TAB_PNL:
                loadPLList(PNL);
                break;

            default:
                loadMessages(current_tab_name);
                break;
        }
    });

    /**
     * Is diversion checkbox change event handler
     * @return void
     */
    $("#is_diversion").on("change", function () {
        var _this = $(this), diverted_flight = $("#diverted_flight").val();

        if (_this.is(":checked")) {
            $("#diversion_airport_block").show();
            $("#diversion_airport").attr("required", "required");
            //if (!diverted_flight) {
                $("#diversion_panel").show();
                //$("#diversion_pta").attr("required", "required");
                //$("#diversion_ptd").attr("required", "required");
            //}
        } else {
            $("#diversion_airport_block").hide();
            $("#diversion_airport").removeAttr("required");

            $("#diversion_panel").hide();
            //$("#diversion_pta").removeAttr("required");
            //$("#diversion_ptd").removeAttr("required");
        }
    });

    $("#manual_operator").on("change", function () {
        var _this = $(this);
        if (_this.is(":checked")) {
            $("#manual_operator_container").show();
            $("#operator_name").attr("required", "required");
            $("#airline_id").removeAttr("required");
        } else {
            $("#manual_operator_container").hide();
            $("#operator_name").removeAttr("required");
            $("#airline_id").attr("required", "required");
        }
    });

    $("#manual_ac_type").on("change", function () {
        var _this = $(this);
        if (_this.is(":checked")) {
            $("#manual_ac_type_container").show();
            $("#ac_type").attr("required", "required");
        } else {
            $("#manual_ac_type_container").hide();
            $("#ac_type").removeAttr("required");
        }
    });

    $("#manual_ac").on("change", function () {
        var _this = $(this);
        if (_this.is(":checked")) {
            $("#manual_ac_container").show();
            $("#ac").attr("required", "required");
        } else {
            $("#manual_ac_container").hide();
            $("#ac").removeAttr("required");
        }
    });

    /**
     * Manual Flight No Selection
     */
    $("#manual_flt_no").on("change", function () {
        var _this = $(this);
        if (_this.is(":checked")) {
            $("#manual_flt_no_div").show();
            $("#flt_no").attr("required", "required");
            $("#departure_airport").attr("required", "required");
            $("#arrival_airport").attr("required", "required");
            $("#flight_type").attr("required", "required");
            $("#flight_number_id").removeAttr("required");
        } else {
            $("#manual_flt_no_div").hide();
            $("#flt_no").removeAttr("required");
            $("#departure_airport").removeAttr("required");
            $("#arrival_airport").removeAttr("required");
            $("#flight_type").removeAttr("required");
            $("#flight_number_id").attr("required", "required");
        }
    });

    /**
     * Flight form cancel button click handler
     * @return void
     */
    $(".cancel_btn").on("click", function () {
        var _form = $(this).parents('form');

        clearFlightForm();
        EnableStdSta();

        // Added on Apr 19 2019
        OperationsFormFilter();
        AircraftTypeChange();
        AircraftChange();

        timeline.setSelection([]);
        $("#flight_add_btn").show();

        $("#cancel_flight_div").hide();
        $("#remove_flight_div").hide();

        $("#flight_update_btn1").hide();
        $("#flight_update_btn2").hide();

        $("#cancel_btn1").hide();
        $("#cancel_btn2").hide();

        $("#flight_restore_btn").hide();
        $("#flight_panel").hide();

        _form.find("input").removeAttr("disabled");
        _form.find("select").removeAttr("disabled");
        _form.find("a").removeAttr("disabled");
        _form.find("button").removeAttr("disabled");
    });


    /**
     * Set PTD Value equal to STD value if Empty
     */
    $("#std").on("change", function () {
        var _this = $(this), ptd = $('#ptd');
        if (ptd.val() == ""){
            ptd.val(_this.val());
        }
    });

    /**
     * Set PTA value equal to STA value if Empty
     */
    $("#sta").on("change", function () {
        var _this = $(this), pta = $('#pta');
        if (pta.val() == ""){
            pta.val(_this.val());
        }
    });

    $("#etd").on("change", function () {
        var _this = $(this), sta = $('#sta'), std = $('#std'),
            pta = $('#pta'), ptd = $('#ptd'), eta = $('#eta'),
            duration, minutes, from, to;

        if (!_this.val()){
            return;
        }

        if (std.val() && sta.val()){
            from = std.val();
            to = sta.val();
        }
        else if (ptd.val() && pta.val()){
            from = ptd.val();
            to = pta.val();
        }
        else {
            return;
        }

        duration = moment.duration(moment(to).diff(from));
        minutes = duration.asMinutes();

        //if (eta.val() == ""){
            eta.val(moment( _this.val() ).add(minutes, 'm').format("YYYY-MM-DD HH:mm"));
        //}
    });

    function EnableStdSta(){
        var std = $('#std'), sta = $("#sta");

        std.removeAttr('disabled');
        sta.removeAttr('disabled');

        //std.attr('required', 'required');
        //sta.attr('required', 'required');
    }


    /**
     * Flight form flight number select box change handler
     * @return void
     */
    $("#flight_number_id").on("change", function () {
        var _this = $(this), flight_number_id = _this.val(), request,
            flight_number = parseInt(_this.find('option:selected').html()),
            outbound_flight_number_id = $("#outbound_flight_number_id");

        return;

        $("#outbound_flight_number_block").hide();
        if (flight_number_id) {
            if (isEven(flight_number)) {
                _this.attr("disabled", true);
                request = $.ajax({
                    type: "GET",
                    url: baseUrl + "/flight/ajax-flight-get-parent-flight",
                    dataType: "json",
                    data: {
                        flight_number_id: flight_number_id,
                        flight_number: flight_number
                    }
                });
                request.done(function (data) {

                    if (typeof data.success !== "undefined") {
                        showMessage(data.message, "Success!", MESSAGE_SUCCESS, _form_flight_messages);
                        // show parent flight numbers select box

                        if (typeof data.flights !== "undefined") {
                            $("#outbound_flight_number_block").show();
                            outbound_flight_number_id.attr('required', 'required');
                            outbound_flight_number_id.find("option:not(:first)").remove();
                            for (var i = 0, l = data.flights.length; i < l; i++) {
                                outbound_flight_number_id.append("<option value='" + data.flights[i].id + "'>" +
                                data.flights[i].label + "</option>")
                            }
                        }
                    } else {
                        outbound_flight_number_id.removeAttr('required');
                        showMessage(data.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
                    }
                });
                request.fail(function (jqXHR, text_status) {
                    showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, _form_flight_messages);
                });
                request.always(function () {
                    _this.attr("disabled", false);
                });
            }
            else {
                outbound_flight_number_id.removeAttr('required');
            }
        }
    });

    /**
     * Send departure MVT message button click handler
     * @return void
     */
    $("#send-departure-message-btn, #send-arrival-message-btn").on("click", function () {
        var _this = $(this), id = _this.attr("id"), request, subject, message, notification_mvt_block;
        if (id == "send-departure-message-btn") {
            message = $("#departure_message_mvt");
            subject = $("#departure_message_subject");
            notification_mvt_block = $("#departure-mvt-notification");
        } else {
            message = $("#arrival_message_mvt");
            subject = $("#arrival_message_subject");
            notification_mvt_block = $("#arrival-mvt-notification");
        }

        // todo: need to add validation for delay ID if flight was delayed

        if (!message.val()) {
            return false;
        }

        _this.attr('disabled', true).html('Processing...');
        request = $.ajax({
            headers: {
                'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/flight/ajax-send-mvt-message",
            type: "POST",
            dataType: "json",
            data: {
                subject: subject.val(),
                message: message.val()
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                message.val("");
                showMessage(data.message, data.title, MESSAGE_SUCCESS, notification_mvt_block);
            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, notification_mvt_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, notification_mvt_block);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Send Message");
        });
    });

    /**
     * Load PNL passengers list
     * @return void
     */
    function loadPNLList() {
        var request, pnl_message_block = $("#pnl-message-block"),
            pnl_table = $('#pnl-table'), pnl_container = $("#pnl-container"),
            pnl_table_body = $("#pnl-table-body"), fare;

        //if (pnl_table.attr('data-opened') == "1")
        //    return;


        pnl_message_block.empty();
        pnl_table_body.empty();

        var loading = $('<h1 class="ajax-loading-animation"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
        //pnl_table_body.append(loading);

        pnl_container.prepend(loading);

        // send AJAX request to load passengers list
        request = $.ajax({
            url: baseUrl + "/passenger/ajax-get-pnl-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                std: flight_info_modal.attr('data-std'),
                flight_id: flight_info_modal.attr('data-flight_id'),
                flight_number_id: flight_info_modal.attr('data-flight_number_id'),
            }
        });
        request.done(function (data) {
            if (typeof data.passengers !== "undefined") {
                if (data.passengers.length) {
                    pnl_table_body.empty();
                    for (var i = 0, l = data.passengers.length; i < l; i++) {
                        pnl_table_body.append("<tr class='text-center'>" +
                        "<td>" + (i + 1) + "</td>" +
                        "<td data-left>" + data.passengers[i].last_name + "</td>" +
                        "<td data-left>" + (data.passengers[i].first_name ? data.passengers[i].first_name : "") + "</td>" +
                        "<td data-left>" + data.passengers[i].ticket_number + "</td>" +
                        "<td>" + data.passengers[i].coupon + "</td>" +
                        "<td data-left>" + (data.passengers[i].sales_date ? data.passengers[i].sales_date : "") + "</td>" +
                        "<td data-right>" + (data.passengers[i].fare ? parseFloat(data.passengers[i].fare).toFixed(0) : "") + "</td>" +
                        "<td data-left>" + (data.passengers[i].fare_basis ? data.passengers[i].fare_basis : "") + "</td>" +
                        "<td>" + (data.passengers[i].rbd ? data.passengers[i].rbd : "") + "</td>" +
                        "</tr>");
                    }
                    $("#pnl-table").show();
                    //ApplyTableFilter("#pnl-table", ASSETS_URL);

                    //ApplyTablesorter("#pnl-table");
                } else {
                    $("#pnl-table").hide();
                    showMessage("Not found any passengers in this flight", "No Result!", MESSAGE_INFO, pnl_message_block);
                }
            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, pnl_message_block);
            }
        });
        request.always(function () {
            pnl_table.attr("data-opened", "1");
            pnl_message_block.find('.ajax-loading-flight-info').remove();
            loading.remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, pnl_message_block);
        });
    }

    /**
     * Load PL passengers list
     * @return void
     */
    function loadPLList(type) {
        var request, pl_message_block = $("#pl-message-block"), fare, i, l, flight_number,
            pl_container = $("#" + type + "-container"), weight, n, data,
            pl_table = $("#" + type + "-table"),
            pl_table_body = $("#" + type + "-table-body"), icons,

            pl_data_container = $("#" + type + "-data-container"),

            pl_details_table = $("#" + type + "-details-table"),
            pl_details_table_body = $("#" + type + "-details-table-body"),

            pl_outbound_table = $("#" + type + "-outbound-table"),
            pl_outbound_table_body = $("#" + type + "-outbound-table-body"),
            pl_inbound_table = $("#" + type + "-inbound-table"),
            pl_inbound_table_body = $("#" + type + "-inbound-table-body"),
            pl_xbag_table = $("#" + type + "-xbag-table"),
            pl_xbag_table_body = $("#" + type + "-xbag-table-body"),
            pl_docs_table = $("#" + type + "-docs-table"),
            pl_docs_table_body = $("#" + type + "-docs-table-body"),

            pl_tab_info = $("#" + type + "-tab-info"),
            pl_tab_content = $("#" + type + "-tab-content"),

            outbound_icon = '<i class="fa fa-sm fa-sign-out"></i>',
            inbound_icon = '<i class="fa fa-sm fa-sign-in"></i>',
            xbag_icon = '<i class="fa fa-sm fa-suitcase"></i>',

            message_block = $(".message-block[data-type=" + type +"]");

        //if (pl_table.attr('data-opened') == "1")
        //    return;

        pl_message_block.empty();
        pl_table_body.empty();
        pl_details_table_body.empty();
        pl_outbound_table_body.empty();
        pl_inbound_table_body.empty();
        pl_xbag_table_body.empty();
        pl_data_container.empty();

        if (pl_docs_table.length){
            pl_docs_table_body.empty();
        }

        $("#" + type + "-data-no").text("");
        $("#" + type + "-passenger-no").text("");
        $("#" + type + "-outbound-no").text("");
        $("#" + type + "-inbound-no").text("");
        $("#" + type + "-xbag-no").text("");
        $("#" + type + "-docs-no").text("");

        // Select 1st PL tab
        pl_tab_info.find("li.active").removeClass("active");
        pl_tab_info.find("li").first().addClass("active");  // this activates the profile tab

        pl_tab_content.find(".tab-pane.active").removeClass("active");
        pl_tab_content.find(".tab-pane").first().addClass("active");

        pl_tab_content.find(".tab-pane").first().find(".message-block").empty();

        var loading = $('<h1 class="ajax-loading-animation loading"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
        //pl_table_body.prepend(loading);

        pl_container.prepend(loading);

        // send AJAX request to load passengers list
        request = $.ajax({
            url: baseUrl + "/passenger/ajax-get-pl-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                type: type,
                std: flight_info_modal.attr('data-std'),
                flight_id: flight_info_modal.attr('data-flight_id'),
                flight_number_id: flight_info_modal.attr('data-flight_number_id'),
            }
        });
        request.done(function (data) {

            if (typeof data.pl_data !== "undefined" && data.pl_data.length > 0 ) {
                $("#" + type + "-data-no").text(data.pl_data.length);
                pl_data_container.empty();
                for (var i = 0; i < data.pl_data.length; i++) {
                    pl_data_container.append("<div class='message-item'>" +
                            "<pre>" + data.pl_data[i] +"</pre>" +
                        "</div>");
                }
            } else {
                showMessage(type.toUpperCase()+ " messages not found.", "Result: Found 0.", MESSAGE_INFO, message_block);
            }

            if (typeof data.pl !== "undefined") {
                var psn = data.pl.length;
                if (data.pl_inf.length){
                    psn += "+" + data.pl_inf.length;
                }

                $("#" + type + "-passenger-no").text(psn);
                $("#" + type + "-outbound-no").text(data.pl_outbound.length);
                $("#" + type + "-inbound-no").text(data.pl_inbound.length);
                $("#" + type + "-details-no").text(data.pl_details.length);
                $("#" + type + "-xbag-no").text(data.pl_xbag.length);
                $("#" + type + "-docs-no").text(data.pl_docs.length);

                if (data.pl.length > 0) {
                    pl_table_body.empty();
                    var last_seq_no = 0, td_class, tr_class, ticket_number;

                    for (i = 0, l = data.pl.length; i < l; i++) {
                        icons = "";

                        if (data.pl[i].seq_no){
                            if (last_seq_no + 1 == data.pl[i].seq_no){
                                td_class = "num_conseq";
                            }
                            else {
                                td_class = "";
                            }
                            last_seq_no = data.pl[i].seq_no;
                        }
                        else {
                            td_class = "";
                        }

                        if (data.pl[i].outbound && data.pl[i].inbound){
                            //icons += outbound_icon + inbound_icon;
                            tr_class = 'outbound-inbound';
                        }
                        else if (data.pl[i].outbound){
                            //icons += outbound_icon;
                            tr_class = 'outbound';
                        }
                        else if (data.pl[i].inbound){
                            //icons += inbound_icon;
                            tr_class = 'inbound';
                        }
                        else {
                            tr_class = "";
                        }

                        if (data.pl[i].xbag_wt){
                            icons += xbag_icon;
                        }

                        ticket_number = (data.pl[i].ticket_number  ? data.pl[i].ticket_number : '');
                        fare = parseFloat(data.pl[i].fare).toFixed(0);
                        pl_table_body.append("<tr class='text-center " + tr_class + "'>" +
                            "<td class=''>" + (i + 1) + "</td>" +
                            "<td class='" + td_class +"'>" + (data.pl[i].seq_no ? data.pl[i].seq_no : ("-")) + "</td>" +
                            "<td data-left><div class='inline'>" + icons + "</div></td>" +
                            "<td data-left>" + (data.pl[i].first_name ? data.pl[i].first_name : "") + "</td>" +
                            "<td data-left>" + data.pl[i].last_name + "</td>" +
                            "<td>" + (data.pl[i].gender         ? getGenderAbbr(data.pl[i].gender) : '') + "</td>" +
                            "<td>" + (data.pl[i].seat_number    ? data.pl[i].seat_number    : '') + "</td>" +
                            "<td>" + (data.pl[i].group_tcp    ? data.pl[i].group_tcp    : '') + "</td>" +
                            "<td data-left class='" + (!ticket_number ? "error" : "") +"'>" + (ticket_number ? ticket_number : "N/A") + "</td>" +
                            "<td>" + (data.pl[i].coupon         ? data.pl[i].coupon    : '') + "</td>" +
                            "<td>" + (data.pl[i].pnr    ? data.pl[i].pnr    : '') + "</td>" +
                            "<td>" + (data.pl[i].ff_airline ? data.pl[i].ff_airline : "") + (data.pl[i].ff_no ?  data.pl[i].ff_no : "") + "</td>" +
                            //"<td>" + (data.pl[i].cabin          ? data.pl[i].cabin          : '') + "</td>" +
                            //"<td data-right>" + (data.pl[i].baggage_pcs    ? data.pl[i].baggage_pcs    : '') + "</td>" +
                            //"<td data-right>" + (data.pl[i].baggage_weight ? data.pl[i].baggage_weight : '') + "</td>" +
                            //"<td data-left>" + (data.pl[i].dob            ? data.pl[i].dob            : '') + "</td>" +
                        "</tr>");

                        if (data.pl[i].inf){
                            $.each(data.pl[i].inf, function (j, inf) {
                                ticket_number = (inf.ticket_number  ? inf.ticket_number : '');
                                fare = parseFloat(inf.fare).toFixed(0);
                                pl_table_body.append("<tr class='text-center inf'>" +
                                    "<td>INF</td>" +
                                    "<td>-</td>" +
                                    "<td><i class='fa fa-chevron-up'></i></td>" +
                                    "<td data-left>" + (inf.first_name ? inf.first_name : "") + "</td>" +
                                    "<td data-left>" + inf.last_name + "</td>" +
                                    "<td>" + "</td>" +
                                    "<td>" + (inf.seat_number   ? inf.seat_number    : '') + "</td>" +
                                    "<td>" + (inf.group_tcp     ? inf.group_tcp    : '') + "</td>" +
                                    "<td data-left class='" + (!ticket_number ? "error" : "") +"'>" + (ticket_number ? ticket_number : "N/A") + "</td>" +
                                    "<td>" + (inf.coupon        ? inf.coupon    : '') + "</td>" +
                                    "<td>" + (inf.pnr           ? inf.pnr    : '') + "</td>" +
                                    "<td>" + "</td>" +
                                    "</tr>");
                            })
                        }
                    }
                    $("#" + type + "-table").show();
                    //ApplyTablesorter();
                }
                else {
                    pl_table.hide();
                    showMessage("Not found any passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }

                if (data.pl_details.length > 0) {
                    pl_details_table_body.empty();
                    var tags, tagsArray;
                    for (i = 0, l = data.pl_details.length; i < l; i++) {

                        flag = data.pl_details[i].resident_country ? "flag flag-" + data.pl_details[i].resident_country.toLowerCase() : "";

                        tags = "";
                        if (data.pl_details[i].tag_number){
                            tags = "<select>";

                            tagsArray = explode(";", data.pl_details[i].tag_number);

                            $.each(tagsArray, function(j, item){
                                tags += "<option>" + item + "</option>";
                            });

                            tags += "</select>";
                        }

                        pl_details_table_body.append("<tr class='text-center'>" +
                            "<td>" + (i + 1) + "</td>" +
                            "<td data-left>" + (data.pl_details[i].first_name ? data.pl_details[i].first_name : "") + "</td>" +
                            "<td data-left>" + data.pl_details[i].last_name + "</td>" +
                            //"<td data-left>" + '<img style="margin-right:5px;" class="' +  flag + '" src="' + baseUrl + "/smart/img/blank.gif" + '" alt="">' +
                            //    (data.pl_details[i].resident_country ? data.pl_details[i].resident_country : "") +
                            //"</td>" +
                            //"<td data-left>" + (data.pl_details[i].address ? data.pl_details[i].address : "") + "</td>" +
                            "<td data-left>" + data.pl_details[i].baggage_pcs + "</td>" +
                            "<td data-left>" + data.pl_details[i].baggage_weight + "</td>" +
                            "<td data-left>" + tags + "</td>" +
                            "</tr>");
                    }
                    pl_details_table.show();
                }
                else {
                    pl_details_table.hide();
                    //showMessage("Not found any inbound passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }

                if (data.pl_outbound.length > 0) {
                    pl_outbound_table_body.empty();
                    console.log(data.pl_outbound)
                    for (i = 0, l = data.pl_outbound.length; i < l; i++) {
                        flight_number = data.pl_outbound[i].outbound.airline + " ";
                        flight_number += data.pl_outbound[i].outbound.flight_number;

                        // if (data.pl_outbound[i].ptm_pax || data.pl_outbound[i].baggage_pcs){
                            pl_outbound_table_body.append("<tr class='text-center'>" +
                                "<td>" + (i + 1) + "</td>" +
                                "<td data-left>" + (data.pl_outbound[i].first_name ? data.pl_outbound[i].first_name : "") + "</td>" +
                                "<td data-left>" + data.pl_outbound[i].last_name + "</td>" +
                                "<td data-left>" + flight_number + "</td>" +
                                "<td>" + (data.pl_outbound[i].outbound.rbd              ? data.pl_outbound[i].outbound.rbd : '-') + "</td>" +
                                "<td>" + (data.pl_outbound[i].outbound.departure_date   ? data.pl_outbound[i].outbound.departure_date : '-') + "</td>" +
                                "<td>" + (data.pl_outbound[i].outbound.destination      ? data.pl_outbound[i].outbound.destination : '-') + "</td>" +

                                "<td data-left>" + (data.pl_outbound[i].ptm_name_str ? data.pl_outbound[i].ptm_name_str : "") + "</td>" +
                                "<td>" + (data.pl_outbound[i].ptm_pax ? data.pl_outbound[i].ptm_pax : "") + "</td>" +
                                "<td>" + (data.pl_outbound[i].baggage_pcs ? data.pl_outbound[i].baggage_pcs : "") + "</td>" +
                                "<td data-right>" + (data.pl_outbound[i].baggage_weight ? data.pl_outbound[i].baggage_weight : "" ) + "</td>" +
                                "</tr>");
                        // }
                        /*
                        else {
                            // ptm_extracted
                            pl_outbound_table_body.append("<tr class='text-center'>" +
                                "<td>" + (i + 1) + "</td>" +
                                "<td data-left>" + (data.pl_outbound[i].first_name ? data.pl_outbound[i].first_name : "") + "</td>" +
                                "<td data-left>" + data.pl_outbound[i].last_name + "</td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "<td data-left></td>" +
                                "</tr>");
                        }
                         */

                    }
                    pl_outbound_table.show();
                }
                else {
                    pl_outbound_table.hide();
                    //showMessage("Not found any outbound passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }

                if (data.pl_inbound.length > 0) {
                    pl_inbound_table_body.empty();

                    for (i = 0, l = data.pl_inbound.length; i < l; i++) {
                        flight_number = data.pl_inbound[i].inbound.airline + " ";
                        flight_number += data.pl_inbound[i].inbound.flight_number;

                        pl_inbound_table_body.append("<tr class='text-center'>" +
                            "<td>" + (i + 1) + "</td>" +
                            "<td data-left>" + (data.pl_inbound[i].first_name ? data.pl_inbound[i].first_name : "" ) + "</td>" +
                            "<td data-left>" + data.pl_inbound[i].last_name + "</td>" +
                            "<td data-left>" + flight_number + "</td>" +
                            "<td>" + (data.pl_inbound[i].inbound.rbd              ? data.pl_inbound[i].inbound.rbd : '-') + "</td>" +
                            "<td>" + (data.pl_inbound[i].inbound.arrival_date   ? data.pl_inbound[i].inbound.arrival_date : '-') + "</td>" +
                            "<td>" + (data.pl_inbound[i].inbound.origin   ? data.pl_inbound[i].inbound.origin : '-') + "</td>" +
                            "</tr>");
                    }
                    pl_inbound_table.show();
                }
                else {
                    pl_inbound_table.hide();
                    //showMessage("Not found any inbound passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }

                if (data.pl_xbag.length > 0) {
                    pl_xbag_table_body.empty();

                    for (i = 0, l = data.pl_xbag.length; i < l; i++) {
                        weight = "";
                        if (data.pl_xbag[i].xbag_info){
                            weight += data.pl_xbag[i].xbag_info[0] + " ";
                        }
                        if (data.pl_xbag[i].xbag_wt) {
                            weight += data.pl_xbag[i].xbag_wt + "KG" + " ";
                        }
                        if (data.pl_xbag[i].xbag_info && data.pl_xbag[i].xbag_info.length > 1){
                            weight += data.pl_xbag[i].xbag_info[1];
                        }

                        pl_xbag_table_body.append("<tr class='text-center'>" +
                            "<td>" + (i + 1) + "</td>" +
                            "<td data-left>" + (data.pl_xbag[i].first_name ? data.pl_xbag[i].first_name : "") + "</td>" +
                            "<td data-left>" + data.pl_xbag[i].last_name + "</td>" +
                            "<td data-left>" + (data.pl_xbag[i].xbag_qty ? (data.pl_xbag[i].xbag_qty + "BAGS ") : "") + weight + "</td>" +
                            "</tr>");
                    }
                    pl_xbag_table.show();
                }
                else {
                    pl_xbag_table.hide();
                    //showMessage("Not found any extra-baggage in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }

                if (pl_docs_table.length) {

                    if (data.pl_docs.length > 0) {
                        pl_docs_table_body.empty();
                        var flag;
                        for (i = 0, l = data.pl_docs.length; i < l; i++) {
                            flag = data.pl_docs[i].passport_country ? "flag flag-" + data.pl_docs[i].passport_country.toLowerCase() : ""
                            pl_docs_table_body.append("<tr class='text-center'>" +
                                "<td>" + (i + 1) + "</td>" +
                                "<td data-left>" + (data.pl_docs[i].first_name ? data.pl_docs[i].first_name : "") + "</td>" +
                                "<td data-left>" + data.pl_docs[i].last_name + "</td>" +
                                "<td>" + (data.pl[i].gender ? getGenderAbbr(data.pl[i].gender) : '') + "</td>" +
                                "<td data-left>" + data.pl_docs[i].dob + "</td>" +
                                "<td data-left>" + data.pl_docs[i].passport_num + "</td>" +
                                "<td data-left>" + '<img style="margin-right:5px;" class="' + flag + '" src="' + baseUrl + "/smart/img/blank.gif" + '" alt="">' +
                                (data.pl_docs[i].passport_country ? data.pl_docs[i].passport_country : "") +
                                "</td>" +
                                "<td data-left>" + (data.pl_docs[i].passport_dex ? data.pl_docs[i].passport_dex : "") + "</td>" +
                                "</tr>");
                        }
                        pl_docs_table.show();
                    }
                    else {
                        pl_docs_table.hide();
                        //showMessage("Not found any inbound passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                    }
                }


            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, pl_message_block);
            }
        });
        request.always(function () {
            pl_table.attr("data-opened", "1");
            pl_message_block.find('.ajax-loading-flight-info').remove();
            loading.remove();
            //ApplyTableFilter(".table", baseUrl);

        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, pl_message_block);
        });
    }




    /*
    $(document).on('click', '.flight_update_btn', function () {
       return true;
    });
    */

    /**
     * Save Changes
     */
    $(document).on('click', '.flight_update_btn', function () {

        return true;

        var std = $('#std'), ptd = $('#ptd'), etd = $('#etd'), atd = $('#atd'), abn = $('#abn'),
            sta = $('#sta'), pta = $('#pta'), eta = $('#eta'), tdn = $('#tdn'), ata = $('#ata'),
            flight_time, result;

        flight_time = {
            std : std.val(),
            ptd : ptd.val(),
            etd : etd.val(),
            atd : atd.val(),
            abn : abn.val(),
            sta : sta.val(),
            pta : pta.val(),
            eta : eta.val(),
            tdn : tdn.val(),
            ata : ata.val()
        };

        // Flight Time Validate
        result = flightTimeValidation(flight_time);

        if (!result.status) {
            window.scrollTo(0, 100);
            showMessage(result.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
            return result.status;
        }

        result = checkDuplicateCrewNames();

        if (!result.status) {
            window.scrollTo(0, 100);
            showMessage(result.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
        }

        return result.status;
    });


    /**
     * Check If There are Duplication In Crew Names
     */
    function checkDuplicateCrewNames(){
        var crew = $(".fleetwatch_form").find(".crew"), id, crewIds = [], duplicateFound = false,
            duplicateCrewName = [], _this;


        crew.each(function () {
            _this = $(this);
            // Remove Has-Error Class
            _this.parent().removeClass('has-error');
            id = _this.val();
            if (id && id !== ''){
                // if In Array Then => Duplicate Found
                if ($.inArray(id, crewIds) != -1){
                    duplicateFound = true;
                    duplicateCrewName.push(_this.find(':selected').text());
                    _this.parent().addClass("has-error");
                }
                crewIds.push(id);
            }

        });

        if (duplicateFound){
            return {
                status : false,
                message: 'Crew: ' + implode(duplicateCrewName, ', ') + ' is duplicated. No duplication is Allowed.'
            };
        }

        // Return True If All Checks Passed
        return {
            status : true,
            message: 'Success'
        };

    }


    /**
     *
     * @param flight_time
     * @returns {*}
     */
    function flightTimeValidation(flight_time){
        // Flight MUST HAVE STD & STA
        if (flight_time.std && flight_time.std != emptyDate && flight_time.sta && flight_time.sta != emptyDate){
            // STD, STA check
            if (moment(flight_time.sta).isBefore(flight_time.std)){ return false;}

            // STD, STA check
            if (moment(flight_time.pta).isBefore(flight_time.ptd)){ return false;}

            // ETD Check If Exists
            if (flight_time.etd){
                if (flight_time.eta || flight_time.ata){
                    if (flight_time.eta) {
                        if (moment(flight_time.eta).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > ETA (ETD should not exceed ETA)'
                            };
                        }
                    }

                    if (flight_time.ata) {
                        if (moment(flight_time.ata).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > ATA (ETD should not exceed ATA)'
                            };
                        }
                    }

                    if (flight_time.tdn) {
                        if (moment(flight_time.tdn).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > TDN (ETD should not exceed TDN)'
                            };
                        }
                    }
                }
                else {
                    if (moment(flight_time.sta).isBefore(flight_time.etd)){
                        return {
                            status : false,
                            message: 'Please Fill Out ETA'
                        };
                    }
                }
            }

            // ATD Check If Exists
            if (flight_time.atd){
                if (flight_time.eta || flight_time.ata){
                    if (flight_time.ata || flight_time.tdn){
                        if (flight_time.ata) {
                            if (moment(flight_time.ata).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > ATA (ATD should not exceed ATA)'
                                };
                            }
                        }
                        if (flight_time.tdn) {
                            if (moment(flight_time.tdn).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > TDN (ATD should not exceed TDN)'
                                };
                            }
                        }
                    }
                    else {
                        if (flight_time.eta) {
                            if (moment(flight_time.eta).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > ETA (ATD should not exceed ETA)'
                                };
                            }
                        }
                    }
                }
                else {
                    if (moment(flight_time.sta).isBefore(flight_time.atd)){
                        return {
                            status : false,
                            message: 'Please Fill Out ETA'
                        };
                    }
                }
            }

            // ABN Check If Exists
            if (flight_time.abn){

                // If Atd is Empty OR if ATD is After ABN -> FALSE
                if (!flight_time.atd || (moment(flight_time.atd).isAfter(flight_time.abn))){
                    if (!flight_time.atd) {
                        return {
                            status: false,
                            message: 'Please Fill Out ATD'
                        };
                    }
                    else {
                        return {
                            status: false,
                            message: 'Error! ATD cannot exceed ABN'
                        };
                    }
                }


                if ( flight_time.ata || flight_time.tdn){
                    if (flight_time.ata) {
                        if (moment(flight_time.ata).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > ATA (ABN should not exceed ATA)'
                            };
                        }
                    }
                    if (flight_time.tdn) {
                        if (moment(flight_time.tdn).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > TDN (ABN should not exceed TDN)'
                            };
                        }
                    }
                }
                else {
                    if (flight_time.eta) {
                        if (moment(flight_time.eta).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > ETA (ABN should not exceed ETA)'
                            };
                        }
                    }
                    else {
                        if (moment(flight_time.sta).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'Please Fill Out ETA'
                            };
                        }
                    }
                }
            }

            // If TDN is After ATA -> FALSE
            if (flight_time.tdn){
                if (!flight_time.atd){
                    return {
                        status : false,
                        message: 'Please Fill Out ATD'
                    };
                }
                if (!flight_time.abn){
                    return {
                        status : false,
                        message: 'Please Fill Out ABN'
                    };
                }
                if (moment(flight_time.tdn).isAfter(flight_time.ata)){
                    return {
                        status : false,
                        message: 'TDN > ATA (TDN should not exceed ATA)'
                    };
                }
            }

            // Return True If All Checks Passed
            return {
                status : true,
                message: 'Success'
            };

        }

        return {
            status : true,
            message: 'Success'
        };
    }

    function getGenderIcon(gender){
        if (gender){
            if (gender.toUpperCase() == 'MALE' || gender == "M") {
                return '<i class="fa fa-sm fa-male">';
            }
            else if (gender.toUpperCase() == 'FEMALE' || gender == "F") {
                return '<i class="fa fa-sm fa-female">';
            }
        }
        return gender;
    }

    function getGenderAbbr(gender){
        if (gender){
            if (gender.toUpperCase() == 'MALE'){
                return 'M';
            }
            else if (gender.toUpperCase() == 'FEMALE'){
                return 'F';
            }
        }

        return gender;
    }

    /**
     * Load MVT flight messages
     * @return void
     */
    function loadMVTMessages() {
        var request, mvt_message_block = $("#mvt-message-block"), fare,
            mvt_container = $("#mvt-container"), email_body, i, l, readyMessage,
            departure_mvt_container = $("#departure-mvt-container"),
            arrival_mvt_container = $("#arrival-mvt-container");

        mvt_message_block.empty();
        departure_mvt_container.empty();
        arrival_mvt_container.empty();
        mvt_container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-mvt-messages-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id:  $("#flight_info_modal").attr('data-flight_id')
            }
        });
        request.done(function (data) {
            if (typeof data.departureMVT !== "undefined") {
                if (data.departureMVT.length > 0 || data.arrivalMVT.length > 0 ) {

                    console.log(data)
                    departure_mvt_container.empty();
                    var skippedClass;
                    for (i = 0; i < data.departureMVT.length; i++) {
                        skippedClass = data.departureMVT[i].skipped ? "skipped" : "";
                        departure_mvt_container.append("<div class='mvt-message-item " + data.departureMVT[i].type + "'>" +
                            "<pre class='mvt-message " + skippedClass +"'>" + data.departureMVT[i].readyData +"</pre>" +
                            "</div>");
                    }

                    arrival_mvt_container.empty();
                    for (i = 0; i < data.arrivalMVT.length; i++) {
                        skippedClass = data.arrivalMVT[i].skipped ? "skipped" : "";
                        arrival_mvt_container.append("<div class='mvt-message-item " + data.arrivalMVT[i].type + "'>" +
                            "<pre class='mvt-message " + skippedClass +"'>" + data.arrivalMVT[i].readyData +"</pre>" +
                            "</div>");
                    }
                } else {
                    showMessage("Not found any MVT messages for this flight", "No Result!", MESSAGE_INFO, mvt_message_block);
                }
            }
        });
        request.always(function () {
            mvt_container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, mvt_message_block);
        });
    }

    function loadMessages(message_type) {
        var request, message_block = $(".message-block[data-type='" + message_type +"']"),
            container = $(".message-container[data-type='" + message_type +"']");

        message_block.empty();
        container.empty();
        container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-messages",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id:  $("#flight_info_modal").attr('data-flight_id'),
                type: message_type
            }
        });
        request.done(function (data) {
            if (typeof data.messages !== "undefined") {
                console.log(data)
                if (data.messages.length > 0 ) {
                    container.empty();
                    for (var i = 0; i < data.messages.length; i++) {
                        container.append("<div class='message-item'>" +
                                            "<pre>" + data.messages[i] +"</pre>" +
                                         "</div>");
                    }
                } else {
                    showMessage(message_type.toUpperCase()+ " messages not found.", "Result: Found 0.", MESSAGE_INFO, message_block);
                }
            }
        });
        request.always(function () {
            container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
    }

    $(document).on("submit", "#formMVTDeparture, #formMVTArrival", function () {

        var _this = $(this), url = _this.attr("action"), loading = $("#loading-fleetwatch-form"),
            cancel_btn = $("#cancel_btn1");

        loading.show();

        var request = $.ajax({
            data: _this.serialize(),
            url:  url,
            type: _this.attr("method") // not POST, laravel won't allow it
        });

        request.success(function(data){

            if (typeof data.success !== "undefined") {
                var jsonData = data.jsonData,
                    flights = prepareDataForTimeline(jsonData, true);

                if (flights.length) {
                    timeline.setData(flights);
                    timeline.redraw();
                }

                updatedAircraftByTypeAndAirlineList(data);

                cancel_btn.click();
            }

        });

        request.always(function(){
            loading.hide();
        });

        return false;
    });

    function getFlightId() {
    }

    function getFlightNumberId() {
    }

    /**
     * Update fuel fields
     * @return void
     */


    $("#arrival_fuel, #departure_fuel, #utilised").keyup(function (e) {
        calculateFuel($(this));
    })
    .focusout(function () {
        calculateFuel($(this));
    });


    function calculateFuel(element){
        var id = element.attr("id"),
            departure_fuel_element = $("#departure_fuel"),
            arrival_fuel_element = $("#arrival_fuel"),
            utilised_element = $("#utilised"),

            in_tanks = $("#in_tanks").val(),
            uplifted = $("#uplifted").val(),
            utilised = utilised_element.val(),
            departure_fuel = departure_fuel_element.val(),
            arrival_fuel = arrival_fuel_element.val();

        uplifted        = uplifted          ? parseInt(uplifted)        : 0;
        in_tanks        = in_tanks          ? parseInt(in_tanks)        : 0;
        utilised        = utilised          ? parseInt(utilised)        : 0;
        departure_fuel  = departure_fuel    ? parseInt(departure_fuel)  : 0;
        arrival_fuel    = arrival_fuel      ? parseInt(arrival_fuel)    : 0;

        if (!departure_fuel){
            departure_fuel = in_tanks + uplifted;
        }

        if (id == "arrival_fuel") {
            departure_fuel_element.val(departure_fuel);
            utilised_element.val(departure_fuel - arrival_fuel);
        }
        else {
            arrival_fuel_element.val(departure_fuel - utilised);
        }
    }

    /**
     * Click update fuel button
     * @return void
     */
    $("#update-fuel-btn").on("click", function () {
        var flight_id = $("#flight_id").val(), _this = $(this), request;

        _this.attr("disabled", true).html("loading...");
        request = $.ajax({
            url: baseUrl + "/flight/ajax-fuel",
            type: "GET",
            dataType: "json",
            data: {
                flight_id: flight_id
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {

                // UPDATE MVT TAB DATA ALSO
                // !!!!!
                //var flight = data.flight,


                $("#in_tanks").val(parseInt(data.in_tanks)).trigger("keyup");
            } else {
                showMessage("Not found fuel value in previous flight", "Information!", MESSAGE_INFO, messageBlock);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Update Fuel");
        });
    });

});