"use strict";


var loadFlightsBtn = $("button.load-flights"), btnAddAllFlights = $(".add-all"),
    assignedDate = $("#assigned_date"), generateBtn = $("#generate_btn"), saveBtn = $("#save_btn");

function drawVisualization(json, startVisibleDate, endVisibleDate) {

    // Create and populate a data table.
    try {
        var data = new google.visualization.DataTable();
    }
    catch(e){
        return;
    }

    var today = new Date(), date = new Date(), date2 = new Date(),
        start_time = date.setHours(date.getHours() - 12),
        end_time = date2.setHours(date2.getHours() + 12);

    start_time = moment(start_time).utc();
    end_time = moment(end_time).utc();

    var visibleYear = date.getFullYear() + 2,
        visibleMonth = date.getMonth(),
        visibleDay = date.getDate();

    start_time = moment(start_time).format("YYYY-MM-DD HH:mm:ss");
    end_time = moment(end_time).format("YYYY-MM-DD HH:mm:ss");

    if (typeof startVisibleDate !== "undefined" && startVisibleDate != false && typeof endVisibleDate !== "undefined" && endVisibleDate != false) {
        start_time = moment(startVisibleDate).format("YYYY-MM-DD HH:mm:ss");
        end_time = moment(endVisibleDate).format("YYYY-MM-DD HH:mm:ss");
    }

    data.addColumn("datetime", "start");
    data.addColumn("datetime", "end");
    data.addColumn("string", "content");
    data.addColumn("string", "group");
    data.addColumn("string", "className");

    if (json.length) {
        data.addRows(prepareDataForTimeline(json));
    }

    // specify options
    var options = {
        stackEvents: true,
        //start: start_time,
        //end: end_time,
        editable: true,
        animate: true,
        eventMargin: 5,
        eventMarginAxis: 5,
        cluster: true,
        axisOnTop: true,
        snapEvents: false,
        dragAreaWidth: 10,
        groupMinHeight: 35,
        groupsWidth: "100px",
        min: new Date(start_time),
        max: new Date(end_time), //new Date(visibleYear, visibleMonth, visibleDay),
        zoomable: true,
        zoomMin: 1000 * 60 * 60 * 6,     // 4 hours in milliseconds
        zoomMax: 1000 * 60 * 60 * 24,     // 7 days in milliseconds
        showButtonNew: false,
        showNavigation: false,
        showMajorLabels: true,
        width: "100%",
        height: "auto",
        layout: "box",
        /* Have disabled on Nov 15, 19 */
        groupsChangeable: true,
        groupsOrder: function (a, b) {
            if (a.content == b.content) {
                return 0;
            }
            return (a.content < b.content) ? -1 : 1;
        }
    };

    // Instantiate our timeline object
    timeline = new links.Timeline(document.getElementById("mytimeline"));

    // Draw our timeline with the created data and options
    timeline.setOptions(options);

    timeline.draw(data);
    //timeline.draw(data, options);

    //new Date(year, month, day, hours, minutes, seconds, milliseconds)
    var start = new Date(
        moment(start_time).get('year'),
        moment(start_time).get('month'),
        moment(start_time).get('date'),
        moment(start_time).get('hour'),
        moment(start_time).get('minute'),
        moment(start_time).get('second')
    );

    var end = new Date(
        moment(end_time).get('year'),
        moment(end_time).get('month'),
        moment(end_time).get('date'),
        moment(end_time).get('hour'),
        moment(end_time).get('minute'),
        moment(end_time).get('second')
    );


    timeline.setVisibleChartRange(start, end);

    var now = new Date();
    var current_datetime = moment({
        year: now.getUTCFullYear(),
        month: now.getUTCMonth(),
        day: now.getUTCDate(),
        hour: now.getUTCHours(),
        minute: now.getUTCMinutes(),
        second: now.getUTCSeconds()
    });

    timeline.setCurrentTime(current_datetime);
}

function prepareDataForTimeline(json, object) {
    var data = [];
    if (json.length) {
        var item, start_date, end_date;
        for (var i = 0, l = json.length; i < l; i++) {
            item = json[i];
            start_date = item.start_date;
            end_date = item.end_date;

            if (object) {
                data.push({
                    "start": new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                    "end": new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                    "content": item.content,
                    "group": item.group,
                    "className": item.className
                });
            }
            else {
                data.push([
                    new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                    new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                    item.content,
                    item.group,
                    item.className
                ]);
            }
        }
    }
    return data;
}

fromDate.change(function () {
    assignedDate.val($(this).val());
});


$(document).on("click", "form input.assign-date", function () {
    selectedDate = $(this).val();
})
    .on("change", "form input.assign-date", function () {
        var _this = $(this), form = _this.closest("form"),
            flightList = form.find("select.flights-list"), loadFlightInfo = form.find("#load-flight-info"),
            btnAddFlight = form.find(".add-flight");

        var from_date = moment(fromDate.val()), to_date = moment(toDate.val()),
            sel_date = moment(_this.val());

        if (sel_date.isAfter(to_date) || sel_date.isBefore(from_date)){
            alert("Please select date within roster date period!");
            _this.val(fromDate.val());

            return false;
        }

        if (selectedDate !== _this.val()){
            loadFlightInfo.text("");
            flightList.find("option").remove();
            loadFlightsBtn.removeAttr("disabled");
            btnAddFlight.attr("disabled", "disabled");
            btnAddAllFlights.attr("disabled", "disabled");
        }
    })
    .on("click", "form select#airport", function () {selectedAirport = $(this).val();})
    .on("change", "form select#airport", function () {
        var _this = $(this), form = _this.closest("form"), flightList = form.find("select.flights-list"), loadFlightInfo = form.find("#load-flight-info"),
            allFlightContainers = form.find(".flight-container"), btnAddFlight = form.find(".add-flight");

        if (selectedAirport !== _this.val()){
            loadFlightInfo.text("");
            flightList.find("option").remove();
            loadFlightsBtn.removeAttr("disabled");
            btnAddFlight.attr("disabled", "disabled");
            btnAddAllFlights.attr("disabled", "disabled");
            allFlightContainers.remove();
            saveBtn.attr("disabled", "disabled");
        }
    })
    .on("click", "form select#airline", function () {selectedAirline = $(this).val();})
    .on("change", "form select#airline", function () {
        var _this = $(this), form = _this.closest("form"),
            flightList = form.find("select.flights-list"), loadFlightInfo = form.find("#load-flight-info");


        if (selectedAirline !== _this.val()){
            loadFlightInfo.text("");
            flightList.find("option").remove();
            loadFlightsBtn.removeAttr("disabled");
        }
    });


$(document).on("click", "form button.delete-flight", function(){
    var _this = $(this), form = _this.closest("form"), flightContainer = _this.parents(".flight-container"), otherFlightContainers;
    flightContainer.remove();

    otherFlightContainers = form.find(".flight-container");

    var span;
    var i = 0;
    $.each(otherFlightContainers, function(){
        span = $(this).find("span.flight-num");
        if (span.length == 1){
            span.text((++i)+ ") ");
        }
    })
});


$(document).on("click", "form button.save-staff", function(){
    var _this = $(this), form = _this.closest("form"), staff_container = $("#staff_container"),
        flightList = form.find("select.flights-list option");

    var request = $.ajax({
        headers: {
            'x-csrf-token': staffForm.find('input[name=_token]').val()
        },
        //contentType : 'multipart/form-data',
        type        : "POST",
        url         :  baseUrl + "/staff-roster/staff",
        data        : staff_container.serializeArray(),
        //dataType  : "json",
    });

    request.always(function () {

    });

    request.fail(function(){
    });

    request.success(function(data){
        if (data.success)
        {
            // staffSuccessMessage.show();
        }
        else
        {
            // staffFailureMessage.show();
        }
    });
});

function addFlight(form, flightId) {
    var data = flightsData[flightId],
    newContainer, newService, newStaff,
    assignedFlights = form.find(".flight-container"), num = assignedFlights.length,
    assignedContainer = form.find(".assigned-container[data-initial=1]"),
    searchFlightEntry = form.find("input[type=hidden][value='" + flightId +"']");

    if (searchFlightEntry.length){
        return;
    }
    num++;


    var flightContainer = $("<div class='col-md-12 flight-container border-bottom' data-num='" + num + "'></div>");
    var flightInfo = $("<div class='col-md-3' style='padding-top: 0px;'></div>")
        .append($("<button class='btn btn-danger delete-flight'>X</button>"))
        .append($("<span class='margin-left-10 flight-num'></span>").text(num + ") "))
        .append($("<label class='margin-right-5'></label>").text(data.flight))
        // .append(data.flightType)
        .append($("<input name='f_" + num + "' type='hidden' value='" + flightId +"' />"));

    flightContainer.append(flightInfo);
    var serviceNameAndStaffReq;

    $.each(data.services, function(key, airlineService){
        var serviceTypeVariable = airlineService.serviceType;
        if (airlineService.service_timings == 1){
            if (airlineService.service[serviceTypeVariable] != 1){
                // Continue
                return true;
            }
        }
        else {
            if (airlineService[serviceTypeVariable] != 1){
                // Continue
                return true;
            }
        }

        newContainer = assignedContainer.clone();
        newContainer.removeAttr("data-initial");
        newService = newContainer.find(".assigned-service");

        serviceNameAndStaffReq = airlineService.service.abbr;

        switch (serviceTypeVariable) {
            case DEPARTURE_SERVICE:
                serviceNameAndStaffReq += " - " + (airlineService.dep_staff_req ? airlineService.dep_staff_req : airlineService.service.dep_staff_req);
                break;

            case ARRIVAL_SERVICE:
                serviceNameAndStaffReq += " - " + (airlineService.arr_staff_req ? airlineService.arr_staff_req : airlineService.service.arr_staff_req);
                break;

            case TURNAROUND_SERVICE:
                serviceNameAndStaffReq += " - " + (airlineService.turn_staff_req ? airlineService.turn_staff_req : airlineService.service.turn_staff_req);
                break;
        }


        newService.text(serviceNameAndStaffReq);

        newStaff = newContainer.find(".assigned-staff");
        newStaff.attr("name", "s_" + num + "_" + airlineService.service_id + "[]");

        var selected = false;
        $.each(airlineService.eligibleStaff, function(j, staff){

            selected = staff.selected;
            if (typeof servicesByFlight !== "undefined" && servicesByFlight){
                if (typeof servicesByFlight[flightId] !== "undefined" &&
                    typeof servicesByFlight[flightId][airlineService.service_id] !== "undefined" &&
                    $.inArray(staff.user_id, servicesByFlight[flightId][airlineService.service_id]) !== -1)
                {
                    selected = true;
                }
            }

            newStaff.append($("<option value='" + staff.user_id + "'" + (selected ? "selected" : "") + ">" + staff.iata + " - " + staff.first_name + " " + staff.last_name + "</option>"));
        });


        // newStaff.multiselect("rebuild");
        newStaff.multiselect({
            buttonWidth: '500px',
            buttonText: function (options) {
                if (options.length == 0) {
                    return 'None selected <b class="caret"></b>';
                } else {
                    var selected = 0;
                    options.each(function () {
                        selected += 1;
                    });
                    return selected +  ' Selected  <b class="caret"></b>';
                }
            }
        });

        newContainer.removeClass("hidden");
        flightContainer.append(newContainer);
    });

    form.append(flightContainer);
}


var staff_travel = $(document).find('.staff_travel');

staff_travel.on('click', 'span.edit', function () {
    var _this = $(this), parent = _this.parents('tr.data'), parent_mytable = _this.parents('table'),
        inputs = parent.find('input'), selects = parent.find('select'),
        date_format_inputs = parent.find('input.date_format'),
        date_format = parent_mytable.attr('data-date_format');

    if (inputs.attr('disabled')) {
        parent.find('input').removeAttr('disabled')
            .removeClass('no_borders');
        _this.attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');
        selects.removeAttr('disabled');
        AddDateFormatElement(date_format_inputs, date_format);
    }
    else {
        parent.find('input').attr('disabled', 'disabled');
        selects.attr('disabled', 'disabled');
    }

    return false;
})
    .on('click', 'span.save', function () {
        var _this = $(this), parent = _this.parents('tr.data'),
            condition = parent.find('select[name=condition]').val(), airline_id = parent.find('select[name=airline_id]').val(),
            user_id = parent.find('select[name=user_id]').val(),
            parent_mytable = _this.parents('table'), request,
            table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
            from_date = parent.find('input[name="condition_from"]').val(),
            to_date = parent.find('input[name="condition_to"]').val(),
            notes = parent.find('input[name="notes"]').val(),
            message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');


        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-user-history",
            type: 'GET',
            dataType: 'json',
            data: {
                user_id       : user_id,
                table         : table,
                condition_id  : condition,
                airline_id      : airline_id,
                from_date     : from_date,
                to_date       : to_date,
                date_format   : date_format,
                notes   : notes,
                history_id    : history_id
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                if (data.success){
                    parent.attr("data-history_id", data.history_id);
                    getMessageDiv("Success", message_div, data.message);
                }
                else{

                    getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
                }



                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
        });

        request.always(function () {
            parent.find('input').attr('disabled', 'disabled')
                .addClass('no_borders');

            parent.find('select').attr('disabled', 'disabled');

            _this.attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
        });

        return false;

    }).on('click', 'span.remove', function () {

    var _this = $(this);

    _this.confirm({
        text: 'Are You Sure You want to Remove This ?',
        title: 'Profile Update',
        confirm: function (button) {
            deleteUserHistory(_this);
        },
        cancel: function (button) {
            //
        },
        confirmButton: "Yes",
        cancelButton: "No",
        post: true,
        confirmButtonClass: "btn-primary"
    });

    return false;

});

function deleteUserHistory(element){
    var _this = $(element), parent = _this.parents('tr.data'),
        condition = parent.find('select[name=condition]').val(), airline_id = parent.find('select[name=airline_id]').val(),
        user_id = parent.find('select[name=user_id]').val(),
        parent_mytable = _this.parents('.mytable'), request,
        table = parent_mytable.attr('data-table'), date_format = parent_mytable.attr('data-date_format'), data,
        from_date = parent.find('input[name="condition_from"]').val(),
        to_date = parent.find('input[name="condition_to"]').val(),
        notes = parent.find('input[name="notes"]').val(),
        message_div = parent.parents('div.active'), history_id = parent.attr('data-history_id');

    request = $.ajax({
        url: baseUrl + "/change-record/ajax-remove-user-history",
        type: 'GET',
        dataType: 'json',
        data: {
            user_id       : user_id,
            table         : table,
            condition_id  : condition,
            airline_id  : airline_id,
            from_date     : from_date,
            to_date       : to_date,
            date_format   : date_format,
            notes       : notes,
            history_id    : history_id
        }
    });

    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            if (data.success) {
                getMessageDiv("Success", message_div, data.message);

            }
            else {
                getMessageDiv("Warning", message_div, data.message);
                _this.parent().prev().find('span').attr('class', 'glyphicon glyphicon-pencil margin_right_10 edit');
            }
            parent.remove();
            Cancel_Change();

        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_div, 'Error! Changes Not Saved.');
    });

    request.always(function () {
        parent.find('input').attr('disabled', 'disabled');
    });
}

staff_travel.on('click', 'a.add', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), row = parent.find('tbody > tr[class="data"]:last'),
        duplicate = row.clone(), label = duplicate.find('label').text(), inputs = duplicate.find('input'),
        selects =  duplicate.find('select'), checkboxes =  duplicate.find('input[type="checkbox"]');

    if (label.length > 0){
        label = parseInt(label);
        duplicate.find('label').text(++label);
    }
    duplicate.attr('data-history_id', 'add');
    duplicate.find('span.edit').attr('class', 'glyphicon glyphicon-floppy-save margin_right_10 save');

    inputs.val('')
        .removeAttr('disabled')
        .removeClass('no_borders');
    selects.val('')
        .removeAttr('disabled');
    checkboxes.prop('checked', false)
        .removeAttr('disabled');

    duplicate.insertAfter(row);
    ApplyValidationDateFormats();

    return false;

});

staff_travel.on('click', 'a.check', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'),
        marital_status = parent.attr('data-marital_status'), relationship, nominee,
        relationships_single = parent.find('input[name="relationships_single"]').val(),
        relationships_married = parent.find('input[name="relationship_married"]').val();

    rows.each(function () {
        relationship = $(this).find('select[name="relationship_id"]');
        nominee = $(this).find('input[name="is_nominee"]');
        switch (marital_status){
            case "Single":

                break;
            case "Married":
                break;
            default :
                break;
        }
    })

    return false;

});

staff_travel.on('click', 'a.remove', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), all_rows = parent.find('tbody > tr[class="data"]'),
        row = all_rows.last();

    row.remove();

    return false;

});

staff_travel.on('click', 'a.save', function () {
    var _this = $(this), parent = _this.parents('.staff_travel'), rows = parent.find('tbody > tr[class="data"]'), records,
        data = [], select, input, i = 0, property, omit = false, request, user_id = parent.attr('data-user_id'),
        table = parent.attr('data-table'), date_format = parent.attr('data-date_format'), nominee,
        checkbox = rows.find('input[type="checkbox"]:checked'), message_div = parent.parents('div.active');


    if (checkbox.length > 3) {
        getMessageDiv("Warning", message_div, "Warning. Only 3 Nominees Are Allowed. Please Pick Not More Than 3.");
        return false;
    }

    rows.each(function () {
        data[i] = {};
        omit = false;
        records = $(this).find('td');
        records.each(function () {
            select = $(this).find('select');
            input = $(this).find('input');
            nominee = $(this).find('input[type="checkbox"]');

            if (select.length > 0) {

                property = select.attr('name');
                if (select.val() !== "") {
                    data[i][property] = select.val();
                }

            }
            else if (nominee.length > 0){
                property = nominee.attr('name');
                data[i][property] = nominee.is(':checked') ? 1 : 0;
            }
            else {
                property = input.attr('name');
                data[i][property] = input.val();
            }
            if (select.val() == '' || input.val() == '') {
                omit = true;
                data.splice(i, 1);
                return false;
            }
        });
        if (omit == false)
            i++;
        else
            omit = false;
    });

    request = $.ajax({
        headers: {
            'x-csrf-token': $(this).parents('form').find('input[name=_token]').val()
        },
        url: baseUrl + "/change-record/ajax-save-records",
        type: 'POST',
        dataType: 'json',
        data: {
            user_id : user_id,
            table : table,
            data : data,
            date_format : date_format
        }
    });

    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            getMessageDiv("Success", message_div, data.message);
            Cancel_Change();
        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_div,'Error! Changes Not Saved.');
    });

    return false;

});

function Cancel_Change(){
    var _this = $('p.editable_values > input.editable[type="text"]'), value, is_checkbox = 0;
    if (_this.length == 0)
        _this = $('p.editable_values > select.editable');
    if (_this.length == 0) {
        _this = $('p.editable_values > input.editable[type="checkbox"]');
        is_checkbox = 1;
    }

    if (is_checkbox == 1) {
        value = _this.is(':checked');
        if (value)
            value = '<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>';
        else
            value = '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>';

        _this.parent().html(value);
    }
    else {
        value = _this.val();
        if ($.isArray(value)) {
            value = value.join(', ');
        }

        _this.parent().text(value);
    }

    _this.remove();
}

var currentLoad = false, autoAddAll = false, loadPeriod = false;

$(document).ready(function () {
    if (rosterID){
        loadPeriod = true;
        autoAddAll = true;
        loadFlightProcess();

        // for (var d = _from; d <= _to; d.setDate(d.getDate() + 1)) {
        //     date = d.toISOString().split('T')[0];
        //     console.log(date);
        //     loadAndAddFlights(date);
        // }
    }
});

// $(document).on("click", "form button.load-flights", function () {
loadFlightsBtn.click(function () {
    autoAddAll = false;
    loadFlightProcess();
});

function loadFlightProcess(){
    if (currentLoad){
        return;
    }

    var form = loadFlightsBtn.closest("form"), request,
        airline = form.find("#airline"), airport = form.find("#airport"), btnAddFlight = form.find(".add-flight"),
        btnAddAllFlights = form.find(".add-all"),
        assignDate = form.find("input.assign-date"), flightList = form.find("select.flights-list"),
        loadFlightInfo = form.find("#load-flight-info"), includeRosteredStaff = form.find("#include_rostered_staff");

    loadFlightInfo.html(loading);

    currentLoad = true;

    if (loadPeriod){
        request = $.ajax({
            type: "GET",
            dataType: "json",
            url: baseUrl + "/staff-roster/get-flights",
            data: {
                date_from: rosterFrom,
                date_to: rosterTo,
                airport_id : airport.val(),
                airline_id : airline.val(),
                include_rostered_staff : !assignedStaff && includeRosteredStaff.is(":checked") ? 1 : 0,
            }
        });
    }
    else {
        request = $.ajax({
            type: "GET",
            dataType: "json",
            url: baseUrl + "/staff-roster/get-flights",
            data: {
                date: assignDate.val(),
                airport_id : airport.val(),
                airline_id : airline.val(),
                include_rostered_staff : !assignedStaff && includeRosteredStaff.is(":checked") ? 1 : 0,
            }
        });
    }

    request.done(function (data) {

        currentLoad = false;

        flightsData = {};
        flightList.find("option").remove();

        if (Object.keys(data.jsonData).length){

            loadFlightInfo.removeClass("color-red").addClass("color-green").text("Found " + Object.keys(data.jsonData).length + " Flights.");

            $.each(data.jsonData, function(key, obj) {
                flightsData[obj.id] = obj;
                flightList.append($("<option value='" + obj.id + "'>" + obj.flight + "</option>"));
            });

            btnAddFlight.removeAttr("disabled");
            btnAddAllFlights.removeAttr("disabled");

            if (autoAddAll){
                addAllFlights()
            }
        }
        else {
            loadFlightInfo.removeClass("color-green").addClass("color-red").text("No Flights Found!");
        }

        loadFlightsBtn.attr("disabled", "disabled");
    });
}

$("#reset_btn").click("click", function() {
    cleanLoadedFlights();
    return false;
});

$("#include_rostered_staff").click("change", function() {
    cleanLoadedFlights();
});

function cleanLoadedFlights(){
    var form = $(document).find("#formGenerate"), flightList = form.find("select.flights-list"), loadFlightInfo = form.find("#load-flight-info"),
        allFlightContainers = form.find(".flight-container"), btnAddFlight = form.find(".add-flight");

    loadFlightInfo.text("");
    flightList.find("option").remove();
    loadFlightsBtn.removeAttr("disabled");
    btnAddFlight.attr("disabled", "disabled");
    btnAddAllFlights.attr("disabled", "disabled");
    allFlightContainers.remove();
    saveBtn.attr("disabled", "disabled");

}

$(document).on("click", "form button.add-all", function() {
    addAllFlights();
});

function addAllFlights(){
    var form = btnAddAllFlights.closest("form"), flightList = form.find("select.flights-list option");
    $("#roster_id").val(rosterID);
    flightList.each(function () {
        // console.log("Flight ID: " + this.value);
        addFlight(form, this.value);
    });
}

$(document).on("change", ".assigned-staff", function () {
   saveBtn.attr("disabled", "disabled");
});

$(document).on("click", "form button.add-flight", function(){
    var _this = $(this), form = _this.closest("form"),
        flightList = form.find("select.flights-list"),
        flightId = flightList.val();

    addFlight(form, flightId);
});
