

$(document).on('change', '#organization_level_id', function () {
    var _this = $(this), organization_level_id = _this.val(),
        period_id = $('#period_id').val(),
        parent = _this.parents('.list-header'),
        added = parent.parent().find('.added');


    if (added.length){
        added.remove();
    }

    $.get(baseUrl + '/template/ajax-users-by-organization-level-id', {
        'organization_level_id' : organization_level_id,
        'period_id' : period_id,
        'searchable' : false,
        'upper_level_exists' : true,
        'organization_ids' : true,
        'accountable_staff' : true,
        'required' : false,
        'sub_container_first' : 'col-md-5',
        'sub_container_second' : 'col-md-7',
        'label' : 'Accountable',
        'select_name' : 'organization_id'
    })
        .done(function (data) {
            if (typeof data.success !== 'undefined' && data.success == false){
                var div = $('<div></div>').addClass('col-lg-12 list-header added');
                div.append(alert_box.addClass('alert-danger').text(data.message));
                parent.after(div);
                _this.val("");
            }
            else {
                data = $(data);
                parent.after(data);
                Apply_Multiselect(data);
            }
        })
});


$('#period_id').on('change', function () {
    var _this = $(this), selected = _this.find('option:selected'),  period = explode('/', selected.text());

    $('#period_from').val(period[0]).trigger('change');

});

$('#period_from').on('change', function () {
    var _this = $(this), from = moment(_this.val()), period_to = $('#period_to'), to;
    from = from.set('date', 1);

    _this.val(from.format('YYYY-MM-DD'));

    if (from.isValid()) {
        to = moment(from).add(1, 'years').subtract(1, 'days');
        period_to.val(to.format('YYYY-MM-DD'));
    }
    else {
        period_to.val('');
    }

    var j = 1;
    for (var i = from; i <= to; i = moment(i).add(1, 'months')){
        $('#label_target_m'+j++).text(i.format('MMM, YYYY'));
    }
});

 function SplitYearlyTarget(target) {
     var target = removeCommas(target), i, j, val_q, val_q_show, target_m, val_m_show, target_m_remaining, month_no, val_m, target_q_share = {},
         target_q = {}, target_q_remaining = target;

     //Get Quarters' Shares
     for (i = 1; i <= 4; i++) {
         target_q_share[i] =  parseFloat($("#target_q" + i + "_share").val());
         target_q[i] = parseFloat((target_q_share[i] * target / 100).toFixed(0));
         target_q_remaining -= target_q[i];
     }

     console.log(target_q_remaining)
     // Calculate Remaining
     target_q_remaining = parseFloat(target_q_remaining.toFixed(0));

     // Auto Feed
     for (i = 1; i <= 4; i++) {
         val_q = target_q[i];
         if (i == 1 && target_q_remaining > 0) {
             val_q = target_q[i] + target_q_remaining;
         }
         val_q_show = AddCommas(val_q.toFixed(0));
         $('#target_q' + i).val(val_q_show);

         target_m = parseFloat((val_q / 3).toFixed(0));
         target_m_remaining = parseFloat((val_q - (target_m * 3).toFixed(0)));
         for (j = 1; j <= 3; j++) {
             month_no = (i - 1) * 3 + j;
             val_m = target_m;
             if (j == 1 && target_m_remaining > 0) {
                 val_m = target_m + target_m_remaining;
             }
             val_m_show = AddCommas(val_m.toFixed(0));
             $('#target_m' + month_no).val(val_m_show);
         }
     }
 }

$('#quarter_shares_refresh').on('click', function () {
    if (CheckQuartersShares()) {
        SplitYearlyTarget($('#target').val());
    }
    return false;
});

$('#target_refresh').on('click', function () {
    if (CheckQuartersShares()) {
        SplitYearlyTarget($('#target').val());
    }
    return false;
});

$('#accountable_refresh').on('click', function () {
    $('#organization_level_id').trigger('change');
    return false;
});

$('#period_refresh').on('click', function () {
    $('#period_id').trigger('change');
    return false;
});



function CheckQuartersShares () {
    var target_q1_share = parseFloat($('#target_q1_share').val()),
        target_q2_share = parseFloat($('#target_q2_share').val()),
        target_q3_share = parseFloat($('#target_q3_share').val()),
        target_q4_share = parseFloat($('#target_q4_share').val()),
        success = true;

    if (target_q1_share + target_q2_share + target_q3_share + target_q4_share != 100){
        alert("Please Make Sure That Sum of Quarters' Shares Equals To 100");
        success = false;
    }
    return success;
}

function CheckExceeding(val, type, periodNo){
    var target, target_val, this_value, success = true, message = "";

    switch (type) {
        case REPORT_YEARLY:
            break;
        case REPORT_QUARTERLY:
            target = $('#target').val();
            message = "Quarterly Target Cannot Exceed Yearly Target. Please Check Again.";
            break;
        case REPORT_MONTHLY:
            target = $('#target_q' + periodNo).val();
            message = "Monthly Target Cannot Exceed Quarterly Target. Please Check Again.";
            break;
    }

    target_val = removeCommas(target, true);
    this_value = removeCommas(val, true);

    if (this_value >= target_val) {
        alert(message);
        success = false;
    }
    return { value: val, success: success};
}

function CheckAllExceedings(){
    var year = $('#target').val(), quarter, val_q, month, month_no, val_m, val_q_total = 0, val_m_total;
    for (var i = 1; i <= 4; i++) {
        quarter = '#target_q' + i;
        val_q = removeCommas($(quarter).val(), true);
        val_q_total += val_q;
        val_m_total = 0;
        for (var j = 1; j <= 3; j++) {
            month_no = (i - 1) * 3 + j;
            month = '#target_m' + month_no;
            val_m = removeCommas($(month).val(), true);
            val_m_total += val_m;
        }
        if (val_m_total < val_q){
            alert("Error. Monthly Targets' Totals is less than Quarter " + i);
            return false;
        }
    }
    if (val_q_total < year){
        alert("Error. Quarterly Targets' Totals is less than Yearly Target");
        return false;
    }

    return true;
}


function SplitQuarterlyTarget(val, quarter) {
    var  i, j, target_m, val_m_show, target_m_remaining, month_no, val_m,
        target = removeCommas($('#target').val(), true);

    if (val >= target) {
        //alert('Quarterly Target Cannot Exceed Yearly Target. Please Check Again.');
    }
    else {
        target_m = parseFloat((val / 3).toFixed(0));
        target_m_remaining = parseFloat((val - (target_m * 3).toFixed(0)));
        for (j = 1; j <= 3; j++) {
            month_no = (quarter - 1) * 3 + j;
            val_m = target_m;
            if (j == 1 && target_m_remaining > 0) {
                val_m = target_m + target_m_remaining;
            }
            val_m_show = AddCommas(val_m.toFixed(0));
            $('#target_m' + month_no).val(val_m_show);
        }
    }
}

function removeCommas(number, make_integer){
    if (typeof make_integer !== 'undefined')
        return parseInt(number.replace(/\,/g, ''));
    else
        return number.replace(/\,/g, '');
}

function AddCommasAndSplitTarget(this_val, type, periodVal, check){


    var this_val_int = removeCommas(this_val);
    if (typeof type === 'undefined'){
        type = REPORT_YEARLY;
    }
    if (typeof periodVal === 'undefined'){
        periodVal = 1;
    }
    if (typeof check !== "undefined"){
        check = CheckExceeding(this_val, type, periodVal)
    }
    if (typeof check === 'undefined' || check.success) {
        if (CheckQuartersShares()) {
            switch (type) {
                case REPORT_YEARLY:
                    SplitYearlyTarget(this_val_int);
                    break;
                case REPORT_QUARTERLY:
                    SplitQuarterlyTarget(this_val_int, periodVal);
                    break;
                case REPORT_MONTHLY:
                    break;
            }
        }

        return AddCommas(this_val_int);
    }
    return check.value.substring(0, check.value.length-1);

}


function detectLeftButton(evt) {
    evt = evt || window.event;
    var button = evt.which || evt.button;
    console.log(button)
    return button == 1;
}


$('#target').on('keyup', function () {
    var _this = $(this), val = _this.val();
    if($.inArray(event.keyCode, [16, 35, 36, 37, 38, 39, 40]) == -1) {
        _this.val(AddCommas(val));
    }
});

function AddCommas(myElement) {
    var myVal = ""; // The number part
    var myDec = ""; // The digits pars

    var parts = myElement.toString().split(".");
    // Filtering out the trash!
    parts[0] = parts[0].replace(/[^0-9]/g, "");
    // Setting up the decimal part
    if (!parts[1] && myElement.indexOf(".") > 1) {
        myDec += ".00"
    }
    if (parts[1]) {
        myDec = "." + parts[1]
    }
    // Adding the thousand separator
    while (parts[0].length > 3) {
        myVal = "," + parts[0].substr(parts[0].length - 3, parts[0].length) + myVal;
        parts[0] = parts[0].substr(0, parts[0].length - 3)
    }
    return parts[0] + myVal + myDec;
}