

$(document).on('change', '#organization_level_id', function () {
    var _this = $(this), organization_level_id = _this.val(),
        parent = _this.parents('.list-header'),
        added = parent.parent().find('.added');


    if (added.length){
        added.remove();
    }

    $.get(baseUrl + '/template/ajax-users-by-organization-level-id', {
        'organization_level_id' : organization_level_id,
        'searchable' : false,
        'organization_ids' : true,
        'accountable_staff' : true,
        'required' : false,
        'sub_container_first' : 'col-md-5',
        'sub_container_second' : 'col-md-7',
        'label' : 'Accountable',
        'select_name' : 'network_organization_id'
    })
        .done(function (data) {
            if (typeof data.success !== 'undefined' && data.success == false){
                var div = $('<div></div>').addClass('col-lg-12 list-header added');
                div.append(alert_box.addClass('alert-danger').text(data.message));
                parent.after(div);
            }
            else {
                data = $(data);
                parent.after(data);
                Apply_Multiselect(data);
            }
        })
});

$('#period_from').on('change', function () {
    var _this = $(this), from = moment(_this.val()), period_to = $('#period_to'), to;
    from = from.set('date', 1);

    _this.val(from.format('YYYY-MM-DD'));

    if (from.isValid()) {
        to = moment(from).add(1, 'years').subtract(1, 'days');
        period_to.val(to.format('YYYY-MM-DD'));
    }
    else {
        period_to.val('');
    }

    var j = 1;
    for (var i = from; i <= to; i = moment(i).add(1, 'months')){
        $('#label_target_m'+j++).text(i.format('MMM, YYYY'));
    }
});

 function SplitYearlyTarget(target) {
     var  i, j, val_q, val_q_show, target_m, val_m_show, target_m_remaining, month_no, val_m,
         target_q = parseFloat((target / 4).toFixed(0)), target_q_remaining = parseFloat((target - (target_q * 4).toFixed(0)));

     // Auto Feed
     for (i = 1; i <= 4; i++) {
         val_q = target_q;
         if (i == 1 && target_q_remaining > 0) {
             val_q = target_q + target_q_remaining;
         }
         val_q_show = AddCommas(val_q.toFixed(0));
         $('#target_q' + i).val(val_q_show);

         target_m = parseFloat((val_q / 3).toFixed(0));
         target_m_remaining = parseFloat((val_q - (target_m * 3).toFixed(0)));
         for (j = 1; j <= 3; j++) {
             month_no = (i - 1) * 3 + j;
             val_m = target_m;
             if (j == 1 && target_m_remaining > 0) {
                 val_m = target_m + target_m_remaining;
             }
             val_m_show = AddCommas(val_m.toFixed(0));
             $('#target_m' + month_no).val(val_m_show);
         }
     }
 }


function CheckExceeding(val){
    var target = $('#target').val();
    if (val >= target) {
        alert('Quarterly Target Cannot Exceed Yearly Target. Please Check Again.');
    }
    return val;
}

function SplitQuarterlyTarget(val, quarter) {
    var  i, j, target_m, val_m_show, target_m_remaining, month_no, val_m,
        target = $('#target').val();

    if (val >= target) {
        //alert('Quarterly Target Cannot Exceed Yearly Target. Please Check Again.');
    }
    else {
        target_m = parseFloat((val / 3).toFixed(0));
        target_m_remaining = parseFloat((val - (target_m * 3).toFixed(0)));
        for (j = 1; j <= 3; j++) {
            month_no = (quarter - 1) * 3 + j;
            val_m = target_m;
            if (j == 1 && target_m_remaining > 0) {
                val_m = target_m + target_m_remaining;
            }
            val_m_show = AddCommas(val_m.toFixed(0));
            $('#target_m' + month_no).val(val_m_show);
        }
    }
}

function AddCommasAndSplitTarget(myElement, type, val){
    var withoutCommas = myElement.replace(/\,/g, '');
    if (typeof type === 'undefined'){
        type = REPORT_YEARLY;
    }
    if (typeof val === 'undefined'){
        val = 1;
    }
    switch (type){
        case REPORT_YEARLY:
            SplitYearlyTarget(withoutCommas);
            break;
        case REPORT_QUARTERLY:
            SplitQuarterlyTarget(withoutCommas, val);
            break;
        case REPORT_MONTHLY:
            break;
    }

    return AddCommas(myElement);
}


function AddCommas(myElement) {
    var myVal = ""; // The number part
    var myDec = ""; // The digits pars

    var parts = myElement.toString().split(".");
    // Filtering out the trash!
    parts[0] = parts[0].replace(/[^0-9]/g, "");
    // Setting up the decimal part
    if (!parts[1] && myElement.indexOf(".") > 1) {
        myDec += ".00"
    }
    if (parts[1]) {
        myDec = "." + parts[1]
    }
    // Adding the thousand separator
    while (parts[0].length > 3) {
        myVal = "," + parts[0].substr(parts[0].length - 3, parts[0].length) + myVal;
        parts[0] = parts[0].substr(0, parts[0].length - 3)
    }
    return parts[0] + myVal + myDec;
}