/**
 * Created by WebSomonair on 03.10.2014.
 */



$(document).ready(function(){

    $(".category").click(function(){
       var details = $(this).next('.details');

       if (details.hasClass('hidden'))
            details.removeClass('hidden');
        else
            details.addClass('hidden');
    });


    function checkSelect(){
        $('.mytable tbody tr').addClass('hidden_div');
        var checked_ones = $('#flight_type :checked');
        //console.log(checked_ones);
        for (var i = 0; i < checked_ones.length; i++){
            var each = $(checked_ones[i]);
            $('.mytable tr.'+each.val()).removeClass('hidden_div');
        }
    }

    $('#flight_type').change(function () {
        checkSelect();
    })

    $('#selected_period_btn').click(function () {
        checkSelect();
    })


    var FLIGHT_TYPE_CHANGE = 'FLIGHT_TYPE_CHANGE',
        AGENCY_CHANGE = 'AGENCY_CHANGE';

    $('#country, #country_btn').change(function(){
        check_flight_type('#country', '#city', '#agency', AGENCY_CHANGE, 'country');
    });

    $('#city, #city_btn').change(function(){
        check_flight_type('#country', '#city', '#agency', AGENCY_CHANGE, 'city');
    });

    function check_flight_type(id_parent, id_child1, id_child2, type_data, priority){
        if (typeof id_parent == 'undefined')
            id_parent = '#flight_type';
        var request;

        var city = $(id_child1).val();
        console.log(baseUrl);

        request = $.ajax({
            url: baseUrl + "/report/ajaxflighttype",
            type: 'POST',
            dataType: 'json',
            data: {
                country: $(id_parent).val(),
                city: $(id_child1).val(),
                action: type_data
            }
        });


        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                console.log(data);

                var $child1 = $(id_child1);
                var $child2 = $(id_child2);

                if (priority == 'country')
                    $child1.find('option').remove();

                $child2.find('option').remove();

                var opts = [];

                for (var j in data) {
                    opts[j] = '';
                    if (data.hasOwnProperty(j)) {
                        for (var i in data[j]) {
                            if (data[j].hasOwnProperty(i)) {
                                var each = "<option value='" + i + "'>" + data[j][i] + "</option>";
                                opts[j] = opts[j].concat(each);
                            }
                        }
                    }
                }

                if (priority == 'country'){
                    $child1.append(opts[0]);
                    $child1.multiselect('rebuild');
                }


                $child2.append(opts[1]);
                $child2.multiselect('rebuild');
            }
        });
        request.fail(function (jqXHR, text_status) {

        });
    }
});

