/**
 * Created by Compas on 14.10.2014.
 */

$(function() {

    Add_Date_Format('dMY');

    $.get(baseUrl + '/template/ajax-get-buttons', {}, function(data){
       $('#button').html(data)
    });

    var parent = $(".details");

    parent.on('dblclick', 'p.editable_values', function () {
        // Cancel All Others
        Cancel_Change();
        var _this = $(this), _content = _this.children(), oriVal = _this.text(), item = _this.attr('data-item'),
            table = _this.attr('data-table'), date_format = _this.attr('data-date_format'),
            var_type = _this.attr('data-var_type'), options, selected_values, original_value,
            parent = _this.parents('.details'), type = parent.attr('data-type'), input, save;

        _this.text("");

        var offset_top=_this.offset().top;
        var offset_left=_this.offset().left;
        console.log(offset_top);

        $(".bubble").css("left",offset_left);
        $(".bubble").css("top",offset_top - _this.height() - 20 );
        $(".bubble").show("swing");


        if (typeof var_type !== 'undefined'){
            if (item == 'nationality'){
                input = $("<select class='editable'></select>");
                options = Nationalities();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });

                input.val(oriVal);
            }
            else if (item == 'pob_country_id'){
                input = $("<select class='editable'></select>");
                $.post(baseUrl + '/location/ajax-get-country-list',{},function(data){
                    $.each(data, function (i, key) {
                        input.append($("<option></option>").attr('value', i).html(key));
                    });
                });
                input.val(oriVal);
            }
            else if (item == 'languages'){
                input = $("<select class='multiselect editable' multiple='multiple'></select>");
                $.post(baseUrl + '/language/ajax-get-language-list',{},function(data){
                    $.each(data, function (i, key) {
                        input.append($("<option></option>").attr('value', i).html(key));
                    });
                });

                input.val(selected_values);

            }
            else if (item == 'location'){
                input = $("<select class='editable margin_right'></select>");
                options = Location_Bases();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'marital_status'){
                input = $("<select class='editable margin_right'></select>");
                options = Marital_Status();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });

                input.val(oriVal);
            }
            else if (item == 'english_level'){
                input = $("<select class='editable margin_right'></select>");
                options = English_Levels();
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(oriVal);
            }
            else if (item == 'aircraft_types') {
                input = $("<select class='multiselect editable' multiple='multiple'></select>");
                selected_values = oriVal.split(", ");
                options = Get_Aircraft('type', 'static');
                $.each(options, function (i, key) {
                    input.append($("<option></option>").attr('value', i).html(key));
                });
                input.val(selected_values);

            }
            else if ($.inArray(item, ['is_captain', 'is_purser']) != -1){
                oriVal = _content;
                input = $('<input />', { type: 'checkbox', name: 'crew_designation',  class:'editable' });
                //input = $("<input type='checkbox' class='editable' />");
                if (_content.hasClass('glyphicon-ok')) {
                    input.attr('checked', true);
                }
                else
                    input.attr('checked', false);

            }
            else
                input = $("<input class = 'editable long' type='text' value='"+oriVal+"' />");
        }
        else {
            input = $("<input class = 'date_format editable' type='text' value='"+oriVal+"' />");
        }

        original_value = $("<input class = 'original_value editable long' type='hidden' value='"+oriVal+"' />");

        save = $('<div class="btn-group change_values"><a href="#" class="btn btn-sm btn-primary" id="save_changes">Save</a>' +
        '<a href="#" class="btn btn-sm btn-warning" id="empty_text">Empty</a>'+'<a href="#" class="btn btn-sm btn-danger" id="cancel_changes">Cancel</a>');

        input.appendTo(_this);
        original_value.appendTo(_this);
        save.appendTo(_this);
        Add_Date_Format(date_format);
        Apply_Multiselect();
        input.focus();
        Load_Buttons();
    });

    parent.on('click', '#save_changes', function () {
        var _this = $(this),
            value, p_editable = _this.parents('p.editable_values'),
            date_format = p_editable.attr('data-date_format'), item = p_editable.attr('data-item'), table = p_editable.attr('data-table'),
            input = p_editable.find('input.editable').not('[type=hidden]'), originalValue = p_editable.find('input.original_value').val(),
            select = p_editable.find('select'), div_active = _this.parents('div.active'),
            grandparent = _this.parents('.details'), type = grandparent.attr('data-type'), id = grandparent.attr('data-passenger_id');

        if (typeof date_format === 'undefined'){
            date_format = "not_applicable";
        }
        if (input.length > 0) {
            if (input.attr('type') == 'checkbox') {
                if ($(input).prop('checked'))
                    value = 1;
                else
                    value = 0;
            }
            else
                value = input.val();
        }
        else if (select.length > 0){
            value = select.val();
        }

        console.log(select.val())
        if (originalValue != value){
            AjaxSaveChanges(id, value, item, div_active, type, table, date_format);
        }

    });

    function AjaxSaveChanges(id, value, item, parent, type, table, date_format){
        request = $.ajax({
            url: baseUrl + "/change-record/ajax-save-passenger",
            type: 'POST',
            dataType: 'json',
            data: {
                type        : type,
                table       : table,
                passenger_id     : id,
                item        : item,
                value       : value,
                date_format : date_format
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", parent, data.message);
                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", parent,'Error! Changes Not Saved.');
        });
    }

    function Load_Buttons(){
        $('#cancel_changes').click(function () {
            Cancel_Change();
        });

        $('#empty_text').click(function () {
            var _this =  $('input.date_format.editable');
            _this.val("");
        });

        $('input.date_format.editable').on('change', function () {
            $(this).addClass('edited');
        })
    }

    function Cancel_Change(){
        var _this = $('p.editable_values > input.editable[type="text"]'), value, is_checkbox = 0;
        if (_this.length == 0)
            _this = $('p.editable_values > select.editable');
        if (_this.length == 0) {
            _this = $('p.editable_values > input.editable[type="checkbox"]');
            is_checkbox = 1;
        }

        if (is_checkbox == 1) {
            value = _this.is(':checked');
            if (value)
                value = '<span class="glyphicon glyphicon-ok" aria-hidden="true"></span>';
            else
                value = '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>';

            _this.parent().html(value);
        }
        else {
            value = _this.val();
            if ($.isArray(value)) {
                value = value.join(', ');
            }
            _this.parent().text(value);
        }
        _this.remove();

    }

});