/**
 * Created by WebSomonair on 21.05.2015.
 */

var organization_level_id    = 'select[name=organization_level_id]',
    report_to_level          = 'select[name=report_to_level]',
    structure_department_id  = '#structure_department_id',
    structure_position_id    = 'select[name=structure_position_id]',
    report_to_user_id        = 'select[name=report_to_user_id]',
    new_position             = '#new_position';

$(document).on('change', organization_level_id, function () {
    var _this = $(this), organization_level_id = _this.val(), level = _this.text(), parent = _this.parents('.list-header'),
        container = parent.parent(), related_tables = $(document).find('.related_tables'), report_to = [], key, val;

    _this.find('option').each(function() {
        report_to[this.text] = this.value;
        if (this.value == organization_level_id)
            return false;
    });

    modal_ajax_loading.show();

    // Remove Previously Set Related Tables
    related_tables.each(function () {
        $(this).remove();
    });

    $.get(baseUrl + '/template/ajax-organization-info', {
        'organization_level_id' : organization_level_id
    })
        .done(function (data) {
            data = $(data);
            parent.after(data);
            Apply_Multiselect(data);
        })
        .fail(function () {
        })
        .always(function () {
            modal_ajax_loading.hide();
        });

    $(report_to_level).find('option').remove();

    for (var i = 0, l = Object.keys(report_to).length; i < l ; i++){
        val = Object.keys(report_to)[i];
        key = report_to[val];
        $(report_to_level).append($('<option></option>').val(key).text(val));
    }
    $(report_to_level).val("");
    $(report_to_level).multiselect('rebuild');
    //$(report_to_level).multiselect('rebuild');
});

$(document).on('change', report_to_level, function () {
    var _this = $(this), organization_level_id = _this.val(), parent = _this.parents('.list-header'),
        report_to_user_id = $('select[name=report_to_user_id]');

    console.log(report_to_user_id);


    if (report_to_user_id.length){
        report_to_user_id.parents('.list-header').remove()
    }

    $.get(baseUrl + '/template/ajax-users-by-organization-level-id', {
        'organization_level_id' : organization_level_id
    })
        .done(function (data) {
            if (typeof data.success !== 'undefined' && data.success == false){
                var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                parent.append(div);

            }
            else {
                data = $(data);
                parent.after(data);
                Apply_Multiselect(data);
            }
        })
});

$(document).on('change', structure_department_id, function () {
    var _this = $(this), department_id = _this.val(),
        submit = $('input[type=submit]').parents('.list-header'),
        added = $('.added'),
        user_id = $('#user_id').text(),
        report_to_user = $(report_to_user_id).parents('.list-header'),
        positions = $(structure_position_id).parents('.list-header'),
        report_to_levels = $(report_to_level).parents('.list-header'),
        employee = $('#user_id').parents('.list-header'),
        levels = $(organization_level_id).parents('.list-header'),
        department = _this.parents('.list-header'),
        add_new_position = $(new_position).parents('.list-header'),
        designation = $('input[name=support_staff]').parents('.list-header'),
        level = $(organization_level_id).parents('.list-header');

    if (added.length){
        added.remove();
    }

    if (report_to_user.length){
        report_to_user.remove();
    }

    if (positions.length){
        positions.remove();
    }

    if (levels.length){
        levels.remove();
    }

    if (report_to_levels.length){
        report_to_levels.remove();
    }

    if (department_id) {

        // Get Positions
        $.get(baseUrl + '/template/ajax-positions-by-department-id', {
            'department_id': department_id
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    data = $(data);
                    employee.after(data);
                    Apply_Multiselect(data);
                }
            });

        // Get Levels
        $.get(baseUrl + '/template/ajax-levels-by-department-id', {
            'department_id' : department_id,
            'label'         : 'Level',
            'name'          : 'organization_level_id'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    // Existing Levels Of the Department
                    data = $(data);
                    designation.after(data);
                    Apply_Multiselect(data);
                }
            });

        // Get Report To Levels
        $.get(baseUrl + '/template/ajax-levels-by-department-id', {
            'department_id' : department_id,
            'label'         : 'Reports To (Level)',
            'name'          : 'report_to_level'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    // Existing Levels Of the Department
                    data = $(data);
                    submit.before(data);
                    Apply_Multiselect(data);
                }
            });
    }
});

$(document).on('change', '#new_user :checkbox, #new_position :checkbox', function () {
    var _this = $(this), parent =_this.parents('.list-header'), employee = parent.prev('.list-header').find('select'),
        hidden_element = parent.next('.list-header');

    if (_this.is(':checked')) {
        employee.removeAttr('required');
        hidden_element.show();
        hidden_element.find('input[data-required]').attr('required', 'required');
    }
    else {
        employee.attr('required', 'required');
        hidden_element.hide();
        hidden_element.find('input[data-required]').removeAttr('required');
    }
});