/**
 * Created by WebSomonair on 21.05.2015.
 */

var organization_level_id = 'select[name=organization_level_id]',
    report_to_level = 'select[name=report_to_level]',
    structure_department_id = '#structure_department_id';

$(document).on('change', organization_level_id, function () {
    var _this = $(this), organization_level_id = _this.val(), level = _this.text(), parent = _this.parents('.list-header'),
        container = parent.parent(), added_related_tables = container.find('.added'), report_to = [], key, val;

    _this.find('option').each(function() {
        report_to[this.text] = this.value;
        if (this.value == organization_level_id)
            return false;
    });

    modal_ajax_loading.show();

    $(report_to_level).parents('list-header').remove();

    $.get(baseUrl + '/template/ajax-organization-info', {
        'organization_level_id' : organization_level_id
    })
        .done(function (data) {
            data = $(data);
            parent.after(data);
            Apply_Multiselect(data);
        })
        .fail(function () {
        })
        .always(function () {
            modal_ajax_loading.hide();
        });

    $(report_to_level).find('option').remove();

    for (var i = 0, l = Object.keys(report_to).length; i < l ; i++){
        val = Object.keys(report_to)[i];
        key = report_to[val];
        $(report_to_level).append($('<option></option>').val(key).text(val));
    }
    $(report_to_level).val("");
    $(report_to_level).multiselect('rebuild');
});

$(document).on('change', report_to_level, function () {
    var _this = $(this), organization_level_id = _this.val(), parent = _this.parents('.list-header'),
        report_to_user_id = $('select[name=report_to_user_id]');

    if (report_to_user_id.length){
        report_to_user_id.parents('.list-header').remove()
    }

    $.get(baseUrl + '/template/ajax-users-by-organization-level-id', {
        'organization_level_id' : organization_level_id
    })
        .done(function (data) {
            if (typeof data.success !== 'undefined' && data.success == false){
                var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                parent.append(div);

            }
            else {
                data = $(data);
                parent.after(data);
                Apply_Multiselect(data);
            }
        })
});

$(document).on('change', structure_department_id, function () {
    select_department_change($(this));
});

$(document).on('change', '#new_user :checkbox, #new_position :checkbox', function () {
    var _this = $(this), parent =_this.parents('.list-header'), employee = parent.prev('.list-header').find('select'),
        hidden_element = parent.next('.list-header');

    if (_this.is(':checked')) {
        employee.removeAttr('required');
        hidden_element.show();
        hidden_element.find('input[data-required]').attr('required', 'required');
    }
    else {
        employee.attr('required', 'required');
        hidden_element.hide();
        hidden_element.find('input[data-required]').removeAttr('required');
    }
});

/**
 * Department Change Event Listener
 * @param _this
 */
function select_department_change(_this) {
    var department_id = _this.val(),
        employees = $('select[name=user_id]'),  parent = _this.parents('.list-header'),
        positions = $('select[name=structure_position_id]'), positionBefore = $('#new_position').parents('.list-header'),
        levels = $(organization_level_id),  report_to_levels = $(report_to_level),
        levelBefore = $('input[name=support_staff]').parents('.list-header');

    if (employees.length){
        employees.parents('.list-header').remove();
    }

    if (positions.length){
        positions.parents('.list-header').remove();
    }

    if (levels.length){
        levels.parents('.list-header').remove();
    }

    if (report_to_levels.length){
        report_to_levels.parents('.list-header').remove();
    }

    if (department_id) {

        $.get(baseUrl + '/template/ajax-users-by-department-id', {
            'department_id': department_id
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    data = $(data);
                    parent.after(data);
                    Apply_Multiselect(data);
                }
            });

        $.get(baseUrl + '/template/ajax-positions-by-department-id', {
            'department_id': department_id
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    data = $(data);
                    positionBefore.before(data);
                    Apply_Multiselect(data);
                }
            });


        $.get(baseUrl + '/template/ajax-levels-by-department-id', {
            'department_id' : department_id,
            'label'         : 'Level',
            'name'          : 'organization_level_id'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    // Existing Levels Of the Department
                    data = $(data);
                    levelBefore.before(data);
                    Apply_Multiselect(data);
                }
            });

        $.get(baseUrl + '/template/ajax-levels-by-department-id', {
            'department_id' : department_id,
            'label'         : 'Reports To (Level)',
            'name'          : 'report_to_level'
        })
            .done(function (data) {
                if (typeof data.success !== 'undefined' && data.success == false) {
                    var div = $('<div></div>').addClass('col-md-3').html(alert_box.addClass('alert-danger').text(data.message));
                    parent.append(div);

                }
                else {
                    // Existing Levels Of the Department
                    data = $(data);
                    levelBefore.after(data);

                    Apply_Multiselect(data);
                }
            });
    }
}

//$(document).ready(function () {
    var department = $(structure_department_id);

    if (department.val()){
        select_department_change(department);
    }
//});