/**
 * Created by Dilovar Tursunov on 27.08.14.
 */

"use strict";

var _MS_PER_DAY = 1000 * 60 * 60 * $timelinePeriod,
    FLIGHT_CREW_CAPTAINS = "captains",
    FLIGHT_CREW_FIRST_OFFICERS = "first_officers",
    FLIGHT_CREW_FLIGHT_ATTENDANTS = "flight_attendants",
    T_MAINTENANCE = "maintenance",
    T_FLIGHT = "flight",
    FLIGHT_AVAILABLE = "available",
    FLIGHT_DELAYED = "delayed",
    FLIGHT_CANCELLED = "cancelled",
    FLIGHT_DIVERTED = "diversion",
    FLIGHT_MAINTENANCE = "maintenance",
    MAX_HOURS_FOR_MOVE = $timelinePeriod,

    CREW_TYPE_SUP = "SUP",
    CREW_TYPE_STANDBY = "STANDBY",
    CREW_TYPE_DHC = "DHC",
    CREW_TYPE_IN_FLIGHT = "IN_FLIGHT",

    EMPTY_DATE = "0000-00-00",
    EMPTY_TIME = "00:00:00",
    EMPTY_DATETIME = "0000-00-00 00:00:00",

    timeline = null,
    inputDateFormat = "YYYY-MM-DD HH:mm:ss",
    outputDateOnlyFormat = "MMM DD",
    outputDateFormat = "MMM DD, HH:mm",
    outputTimeFormat = "HH:mm",

    popupFlight = null,
    messageBlock = $("#fleetwatch_message_block"),
    flight_info_modal = $("#flight_info_modal"),
    DEPARTURE_SERVICE = "departure_service",
    ARRIVAL_SERVICE = "arrival_service",
    TURNAROUND_SERVICE = "turnaround_service";

function initializeTime(){
    updateTime();
    window.setInterval(updateTime, 1000);
}

initializeTime();
/**
 * Time UTC in Real Time
 */
function updateTime(){
    var timeNow = $('#timeNow'), now;
    if (timeNow.length > 0){
        //   time.innerText = new Date().toUTCString();
        now = new Date().toUTCString();
        now = now.split(' ')[4];
        timeNow.text(now +" GMT");
    }
}

try {
    google.load("visualization", "1");
}
catch(e){
    // Nothing
}

$(document).ready(function(){

    google.setOnLoadCallback(drawVisualization);

});

// Set callback to run when API is loaded


// Called when the Visualization API is loaded.
function drawVisualization() {

    // Create and populate a data table.
    try {
        var data = new google.visualization.DataTable();
    }
    catch(e){
        return;
    }

    var today = new Date(), date = new Date(), date2 = new Date(),
        start_time = date.setHours(date.getHours() - 12),
        end_time = date2.setHours(date2.getHours() + 12);

    start_time = moment(start_time).utc();
    end_time = moment(end_time).utc();

    var visibleYear = date.getFullYear() + 2,
        visibleMonth = date.getMonth(),
        visibleDay = date.getDate();

    // if was set go to date, use it as default date for timeline
    if (typeof goToDate !== "undefined" && goToDate != false) {
        date = new Date(goToDate);
        date2 = new Date(goToDate);
        start_time = date.setHours(0, 0, 0);
        end_time = date2.setHours(23, 59, 59);
        var d = date, d2 = date2,
            start_visible_time = moment(d.setHours(today.getHours() - 12)).format("YYYY-MM-DD HH:mm:ss"),
            end_visible_time = moment(d2.setHours(today.getHours() + 12)).format("YYYY-MM-DD HH:mm:ss");


        $("#start_visible_period").val(start_visible_time);
        $("#end_visible_period").val(end_visible_time);
    }

    start_time = moment(start_time).format("YYYY-MM-DD HH:mm:ss");
    end_time = moment(end_time).format("YYYY-MM-DD HH:mm:ss");


    if (typeof startVisibleDate !== "undefined" && startVisibleDate != false && typeof endVisibleDate !== "undefined" && endVisibleDate != false) {
        start_time = moment(startVisibleDate).format("YYYY-MM-DD HH:mm:ss");
        end_time = moment(endVisibleDate).format("YYYY-MM-DD HH:mm:ss");
    }


    data.addColumn("datetime", "start");
    data.addColumn("datetime", "end");
    data.addColumn("string", "content");
    data.addColumn("string", "group");
    data.addColumn("string", "className");

    if (json.length) {
        var flights = prepareDataForTimeline(json);
        data.addRows(flights);
    }

    // specify options
    var options = {
        stackEvents: true,
        //start: start_time,
        //end: end_time,
        editable: true,
        animate: true,
        eventMargin: 5,
        eventMarginAxis: 5,
        cluster: true,
        axisOnTop: true,
        snapEvents: false,
        dragAreaWidth: 10,
        groupMinHeight: 35,
        groupsWidth: $groupsWidth,
        min: new Date(2013, 1, 1),
        max: new Date(visibleYear, visibleMonth, visibleDay),     // upper limit of visible range
        zoomable: false,
        zoomMin: 1000 * 60 * 60 * $timelinePeriod,     // 4 hours in milliseconds
        zoomMax: 1000 * 60 * 60 * $timelinePeriod,     // 7 days in milliseconds
        showButtonNew: false,
        showNavigation: false,
        showMajorLabels: true,
        width: "100%",
        height: "auto",
        layout: "box",
        /* Have disabled on Nov 15, 19 */
        groupsChangeable: true,
        groupsOrder: function (a, b) {
            if (a.content == b.content) {
                return 0;
            }
            return (a.content < b.content) ? -1 : 1;
        }
    };

    // Instantiate our timeline object
    timeline = new links.Timeline(document.getElementById("mytimeline"));

    // Draw our timeline with the created data and options
    timeline.setOptions(options);

    timeline.draw(data);
    //timeline.draw(data, options);

    //new Date(year, month, day, hours, minutes, seconds, milliseconds)
    var start = new Date(
        moment(start_time).get('year'),
        moment(start_time).get('month'),
        moment(start_time).get('date'),
        moment(start_time).get('hour'),
        moment(start_time).get('minute'),
        moment(start_time).get('second')
    );

    var end = new Date(
        moment(end_time).get('year'),
        moment(end_time).get('month'),
        moment(end_time).get('date'),
        moment(end_time).get('hour'),
        moment(end_time).get('minute'),
        moment(end_time).get('second')
    );


    timeline.setVisibleChartRange(start, end);

    var now = new Date();
    var current_datetime = moment({
        year: now.getUTCFullYear(),
        month: now.getUTCMonth(),
        day: now.getUTCDate(),
        hour: now.getUTCHours(),
        minute: now.getUTCMinutes(),
        second: now.getUTCSeconds()
    });

    timeline.setCurrentTime(current_datetime);

    //
    /**
     * Delete flight item event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "delete",
        function () {
            timeline.cancelDelete();

            if (!editable) {
                // My Temp Edit
                return false;
            }

            return false;

            var sel = timeline.getSelection(), row;
            if (sel.length) {
                if (sel[0].row != undefined) {
                    row = sel[0].row;
                }
            }

            bootbox.confirm("Flight will be cancelled, are you sure?", function (result) {
                if (result) {
                    var $body = $("body"), flightData = getSelectedEvent(),
                        request, requestData = $.ajaxSetup({
                            type: "GET",
                            dataType: "json"
                        });

                    if (!flightData) {
                        return false;
                    }

                    $body.addClass("loading");
                    if (flightData.type == T_MAINTENANCE) {
                        requestData = {
                            url: baseUrl + "/aircraft/ajax-delete-maintenance",
                            data: {
                                maintenance_id: flightData.id
                            }
                        };
                    } else if (flightData.type == T_FLIGHT) {
                        requestData = {
                            url: baseUrl + "/flight/ajax-delete-flight",
                            data: {
                                flight_id: flightData.id
                            }
                        };
                    }
                    request = $.ajax(requestData);
                    request.done(function (data) {
                        if (typeof data.success !== "undefined") {
                            showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                            if (flightData.type == T_FLIGHT) {
                                // clear the bottom form
                                clearFlightForm();
                            } else if (flightData.type == T_MAINTENANCE) {
                                //
                            }
                            timeline.deleteItem(row);
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                    });
                    request.always(function () {
                        $body.removeClass("loading");
                    });
                } else {
                    timeline.setSelection([]);
                }
            });
        }
    );

    /**
     * Change flight item position event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "changed",
        function () {
            var sel = timeline.getSelection();
            // My Temp Edit
            timeline.cancelChange();
            return false;
            ///

            if (sel.length) {
                if (sel[0].row != undefined) {
                    var row = sel[0].row;
                    var itemFlight = timeline.getItem(row);
                }
            }

            if (typeof itemFlight === "undefined") {
                timeline.cancelChange();
                timeline.setSelection([]);
                return false;
            }

            // validate available hours
            var arrivalDate = moment(itemFlight.end),
                duration = moment.duration(moment().diff(arrivalDate)),
                hours = duration.asHours();
            if (hours > MAX_HOURS_FOR_MOVE) {
                showMessage("Flight cannot be updated due to exceeding  " + MAX_HOURS_FOR_MOVE + " hours period", "Warning!",
                    MESSAGE_WARNING, messageBlock);
                timeline.cancelChange();
                return false;
            }

            if (confirm("Flight dates was changed. Do you want to save change?") === true) {
                var $body = $("body"), flightData = getSelectedEvent(),
                    startTime = moment(itemFlight.start).format("YYYY-MM-DD HH:mm:ss"),
                    endDate = moment(itemFlight.end).format("YYYY-MM-DD HH:mm:ss"),
                    request, requestData = $.ajaxSetup({
                        type: "GET",
                        dataType: "json"
                    });

                if (!flightData) {
                    return false;
                }

                $body.addClass("loading");
                if (flightData.type == T_MAINTENANCE) {
                    requestData = {
                        url: baseUrl + "/aircraft/ajax-change-maintenance",
                        data: {
                            start_date: startTime,
                            end_date: endDate,
                            maintenance_id: flightData.id,
                            aircraft_name: itemFlight.group
                        }
                    };
                } else if (flightData.type == T_FLIGHT) {
                    requestData = {
                        url: baseUrl + "/flight/ajax-change-flight",
                        data: {
                            start_date: startTime,
                            end_date: endDate,
                            flight_id: flightData.id,
                            aircraft_name: itemFlight.group
                        }
                    };
                }
                request = $.ajax(requestData);
                request.done(function (data) {
                    if (typeof data.success !== "undefined") {
                        showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                        if (flightData.type == T_FLIGHT) {
                            //
                        } else if (flightData.type == T_MAINTENANCE) {
                            //
                        }

                    } else {
                        showMessage(data.message, data.title, MESSAGE_DANGER, messageBlock);
                        timeline.setSelection([]);
                        timeline.changeItem(row, itemFlight);
                    }
                    // update page
                    window.location = baseUrl + "/fleetwatch/index?go_to_date=" + moment(itemFlight.start).format("YYYY-MM-DD");
                });
                request.fail(function (jqXHR, textStatus) {
                    showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                });
                request.always(function () {
                    $body.removeClass("loading");
                });
            } else {
                timeline.cancelChange();
                timeline.setSelection([]);
                return false;
            }
        }
    );

    /**
     * Select exact flight event handler
     * @return void
     */
    /*
    google.visualization.events.addListener(timeline, "select", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;

        var _this = $(this), $body = $("body"), requestData,
            flightData = getSelectedEvent(), request;

        if (!flightData) {
            return false;
        }
        if (flightData.type == T_MAINTENANCE) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/aircraft/ajax-get-maintenance",
                data: {
                    maintenance_id: flightData.id
                }
            };
        } else if (flightData.type == T_FLIGHT) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/flight-watch/ajax-get-flight",
                data: {
                    flight_id: flightData.id
                }
            };
        }
        request = $.ajax(requestData);
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                if (flightData.type == T_FLIGHT) {
                    fillFlightForm(data);
                    fillStaffForm(data);
                    fillMVTMessages(data);
                    //DisableStdSta();
                } else if (flightData.type == T_MAINTENANCE) {
                    //
                }
            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
        });
    });
    */

    /**
     * Timeline range was changed event handler
     * @return void
     */
    google.visualization.events.addListener(timeline, "rangechanged",
        function (dates) {
            var now = new Date();

            /*
             if ((dates.start <= now && now <= dates.end) && dateDiffInDays(dates.start, dates.end) <= 4) {
             // range is not changed so many to send AJAX request
             return false;
             }
             */

            var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
                airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

            $.each(airportSelected, function(i, item){
                airportIDs.push($(item).attr("data-id"));
            });

            $.each(airlineSelected, function(i, item){
                airlineIDs.push($(item).attr("data-id"));
            });

            var request, loading = $("#loading-fleetwatch-data"),
                requestData = {
                    type: "GET",
                    dataType: "JSON",
                    url: baseUrl + "/flight-watch/ajax-get-range",
                    data: {
                        airport_id: airportIDs,
                        airline_id: airlineIDs,
                        start_date: moment(dates.start).format("YYYY-MM-DD HH:mm:ss"),
                        end_date: moment(dates.end).format("YYYY-MM-DD HH:mm:ss")
                    }
                };

            loading.show();
            request = $.ajax(requestData);
            request.done(function (data) {
                if (typeof data.success !== "undefined") {
                    var flights = [], flightItem, maintenanceItem, flt, jsonData = data.jsonData;
                    // recreate timeline
                    /*if (typeof data.flights !== "undefined" && data.flights.length) {
                     for (i = 0, l = data.flights.length; i < l; i++) {
                     flightItem = data.flights[i];
                     flt = {
                     "start": getStartDate(flightItem),
                     "end": getEndDate(flightItem),
                     "group": getFlightGroup(flightItem),
                     "className": getFlightClassName(flightItem)
                     };

                     flt.content = getFlightContent(flightItem, flt.start, flt.end);

                     flights.push(flt);
                     }
                     }

                     if (typeof data.aircraftMaintenance !== "undefined" && data.aircraftMaintenance.length) {
                     for (i = 0, l = data.aircraftMaintenance.length; i < l; i++) {
                     maintenanceItem = data.aircraftMaintenance[i];
                     flights.push({
                     "start": moment(maintenanceItem.arrival_time).toDate(),
                     "end": moment(maintenanceItem.departure_time).toDate(),
                     "content": getMaintenanceContent(maintenanceItem),
                     "group": getFlightGroup(maintenanceItem),
                     "className": FLIGHT_MAINTENANCE
                     });
                     }
                     }*/
                    flights = prepareDataForTimeline(jsonData, true);
                    //if (flights.length) {
                    timeline.setData(flights);
                    timeline.redraw();
                    //}

                    // Update Flight tracker
                    updateFlightTracker(data);

                } else {
                    showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
                }
                $("#start_visible_period").val(moment(dates.start).format("YYYY-MM-DD HH:mm:ss"));
                $("#end_visible_period").val(moment(dates.end).format("YYYY-MM-DD HH:mm:ss"));

            });
            request.fail(function (jqXHR, textStatus) {
                showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
            });
            request.always(function () {
                loading.hide();
            });
        }
    );

    // Update Timeline Every
    window.setInterval(updateTimeline, 120000);
}

function resetLineSelection(){
    $("#lineTitle").text("");
    $("#lineHeader").hide();
    $("#tableFltLine").find("tbody > tr").remove();
}



$(document).on("click", "a#save_line", function(){
    var _this = $(this), header = _this.parents("#lineHeader"),
        line = header.data("line"),
        rows = $(document).find("#tableFltLine > tbody > tr");

    var flightIDs = [], id, row;
    $.each(rows, function(i, item){
        row = $(item);
        if (row.find("td.checkbox-column > input").is(":checked")){
            id = row.data("id");
            if (id){
                flightIDs.push(id)
            }
        }
    });

    console.log(flightIDs)

    var request = $.ajax({
        headers: {
            'x-csrf-token': $(document).find('form input[name=_token]').val()
        },
        url:  baseUrl + "/flight-watch/save-line",
        type: 'POST',
        dataType: 'json',
        data : {
            aircraft_type_id    : $("#aircraft_type_id").val(),
            ac_type             : $("#ac_type").val(),
            aircraft_id         : $("#aircraft_id").val(),
            ac                  : $("#ac").val(),
            flight_ids          : flightIDs,
            line                : line,
        }
    });

    request.done(function (data) {
        if (typeof data.success !== "undefined") {

            if (typeof data.error !== "undefined" && data.error){
                messageBlock.html("<span class='text-red'>" + data.message + "</span>");
                return;
            }

            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true);

            if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();
            }

            updatedAircraftByTypeAndAirlineList(data);

            updateFlightTracker(data);

            resetLineSelection();
        }
    });
    request.fail(function (jqXHR, textStatus) {
        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
    });
});

$(document).on("click", "th.checkbox-column", function(){
    var _this = $(this);

    if (_this.text() === "Select"){
        _this.parents("table").find("tbody td.checkbox-column > input").prop("checked", true);
        _this.text("Deselect");
    }
    else {
        _this.parents("table").find("tbody td.checkbox-column > input").prop("checked", false);
        _this.text("Select");
    }
});

$(document).on("click", "a.left_sidebar", function(){
    var _this = $(this), line =  _this.data("line"), ac = _this.text(),
        aircraftID = _this.data("ac_id"), aircraftTypeID = _this.data("ac_type_id"),
        lineHeader = $("#lineHeader"), lineTitle = $("#lineTitle"), table = $("#tableFltLine"), tableAll = $("#tableFltAll"),
        // rows = loadedAllFlights.find("tr[data-line=" + line + "]");
        rows = $(document).find("#tableFltAll tr[data-line=" + line + "]").clone();

    rows.find(".checkbox-column").show();
    rows.find("td.checkbox-column > input").prop("checked", true);
    table.find("th.checkbox-column").text("Deselect");

    $("#cancel_btn1").click();
    activateTab("flight_watch_main_tab", "flightInformationTab");
    activateTab("flight_by_type_tab", "tabLine");
    lineHeader.data("line", line);
    // lineHeader.data("ac_id", aircraftID);
    // lineHeader.data("ac_type_id", aircraftTypeID);
    lineHeader.show();
    lineTitle.text(ac);
    table.find("tbody > tr").remove();
    table.append(rows);

    console.log("AC: " + aircraftID + " | Type: " + aircraftTypeID);

    AircraftTypeChange(false);

    AircraftChange(false, false, aircraftTypeID);

    if (aircraftID){
        $("#aircraft_id").val(aircraftID);

        if (aircraftTypeID){
            $("#aircraft_type_id").val(aircraftTypeID);
        }
    }
    else {
        $("#aircraft_type_id").val(aircraftTypeID);
    }
});

function activateTab(tabID, pageID){
    $('#' + tabID + ' a[href="#' + pageID + '"]').tab('show');
};

function updateFlightTracker(data){
    var tabDepartures = $("#tabDepartures"),
        tabArrivals = $("#tabArrivals"),
        tabAll = $("#tabAll"),
        airlinesSelector = $("#airline_id");

    var flightTables = data.flightTables;

    tabDepartures.children().remove();
    tabDepartures.html(flightTables["DEPARTURE"]);
    ApplyTableFilter("#tableFltDepartures");

    tabArrivals.children().remove();
    tabArrivals.html(flightTables["ARRIVAL"]);
    ApplyTableFilter("#tableFltArrivals");

    // loadedAllFlights = flightTables["ALL"];
    tabAll.children().remove();
    tabAll.html(flightTables["ALL"]);
    ApplyTableFilter("#tableFltAll");

    if (typeof data.airlines !== "undefined") {
        //airlinesSelector.children().remove();
        // airlinesSelector.append('<option value="">Select</option>');
        $.each(data.airlines, function (key, obj) {
            if (!airlinesSelector.find("option[value=" + obj.id+"]").length){
                airlinesSelector.append('<option value=' + obj.id + '>' + obj.code + '</option>');
            }
        });
    }
}

function updateTimeline () {
    var now = new Date();

    var timeObj = timeline.getVisibleChartRange();

    var start_visible_time = moment(timeObj.start).format("YYYY-MM-DD HH:mm:ss"),
        end_visible_time = moment(timeObj.end).format("YYYY-MM-DD HH:mm:ss"),
        start_visible_date = moment(timeObj.start),
        end_visible_date = moment(timeObj.end),
        todays_date = moment(now);

    if (start_visible_date.isAfter(todays_date, 'day') || end_visible_date.isBefore(todays_date, 'day')){
        return;
    }
    //end_visible_time = moment(now.setHours(now.getHours() + 12)).format("YYYY-MM-DD HH:mm:ss");

    var airportSelected = $(document).find("a.quick-airports.btn-warning"), airportIDs = [],
        airlineSelected = $(document).find(".quick-airlines.selected"), airlineIDs = [];

    $.each(airportSelected, function(i, item){
        airportIDs.push($(item).attr("data-id"));
    });

    $.each(airlineSelected, function(i, item){
        airlineIDs.push($(item).attr("data-id"));
    });

    var request, loading = $("#loading-fleetwatch-data"),
        requestData = {
            type: "GET",
            dataType: "JSON",
            url: baseUrl + "/flight-watch/ajax-get-range",
            data: {
                airport_id: airportIDs,
                airline_id: airlineIDs,
                start_date: start_visible_time,
                end_date:   end_visible_time,
                flight_tracker : true,
            }
        };

    loading.show();
    request = $.ajax(requestData);
    request.done(function (data) {
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true);

            if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();

                // Update Flight tracker
                updateFlightTracker(data);
            }
        } else {
            showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
        }
        $("#start_visible_period").val(start_visible_time);
        $("#end_visible_period").val(end_visible_time);

    });
    request.fail(function (jqXHR, textStatus) {
        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
    });
    request.always(function () {
        loading.hide();
    });
}

function DisableStdSta(autoCreated) {
    var std = $('#std'), sta = $("#sta");

    if (autoCreated || $userAnyAdmin){
        std.removeAttr('disabled');
        sta.removeAttr('disabled');
    }
    else {
        std.attr('disabled', 'disabled');
        sta.attr('disabled', 'disabled');
    }

    std.removeAttr('required');
    sta.removeAttr('required');
}

/**
 * Get start date
 * @param flight
 * @returns {*}
 */
function getStartDate(flight) {
    var date;
    if (flight.atd) {
        date = moment(flight.atd, inputDateFormat).toDate();
    } else if (flight.etd) {
        date = moment(flight.etd, inputDateFormat).toDate();
    } else if (flight.ptd) {
        date = moment(flight.ptd, inputDateFormat).toDate();
    } else {
        date = moment(flight.std, inputDateFormat).toDate();
    }
    return date;
}

/**
 * Get end date
 * @param flight
 * @returns {*}
 */
function getEndDate(flight) {
    var date;
    if (flight.ata) {
        date = moment(flight.ata, inputDateFormat).toDate();
    } else if (flight.eta) {
        date = moment(flight.eta, inputDateFormat).toDate();
    } else if (flight.pta) {
        date = moment(flight.pta, inputDateFormat).toDate();
    } else {
        date = moment(flight.sta, inputDateFormat).toDate();
    }
    return date;
}

function getSLAFlightDeparture(flight) {
    var date;
    /*
    if (flight.atd && flight.atd != EMPTY_DATETIME) {
        date = moment(flight.atd, inputDateFormat).toDate();
    }
    else if (flight.etd && flight.etd != EMPTY_DATETIME) {
        date = moment(flight.etd, inputDateFormat).toDate();
    }
    else
    */
    if (flight.ptd && flight.ptd != EMPTY_DATETIME) {
        date = moment(flight.ptd, inputDateFormat).toDate();
    }
    else {
        date = moment(flight.std, inputDateFormat).toDate();
    }
    return date;
}

/**
 * Get end date
 * @param flight
 * @returns {*}
 */
function getSLAFlightArrival(flight) {
    var date;
    /*
    if (flight.ata && flight.ata != EMPTY_DATETIME) {
        date = moment(flight.ata, inputDateFormat).toDate();
    }
    else if (flight.eta && flight.eta != EMPTY_DATETIME) {
        date = moment(flight.eta, inputDateFormat).toDate();
    }
    else
    */
    if (flight.pta && flight.pta != EMPTY_DATETIME) {
        date = moment(flight.pta, inputDateFormat).toDate();
    }
    else {
        date = moment(flight.sta, inputDateFormat).toDate();
    }
    return date;
}

/**
 * Get flight content
 * @param flight
 * @return string
 */
function getFlightContent(flight, departure, arrival) {
    var diff = moment(arrival).diff(departure, 'm'), result, diversion;

    if (flight.is_diversion) {
        diversion = flight.diversion;
        result = "<div id='flight-" + flight.id + "' class='row fw-flight-item diversion'>" +
            "<div class='flight_number_diversion_box_left diversionBox'>" +
            "<span class='flight_number_diversion_box_left'>" + flight.flight_number.departure_airport + "</span>" +
            "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
            "<span class='flight_number_diversion_box_right'>" + diversion['diversion_airport_code'] + "</span>" +
            "</div>" +
            "<div class='flight_number_diversion_box_center flightStandard'>" +
            "<span class='text-center'>" + CURRENT_IATA_CODE + " " + flight.flight_number.flight_number + "</span>" +
            "</div>" +
            "<div class='flight_number_diversion_box_right diversionBox'>" +
            "<span class='flight_number_diversion_box_left'>" + diversion['diversion_airport_code'] + "</span>" +
            "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
            "<span class='flight_number_diversion_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
            "</div>" +
            "</div>";
    }
    else {
        if (diff < 90) {
            result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                "<div class='col-sm-12 flightStandard'>" +
                "<span class='flight_number_box_small'>" + flight.flight_number.flight_number + "</span>" +
                "</div>" +
                "</div>";
        }
        else {

            var fNo;
            if ($.inArray(flight.flightNumber.flightType.type, [ TAJIKAIR, OTHERAIRLINES ])){
                fNo = flight.flight_number.flight_number;
            }
            else {
                fNo = CURRENT_IATA_CODE + " " + flight.flight_number.flight_number;
            }
            result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                "<div class='col-sm-12 flightStandard'>" +
                "<span class='flight_number_box_left'>" + flight.flight_number.departure_airport + "</span>" +
                "<span class='flight_number_box_center'>" + fNo + "</span>" +
                "<span class='flight_number_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
                "</div>" +
                "</div>";
        }
    }
    return result;
}

/**
 *
 * @param maintenance
 * @returns {string}
 */
function getMaintenanceContent(maintenance) {
    return "<div id='maintenance-" + maintenance.id + "' class='fw-flight-item'>" +
        maintenance.note + " (" + maintenance.location_code + ")" +
        "</div>";
}

/**
 * Get flight group name
 * @param flight
 * @returns {*}
 */
function getFlightGroup(flight) {
    return flight.aircraft.name;
}

/**
 * Get flight class name
 * @param flight
 */
function getFlightClassName(flight) {
    var className = FLIGHT_AVAILABLE;
    if (flight.is_diversion) {
        className = FLIGHT_DIVERTED;
    } else {
        if (flight.delay_id) {
            className = FLIGHT_DELAYED;
        } else {
            var atd, etd, std, diff;
            if (flight.atd) {
                atd = moment(flight.atd, inputDateFormat);
                std = moment(flight.std, inputDateFormat);
                diff = atd.diff(std, "minutes");

                if (atd > std && diff >= 3) {
                    className = FLIGHT_DELAYED;
                }
            } else if (flight.etd) {
                etd = moment(flight.etd, inputDateFormat);
                std = moment(flight.std, inputDateFormat);
                diff = etd.diff(std, "minutes");

                if (etd > std && diff >= 3) {
                    className = FLIGHT_DELAYED;
                }
            }
        }
    }
    return className;
}

/**
 * Parse flight information
 * @param data
 */
var generalTabTemplateHTML = $("#general_tab_template");

function parseFlight(data) {
    var flight = data.flight, generalTabTemplate, templateData,
        _general_tab_template = generalTabTemplateHTML.clone(),
        _title = $("#modal_title"), flightNumber = flight.flight_number,
        flightNumText = (flightNumber.airline ?
            (flightNumber.airline.iata ? flightNumber.airline.iata : (flightNumber.airline.icao ? flightNumber.airline.icao : flightNumber.airline.airline)+ "-") : "" ) + flightNumber.flight_number,
        aircraftDetails = "",
        flightNumRadar = (flightNumber.airline ? (flightNumber.airline.iata ? flightNumber.airline.iata : (flightNumber.airline.icao ? flightNumber.airline.icao : "")).toUpperCase() : "") + ltrim(flightNumber.flight_number, "0"),
        flightNumAware = (flightNumber.airline ? (flightNumber.airline.icao ? flightNumber.airline.icao : (flightNumber.airline.icao ? flightNumber.airline.icao : "")).toUpperCase() : "") + flightNumber.flight_number;

    // Load Staff
    loadStaff(flight, data.serviceData);


    if (flight.aircraft){
        // Type
        if (flight.aircraft.type){
            aircraftDetails += " / " + (flight.aircraft.type.iata_name ? flight.aircraft.type.iata_name : flight.aircraft.type.icao);
        }

        // Name
        if (flight.aircraft.name){
            aircraftDetails += " / " + flight.aircraft.name;
        }
        else if (flight.aircraft.mvt_name){
            aircraftDetails += " / " + flight.aircraft.mvt_name;
        }
    }
    else {
        if (flight.aircraft_type){
            aircraftDetails += " / " + (flight.aircraft_type.iata_name ? flight.aircraft_type.iata_name : flight.aircraft_type.icao);
        }
    }

    if (flight.capacity_a || flight.capacity_c || flight.capacity_w || flight.capacity_y){
        if (flight.capacity_a){
            aircraftDetails += " / " + flight.capacity_a + "F ";
        }
        if (flight.capacity_c){
            aircraftDetails += " / " + flight.capacity_c + "C ";
        }
        if (flight.capacity_w){
            aircraftDetails += " / " + flight.capacity_w + "W ";
        }
        if (flight.capacity_y){
            aircraftDetails += " / " + flight.capacity_y + "Y";
        }
    }
    else if (flight.aircraft){
        if (flight.aircraft.config_a){
            aircraftDetails += " / " + flight.aircraft.config_a + "F ";
        }
        if (flight.aircraft.config_c){
            aircraftDetails += " / " + flight.aircraft.config_c + "C ";
        }
        if (flight.aircraft.config_w){
            aircraftDetails += " / " + flight.aircraft.config_w + "W ";
        }
        if (flight.aircraft.config_y){
            aircraftDetails += " / " + flight.aircraft.config_y + "Y";
        }
    }

    var remark = "<span style='font-weight:bold; color:red; font-size:18px;'>";

    if (flight.diverted_airport_id){
        remark += " | DIVERTED";
    }

    if (flight.cancelled_at){
        remark += "| Cancelled";

        if (flight.remark){
            remark += " | Reason:" + flight.remark;
        }
    }
    else {
        if (flight.remark){
            remark += " | " + flight.remark;
        }
    }

    remark += "</span>";

    var flt_date = moment(getFlightDepartureInitialDate(flight)).format("YYYY-MM-DD");

    _title.html("<div class='col-md-12'>" +
        "<table style='width: 100%;'>" +
        "<tr>"+
        "<td rowspan='2'>" +
        "<a style='font-size:18px;' target='_blank' href='" + baseUrl + '/flight-info/handling/' + flight.id + "'>" + flightNumText + "</a>" +
        "<a>"  + aircraftDetails + "</a>" +
        remark +
        "</td>" +
        "<td rowspan='2' style=''><a style='font-size: 18px;border: 1px solid;padding: 5px 10px;' target='_blank' href='" + baseUrl + "/flight-com?date=" + flt_date + "&flight_id=" + flight.id + "&refresh=1'>Flight Comms</a></td>"+
        "<td rowspan='2' style='width: 180px; text-align: center'><a class='flightTracker' target='_blank' href='" + baseUrl + "/flight-tracker/" + flight.id + "'>FlightTracker</a></td>"+
        // "<td style='width: 70px;'><a style='font-size:12px;' target='_blank' href='https://www.radarbox24.com/data/flights/" + flightNumRadar + "'>RadarBox</a>" +
        "<td style='width: 70px;'><a style='font-size:12px;' target='_blank' href='https://flightaware.com/live/flight/" + flightNumAware + "'>FlightAware</a>" +
        "<td rowspan='2' style='width: 30px; text-align: right;'>" +
        "<button type='button' class='close close-btn font-lg' data-dismiss='modal'>" +
        "<span class='font-lg' aria-hidden='true'>&times;</span>" +
        "<span class='sr-only'>Close</span>" +
        "</button>" +
        "</td>" +
        "</tr>" +
        // "<tr>" +
        //     "<td><a style='font-size:12px;' target='_blank' href='https://flightaware.com/live/flight/" + flightNumAware + "'>FlightAware</a></tr>" +
        // "</tr>" +
        "</table>" +
        "</div>");

    // www.flightradar24.com/flight/bt221

    if (generalTabTemplateHTML.length) {
        var html = _general_tab_template.html();
        generalTabTemplate = _.template(html);
        var captains = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_IN_FLIGHT),
            firstOfficers = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_IN_FLIGHT),
            flightAttendants = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_IN_FLIGHT),

            captainsDHC = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_DHC),
            firstOfficersDHC = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_DHC),
            flightAttendantsDHC = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_DHC),

            captainsStandby = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_STANDBY),
            firstOfficersStandby = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_STANDBY),
            flightAttendantsStandby = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_STANDBY),

            flightAttendantsSUP = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_SUP);

        var pax_c_actual = (flight.pax_c_actual) ? parseInt(flight.pax_c_actual) : 0,
            pax_y_actual = (flight.pax_y_actual) ? parseInt(flight.pax_y_actual) : 0,
            //allowance_baggage = (pax_c_actual + pax_y_actual == 0) ? "&mdash;" : pax_c_actual * C_BAGGAGE_WEIGHT + pax_y_actual * Y_BAGGAGE_WEIGHT,
            //excess_baggage = (!flight.baggage || allowance_baggage == "&mdash;") ? "&mdash;" : (((parseInt(flight.baggage) - allowance_baggage) < 0) ? 0 : (parseInt(flight.baggage) - allowance_baggage)),
            //excess_baggage_revenue = (excess_baggage == "&mdash;") ? 0 : excess_baggage * EXCESS_BAGGAGE_RATE,
            //cargo_revenue = (flight.cargo) ? parseInt(flight.cargo) * CARGO_RATE : 0,
            //mail_revenue = (flight.mail) ? parseInt(flight.mail) * MAIL_RATE : 0,
            total_kgs = 0,

            std = showDateInFlightTimings(flight, "std"),
            ptd = showDateInFlightTimings(flight, "ptd"),
            etd = showDateInFlightTimings(flight, "etd"),
            atd = showDateInFlightTimings(flight, "atd"),
            abn = showDateInFlightTimings(flight, "abn"),

            sta = showDateInFlightTimings(flight, "sta"),
            pta = showDateInFlightTimings(flight, "pta"),
            eta = showDateInFlightTimings(flight, "eta"),
            tdn = showDateInFlightTimings(flight, "tdn"),
            ata = showDateInFlightTimings(flight, "ata");


        total_kgs += (flight.baggage) ? parseInt(flight.baggage) : 0;
        total_kgs += (flight.cargo) ? parseInt(flight.cargo) : 0;
        total_kgs += (flight.mail) ? parseInt(flight.mail) : 0;
        total_kgs += (flight.eic) ? parseInt(flight.eic) : 0;

        var airport_oth = [], pax_c_oth = [], pax_y_oth = [], pax_inf_oth = [],
            pax_ch_oth = [], pax_m_oth = [], pax_f_oth = [],
            baggage_oth = [], baggage_pcs_oth = [], cargo_oth = [], cargo_pcs_oth = [],
            eic_oth = [], mail_oth = [], total_oth = [];

        var pax_oth_content = null;
        var baggage_content  = "", cargo_tr    = "", eic_tr      = "", mail_tr     = "", total_tr    = "";

        if (flight.station && flight.station.length){

            pax_oth_content = '<div class="float-left" style="width: 20%; ">'+
                '<table class="pax-modal">' +
                '<tbody>';

            var airport_tr  = "", // "<td class='width-35'></td>",
                pax_a_tr    = "", // "<td class='highlighted'>C</td>",
                pax_c_tr    = "", // "<td class='highlighted'>C</td>",
                pax_w_tr    = "", // "<td class='highlighted'>Y</td>",
                pax_y_tr    = "", // "<td class='highlighted'>Y</td>",
                pax_inf_tr  = "", // "<td class='highlighted'>INF</td>",
                pax_ch_tr   = "", // "<td>CH</td>",
                pax_m_tr    = "", // "<td>M</td>",
                pax_f_tr    = ""; // "<td>F</td>";

            for(var n = 0; n < flight.station.length; n++){
                airport_oth.push(flight.station[n].airport);
                pax_c_oth.push(flight.station[n].pax_c);
                pax_y_oth.push(flight.station[n].pax_y);
                pax_inf_oth.push(flight.station[n].pax_inf);
                pax_ch_oth.push(flight.station[n].pax_ch);
                pax_m_oth.push(flight.station[n].pax_m);
                pax_f_oth.push(flight.station[n].pax_f);

                var bag     = flight.station[n].baggage     ? flight.station[n].baggage     : 0,
                    bag_pcs = flight.station[n].baggage_pcs ? flight.station[n].baggage_pcs : 0,
                    cargo   = flight.station[n].cargo       ? flight.station[n].cargo       : 0,
                    cargo_pcs  = flight.station[n].cargo_pcs   ? flight.station[n].cargo_pcs       : 0,
                    eic     = flight.station[n].eic         ? flight.station[n].eic         : 0,
                    mail    = flight.station[n].mail        ? flight.station[n].mail        : 0,
                    total   = bag + cargo + mail + eic;

                baggage_oth.push(bag);
                baggage_pcs_oth.push(bag_pcs);
                cargo_pcs_oth.push(cargo_pcs);
                cargo_oth.push(cargo);
                eic_oth.push(eic);
                mail_oth.push(mail);
                total_oth.push(total);
            }

            for(n = 0; n < airport_oth.length; n++){
                airport_tr  += ("<td>" + airport_oth[n]  + "</td>");
                pax_c_tr    += ("<td class='data'>" + pax_c_oth[n]    + "</td>");
                pax_y_tr    += ("<td class='data'>" + pax_y_oth[n]    + "</td>");
                pax_inf_tr  += ("<td class='data'>" + pax_inf_oth[n]  + "</td>");
                pax_ch_tr   += ("<td class='data-unimportant'>" + pax_ch_oth[n]   + "</td>");
                pax_m_tr    += ("<td class='data-unimportant'>" + pax_m_oth[n]    + "</td>");
                pax_f_tr    += ("<td class='data-unimportant'>" + pax_f_oth[n]    + "</td>");

                baggage_content  += "<tr>" +
                    "<td class=''>" + airport_oth[n] + "</td>" +
                    "<td class='data-unimportant'>" + baggage_pcs_oth[n] + " / " + baggage_oth[n] + "</td>" +
                    "<td class='data-unimportant'>" + cargo_pcs_oth[n] + " / " +  cargo_oth[n]    + "</td>" +
                    "<td class='data-unimportant'>" + eic_oth[n]         + "</td>" +
                    "<td class='data-unimportant'>" + mail_oth[n]        + "</td>" +
                    "<td class='data-unimportant'>" + total_oth[n]       + "</td>" +
                    "</tr>";
            }

            pax_oth_content +=  airport_tr + "</tr>" +
                pax_c_tr + "</tr>" +
                pax_y_tr  + "</tr>" +
                pax_inf_tr + "</tr>" +
                pax_ch_tr + "</tr>" +
                pax_m_tr + "</tr>" +
                pax_f_tr + "</tr>";

            pax_oth_content +=  '</tbody>' +
                '</table>' +
                '</div>';
        }

        var all_tabs = [
            LDS,
            MVT,
            CPM,
            CAL,
            LDM,
            LIR,
            LPM,
            PSM,
            PTM,
            UCM,
            TPM,
            PNL,
            ADL,
            PRL,
            SLS,
            HBG,
            CREW_LIST,
            NOT,
            NOTOC,
            OTHS,
        ];

        var messageTypes = [], messagasList = flight.message.length ? flight.message : flight.message2018;

        if (messagasList && messagasList.length){
            var msg;
            $.each(messagasList, function(i, each){
                if ($.inArray(each.message_type, messageTypes) == -1){

                    if (each.message_type == LOADSHEET || each.message_type == LOADSHEET_FINAL){
                        msg = LDS;
                    }
                    else if (each.message_type == CREW_LIST){
                        msg = "crew_list";
                    }
                    else if (each.message_type == ONLOAD){
                        msg = OTHS;
                    }
                    else {
                        msg = each.message_type;
                    }

                    if (!msg){
                        return;
                    }

                    $("#" + msg.toLowerCase() + "_tab").addClass("has-message");
                    messageTypes.push(msg);
                }
            });

            if ($.inArray(PNL, messageTypes) != -1 || $.inArray(PRL, messageTypes) != -1 || $.inArray(PTM, messageTypes) != -1){
                messageTypes.push(PL);
                $("#pl_tab").addClass("has-message");
            }
        }

        $.each(all_tabs, function(i, each){
            if (each == CREW_LIST){
                each = "crew_list";
            }
            if ($.inArray(each, messageTypes) == -1){
                msg = each.toLowerCase();
                $("#" + msg + "_tab").removeClass("has-message");
            }
        });


        if (Object.keys(flight.staffList).length){
            $("#staff_tab").addClass("has-message");
        }
        else {
            $("#staff_tab").removeClass("has-message");
        }


        var departureAP = getFlightDepartureAirport(flight, "IATA"),
            arrivalAP = getFlightArrivalAirport(flight, "IATA", true),
            divertedAP = "", originalDestinationLabel = "";

        if (flight.diverted_airport_id){
            divertedAP = flight.diverted_airport.iata;
            originalDestinationLabel = "ORIGINAL DESTINATION: ";

            if (flight.prev_flight_id){
                divertedAP = arrivalAP;
                arrivalAP = "";
                originalDestinationLabel = "DIVERTED";
            }
        }

        templateData = {
            planeIcon: (flight.delays && flight.delays.length > 0) ?  baseUrl + "/assets/img/plane-delayed.png?3" : baseUrl + "/assets/img/plane-ontime.png?3",
            cancelled: flight.cancelled_at ? true : false,
            flightBarPosition: getFlightProgressBarFlownPercentage(flight),
            planeWidth: getPlaneWidth(),
            planePosition: getPlanePosition(),

            departureCityCode: departureAP,
            arrivalCityCode: arrivalAP,

            departureDateType : flight.departure_date_type,
            arrivalDateType : flight.arrival_date_type,

            departureLocalDate: flight.departure_local_date  ? flight.departure_local_date    : "",
            departureLocalTime: flight.departure_local_time  ? flight.departure_local_time    : "",

            arrivalLocalDate:   flight.arrival_local_date    ? flight.arrival_local_date      : "",
            arrivalLocalTime:   flight.arrival_local_time    ? flight.arrival_local_time      : "",

            departureCity: getFlightDepartureAirport(flight, "NAME"), // data.departure_city,
            arrivalCity: getFlightArrivalAirport(flight, "NAME", true), // data.arrival_city,

            //divertedMessageDisplay : flight.diverted_airport_id ? "block" : "none",
            //divertedMessage : flight.diverted_airport_id ? "DIVERTED" : "",

            flightInfoHeaderBgColor : flight.diverted_airport_id ? "#ffd3d3" : "#ffffff",
            progressStatus : flight.diverted_airport_id ? "info" : ((flight.is_delayed || (flight.delays && flight.delays.length > 0)) ? "danger" : "success"),
            progressBarPerc: flight.diverted_airport_id ? 53 : 83,
            arrAirportColor: flight.diverted_airport_id ? "red" : "",
            divAirport: divertedAP,
            divAirportPerc: flight.diverted_airport_id ? 10 : 0,
            divPanelPerc: flight.diverted_airport_id ? 20 : 0,
            originalDestinationLabel: originalDestinationLabel,

            std: std,
            ptd: ptd,
            etd: etd,
            atd: atd,
            abn: abn,

            sta: sta,
            pta: pta,
            eta: eta,
            tdn: tdn,
            ata: ata,

            delays: implode(flight.delaysString, '<br/>&nbsp'),

            pax_mvt_px: flight.pax_mvt_total,
            pax_mvt_inf: flight.pax_mvt_inf,
            pax_mvt_total: (flight.pax_mvt_total ? flight.pax_mvt_total : 0) + (flight.pax_mvt_inf ? flight.pax_mvt_inf : 0),

            pax_a_actual: flight.pax_a_actual,
            pax_c_actual: flight.pax_c_actual,
            pax_w_actual: flight.pax_w_actual,
            pax_y_actual: flight.pax_y_actual,
            pax_inf_actual: flight.pax_inf_actual,
            pax_ch_actual: flight.pax_ch_actual,
            pax_m_actual: flight.pax_m_actual,
            pax_adults_actual: flight.pax_adults_actual,
            pax_f_actual: flight.pax_f_actual,

            //pax_oth_content : pax_oth_content,
            airport_tr : airport_tr,
            pax_a_tr   : pax_a_tr,
            pax_c_tr   : pax_c_tr,
            pax_w_tr   : pax_w_tr,
            pax_y_tr   : pax_y_tr,
            pax_inf_tr : pax_inf_tr,
            pax_ch_tr  : pax_ch_tr,
            pax_m_tr   : pax_m_tr,
            pax_f_tr   : pax_f_tr,

            //cargo_tr: cargo_tr,
            //eic_tr: eic_tr,
            //mail_tr: mail_tr,
            //total_tr: total_tr,
            //airport_oth: airport_oth,
            //pax_c_oth: pax_c_oth,
            //pax_y_oth: pax_y_oth,
            //pax_inf_oth: pax_inf_oth,
            //pax_ch_oth: pax_ch_oth,
            //pax_m_oth: pax_m_oth,
            //pax_f_oth: pax_f_oth,
            //baggage_allowance: allowance_baggage,
            //excess_baggage: excess_baggage,
            //excess_baggage_revenue: excess_baggage_revenue,
            //cargo_revenue: cargo_revenue,
            //mail_revenue: mail_revenue,
            baggage_content : baggage_content,
            baggage_pcs_total: flight.baggage_pcs ? flight.baggage_pcs : "&mdash;",

            eic_total: flight.eic ? flight.eic : "&mdash;",
            baggage_total: flight.baggage ? flight.baggage : "&mdash;",
            mail_total: flight.mail ? flight.mail : "&mdash;",

            cargo_total: flight.cargo ? flight.cargo : "&mdash;",
            cargo_pcs_total: flight.cargo_pcs ? flight.cargo_pcs : "&mdash;",

            total_bcme: total_kgs,

            pax_a_booked: flight.pax_a_booked,
            pax_c_booked: flight.pax_c_booked,
            pax_w_booked: flight.pax_w_booked,
            pax_y_booked: flight.pax_y_booked,
            pax_inf_booked: flight.pax_inf_booked,
            de: flight.deportees,
            ckin_num: flight.ckin_num,

            in_tanks: flight.in_tanks ? flight.in_tanks : "",
            uplifted: flight.uplifted ? flight.uplifted : "",
            utilised: flight.utilised ? flight.utilised : "",
            defuel: flight.defuel ? flight.defuel : "",

            captains: implode(captains, ", "),
            first_officers: implode(firstOfficers, ", "),
            cabin_crew: implode(flightAttendants, ", "),
            captains_dhc: implode(captainsDHC, ", "),
            first_officers_dhc: implode(firstOfficersDHC, ", "),
            cabin_crew_dhc: implode(flightAttendantsDHC, ", "),
            captains_standby: implode(captainsStandby, ", "),
            first_officers_standby: implode(firstOfficersStandby, ", "),
            cabin_crew_standby: implode(flightAttendantsStandby, ", "),

            cabin_crew_sup: implode(flightAttendantsSUP, ", ")
        };
        var in_tanks = templateData.in_tanks ? parseInt(templateData.in_tanks) : 0,
            uplifted = templateData.uplifted ? parseInt(templateData.uplifted) : 0,
            utilised = templateData.utilised ? parseInt(templateData.utilised) : 0,
            departure_fuel  = flight.fob    ? flight.fob    : (in_tanks + uplifted),
            arrival_fuel    = flight.rf     ? flight.rf     : (departure_fuel - utilised);

        templateData.dep_fuel = departure_fuel;
        templateData.arr_fuel = arrival_fuel;

        if (!templateData.utilised){
            templateData.utilised = departure_fuel - arrival_fuel;
        }

        $("#general").html(
            generalTabTemplate(templateData)
        );

        generalTabTemplateHTML = _general_tab_template;
        // Tooltip
        $("[data-toggle='tooltip']").popover({trigger: "hover"});

        setTimeout(function () {
            $("#flight_id").val(flight.id);
            $("#flight_number_id").val(flightNumber.id);
            $("#mvt_flight_id").val(flight.id);
            $("#arr_mvt_flight_id").val(flight.id);
        }, 1);
    }
}

var maintenanceTabTemplateHTML = $("#maintenance_tab_template");

function parseMaintenance(data) {
    var maintenance = data.maintenance, maintenanceTabTemplate, templateData,
        _maintenance_tab_template = maintenanceTabTemplateHTML.clone();

    if (_maintenance_tab_template.length) {
        maintenanceTabTemplate = _.template(
            _maintenance_tab_template.html()
        );
    }

    templateData = {
        location: maintenance.location_code,
        arrivalDate: moment(maintenance.arrival_time, inputDateFormat).format(outputDateFormat),
        departureDate: moment(maintenance.departure_time, inputDateFormat).format(outputDateFormat),
        notes: maintenance.note,
        userFullName: maintenance.user ? maintenance.user.last_name + " " + maintenance.user.first_name : "",
    };

    $("#general_maintenance").html(
        maintenanceTabTemplate(templateData)
    );

    maintenanceTabTemplateHTML = _maintenance_tab_template;
}

function getDuration(from, to){
    var duration = moment.duration(moment(to).diff(from));
    var hours = duration.hours(), mins = duration.minutes();

    if (mins > 60) {
        mins -= (hours * 60);
    }

    return (hours < 10 ? "0" + hours : hours) + ":" + (mins < 10 ? "0" + (mins < 0 ? 0 : mins) : mins);
}

function loadStaff(flight, serviceData){
    var staffTableBody = $("#staff-table-body"), tr = "", foundStaff, user, k,
        services = serviceData.services,
        //serviceType = serviceData.serviceType,
        staffList = flight.staffList, flightDepArr;


    staffTableBody.empty();

    var serviceType, req, min, report, release;

    //duration = moment.duration(moment(to).diff(from));
    //minutes = duration.asMinutes();

    var obj, pReportTime, spanType, spanClass, pReleaseTime, pDuration, reportTime, releaseTime, duration, plannedReport, plannedRelease, plannedDuration;

    if (services && services.length) {
        $.each(services, function (key, airlineService) {
            serviceType = airlineService.serviceType;

            if (airlineService.service_timings == 1) {
                if (airlineService.service[serviceType] != 1) {
                    return true;
                }
                obj = airlineService.service;
            }
            else {
                if (airlineService[serviceType] != 1) {
                    // Continue
                    return true;
                }
                obj = airlineService;
            }


            switch (serviceType) {
                case ARRIVAL_SERVICE:
                    req = "arr_staff_req";
                    min = "arr_staff_min";
                    report = "arr_report_time";
                    release = "arr_release_time";
                    spanType = "<span class='label label-success'>ARRIVAL</span>";
                    spanClass = "label-success";

                    flightDepArr = getSLAFlightArrival(flight);
                    plannedReport = moment(flightDepArr).subtract(obj[report], 'm');
                    plannedRelease = moment(flightDepArr).add(obj[release], 'm');
                    break;

                case DEPARTURE_SERVICE:
                    req = "dep_staff_req";
                    min = "dep_staff_min";
                    report = "dep_report_time";
                    release = "dep_release_time";
                    spanType = "<span class='label label-primary'>DEPARTURE</span>";
                    spanClass = "label-primary";

                    flightDepArr = getSLAFlightDeparture(flight);
                    plannedReport = moment(flightDepArr).subtract(obj[report], 'm');
                    plannedRelease = moment(flightDepArr).subtract(obj[release], 'm');
                    break;

                case TURNAROUND_SERVICE:
                    req = "turn_staff_req";
                    min = "turn_staff_min";
                    report = "turn_report_time";
                    release = "turn_release_time";
                    spanType = "<span class='label label-warning'>TURNAROUND</span>";
                    spanClass = "label-warning";

                    var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                    flightDepArr = getSLAFlightDeparture(flight);

                    plannedReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                    plannedRelease = moment(flightDepArr).subtract(obj[release], 'm');
                    break;
            }

            plannedDuration = getDuration(plannedReport, plannedRelease);

            tr += "<tr class='sla-header'>" +
                "<td data-center><span class='label font-sm " + spanClass + "'>" + airlineService.service.abbr + "</span></td>" +
                "<td>" +
                spanType +
                "<span class='margin-left-10'><strong>Required: " + obj[req] + "</strong></span>" +
                "</td>" +

                "<td>" + plannedReport.format("MMM DD, HH:mm") + " <span class='label label-warning'>SLA</span></td>" +
                "<td>" + plannedRelease.format("MMM DD, HH:mm") + " <span class='label label-warning'>SLA</span></td>" +
                "<td data-center>" + plannedDuration + " <span class='label label-warning'>SLA</span></td>" +
                "</tr>";

            foundStaff = false;
            if (staffList.hasOwnProperty(airlineService.service.abbr) && staffList[airlineService.service.abbr].length > 0) {
                k = 0;
                $.each(staffList[airlineService.service.abbr], function (j, staffDetail) {
                    if (airlineService.service_id == staffDetail.service_id) {
                        user = staffDetail.user;
                        pReportTime = staffDetail.planned_report_time && staffDetail.planned_report_time != EMPTY_DATETIME ? moment(staffDetail.planned_report_time) : "";
                        pReleaseTime = staffDetail.planned_release_time && staffDetail.planned_release_time != EMPTY_DATETIME ? moment(staffDetail.planned_release_time) : "";
                        pDuration = pReportTime && pReleaseTime ? getDuration(pReportTime, pReleaseTime) : "";

                        reportTime = staffDetail.report_time && staffDetail.report_time != EMPTY_DATETIME ? moment(staffDetail.report_time) : "";
                        releaseTime = staffDetail.release_time && staffDetail.release_time != EMPTY_DATETIME ? moment(staffDetail.release_time) : "";
                        duration = reportTime && releaseTime ? getDuration(reportTime, releaseTime) : "";

                        tr += "<tr>" +
                            "<td style='vertical-align: middle' data-center>" + (++k) + "</td>" +
                            "<td class='staff-name'>" + (staffDetail.location ? staffDetail.location.iata + " - " : "") + (user ? user.first_name + " " + user.last_name : "") + "</td>" +

                            "<td>" + (pReportTime ? (pReportTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                            (reportTime ? (reportTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                            "</td>" +

                            "<td>" + (pReleaseTime ? (pReleaseTime.format("MMM DD, HH:mm") + " <span class='label label-success'>PLN</span>") : "") + "<br/>" +
                            (releaseTime ? (releaseTime.format("MMM DD, HH:mm") + " <span class='label label-primary'>ACT</span>") : "") +
                            "</td>" +

                            "<td data-center>" + (pDuration ? pDuration + " <span class='label label-success'>PLN</span>" : "") + "<br/>" +
                            (duration ? duration + " <span class='label label-primary'>ACT</span>" : "") +
                            "</td>" +

                            "</tr>";

                        foundStaff = true;
                    }
                });
            }
        });

        staffTableBody.append(tr);
    }
}

function showDateInFlightTimings(flight, type){
    var dep = [
        "std",
        "ptd",
        "etd",
        "atd",
        "abn",
    ];

    var arr = [
        "sta",
        "pta",
        "eta",
        "tdn",
        "ata",
    ];

    if (!flight[type] || flight[type] == EMPTY_DATETIME){
        return "&mdash;"
    }

    var searchArray = ($.inArray(type, dep) !== -1) ? dep : arr;

    var newValue = moment(flight[type], inputDateFormat).format(outputTimeFormat);
    var valueDate =  moment(flight[type], inputDateFormat).format(outputDateOnlyFormat);
    var foundDate;
    var previousTypeDate = true;
    $.each(searchArray, function(i, val){

        if (flight[val] && flight[val] != EMPTY_DATETIME){

            foundDate = moment(flight[val], inputDateFormat).format(outputDateOnlyFormat);
            if (valueDate != foundDate){
                return;
            }

            if (val == type){
                newValue = moment(flight[val], inputDateFormat).format(outputDateFormat)
                previousTypeDate = false;
            }

            return false;
        }
    });

    if (previousTypeDate && foundDate && foundDate !== "undefined" &&
        moment(flight[type], inputDateFormat).format(outputDateOnlyFormat) != foundDate){
        newValue = moment(flight[type], inputDateFormat).format(outputDateFormat)
    }

    return newValue;
}

/**
 * Prepare Raw Data For FleetWatch Timeline
 * @param json
 * @returns {Array}
 */
function prepareDataForTimeline(json, object) {
    var flights = [];
    if (json.length) {
        var item, start_date, end_date;
        for (var i = 0, l = json.length; i < l; i++) {
            item = json[i];
            start_date = item.start_date;
            end_date = item.end_date;

            if (object) {
                flights.push({
                    "start": new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                    "end": new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                    "content": item.content,
                    "group": item.group,
                    "className": item.className
                });
            }
            else {
                flights.push([
                    new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                    new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                    item.content,
                    item.group,
                    item.className
                ]);
            }
        }
    }
    return flights;
}

/**
 * Get selected flight ID and type
 * @returns {*}
 */
function getSelectedEvent(flight) {
    var type, id;
    flight = flight || $(".timeline-event-selected > div.timeline-event-content > div");
    if (flight.length) {
        id = flight.attr("id");
        if (id.indexOf("flight-") === -1) {
            type = T_MAINTENANCE;
            id = id.replace("maintenance-", "");
        } else {
            type = T_FLIGHT;
            id = id.replace("flight-", "");
        }
        return {
            "type": type,
            "id": id
        }
    }
    return false;
}

function getPlanePosition() {
    var screenWidth = $(document).width(),
        position = (-1) * (screenWidth) * 13 / 1200;
    return screenWidth < 1000 ? 0 : position;
}

function getPlaneWidth() {
    var screenWidth = $(document).width(),
        proportionateWidth = Math.round(screenWidth * 100 / 1300);
    return proportionateWidth > 100 ? 100 : proportionateWidth;
}

function getFlightPosition(flight) {
    var progressbar_container = $(document).find("#progressbar_container"),
        progressbar_line = $(document).find("#progressbar_line"),
        //progressbar_plane = $(document).find("#progressbar_plane"),
        LINE_WIDTH = progressbar_container.width(),
        //PLANE_WIDTH = progressbar_plane.width(),
        PLANE_AND_LINE_OFFSET = 0,
        result = 0;

    if (flight.std && flight.sta && flight.atd) {
        var flightStartTime = moment(flight.atd),
            flightEndTime = moment(flight.sta),
            now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
            currentTime = moment(now);

        if (flight.ata){
            flightEndTime = moment(flight.ata);
        }
        else if (flight.eta){
            flightEndTime = moment(flight.eta);
        }

        /*if (currentTime.isAfter(flightEndTime)) {
            result = PLANE_WIDTH + (2 * PLANE_AND_LINE_OFFSET) + LINE_WIDTH;
        } else if (currentTime.isBefore(flightStartTime)) {
            result = 0;
        } else {
            var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                flownRoute = currentTime.diff(flightStartTime, "seconds");

            result = PLANE_WIDTH + PLANE_AND_LINE_OFFSET + (LINE_WIDTH * flownRoute / totalFlightTimeInSeconds);
        }*/
    }

    //progressbar_plane.attr("style", progressbar_plane.attr("style") + ";left:" + result + "px;");

    return result;
}

function getFlightProgressBarFlownPercentage(flight) {
    var OFFSET = 1;
    if (flight.atd) {

        var flightStartTime = moment(flight.atd),
            flightEndTime = getFlightArrivalDate(flight, true),
            now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
            currentTime = moment(now);

        if (currentTime.isAfter(flightEndTime)) {
            return 100;
        } else if (currentTime.isBefore(flightStartTime)) {
            return 0;
        } else {
            var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                flownRoute = currentTime.diff(flightStartTime, "seconds");
            return OFFSET + 100 * (flownRoute / totalFlightTimeInSeconds);
        }
    }
    return 0;
}

/**
 * Get Flight Crew
 * @param type
 * @param data
 * @param crew_type
 * @returns {*}
 */
function getFlightCrewItems(type, data, crew_type) {
    if (typeof data.flightCrew === "undefined" || data.flightCrew == false) {
        return "";
    }
    var flightCrew = data.flightCrew, crew = [];
    switch (type) {
        case FLIGHT_CREW_CAPTAINS:
            if (typeof flightCrew.captains !== "undefined") {
                if (crew_type == CREW_TYPE_DHC) {
                    crew = flightCrew.captains.dhc;
                } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                    crew = flightCrew.captains.general;
                } else if (crew_type == CREW_TYPE_STANDBY) {
                    crew = flightCrew.captains.standby;
                }
            }
            break;
        case FLIGHT_CREW_FIRST_OFFICERS:
            if (typeof flightCrew.firstOfficers !== "undefined") {
                if (crew_type == CREW_TYPE_DHC) {
                    crew = flightCrew.firstOfficers.dhc;
                } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                    crew = flightCrew.firstOfficers.general;
                } else if (crew_type == CREW_TYPE_STANDBY) {
                    crew = flightCrew.firstOfficers.standby;
                }
            }
            break;
        case FLIGHT_CREW_FLIGHT_ATTENDANTS:
            if (typeof flightCrew.flightAttendants !== "undefined") {
                if (crew_type == CREW_TYPE_DHC) {
                    crew = flightCrew.flightAttendants.dhc;
                } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                    crew = flightCrew.flightAttendants.general;
                } else if (crew_type == CREW_TYPE_STANDBY) {
                    crew = flightCrew.flightAttendants.standby;
                } else if (crew_type == CREW_TYPE_SUP) {
                    crew = flightCrew.flightAttendants.sup;
                }

            }
            break;
        default:
            break;
    }
    if (crew.length) {
        var result = [];
        var url = crew_type == CREW_TYPE_SUP ? "staff/" : "crew/profile?id=";
        for (var i = 0, l = crew.length; i < l; i++) {
            if (crew[i] && $.isPlainObject(crew[i])) {
                result.push("<a target='_blank' href='" + baseHomeUrl + "#" + url + crew[i].id + "' id='user-" + crew[i].id +
                    "' class='crew-item-person'>" + crew[i].last_name + " " + crew[i].first_name + "</a>");
            }
        }
        return result;
    }
    return "";
}

/**
 * Implode array to string with delimiter
 * @param arr
 * @param delimiter
 * @returns {string|*}
 */
function implode(arr, delimiter) {
    return (arr instanceof Array) ? arr.join(delimiter) : arr;
}

function implodeWithCheck(arr, delimiter) {
    if (arr instanceof Array) {
        var newString = '';
        $.each(arr, function (i, item) {
            var each = $(item);
            if (each.val() != 'undefined undefined') {
                newString += item + delimiter;
            }
        });

        return newString;
    }
    return arr;
}

function getFlightDepDate(flight, departure, type, format){
    if (!departure || departure == EMPTY_DATETIME){
        if (flight.etd && flight.etd != EMPTY_DATETIME) {
            departure = moment(flight.etd);
        }
        else {
            if (flight.ptd && flight.ptd != EMPTY_DATETIME) {
                departure = moment(flight.ptd);
            }
            else if (flight.std && flight.std != EMPTY_DATETIME) {
                departure = moment(flight.std);
            }
        }

        if (type == ABN){
            departure = moment(departure).add(10, 'm');
        }
    }

    if (format !== "undefined"){
        return moment(departure).format(format);
    }

    return moment(departure);
}

function getFlightArrDate(flight, arrival, type, format){
    if (!arrival || arrival == EMPTY_DATETIME){
        if (flight.eta && flight.eta != EMPTY_DATETIME) {
            arrival = moment(flight.eta);
        }
        else {
            if (flight.pta && flight.pta != EMPTY_DATETIME) {
                arrival = moment(flight.pta);
            }
            else if (flight.sta && flight.sta != EMPTY_DATETIME) {
                arrival = moment(flight.sta);
            }
        }

        if (type == TDN){
            arrival = moment(arrival).subtract(10, 'm');
        }
    }

    if (format !== "undefined"){
        return moment(arrival).format(format);
    }

    return moment(arrival);
}

/**
 * Fill MVT messages
 * @param data
 */
function fillMVTMessages(data) {
    var arrival_message_mvt = $("#arrival_message_mvt"), arrival_message_subject = $('#arrival_message_subject'),
        departure_message_mvt = $("#departure_message_mvt"), departure_message_subject = $('#departure_message_subject'),
        send_departure_message_btn = $("#send-departure-message-btn"), diverted_flight = $("#diverted_flight"),
        send_arrival_message_btn = $("#send-arrival-message-btn"),
        flight = data.flight, i, l, j,
        flightNumber = flight.flight_number,
        departureAirport = flight.departure_airport ? flight.departure_airport : flightNumber.departure_airport,
        arrivalAirport =  flight.arrival_airport ? flight.arrival_airport : flightNumber.arrival_airport,
        aircraft = flight.aircraft,
        user = data.user,
        _departure_airport,
        _arrival_airport,

        // DEP FIELDS
        dep_message_layout = $("#dep_message_layout"),
        arr_message_layout = $("#arr_message_layout"),
        // dep_message_copy = $("#dep_message_copy"),
        // arr_message_copy = $("#arr_message_copy"),
        mvt_type = $("#mvt_type"), mvt_flt_no = $("#mvt_flt_no"), mvt_dep_date = $("#mvt_dep_date"), mvt_ac = $("#mvt_ac"), mvt_dep_ap = $("#mvt_dep_ap"),
        mvt_etd = $("#mvt_etd"),
        mvt_atd = $("#mvt_atd"), mvt_abn = $("#mvt_abn"), mvt_eta = $("#mvt_eta"), mvt_arr_ap = $("#mvt_arr_ap"),
        mvt_dl_code = [], mvt_dl_time = [],

        mvt_pax_total = $("#mvt_pax_total"), mvt_pax_a = $("#mvt_pax_a"), mvt_pax_c = $("#mvt_pax_c"), mvt_pax_w = $("#mvt_pax_w"),
        mvt_pax_y = $("#mvt_pax_y"), mvt_pax_inf = $("#mvt_pax_inf"),
        mvt_fob = $("#mvt_fob"), mvt_tof = $("#mvt_tof"), mvt_eet = $("#mvt_eet"),
        mvt_baggage = $("#mvt_baggage"), mvt_cargo = $("#mvt_cargo"), mvt_mail = $("#mvt_mail"), mvt_eic = $("#mvt_eic"),
        mvt_pic = $("#mvt_pic"), mvt_si = $("#mvt_si"),

        // ARR FIELDS
        arr_mvt_flt_no = $("#arr_mvt_flt_no"), arr_mvt_dep_date = $("#arr_mvt_dep_date"), arr_mvt_ac = $("#arr_mvt_ac"),
        arr_mvt_ap = $("#arr_mvt_ap"), arr_mvt_tdn = $("#arr_mvt_tdn"), arr_mvt_ata = $("#arr_mvt_ata"),
        arr_mvt_si = $("#arr_mvt_si"), arr_mvt_rf = $("#arr_mvt_rf"),
        arr_mvt_pic = $("#arr_mvt_pic");

    // Clear MVT Boxes Before Loading
    clearMVTForm();

    mvt_dl_code.push($("#mvt_dl1_code"));
    mvt_dl_code.push($("#mvt_dl2_code"));
    mvt_dl_code.push($("#mvt_dl3_code"));

    mvt_dl_time.push($("#mvt_dl1_time"));
    mvt_dl_time.push($("#mvt_dl2_time"));
    mvt_dl_time.push($("#mvt_dl3_time"));

    var fltNo = flightNumber.airline.iata + flightNumber.flight_number,
        pax_a = parseInt(flight.pax_a_actual),
        pax_c = parseInt(flight.pax_c_actual),
        pax_w = parseInt(flight.pax_w_actual),
        pax_y = parseInt(flight.pax_y_actual),
        // std = moment(flight.std),
        // sta = moment(flight.sta),
        // atd = moment(flight.atd),
        // abn = moment(flight.abn),
        // eta = moment(flight.eta),
        // ata = moment(flight.ata),
        depAP = departureAirport ? departureAirport.iata : "",
        arrAP = arrivalAirport ? arrivalAirport.iata : "",
        ac = aircraft ? aircraft.mvt_name   : "",
        readyDEP = "", readyARR = "";

    var initDate = moment(getFlightDepartureInitialDate(flight)).format("DD");

    // DEP FIELDS

    mvt_flt_no.text(fltNo);

    mvt_dep_date.text(initDate);
    mvt_ac.val(ac);
    mvt_dep_ap.text(depAP);

    // HIDE AUTOFILL

    var etd = getFlightDepDate(flight, flight.etd, ETD, "HHmm"),
        atd = getFlightDepDate(flight, flight.atd, ATD, "HHmm"),
        abn = getFlightDepDate(flight, flight.abn, ABN, "HHmm"),
        eta = getFlightArrDate(flight, flight.eta, ETA, "HHmm");

    mvt_etd.attr("placeholder", "Ex. " + etd);
    mvt_atd.attr("placeholder", "Ex. " + atd);
    mvt_abn.attr("placeholder", "Ex. " + abn);
    mvt_eta.attr("placeholder", "Ex. " + eta);

    //mvt_eta.val(getFlightArrDate(flight, flight.eta, ETA, "DDHHmm"));

    mvt_arr_ap.text(arrAP);



    // DIVERSION
    if (flight.is_diversion && flight.arrival_airport_id && flight.diverted_airport_id){
        mvt_type.text("DIV");
        mvt_type.addClass("color-red");
    }


    // DELAYS
    var time, dCodes = [], dTimes = [];
    if (flight.delays && flight.delays.length){
        $.each(flight.delays, function(i, each){
            time = moment(each.duration, "HH:mm:ss").format("HHmm");

            mvt_dl_code[i].val(each.delay.code);
            mvt_dl_time[i].val(time);

            dCodes.push(each.delay.code);
            dTimes.push(time);
        });
    }

    if (ac && depAP) {
        var depText = "MVT\n"
            + fltNo + "/" + initDate + "." + ac + "." + depAP + "\n";

        if (atd) {
            depText += "AD" + atd;
            if (abn) {
                depText += "/" + abn;
            }
            if (eta) {
                depText += " EA" + eta;
            }
        } else if (etd) {
            depText += "ED" + etd;
        }

        depText += " " + arrAP + "\n";

        if (dCodes.length) {
            depText += "DL" + dCodes.join('/');
            if (dTimes.length) {
                depText += "/" + dTimes.join('/');
            }
        }
        // for copying
        dep_message_layout.val(depText);
    }


    mvt_pax_total.val(flight.pax_mvt_total);
    mvt_pax_inf.val(flight.pax_mvt_inf ? flight.pax_mvt_inf : (flight.pax_inf_actual ? flight.pax_inf_actual : ""));
    mvt_pax_a.val(flight.pax_a_actual ? flight.pax_a_actual : (flight.pax_a_booked ? flight.pax_a_booked : "" ));
    mvt_pax_c.val(flight.pax_c_actual ? flight.pax_c_actual : (flight.pax_c_booked ? flight.pax_c_booked : "" ));
    mvt_pax_w.val(flight.pax_w_actual ? flight.pax_w_actual : (flight.pax_w_booked ? flight.pax_w_booked : "" ));
    mvt_pax_y.val(flight.pax_y_actual ? flight.pax_y_actual : (flight.pax_y_booked ? flight.pax_y_booked : "" ));

    mvt_fob.val(getDepartureFuel(flight));

    mvt_tof.val(flight.tof);
    mvt_pic.val(flight.pic);

    mvt_baggage.val(flight.baggage);
    mvt_cargo.val(flight.cargo);
    mvt_mail.val(flight.mail);
    mvt_eic.val(flight.eic);

    if (flight.eet && flight.eet != EMPTY_TIME){
        mvt_eet.val(moment(flight.eet, "HH:mm:ss").format("HHmm"));
    }
    else {
        mvt_eet.val("");
    }
    //mvt_si.val("");



    // ARRIVAL
    arr_mvt_flt_no.text(fltNo);
    arr_mvt_dep_date.text(initDate);
    arr_mvt_ac.val(ac);
    arr_mvt_ap.text(arrAP);

    // HIDE AUTOFILL
    var tdn = getFlightArrDate(flight, flight.tdn, TDN, "HHmm"),
        ata = getFlightArrDate(flight, flight.ata, ATA, "HHmm");

    arr_mvt_tdn.attr("placeholder", "Ex. " + tdn);
    arr_mvt_ata.attr("placeholder", "Ex. " + ata);
    //arr_mvt_tdn.val(getFlightArrDate(flight, flight.tdn, TDN, "DDHHmm"));
    //arr_mvt_ata.val(getFlightArrDate(flight, flight.ata, ATA, "DDHHmm"));


    // Set Arrival Fuel
    arr_mvt_rf.val(getArrivalFuel(flight));
    arr_mvt_pic.val(flight.pic_arr ? flight.pic_arr : flight.pic);
    //arr_mvt_pic.val("");
    //arr_mvt_si.val("");

    if (ac && arrAP) {
        var arrText = "MVT\n"
            + fltNo + "/" + initDate + "." + ac + "." + arrAP + "\n";

        if (tdn || ata) {
            arrText += "AA";
            if (tdn) {
                arrText += tdn;
                if (ata) {
                    arrText += "/" + ata;
                }
            } else if (eta) {
                arrText += eta;
            }
        }

        arr_message_layout.val(arrText);
    }

    return;

    _departure_airport = flightNumber.departure_airport ? flightNumber.departure_airport.iata : "";
    _arrival_airport = flightNumber.arrival_airport ? flightNumber.arrival_airport.iata : "";

    // set Departure MVT message
    if (flight.atd && flight.abn && flight.eta && aircraft) {
        var departureMessageSubject, arrivalMessageSubject,

            departure_MVT_message,
            arrival_MVT_message;

        if (flight.is_diversion) {
            _departure_airport = departureAirport.abbr;
            _arrival_airport = arrivalAirport.abbr;
        }

        departure_MVT_message = "MVT\n" + flightNumber.airline.iata + flightNumber.flight_number + "/" + atd.format("DD") + "." +
            aircraft.mvt_name + "." + _departure_airport + "\nAD" + atd.format("DDHHmm") + "/" +
            abn.format("DDHHmm") + " EA" + eta.format("HHmm") + " " + _arrival_airport + "\n";
        // set Subject of The Message
        departureMessageSubject = 'MVT ' + flightNumber.airline.iata + flightNumber.flight_number + '/' + atd.format("DD") + ' ' +
            _departure_airport + '-' + _arrival_airport;
        departure_message_subject.val(departureMessageSubject);




        arrivalMessageSubject = 'MVT ' + flightNumber.airline.iata + flightNumber.flight_number + '/' + ata.format("DD") + ' ' +
            _departure_airport + '-' + _arrival_airport;
        arrival_message_subject.val(arrivalMessageSubject);

        // set delay part of message
        if (flight.delay_id && flight.delay) {
            var diff_hours = atd.diff(std, "hours").toString();
            var diff_minutes = atd.diff(std, "minutes").toString();

            if (diff_hours.length == 1) {
                diff_hours = "0" + diff_hours.toString();
            }
            if (parseInt(diff_minutes) > 60) {
                diff_minutes = parseInt(diff_minutes) % 60;
                diff_minutes = diff_minutes.toString();
            }
            if (diff_minutes.length == 1) {
                diff_minutes = "0" + diff_minutes;
            }
            departure_MVT_message += "DL" + flight.delay.code + "/" + diff_hours + diff_minutes + "\n";
            if (flight.delay.description) {
                departure_MVT_message += "SI " + flight.delay.description + "\n";
            }
        }

        // set PAX part of message
        if (isNumber(pax_c) && isNumber(pax_y)) {
            var total = parseInt(pax_c) + parseInt(pax_y);
            if (total > 0) {
                departure_MVT_message += "PX" + total + "\n";
            }
        }

        // set user name
        if (user) {
            departure_MVT_message += "OCC/" + user.last_name + " " + user.first_name;
        }
        departure_message_mvt.val(departure_MVT_message);

        // validate available hours
        var arrivalDate = moment(flight.abn),
            duration = moment.duration(moment().diff(arrivalDate)),
            hours = duration.asHours();
        if (hours > MAX_HOURS_FOR_MOVE) {
            send_departure_message_btn.attr("disabled", true);
            send_arrival_message_btn.attr("disabled", true);
        } else {
            send_departure_message_btn.attr("disabled", false);
            send_arrival_message_btn.attr("disabled", false);
        }
    }

    // set arrival MVT message
    if (flight.tdn && flight.ata && aircraft) {
        tdn = moment(flight.tdn);
        ata = moment(flight.ata);

        arrival_MVT_message = "MVT\n" + flightNumber.airline.iata + flightNumber.flight_number + "/" + ata.format("DD") + "." +
            aircraft.mvt_name + "." + _arrival_airport + "\nAA" + tdn.format("DDHHmm") + "/" +
            ata.format("DDHHmm") + "\n";

        // set user name
        if (user) {
            arrival_MVT_message += "OCC/" + user.first_name + " " + user.last_name;
        }
        arrival_message_mvt.val(arrival_MVT_message);
    }
}

function getArrivalFuel(flight){
    if (flight.rf){
        return flight.rf;
    }

    var in_tanks = flight.in_tanks  ? flight.in_tanks : 0,
        uplifted = flight.uplifted  ? flight.uplifted : 0,
        utilised = flight.utilised  ? flight.utilised : 0,
        departure_fuel = flight.fob ? flight.fob : (in_tanks + uplifted);

    return departure_fuel  - utilised;
}

function getDepartureFuel(flight){
    if (flight.fob){
        return flight.fob;
    }

    var in_tanks = flight.in_tanks  ? flight.in_tanks : 0,
        uplifted = flight.uplifted  ? flight.uplifted : 0;

    return in_tanks + uplifted;
}

var multiSelectOptionsSearch = {
    includeSelectAllOption: true,
    enableFiltering: true,
    enableCaseInsensitiveFiltering: true
};

function ApplyDateFormatToInputs(parentElement) {
    parentElement.find(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    parentElement.find(".datetimepicker-current").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1,
        // maxDate: new Date(moment.utc().format("YYYY-MM-DD HH:mm")),
        onChangeDateTime: function(date, $input) {
            var maxDate = moment.utc().format("YYYY-MM-DD HH:mm");
            if (moment(maxDate).isBefore(moment(date))) {
                alert("Time is in future!");
                $input.val("");
            }
        }
    });
}

$(document).on("change", ".assigned-staff", function(){
    var _this = $(this), assignedContainer = _this.parents(".assigned-container");
    console.log("Changed");
    console.log(assignedContainer);
    if (_this.val()){
        assignedContainer.find(".p-report-time").attr("required", "required");
        assignedContainer.find(".p-release-time").attr("required", "required");
    }
    else {
        assignedContainer.find(".p-report-time").removeAttr("required");
        assignedContainer.find(".p-release-time").removeAttr("required");
    }
});

$("#staff-container").on("click", ".add-staff", function(){
    var _this = $(this), assignedContainer = _this.parents(".assigned-container"),
        staffContainer = $("#staff-container"), newContainer, staff;

    newContainer = assignedContainer.clone();

    newContainer.find(".assigned-service").text("");

    // newContainer.find(".assigned-sla-type").val("");

    newContainer.find(".assigned-staff").val("");

    newContainer.find(".report-time").val("");

    newContainer.find(".release-time").val("");


    assignedContainer.find(".staff-operations").hide();

    assignedContainer.removeClass("gray-border-bottom");

    newContainer.insertAfter(assignedContainer);

    newContainer.find(".sla-info").hide();

    newContainer.addClass("gray-border-bottom");

    ApplyDateFormatToInputs(newContainer);

})
    .on("click", ".remove-staff", function(){
        var _this = $(this), assignedContainer = _this.parents(".assigned-container"),
            staffContainer = $("#staff-container"), assignedService;

        assignedService = assignedContainer.find(".assigned-service");

        if (assignedService.text() == ""){

            assignedContainer.prev().find(".staff-operations").show();

            assignedContainer.prev().addClass("gray-border-bottom");

            assignedContainer.remove();
        }
        else {

            // assignedContainer.find(".assigned-sla-type").val("");
            assignedContainer.find(".assigned-staff").val("");

            console.log("SLA REPORT TIME: " + assignedContainer.find(".sla-report-time").text())
            assignedContainer.find(".p-report-time").val(assignedContainer.find(".sla-report-time").text());
            assignedContainer.find(".p-report-time").removeAttr("required");

            assignedContainer.find(".p-release-time").val(assignedContainer.find(".sla-release-time").text());
            assignedContainer.find(".p-release-time").removeAttr("required");

            assignedContainer.find(".report-time").val("");
            assignedContainer.find(".release-time").val("");

            assignedContainer.find(".staff-operations").show();
        }
    })
    .on("click", ".copy-pln-report-time", function(){
        var _this = $(this), plnReportTime = _this.parent().find(".p-report-time"),
            container = _this.parents(".assigned-container");

        var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

        if (moment(utcDate).isBefore(moment(plnReportTime.val(), "YYYY-MM-DD HH:mm"))){
            alert("Time is in future!");
            return;
        }

        container.find(".report-time").val(plnReportTime.val());

    })
    .on("click", ".copy-pln-release-time", function(){
        var _this = $(this), plnReleaseTime = _this.parent().find(".p-release-time"),
            container = _this.parents(".assigned-container");

        var utcDate = moment().utc().format("YYYY-MM-DD HH:mm");

        if (moment(utcDate).isBefore(moment(plnReleaseTime.val(), "YYYY-MM-DD HH:mm"))){
            alert("Time is in future!");
            return;
        }

        container.find(".release-time").val(plnReleaseTime.val());

    });

function fillStaffForm(data){

    var staffContainer = $("#staff-container"),
        _form = staffContainer.parents('form'),
        flightsData = data.serviceData, newStaff,
        assignedFlights = _form.find(".flight-container"), num = assignedFlights.length,
        assignedContainer = _form.find(".assigned-container[data-initial=1]");

    num++;


    var flightContainer = $("<div class='col-md-12 flight-container border-bottom no-padding' data-num='" + num + "'></div>");

    // Delete
    staffContainer.children().remove();
    //_form.find(".assigned-container").not(".hidden").remove();

    var staffObjects = data.flight.staffList;

    var foundStaff = false;

    var obj;

    if (flightsData.services) {
        $.each(flightsData.services, function (key, airlineService) {
            var serviceType = airlineService.serviceType;

            if (airlineService.service_timings == 1) {
                if (airlineService.service[serviceType] != 1) {
                    return true;
                }
                obj = airlineService.service;
            }
            else {
                if (airlineService[serviceType] != 1) {
                    return true;
                }
                obj = airlineService;
            }

            foundStaff = false;
            if (staffObjects.hasOwnProperty(airlineService.service.abbr) && staffObjects[airlineService.service.abbr].length > 0) {
                $.each(staffObjects[airlineService.service.abbr], function (j, staffDetail) {
                    if (airlineService.service_id == staffDetail.service_id) {
                        flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, !foundStaff, staffDetail);
                        foundStaff = true;
                    }
                });
            }

            if (!foundStaff) {
                flightContainer = createStaffContainer(airlineService, obj, data.flight, serviceType, assignedContainer, flightContainer, true);
            }

            flightContainer.find(".staff-operations").last().show();
            flightContainer.find(".assigned-container").last().addClass("gray-border-bottom");

            staffContainer.append(flightContainer);

        });

        ApplyDateFormatToInputs(staffContainer);
    }
}

function createStaffContainer(airlineService, obj, flight, serviceType, assignedContainer, flightContainer, showLabel, selectedStaff){
    var slaInfo, slaStaffReq, slaType, newStaff, pReportTime, pReleaseTime, reportTime, releaseTime, newContainer, newService;

    newContainer = assignedContainer.clone();
    newContainer.removeAttr("data-initial");
    slaInfo = newContainer.find(".sla-info");

    slaType = newContainer.find(".assigned-sla-type");
    slaType.attr("name", "t_" + airlineService.service_id);

    if (showLabel && showLabel !== "undefined"){
        var req, min, report, release, pReport, pRelease, pDuration, flightDepArr;

        switch (serviceType) {
            case ARRIVAL_SERVICE:
                req = "arr_staff_req";
                report = "arr_report_time";
                release = "arr_release_time";
                flightDepArr = getSLAFlightArrival(flight);
                pReport = moment(flightDepArr).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).add(obj[release], 'm');

                newContainer.find(".assigned-service").addClass("label-success").text(airlineService.service.abbr);
                newContainer.find(".assigned-service-type").addClass("label-success").text("ARRIVAL");
                newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                // Service Type sent to form
                slaType.val("a");
                break;

            case DEPARTURE_SERVICE:
                req = "dep_staff_req";
                report = "dep_report_time";
                release = "dep_release_time";
                flightDepArr = getSLAFlightDeparture(flight);
                pReport = moment(flightDepArr).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                newContainer.find(".assigned-service").addClass("label-primary").text(airlineService.service.abbr);
                newContainer.find(".assigned-service-type").addClass("label-primary").text("DEPARTURE");
                newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                // Service Type sent to form
                slaType.val("d");
                break;

            case TURNAROUND_SERVICE:
                req = "turn_staff_req";
                report = "turn_report_time";
                release = "turn_release_time";

                var flightDepArrParent = getSLAFlightArrival(flight.flight_parent);
                flightDepArr = getSLAFlightDeparture(flight);

                pReport = moment(flightDepArrParent).subtract(obj[report], 'm');
                pRelease = moment(flightDepArr).subtract(obj[release], 'm');

                newContainer.find(".assigned-service").addClass("label-warning").text(airlineService.service.abbr);
                newContainer.find(".assigned-service-type").addClass("label-warning").text("TURNAROUND");
                newContainer.find(".sla-staff-required").text("Required: " + obj[req]);

                // Service Type sent to form
                slaType.val("t");
                break;
        }

        pDuration = getDuration(pReport, pRelease);

        newContainer.find(".sla-report-time").text(pReport.format("YYYY-MM-DD HH:mm"));
        newContainer.find(".sla-release-time").text(pRelease.format("YYYY-MM-DD HH:mm"));
    }
    else{
        slaInfo.hide();
    }

    newStaff = newContainer.find(".assigned-staff");
    newStaff.attr("name", "s_" + airlineService.service_id + "[]");
    newStaff.append($("<option value=''>-Select Staff-</option>"));
    $.each(airlineService.eligibleStaff, function(j, staff){
        newStaff.append($("<option value='" + staff.user_id + "'>" + staff.iata + " - " + staff.first_name + " " + staff.last_name + "</option>"));
    });

    //newStaff.multiselect(multiSelectOptionsSearch);


    pReportTime = newContainer.find(".p-report-time");
    pReportTime.attr("name", "pr_" + airlineService.service_id + "[]");
    pReportTime.attr("required", "required");

    pReleaseTime = newContainer.find(".p-release-time");
    pReleaseTime.attr("name", "pf_" + airlineService.service_id + "[]");
    pReleaseTime.attr("required", "required");

    reportTime = newContainer.find(".report-time");
    reportTime.attr("name", "r_" + airlineService.service_id + "[]");

    releaseTime = newContainer.find(".release-time");
    releaseTime.attr("name", "f_" + airlineService.service_id + "[]");

    if (selectedStaff && selectedStaff !== "undefined"){
        newStaff.val(selectedStaff.user_id);
        // PLANNED
        if (selectedStaff.planned_report_time && selectedStaff.planned_report_time != EMPTY_DATETIME)
        {
            pReportTime.val(correctDateFormat(selectedStaff.planned_report_time));
        }
        else if (pReport && pReport != EMPTY_DATETIME)
        {
            pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
        }

        if (selectedStaff.planned_release_time && selectedStaff.planned_release_time != EMPTY_DATETIME)
        {
            pReleaseTime.val(correctDateFormat(selectedStaff.planned_release_time));
        }
        else if (pRelease && pRelease != EMPTY_DATETIME)
        {
            pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
        }

        // ACTUALS
        reportTime.val(selectedStaff.report_time && selectedStaff.report_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.report_time) : "");
        releaseTime.val(selectedStaff.release_time && selectedStaff.release_time != EMPTY_DATETIME ? correctDateFormat(selectedStaff.release_time) : "");
    }
    else {
        if (pReport && pReport != EMPTY_DATETIME)
        {
            pReportTime.val(pReport.format("YYYY-MM-DD HH:mm"));
        }

        if (pRelease && pRelease != EMPTY_DATETIME)
        {
            pReleaseTime.val(pRelease.format("YYYY-MM-DD HH:mm"));
        }
    }


    newContainer.removeClass("hidden");
    flightContainer.append(newContainer);

    return flightContainer;
}

/**
 * Fill Flight Form with flight information
 * @param data
 */
function fillFlightForm(data) {
    var _form_flight_messages = $("#form_flight_messages"),
        _form = _form_flight_messages.parents('form'),
        _edit_flight_title = $("#edit_flight_title"),
        flight = data.flight, i, l, j,
        flightNumber = flight.flight_number, is_etd, is_atd,
        aircraft = flight.aircraft, titleTemplateHTML,
        delays = flight.delays,
        titleTemplate =
            _.template(CURRENT_IATA_CODE + "-<%= flightNumber %> \"<%= departureCityCode %>\" - \"<%= arrivalCityCode %>\"");

    titleTemplateHTML = titleTemplate({
        flightNumber: flightNumber.flight_number,
        departureCityCode: flightNumber.departure_airport,
        arrivalCityCode: flightNumber.arrival_airport
    });

    // clean form from old values
    clearFlightForm();

    _form_flight_messages.empty();
    _edit_flight_title.show();
    _edit_flight_title.find("legend").html("Edit: " + titleTemplateHTML);

    $("#flight_id").val(flight.id);
    $("#cancel_flight_id").val(flight.id);
    $("#remove_flight_id").val(flight.id);

    $("#remark").val(flight.remark);

    $("#airline_id").val(flightNumber.airline_id);

    OperationsFormFilter(flightNumber.airline_id + "");

    AircraftTypeChange(flightNumber.airline_id + "");

    AircraftChange(flightNumber.airline_id + "", flight);

    var std, sta;

    // Prev place of fn ID set

    if (flight.std != EMPTY_DATETIME && flight.std) {
        $("#std").val(std = correctDateFormat(flight.std));
    }

    if (flight.sta != EMPTY_DATETIME && flight.sta) {
        $("#sta").val(sta = correctDateFormat(flight.sta));
    }

    if (flight.ptd != EMPTY_DATETIME && flight.ptd) {
        $("#ptd").val(correctDateFormat(flight.ptd));
    }
    else if (std && std !== "undefined") {
        $("#ptd").val(correctDateFormat(std));
    }

    if (flight.pta != EMPTY_DATETIME && flight.pta) {
        $("#pta").val(correctDateFormat(flight.pta));
    }
    else if (sta && sta !== "undefined") {
        $("#pta").val(correctDateFormat(flight.sta));
    }

    if (flight.eta != EMPTY_DATETIME && flight.eta) {
        $("#eta").val(correctDateFormat(flight.eta));
    }
    if (flight.ata != EMPTY_DATETIME && flight.ata) {
        $("#ata").val(correctDateFormat(flight.ata));
    }
    if (flight.etd != EMPTY_DATETIME && flight.etd) {
        is_etd = true;
        $("#etd").val(correctDateFormat(flight.etd));
    }
    if (flight.atd != EMPTY_DATETIME && flight.atd) {
        is_atd = true;
        $("#atd").val(correctDateFormat(flight.atd));
    }
    if (flight.abn != EMPTY_DATETIME && flight.abn) {
        $("#abn").val(correctDateFormat(flight.abn));
    }
    if (flight.tdn != EMPTY_DATETIME && flight.tdn) {
        $("#tdn").val(correctDateFormat(flight.tdn));
    }
    $("#capacity_a").val(flight.capacity_a);
    $("#capacity_c").val(flight.capacity_c);
    $("#capacity_w").val(flight.capacity_w);
    $("#capacity_y").val(flight.capacity_y);

    $("#pax_a_booked").val(flight.pax_a_booked);
    $("#pax_c_booked").val(flight.pax_c_booked);
    $("#pax_w_booked").val(flight.pax_w_booked);
    $("#pax_y_booked").val(flight.pax_y_booked);
    $("#pax_inf_booked").val(flight.pax_inf_booked);
    $("#pax_a_actual").val(flight.pax_a_actual);
    $("#pax_c_actual").val(flight.pax_c_actual);
    $("#pax_w_actual").val(flight.pax_w_actual);
    $("#pax_y_actual").val(flight.pax_y_actual);
    $("#pax_inf_actual").val(flight.pax_inf_actual);
    $("#gate_parking").val(flight.gate_parking);
    $("#gate_boarding").val(flight.gate_boarding);
    $("#baggage").val(flight.baggage);
    $("#baggage_pcs").val(flight.baggage_pcs);
    $("#cargo_pcs").val(flight.cargo_pcs);
    $("#cargo").val(flight.cargo);
    $("#eic").val(flight.eic);
    $("#mail").val(flight.mail);
    $("#deportees").val(flight.deportees);
    $("#ckin_num").val(flight.ckin_num);

    // FUEL
    var in_tanks = flight.in_tanks  ? flight.in_tanks : 0,
        uplifted = flight.uplifted  ? flight.uplifted : 0,
        utilised = flight.utilised  ? flight.utilised : 0,
        departure_fuel = flight.fob ? flight.fob      : (in_tanks + uplifted),
        arrival_fuel = flight.rf    ? flight.rf       : (departure_fuel - utilised);

    if (!utilised){
        utilised = departure_fuel - arrival_fuel;
    }

    $("#in_tanks").val(in_tanks);
    $("#uplifted").val(uplifted);
    $("#departure_fuel").val(departure_fuel);
    $("#utilised").val(utilised);
    $("#arrival_fuel").val(arrival_fuel);
    $("#defuel").val(flight.defuel);
    // END FUEL Section


    // set diversions
    if (flight.is_diversion){

        $('#diverted_flight').val(1);

        if (flight.next_flight) {
            $("#is_diversion").prop("checked", "checked");
            $("#diversion_airport_block").show();
            $("#diversion_panel").show();
            $("#diversion_airport").val(flight.diverted_airport.iata);
            $("#diversion_airport").attr("required", "required");

            if (flight.next_flight.ptd && flight.next_flight.ptd != EMPTY_DATETIME) {
                $("#diversion_ptd").val(correctDateFormat(flight.next_flight.ptd));
            }
            if (flight.next_flight.etd && flight.next_flight.etd != EMPTY_DATETIME) {
                $("#diversion_etd").val(correctDateFormat(flight.next_flight.etd));
            }
            if (flight.next_flight.atd && flight.next_flight.atd != EMPTY_DATETIME) {
                $("#diversion_atd").val(correctDateFormat(flight.next_flight.atd));
            }
            if (flight.next_flight.abn && flight.next_flight.abn != EMPTY_DATETIME) {
                $("#diversion_abn").val(correctDateFormat(flight.next_flight.abn));
            }

            if (flight.next_flight.pta && flight.next_flight.pta != EMPTY_DATETIME) {
                $("#diversion_pta").val(correctDateFormat(flight.next_flight.pta));
            }
            if (flight.next_flight.eta && flight.next_flight.eta != EMPTY_DATETIME) {
                $("#diversion_eta").val(correctDateFormat(flight.next_flight.eta));
            }
            if (flight.next_flight.tdn && flight.next_flight.tdn != EMPTY_DATETIME) {
                $("#diversion_tdn").val(correctDateFormat(flight.next_flight.tdn));
            }
            if (flight.next_flight.ata && flight.next_flight.ata != EMPTY_DATETIME) {
                $("#diversion_ata").val(correctDateFormat(flight.next_flight.ata));
            }

        }
        /*$("#diversion_arrival").show();
         $("#diversion_departure").show();
         $("#diversion_sta").val(flight.diversion.diversion_sta);
         $("#diversion_eta").val(flight.diversion.diversion_eta);
         $("#diversion_ata").val(flight.diversion.diversion_ata);
         $("#diversion_std").val(flight.diversion.diversion_std);
         $("#diversion_etd").val(flight.diversion.diversion_etd);
         $("#diversion_atd").val(flight.diversion.diversion_atd);
         $("#diversion_abn").val(flight.diversion.diversion_abn);
         $("#diversion_tdn").val(flight.diversion.diversion_tdn);*/
    }

    setFlightFormCrew(flight);

    /*
    item_staff = $("#captain" + j);
    if (i > 0) {
        // add additional field
        if (!item_captain.length) {
            item = $("#flight_captains_crew").find("span.item:last");
            item_new = item.clone();
            item_new.attr("data-item-number", j);
            item_new.find("label").html("#" + j);
            item_new.find("select").attr("id", "captain" + j);
            item_new.insertAfter(item);
        }
    }
    item_staff = $("#captain" + j);
    if ($.isPlainObject(captains.general[i])) {
        item_staff.val(captains.general[i].id);

        // Show Report Time If Exists
        if (captains.general[i].settings.report_time && captains.general[i].settings.report_time !== 'undefined') {
            reportTime = moment(captains.general[i].settings.report_time).format('YYYY-MM-DD HH:mm');
        }
        else {
            reportTime = moment(flight.std).subtract({
                hours: 1,
                minutes: 15
            }).format('YYYY-MM-DD HH:mm');
        }
        item_staff.parents('span').find('input.reportTime').val(reportTime);

        // Show Reason If Exists
        if (captains.general[i].settings.reason && captains.general[i].settings.reason !== 'undefined') {
            reasonSpanParent = item_staff.parent().find('span.reason');
            reasonSpanParent.show();
            reasonSpanParent.find('select.crewReason').val(captains.general[i].settings.reason);
        }
    }
    */


    AddDateFormatElement($("input.reportTime"), "Y-m-d H:i", true, 5);
    reasonShowOnCrewChange();

    $("#flight_add_btn").hide();

    if (flight.deleted_at) {
        $("#flight_update_btn1").hide();
        $("#flight_update_btn2").hide();

        $("#remove_flight_div").hide();
        $("#flight_restore_btn").show();
        _form.find("input").not(":hidden, #flight_restore_btn, #cancel_btn1, #cancel_btn2").attr("disabled", "disabled");
        _form.find("select").attr("disabled", "disabled");
        _form.find("a").attr("disabled", "disabled");
        _form.find("button").attr("disabled", "disabled");
    }
    else if (flight.cancelled_at) {
        $("#flight_update_btn1").hide();
        $("#flight_update_btn2").hide();

        $("#cancel_flight_div").hide();
        $("#flight_restore_btn").show();
        _form.find("input").not(":hidden, #flight_restore_btn, #cancel_btn1, #cancel_btn2").attr("disabled", "disabled");
        _form.find("select").attr("disabled", "disabled");
        _form.find("a").attr("disabled", "disabled");
        _form.find("button").attr("disabled", "disabled");
    }
    else {
        $("#flight_restore_btn").hide();

        $("#flight_update_btn1").show();
        $("#flight_update_btn2").show();


        $("#cancel_flight_div").show();
        $("#remove_flight_div").show();

        _form.find("input").removeAttr("disabled");
        _form.find("select").removeAttr("disabled");
        _form.find("a").removeAttr("disabled");
        _form.find("button").removeAttr("disabled");
    }
    $("#cancel_btn1").show();
    $("#cancel_btn2").show();

    cancelReasonCheck();

    // fills delays fields
    if (delays) {
        $(".item-delay").not(":first").remove();
        $("#delay_total").val("");
        var first_delay = $(".item-delay:first"), duration;
        for (i = 0, l = delays.length; i < l; i++) {
            if (i == 0) {
                duration = moment(delays[i].duration, "HH:mm:ss");
                first_delay.find("select").val(delays[i].delay_id);
                first_delay.find("input").val(duration.format("HH:mm"));
            } else {
                addNewDelayAndFill(first_delay, delays[i]);
            }
        }
    }
    DelayFieldSet();


    // moved from Prev place
    $("#flight_number_id").val(flightNumber.id);

    if (aircraft){
        $("#aircraft_id").val(aircraft.id);

        $("#flt_ac").text(aircraft.name);
        if (aircraft.aircraft_type_id){
            $("#aircraft_type_id").val(aircraft.aircraft_type_id);
            // Type
            $("#flt_ac_type").text(aircraft.type.icao);
        }
    }
    else {
        $("#aircraft_type_id").val(flight.aircraft_type_id);

        $("#flt_ac_type").text(flight.aircraft_type.icao);
    }

    ///
    // Flight AC Config
    let fltConfig = getFlightConfig(flight);
    $("#cfg_a").val(fltConfig.a);
    $("#cfg_c").val(fltConfig.c);
    $("#cfg_w").val(fltConfig.w);
    $("#cfg_y").val(fltConfig.y);
    ///

    // Catering
    if (flight.catering){
        // Std
        $("#std_meals_a").val(flight.catering.std_meals_a);
        $("#std_meals_c").val(flight.catering.std_meals_c);
        $("#std_meals_w").val(flight.catering.std_meals_w);
        $("#std_meals_y").val(flight.catering.std_meals_y);

        // Spcl
        $("#spcl_meals_a").val(flight.catering.spcl_meals_a);
        $("#spcl_meals_c").val(flight.catering.spcl_meals_c);
        $("#spcl_meals_w").val(flight.catering.spcl_meals_w);
        $("#spcl_meals_y").val(flight.catering.spcl_meals_y);

        // Total
        $("#meals_a").val(flight.catering.meals_a);
        $("#meals_c").val(flight.catering.meals_c);
        $("#meals_w").val(flight.catering.meals_w);
        $("#meals_y").val(flight.catering.meals_y);
    }


    // Set 2-sector flights data
    var pax_actual_content = "", pax_bkd_content = "", payload_content = "";

    for(let n = 0; n < flight.station.length; n++){
        pax_actual_content += createActualPaxLayout(flight, flight.station[n]);
        pax_bkd_content += createBookedPaxLayout(flight, flight.station[n]);
        payload_content += createPayloadLayout(flight, flight.station[n]);
        // airport_oth.push(flight.station[n].airport);
        // pax_c_oth.push(flight.station[n].pax_c);
        // pax_y_oth.push(flight.station[n].pax_y);
        // pax_inf_oth.push(flight.station[n].pax_inf);
        // pax_ch_oth.push(flight.station[n].pax_ch);
        // pax_m_oth.push(flight.station[n].pax_m);
        // pax_f_oth.push(flight.station[n].pax_f);
        //
        // var bag     = flight.station[n].baggage     ? flight.station[n].baggage     : 0,
        //     bag_pcs = flight.station[n].baggage_pcs ? flight.station[n].baggage_pcs : 0,
        //     cargo   = flight.station[n].cargo       ? flight.station[n].cargo       : 0,
        //     cargo_pcs  = flight.station[n].cargo_pcs   ? flight.station[n].cargo_pcs       : 0,
        //     eic     = flight.station[n].eic         ? flight.station[n].eic         : 0,
        //     mail    = flight.station[n].mail        ? flight.station[n].mail        : 0,
        //     total   = bag + cargo + mail + eic;
    }

    $(".actual_pax_container > .title").after(pax_actual_content);
    $(".booked_pax_container > .title").after(pax_bkd_content);
    $(".payload_container > .title").after(payload_content);
}

function getFlightConfig(flight){
    if (flight.capacity_a || flight.capacity_c || flight.capacity_w || flight.capacity_y){
        return {
            "a" :  flight.capacity_a,
            "c" :  flight.capacity_c,
            "w" :  flight.capacity_w,
            "y" :  flight.capacity_y,
        };
    }
    if (flight.aircraft){
        return {
            "a" :  flight.aircraft.config_a,
            "c" :  flight.aircraft.config_c,
            "w" :  flight.aircraft.config_w,
            "y" :  flight.aircraft.config_y,
        };
    }
    if (flight.aircraft_type){
        return {
            "a" :  flight.aircraft_type.config_a,
            "c" :  flight.aircraft_type.config_c,
            "w" :  flight.aircraft_type.config_w,
            "y" :  flight.aircraft_type.config_y,
        };
    }

    return {
        "a" :  "",
        "c" :  "",
        "w" :  "",
        "y" :  "",
    };
}

function createActualPaxLayout(flight, flightStation){
    return '<div class="box margin-bottom-5 align-items-center stations-data">' +
        '<label class="control-label text-center width-70">' + flight.flight_number.departure_airport.iata + ' - ' + flightStation.airport + '</label>'+
        '<input type="hidden" name="station[]" value="' + flightStation.id +'" class="form-control width-50" id="">' +
        '<input type="hidden" name="station_airport[]" value="' + flightStation.airport_id +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_a[]" value="' + (flightStation.pax_a ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_c[]" value="' + (flightStation.pax_c ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_w[]" value="' + (flightStation.pax_w ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_y[]" value="' + (flightStation.pax_y ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_inf[]" value="' + (flightStation.pax_inf ?? "") +'" class="form-control width-50" id="">' +
        '</div>';
}

function createBookedPaxLayout(flight, flightStation){
    return '<div class="box margin-bottom-5 align-items-center stations-data">' +
        '<label class="control-label text-center width-70">' + flight.flight_number.departure_airport.iata + ' - ' + flightStation.airport + '</label>'+
        '<input type="text" name="station_pax_a_bkd[]" value="' + (flightStation.pax_a_bkd ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_c_bkd[]" value="' + (flightStation.pax_c_bkd ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_w_bkd[]" value="' + (flightStation.pax_w_bkd ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_y_bkd[]" value="' + (flightStation.pax_y_bkd ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_pax_inf_bkd[]" value="' + (flightStation.pax_inf_bkd ?? "") +'" class="form-control width-50" id="">' +
        '</div>';
}

function createPayloadLayout(flight, flightStation){
    return '<div class="box margin-bottom-5 align-items-center stations-data">' +
        '<label class="control-label text-center width-70">' + flight.flight_number.departure_airport.iata + ' - ' + flightStation.airport + '</label>'+
        '<input type="text" name="station_baggage_pcs[]" value="' + (flightStation.baggage_pcs ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_baggage[]" value="' + (flightStation.baggage ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_cargo[]" value="' + (flightStation.cargo ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_mail[]" value="' + (flightStation.mail ?? "") +'" class="form-control width-50" id="">' +
        '<input type="text" name="station_eic[]" value="' + (flightStation.eic ?? "") +'" class="form-control width-50" id="">' +
        '</div>';
}

function OperationsFormFilter(airlineIds){
    var flightNumber = $("#flight_number_id");

    flightNumber.children().remove();

    if (typeof airlineIds !== "undefined"){
        airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);
    }
    else {
        airlineIds = false;
    }

    if (!airlineIds || airlineIds.length == 0){
        $.each(flightNumbersObj, function (i, each) {
            flightNumber.append("<option value='" + each.id  + "'>" + each.sector + "</option>");
        });
    }
    else {
        $.each(flightNumbersObj, function (i, each) {
            if ($.inArray(each.airline_id + "", airlineIds) != -1) {
                flightNumber.append("<option value='" + each.id + "'>" + each.sector + "</option>");
            }
        });
    }
}

function AircraftTypeChange(airlineIds){
    var aircraftType = $("#aircraft_type_id");

    aircraftType.children().remove();

    airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);

    if ($airlineModule){
        $.each(acTypesByAirline, function (j, each) {
            // $.each(array, function (j, each) {
            aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
            // });
        });
    }
    else {
        if (!airlineIds || airlineIds.length == 0) {
            $.each(acTypesByAirline, function (i, array) {
                $.each(array, function (j, each) {
                    aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
                });
            });
        } else {
            $.each(airlineIds, function (i, airlineID) {
                if (airlineID in acTypesByAirline) {
                    $.each(acTypesByAirline[airlineID], function (j, each) {
                        aircraftType.append("<option value='" + each.id + "'>" + each.name + "</option>");
                    });
                }
            });
        }
    }
}

function AircraftChange(airlineIds, flight, typeID){
    var aircraftList = $("#aircraft_id");

    aircraftList.children().remove();

    airlineIds = $.isArray(airlineIds) ? airlineIds : (airlineIds ? [airlineIds] : false);

    if (typeof typeID === "undefined" || !typeID) {
        if (typeof flight !== "undefined" && flight) {
            if (flight.aircraft) {
                if (flight.aircraft.aircraft_type_id) {
                    typeID = flight.aircraft.aircraft_type_id;
                }
            }
            else if (flight.aircraft_type_id) {
                typeID = flight.aircraft_type_id
            }
        }
    }

    if (typeID){
        if (typeID in aircraftByType) {

            var aType = [];
            $.each(aircraftByType[typeID], function (id, name) {
                aType.push([id, name]);
            });

            aType.sort(function(a, b)
            {
                if (a[1] == b[1]) { return 0; }
                return a[1] > b[1] ? 1 : -1;
            });

            $.each(aType, function (i, eachType) {
                aircraftList.append("<option value='" + eachType[0] + "'>" + eachType[1] + "</option>");
            });

            /*
            $.each(aircraftByType[typeID], function (id, name) {
                aircraftList.append("<option value='" + id + "'>" + name + "</option>");
            });
            */
        }
    }
    else {
        if ($airlineModule) {
            $.each(aircraftByAirline, function (j, each) {
                // $.each(array, function (j, each) {
                aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                // });
            });
        }
        else {
            if (airlineIds === undefined || !airlineIds || (airlineIds && airlineIds.length == 0)) {
                $.each(aircraftByAirline, function (i, array) {
                    $.each(array, function (j, each) {
                        aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                    });
                });
            } else {
                $.each(airlineIds, function (i, airlineID) {
                    if (airlineID in aircraftByAirline) {
                        $.each(aircraftByAirline[airlineID], function (j, each) {
                            aircraftList.append("<option value='" + each.id + "'>" + each.name + "</option>");
                        });
                    }
                });
            }
        }
    }
}

$(document).on("change", "#airline_id", function () {
    OperationsFormFilter($(this).val());

    AircraftTypeChange($(this).val());

    AircraftChange($(this).val());
});

$(document).on("change", "#aircraft_type_id", function () {
    AircraftChange($("#airline_id").val(), false, $(this).val());
});

function updatedAircraftByTypeAndAirlineList(data){
    if (typeof data === "undefined" || !data){
        return;
    }

    // Update Flight Number object
    var flightNumbersObj = data.flightNumbersObj;
    OperationsFormFilter();
    // end

    // Update other list vars
    //aircraftByAirline = acTypesByAirline = aircraftByType = [];

    if ("acTypesByAirline" in data){
        $.each(data["acTypesByAirline"], function(airlineID, values){
            acTypesByAirline[airlineID] = values;
        })
    }

    if ("aircraftByAirline" in data){
        $.each(data["aircraftByAirline"], function(airlineID, values){
            aircraftByAirline[airlineID] = values;
        })
    }

    if ("aircraftByType" in data){
        // aircraftByType[typeID], function (id, name)
        $.each(data["aircraftByType"], function(typeID, values){
            $.each(values, function(id, name){
                if (typeof aircraftByType[typeID] === "undefined" || !aircraftByType[typeID]){
                    aircraftByType[typeID] = [];
                }
                aircraftByType[typeID][id] = name;
            })
        })
    }
}

function setFlightFormCrew(flight){
    if (typeof flight.flightCrew !== "undefined") {
        var captains = flight.flightCrew.captains,
            firstOfficers = flight.flightCrew.firstOfficers,
            flightAttendants = flight.flightCrew.flightAttendants,
            item, item_new, l, j, i, itemEach,
            reasonSpanParent, reportTime;

        var elements = [], ids = [], templates = [], objects = [];

        if (typeof captains === "object") {
            elements.push("#captain");
            elements.push("#captain_dhc");
            elements.push("#captain_standby");

            ids.push("captain");
            ids.push("captain_dhc");
            ids.push("captain_standby");

            templates.push("#flight_captains_crew");
            templates.push("#flight_captains_dhc_crew");
            templates.push("#flight_captain_standby_crew");

            objects.push(captains.general);
            objects.push(captains.dhc);
            objects.push(captains.standby);
        }

        if (typeof  firstOfficers === "object"){
            elements.push("#first_officer");
            elements.push("#first_officer_dhc");
            elements.push("#first_officer_standby");

            ids.push("first_officer");
            ids.push("first_officer_dhc");
            ids.push("first_officer_standby");

            templates.push("#flight_first_officers_crew");
            templates.push("#flight_first_officers_dhc_crew");
            templates.push("#flight_first_officers_standby_crew");

            objects.push(firstOfficers.general);
            objects.push(firstOfficers.dhc);
            objects.push(firstOfficers.standby);
        }

        if (typeof flightAttendants === "object"){
            elements.push("#cabin_crew");
            elements.push("#cabin_crew_dhc");
            elements.push("#cabin_crew_standby");
            elements.push("#cabin_crew_sup");

            ids.push("cabin_crew");
            ids.push("cabin_crew_dhc");
            ids.push("cabin_crew_standby");
            ids.push("cabin_crew_sup");

            templates.push("#flight_cabin_crew_crew");
            templates.push("#flight_cabin_crew_dhc_crew");
            templates.push("#flight_cabin_crew_standby_crew");
            templates.push("#flight_cabin_crew_sup_crew");

            objects.push(flightAttendants.general);
            objects.push(flightAttendants.dhc);
            objects.push(flightAttendants.standby);
            objects.push(flightAttendants.sup);
        }

        $.each(objects, function(n, eachObj){
            $.each(eachObj, function(i, obj){
                //for (i = 0; i < obj.length; i++){
                j = parseInt(i) + 1;
                itemEach = $(elements[n] + "" + j);
                if (i > 0) {
                    // add additional field
                    if (!itemEach.length) {
                        item = $(templates[n]).find("span.item:last");
                        item_new = item.clone();
                        item_new.attr("data-item-number", j);
                        item_new.find("label").html("#" + j);
                        item_new.find("select").attr("id", ids[n] + j);
                        item_new.insertAfter(item);
                    }
                }
                itemEach = $(elements[n] + "" + j);
                console.log("plain obj " + typeof obj)

                if ($.isPlainObject(obj)) {
                    itemEach.val(obj.id);

                    // Show Report Time If Exists
                    if (obj.settings.report_time && obj.settings.report_time !== 'undefined' && obj.settings.report_time != EMPTY_DATETIME) {
                        reportTime = moment(obj.settings.report_time).format('YYYY-MM-DD HH:mm');
                    }
                    else {
                        var depInitDate = getFlightDepartureInitialDate(flight);
                        reportTime = moment(depInitDate).subtract({
                            hours: 1,
                            minutes: 15
                        }).format('YYYY-MM-DD HH:mm');
                    }
                    itemEach.parents('span').find('input.reportTime').val(reportTime);

                    // Show Reason If Exists
                    if (obj.settings.reason && obj.settings.reason !== 'undefined') {
                        reasonSpanParent = itemEach.parent().find('span.reason');
                        reasonSpanParent.show();
                        reasonSpanParent.find('select.crewReason').val(obj.settings.reason);
                    }
                }
                //}
            });
        });
    }
}

$(document).on("change", "#cancel_reason", function () {
    cancelReasonCheck();
});

function cancelReasonCheck(){
    var _this = $("#cancel_reason"), flight_cancel_btn = $("#flight_cancel_btn");

    if (_this.val() == ""){
        flight_cancel_btn.attr("disabled", "disabled");
    }
    else {
        flight_cancel_btn.removeAttr("disabled");
    }
}

$(document).on("change", "#remove_reason", function () {
    removeReasonCheck();
});

function removeReasonCheck(){
    var _this = $("#remove_reason"), flight_remove_btn = $("#flight_remove_btn");

    if (_this.val() == ""){
        flight_remove_btn.attr("disabled", "disabled");
    }
    else {
        flight_remove_btn.removeAttr("disabled");
    }
}

function addNewDelayAndFill(first_delay, delay) {
    var next_delay = first_delay.clone(),
        duration = moment(delay.duration, "HH:mm:ss");

    next_delay.find("select").val(delay.delay_id);
    next_delay.find("input").val(duration.format("HH:mm"));
    first_delay.after(next_delay);
}

/**
 * Hide flight popup event handler
 * @return void
 */
$("#flight_info_modal, #flight_maintenance_info_modal").on("hidden.bs.modal", function (e) {
    //timeline.setSelection([]);
});

/**
 * Mouse enter on crew item person to load his image
 */
$(document).on({
    mouseenter: function () {
        var _this = $(this), user_id = _this.attr("id").replace("user-", ""),
            request;

        _this.attr("data-toggle", "popover")
            .attr("data-trigger", "focus")
            .attr("title", _this.text())
            .attr("data-content", "<div class='user-image center-block'>" +
                "<img src='" + baseUrl + "/assets/img/2.GIF' alt='User Image'/></div>");
        _this.popover({
            "html": true
        });
        _this.popover("show");
        $.ajaxSetup({
            url: baseUrl + "/user/ajaxgetuserimage",
            type: "GET",
            dataType: "json"
        });
        request = $.ajax({
            data: {
                user_id: user_id
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                $(".user-image").empty().append("<img src='" + data.image + "' alt='User Image' width='120' />");
            } else {

            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, $("#da"));
        });
        request.always(function () {
        });
    },
    mouseleave: function () {
        var _this = $(this);
        _this.attr("data-content", "");
        _this.popover("hide");
    }
}, ".crew-item-person");


function correctDateFormat(date, format) {
    if (format)
        return moment(date, inputDateFormat).format(format);
    else
        return moment(date, inputDateFormat).format("YYYY-MM-DD HH:mm");
}

/**
 * a and b are javascript Date objects
 * @param a
 * @param b
 * @returns {number}
 */
function dateDiffInDays(a, b) {
    // Discard the time and time-zone information.
    var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
    var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

    return Math.floor((utc2 - utc1) / _MS_PER_DAY);
}

/**
 * Mouse over|move|click variables
 * @type {number}
 */
var delay = 1000, setTimeoutConst, flightHover = null;
var clicking = false, clickingAndMove = false, doubleClicking = false;

/* $(document).mousedown(function() {
 clicking = true;
 });
 $(document).mouseup(function() {
 clicking = false;
 });
 $(document).mousemove(function() {
 doubleClicking = false;
 clickingAndMove = !(clicking == false);
 });

 $(document).dblclick(function(){
 doubleClicking = true;
 clicking = false;
 });*/

$(document).on("click touchstart", ".timeline-event", function () {
    var _this = $(this), flightHover = _this.find(".timeline-event-content>div");
    //flight_info_modal = $('#flight_info_modal');

    /* if (clickingAndMove === true || doubleClicking === true ){ // || clicking === true || _this.hasClass("timeline-event-selected") == true ||
     flightHover = false;
     return false;
     }*/
//            setTimeoutConst = setTimeout(function () {
    /* if (_this.hasClass("timeline-event-selected") == true || clickingAndMove === true || clicking === true) {
     flightHover = false;
     return false;
     }*/

    var $body = $("body"), requestData,
        flightData = getSelectedEvent(flightHover), request;
    if (!flightData) {
        return false;
    }

    resetLineSelection();

    if (flightData.type == T_MAINTENANCE) {
        requestData = {
            type: "GET",
            dataType: "json",
            url: baseUrl + "/aircraft/ajax-get-maintenance",
            data: {
                maintenance_id: flightData.id
            }
        };
    }
    else if (flightData.type == T_FLIGHT) {
        requestData = {
            type: "GET",
            dataType: "json",
            url: baseUrl + "/flight-watch/ajax-get-flight/" + flightData.id,
            data: {
                // flight_id: flightData.id
            }
        };
    }
    request = $.ajax(requestData);
    request.done(function (data) {

        activateTab("flight_watch_main_tab", "flightInformationTab");
        activateTab("flight_by_type_tab", "tabDetails");

        if (typeof data.success !== "undefined") {
            if (flightData.type == T_FLIGHT) {
                //clearFlightForm();

                var topOffset, leftOffset,
                    modal_height = $airlineModule ? 630 : 440, // flight_info_modal.outerHeight() > 500 ? 630 : 450, // flight_info_modal.outerHeight(),
                    modal_width  = 980; //flight_info_modal.outerWidth()  > 500 ? 650 : flight_info_modal.outerWidth();

                topOffset  = Math.max(0, (($(window).height() - modal_height) / 2) + $(window).scrollTop());
                leftOffset = Math.max(0, (($(window).width() - modal_width) / 2) + $(window).scrollLeft());

                popupFlight = flight_info_modal.bPopup({
                    //modalClose: false,
                    //opacity: 1,
                    //positionStyle: 'fixed', //'fixed' or 'absolute'
                    //fadeSpeed: 'fast', //can be a string ('slow'/'fast') or int
                    //followSpeed: "fast", //can be a string ('slow'/'fast') or int
                    closeClass: 'close-btn',
                    modal: true,
                    follow: [false, false], //x, y
                    position: [leftOffset, topOffset],
                    /*
                    onOpen: function() {
                        $('#accordion').on('shown.bs.collapse', function () {

                            setTimeout(function() {
                                var crew_panel = $("#crew_information_panel"),
                                    fuel_panel = $("#fuel_information_panel"),
                                    crew_panel_height = crew_panel.height(),
                                    fuel_panel_height = fuel_panel.height();
                                if (crew_panel_height > fuel_panel_height) {
                                    fuel_panel.height(crew_panel_height);
                                } else {
                                    crew_panel.height(fuel_panel_height);
                                }
                            }, 1);
                        });
                    }
                    */
                });

                $("#flight_info_modal ul.nav a:first").tab("show");

                console.log("FIND FN:");
                console.log(flightNumbersObj.find(a => a.id === data.flight_number.id));
                if (!flightNumbersObj.find(a => a.id === data.flight_number.id))
                {
                    flightNumbersObj.push(data.flight_number);
                    console.log("PUSHED");
                }

                parseFlight(data);

                flight_info_modal.attr('data-flight_id', flightData.id);
                flight_info_modal.attr('data-flight_number_id', data.flight.flight_number_id);
                flight_info_modal.attr('data-std', data.flight.std);

                //var generalTab = $(document).find("#progressbar_container");
                //getFlightPosition(data.flight)

                fillFlightForm(data);
                fillStaffForm(data);
                fillMVTMessages(data);

                // Disable STD/STA for Airline Module
                if ($airlineModule){
                    DisableStdSta(data.flight.created_by_email);
                }
            }
            else if (flightData.type == T_MAINTENANCE) {
                parseMaintenance(data);
                popupFlight = $("#flight_maintenance_info_modal").bPopup({
                    closeClass: 'close-btn',
                    modal: true
                });

                $("#flight_maintenance_info_modal a:first").tab("show");
                $("#flight_maintenance_info_modal").attr("data-maintenance_id", flightData.id);
            }

        } else {
            showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
        }
    });
    request.fail(function (jqXHR, textStatus) {
        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
    });
    request.always(function () {
        $body.removeClass("loading");
    });
    //}, delay);
});

$(document).on("mouseleave", ".timeline-event", function () {
    clearTimeout(setTimeoutConst);
    flightHover = null;
});

/**
 * On flight item hover mouse event handlers
 * @return void
 */
/*$(document).on({
    dblclick: function () {
       var _this = $(this),
           flightHover = _this.find(".timeline-event-content>div");

      /!* if (clickingAndMove === true || doubleClicking === true ){ // || clicking === true || _this.hasClass("timeline-event-selected") == true ||
           flightHover = false;
           return false;
       }*!/
//            setTimeoutConst = setTimeout(function () {
          /!* if (_this.hasClass("timeline-event-selected") == true || clickingAndMove === true || clicking === true) {
               flightHover = false;
               return false;
           }*!/

           var $body = $("body"), requestData,
               flightData = getSelectedEvent(flightHover), request;
           if (!flightData) {
               return false;
           }

           if (flightData.type == T_MAINTENANCE) {
               requestData = {
                   type: "GET",
                   dataType: "json",
                   url: baseUrl + "/aircraft/ajax-get-maintenance",
                   data: {
                       maintenance_id: flightData.id
                   }
               };
           } else if (flightData.type == T_FLIGHT) {
               requestData = {
                   type: "GET",
                   dataType: "json",
                   url: baseUrl + "/flight-watch/ajax-get-flight",
                   data: {
                       flight_id: flightData.id
                   }
               };
           }
           request = $.ajax(requestData);
           request.done(function (data) {

               if (typeof data.success !== "undefined") {
                   if (flightData.type == T_FLIGHT) {
                       parseFlight(data);
                       //clearFlightForm();
                       popupFlight = flight_info_modal.bPopup({
                           closeClass: 'close-btn',
                           modal: true,
                           follow: [false, false], //x, y
                           onOpen: function() {
                               $('#accordion').on('shown.bs.collapse', function () {
                                   setTimeout(function() {
                                       var crew_panel = $("#crew_information_panel"),
                                           fuel_panel = $("#fuel_information_panel"),
                                           crew_panel_height = crew_panel.height(),
                                           fuel_panel_height = fuel_panel.height();
                                       if (crew_panel_height > fuel_panel_height) {
                                           fuel_panel.height(crew_panel_height);
                                       } else {
                                           crew_panel.height(fuel_panel_height);
                                       }
                                   }, 1);
                               });
                           }
                       });
                       $("#flight_info_modal ul.nav a:first").tab("show");

                       flight_info_modal.attr('data-flight_id', flightData.id);
                       flight_info_modal.attr('data-flight_number_id', data.flight.flight_number_id);
                       flight_info_modal.attr('data-std', data.flight.std);

                       var generalTab = $(document).find("#progressbar_container");
                       getFlightPosition(data.flight)

                   } else if (flightData.type == T_MAINTENANCE) {
                       parseMaintenance(data);
                       popupFlight = $("#flight_maintenance_info_modal").bPopup({
                           closeClass: 'close-btn',
                           modal: true
                       });
                       $("#flight_maintenance_info_modal a:first").tab("show");
                       $("#flight_maintenance_info_modal").attr("data-maintenance_id", flightData.id);
                   }

               } else {
                   showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
               }
           });
           request.fail(function (jqXHR, textStatus) {
               showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
           });
           request.always(function () {
               $body.removeClass("loading");
           });
       //}, delay);
    },
    mouseleave: function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;
    }
}, ".timeline-event");*/

/**
 * On document ready
 */
$(function () {
    $("#go_to_date").datetimepicker({
        format: "Y-m-d",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
    });

    /**
     * Reset button clikc event handler
     * @return void
     */
    $("#btn-clear-go-to-date").on("click", function () {
        if ($("#go_to_date").val()) {
            $(this).attr("disabled", true);
            $("#btn-go-to-date").attr("disabled", true);
            $("#go_to_date").val("");
            $("#go_to_date_form").submit();
            //return true;
        }
        //return false
    });

    /*var touchtime = 0;
    $(document).on("mouseleave", ".timeline-event", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;
        touchtime = 0;
    });

    $(document).on("click", ".timeline-event", function () {
        if(touchtime == 0) {
            touchtime = new Date().getTime();
        }
        else {
            //compare first click to this click and see if they occurred within double click threshold
            if(((new Date().getTime())- touchtime) < 800) {
                //double click occurred
                flightDoubleClick();
                touchtime = 0;
            } else {
                //not a double click so set as a new first click
                touchtime = new Date().getTime();
            }
        }
    });*/
});
