/**
 * Created by Dilovar Tursunov on 11.11.2014.
 */

$(function () {

    var notification_block = $("#notification-block");

    /**
     * Edit button click handler
     * @return void
     */
    $(document).on("click", ".edit-button", function () {
        var _this = $(this), request, module_id = _this.attr("data-module-id"), department_id = _this.attr("data-department-id"),
            td = _this.parent();
        _this.hide();
        var department_select = $("<select name='department_id' class='form-control input-sm' style='width: 150px; display: inline-block; top: 1px; position: relative; margin:0 5px'>");
        if (typeof departments !== "undefined") {
            for (var i in departments) {
                if (departments.hasOwnProperty(i)) {
                    department_select.append("<option value='" + i + "'>" + departments[i] + "</option>");
                }
            }
            var from_group = $("<div style='display: inline-block'></div>");
            from_group.append("<label>Department</label>");
            from_group.append(department_select);
            from_group.append("<button data-department-id='" + department_id + "' data-module-id='" + module_id + "' type='button' class='btn btn-sm save-button btn-primary'>Save</button>");
            from_group.append("<button data-module-id='" + module_id + "' type='button' class='btn btn-sm cancel-button btn-info'>Cancel</button>");
            td.append(from_group);
        }
    });

    /**
     * Cancel button click handler
     * @return void
     */
    $(document).on("click", ".cancel-button", function () {
        var _this = $(this), module_id = _this.attr("data-module-id"), department_id = _this.attr("data-department-id"),
            td = _this.parents("td:first");

        _this.parent().remove();
        td.append('<button data-department-id="' + department_id + '" data-module-id="' + module_id +
        '" type="button" class="btn btn-sm edit-button btn-primary">Edit</button>');
    });

    /**
     * Save button click handler
     * @return void
     */
    $(document).on("click", ".save-button", function () {
        var _this = $(this), module_id = _this.attr("data-module-id"), department_id = _this.attr("data-department-id"),
            td = _this.parents("td:first"), department = _this.prev(), request;

        if (department.val() == department_id) {
            showMessage("You selected the same department", "Validation Error:", MESSAGE_DANGER, notification_block);
            return false;
        }

        _this.attr("disabled", true);
        _this.next().attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/module/ajax-update-module-department",
            type: "POST",
            dataType: "json",
            data: {
                module_id: module_id,
                department_id: department.val()
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                window.location.reload();
            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, notification_block);
                _this.attr("disabled", false);
                _this.next().attr("disabled", false);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, notification_block);
            _this.attr("disabled", false);
            _this.next().attr("disabled", false);
        });

    });

    /**
     * Remove button click handler
     * @return void
     */
    $(".remove-button").on("click", function () {
        var _this = $(this), request, module_id = _this.attr("data-module-id");
        if (confirm("Are you sure?")) {

            _this.attr("disabled", true);
            request = $.ajax({
                url: baseUrl + "/module/ajax-update-module-department",
                type: "POST",
                dataType: "json",
                data: {
                    module_id: module_id,
                    department_id: 0
                }
            });
            request.done(function (data) {
                if (typeof data.success !== "undefined") {

                    var department_name = _this.parent("td").prev().html(),
                        tr = _this.parents("table").find("tr"),
                        home_table = $("#home_table");
                    if (tr.length == 2) {
                        _this.parents("table").remove();
                    } else {
                        _this.parents("tr").remove();
                    }
                    if (home_table.find("tr").length == 0) {
                        home_table.append('<tr class="header-tr">' +
                        '<th>Module Name</th>' +
                        '<th>Actions</th>' +
                        '</tr>');
                    }
                    home_table.append('<tr>' +
                    '<td style="width: 200px">' + department_name + '</td>' +
                    '<td>' +
                    '<button data-module-id="' + module_id + '" type="button" class="btn btn-sm btn-primary">Edit</button>' +
                    '</td>' +
                    '</tr>');
                    showMessage(data.text, "Success!", MESSAGE_SUCCESS, notification_block);
                } else {
                    showMessage(data.text, "Error!", MESSAGE_DANGER, notification_block);
                }
            });
            request.fail(function (jqXHR, text_status) {
                showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, notification_block);
            });
            request.always(function () {
                _this.attr("disabled", false);
            });
        }
        return false;
    });
});