/**
 * Created by dimmer on 09.10.2015.
 */
$(function () {
    SetAutocompleteFields();
});

$(document).on("click", "i.flight-itinerary-add", function () {
    var _this = $(this), _table = $('table#flight-itinerary'), last_record = _table.find("tr[data-info=flight-itinerary]").last(),
        last_number = parseInt(last_record.attr("data-number")), new_record = last_record.clone();

    if (last_number < 10) {
        new_record.attr("data-number", ++last_number);
        last_record.after(new_record);
    }
});

$(document).on("click", "i.flight-itinerary-remove", function () {
    var _this = $(this), _table = $('table#flight-itinerary'), last_record = _table.find("tr[data-info=flight-itinerary]").last(),
        last_number = parseInt(last_record.attr("data-number"));

    if (last_number > 1) {
        last_record.remove();
    }
});

$(document).on("click", "i.add_flight", function () {
    var _this = $(this), baggage_info = _this.parents('.baggage-info'), last_flight = baggage_info.find('.flights').last(),
        prev_flights_number = parseInt(last_flight.attr('data-flights_number')), current_flight = last_flight.clone(),
        current_flights_number =  prev_flights_number + 1;

    if (prev_flights_number < 4) {
        current_flight.attr('data-flights_number', current_flights_number);
        current_flight.find('.input-sm').val("");
        last_flight.after(current_flight);

        SetAutocompleteFields();

        DateTimeFormat();
    }
});

$(document).on("click", "i.remove_flight", function () {
    var _this = $(this), baggage_info = _this.parents('.baggage-info'), last_flight = baggage_info.find('.flights').last(),
        prev_flights_number = parseInt(last_flight.attr('data-flights_number'));

    if (prev_flights_number > 1){
        last_flight.remove();
    }

});

$(document).on("click", "i#add_baggage", function () {
    var _this = $(this), prev_baggage = _this.parents('div').prev('.baggage-info'),
        prev_baggage_number = parseInt(prev_baggage.attr("data-number")), cur_baggage_number = prev_baggage_number + 1,
        new_baggage_record = prev_baggage.clone(),
        damage_info = new_baggage_record.find('.damage_info'), baggage_damage_types = damage_info.find('input[type=radio]'),
        whs_checkbox = new_baggage_record.find('input[type=checkbox][data-type=whs]'),
        current_baggage_num = new_baggage_record.find('.baggage_num'),
        baggage_damage_checkboxes = damage_info.find('.baggage-damage-checkboxes').find('input[type=checkbox]'),
        textarea_damage_description = damage_info.find('textarea[data-type=damage_description]'), new_name,
        a_damage_title = new_baggage_record.find('a[data-role=damage-title]'), damage_number = a_damage_title.attr('data-number'),
        next_number = parseInt(damage_number) + 1, div_damage_content = new_baggage_record.find('div[data-role=damage-content]');

    if (prev_baggage_number < 4) {

        current_baggage_num.text(cur_baggage_number);

        $.each(baggage_damage_checkboxes, function (i, item) {
            var _item = $(item),
            type = _item.attr('data-type'),
            new_name = "bag" + next_number + "_" + type + "[]";
            _item.attr('name', new_name);
        });

        new_baggage_record.find('[data-name=dep_apt]').attr('name', 'dep_apt' + cur_baggage_number + "[]");
        new_baggage_record.find('[data-name=arr_apt]').attr('name', 'arr_apt' + cur_baggage_number + "[]");
        new_baggage_record.find('[data-name=flt_no]').attr('name', 'flt_no' + cur_baggage_number + "[]");
        new_baggage_record.find('[data-name=date]').attr('name', 'date' + cur_baggage_number + "[]");
        new_baggage_record.find('[data-name=sta]').attr('name', 'sta' + cur_baggage_number + "[]");
        new_baggage_record.find('[data-name=ata]').attr('name', 'ata' + cur_baggage_number + "[]");

        $.each(baggage_damage_types, function (i, item) {
            var _item = $(item),
            type = _item.attr('data-type'),
            new_name = "bag" + next_number + "_" + type + "[]";

            _item.attr('name', new_name);
        });

        new_name = "bag" + next_number + "_" + textarea_damage_description.attr('data-type');
        textarea_damage_description.attr('name', new_name);

        new_name = "bag" + next_number + "_" + whs_checkbox.attr('data-type');
        whs_checkbox.attr('name', new_name);

        div_damage_content.attr('id', 'damage_' + next_number);
        a_damage_title.attr('data-number', next_number);
        a_damage_title.attr('href', '#damage_' + next_number);
        new_baggage_record.attr("data-number", ++prev_baggage_number);
        prev_baggage.after(new_baggage_record);

        SetAutocompleteFields();

        DateTimeFormat();
    }
});


$(document).on("click", "i#remove_baggage", function () {
    var _this = $(this), prev_baggage = _this.parents('div').prev('.baggage-info'),
        prev_baggage_number = parseInt(prev_baggage.attr("data-number"));

    if (prev_baggage_number > 1) {
        prev_baggage.remove();
    }
});

$(document).on("click", '#btn_next_basic_info', function () {
    var _this = $(this), top_panel = _this.parents('.panel'), a_href_next_panel = top_panel.nextAll(':visible').first().find('a[role="button"]');

    a_href_next_panel.click();
})
    .on("click", '#btn_next_damage_info', function () {
    var _this = $(this), top_panel = _this.parents('.panel'), a_href_next_panel = top_panel.nextAll(':visible').first().find('a[role="button"]');

    a_href_next_panel.click();
})
    .on("click", '#btn_prev_damage_info', function () {
    var _this = $(this), top_panel = _this.parents('.panel'), a_href_prev_panel = top_panel.prevAll(':visible').first().find('a[role="button"]');

    if (a_href_prev_panel.length == 1) {
        a_href_prev_panel.click();
    }
}) .on("click", '#btn_submit_supplementary_info', function () {
    var _this = $(this), top_panel = _this.parents('.panel'), a_href_next_panel = top_panel.nextAll(':visible').first().find('a[role="button"]');

    //a_href_next_panel.click();
})
    .on("click", '#btn_prev_supplementary_info', function () {
    var _this = $(this), top_panel = _this.parents('.panel'), a_href_prev_panel = top_panel.prev().find('a[role="button"]').first();

    if (a_href_prev_panel.length == 1) {
        a_href_prev_panel.click();
    }
}) .on("change", '#mhb_type', function () {
    var _this = $(this), top_parent = _this.parents('#basic_info'), damage_panels = top_parent.find('tr.damage-info-container'),
        selected_type = $("#mhb_type option:selected").text();

    if (selected_type == 'AHL'){
        damage_panels.hide();
        damage_panels.find('input').attr("disabled",true);
        damage_panels.find('textarea').attr("disabled",true);
    }
    else{
        damage_panels.show();
        damage_panels.find('input').removeAttr("disabled");
        damage_panels.find('textarea').removeAttr("disabled");
    }
});


function SetAutocompleteFields() {
    $(document).find('.airport').autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseUrl + '/template/ajax-airports-autocomplete',
                dataType: "json",
                data: {
                    iata: request.term,
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        autoFocus: true,
        minLength: 0
    });

    $(document).find('.airline').autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseUrl + '/template/ajax-airlines-autocomplete',
                dataType: "json",
                data: {
                    airline: request.term
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        autoFocus: true,
        minLength: 0
    });


    $(document).find('.brand').autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseUrl + '/template/ajax-baggage-brands-autocomplete',
                dataType: "json",
                data: {
                    search: request.term
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        autoFocus: true,
        minLength: 0
    });
}

$(document).on('click', 'area.baggate_type_area', function () {
   var _this = $(this), type =_this.attr('data-type'), button = _this.parents('td').find('button.details'),
       selectbox = button.prev('select');

    selectbox.find('option').filter(function() {
        //may want to use $.trim in here
        return $(this).text() == type;
    }).prop('selected', true);

    window.setTimeout(function () {
        button.click();
    }, 100);

    console.log(type);
});


$(document).on('click', 'img.img-baggage-color', function () {
   var _this = $(this), color =_this.attr('data-color'), button = _this.parents('td').find('button.details'),
       selectbox = button.prev('select');

    selectbox.find('option').filter(function() {
        //may want to use $.trim in here
        return $(this).text() == color;
    }).prop('selected', true);

    window.setTimeout(function () {
        button.click();
    }, 100);
});

$(document).on('click', '#mhb tr[data-mhb_id] td', function () {
    var _this = $(this), parent_tr = _this.parent(), mhb_id = parent_tr.attr('data-mhb_id'),
        mhb_details = $('#mhb_details'), mhb_details_find_by_id = mhb_details.find("tr[data-mhb_id=" + mhb_id + "]"),
        all_trs = mhb_details.find("tr[data-mhb_id]");

    mhb_details.show();
    all_trs.hide();
    mhb_details_find_by_id.show();


});

$(document).on('click', '#mhb_details tr[data-mhb_id] td', function () {
    var _this = $(this), parent_tr = _this.parent(), mhb_id = parent_tr.attr('data-mhb_id'),
        damage_checkboxes_container = $(".baggage-damage-checkboxes"),
        baggage_show_bag_alert = $('.baggage-show_bag'),
        all_checkboxes =  damage_checkboxes_container.filter("input[type=checkbox]"),
        side1 = parent_tr.attr('data-side1'), side2 = parent_tr.attr('data-side2'), end1 = parent_tr.attr('data-end1'),
        end2 = parent_tr.attr('data-end2'), top = parent_tr.attr('data-top'), bottom = parent_tr.attr('data-bottom'),
        show_bag = parent_tr.attr('data-show_bag'),
        bag = ['side1', 'side2', 'end1', 'end2', 'top', 'bottom'], _val, _val_array, _found_checkboxes;



    if (show_bag || show_bag == "1") {
        all_checkboxes.prop('checked', false);
        damage_checkboxes_container.show();
        baggage_show_bag_alert.hide();

        $.each(bag, function (i, item) {
            _val = eval(item);

            if (_val && _val != "") {
                _val_array = explode(';', _val);
                $.each(_val_array, function (j, _each) {
                    _found_checkboxes = $(document).find('input[type=checkbox][name=' + item + '][value=' + _each + ']');
                    _found_checkboxes.prop('checked', true);
                    console.log(_found_checkboxes)
                });
            }
        });
    }
    else {
        damage_checkboxes_container.hide();
        baggage_show_bag_alert.show();
    }
});