
$(".category").click(function () {
    var details = $(this).next('.details');

    if (details.hasClass('hidden'))
        details.removeClass('hidden');
    else
        details.addClass('hidden');
});


Apply_Tablesorter();

function AjaxSaveDailyBooking(input_array, updated_date, message_box) {

    var request = $.ajax({
        headers: {
            'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
        },
        url: baseUrl + "/forwardbooking/ajaxsavedailybooking",
        type: 'POST',
        dataType: 'json',
        data: {
            input_data: input_array,
            date: updated_date
        }
    });


    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            console.log(data);
            getMessageDiv("Success", message_box, 'Forward Data Were Successfully Saved');
        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_box, 'Error! Data Was Not Saved. Please See Administrator');
    });
}

$(document).on("click", "button.save", function () {
    var mytable = $(this).parent().find('table');
    var message_box = $(this).parent().find('.message_box');

    var rows = mytable.find('tbody tr');
    var aircraft_id, flight_id, capacity_a, capacity_c, capacity_w, capacity_y, pax_a_booked, pax_c_booked, pax_w_booked, pax_y_booked, cancel_flight, closed_sales, remark;
    var ac_id, flt_id, flt_std, flt_no_id, flt_bound, cap_a, cap_c, cap_w, cap_y, pax_a_bkd, pax_c_bkd, pax_w_bkd, pax_y_bkd, cancel_flt, closed_sls, rmk;
    var input_array = [];
    var updated_date = moment().zone(0).format("YYYY-MM-DD");
    var updated_datetime = moment().zone(0).format("YYYY-MM-DD HH:mm:ss");
    var flight_number_id = mytable.find('thead tr.flight_number_id th');

    console.log(mytable)
    $.each(rows, function (i, row) {
        var jrow = $(row);
        aircraft_id = jrow.find('td.aircraft_id');
        flight_id = jrow.find('td.flight_id');
        capacity_a = jrow.find('input[name="capacity_a[]"]');
        capacity_c = jrow.find('input[name="capacity_c[]"]');
        capacity_w = jrow.find('input[name="capacity_w[]"]');
        capacity_y = jrow.find('input[name="capacity_y[]"]');
        pax_a_booked = jrow.find('input[name="pax_a_booked[]"]');
        pax_c_booked = jrow.find('input[name="pax_c_booked[]"]');
        pax_w_booked = jrow.find('input[name="pax_w_booked[]"]');
        pax_y_booked = jrow.find('input[name="pax_y_booked[]"]');
        cancel_flight = jrow.find('input[name="deleted_at[]"]');
        closed_sales = jrow.find('input[name="closed_sales[]"]');
        remark = jrow.find('input[name="remark[]"]');
        for (var i = 0; i < flight_number_id.length; i++) {
            ac_id = $(aircraft_id[i]).attr('data-aircraft_id');
            flt_id = $(flight_id[i]).attr('data-flight_id');
            //flt_bound = $(flight_number_id[i]).attr('data-flight_bound');
            flt_std = $(flight_id[i]).attr('data-flight_std');
            flt_no_id = $(flight_number_id[i]).attr('data-flight_number_id');
            cap_a = $(capacity_a[i]).val();
            cap_c = $(capacity_c[i]).val();
            cap_w = $(capacity_w[i]).val();
            cap_y = $(capacity_y[i]).val();
            pax_a_bkd = $(pax_a_booked[i]).val();
            pax_c_bkd = $(pax_c_booked[i]).val();
            pax_w_bkd = $(pax_w_booked[i]).val();
            pax_y_bkd = $(pax_y_booked[i]).val();
            cancel_flt = $(cancel_flight[i]).is(':checked') ? updated_datetime : null;
            closed_sls = $(closed_sales[i]).is(':checked') ? updated_datetime : null;
            rmk = $(remark[i]).val();
            input_array.push({
                'updated_date': updated_date,
                'aircraft_id': ac_id,
                'flight_id': flt_id,
                'flight_number_id': flt_no_id,
                'std': flt_std,
                'capacity_a': cap_a,
                'capacity_c': cap_c,
                'capacity_w': cap_w,
                'capacity_y': cap_y,
                'pax_a_booked': pax_a_bkd,
                'pax_c_booked': pax_c_bkd,
                'pax_w_booked': pax_w_bkd,
                'pax_y_booked': pax_y_bkd,
                'cancel_flight': cancel_flt,
                'closed_sales': closed_sls,
                'remark': rmk
            });
        }

    });

    AjaxSaveDailyBooking(input_array, updated_date, message_box);
});

$('#export_excel').click(function () {
    $('.tab-pane.active').find('.mytable[data-excel="1"]').tableExport({type: 'excel', escape: 'true'});
});


function Pagination_Range(page, group_int) {
    var start = (page - 1) * group_int + 1;
    var end = page * group_int;
    return [start, end];
}

$(".pagination a.page").click(function () {
    Paginate_Event($(this));
});
