/**
 * Created by Dilovar Tursunov on 03.11.2014.
 */

"use strict";

var
    T_MAINTENANCE = "maintenance",
    T_FLIGHT = "flight",
    FLIGHT_AVAILABLE = "available",
    FLIGHT_DELAYED = "delayed",
    FLIGHT_CANCELLED = "cancelled",
    FLIGHT_DIVERTED = "diversion",
    FLIGHT_MAINTENANCE = "maintenance",

    template_item_key,
    timeline = null,
    messageBlock = $("#fleetwatch_message_block"),
    inbound = $('#inbound'),
    parent_flight_id = $('#parent_flight_id'),
    message_block = $("#add-flight-message"),
    parent_flight_id_div = parent_flight_id.parent('div');

google.load("visualization", "1");

// Set callback to run when API is loaded
google.setOnLoadCallback(drawVisualization);


// Called when the Visualization API is loaded.
function drawVisualization() {
    // Create and populate a data table.
    var data = new google.visualization.DataTable(),
        today = new Date(), dateFrom = new Date(), dateTo = new Date(),
        monday = moment().startOf('isoweek').toDate(),
        sunday = moment().day(7).toDate();

    // if was set go to date, use it as default date for timeline
    if (typeof from !== "undefined" && to != false) {
        dateFrom = new Date(from);
        dateTo = new Date(to);
    }

    data.addColumn("datetime", "start");
    data.addColumn("datetime", "end");
    data.addColumn("string", "content");
    data.addColumn("string", "group");
    data.addColumn("string", "className");

    if (json.length) {
        var flights = [], item, start_date, end_date;
        for (var i = 0, l = json.length; i < l; i++) {
            item = json[i];
            start_date = item.start_date;
            end_date = item.end_date;
            flights.push([
                new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                item.content,
                item.group,
                item.className
            ]);
        }
        data.addRows(flights);
        localStorage.setItem("tmp_template", JSON.stringify(json));
    }

    var addDateFrom = new Date(dateFrom.setHours(0)),
        addDateTo = new Date(dateTo.setHours(dateTo.getHours() + 5));

    // specify options
    var options = {
        stackEvents: true,
        /*start: addDateFrom.setHours(dateFrom.getHours() - 12),
        end:  addDateTo.setHours(dateTo.getHours() + 12),*/
        editable: true,
        animate: true,
        eventMargin: 5,
        eventMarginAxis: 5,
        cluster: true,
        axisOnTop: true,
        snapEvents: false,
        dragAreaWidth: 10,
        groupMinHeight: 50,
        min: addDateFrom.getTime(),
        max: addDateTo.getTime(),
        /*min: new Date(monday.setDate(monday.getDate() - 1)),
        max: new Date(sunday.setDate(sunday.getDate() + 1)), */               // upper limit of visible range
        zoomMin: 1000 * 60 * 60 * 8,          // 4 hours in milliseconds
        zoomMax: 1000 * 60 * 60 * 24 * 7,     // 7 days in milliseconds
        showButtonNew: false,
        showNavigation: false,
        showMajorLabels: true,
        width: "100%",
        height: "auto",
        layout: "box",
        groupsChangeable: true,
        groupsOrder: function (a, b) {
            if (a.content == b.content) {
                return 0;
            }
            return (a.content < b.content) ? 1 : -1;
        }
    };

    // Instantiate our timeline object
    timeline = new links.Timeline(document.getElementById("mytimeline"));

    // Draw our timeline with the created data and options
    timeline.draw(data, options);

    /**
     * Delete flight item event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "delete",
        function () {
            var flightData = getSelectedEvent();
            if (!flightData) {
                showMessage("Not found flight details", "Error!", MESSAGE_DANGER, messageBlock);
                return false;
            }

            try {
                var tmp_template = JSON.parse(localStorage.getItem("tmp_template")),
                    id = "flight-" + flightData.id;
                if (tmp_template.length) {
                    for (var i = 0, l = tmp_template.length; i < l; i++) {
                        var label = $(tmp_template[i].content);
                        if (label.attr("id") == id) {
                            tmp_template.splice(i, 1);
                            break;
                        }
                    }
                    localStorage.setItem("tmp_template", JSON.stringify(tmp_template));
                }
            } catch (e) {
                showMessage(e.message, "Error!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        }
    );


    /**
     * Change flight item position event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "changed",
        function () {
            var sel = timeline.getSelection(), flightData = getSelectedEvent();

            if (sel.length) {
                if (sel[0].row != undefined) {
                    var row = sel[0].row;
                    var itemFlight = timeline.getItem(row);
                }
            }

            if (typeof itemFlight === "undefined") {
                timeline.cancelChange();
                timeline.setSelection([]);
                return false;
            }

            if (!flightData) {
                return false;
            }

            try {
                var tmp_template = JSON.parse(localStorage.getItem("tmp_template")),
                    id = "flight-" + flightData.id, template_item_flight, child_item_flight, child_item_key, i, l, label;
                if (tmp_template.length) {
                    for (i = 0, l = tmp_template.length; i < l; i++) {
                        label = $(tmp_template[i].content);
                        if (label.attr("id") == id) {
                            template_item_key = i;
                            template_item_flight = tmp_template[i];
                            break;
                        }
                    }

                    if (template_item_flight.parent_id == 0) {
                        // need to find child one
                        for (i = 0, l = tmp_template.length; i < l; i++) {
                            if (tmp_template[i].parent_id == template_item_flight.unique_id) {
                                child_item_key = i;
                                child_item_flight = tmp_template[i];
                                break;
                            }
                        }
                    }

                    if (typeof template_item_flight !== "undefined") {
                        var aircraft_id = getAircraftId(itemFlight.group);

                        // update child if available
                        if (typeof child_item_flight !== "undefined") {
                            var database = timeline.getData(), child_index, child_timeline_item;
                            if (database.Lf.length) {
                                for (i = 0, l = database.Lf.length; i < l; i++) {
                                    var item = $(database.Lf[i].c[2].v);
                                    if (item.attr("id") == "flight-" + child_item_flight.unique_id) {
                                        child_index = i;
                                        break;
                                    }
                                }
                            }
                            if (child_index) {
                                child_timeline_item = timeline.getItem(child_index);
                            }
                            var parent_arr_date = template_item_flight.end_date;
                            var child_dep_date = child_item_flight.start_date;
                            var child_arr_date = child_item_flight.end_date;
                            var parent_arrival = new Date(parent_arr_date[0], parent_arr_date[1], parent_arr_date[2], parent_arr_date[3], parent_arr_date[4], parent_arr_date[5]);
                            var child_departure = new Date(child_dep_date[0], child_dep_date[1], child_dep_date[2], child_dep_date[3], child_dep_date[4], child_dep_date[5]);
                            var child_arrival = new Date(child_arr_date[0], child_arr_date[1], child_arr_date[2], child_arr_date[3], child_arr_date[4], child_arr_date[5]);
                            var diff = moment(itemFlight.end).diff(moment(parent_arrival)), new_child_departure, new_child_arrival;

                            new_child_departure = moment(child_departure).add(diff, 'milliseconds').toDate();
                            new_child_arrival = moment(child_arrival).add(diff, 'milliseconds').toDate();

                            if (child_timeline_item) {
                                timeline.changeItem(child_index, {
                                    start: new_child_departure,
                                    end: new_child_arrival,
                                    content: child_timeline_item.content,
                                    group: itemFlight.group,
                                    className: itemFlight.className,
                                    editable: true
                                });
                            }

                            child_item_flight.end_date = [
                                new_child_arrival.getFullYear(),
                                new_child_arrival.getMonth(),
                                new_child_arrival.getDate(),
                                new_child_arrival.getHours(),
                                new_child_arrival.getMinutes(),
                                new_child_arrival.getSeconds()
                            ];
                            child_item_flight.sta_time = moment(new_child_arrival).format("YYYY-MM-DD HH:mm:ss");
                            child_item_flight.sta_weekday = moment(new_child_arrival).format("E");
                            child_item_flight.start_date = [
                                new_child_departure.getFullYear(),
                                new_child_departure.getMonth(),
                                new_child_departure.getDate(),
                                new_child_departure.getHours(),
                                new_child_departure.getMinutes(),
                                new_child_departure.getSeconds()
                            ];
                            child_item_flight.std_time = moment(new_child_departure).format("YYYY-MM-DD HH:mm:ss");
                            child_item_flight.std_weekday = moment(new_child_departure).format("E");
                            child_item_flight.group = itemFlight.group;
                            child_item_flight.aircraft_id = aircraft_id;
                            tmp_template[child_item_key] = child_item_flight;
                        }

                       /*$.when(getAircraftIdByName(itemFlight.group)).done(function(data){
                            template_item_flight.aircraft_id = data.result;
                        });*/
                        console.log(itemFlight)
                        template_item_flight.end_date = [
                            itemFlight.end.getFullYear(),
                            itemFlight.end.getMonth(),
                            itemFlight.end.getDate(),
                            itemFlight.end.getHours(),
                            itemFlight.end.getMinutes(),
                            itemFlight.end.getSeconds()
                        ];
                        template_item_flight.sta_time = moment(itemFlight.end).format("YYYY-MM-DD HH:mm:ss");
                        template_item_flight.sta_weekday = moment(itemFlight.end).format("E");
                        template_item_flight.start_date = [
                            itemFlight.start.getFullYear(),
                            itemFlight.start.getMonth(),
                            itemFlight.start.getDate(),
                            itemFlight.start.getHours(),
                            itemFlight.start.getMinutes(),
                            itemFlight.start.getSeconds()
                        ];
                        template_item_flight.std_time = moment(itemFlight.start).format("YYYY-MM-DD HH:mm:ss");
                        template_item_flight.std_weekday = moment(itemFlight.start).format("E");
                        template_item_flight.group = itemFlight.group;
                        template_item_flight.aircraft_id = aircraft_id;
                        tmp_template[template_item_key] = template_item_flight;
                        localStorage.setItem("tmp_template", JSON.stringify(tmp_template));

                        // update edit form
                        $("#aircraft_id").val(aircraft_id);
                        $("#day_of_week").val(template_item_flight.std_weekday);
                        $("#std").val(moment(itemFlight.start).format("YYYY-MM-DD HH:mm"));
                        $("#sta").val(moment(itemFlight.end).format("YYYY-MM-DD HH:mm"));
                    }
                }
            } catch (e) {
                console.log(e.message);
            }
            console.log(template_item_flight);
        }
    );


    /**
     * Find Flight Object By Unique Id
     * @param uniqueId
     * @returns {*}
     */
    function getFlightObject(uniqueId){
        var database = timeline.getData(), foundIndex, foundFlight;
        var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));

        for (var i = 0, l = tmp_template.length; i < l; i++) {
            if (tmp_template[i].unique_id == uniqueId) {
                foundFlight = tmp_template[i];
                break;
            }
        }
        return foundFlight ? foundFlight : false;
    }


    /**
     * Select exact flight event handler
     * @return void
     */
    google.visualization.events.addListener(timeline, "unselect",
        function () {
            var WEEKLY = "weekly",
                FIRST_WEEK = "first_week",
                aircraft_id = $("#aircraft_id"),
                flight_number_id = $("#flight_number_id"),
                day_of_week = $("#day_of_week"),
                std = $("#std"),
                sta = $("#sta");
            $("#add-flight-legend").html("Add Flight");
            aircraft_id.val("");
            flight_number_id.val("");
            $("#frequency").val(WEEKLY);
            $("#starting_week").val(FIRST_WEEK);
            day_of_week.val("");
            std.val("");
            sta.val("");
            parent_flight_id_div.hide();
            inbound.prop('checked', false);
            $("#update-flight-btn").hide();
            $("#reset-flight-btn").hide();
            $("#add-new-flight-btn").show();
            $("#selected-flight-id").val("");

            aircraft_id.parent().removeClass("has-error has-success");
            flight_number_id.parent().removeClass("has-error  has-success");
            day_of_week.parent().removeClass("has-error has-success");
            std.parent().removeClass("has-error has-success");
            sta.parent().removeClass("has-error has-success");
        }
    );

    /**
     * Select exact flight event handler
     * @return void
     */
    google.visualization.events.addListener(timeline, "select",
        function () {
            var $body = $("body"), requestData, request, flight, std, sta, parentFlight,
                flightData = getSelectedEvent();

            try {
                var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
                if (!(tmp_template instanceof Array)) {
                    showMessage("Not found template data to be save as template", "Empty data!", MESSAGE_DANGER, messageBlock);
                    return false;
                }
            } catch (e) {
                showMessage(e.message, "Error!", MESSAGE_DANGER, messageBlock);
                return false;
            }



            if (tmp_template.length) {
                for (var i = 0, l = tmp_template.length; i < l; i++) {
                    if (tmp_template[i].unique_id == flightData.id) {
                        flight = tmp_template[i];
                        break;
                    }
                }
            }

            if (typeof flight === "object") {
                // Parent Id Set
                if (flight.parent_id == 0){
                    inbound.prop('checked', false);
                    parent_flight_id_div.hide();
                }
                else {
                    inbound.prop('checked', true);
                    parentFlight = getFlightObject(flight.parent_id);
                    if (parentFlight){
                        console.log(parentFlight)
                        // Remove All Options
                        parent_flight_id.children().remove();
                        var parentOption = $('<option></option>').attr('value', flight.parent_id)
                                                                 .attr('selected', true)
                                                                 .text(flightNumbers[parentFlight.flight_number_id] + " " + parentFlight.std_time);
                        parentOption.appendTo(parent_flight_id);
                    }
                    parent_flight_id_div.show();
                }
                // STD
                std = moment({  y    : flight.start_date[0],
                                M    : flight.start_date[1],
                                d    : flight.start_date[2],
                                h    : flight.start_date[3],
                                m    : flight.start_date[4]
                              });
                // STA
                sta = moment({  y    : flight.end_date[0],
                                M    : flight.end_date[1],
                                d    : flight.end_date[2],
                                h    : flight.end_date[3],
                                m    : flight.end_date[4]
                              });

                $("#add-flight-legend").html("Edit Flight");
                $("#aircraft_id").val(flight.aircraft_id);
                $("#flight_number_id").val(flight.flight_number_id);
                $("#frequency").val(flight.frequency);
                $("#starting_week").val(flight.starting_week);
                $("#day_of_week").val(flight.std_weekday);
                $("#std").val(std.format('YYYY-MM-DD HH:mm'));
                $("#sta").val(sta.format('YYYY-MM-DD HH:mm'));
                $("#update-flight-btn").show();
                $("#reset-flight-btn").show();
                $("#add-new-flight-btn").hide();
                $("#selected-flight-id").val(flight.unique_id);
            }
        }
    );


    $('#searchParentFlight').click(function () {
        var aircraftId = $("#aircraft_id").val(),  flightNumberId = $("#flight_number_id").val(),
            std = $("#std").val(), sta = $('#sta').val(), request, parentFlight;

        if (aircraftId && flightNumberId && std && sta){
            request = $.ajax({
                url: baseUrl + '/flight/ajax-parent-flight-number-id',
                dataType: 'JSON',
                type: 'GET',
                data:{
                    flightNumberId  : flightNumberId
                }
            });

            request.done(function (data) {
                if (typeof data.success !== 'undefined'){
                    if (data.success){
                        parentFlight = searchParentFlight(data.flightNumberId, aircraftId, std);
                        console.log(parentFlight)
                        if (parentFlight) {
                            showMessage("Parent Flight Found", "Success", MESSAGE_SUCCESS, message_block);
                            parent_flight_id.children().remove();
                            var parentOption = $('<option></option>').attr('value', parseInt(parentFlight.unique_id))
                                .attr('selected', true)
                                .text(flightNumbers[parentFlight.flight_number_id] + " " + parentFlight.std_time);
                            parentOption.appendTo(parent_flight_id);
                        }
                        else {
                            showMessage("Parent Flight Not Found", "Error", MESSAGE_DANGER, message_block);
                        }
                    }
                    else{
                        showMessage("Parent Flight Not Found", "Error", MESSAGE_DANGER, message_block);
                    }
                }
            });

            request.fail(function (jqXHR, text_status){

            })
        }
    });


    /**
     * Search Parent Flight
     * @param flightNumberId
     * @param aircraftId
     * @param childStd
     * @returns {*}
     */
    function searchParentFlight(flightNumberId, aircraftId, childStd) {
        var tmp_template = JSON.parse(localStorage.getItem("tmp_template")), parentStd, previousDate, found = false;

        childStd = moment(childStd).format('YYYY-MM-DD');

        for (var i = 0, l = tmp_template.length; i < l; i++) {
            if (tmp_template[i].aircraft_id == aircraftId && tmp_template[i].flight_number_id == flightNumberId) {
                parentStd = moment(tmp_template[i].std_time).format('YYYY-MM-DD');
                if (moment(parentStd).format('X') == moment(childStd).format('X')) {
                    return tmp_template[i];
                }
                previousDate = moment(childStd).subtract(1, 'days');
                if (moment(parentStd).format('X') == moment(previousDate).format('X')) {
                    found = tmp_template[i];
                }
            }
        }
        return found;
    }


    /**
     * Get selected flight ID and type
     * @returns {*}
     */
    function getSelectedEvent() {
        var type, id, flight = $(".timeline-event-selected > div.timeline-event-content > div");
        if (flight.length) {
            id = flight.attr("id");
            if (id.indexOf("flight-") === -1) {
                type = T_MAINTENANCE;
                id = id.replace("maintenance-", "");
            } else {
                type = T_FLIGHT;
                id = id.replace("flight-", "");
            }
            return {
                "type": type,
                "id": id
            }
        }
        return false;
    }

    /**
     * Get aircraft ID
     * @param aircraftName
     * @returns {*}
     */
    function getAircraftId(aircraftName) {
        var aircraft_id;
        if (typeof aircraft !== "undefined" && aircraft instanceof Object) {
            for (var i in aircraft) {
                if (i && aircraft.hasOwnProperty(i)) {
                    if (aircraft[i] == aircraftName) {
                        aircraft_id = i;
                    }
                }
            }
        }
        return aircraft_id;
    }
}


$(function () {

    /**
     * Save fleet watch data as new template
     * @return bool
     */
    $("#save-as-template-btn").click(function () {
        try {
            var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
            if (!(tmp_template instanceof Array)) {
                showMessage("Not found template data to be save as template", "Empty data!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        } catch (e) {
            showMessage(e.message, "Error!", MESSAGE_DANGER, messageBlock);
            return false;
        }
        if (!$("#template_name").val()) {
            showMessage("Template name is required", "Validation Errors:", MESSAGE_DANGER, messageBlock);
            return false;
        }

        $("#template_data").val(JSON.stringify(tmp_template));
        console.log(tmp_template)
        $("#save-template-form").submit();
        return true;
    });

    /**
     * Upload data to fleet watch button click event handler
     * @return void
     */
    $("#upload-data-to-fleetwatch-btn").click(function () {
        var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
        try {
            if (!($.isArray(tmp_template))) {
                showMessage("Not found template data to upload to fleetwatch", "Empty data!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        } catch (e) {
            showMessage(e.message, "Error!", MESSAGE_DANGER, messageBlock);
            return false;
        }
        // validate form fields
        messageBlock.empty();
        var week_from = $("#upload_week_from").val(),
            year_from = $("#upload_year_from").val(),
            week_to = $("#upload_week_to").val(),
            year_to = $("#upload_year_to").val();
        if (!week_from || !year_from || !week_to || !year_to) {
            showMessage("Please select week and year to upload data", "Validation errors:", MESSAGE_DANGER, messageBlock);
            return false;
        }
        if (year_from > year_to || (year_from == year_to && week_from > week_to)){
            showMessage("'From' date cannot be less than 'to' date", "Validation errors:", MESSAGE_DANGER, messageBlock);
            return false;
        }

        $("#fleetwatch_data").val(JSON.stringify(tmp_template));
        //return false;
        $("#upload-to-fleetwatch-form").submit();
        return true;
    });

    /**
     * Update current template click handler
     * @return void
     */
    $("#update-current-template-btn").click(function () {
        var _this = $(this), request, template_id = $("#loaded_template_id").val();

        try {
            var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
            if (!(tmp_template instanceof Array)) {
                showMessage("Not found template data to be updated", "Empty data!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        } catch (e) {
            showMessage(e.message, "Error!", MESSAGE_DANGER, messageBlock);
            return false;
        }
        if (!template_id) {
            showMessage("Not found template ID", "Error!", MESSAGE_DANGER, messageBlock);
            return false;
        }

        _this.attr("disabled", true).html("loading...");
        request = $.ajax({
            headers: {
                'x-csrf-token': $("#upload-to-fleetwatch-form").find('input[name=_token]').val()
            },
            url: baseUrl + "/flight-schedule/ajax-update-template",
            type: "POST",
            dataType: "json",
            data: {
                template_data: JSON.stringify(tmp_template),
                template_id: template_id
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success", MESSAGE_SUCCESS, messageBlock);
            } else {
                showMessage(data.message, "Error", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Update Current Template");
        });
    });

    /**
     * Delete current template
     * @return void
     */
    $("#delete-current-template-btn").click(function () {
        var _this = $(this), request, template_id = $("#loaded_template_id").val();
        if (!template_id) {
            showMessage("Not found template ID", "Error!", MESSAGE_DANGER, messageBlock);
            return false;
        }

        _this.attr("disabled", true).html("loading...");
        request = $.ajax({
            url: baseUrl + "/flight-schedule/ajax-delete-template",
            type: "GET",
            dataType: "json",
            data: {
                template_id: template_id
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, "Success", MESSAGE_SUCCESS, messageBlock);
                window.location = baseUrl + "/flight-schedule/index";
            } else {
                showMessage(data.message, "Error", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Remove Template");
        });
    });

    /**
     * Add New Flight
     */
    $("#add-new-flight-btn").on("click", function () {
        var _this = $(this), valid = true,
            aircraft_id = $("#aircraft_id"),
            flight_number_id = $("#flight_number_id"),
            /*day_of_week = $("#day_of_week"),*/
            std = $("#std"),
            sta = $("#sta"),
            frequency = $("#frequency"),
            starting_week = $("#starting_week");

        message_block.empty();
        if (!aircraft_id.val()) {
            aircraft_id.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!flight_number_id.val()) {
            flight_number_id.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        /*if (!day_of_week.val()) {
            day_of_week.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }*/
        if (!std.val()) {
            std.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!sta.val()) {
            sta.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!valid) {
            showMessage("Please check your form field, all fields are required", "Validation Errors:", MESSAGE_DANGER, message_block);
            return false;
        }

        aircraft_id.parent().addClass("has-success").removeClass("has-error");
        flight_number_id.parent().addClass("has-success").removeClass("has-error");
        //day_of_week.parent().addClass("has-success").removeClass("has-error");
        std.parent().addClass("has-success").removeClass("has-error");
        sta.parent().addClass("has-success").removeClass("has-error");

        try {
            var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
            if (!(tmp_template instanceof Array)) {
                showMessage("Not found template data to be save as template", "Empty data!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        } catch (e) {
            showMessage(e.message, "Error!", MESSAGE_DANGER, message_block);
            return false;
        }

        var flight_number = flight_number_id.find("option:selected");
        var re = /([0-9]+)(?:[ ])([A-Z]+)\040\-\040([A-Z]+)/g;
        var str = flight_number.html();
        var content = str.replace(re, "<span class='col-xs-0 col-sm-4'>$2</span>" +
        "<span class='col-xs-0 col-sm-4'>"+CURRENT_IATA_CODE+" $1</span>" +
        "<span class='col-xs-0 col-sm-4'>$3</span>");
        var rand_id = _.random(1, 1000000);
        //var flightDate = moment().isoWeekday(day_of_week.val()),
        var std_time = moment(std.val()).format('YYYY-MM-DD HH:mm'),
            sta_time = moment(sta.val()).format('YYYY-MM-DD HH:mm');
        var flight_item = {
                unique_id: rand_id,
                aircraft_id: parseInt(aircraft_id.val()),
                className: FLIGHT_AVAILABLE,
                content: "<div id='flight-" + rand_id + "' class='row  fw-flight-item'>" + content + "</div>",
                flight_number_id: parseInt(flight_number_id.val()),
                group: aircraft_id.find("option:selected").html(),
                frequency: frequency.val(),
                starting_week: starting_week.val(),
                sta_time: sta_time + ":00",
                sta_weekday: moment(sta_time).weekday(), /*day_of_week.val(),*/
                std_time: std_time + ":00",
                std_weekday:  moment(std_time).weekday(), /*day_of_week.val(),*/
                start_date: [
                    moment(std_time).get('year'),  //flightDate.format("YYYY"),
                    moment(std_time).get('month'), //flightDate.month(),
                    moment(std_time).get('date'),  //flightDate.date(),
                    moment(std_time).get('hour'),  //sta_time[0],
                    moment(std_time).get('minute'), //sta_time[1],
                    0
                ],
                end_date: [
                    moment(sta_time).get('year'), //flightDate.format("YYYY"),
                    moment(sta_time).get('month'), //flightDate.month(),
                    moment(sta_time).get('date'), //flightDate.date(),
                    moment(sta_time).get('hour'), //sta_time[0],
                    moment(sta_time).get('minute'), //sta_time[1],
                    0
                ],
                parent_id : 0
            };

        if (inbound.is(':checked') && parent_flight_id.val()){
            flight_item.parent_id = parseInt(parent_flight_id.val());
        }


        tmp_template.push(flight_item);
        timeline.addItem({
            start: new Date(flight_item.start_date[0], flight_item.start_date[1], flight_item.start_date[2],
                flight_item.start_date[3], flight_item.start_date[4], flight_item.start_date[5]),
            end: new Date(flight_item.end_date[0], flight_item.end_date[1], flight_item.end_date[2],
                flight_item.end_date[3], flight_item.end_date[4], flight_item.end_date[5]),
            content: flight_item.content,
            group: flight_item.group,
            className: flight_item.className,
            editable: true
        });
        localStorage.setItem("tmp_template", JSON.stringify(tmp_template));
        return false;
    });

    /**
     * Update current flight information
     * @return void
     */
    $("#update-flight-btn").on("click", function () {

        var _this = $(this), valid = true, index = null, parent_id = 0,
            selected_flight_id = $("#selected-flight-id").val(),
            aircraft_id = $("#aircraft_id"),
            flight_number_id = $("#flight_number_id"),
            day_of_week = $("#day_of_week"),
            std = $("#std"),
            sta = $("#sta"),
            frequency = $("#frequency"),
            starting_week = $("#starting_week");
        message_block.empty();
        if (!selected_flight_id) {
            showMessage("Not found flight ID", "Validation Errors:", MESSAGE_DANGER, message_block);
            return false;
        }
        if (!aircraft_id.val()) {
            aircraft_id.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!flight_number_id.val()) {
            flight_number_id.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!day_of_week.val()) {
            day_of_week.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!std.val()) {
            std.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!sta.val()) {
            sta.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (inbound.is(':checked') && !$.isNumeric(parent_flight_id.val())){
            parent_flight_id.parent().addClass("has-error").removeClass("has-success");
            valid = false;
        }
        if (!valid) {
            showMessage("Please check your form field, all fields are required", "Validation Errors:", MESSAGE_DANGER, message_block);
            return false;
        }

        aircraft_id.parent().addClass("has-success").removeClass("has-error");
        flight_number_id.parent().addClass("has-success").removeClass("has-error");
        day_of_week.parent().addClass("has-success").removeClass("has-error");
        std.parent().addClass("has-success").removeClass("has-error");
        sta.parent().addClass("has-success").removeClass("has-error");
        parent_flight_id.parent().addClass("has-success").removeClass("has-error");

        try {
            var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
            if (!(tmp_template instanceof Array)) {
                showMessage("Not found template data to be save as template", "Empty data!", MESSAGE_DANGER, messageBlock);
                return false;
            }
        } catch (e) {
            showMessage(e.message, "Error!", MESSAGE_DANGER, message_block);
            return false;
        }

        for (var i = 0, l = tmp_template.length; i < l; i++) {
            if (tmp_template[i].unique_id == selected_flight_id) {
                index = i;
                parent_id = tmp_template[i].parent_id;
                break;
            }
        }
        if (index == null) {
            showMessage("Not found selected flight in local storage", "Warning!", MESSAGE_WARNING, message_block);
            return false;
        }

        var sel = timeline.getSelection();
        if (sel.length) {
            if (sel[0].row != undefined) {
                var row = sel[0].row;
            }
        }
        var timelineItem = timeline.getItem(row);
        var flight_number = flight_number_id.find("option:selected");
        var re = /([0-9]+)(?:[ ])([A-Z]+)\040\-\040([A-Z]+)/g;
        var str = flight_number.html();
        var content = str.replace(re, "<span class='col-xs-0 col-sm-4'>$2</span>" +
        "<span class='col-xs-0 col-sm-4'>"+CURRENT_IATA_CODE+" $1</span>" +
        "<span class='col-xs-0 col-sm-4'>$3</span>");
        var flightDate = moment().isoWeekday(day_of_week.val()),
            std_time = moment(std.val()).format('YYYY-MM-DD HH:mm'),// explode(":", std.val()),
            sta_time = moment(sta.val()).format('YYYY-MM-DD HH:mm'), //explode(":", sta.val()),
            std_minutes = parseInt(std_time[0]) * 60 + parseInt(std_time[1]),
            sta_minutes = parseInt(sta_time[0]) * 60 + parseInt(sta_time[1]),
            flight_item = {
                unique_id: parseInt(selected_flight_id),
                parent_id: parseInt(parent_id),
                aircraft_id: parseInt(aircraft_id.val()),
                className: FLIGHT_AVAILABLE,
                content: "<div id='flight-" + selected_flight_id + "' class='row  fw-flight-item'>" + content + "</div>",
                flight_number_id: parseInt(flight_number_id.val()),
                group: aircraft_id.find("option:selected").html(),
                frequency: frequency.val(),
                starting_week: starting_week.val(),
                sta_time: sta_time + ":00",
                sta_weekday: (std_minutes > sta_minutes) ? parseInt(day_of_week.val()) + 1 : day_of_week.val(),
                std_time: std_time + ":00",
                std_weekday: day_of_week.val(),
                start_date: [
                    moment(std_time).get('year'), //flightDate.format("YYYY"),
                    moment(std_time).get('month'), //flightDate.month(),
                    moment(std_time).get('date'), //flightDate.date(),
                    moment(std_time).get('hour'), //sta_time[0],
                    moment(std_time).get('minute'), //sta_time[1],
                    0
                ],
                end_date: [
                    moment(sta_time).get('year'), //flightDate.format("YYYY"),
                    moment(sta_time).get('month'), //flightDate.month(),
                    moment(sta_time).get('date'), //flightDate.date(),
                    moment(sta_time).get('hour'), //sta_time[0],
                    moment(sta_time).get('minute'), //sta_time[1],
                    0
                ]
            };
        if (moment(timelineItem.end).day() > day_of_week.val()) {
            var end = moment(timelineItem.end).toDate();
            flight_item.end_date = [
                flightDate.format("YYYY"),
                flightDate.month(),
                end.getDate(),
                sta_time[0],
                sta_time[1],
                0
            ];
        }

        if (inbound.is(':checked') && parent_flight_id.val()){
            flight_item.parent_id = parseInt(parent_flight_id.val());
        }
        else {
            flight_item.parent_id = 0;
        }


        tmp_template[index] = flight_item;
        timeline.changeItem(row, {
            start: new Date(flight_item.start_date[0], flight_item.start_date[1], flight_item.start_date[2],
                flight_item.start_date[3], flight_item.start_date[4], flight_item.start_date[5]),
            end: new Date(flight_item.end_date[0], flight_item.end_date[1], flight_item.end_date[2],
                flight_item.end_date[3], flight_item.end_date[4], flight_item.end_date[5]),
            content: flight_item.content,
            group: flight_item.group,
            className: flight_item.className,
            editable: true
        });

        if (frequency.val() !== 'weekly')
            $('#flight-'+selected_flight_id).parents('.available').addClass('frequency_different');

        localStorage.setItem("tmp_template", JSON.stringify(tmp_template));
        return false;
    });

    /**
     * Reset edit form
     * @return void
     */
    $("#reset-flight-btn").on("click", function () {
        var WEEKLY = "weekly",
            FIRST_WEEK = "first_week",
            aircraft_id = $("#aircraft_id"),
            flight_number_id = $("#flight_number_id"),
            day_of_week = $("#day_of_week"),
            std = $("#std"),
            sta = $("#sta");
        $("#add-flight-legend").html("Add Flight");
        aircraft_id.val("");
        flight_number_id.val("");
        $("#frequency").val(WEEKLY);
        $("#starting_week").val(FIRST_WEEK);
        day_of_week.val("");
        std.val("");
        sta.val("");
        $("#update-flight-btn").hide();
        $("#reset-flight-btn").hide();
        $("#add-new-flight-btn").show();
        $("#selected-flight-id").val("");

        aircraft_id.parent().removeClass("has-error has-success");
        flight_number_id.parent().removeClass("has-error  has-success");
        day_of_week.parent().removeClass("has-error has-success");
        std.parent().removeClass("has-error has-success");
        sta.parent().removeClass("has-error has-success");
        timeline.setSelection([]);
    });

    /**
     * Add flight fields change event handler, show parent flight field
     * @return void
     */
    $(".add-flight-field").on("change", function () {
        var aircraft_id = $("#aircraft_id").val(),
            flight_number = $("#flight_number_id"),
            flight_number_id = flight_number.val(),
            std = $("#std").val(),
            parent_flights_field = $("#parent_flight_id"),
            day_of_week = $("#day_of_week").val();

        if (aircraft_id && flight_number_id && day_of_week && std) {
            var flight_number_html = flight_number.find("option:selected").html();
            var flight_number_no = parseInt(flight_number_html.replace(/\D/g, ""));
            std = std.split(":");
            if (flight_number_no > 0 && flight_number_no % 2 == 0) {
                try {
                    var tmp_template = JSON.parse(localStorage.getItem("tmp_template"));
                    if (!(tmp_template instanceof Array)) {
                        showMessage("Not found template data to be save as template", "Empty data!", MESSAGE_DANGER, messageBlock);
                        return false;
                    }
                } catch (e) {
                    showMessage(e.message, "Error!", MESSAGE_DANGER, message_block);
                    return false;
                }

                var flight_date = moment().day(day_of_week).set("hour", parseInt(std[0])).set("minute", parseInt(std[1])),
                    item_flight_no, item_flight_arrival, arr, dep, item_flight_departure,
                    end_period = flight_date.subtract(1, "days"), i, l,
                    parent_flight_no = parseInt(flight_number_no) - 1,
                    parent_flights = [];
                for (i = 0, l = tmp_template.length; i < l; i++) {
                    item_flight_no = $(tmp_template[i].content).find('span:nth-child(2)').html();
                    arr = tmp_template[i].end_date;
                    dep = tmp_template[i].start_date;
                    item_flight_no = item_flight_no.replace(/\D/g, "");
                    item_flight_arrival = moment(new Date(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]));
                    item_flight_departure = moment(new Date(dep[0], dep[1], dep[2], dep[3], dep[4], dep[5]));
                    if (tmp_template[i].aircraft_id == aircraft_id && item_flight_no == parent_flight_no &&
                        item_flight_arrival >= end_period && item_flight_departure < flight_date) {
                        parent_flights.push({
                            id: tmp_template[i].unique_id,
                            label: CURRENT_IATA_CODE+" " + item_flight_no + " " + item_flight_departure.format("ddd") + " " + item_flight_departure.format("HH:mm")
                        });
                    }
                }
                if (parent_flights.length) {
                    parent_flights_field.find("select:not(:first)").remove();
                    parent_flights_field.parent().show();
                    for (i = 0, l = parent_flights.length; i < l; i++) {
                        parent_flights_field.append("<option value='" + parent_flights[i].id + "'>" + parent_flights[i].label + "</option>");
                    }
                }

                console.log(parent_flights);
            }
        }
    });

    /**
     * Load SSIM button click handler
     * @return void
     */
    $("#load-ssim-btn").click(function () {
        var _this = $(this), ssim_message = $("#ssim-message").val();

        if (ssim_message) {
            var general_regexp = /.*(SCR|SHL|SMA|SAL|SIR|SAQ|WCR|WIR)\s+(?:\/.+\s+)?((?:S|W)[0-9]{2})\s+([0-9]{2}[A-Z]{3})\s+([A-Z]{3})\s+(?:(?:[^SI][^GI].+\s+){1,})(?:SI\s+([\w ]+)\s+)?(?:GI\s+?([\w ]+))?/im,
                flight_regexp = ".*(?:(N|S)([A-Z0-9]+))\u0020+(?:[A-Z0-9]+\u0020+)?([0-9]{2}[A-Z]{3}[0-9]{2}[A-Z]{3})\u0020+([0-9]{7})\u0020+(?:([0-9]{3})?([A-Z0-9\-]+)?\u0020+)?([A-Z]{3})(?:[A-Z]{3})?([0-9]{4})\u0020([0-9]{4})([1,2]{1})?(?:[A-Z]{3})?([A-Z]{3})?\u0020+([A-Z]+)?\u0020?([0-9]+)?",
                flight_general_regexp = new RegExp(flight_regexp, "img"),
                flight_item_regexp = new RegExp(flight_regexp, "im"),
                match = ssim_message.match(general_regexp),
                flights_rows = ssim_message.match(flight_general_regexp),
                flights = [];

            if (flights_rows.length) {
                for (var i = 0, l = flights_rows.length; i < l; i++) {
                    var item_flight = flights_rows[i].match(flight_item_regexp);
                    if (item_flight && item_flight.length) {
                        flights.push({
                            type: item_flight[1],
                            flight_number: item_flight[2],
                            period: item_flight[3],
                            available_days: item_flight[4],
                            seat_numbers: item_flight[5],
                            aircraft_sub_code: item_flight[6],
                            departure_airport: item_flight[7],
                            arrival_time: item_flight[8],
                            departure_time: item_flight[9],
                            overnight_indicator: item_flight[10],
                            arrival_airport: item_flight[11],
                            service_codes: item_flight[12],
                            frequency_indicator: item_flight[13]
                        });
                    }
                }
                console.log(flights);
            }
        }
    });


});