/**
 * Created by Dilovar Tursunov on 30.10.2014.
 */

"use strict";

$(function() {

    /**
     * On focus week or year select box
     * @return void
     */
    $("#week, #year").on("focus", function () {
        $("#load_type_from_to").removeAttr("checked");
        $("#load_type_week").prop("checked", "checked");
    });

    /**
     * On focus week or year select box
     * @return void
     */
    $("#upload_week, #upload_year").on("focus", function () {
        $("#upload_data_from_to").removeAttr("checked");
        $("#upload_data_week").prop("checked", "checked");
    });

    /**
     * On focus event handler
     * @return void
     */
    $("#from, #to").on("focus", function() {
        $("#load_type_week").removeAttr("checked");
        $("#load_type_from_to").prop("checked", "checked");
    });

    /**
     * On focus event handler
     * @return void
     */
    $("#upload_from, #upload_to").on("focus", function() {
        $("#upload_data_week").removeAttr("checked");
        $("#upload_data_from_to").prop("checked", "checked");
    });

    /**
     * Load source select box change event handler
     * @return void
     */
    $("#source").on("change", function() {
        var _this = $(this), value = _this.val();
        if (value == "fleetwatch") {
            $("#fleet-watch-load-form").show();
            $("#update-current-template-btn").hide();
            $("#delete-current-template-btn").hide();
            $("#template-load-form").hide();
            $("#open-ssim-popup").hide();
            $("#load-buttons").show();
        } else if (value == "template") {
            $("#fleet-watch-load-form").hide();
            $("#template-load-form").show();
            $("#open-ssim-popup").hide();
            $("#load-buttons").show();
        } else if (value == "SSIM") {
            $("#ssim_modal").modal();
            $("#open-ssim-popup").show();
            $("#fleet-watch-load-form").hide();
            $("#template-load-form").hide();
            $("#load-buttons").hide();
        }
    });

    /**
     * Open SSIM popup click event handler
     */
    $("#open-ssim-popup-btn").click(function() {
        $("#ssim_modal").modal();
    });

    /**
     * From, To fields enable date picker
     */
    $("#from, #to, #upload_from, #upload_to").datetimepicker({
        format: "Y-m-d",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false,
        weeks: true
    });

    $('#inbound').click(function () {
        var _this = $(this), parent_flight_id = $('#parent_flight_id');
        if (_this.is(':checked')){
            parent_flight_id.parent('div').show();
            parent_flight_id.children().remove();
            parent_flight_id.append($('<option></option>').text('Select Parent Flight'))
        }
        else{
            parent_flight_id.parent('div').hide();
        }
    });
    /*$("#std, #sta").datetimepicker({
        format: "H:i",
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        datepicker: false,
        timepicker: true,
        step: 5,
        weeks: true
    });*/

});