var column, bottom_column, seat, id, last_cabin = 0, divider, column_no, row_no,seatNo, extraSpace;
var seatMap = $(document).find('#seat-map'); /*AirplaneConfig(acConfig) */

console.log(acConfig)
$.each(acConfig, function(cabin, each)
{
    try
    {
        console.log(cabin);
        console.log(each);
        var rowStart = parseInt(each.rowStart);
        var rowEnd = parseInt(each.rowEnd);
        for (var i = rowStart; i <= rowEnd; i++)
        {
            if (typeof each.emptyRows !== 'undefined' && Object.keys(each.emptyRows).length
                && ($.inArray(i, each.emptyRows) !== -1 || $.inArray(i + "", each.emptyRows) !== -1))
            {//  &&
                console.log("empty Rows");
                console.log(each.emptyRows);
                continue;
            }

            /**
             * Column Names
             */
            console.log("row: " + i);
            console.log("cabin: " + cabin);
            console.log("last cabin: " + last_cabin);

            if ((!last_cabin || cabin !== last_cabin) && i === rowStart)
            {
                column = $('<div></div>').addClass('seatCharts-column');
                column_no = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space'].join(' '));
                column.append(column_no);
                $.each(each.columns, function (j, col)
                {
                    if (col === "_")
                    {
                        row_no = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space', cabin].join(' '));
                    }
                    else
                    {
                        row_no = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space', cabin].join(' ')).text(col);
                    }
                    column.append(row_no);
                });
                seatMap.append(column)
            }



            /**
             * Column Names : 1, 2, 3, ...
             */
            column = $('<div></div>').addClass('seatCharts-column ' + cabin);
            column_no = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space'].join(' ')).text(i);
            column.append(column_no);

            $.each(each.columns, function (j, col)
            {

                /**
                 * Check Empty Seats if Exists
                 */

                console.log("COLUMN row = " + j + " - " + col);

                seatNo = i + col;
                if (typeof each.emptySeats !== 'undefined' && Object.keys(each.emptySeats).length
                    && $.inArray(seatNo, each.emptySeats) !== -1)
                {
                    seat = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space', cabin].join(' '));
                    column.append(seat);
                    return true;
                }

                id = i + col;
                if (col === "_")
                {
                    seat = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space', cabin].join(' '));
                }
                else
                {
                    switch (cabin)
                    {
                        case 'a':
                            seat = $('<div></div>').attr('id', id).text('').addClass(['seatCharts-seat', 'seatCharts-cell', 'first-class', 'available'].join(' '));
                            break;
                        case 'b':
                            seat = $('<div></div>').attr('id', id).text('').addClass(['seatCharts-seat', 'seatCharts-cell', 'business-class', 'available'].join(' '));
                            break;
                        case 'w':
                            seat = $('<div></div>').attr('id', id).text('').addClass(['seatCharts-seat', 'seatCharts-cell', 'economy-plus-class', 'available'].join(' '));
                            break;
                        case 'e':
                            seat = $('<div></div>').attr('id', id).text('').addClass(['seatCharts-seat', 'seatCharts-cell', 'economy-class', 'available'].join(' '));
                            break;
                    }
                }

                column.append(seat);
            });


            /**
             * Column Names : 1, 2, 3, ...
             */
            bottom_column = $('<div></div>').addClass(['seatCharts-cell', 'seatCharts-space'].join(' ')).text(i);
            column.append(bottom_column);

            seatMap.append(column);

            if (typeof each.extraSpace !== 'undefined' && each.extraSpace.length > 0 && $.inArray("" + i, each.extraSpace) !== -1)
            {
                extraSpace = $('<div></div>').addClass(['seatCharts-column', 'seatCharts-extra-space'].join(' '));
                seatMap.append(extraSpace);
            }

            if (i === rowEnd)
            {
                if (last_cabin && cabin !== last_cabin)
                {
                    divider = $('<div></div>').addClass(['seatCharts-column', 'seatCharts-divider'].join(' '));
                    seatMap.append(divider);
                }
            }
        }
        last_cabin = cabin;
    }
    catch (e)
    {
        console.log(e);
    }
});

$(document).find('.seatCharts-seat.seatCharts-cell').on({
    mouseenter: function () {
        var _this = $(this), id = _this.attr('id'), seatTooltip = $('.passenger-popup-info'),
            booked = _this.hasClass('booked'), seatInfo = $('.seatTooltip'),
            seatNumber, cabin, data, info, findAttr;

        if (typeof id !== 'undefined') {
            if (booked) {

                var data = {
                    seat_number       : id,
                    //"profile-picture" : _this.attr('profile-picture'),
                    last_name         : _this.attr('last_name').toUpperCase(),
                    first_name        : _this.attr('first_name'),
                    //gender            : _this.attr('gender'),
                    GRP               : _this.attr('GRP'),
                    TKT_NO            : _this.attr('TKT_NO'),
                    fare              : _this.attr('fare'),
                    //fare_basis        : _this.attr('fare_basis'),
                    //coupon            : _this.attr('coupon'),
                    //FQTV              : _this.attr('FQTV'),
                    //XBAG              : _this.attr('XBAG'),
                    //xbag_qty          : _this.attr('xbag_qty'),
                    //xbag_wt           : _this.attr('xbag_wt'),
                    BAG                 : _this.attr('BAG'),
                    //rbd               : _this.attr('rbd'),
                    PNR                 : _this.attr('PNR'),
                    FQTV                : _this.attr('FQTV'),
                    outbound            : _this.attr('outbound'),
                    inbound             : _this.attr('inbound'),
                    codeshare           : _this.attr('codeshare'),
                    SSR                 : _this.attr('SSR'),
                    SSR_INFO            : _this.attr('SSR_INFO'),
                    source              : _this.attr('source'),
                    //baggage_pcs       : _this.attr('baggage_pcs'),
                    //baggage_wt        : _this.attr('baggage_wt'),
                    TAG_NO              : _this.attr('TAG_NO')
                };

                $.each(data, function (attr, value) {
                    findAttr = seatTooltip.find('.' + attr);
                    if (findAttr.length) {
                        if (attr == 'profile-picture') {
                            findAttr.attr('src', value);
                        }
                        else {
                            findAttr.text(value);

                            switch (attr){
                                case "codeshare":
                                    findAttr.parents("[data-parent=1]").css('visibility', value ? 'visible' : 'hidden');
                                    break;

                                case "SSR":
                                case "SSR_INFO":
                                    findAttr.parents("[data-parent=1]").attr('class', value ? "ssr" : "blank");
                                    break;

                                case "outbound":
                                case "inbound":
                                     findAttr.parents("[data-parent=1]").attr('class', value ? "transfer-" + attr : "blank");
                                    break;

                                default:
                                    break;
                            }

                        }
                    }

                    if ($.inArray(attr, ["first_name", "last_name"]) !== -1){
                        seatTooltip.find('[data-var=' + attr + ']').text(value);
                    }

                });
            }
            else {
                seatTooltip = seatInfo;
                seatNumber = id;

                if (_this.hasClass('first-class')) {
                    cabin = SEAT_FIRST_CLASS;
                }
                else if (_this.hasClass('business-class')) {
                    cabin = SEAT_BUSINESS_CLASS;
                }
                else if (_this.hasClass('economy-plus-class')) {
                    cabin = SEAT_ECONOMY_PLUS_CLASS;
                }
                else if (_this.hasClass('economy-class')) {
                    cabin = SEAT_ECONOMY_CLASS;
                }
                else {
                    cabin = "";
                }

                data = GetSeatDescription(seatNumber, cabin);
                
                $.each(data, function (attr, value) {
                    findAttr = seatTooltip.find('.' + attr);
                    if (findAttr.length) {
                        if (attr.indexOf('img') > -1) {
                            if ($.isArray(value)) {
                                findAttr.children().remove();
                                $.each(value, function (i, item) {
                                    findAttr.append('<img src = "' + item + '" />');
                                });
                            }
                            else {
                                findAttr.attr('src', value);
                            }
                        }
                        else {
                            findAttr.text(value);
                        }
                    }
                });
            }
            seatTooltip.stop().fadeIn(500);
            seatTooltip.offset({
                top: _this.offset().top + _this.height() + 13,
                left: _this.offset().left - 16
            });
        }
    },

    mouseleave: function () {
        var _this = $(this), id = _this.attr('id'), seatTooltip = $('.passenger-popup-info'),
            seatInfo = $('.seatTooltip');

        seatInfo.stop().fadeOut(1000);
        seatTooltip.stop().fadeOut(1000);
    },

    dblclick : function () {
        var _this = $(this), id = _this.attr('id'), booked = _this.hasClass('booked'), passenger_id;

        if (typeof id !== 'undefined') {
            if (booked) {
                passenger_id =  _this.attr('passenger_id');
                passengerLink(passenger_id);
            }
        }
    }
});

function passengerLink(passengerID) {

    switch (AIRLINE) {
        case "GSRM":
        case "FRAAI":
        case "SCO":
        case "AVIAM":
            return "#";

        case "QAZAQ_AIR":
        case "TAJIK_AIR":
        default:
            window.open(getPassengerLink(passengerID), '_blank');
    }
}


function MapPassengersBySeat(passengers){
    if (typeof passengers !== "undefined") {
        var additionalClass, ssrFound, outboundFound, inboundFound, csFound;
        $.each(passengers, function (i, item) {
            var findElement, seat = item.seat_number, match, seatInt;

            if (seat) {
                try {
                    match = /(\d{1,2})(\w{1,2})/.exec(seat);

                    if (typeof match[1] !== 'undefined' && typeof match[2] !== 'undefined') {
                        seatInt = parseInt(match[1]) + "" + match[2];
                        findElement = $('#' + seatInt);
                        if (findElement.length) {
                            additionalClass = "";
                            ssrFound = inboundFound = outboundFound = csFound = false;

                            $.each(item, function (attr, value) {
                                findElement.attr(attr, value);
                                if ($.inArray(attr, ["SSR", "SSR_INFO"]) !== -1 && value) {
                                    ssrFound = true;
                                }
                                if (attr == "outbound" && value) {
                                    outboundFound = true;
                                }
                                if (attr == "inbound" && value) {
                                    inboundFound = true;
                                }
                                if (attr == "codeshare" && value) {
                                    csFound = true;
                                }
                            });


                            if (ssrFound) {
                                additionalClass = "ssr";
                            }
                            if (outboundFound) {
                                additionalClass += additionalClass ? "-outbound" : "outbound";
                            }
                            if (inboundFound) {
                                additionalClass += additionalClass ? "-inbound" : "inbound";
                            }

                            findElement.addClass('booked');

                            if (additionalClass) {
                                findElement.addClass(additionalClass);
                            }

                            if (csFound) {
                                findElement.addClass("codeshare");
                            }
                        }
                    }
                }
                catch (e) {
                    console.log(e)
                }
            }
        });
    }
}

function AirplaneConfig(acConfig){
    var acConfig = [], data = [], label, column, i, j, string = "", emptyRight = 0, emptyLeft = 0;

    if (acConfig['e'] !== "undefined"){
        acConfig['e'] = acConfig['e'];
    }

    /*
    if (typeof aircraft !== "undefined"){
        switch (aircraft){
            case AIRCRAFT_B737_900:
                acConfig = {
                    a : {
                        rowStart    : 1,
                        rowEnd     : 1,
                        columns     : [ 'F',  '_' ,  'A', 'A']
                    },
                    b : {
                        rowStart    : 2, //1,
                        rowEnd     : 4,
                        columns     : [ 'F', 'E', 'D', '_' ,  'C', 'B', 'A'],
                        //columns     : [ 'F','D', '_' ,  'C', 'A'],
                        extraSpace  : [10, 11],
                        emptySeats     : {
                            rows     :  [3], // For Quicker Performance Show Rows That is Affected
                            details  :
                            {
                                3 : ['D', 'C']     // Index is Row Number.
                            }
                        }
                    },
                    e : {
                        rowStart    : 5,
                        rowEnd     : 32,
                        columns     : ['G', 'F', '_', 'E', 'D', 'C', '_', 'B', 'A'],
                        //columns     : ['F', 'E', 'D', '_', 'C', 'B', 'A'],

                        // Extra space after rows
                        extraSpace  : [10, 11],

                    }
                };

                break;
            case AIRCRAFT_B737_800:
                acConfig = {
                    e : {
                        rowStart    : 1,
                        rowEnd     : 32,
                        columns     : ['F', 'E', 'D', '_', 'C', 'B', 'A'],
                        extraSpace  : [15, 16],
                        emptySeats     : {
                            rows     :  [1], // For Quicker Performance Show Rows That is Affected
                            details  :
                            {
                                1 : ['D', 'E', 'F']     // Index is Row Number.
                            }
                        }
                    }
                };

                break;
            case AIRCRAFT_B737_300:
                acConfig = {
                    e : {
                        rowStart    : 1,
                        rowEnd     : 24,
                        columns     : ['F', 'E', 'D', '_', 'C', 'B', 'A'],
                        extraSpace  : [11, 12],
                        emptySeats     : {
                            rows     :  [12], // For Quicker Performance Show Rows That is Affected
                            details  :
                            {
                                12 : ['A', 'F']     // Index is Row Number.
                            }
                        }
                    }
                };
                break;
            default :
                break;
        }
    }
    */

    /*$.each(acConfig, function(cabin, object){
        for (i = object.rowStart; i <= object.rowEnd; i++){
            string = "";
            emptyRight = 0;
            emptyLeft = 0;

            for (j = 0; j < object.columns.length; j++) {
                column = object.columns[j];
                if (typeof object.emptyRow !== 'undefined' && Object.keys(object.emptyRow).length > 0 && object.emptyRow.row == i) {
                    switch (object.emptyRow.side){
                        case 'left':
                            if (column == '_') {
                                emptyLeft = 1;
                            }

                            if (!emptyLeft){
                                string += '_';
                                continue;
                            }

                            break;

                        case 'right':
                        default:
                            if (column == '_') {
                                emptyRight = 1;
                            }

                            if (emptyRight){
                                string += '_';
                                continue;
                            }
                            break;
                    }
                }
                if (column == '_') {
                    string += column;
                }
                else {
                    label = i + "" + column;
                    string += cabin + "[" + label + "," + label + "]";
                }
            }
            data.push(string);
        }
    });*/

    return acConfig;
}

function GetSeatDescription(seat_number, cabin){

    var seat_row = parseInt(seat_number), data = {},
        img_path = baseUrl + "/assets/img/aircraft/parts/";

    data.seat_number = seat_number;
    data.seat_description_text = "is a standard " + cabin + " seat";

    switch (cabin) {
        case SEAT_BUSINESS_CLASS:
            data.seat_comfort = "Recliner";
            data.seat_img = img_path + "seat_recliner.jpg";
            break;

        case SEAT_ECONOMY_PLUS_CLASS:
            data.seat_comfort = "Standard";
            break;

        case SEAT_ECONOMY_CLASS:
            data.seat_comfort = "Standard";
            data.seat_img = img_path + "seat_standard.jpg";
            data.seat_service_img = [];
            data.seat_service_descriptions = "";
            break;

    }
    return data;
}

function GetSeatDescription2(acType, seat_number, cabin){

    var seat_row = parseInt(seat_number), data = {},
        img_path = baseUrl + "/assets/img/aircraft/parts/";

    data.seat_number = seat_number;
    data.seat_description_text = "is a standard " + cabin + " seat";

    switch (acType) {
        case AIRCRAFT_B737_900:
        switch (cabin) {
            case SEAT_BUSINESS_CLASS:
                data.seat_service_img = [img_path + "plug_white.png", img_path + "tv_white.png"];
                data.seat_service_descriptions = "On Demand TV & AC Power";
                if (seat_row == 1) {
                    data.seat_comfort = "Recliner & Bulkhead";
                    data.seat_description_text = "may have restricted legroom and the close proximity to the galleys " +
                    "may be bothersome. There is no floor storage for this seat during " +
                    "take-off and landing.";
                    data.seat_img = img_path + "seat_recliner_and_bulkhead.jpg";

                }
                else if (seat_row == 4) {
                    data.seat_description_text = "is a standard Business Class seat however noise from the more" +
                    "crowded economy cabin may be disruptive";
                    data.seat_img = img_path + "seat_recliner_and_bulkhead.jpg";
                }
                else {
                    data.seat_comfort = "Recliner";
                    data.seat_img = img_path + "seat_recliner.jpg";
                }
                break;
            case SEAT_ECONOMY_PLUS_CLASS:
                data.seat_comfort = "Standard";
                break;
            case SEAT_ECONOMY_CLASS:
                if (seat_row == 5) {
                    data.seat_description_text = "is a standard economy seat. However, this seat may have restricted legroom" +
                    "due to the position of the bulkhead. Passengers traveling with infants are" +
                    "often seated hear as there is a bassinet position in this row.";
                    data.seat_comfort = "Standard & Bulkhead";
                    data.seat_img = img_path + "seat_standard_and_bulkhead.jpg";
                }
                else if (seat_row == 10) {
                    data.seat_img = img_path + "seat_standard_no_recline.jpg";
                    data.seat_description_text = "does not recline due to the exit row behind.";
                }
                else if (seat_row == 12) {
                    data.seat_img = img_path + "seat_economy_exit_row.jpg";
                    data.seat_comfort = "Standard & Exit Row";
                    data.seat_description_text = "is an Economy Class seat Exit Row seat that may have extra legroom." +
                    "The tray table is in the armrest, making the armrest immovable and " +
                    "slightly reducing seat width. There may be no floor storage during " +
                    "take-off and landing.";
                }
                else if (seat_row == 32) {
                    data.seat_img = img_path + "seat_last_row.jpg";
                    data.seat_description_text = "is an Economy Class seat in the last row of the plane that may " +
                    "not recline. The close proximity to the lavatories and galley " +
                    "may be bothersome.";
                }
                else {
                    data.seat_comfort = "Standard";
                    data.seat_img = img_path + "seat_standard.jpg";
                }
                data.seat_service_img = [];
                data.seat_service_descriptions = "";
                break;
        }
        break;

        case AIRCRAFT_B737_800:
            switch (cabin) {
                case SEAT_ECONOMY_CLASS:
                    if (seat_row == 1) {
                        data.seat_description_text = "is a standard economy seat. However, this seat may have restricted legroom" +
                        "due to the position of the bulkhead. Passengers traveling with infants are" +
                        "often seated hear as there is a bassinet position in this row.";
                        data.seat_comfort = "Standard & Bulkhead";
                        data.seat_img = img_path + "seat_standard_and_bulkhead.jpg";
                    }
                    else if (seat_row == 13) {
                        data.seat_img = img_path + "seat_standard_no_recline.jpg";
                        data.seat_description_text = "does not recline due to the exit row behind.";
                    }
                    else if (seat_row == 33) {
                        data.seat_img = img_path + "seat_last_row.jpg";
                        data.seat_description_text = "is an Economy Class seat in the last row of the plane that may" +
                                                     "not recline. The close proximity to the lavatories and galley" +
                                                     "may be bothersome.";
                    }
                    else {
                        data.seat_comfort = "Standard";
                        data.seat_img = img_path + "seat_standard.jpg";
                    }
                    data.seat_service_img = [];
                    data.seat_service_descriptions = "";
                    break;
            }
            break;

        case AIRCRAFT_B737_300:
            switch (cabin) {
                case SEAT_ECONOMY_CLASS:
                    if (seat_row == 1) {
                        data.seat_description_text = "is a standard economy seat. However, this seat may have restricted legroom" +
                        "due to the position of the bulkhead. Passengers traveling with infants are" +
                        "often seated hear as there is a bassinet position in this row.";
                        data.seat_comfort = "Standard & Bulkhead";
                        data.seat_img = img_path + "seat_standard_and_bulkhead.jpg";
                    }
                    else if (seat_row == 11) {
                        data.seat_img = img_path + "seat_standard_no_recline.jpg";
                        data.seat_description_text = "is an Economy Class seat that may have limited recline"+
                                                    "due to the exit row behind.";
                    }
                    else if (seat_row == 13) {
                        data.seat_img = img_path + "seat_economy_exit_row.jpg";
                        data.seat_comfort = "Standard & Exit Row";
                        data.seat_description_text = "is an Economy Class seat Exit Row seat that may have extra legroom." +
                                                    "The tray table is in the armrest, making the armrest immovable and" +
                                                    "slightly reducing seat width. There may be no floor storage during" +
                                                    "take-off and landing.d.";
                    }
                    else if (seat_row == 24) {
                        data.seat_img = img_path + "seat_last_row.jpg";
                        data.seat_description_text = "is an Economy Class seat in the last row of the plane that may" +
                        "not recline. The close proximity to the lavatories and galley" +
                        "may be bothersome.";
                    }
                    else {
                        data.seat_comfort = "Standard";
                        data.seat_img = img_path + "seat_standard.jpg";
                    }
                    data.seat_service_img = [];
                    data.seat_service_descriptions = "";
                    break;
            }
            break;
    }
    return data;
}

function MapSeats(passengers) {

    var $cart = $('#selected-seats'),
        $counter = $('#counter'),
        $total = $('#total'),
        sc = $('#seat-map').seatCharts({
            map: acConfig,
            seats: {
                a: {
                    price: 100,
                    classes: 'business-class', //your custom CSS class
                    category: 'Business Class',
                    description: 'Fair priced seat!'
                },

                b: {
                    price: 100,
                    classes: 'business-class', //your custom CSS class
                    category: 'Business Class',
                    description: 'Fair priced seat!'
                },

                w: {
                    price: 60,
                    classes: 'economy-plus-class', //your custom CSS class
                    category: 'Economy Plus Class',
                    description: 'Fair priced seat!'
                },

                e: {
                    price: 40,
                    classes: 'economy-class', //your custom CSS class
                    category: 'Economy Class'
                }

            },
            naming: {
                left: false,
                top: false,
                getLabel: function (character, row, column) {
                    return firstSeatLabel++;
                }
            },
            legend: {
                node: $('#legend'),
                items: [
                    ['a', 'available', 'First Class'],
                    ['b', 'available', 'Business Class'],
                    ['w', 'available', 'Economy Plus Class'],
                    ['e', 'available', 'Economy Class'],
                    ['u', 'unavailable', 'Already Booked']
                ]
            },

            click: function () {
                if (this.status() == 'available') {
                    //let's create a new <li> which we'll add to the cart items
                    $('<li>' + this.data().category + ' Seat # ' + this.settings.label + ': <b>$' + this.data().price + '</b> <a href="#" class="cancel-cart-item">[cancel]</a></li>')
                        .attr('id', 'cart-item-' + this.settings.id)
                        .data('seatId', this.settings.id)
                        .appendTo($cart);

                    /*
                     * Lets update the counter and total
                     *
                     * .find function will not find the current seat, because it will change its stauts only after return
                     * 'selected'. This is why we have to add 1 to the length and the current seat price to the total.
                     */
                    $counter.text(sc.find('selected').length + 1);
                    $total.text(recalculateTotal(sc) + this.data().price);

                    return 'selected';
                } else if (this.status() == 'selected') {
                    //update the counter
                    $counter.text(sc.find('selected').length - 1);
                    //and total
                    $total.text(recalculateTotal(sc) - this.data().price);

                    //remove the item from our cart
                    $('#cart-item-' + this.settings.id).remove();

                    //seat has been vacated
                    return 'available';
                } else if (this.status() == 'unavailable') {
                    //seat has been already booked
                    return 'unavailable';
                } else {
                    return this.style();
                }
            }
        });

    $(document).find('#selected-seats').on('click', '.cancel-cart-item', function () {
        //let's just trigger Click event on the appropriate seat, so we don't have to repeat the logic here
        sc.get($(this).parents('li:first').data('seatId')).click();
    });

    $(document).find('.seatCharts-seat.seatCharts-cell').on({
        mouseenter: function () {
            var _this = $(this), id = _this.attr('id'), seatTooltip = $('.passenger-popup-info'),
                info, seatSearch, findAttr, seatInfo = $('.seatTooltip'), seatNumber, cabin, data;

            if (typeof id !== 'undefined') {

                seatSearch = sc.get(id);

                if (seatSearch) {
                    info = sc.get(id);
                    console.log(info)
                    if (info && info.data.info) {
                        $.each(info.data.info, function (attr, value) {
                            findAttr = seatTooltip.find('.' + attr);
                            if (findAttr.length) {
                                if (attr == 'profile-picture') {
                                    findAttr.attr('src', value);
                                }
                                else {
                                    findAttr.text(value);
                                }
                            }
                        });
                    }
                    else {
                        seatTooltip = seatInfo;
                        seatNumber = _this.text();

                        if (_this.hasClass('first-class')) {
                            cabin = SEAT_FIRST_CLASS;
                        }
                        else if (_this.hasClass('business-class')) {
                            cabin = SEAT_BUSINESS_CLASS;
                        }
                        else if (_this.hasClass('economy-plus-class')) {
                            cabin = SEAT_ECONOMY_PLUS_CLASS;
                        }
                        else if (_this.hasClass('economy-class')) {
                            cabin = SEAT_ECONOMY_CLASS;
                        }
                        else {
                            cabin = "";
                        }

                        data = GetSeatDescription(seatNumber, cabin);

                        $.each(data, function (attr, value) {
                            findAttr = seatTooltip.find('.' + attr);
                            if (findAttr.length) {
                                if (attr.indexOf('img') > -1) {
                                    if ($.isArray(value)) {
                                        findAttr.children().remove();
                                        $.each(value, function (i, item) {
                                            findAttr.append('<img src = "' + item + '" />');
                                        });
                                    }
                                    else {
                                        findAttr.attr('src', value);
                                    }
                                }
                                else {
                                    findAttr.text(value);
                                }
                            }
                        });
                    }
                }

                seatTooltip.show();
                seatTooltip.offset({
                    top: _this.offset().top + _this.height() + 13,
                    left: _this.offset().left - 16
                });
            }
        },

        mouseleave: function () {
            var _this = $(this), id = _this.attr('id'), seatTooltip = $('.passenger-popup-info'),
                seatInfo = $('.seatTooltip');

            seatInfo.hide();
            seatTooltip.hide();
        }
    });

    $.each(passengers, function (i, item) {
        var findElement, seat = item.seat_number, seatSearch, match, seatInt;

        if (seat) {
            match = /(\d{1,2})(\w{1,2})/.exec(seat);

            if (typeof match[1] !== 'undefined' && typeof match[2] !== 'undefined') {
                seatInt = parseInt(match[1]) + "" + match[2];
                findElement = $('#' + seatInt);
                if (findElement.length) {
                    $.each(item, function (attr, value) {
                        findElement.attr(attr, value);
                    });
                    findElement.addClass('booked');
                }

                seatSearch = sc.get(seatInt);

                if (seatSearch) {
                    sc.get(seatInt).status('unavailable');
                    sc.get(seatInt).data.info = item;
                }
            }
        }
    });

}

function recalculateTotal(sc) {
    var total = 0;

    //basically find every selected seat and sum its price
    sc.find('selected').each(function () {
        total += this.data().price;
    });

    return total;
}