/**
 * Created by Dilovar Tursunov on 27.08.14.
 */

"use strict";

var
    _MS_PER_DAY = 1000 * 60 * 60 * 24,
    FLIGHT_CREW_CAPTAINS = "captains",
    FLIGHT_CREW_FIRST_OFFICERS = "first_officers",
    FLIGHT_CREW_FLIGHT_ATTENDANTS = "flight_attendants",
    C_BAGGAGE_WEIGHT = 30,
    Y_BAGGAGE_WEIGHT = 20,
    EXCESS_BAGGAGE_RATE = 3,
    CARGO_RATE = 3,
    MAIL_RATE = 3,
    T_MAINTENANCE = "maintenance",
    T_FLIGHT = "flight",
    FLIGHT_AVAILABLE = "available",
    FLIGHT_DELAYED = "delayed",
    FLIGHT_CANCELLED = "cancelled",
    FLIGHT_DIVERTED = "diversion",
    FLIGHT_MAINTENANCE = "maintenance",
    MAX_HOURS_FOR_MOVE = 24,

    CREW_TYPE_SUP = "SUP",
    CREW_TYPE_STANDBY = "STANDBY",
    CREW_TYPE_DHC = "DHC",
    CREW_TYPE_IN_FLIGHT = "IN_FLIGHT",

    timeline = null,
    emptyDate = "0000-00-00 00:00:00",
    inputDateFormat = "YYYY-MM-DD HH:mm:ss",
    outputDateFormat = "MMM DD, HH:mm",
    outputTimeFormat = "HH:mm",

    popupFlight = null,
    messageBlock = $("#fleetwatch_message_block"),
    flight_info_modal = $("#flight_info_modal");



function initializeTime(){
    updateTime();
    window.setInterval(updateTime, 1000);
}

initializeTime();
/**
 * Time UTC in Real Time
 */
function updateTime(){
    var timeNow = $('#timeNow'), now;
    if (timeNow.length > 0){
        //   time.innerText = new Date().toUTCString();
        now = new Date().toUTCString();
        now = now.split(' ')[4];
        timeNow.text(now +" GMT");
    }
}
google.load("visualization", "1");

    $(document).ready(function(){

        google.setOnLoadCallback(drawVisualization);

    });

    // Set callback to run when API is loaded


    // Called when the Visualization API is loaded.
    function drawVisualization() {

    // Create and populate a data table.
    var data = new google.visualization.DataTable(),
        today = new Date(), date = new Date(), date2 = new Date(),
        start_time = date.setHours(date.getHours() - 12),
        end_time = date2.setHours(date2.getHours() + 12);

    start_time = moment(start_time).utc();
    end_time = moment(end_time).utc();


    // if was set go to date, use it as default date for timeline
    if (typeof goToDate !== "undefined" && goToDate != false) {
        date = new Date(goToDate);
        date2 = new Date(goToDate);
        start_time = date.setHours(0, 0, 0);
        end_time = date2.setHours(23, 59, 59);
        var d = date, d2 = date2,
            start_visible_time = moment(d.setHours(today.getHours() - 12)).format("YYYY-MM-DD HH:mm:ss"),
            end_visible_time = moment(d2.setHours(today.getHours() + 12)).format("YYYY-MM-DD HH:mm:ss");
        $("#start_visible_period").val(start_visible_time);
        $("#end_visible_period").val(end_visible_time);
    }

    start_time = moment(start_time).format("YYYY-MM-DD HH:mm:ss");
    end_time = moment(end_time).format("YYYY-MM-DD HH:mm:ss");

    if (typeof startVisibleDate !== "undefined" && startVisibleDate != false && typeof endVisibleDate !== "undefined" && endVisibleDate != false) {
        start_time = moment(startVisibleDate).format("YYYY-MM-DD HH:mm:ss");
        end_time = moment(endVisibleDate).format("YYYY-MM-DD HH:mm:ss");
    }

    data.addColumn("datetime", "start");
    data.addColumn("datetime", "end");
    data.addColumn("string", "content");
    data.addColumn("string", "group");
    data.addColumn("string", "className");

    if (json.length) {
        var flights = prepareDataForTimeline(json);
        data.addRows(flights);
    }

    // specify options
    var options = {
        stackEvents: true,
        //start: start_time,
        //end: end_time,
        editable: true,
        animate: true,
        eventMargin: 5,
        eventMarginAxis: 5,
        cluster: true,
        axisOnTop: true,
        snapEvents: false,
        dragAreaWidth: 10,
        groupMinHeight: 50,
        groupsWidth: "100px",
        min: new Date(2013, 1, 1),
        max: new Date(today.setMonth(today.getMonth() + 6)),                // upper limit of visible range
        zoomable: false,
        zoomMin: 1000 * 60 * 60 * 24,         // 4 hours in milliseconds
        zoomMax: 1000 * 60 * 60 * 24,     // 7 days in milliseconds
        showButtonNew: false,
        showNavigation: false,
        showMajorLabels: true,
        width: "100%",
        height: "auto",
        layout: "box",
        groupsChangeable: true,
        groupsOrder: function (a, b) {
            if (a.content == b.content) {
                return 0;
            }
            return (a.content < b.content) ? 1 : -1;
        }
    };

    // Instantiate our timeline object
    timeline = new links.Timeline(document.getElementById("mytimeline"));

    // Draw our timeline with the created data and options
    timeline.setOptions(options);
    timeline.draw(data);
    //timeline.draw(data, options);

    var start = new Date(
        moment(start_time).get('year'),
        moment(start_time).get('month'),
        moment(start_time).get('date'),
        moment(start_time).get('hour'),
        moment(start_time).get('minute'),
        moment(start_time).get('second')
    );

    var end = new Date(
        moment(end_time).get('year'),
        moment(end_time).get('month'),
        moment(end_time).get('date'),
        moment(end_time).get('hour'),
        moment(end_time).get('minute'),
        moment(end_time).get('second')
    );

    timeline.setVisibleChartRange(start, end);

    var now = new Date();
    var current_datetime = moment({
        year: now.getUTCFullYear(),
        month: now.getUTCMonth(),
        day: now.getUTCDate(),
        hour: now.getUTCHours(),
        minute: now.getUTCMinutes(),
        second: now.getUTCSeconds()
    });
    timeline.setCurrentTime(current_datetime);

    //
    /**
     * Delete flight item event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "delete",
        function () {
            timeline.cancelDelete();

            if (!editable) {
                // My Temp Edit
                return false;
            }

            var sel = timeline.getSelection(), row;
            if (sel.length) {
                if (sel[0].row != undefined) {
                    row = sel[0].row;
                }
            }

            bootbox.confirm("Flight will be cancelled, are you sure?", function (result) {
                if (result) {
                    var $body = $("body"), flightData = getSelectedEvent(),
                        request, requestData = $.ajaxSetup({
                            type: "GET",
                            dataType: "json"
                        });

                    if (!flightData) {
                        return false;
                    }

                    $body.addClass("loading");
                    if (flightData.type == T_MAINTENANCE) {
                        requestData = {
                            url: baseUrl + "/aircraft/ajax-delete-maintenance",
                            data: {
                                maintenance_id: flightData.id
                            }
                        };
                    } else if (flightData.type == T_FLIGHT) {
                        requestData = {
                            url: baseUrl + "/flight/ajax-delete-flight",
                            data: {
                                flight_id: flightData.id
                            }
                        };
                    }
                    request = $.ajax(requestData);
                    request.done(function (data) {
                        if (typeof data.success !== "undefined") {
                            showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                            if (flightData.type == T_FLIGHT) {
                                // clear the bottom form
                                clearFlightForm();
                            } else if (flightData.type == T_MAINTENANCE) {
                                //
                            }
                            timeline.deleteItem(row);
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                    });
                    request.always(function () {
                        $body.removeClass("loading");
                    });
                } else {
                    timeline.setSelection([]);
                }
            });
        }
    );

    /**
     * Change flight item position event listener
     * @return void
     */
    google.visualization.events.addListener(timeline, "changed",
        function () {
            var sel = timeline.getSelection();
            // My Temp Edit
            timeline.cancelChange();
            return false;
            ///

            if (sel.length) {
                if (sel[0].row != undefined) {
                    var row = sel[0].row;
                    var itemFlight = timeline.getItem(row);
                }
            }

            if (typeof itemFlight === "undefined") {
                timeline.cancelChange();
                timeline.setSelection([]);
                return false;
            }

            // validate available hours
            var arrivalDate = moment(itemFlight.end),
                duration = moment.duration(moment().diff(arrivalDate)),
                hours = duration.asHours();
            if (hours > MAX_HOURS_FOR_MOVE) {
                showMessage("Flight cannot be updated due to exceeding  " + MAX_HOURS_FOR_MOVE + " hours period", "Warning!",
                    MESSAGE_WARNING, messageBlock);
                timeline.cancelChange();
                return false;
            }

            if (confirm("Flight dates was changed. Do you want to save change?") === true) {
                var $body = $("body"), flightData = getSelectedEvent(),
                    startTime = moment(itemFlight.start).format("YYYY-MM-DD HH:mm:ss"),
                    endDate = moment(itemFlight.end).format("YYYY-MM-DD HH:mm:ss"),
                    request, requestData = $.ajaxSetup({
                        type: "GET",
                        dataType: "json"
                    });

                if (!flightData) {
                    return false;
                }

                $body.addClass("loading");
                if (flightData.type == T_MAINTENANCE) {
                    requestData = {
                        url: baseUrl + "/aircraft/ajax-change-maintenance",
                        data: {
                            start_date: startTime,
                            end_date: endDate,
                            maintenance_id: flightData.id,
                            aircraft_name: itemFlight.group
                        }
                    };
                } else if (flightData.type == T_FLIGHT) {
                    requestData = {
                        url: baseUrl + "/flight/ajax-change-flight",
                        data: {
                            start_date: startTime,
                            end_date: endDate,
                            flight_id: flightData.id,
                            aircraft_name: itemFlight.group
                        }
                    };
                }
                request = $.ajax(requestData);
                request.done(function (data) {
                    if (typeof data.success !== "undefined") {
                        showMessage(data.message, "Success!", MESSAGE_SUCCESS, messageBlock);
                        if (flightData.type == T_FLIGHT) {
                            //
                        } else if (flightData.type == T_MAINTENANCE) {
                            //
                        }

                    } else {
                        showMessage(data.message, data.title, MESSAGE_DANGER, messageBlock);
                        timeline.setSelection([]);
                        timeline.changeItem(row, itemFlight);
                    }
                    // update page
                    window.location = baseUrl + "/fleetwatch/index?go_to_date=" + moment(itemFlight.start).format("YYYY-MM-DD");
                });
                request.fail(function (jqXHR, textStatus) {
                    showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                });
                request.always(function () {
                    $body.removeClass("loading");
                });
            } else {
                timeline.cancelChange();
                timeline.setSelection([]);
                return false;
            }
        }
    );

    /**
     * Select exact flight event handler
     * @return void
     */
    google.visualization.events.addListener(timeline, "select", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;

        var _this = $(this), $body = $("body"), requestData,
            flightData = getSelectedEvent(), request;

        if (!flightData) {
            return false;
        }
        if (flightData.type == T_MAINTENANCE) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/aircraft/ajax-get-maintenance",
                data: {
                    maintenance_id: flightData.id
                }
            };
        } else if (flightData.type == T_FLIGHT) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/flight/ajax-get-flight",
                data: {
                    flight_id: flightData.id
                }
            };
        }
        request = $.ajax(requestData);
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                if (flightData.type == T_FLIGHT) {
                    fillFlightForm(data);
                    fillMVTMessages(data);
                    DisableStdSta();
                } else if (flightData.type == T_MAINTENANCE) {

                }
            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
        });
    });

    /**
     * Timeline range was changed event handler
     * @return void
     */
    google.visualization.events.addListener(timeline, "rangechanged",
        function (dates) {
            var now = new Date();

            /*
             if ((dates.start <= now && now <= dates.end) && dateDiffInDays(dates.start, dates.end) <= 4) {
             // range is not changed so many to send AJAX request
             return false;
             }
             */
            var request, loading = $("#loading-fleetwatch-data"), i, l,
                requestData = {
                    type: "GET",
                    dataType: "JSON",
                    url: baseUrl + "/fleetwatch/ajax-get-range",
                    data: {
                        start_date: moment(dates.start).format("YYYY-MM-DD HH:mm:ss"),
                        end_date: moment(dates.end).format("YYYY-MM-DD HH:mm:ss")
                    }
                };

            loading.show();
            request = $.ajax(requestData);
            request.done(function (data) {
                if (typeof data.success !== "undefined") {
                    var flights = [], flightItem, maintenanceItem, flt, jsonData = data.jsonData;
                    // recreate timeline
                    /*if (typeof data.flights !== "undefined" && data.flights.length) {
                     for (i = 0, l = data.flights.length; i < l; i++) {
                     flightItem = data.flights[i];
                     flt = {
                     "start": getStartDate(flightItem),
                     "end": getEndDate(flightItem),
                     "group": getFlightGroup(flightItem),
                     "className": getFlightClassName(flightItem)
                     };

                     flt.content = getFlightContent(flightItem, flt.start, flt.end);

                     flights.push(flt);
                     }
                     }

                     if (typeof data.aircraftMaintenance !== "undefined" && data.aircraftMaintenance.length) {
                     for (i = 0, l = data.aircraftMaintenance.length; i < l; i++) {
                     maintenanceItem = data.aircraftMaintenance[i];
                     flights.push({
                     "start": moment(maintenanceItem.arrival_time).toDate(),
                     "end": moment(maintenanceItem.departure_time).toDate(),
                     "content": getMaintenanceContent(maintenanceItem),
                     "group": getFlightGroup(maintenanceItem),
                     "className": FLIGHT_MAINTENANCE
                     });
                     }
                     }*/
                    flights = prepareDataForTimeline(jsonData, true);
                    if (flights.length) {
                        timeline.setData(flights);
                        timeline.redraw();
                    }
                } else {
                    showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
                }
                $("#start_visible_period").val(moment(dates.start).format("YYYY-MM-DD HH:mm:ss"));
                $("#end_visible_period").val(moment(dates.end).format("YYYY-MM-DD HH:mm:ss"));

            });
            request.fail(function (jqXHR, textStatus) {
                showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
            });
            request.always(function () {
                loading.hide();
            });
        }
    );
}

    function DisableStdSta() {
        var std = $('#std'), sta = $("#sta");

        std.attr('disabled', 'disabled');
        sta.attr('disabled', 'disabled');

        std.removeAttr('required');
        sta.removeAttr('required');
    }

    /**
     * Get start date
     * @param flight
     * @returns {*}
     */
    function getStartDate(flight) {
        var date;
        if (flight.atd) {
            date = moment(flight.atd, inputDateFormat).toDate();
        } else if (flight.etd) {
            date = moment(flight.etd, inputDateFormat).toDate();
        } else if (flight.ptd) {
            date = moment(flight.ptd, inputDateFormat).toDate();
        } else {
            date = moment(flight.std, inputDateFormat).toDate();
        }
        return date;
    }

    /**
     * Get end date
     * @param flight
     * @returns {*}
     */
    function getEndDate(flight) {
        var date;
        if (flight.ata) {
            date = moment(flight.ata, inputDateFormat).toDate();
        } else if (flight.eta) {
            date = moment(flight.eta, inputDateFormat).toDate();
        } else if (flight.pta) {
            date = moment(flight.pta, inputDateFormat).toDate();
        } else {
            date = moment(flight.sta, inputDateFormat).toDate();
        }
        return date;
    }

    /**
     * Get flight content
     * @param flight
     * @return string
     */
    function getFlightContent(flight, departure, arrival) {
        var diff = moment(arrival).diff(departure, 'm'), result, diversion;

        console.log(flight)

        if (flight.is_diversion) {
            diversion = flight.diversion;
            result = "<div id='flight-" + flight.id + "' class='row fw-flight-item diversion'>" +
                "<div class='flight_number_diversion_box_left diversionBox'>" +
                "<span class='flight_number_diversion_box_left'>" + flight.flight_number.departure_airport + "</span>" +
                "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
                "<span class='flight_number_diversion_box_right'>" + diversion['diversion_airport_code'] + "</span>" +
                "</div>" +
                "<div class='flight_number_diversion_box_center flightStandard'>" +
                "<span class='text-center'>" + CURRENT_IATA_CODE + " " + flight.flight_number.flight_number + "</span>" +
                "</div>" +
                "<div class='flight_number_diversion_box_right diversionBox'>" +
                "<span class='flight_number_diversion_box_left'>" + diversion['diversion_airport_code'] + "</span>" +
                "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>" +
                "<span class='flight_number_diversion_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
                "</div>" +
                "</div>";
        }
        else {
            if (diff < 90) {
                result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                    "<div class='col-sm-12 flightStandard'>" +
                    "<span class='flight_number_box_small'>" + flight.flight_number.flight_number + "</span>" +
                    "</div>" +
                    "</div>";
            }
            else {

                var fNo;
                if ($.inArray(flight.flightNumber.flightType.type, [ TAJIKAIR, OTHERAIRLINES ])){
                    fNo = flight.flight_number.flight_number;
                }
                else {
                    fNo = CURRENT_IATA_CODE + " " + flight.flight_number.flight_number;
                }
                result = "<div id='flight-" + flight.id + "' class='row fw-flight-item'>" +
                    "<div class='col-sm-12 flightStandard'>" +
                    "<span class='flight_number_box_left'>" + flight.flight_number.departure_airport + "</span>" +
                    "<span class='flight_number_box_center'>" + fNo + "</span>" +
                    "<span class='flight_number_box_right'>" + flight.flight_number.arrival_airport + "</span>" +
                    "</div>" +
                    "</div>";
            }
        }
        return result;
    }

    /**
     *
     * @param maintenance
     * @returns {string}
     */
    function getMaintenanceContent(maintenance) {
        return "<div id='maintenance-" + maintenance.id + "' class='fw-flight-item'>" +
            maintenance.note + " (" + maintenance.location_code + ")" +
            "</div>";
    }

    /**
     * Get flight group name
     * @param flight
     * @returns {*}
     */
    function getFlightGroup(flight) {
        return flight.aircraft.name;
    }

    /**
     * Get flight class name
     * @param flight
     */
    function getFlightClassName(flight) {
        var className = FLIGHT_AVAILABLE;
        if (flight.is_diversion) {
            className = FLIGHT_DIVERTED;
        } else {
            if (flight.delay_id) {
                className = FLIGHT_DELAYED;
            } else {
                var atd, etd, std, diff;
                if (flight.atd) {
                    atd = moment(flight.atd, inputDateFormat);
                    std = moment(flight.std, inputDateFormat);
                    diff = atd.diff(std, "minutes");

                    if (atd > std && diff >= 3) {
                        className = FLIGHT_DELAYED;
                    }
                } else if (flight.etd) {
                    etd = moment(flight.etd, inputDateFormat);
                    std = moment(flight.std, inputDateFormat);
                    diff = etd.diff(std, "minutes");

                    if (etd > std && diff >= 3) {
                        className = FLIGHT_DELAYED;
                    }
                }
            }
        }
        return className;
    }

    /**
     * Parse flight information
     * @param data
     */
    var generalTabTemplateHTML = $("#general_tab_template");

    function parseFlight(data) {
        var flight = data.flight, generalTabTemplate, templateData,
            _general_tab_template = generalTabTemplateHTML.clone(),
            _title = $("#modal_title"), flightNumber = flight.flight_number;

        var flightNumText;

        if (typeof flight.flight_number.flight_type != "undefined" &&
            $.inArray(flight.flight_number.flight_type.type, [ TAJIKAIR, OTHERAIRLINES ]) != -1){
            flightNumText = flight.flight_number.flight_number;
        }
        else {
            flightNumText = CURRENT_IATA_CODE + " " + flight.flight_number.flight_number;
        }


        if (flight.cancelled_at){
            flightNumText += "(Cancelled)";

            if (flight.remark){
                flightNumText += " | Reason:" + flight.remark;
            }
        }

        _title.html($("<a></a>").text(flightNumText).attr('target', '_blank').attr('href',  baseUrl + "/flight-info/" + flight.id));

        if (generalTabTemplateHTML.length) {
            var html = _general_tab_template.html();
            generalTabTemplate = _.template(html);
            var captains = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_IN_FLIGHT),
                firstOfficers = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_IN_FLIGHT),
                flightAttendants = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_IN_FLIGHT),

                captainsDHC = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_DHC),
                firstOfficersDHC = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_DHC),
                flightAttendantsDHC = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_DHC),

                captainsStandby = getFlightCrewItems(FLIGHT_CREW_CAPTAINS, flight, CREW_TYPE_STANDBY),
                firstOfficersStandby = getFlightCrewItems(FLIGHT_CREW_FIRST_OFFICERS, flight, CREW_TYPE_STANDBY),
                flightAttendantsStandby = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_STANDBY),

                flightAttendantsSUP = getFlightCrewItems(FLIGHT_CREW_FLIGHT_ATTENDANTS, flight, CREW_TYPE_SUP);

            var pax_c_actual = (flight.pax_c_actual) ? parseInt(flight.pax_c_actual) : 0,
                pax_y_actual = (flight.pax_y_actual) ? parseInt(flight.pax_y_actual) : 0,
                allowance_baggage = (pax_c_actual + pax_y_actual == 0) ? "&mdash;" : pax_c_actual * C_BAGGAGE_WEIGHT + pax_y_actual * Y_BAGGAGE_WEIGHT,
                excess_baggage = (!flight.baggage || allowance_baggage == "&mdash;") ? "&mdash;" :
                    (((parseInt(flight.baggage) - allowance_baggage) < 0) ? 0 : (parseInt(flight.baggage) - allowance_baggage)),
                excess_baggage_revenue = (excess_baggage == "&mdash;") ? 0 : excess_baggage * EXCESS_BAGGAGE_RATE,
                cargo_revenue = (flight.cargo) ? parseInt(flight.cargo) * CARGO_RATE : 0,
                mail_revenue = (flight.mail) ? parseInt(flight.mail) * MAIL_RATE : 0,
                total_revenue = parseInt(cargo_revenue) + parseInt(mail_revenue) + parseInt(excess_baggage_revenue),
                std = moment(flight.std, inputDateFormat).format(outputDateFormat),
                sta = moment(flight.sta, inputDateFormat).format(outputDateFormat);

            console.log(flight.delays)

            templateData = {
                progressStatus : (flight.delays && flight.delays.length > 0) ? "danger" : "success",
                planeIcon: (flight.delays && flight.delays.length > 0) ?  baseUrl + "/assets/img/plane-delayed.png?3" : baseUrl + "/assets/img/plane-ontime.png?3",
                cancelled: flight.cancelled_at ? true : false,
                departureCityCode: flight.flight_number.departure_airport.iata,
                arrivalCityCode: flight.flight_number.arrival_airport.iata,
                flightBarPosition: getFlightProgressBarFlownPercentage(flight),
                planeWidth: getPlaneWidth(),
                planePosition: getPlanePosition(),
                departureCity: data.departure_city,
                arrivalCity: data.arrival_city,
                std: std,
                sta: sta,
                ptd: (flight.ptd == emptyDate || !flight.ptd) ? std : moment(flight.ptd, inputDateFormat).format(outputTimeFormat),
                pta: (flight.pta == emptyDate || !flight.pta) ? sta : moment(flight.pta, inputDateFormat).format(outputTimeFormat),
                etd: (flight.etd == emptyDate || !flight.etd) ? "&mdash;" : moment(flight.etd, inputDateFormat).format(outputTimeFormat),
                atd: (flight.atd == emptyDate || !flight.atd) ? "&mdash;" : moment(flight.atd, inputDateFormat).format(outputTimeFormat),
                abn: (flight.abn == emptyDate || !flight.abn) ? "&mdash;" : moment(flight.abn, inputDateFormat).format(outputTimeFormat),
                eta: (flight.eta == emptyDate || !flight.eta) ? "&mdash;" : moment(flight.eta, inputDateFormat).format(outputTimeFormat),
                ata: (flight.ata == emptyDate || !flight.ata) ? "&mdash;" : moment(flight.ata, inputDateFormat).format(outputTimeFormat),
                tdn: (flight.tdn == emptyDate || !flight.tdn) ? "&mdash;" : moment(flight.tdn, inputDateFormat).format(outputTimeFormat),
                delays: implode(flight.delaysString, '<br/>'),
                pax_actually_c: flight.pax_c_actual,
                pax_actually_y: flight.pax_y_actual,
                pax_actually_inf: flight.pax_inf_actual,
                baggage: flight.baggage,
                baggage_allowance: allowance_baggage,
                excess_baggage: excess_baggage,
                excess_baggage_revenue: excess_baggage_revenue,
                cargo_revenue: cargo_revenue,
                mail_revenue: mail_revenue,
                total_revenue: total_revenue,
                cargo: flight.cargo,
                eic: flight.eic,
                mail: flight.mail,
                pax_booked_c: flight.pax_c_booked,
                pax_booked_y: flight.pax_y_booked,
                pax_booked_inf: flight.pax_inf_booked,
                de: flight.deportees,
                in_tanks: flight.in_tanks ? flight.in_tanks : "&mdash;",
                uplifted: flight.uplifted ? flight.uplifted : "&mdash;",
                utilised: flight.utilised ? flight.utilised : "&mdash;",
                captains: implode(captains, ", "),
                first_officers: implode(firstOfficers, ", "),
                cabin_crew: implode(flightAttendants, ", "),
                captains_dhc: implode(captainsDHC, ", "),
                first_officers_dhc: implode(firstOfficersDHC, ", "),
                cabin_crew_dhc: implode(flightAttendantsDHC, ", "),
                captains_standby: implode(captainsStandby, ", "),
                first_officers_standby: implode(firstOfficersStandby, ", "),
                cabin_crew_standby: implode(flightAttendantsStandby, ", "),

                cabin_crew_sup: implode(flightAttendantsSUP, ", ")
            };
            var in_tanks = parseFloat(templateData.in_tanks),
                uplifted = parseFloat(templateData.uplifted),
                utilised = parseFloat(templateData.utilised);
            if (isNaN(in_tanks)) in_tanks = 0;
            if (isNaN(uplifted)) uplifted = 0;
            if (isNaN(utilised)) utilised = 0;

            templateData.dep_fuel = in_tanks + uplifted;
            templateData.arr_fuel = in_tanks + uplifted - utilised;

            $("#general").html(
                generalTabTemplate(templateData)
            );



            generalTabTemplateHTML = _general_tab_template;
            // Tooltip
            $("[data-toggle='tooltip']").popover({trigger: "hover"});

            setTimeout(function () {
                $("#flight_id").val(flight.id);
                $("#flight_number_id").val(flightNumber.id);
            }, 1);
        }
    }

    /**
     * Parse maintenance
     * @param data
     */
    function parseMaintenance(data) {
        var maintenance = data.maintenance, generalTabTemplate, templateData,
            _general_tab_template = $("#maintenance_tab_template");

        if (_general_tab_template.length) {
            generalTabTemplate = _.template(
                _general_tab_template.html()
            );

            templateData = {
                location: maintenance.location_code,
                arrivalDate: moment(maintenance.arrival_time, inputDateFormat).format(outputDateFormat),
                departureDate: moment(maintenance.departure_time, inputDateFormat).format(outputDateFormat),
                description: maintenance.note,
                userFullName: maintenance.user_id
            };
            $("#general_maintenance").html(
                generalTabTemplate(templateData)
            );
        }
    }

    /**
     * Prepare Raw Data For FleetWatch Timeline
     * @param json
     * @returns {Array}
     */
    function prepareDataForTimeline(json, object) {
        var flights = [];
        if (json.length) {
            var item, start_date, end_date;
            for (var i = 0, l = json.length; i < l; i++) {
                item = json[i];
                start_date = item.start_date;
                end_date = item.end_date;
                if (object) {
                    flights.push({
                        "start": new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        "end": new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                        "content": item.content,
                        "group": item.group,
                        "className": item.className
                    });
                }
                else {
                    flights.push([
                        new Date(start_date[0], start_date[1], start_date[2], start_date[3], start_date[4], start_date[5]),
                        new Date(end_date[0], end_date[1], end_date[2], end_date[3], end_date[4], end_date[5]),
                        item.content,
                        item.group,
                        item.className
                    ]);
                }
            }
        }
        return flights;
    }

    /**
     * Get selected flight ID and type
     * @returns {*}
     */
    function getSelectedEvent(flight) {
        var type, id;
        flight = flight || $(".timeline-event-selected > div.timeline-event-content > div");
        if (flight.length) {
            id = flight.attr("id");
            if (id.indexOf("flight-") === -1) {
                type = T_MAINTENANCE;
                id = id.replace("maintenance-", "");
            } else {
                type = T_FLIGHT;
                id = id.replace("flight-", "");
            }
            return {
                "type": type,
                "id": id
            }
        }
        return false;
    }

    function getPlanePosition() {
        var screenWidth = $(document).width(),
            position = (-1) * (screenWidth) * 13 / 1200;
        return screenWidth < 1000 ? 0 : position;
    }

    function getPlaneWidth() {
        var screenWidth = $(document).width(),
            proportionateWidth = Math.round(screenWidth * 100 / 1300);
        return proportionateWidth > 100 ? 100 : proportionateWidth;
    }

    function getFlightPosition(flight) {
        var progressbar_container = $(document).find("#progressbar_container"),
            progressbar_line = $(document).find("#progressbar_line"),
            progressbar_plane = $(document).find("#progressbar_plane"),
            LINE_WIDTH = progressbar_container.width(),
            PLANE_WIDTH = progressbar_plane.width(),
            PLANE_AND_LINE_OFFSET = 0, result = 0;

        if (flight.std && flight.sta && flight.atd) {
            var flightStartTime = moment(flight.atd),
                flightEndTime = moment(flight.sta),
                now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
                currentTime = moment(now);

            if (flight.ata){
                flightEndTime = moment(flight.ata);
            }
            else if (flight.eta){
                flightEndTime = moment(flight.eta);
            }

            if (currentTime.isAfter(flightEndTime)) {
                result = PLANE_WIDTH + (2 * PLANE_AND_LINE_OFFSET) + LINE_WIDTH;
            } else if (currentTime.isBefore(flightStartTime)) {
                result = 0;
            } else {
                var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                    flownRoute = currentTime.diff(flightStartTime, "seconds");

                result = PLANE_WIDTH + PLANE_AND_LINE_OFFSET + (LINE_WIDTH * flownRoute / totalFlightTimeInSeconds);

            }
        }

        console.log(PLANE_WIDTH);
        console.log(PLANE_AND_LINE_OFFSET);
        console.log(LINE_WIDTH);
        console.log((LINE_WIDTH * flownRoute / totalFlightTimeInSeconds));

        progressbar_plane.attr("style", progressbar_plane.attr("style") + ";left:" + result + "px;");

        return result;
    }

    function getFlightProgressBarFlownPercentage(flight) {
        var OFFSET = 1;
        if (flight.std && flight.sta && flight.atd) {
            var flightStartTime = moment(flight.atd),
                flightEndTime = moment(flight.sta),
                now = moment.utc().format('YYYY-MM-DD HH:mm:ss'),
                currentTime = moment(now);

            if (flight.ata){
                flightEndTime = moment(flight.ata);
            }
            else if (flight.eta){
                flightEndTime = moment(flight.eta);
            }

            if (currentTime.isAfter(flightEndTime)) {
                return 100;
            } else if (currentTime.isBefore(flightStartTime)) {
                return 0;
            } else {
                var totalFlightTimeInSeconds = flightEndTime.diff(flightStartTime, "seconds"),
                    flownRoute = currentTime.diff(flightStartTime, "seconds");
                return OFFSET + 100 * (flownRoute / totalFlightTimeInSeconds);
            }
        }
        return 0;
    }

    /**
     * Get Flight Crew
     * @param type
     * @param data
     * @param crew_type
     * @returns {*}
     */
    function getFlightCrewItems(type, data, crew_type) {
        if (typeof data.flightCrew === "undefined" || data.flightCrew == false) {
            return "";
        }
        var flightCrew = data.flightCrew, crew = [];
        switch (type) {
            case FLIGHT_CREW_CAPTAINS:
                if (typeof flightCrew.captains !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.captains.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.captains.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.captains.standby;
                    }
                }
                break;
            case FLIGHT_CREW_FIRST_OFFICERS:
                if (typeof flightCrew.firstOfficers !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.firstOfficers.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.firstOfficers.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.firstOfficers.standby;
                    }
                }
                break;
            case FLIGHT_CREW_FLIGHT_ATTENDANTS:
                if (typeof flightCrew.flightAttendants !== "undefined") {
                    if (crew_type == CREW_TYPE_DHC) {
                        crew = flightCrew.flightAttendants.dhc;
                    } else if (crew_type == CREW_TYPE_IN_FLIGHT) {
                        crew = flightCrew.flightAttendants.general;
                    } else if (crew_type == CREW_TYPE_STANDBY) {
                        crew = flightCrew.flightAttendants.standby;
                    } else if (crew_type == CREW_TYPE_SUP) {
                        crew = flightCrew.flightAttendants.sup;
                    }

                }
                break;
            default:
                break;
        }
        if (crew.length) {
            var result = [];
            for (var i = 0, l = crew.length; i < l; i++) {
                if (crew[i] && $.isPlainObject(crew[i])) {
                    result.push("<a target='_blank' href='" +   homeBaseUrl + "/crew/profile?id=" + crew[i].id + "' id='user-" + crew[i].id +
                        "' class='crew-item-person'>" + crew[i].first_name + " " + crew[i].last_name + "</a>");
                }
            }
            return result;
        }
        return "";
    }

    /**
     * Implode array to string with delimiter
     * @param arr
     * @param delimiter
     * @returns {string|*}
     */
    function implode(arr, delimiter) {
        return (arr instanceof Array) ? arr.join(delimiter) : arr;
    }

    function implodeWithCheck(arr, delimiter) {
        if (arr instanceof Array) {
            var newString = '';
            $.each(arr, function (i, item) {
                var each = $(item);
                if (each.val() != 'undefined undefined') {
                    newString += item + delimiter;
                }
            });

            return newString;
        }
        return arr;
    }

    /**
     * Fill MVT messages
     * @param data
     */
    function fillMVTMessages(data) {
        var arrival_message_mvt = $("#arrival_message_mvt"), arrival_message_subject = $('#arrival_message_subject'),
            departure_message_mvt = $("#departure_message_mvt"), departure_message_subject = $('#departure_message_subject'),
            send_departure_message_btn = $("#send-departure-message-btn"), diverted_flight = $("#diverted_flight"),
            send_arrival_message_btn = $("#send-arrival-message-btn"),
            flight = data.flight, i, l, j,
            flightNumber = flight.flight_number,
            departureAirport = flight.departure_airport,
            arrivalAirport = flight.arrival_airport,
            aircraft = flight.aircraft,
            user = data.user,
            _departure_airport,
            _arrival_airport;

        // Clear MVT Boxes Before Loading
        clearMVTForm();

        _departure_airport = flightNumber.departure_airport.iata;
        _arrival_airport = flightNumber.arrival_airport.iata;

        // set Departure MVT message
        if (flight.atd && flight.abn && flight.eta) {
            var departureMessageSubject, arrivalMessageSubject,
                pax_c = parseInt(flight.pax_c_actual),
                pax_y = parseInt(flight.pax_y_actual),
                std = moment(flight.std),
                sta = moment(flight.sta),
                atd = moment(flight.atd),
                abn = moment(flight.abn),
                eta = moment(flight.eta),
                ata = moment(flight.ata),
                departure_MVT_message,
                arrival_MVT_message;

            if (flight.is_diversion) {
                _departure_airport = departureAirport.abbr;
                _arrival_airport = arrivalAirport.abbr;
            }

            departure_MVT_message = "MVT\n" + CURRENT_IATA_CODE + flightNumber.flight_number + "/" + atd.format("DD") + "." +
                aircraft.mvt_name + "." + _departure_airport + "\nAD" + atd.format("DDHHmm") + "/" +
                abn.format("DDHHmm") + " EA" + eta.format("HHmm") + " " + _arrival_airport + "\n";
            // set Subject of The Message
            departureMessageSubject = 'MVT ' + CURRENT_IATA_CODE + flightNumber.flight_number + '/' + atd.format("DD") + ' ' +
                _departure_airport + '-' + _arrival_airport;
            departure_message_subject.val(departureMessageSubject);


            arrivalMessageSubject = 'MVT ' + CURRENT_IATA_CODE + flightNumber.flight_number + '/' + ata.format("DD") + ' ' +
                _departure_airport + '-' + _arrival_airport;
            arrival_message_subject.val(arrivalMessageSubject);

            // set delay part of message
            if (flight.delay_id && flight.delay) {
                var diff_hours = atd.diff(std, "hours").toString();
                var diff_minutes = atd.diff(std, "minutes").toString();

                if (diff_hours.length == 1) {
                    diff_hours = "0" + diff_hours.toString();
                }
                if (parseInt(diff_minutes) > 60) {
                    diff_minutes = parseInt(diff_minutes) % 60;
                    diff_minutes = diff_minutes.toString();
                }
                if (diff_minutes.length == 1) {
                    diff_minutes = "0" + diff_minutes;
                }
                departure_MVT_message += "DL" + flight.delay.code + "/" + diff_hours + diff_minutes + "\n";
                if (flight.delay.description) {
                    departure_MVT_message += "SI " + flight.delay.description + "\n";
                }
            }

            // set PAX part of message
            if (isNumber(pax_c) && isNumber(pax_y)) {
                var total = parseInt(pax_c) + parseInt(pax_y);
                if (total > 0) {
                    departure_MVT_message += "PX" + total + "\n";
                }
            }

            // set user name
            if (user) {
                departure_MVT_message += "OCC/" + user.first_name + " " + user.last_name;
            }
            departure_message_mvt.val(departure_MVT_message);

            // validate available hours
            var arrivalDate = moment(flight.abn),
                duration = moment.duration(moment().diff(arrivalDate)),
                hours = duration.asHours();
            if (hours > MAX_HOURS_FOR_MOVE) {
                send_departure_message_btn.attr("disabled", true);
                send_arrival_message_btn.attr("disabled", true);
            } else {
                send_departure_message_btn.attr("disabled", false);
                send_arrival_message_btn.attr("disabled", false);
            }
        }

        // set arrival MVT message
        if (flight.tdn && flight.ata) {
            var ata = moment(flight.ata),
                tdn = moment(flight.tdn),
                arrival_MVT_message = "MVT\n" + CURRENT_IATA_CODE + flightNumber.flight_number + "/" + ata.format("DD") + "." +
                    aircraft.mvt_name + "." + _arrival_airport + "\nAA" + tdn.format("DDHHmm") + "/" +
                    ata.format("DDHHmm") + "\n";

            // set user name
            if (user) {
                arrival_MVT_message += "OCC/" + user.first_name + " " + user.last_name;
            }
            arrival_message_mvt.val(arrival_MVT_message);
        }
    }


    /**
     * Fill Flight Form with flight information
     * @param data
     */
    function fillFlightForm(data) {
        var _form_flight_messages = $("#form_flight_messages"),
            _form = _form_flight_messages.parents('form'),
            _edit_flight_title = $("#edit_flight_title"),
            flight = data.flight, i, l, j,
            flightNumber = flight.flight_number, is_etd, is_atd,
            aircraft = flight.aircraft, titleTemplateHTML,
            delays = flight.delays,
            titleTemplate =
                _.template(CURRENT_IATA_CODE + "-<%= flightNumber %> \"<%= departureCityCode %>\" - \"<%= arrivalCityCode %>\"");

        titleTemplateHTML = titleTemplate({
            flightNumber: flightNumber.flight_number,
            departureCityCode: flightNumber.departure_airport,
            arrivalCityCode: flightNumber.arrival_airport
        });

        // clean form from old values
        clearFlightForm();

        _form_flight_messages.empty();
        _edit_flight_title.show();
        _edit_flight_title.find("legend").html("Edit: " + titleTemplateHTML);

        $("#flight_id").val(flight.id);
        $("#aircraft_id").val(aircraft.id);
        $("#flight_number_id").val(flightNumber.id);
        $("#std").val(correctDateFormat(flight.std));
        $("#sta").val(correctDateFormat(flight.sta));

        if (flight.ptd != emptyDate && flight.ptd) {
            $("#ptd").val(correctDateFormat(flight.ptd));
        }
        else {
            $("#ptd").val(correctDateFormat(flight.std));
        }

        if (flight.pta != emptyDate && flight.pta) {
            $("#pta").val(correctDateFormat(flight.pta));
        }
        else {
            $("#pta").val(correctDateFormat(flight.sta));
        }

        if (flight.eta != emptyDate && flight.eta) {
            $("#eta").val(correctDateFormat(flight.eta));
        }
        if (flight.ata != emptyDate && flight.ata) {
            $("#ata").val(correctDateFormat(flight.ata));
        }
        if (flight.etd != emptyDate && flight.etd) {
            is_etd = true;
            $("#etd").val(correctDateFormat(flight.etd));
        }
        if (flight.atd != emptyDate && flight.atd) {
            is_atd = true;
            $("#atd").val(correctDateFormat(flight.atd));
        }
        if (flight.abn != emptyDate && flight.abn) {
            $("#abn").val(correctDateFormat(flight.abn));
        }
        if (flight.tdn != emptyDate && flight.tdn) {
            $("#tdn").val(correctDateFormat(flight.tdn));
        }
        $("#capacity_c").val(flight.capacity_c);
        $("#capacity_y").val(flight.capacity_y);
        $("#pax_c_booked").val(flight.pax_c_booked);
        $("#pax_y_booked").val(flight.pax_y_booked);
        $("#pax_inf_booked").val(flight.pax_inf_booked);
        $("#pax_c_actual").val(flight.pax_c_actual);
        $("#pax_y_actual").val(flight.pax_y_actual);
        $("#pax_inf_actual").val(flight.pax_inf_actual);
        $("#gate_parking").val(flight.gate_parking);
        $("#baggage").val(flight.baggage);
        $("#cargo").val(flight.cargo);
        $("#eic").val(flight.eic);
        $("#mail").val(flight.mail);
        $("#deportees").val(flight.deportees);


        // set fuel fields
        $("#in_tanks").val(flight.in_tanks);
        $("#uplifted").val(flight.uplifted);
        $("#utilised").val(flight.utilised);
        var in_tanks = parseInt(flight.in_tanks);
        var uplifted = parseInt(flight.uplifted);
        var utilised = parseInt(flight.utilised);
        if (isNaN(in_tanks)) in_tanks = 0;
        if (isNaN(uplifted)) uplifted = 0;
        if (isNaN(utilised)) utilised = 0;
        if ((in_tanks + uplifted) > 0) {
            $("#departure_fuel").val(in_tanks + uplifted);
        }
        if (utilised) {
            $("#arrival_fuel").val(in_tanks + uplifted - utilised);
        }

        // set diversions
        if (flight.is_diversion) {
            $("#is_diversion").prop("checked", "checked");
            $("#diversion_airport_block").show();

            $("#diversion_airport").val(flight.diverted_airport_id);
            $("#diversion_airport").attr("required", "required");
            $('#diverted_flight').val(1);
            /*$("#diversion_arrival").show();
             $("#diversion_departure").show();
             $("#diversion_sta").val(flight.diversion.diversion_sta);
             $("#diversion_eta").val(flight.diversion.diversion_eta);
             $("#diversion_ata").val(flight.diversion.diversion_ata);
             $("#diversion_std").val(flight.diversion.diversion_std);
             $("#diversion_etd").val(flight.diversion.diversion_etd);
             $("#diversion_atd").val(flight.diversion.diversion_atd);
             $("#diversion_abn").val(flight.diversion.diversion_abn);
             $("#diversion_tdn").val(flight.diversion.diversion_tdn);*/
        }

        if (typeof flight.flightCrew !== "undefined") {
            var captains = flight.flightCrew.captains,
                firstOfficers = flight.flightCrew.firstOfficers,
                flightAttendants = flight.flightCrew.flightAttendants,
                item, item_new, item_captain, item_captain_dhc, item_captain_standby,
                itemFirstOfficer, itemFirstOfficerDHC, itemFirstOfficerStandby,
                itemFlightAttendantDHC, itemFlightAttendantStandBy, itemFlightAttendant,
                itemFlightAttendantSup,
                reasonSpanParent, reportTime;
            if (typeof captains === "object") {
                console.log(captains)
                if (captains.general.length) {
                    for (i = 0, l = captains.general.length; i < l; i++) {
                        j = parseInt(i + 1);
                        item_captain = $("#captain" + j);
                        if (i > 0) {
                            // add additional field
                            if (!item_captain.length) {
                                item = $("#flight_captains_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "captain" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        item_captain = $("#captain" + j);
                        if ($.isPlainObject(captains.general[i])) {
                            item_captain.val(captains.general[i].id);

                            // Show Report Time If Exists
                            if (captains.general[i].settings.report_time && captains.general[i].settings.report_time !== 'undefined') {
                                reportTime = moment(captains.general[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            item_captain.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (captains.general[i].settings.reason && captains.general[i].settings.reason !== 'undefined') {
                                reasonSpanParent = item_captain.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(captains.general[i].settings.reason);
                            }
                        }

                    }
                }
                if (captains.dhc.length) {
                    for (i = 0, l = captains.dhc.length; i < l; i++) {
                        j = parseInt(i + 1);
                        item_captain_dhc = $("#captain_dhc" + j);
                        if (i > 0) {
                            // add additional field
                            if (!item_captain_dhc.length) {
                                item = $("#flight_captains_dhc_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "captain_dhc" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        item_captain_dhc = $("#captain_dhc" + j);
                        if ($.isPlainObject(captains.dhc[i])) {
                            item_captain_dhc.val(captains.dhc[i].id);

                            // Show Report Time If Exists
                            if (captains.dhc[i].settings.report_time && captains.dhc[i].settings.report_time !== 'undefined') {
                                reportTime = moment(captains.dhc[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            item_captain_dhc.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (captains.dhc[i].settings.reason && captains.dhc[i].settings.reason !== 'undefined') {
                                reasonSpanParent = item_captain_dhc.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(captains.dhc[i].settings.reason);
                            }
                        }
                    }
                }
                if (captains.standby.length) {
                    for (i = 0, l = captains.standby.length; i < l; i++) {
                        j = parseInt(i + 1);
                        item_captain_standby = $("#captain_standby" + j);
                        if (i > 0) {
                            // add additional field
                            if (!item_captain_standby.length) {
                                item = $("#flight_captain_standby_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "captain_standby" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        item_captain_standby = $("#captain_standby" + j);
                        if ($.isPlainObject(captains.standby[i])) {
                            item_captain_standby.val(captains.standby[i].id);

                            // Show Report Time If Exists
                            if (captains.standby[i].settings.report_time && captains.standby[i].settings.report_time !== 'undefined') {
                                reportTime = moment(captains.standby[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            item_captain_standby.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (captains.standby[i].settings.reason && captains.standby[i].settings.reason !== 'undefined') {
                                reasonSpanParent = item_captain_standby.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(captains.standby[i].settings.reason);
                            }
                        }
                    }
                }
            }

            if (typeof firstOfficers === "object") {
                if (firstOfficers.general.length) {
                    console.log(firstOfficers)
                    for (i = 0, l = firstOfficers.general.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFirstOfficer = $("#first_officer" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFirstOfficer.length) {
                                item = $("#flight_first_officers_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "first_officer" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFirstOfficer = $("#first_officer" + j);
                        if ($.isPlainObject(firstOfficers.general[i])) {
                            itemFirstOfficer.val(firstOfficers.general[i].id);

                            // Show Report Time If Exists
                            if (firstOfficers.general[i].settings.report_time && firstOfficers.general[i].settings.report_time !== 'undefined') {
                                reportTime = moment(firstOfficers.general[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFirstOfficer.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (firstOfficers.general[i].settings.reason && firstOfficers.general[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFirstOfficer.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(firstOfficers.general[i].settings.reason);
                            }
                        }
                    }
                }
                if (firstOfficers.dhc.length) {
                    for (i = 0, l = firstOfficers.dhc.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFirstOfficerDHC = $("#first_officer_dhc" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFirstOfficerDHC.length) {
                                item = $("#flight_first_officers_dhc_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "first_officer_dhc" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFirstOfficerDHC = $("#first_officer_dhc" + j);
                        if ($.isPlainObject(firstOfficers.dhc[i])) {
                            itemFirstOfficerDHC.val(firstOfficers.dhc[i].id);

                            // Show Report Time If Exists
                            if (firstOfficers.dhc[i].settings.report_time && firstOfficers.dhc[i].settings.report_time !== 'undefined') {
                                reportTime = moment(firstOfficers.dhc[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFirstOfficerDHC.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (firstOfficers.dhc[i].settings.reason && firstOfficers.dhc[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFirstOfficerDHC.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(firstOfficers.dhc[i].settings.reason);
                            }
                        }
                    }
                }

                if (firstOfficers.standby.length) {
                    for (i = 0, l = firstOfficers.standby.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFirstOfficerStandby = $("#first_officer_standby" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFirstOfficerStandby.length) {
                                item = $("#flight_first_officers_standby_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "first_officer_standby" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFirstOfficerStandby = $("#first_officer_standby" + j);
                        if ($.isPlainObject(firstOfficers.standby[i])) {
                            itemFirstOfficerStandby.val(firstOfficers.standby[i].id);

                            // Show Report Time If Exists
                            if (firstOfficers.standby[i].settings.report_time && firstOfficers.standby[i].settings.report_time !== 'undefined') {
                                reportTime = moment(firstOfficers.standby[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFirstOfficerStandby.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (firstOfficers.standby[i].settings.reason && firstOfficers.standby[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFirstOfficerStandby.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(firstOfficers.standby[i].settings.reason);
                            }
                        }
                    }
                }
            }

            if (typeof flightAttendants === "object") {
                if (flightAttendants.general.length) {
                    for (i = 0, l = flightAttendants.general.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFlightAttendant = $("#cabin_crew" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFlightAttendant.length) {
                                item = $("#flight_cabin_crew_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label:first").html("No." + j);
                                item_new.find("select:first").attr("id", "cabin_crew" + j);
                                item_new.insertAfter(item);

                            }
                        }
                        itemFlightAttendant = $("#cabin_crew" + j);

                        if ($.isPlainObject(flightAttendants.general[i])) {
                            itemFlightAttendant.val(flightAttendants.general[i].id);
                            // Show Report Time If Exists
                            if (flightAttendants.general[i].settings.report_time && flightAttendants.general[i].settings.report_time !== 'undefined') {
                                reportTime = moment(flightAttendants.general[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 15
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFlightAttendant.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (flightAttendants.general[i].settings.reason && flightAttendants.general[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFlightAttendant.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(flightAttendants.general[i].settings.reason);
                            }
                        }
                    }
                }
                if (flightAttendants.dhc.length) {
                    for (i = 0, l = flightAttendants.dhc.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFlightAttendantDHC = $("#cabin_crew_dhc" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFlightAttendantDHC.length) {
                                item = $("#flight_cabin_crew_dhc_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label").html("#" + j);
                                item_new.find("select").attr("id", "cabin_crew_dhc" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFlightAttendantDHC = $("#cabin_crew_dhc" + j);
                        if ($.isPlainObject(flightAttendants.dhc[i])) {
                            itemFlightAttendantDHC.val(flightAttendants.dhc[i].id);

                            // Show Report Time If Exists
                            if (flightAttendants.dhc[i].settings.report_time && flightAttendants.dhc[i].settings.report_time !== 'undefined') {
                                reportTime = moment(flightAttendants.dhc[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 45
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFlightAttendantDHC.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (flightAttendants.dhc[i].settings.reason && flightAttendants.dhc[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFlightAttendantDHC.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(flightAttendants.dhc[i].settings.reason);
                            }
                        }

                    }
                }

                if (flightAttendants.standby.length) {
                    for (i = 0, l = flightAttendants.standby.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFlightAttendantStandBy = $("#cabin_crew_standby" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFlightAttendantStandBy.length) {
                                item = $("#flight_cabin_crew_standby_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label:first").html("#" + j);
                                item_new.find("select:first").attr("id", "cabin_crew_standby" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFlightAttendantStandBy = $("#cabin_crew_standby" + j);

                        if ($.isPlainObject(flightAttendants.standby[i])) {
                            itemFlightAttendantStandBy.val(flightAttendants.standby[i].id);

                            // Show Report Time If Exists
                            if (flightAttendants.standby[i].settings.report_time && flightAttendants.standby[i].settings.report_time !== 'undefined') {
                                reportTime = moment(flightAttendants.standby[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 45
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFlightAttendantStandBy.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (flightAttendants.standby[i].settings.reason && flightAttendants.standby[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFlightAttendantStandBy.parent().find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(flightAttendants.standby[i].settings.reason);
                            }
                        }
                    }
                }


                if (flightAttendants.sup.length) {
                    for (i = 0, l = flightAttendants.sup.length; i < l; i++) {
                        j = parseInt(i + 1);
                        itemFlightAttendantSup = $("#cabin_crew_sup" + j);
                        if (i > 0) {
                            // add additional field
                            if (!itemFlightAttendantSup.length) {
                                item = $("#flight_cabin_crew_sup_crew").find("span.item:last");
                                item_new = item.clone();
                                item_new.attr("data-item-number", j);
                                item_new.find("label:first").html("#" + j);
                                item_new.find("select:first").attr("id", "cabin_crew_sup" + j);
                                item_new.insertAfter(item);
                            }
                        }
                        itemFlightAttendantSup = $("#cabin_crew_sup" + j);

                        if ($.isPlainObject(flightAttendants.sup[i])) {
                            itemFlightAttendantSup.val(flightAttendants.sup[i].id);

                            // Show Report Time If Exists
                            if (flightAttendants.sup[i].settings.report_time && flightAttendants.sup[i].settings.report_time !== 'undefined') {
                                reportTime = moment(flightAttendants.sup[i].settings.report_time).format('YYYY-MM-DD HH:mm');
                            }
                            else {
                                reportTime = moment(flight.std).subtract({
                                    hours: 1,
                                    minutes: 45
                                }).format('YYYY-MM-DD HH:mm');
                            }
                            itemFlightAttendantSup.parents('span').find('input.reportTime').val(reportTime);

                            // Show Reason If Exists
                            if (flightAttendants.sup[i].settings.reason && flightAttendants.sup[i].settings.reason !== 'undefined') {
                                reasonSpanParent = itemFlightAttendantSup.parents('span').find('span.reason');
                                reasonSpanParent.show();
                                reasonSpanParent.find('select.crewReason').val(flightAttendants.sup[i].settings.reason);
                            }

                            // Show Sup Type
                            if (flightAttendants.sup[i].settings.crew_sup_id && flightAttendants.sup[i].settings.crew_sup_id !== 'undefined') {
                                var supType = itemFlightAttendantSup.parents('span').find('select[name="cabin_crew_sup_type[]"]');
                                supType.val(flightAttendants.sup[i].settings.crew_sup_id);
                            }
                        }
                    }
                }


            }
        }

        AddDateFormatElement($("input.reportTime"), "Y-m-d H:i", true, 5);
        reasonShowOnCrewChange();

        $("#flight_add_btn").hide();

        if (flight.deleted_at){
            $("#flight_update_btn").hide();
            $("#remove_flight_div").hide();
            $("#flight_restore_btn").show();
            _form.find("input").not(":hidden, #flight_restore_btn, #remove_btn").attr("disabled", "disabled");
            _form.find("select").attr("disabled", "disabled");
            _form.find("a").attr("disabled", "disabled");
            _form.find("button").attr("disabled", "disabled");
        }
        else if (flight.cancelled_at) {
            $("#flight_update_btn").hide();
            $("#cancel_flight_div").hide();
            $("#flight_restore_btn").show();
            _form.find("input").not(":hidden, #flight_restore_btn, #cancel_btn").attr("disabled", "disabled");
            _form.find("select").attr("disabled", "disabled");
            _form.find("a").attr("disabled", "disabled");
            _form.find("button").attr("disabled", "disabled");
        }
        else {
            $("#flight_restore_btn").hide();
            $("#flight_update_btn").show();
            $("#cancel_flight_div").show();
            $("#remove_flight_div").show();
            _form.find("input").removeAttr("disabled");
            _form.find("select").removeAttr("disabled");
            _form.find("a").removeAttr("disabled");
            _form.find("button").removeAttr("disabled");
        }
        $("#cancel_btn").show();

        cancelReasonCheck();

        // fills delays fields
        if (delays) {
            $(".item-delay").not(":first").remove();
            $("#delay_total").val("");
            var first_delay = $(".item-delay:first"), duration;
            for (i = 0, l = delays.length; i < l; i++) {
                if (i == 0) {
                    duration = moment(delays[i].duration, "HH:mm:ss");
                    first_delay.find("select").val(delays[i].delay_id);
                    first_delay.find("input").val(duration.format("HH:mm"));
                } else {
                    addNewDelayAndFill(first_delay, delays[i]);
                }
            }
        }
        DelayFieldSet();
    }

    $(document).on("change", "#cancel_reason", function () {
        cancelReasonCheck();
    });

    function cancelReasonCheck(){
        var _this = $("#cancel_reason"), flight_cancel_btn = $("#flight_cancel_btn");

        if (_this.val() == ""){
            flight_cancel_btn.attr("disabled", "disabled");
        }
        else {
            flight_cancel_btn.removeAttr("disabled")
        }
    }

    function addNewDelayAndFill(first_delay, delay) {
        var next_delay = first_delay.clone(),
            duration = moment(delay.duration, "HH:mm:ss");

        next_delay.find("select").val(delay.delay_id);
        next_delay.find("input").val(duration.format("HH:mm"));
        first_delay.after(next_delay);
    }

    /**
     * Hide flight popup event handler
     * @return void
     */
    $("#flight_info_modal, #flight_maintenance_info_modal").on("hidden.bs.modal", function (e) {
        //timeline.setSelection([]);
    });

    /**
     * Mouse enter on crew item person to load his image
     */
    $(document).on({
        mouseenter: function () {
            var _this = $(this), user_id = _this.attr("id").replace("user-", ""),
                request;

            _this.attr("data-toggle", "popover")
                .attr("data-trigger", "focus")
                .attr("title", _this.text())
                .attr("data-content", "<div class='user-image center-block'>" +
                "<img src='" + baseUrl + "/assets/img/2.GIF' alt='User Image'/></div>");
            _this.popover({
                "html": true
            });
            _this.popover("show");
            $.ajaxSetup({
                url: baseUrl + "/user/ajaxgetuserimage",
                type: "GET",
                dataType: "json"
            });
            request = $.ajax({
                data: {
                    user_id: user_id
                }
            });
            request.done(function (data) {
                if (typeof data.success !== "undefined") {
                    $(".user-image").empty().append("<img src='" + data.image + "' alt='User Image' width='120' />");
                } else {

                }
            });
            request.fail(function (jqXHR, text_status) {
                showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, $("#da"));
            });
            request.always(function () {
            });
        },
        mouseleave: function () {
            var _this = $(this);
            _this.attr("data-content", "");
            _this.popover("hide");
        }
    }, ".crew-item-person");


    function correctDateFormat(date, format) {
        if (format)
            return moment(date, inputDateFormat).format(format);
        else
            return moment(date, inputDateFormat).format("YYYY-MM-DD HH:mm");
    }

    /**
     * a and b are javascript Date objects
     * @param a
     * @param b
     * @returns {number}
     */
    function dateDiffInDays(a, b) {
        // Discard the time and time-zone information.
        var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
        var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

        return Math.floor((utc2 - utc1) / _MS_PER_DAY);
    }

    /**
     * Mouse over|move|click variables
     * @type {number}
     */
    var delay = 1000, setTimeoutConst, flightHover = null;
    var clicking = false, clickingAndMove = false, doubleClicking = false;

    /* $(document).mousedown(function() {
     clicking = true;
     });
     $(document).mouseup(function() {
     clicking = false;
     });
     $(document).mousemove(function() {
     doubleClicking = false;
     clickingAndMove = !(clicking == false);
     });

     $(document).dblclick(function(){
     doubleClicking = true;
     clicking = false;
     });*/

    $(document).on("click touchstart", ".timeline-event", function () {
        var _this = $(this), flightHover = _this.find(".timeline-event-content>div");

        console.log(_this)

        /* if (clickingAndMove === true || doubleClicking === true ){ // || clicking === true || _this.hasClass("timeline-event-selected") == true ||
         flightHover = false;
         return false;
         }*/
//            setTimeoutConst = setTimeout(function () {
        /* if (_this.hasClass("timeline-event-selected") == true || clickingAndMove === true || clicking === true) {
         flightHover = false;
         return false;
         }*/

        var $body = $("body"), requestData,
            flightData = getSelectedEvent(flightHover), request;

        if (!flightData) {
            return false;
        }

        if (flightData.type == T_MAINTENANCE) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/aircraft/ajax-get-maintenance",
                data: {
                    id: flightData.id
                }
            };
        } else if (flightData.type == T_FLIGHT) {
            requestData = {
                type: "GET",
                dataType: "json",
                url: baseUrl + "/flight/ajax-get-flight",
                data: {
                    flight_id: flightData.id
                }
            };
        }

        request = $.ajax(requestData);

        request.done(function (data) {

            console.log(data)

            if (typeof data.success !== "undefined") {
                if (flightData.type == T_FLIGHT) {
                    parseFlight(data);
                    //clearFlightForm();
                    popupFlight = flight_info_modal.bPopup({
                        closeClass: 'close-btn',
                        modal: true,
                        follow: [false, false], //x, y
                        onOpen: function() {
                            $('#accordion').on('shown.bs.collapse', function () {
                                setTimeout(function() {
                                    var crew_panel = $("#crew_information_panel"),
                                        fuel_panel = $("#fuel_information_panel"),
                                        crew_panel_height = crew_panel.height(),
                                        fuel_panel_height = fuel_panel.height();
                                    if (crew_panel_height > fuel_panel_height) {
                                        fuel_panel.height(crew_panel_height);
                                    } else {
                                        crew_panel.height(fuel_panel_height);
                                    }
                                }, 1);
                            });
                        }
                    });
                    $("#flight_info_modal ul.nav a:first").tab("show");

                    flight_info_modal.attr('data-flight_id', flightData.id);
                    flight_info_modal.attr('data-flight_number_id', data.flight.flight_number_id);
                    flight_info_modal.attr('data-std', data.flight.std);

                    var generalTab = $(document).find("#progressbar_container");
                    getFlightPosition(data.flight)

                }
                else if (flightData.type == T_MAINTENANCE) {
                    parseMaintenance(data);
                    popupFlight = $("#flight_maintenance_info_modal").bPopup({
                        closeClass: 'close-btn',
                        modal: true
                    });
                    $("#flight_maintenance_info_modal a:first").tab("show");

                    $("#flight_maintenance_info_modal").attr("data-maintenance_id", flightData.id);
                }

            } else {
                showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
            }
        });
        request.fail(function (jqXHR, textStatus) {
            showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            $body.removeClass("loading");
        });
        //}, delay);
    });

    $(document).on("mouseleave", ".timeline-event", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;
    });

    /**
     * On flight item hover mouse event handlers
     * @return void
     */
     /*$(document).on({
         dblclick: function () {
            var _this = $(this),
                flightHover = _this.find(".timeline-event-content>div");

           /!* if (clickingAndMove === true || doubleClicking === true ){ // || clicking === true || _this.hasClass("timeline-event-selected") == true ||
                flightHover = false;
                return false;
            }*!/
//            setTimeoutConst = setTimeout(function () {
               /!* if (_this.hasClass("timeline-event-selected") == true || clickingAndMove === true || clicking === true) {
                    flightHover = false;
                    return false;
                }*!/

                var $body = $("body"), requestData,
                    flightData = getSelectedEvent(flightHover), request;
                if (!flightData) {
                    return false;
                }

                if (flightData.type == T_MAINTENANCE) {
                    requestData = {
                        type: "GET",
                        dataType: "json",
                        url: baseUrl + "/aircraft/ajax-get-maintenance",
                        data: {
                            maintenance_id: flightData.id
                        }
                    };
                } else if (flightData.type == T_FLIGHT) {
                    requestData = {
                        type: "GET",
                        dataType: "json",
                        url: baseUrl + "/flight/ajax-get-flight",
                        data: {
                            flight_id: flightData.id
                        }
                    };
                }
                request = $.ajax(requestData);
                request.done(function (data) {

                    if (typeof data.success !== "undefined") {
                        if (flightData.type == T_FLIGHT) {
                            parseFlight(data);
                            //clearFlightForm();
                            popupFlight = flight_info_modal.bPopup({
                                closeClass: 'close-btn',
                                modal: true,
                                follow: [false, false], //x, y
                                onOpen: function() {
                                    $('#accordion').on('shown.bs.collapse', function () {
                                        setTimeout(function() {
                                            var crew_panel = $("#crew_information_panel"),
                                                fuel_panel = $("#fuel_information_panel"),
                                                crew_panel_height = crew_panel.height(),
                                                fuel_panel_height = fuel_panel.height();
                                            if (crew_panel_height > fuel_panel_height) {
                                                fuel_panel.height(crew_panel_height);
                                            } else {
                                                crew_panel.height(fuel_panel_height);
                                            }
                                        }, 1);
                                    });
                                }
                            });
                            $("#flight_info_modal ul.nav a:first").tab("show");

                            flight_info_modal.attr('data-flight_id', flightData.id);
                            flight_info_modal.attr('data-flight_number_id', data.flight.flight_number_id);
                            flight_info_modal.attr('data-std', data.flight.std);

                            var generalTab = $(document).find("#progressbar_container");
                            getFlightPosition(data.flight)

                        } else if (flightData.type == T_MAINTENANCE) {
                            parseMaintenance(data);
                            popupFlight = $("#flight_maintenance_info_modal").bPopup({
                                closeClass: 'close-btn',
                                modal: true
                            });
                            $("#flight_maintenance_info_modal a:first").tab("show");
                            $("#flight_maintenance_info_modal").attr("data-maintenance_id", flightData.id);
                        }

                    } else {
                        showMessage(data.text, "Error!", MESSAGE_DANGER, messageBlock);
                    }
                });
                request.fail(function (jqXHR, textStatus) {
                    showMessage("Request failed: " + textStatus, "Error!", MESSAGE_DANGER, messageBlock);
                });
                request.always(function () {
                    $body.removeClass("loading");
                });
            //}, delay);
         },
         mouseleave: function () {
             clearTimeout(setTimeoutConst);
             flightHover = null;
         }
     }, ".timeline-event");*/


/**
 * On document ready
 */
$(function () {

    $("#go_to_date").datetimepicker({
        format: "Y-m-d",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        timepicker: false
    });

    /**
     * Validate date field before submit the form
     * @return bool
     */
    $("#btn-go-to-date").on("click", function () {
        if (!$("#go_to_date").val()) {
            showMessage("Please enter valid date before submit the form", "Validation Error:", MESSAGE_DANGER,
                messageBlock);
            //return false;
        }
    });

    /**
     * Reset button clikc event handler
     * @return void
     */
    $("#btn-clear-go-to-date").on("click", function () {
        if ($("#go_to_date").val()) {
            $(this).attr("disabled", true);
            $("#btn-go-to-date").attr("disabled", true);
            $("#go_to_date").val("");
            $("#go_to_date_form").submit();
            //return true;
        }
        //return false
    });

    /*var touchtime = 0;
    $(document).on("mouseleave", ".timeline-event", function () {
        clearTimeout(setTimeoutConst);
        flightHover = null;
        touchtime = 0;
    });

    $(document).on("click", ".timeline-event", function () {
        if(touchtime == 0) {
            touchtime = new Date().getTime();
        }
        else {
            //compare first click to this click and see if they occurred within double click threshold
            if(((new Date().getTime())- touchtime) < 800) {
                //double click occurred
                flightDoubleClick();
                touchtime = 0;
            } else {
                //not a double click so set as a new first click
                touchtime = new Date().getTime();
            }
        }
    });*/


});
