"use strict";

/**
 * Created by Compas on 26.08.14.
 */
// Applies + 1
var MAX_ALLOWED_FLIGHT_CREW = 2,
    MAX_ALLOWED_FLIGHT_CREW_DHC = 4,
    MAX_ALLOWED_FLIGHT_CREW_STANDBY = 2,
    MIN_ALLOWED_FLIGHT_CREW = 0,
    MIN_ALLOWED_FLIGHT_CREW_DHC = 0,
    MIN_ALLOWED_FLIGHT_CREW_STANDBY = 0,

    MAX_ALLOWED_CABIN_CREW = 7,
    MAX_ALLOWED_CABIN_CREW_DHC = 9,
    MAX_ALLOWED_CABIN_CREW_SUP = 9,
    MAX_ALLOWED_CABIN_CREW_STANDBY = 2,
    MIN_ALLOWED_CABIN_CREW = 3,
    MIN_ALLOWED_CABIN_CREW_DHC = 0,
    MIN_ALLOWED_CABIN_CREW_STANDBY = 0,

    MAX_ALLOWED_DIVERSIONS = 3;

/**
 * Captains sync all fields
 */
/*
 var captainsSync = new SelectSync([
 "#captain1",
 "#captain2",
 "#captain3",
 "#captain_dhc1",
 "#captain_dhc2",
 "#captain_dhc3",
 "#captain_standby1"
 ]);
 */

var _form_flight_messages = $("#form_flight_messages");

/**
 * Clear Crew SelectBoxes
 * @param maxNumber
 * @param selector
 */
function clearCrewSelectboxes(maxNumber, selector){
    var crew;
    for (var i = 0; i <= maxNumber; i++){
        crew = $(selector + i);
        if (crew.length)
            crew.val('');
    }
}

$(document).on("submit", "#go_to_date_form", function () {

    var _this = $(this), url = _this.attr("action"), loading = $("#loading-fleetwatch-data"),
        cancel_btn = $("#cancel_btn");

    loading.show();

    var request = $.ajax({
        data: _this.serialize(),
        url:  url,
        type: _this.attr("method") // not POST, laravel won't allow it
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true),
                start_time = moment(data.start_visible_period).format("YYYY-MM-DD HH:mm:ss"),
                end_time = moment(data.end_visible_period).format("YYYY-MM-DD HH:mm:ss");

            timeline.setVisibleChartRange(start_time, end_time);

            //if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();
            //}

            cancel_btn.click();
        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});


$(document).on("submit", "#form_fleetwatch", function () {

    var _this = $(this), url = _this.attr("action"), loading = $("#loading-fleetwatch-form"),
        cancel_btn = $("#cancel_btn");

    loading.show();

    var request = $.ajax({
        data: _this.serialize(),
        url:  url,
        type: _this.attr("method") // not POST, laravel won't allow it
    });

    request.success(function(data){
        if (typeof data.success !== "undefined") {
            var jsonData = data.jsonData,
                flights = prepareDataForTimeline(jsonData, true);

            if (flights.length) {
                timeline.setData(flights);
                timeline.redraw();
            }

            cancel_btn.click();

        }

    });

    request.always(function(){
        loading.hide();
    });

    return false;
});


/**
 * Clear Fleet Watch Input Form
 */
function clearFlightForm() {
    var i, crew, _edit_flight_title = $("#edit_flight_title");
    _form_flight_messages.empty();
    _edit_flight_title.empty().hide();
    _edit_flight_title.find("legend").html("");

    $("#flight_id, #aircraft_id, #flight_number_id").val("");
    $("#capacity_a, #capacity_c, #capacity_w, #capacity_y").val("");
    $("#std, #ptd, #sta, #eta, #ata, #pta, #etd, #atd, #abn, #tdn").val("");
    $("#delay_id, #delay_time, #gate_parking").val("");
    $("#pax_a_booked, #pax_c_booked, #pax_w_booked, #pax_y_booked, #pax_inf_booked").val("");
    $("#pax_a_actual, #pax_c_actual, #pax_w_actual, #pax_y_actual, #pax_inf_actual").val("");
    $("#baggage, #cargo, #eic, #mail, #deportees, #in_tanks, #uplifted, #utilised, #departure_fuel, #arrival_fuel").val("");
    $("#diverted_flight").val("");

    $("#diversion_airport").removeAttr("required");
    $("#diversion_sta").removeAttr("required");
    $("#diversion_std").removeAttr("required");

    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW, "#first_officer");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_STANDBY, "#first_officer_standby");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_DHC, "#first_officer_dhc");

    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW, "#captain");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_STANDBY, "#captain_standby");
    clearCrewSelectboxes(MAX_ALLOWED_FLIGHT_CREW_DHC, "#captain_dhc");

    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW, "#cabin_crew");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_STANDBY, "#cabin_crew_standby");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_DHC, "#cabin_crew_dhc");
    clearCrewSelectboxes(MAX_ALLOWED_CABIN_CREW_SUP, "#cabin_crew_sup");

    $("#flight_captains_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW + ")").remove();
    $("#flight_captain_standby_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_STANDBY + ")").remove();
    $("#flight_captains_dhc_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_DHC + ")").remove();

    $("#flight_first_officers_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW + ")").remove();
    $("#flight_first_officers_standby_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_STANDBY + ")").remove();
    $("#flight_first_officers_dhc_crew").find(".item:gt(" + MIN_ALLOWED_FLIGHT_CREW_DHC + ")").remove();

    $("#flight_cabin_crew_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW + ")").remove();
    $("#flight_cabin_crew_standby_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW_STANDBY + ")").remove();
    $("#flight_cabin_crew_dhc_crew").find(".item:gt(" + MIN_ALLOWED_CABIN_CREW_DHC + ")").remove();

    $("#is_diversion").attr("checked", false);
    $("#diversion_airport_block").hide();
    $("input.reportTime").val("");
    $("span.reason").hide();
    $("#diversion_airport").val("");
    $("#diversion_arrival, #diversion_departure").hide();
    $("#diversion_sta, #diversion_eta, #diversion_ata, #diversion_std, #diversion_etd, #diversion_atd, #diversion_abn, #diversion_tdn").val("");
}

/**
 * Clear MVT Form
 */
function clearMVTForm(){
    $('#departure_message_mvt').val('');
    $('#departure_message_subject').val('');

    $('#arrival_message_mvt').val('');
    $('#arrival_message_subject').val('');

}


function DelayFieldSet(){
    var std = $('#std'), etd = $('#etd'), atd = $('#atd');

    if (atd.val() || etd.val()) {
        var stdDate = moment(std.val()), etdDate = moment(etd.val()), atdDate = moment(atd.val()), delayTotal = "00:00";
        var etd_delay = etd.val() && etdDate.isAfter(stdDate) ? etdDate.diff(stdDate, 'm') : false;
        var atd_delay = atd.val() && atdDate.isAfter(stdDate) ? atdDate.diff(stdDate, 'm') : false;
        if ((etd_delay && etd_delay > 3) || (atd_delay && atd_delay > 3)) {
            var delay_timing = atd_delay ? atd_delay : etd_delay;
            var hours = Math.floor( delay_timing / 60);
            var minutes = delay_timing % 60;
            delayTotal = ( hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes);
            $("#delay_total").val(delayTotal);

            $(".delay_id").attr("disabled", false);
            $(".delay_time").attr("disabled", false);
            $(".add-delay-btn").attr("disabled", false);
            $(".remove-delay-btn").attr("disabled", false);
            return;
        }
    }

    $(".delay_id").attr("disabled", true);
    $(".delay_time").attr("disabled", true);
    $(".add-delay-btn").attr("disabled", true);
    $(".remove-delay-btn").attr("disabled", true);
}


function CheckDelayTimeForLimitation(element) {

    var delays = element.find("input").not("[name=delay_total]"), first_delay = delays.first(), total_delay = moment($("#delay_total").val(), "HH:mm"),
        total_delay_duration = moment.duration(total_delay), delay_each, delay_each_duration, currentVal, delay_each_mins = 0,
        total_duration_mins = total_delay_duration.asMinutes(), delay_message = $('#delay_message');

    for (var i = 0, l = delays.length; i < l; i++) {
        currentVal = $(delays[i]).val();
        delay_each = moment(currentVal, "HH:mm");
        delay_each_duration = moment.duration(delay_each);
        delay_each_mins += delay_each_duration.asMinutes();
    }
    if (delay_each_mins > total_duration_mins){
        delay_message.show();
    }
    else {
        delay_message.hide();
    }
}

function CleanCrewChangeForm(){
    var crewChangeLayout = $('.crew-change-process');

    crewChangeLayout.find('#crew-position').text("");
    crewChangeLayout.find('#crew-name').text("");
    crewChangeLayout.find('#crew-last-ytd').text("");
    crewChangeLayout.find('#crew-last-365').text("");
    crewChangeLayout.find('#crew-last-28').text("");
    crewChangeLayout.find('#crew-last-7').text("");
    crewChangeLayout.find('#crew-message-box').html("");
    crewChangeLayout.find('#flights-table').hide();
    crewChangeLayout.find('#flights-table-body').html("");
    //crewChangeLayout.find('.crew-indicators-label').text("");

}

$(function () {

    var TAB_GENERAL = "general",
        TAB_PNL = "pnl",
        TAB_PL = "pl",
        TAB_MVT = "mvt",
        TAB_LDM = "ldm",
        TAB_CPM = "cpm",
        TAB_PSM = "psm",
        TAB_PTM = "ptm",
        TAB_FHR = "fhr",
        crew = $(".crew"),
        crewChangeLayout = $('.crew-change-process');


    $(document).on("change", ".crew", function () {
        return;

        var _this = $(this), crewType = _this.attr("data-crew-type"), position = _this.attr("data-crew-position"),
            pos = _this.offset();

        crewChangeLayout.show();

        var loading = crewChangeLayout.find("#crew-loading"),
            layoutCrewPosition = crewChangeLayout.find('#crew-position'),
            layoutCrewName =  crewChangeLayout.find('#crew-name'),
            layoutCrewYTD =  crewChangeLayout.find('#crew-last-ytd'),
            layoutCrew365 =  crewChangeLayout.find('#crew-last-365'),
            layoutCrew28 =  crewChangeLayout.find('#crew-last-28'),
            layoutCrew7 =  crewChangeLayout.find('#crew-last-7'),
            layoutMessageBox =  crewChangeLayout.find('#crew-message-box'),
            layoutflightsTable =  crewChangeLayout.find('#flights-table'),
            layoutflightsTableBody =  crewChangeLayout.find('#flights-table-body');

        crewType = crewType === undefined ? "" : crewType;

        crewChangeLayout.css({
            top: (pos.top + 20) + "px",
            left: (pos.left) + "px"
        }).show();

        console.log("60".toHHMMSS());

        CleanCrewChangeForm();
        loading.show();

        var request = $.ajax({
            url: baseUrl + "/fleetwatch/ajax-get-crew-info",
            type: "GET",
            data: {
                id :        _this.val(),
                crew_type : crewType,
            }
        });



        request.done(function (data) {
            if (data.success){
                var hours = data.hours,
                    flights = data.flights,
                    user = data.user;

                layoutCrewPosition.text("(" + user.position_title + ")");
                layoutCrewName.text(user.first_name + " " + user.last_name);

                layoutCrewYTD.text(hours.yearToDate ? (hours.yearToDate * 3600).toString().toHHMM() : "-");
                layoutCrew365.text(hours.last365days ? (hours.last365days * 3600).toString().toHHMM() : "-");
                layoutCrew28.text(hours.last28days ? (hours.last28days * 3600).toString().toHHMM() : "-");
                layoutCrew7.text(hours.last7days ? (hours.last7days * 3600).toString().toHHMM() : "-");

                layoutflightsTable.show();
                layoutflightsTableBody.html(data.flightsTable);
            }
            else {
                layoutMessageBox.html(error_box.text(data.message));
            }
        });

        request.fail(function () {
            layoutMessageBox.html(error_box.text("Error! Request failed. Please try again"));
        });

        request.always(function () {
            loading.hide();
        });
    });

    $(document).on("click", ".crew-change-process button.close", function () {
       crewChangeLayout.hide();
    });

    $(document).on('change', '#atd, #etd', function () {
         DelayFieldSet();
    });

    $(document).on('change', '.delay_time', function () {
        CheckDelayTimeForLimitation($(this).parents('.form-inline'));
    });

    /**
     * Create date time picker fields
     * @return void
     */
    $(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1
    });

    $(".timepicker").datetimepicker({
        format: "H:i",
        closeOnDateSelect: true,
        yearEnd: parseInt(new Date().getFullYear() + 2),
        dayOfWeekStart: 1,
        step: 1,
        datepicker: false,
        value: "00:00"
    });


    $(".remove-delay-btn").click(function() {
        var _this = $(this), parent = _this.parent(),  all_delays = parent.find('.item-delay'),
            item_delay = parent.find('.item-delay:last');
        if (all_delays.length > 1){
            item_delay.remove();
        }
        else {
            item_delay.find("select").val("");
            item_delay.find("input[type='text']").val("00:00");
        }
    });


    /**
     * Add delay button click handler
     * @return void
     */
    $(".add-delay-btn").click(function() {
        var _this = $(this), parent = _this.parent(), item_delay = parent.find('.item-delay:first'), last, duration;

        var clone_item_delay = item_delay.clone(), p = $("<p/>");
        clone_item_delay.find("select").val("");
        duration = clone_item_delay.find("input[type='text']").val("00:00");

        last = parent.find(".item-delay:last");
        clone_item_delay.insertAfter(last);

        duration.datetimepicker({
            format: "H:i",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            step: 1,
            dayOfWeekStart: 1,
            datepicker: false
        });
    });

    /**
     * Add person button click handler
     * @return {Boolean}
     */
    $(".add-person").on("click", function () {
        var _this = $(this), _prev = _this.prev().clone(), maxAllowed = parseInt(_this.attr('data-maxAllowed')),
            field_name = _this.attr("data-field"), dateInput,
            item_number = parseInt(_prev.attr("data-item-number"));

        // Enable Remove Button
        _this.next('.remove-person').attr('disabled', false);

        if (item_number == maxAllowed) {
            _this.attr("disabled", true);
            showMessage("Not more available", "Information", MESSAGE_INFO, $("#form_flight_messages"));
            return false;
        }

        item_number++;
        _prev.attr("data-item-number", item_number);
        _prev.find("label:first").html("No." + item_number);
        _prev.find("select:first")
            .val("")
            .attr("id", field_name + item_number);
        _prev.find('span.reason').hide();

        var html = $("<div></div>").append(_prev).html();
        $(html).insertBefore(_this);

        AddDateFormatElement($("input.reportTime"), "Y-m-d H:i", true, 5);
        reasonShowOnCrewChange();

        return true;
    });

    reasonShowOnCrewChange();


    $(".remove-person").on('click', function(){
        var _this = $(this), parent = _this.parent('div'), lastCrew = parent.find('span.item:last'),
            minAllowed = _this.attr('data-minAllowed'), itemNumber = lastCrew.attr('data-item-number');

        // Enable Add Person Button
        _this.prev('.add-person').attr('disabled', false);

        if (itemNumber == minAllowed){
            if (minAllowed == 1){
                lastCrew.find('select, input').val('');
                lastCrew.find('span.reason').hide();
            }
            else {
                _this.attr('disabled', true);
            }
            return false;
        }

        lastCrew.remove();
        return true;

    });

    /**
     * Tab click handler, load appropriate tab content
     * @return void
     */
    $('a[data-toggle="tab"]').on("shown.bs.tab", function (e) {
        var _current_tab = $(e.target), current_tab_name = _current_tab.attr("href").replace("#", ""),
            request;
        switch (current_tab_name) {
            case TAB_PNL:
                loadPNLList();
                break;
            case TAB_PL:
                loadPLList();
                break;
            case TAB_MVT:
                loadMVTMessages();
                break;
            case TAB_GENERAL:
            default:
                break;
        }
    });

    /**
     * Is diversion checkbox change event handler
     * @return void
     */
    $("#is_diversion").on("change", function () {
        var _this = $(this), diverted_flight = $("#diverted_flight").val();

        if (_this.is(":checked")) {
            $(".diversion_item").show();
            $("#diversion_airport").attr("required", "required");
            if (!diverted_flight) {
                $("#diversion_arrival").show();
                $("#diversion_departure").show();
                $("#diversion_sta").attr("required", "required");
                $("#diversion_std").attr("required", "required");
            }
        } else {
            $(".diversion_item").hide();
            $("#diversion_arrival").hide();
            $("#diversion_departure").hide();
            $("#diversion_airport").removeAttr("required");
            $("#diversion_sta").removeAttr("required");
            $("#diversion_std").removeAttr("required");
        }
    });

    /**
     * Manual Flight No Selection
     */
    $("#manual_flt_no").on("change", function () {
        var _this = $(this);
        if (_this.is(":checked")) {
            $("#manual_flt_no_div").show();
            $("#flt_no").attr("required", "required");
            $("#departure_airport").attr("required", "required");
            $("#arrival_airport").attr("required", "required");
            $("#flight_type").attr("required", "required");
            $("#flight_number_id").removeAttr("required");
        } else {
            $("#manual_flt_no_div").hide();
            $("#flt_no").removeAttr("required");
            $("#departure_airport").removeAttr("required");
            $("#arrival_airport").removeAttr("required");
            $("#flight_type").removeAttr("required");
            $("#flight_number_id").attr("required", "required");
        }
    });

    /**
     * Flight form cancel button click handler
     * @return void
     */
    $("#cancel_btn").on("click", function () {
        var _form = $(this).parents('form');

        clearFlightForm();
        EnableStdSta();
        timeline.setSelection([]);
        $("#flight_add_btn").show();
        $("#flight_update_btn").hide();
        $("#cancel_btn").hide();
        $("#flight_restore_btn").hide();

        _form.find("input").removeAttr("disabled");
        _form.find("select").removeAttr("disabled");
        _form.find("a").removeAttr("disabled");
        _form.find("button").removeAttr("disabled");
    });


    /**
     * Set PTD Value equal to STD value if Empty
     */
    $("#std").on("change", function () {
        var _this = $(this), ptd = $('#ptd');
        if (ptd.val() == ""){
            ptd.val(_this.val());
        }
    });

    /**
     * Set PTA value equal to STA value if Empty
     */
    $("#sta").on("change", function () {
        var _this = $(this), pta = $('#pta');
        if (pta.val() == ""){
            pta.val(_this.val());
        }
    });

    function EnableStdSta(){
        var std = $('#std'), sta = $("#sta");

        std.removeAttr('disabled');
        sta.removeAttr('disabled');

        std.attr('required', 'required');
        sta.attr('required', 'required');
    }


    /**
     * Flight form flight number select box change handler
     * @return void
     */
    $("#flight_number_id").on("change", function () {
        var _this = $(this), flight_number_id = _this.val(), request,
            flight_number = parseInt(_this.find('option:selected').html()),
            outbound_flight_number_id = $("#outbound_flight_number_id");

        return;

        $("#outbound_flight_number_block").hide();
        if (flight_number_id) {
            if (isEven(flight_number)) {
                _this.attr("disabled", true);
                request = $.ajax({
                    type: "GET",
                    url: baseUrl + "/flight/ajax-flight-get-parent-flight",
                    dataType: "json",
                    data: {
                        flight_number_id: flight_number_id,
                        flight_number: flight_number
                    }
                });
                request.done(function (data) {

                    if (typeof data.success !== "undefined") {
                        showMessage(data.message, "Success!", MESSAGE_SUCCESS, _form_flight_messages);
                        // show parent flight numbers select box

                        if (typeof data.flights !== "undefined") {
                            $("#outbound_flight_number_block").show();
                            outbound_flight_number_id.attr('required', 'required');
                            outbound_flight_number_id.find("option:not(:first)").remove();
                            for (var i = 0, l = data.flights.length; i < l; i++) {
                                outbound_flight_number_id.append("<option value='" + data.flights[i].id + "'>" +
                                data.flights[i].label + "</option>")
                            }
                        }
                    } else {
                        outbound_flight_number_id.removeAttr('required');
                        showMessage(data.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
                    }
                });
                request.fail(function (jqXHR, text_status) {
                    showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, _form_flight_messages);
                });
                request.always(function () {
                    _this.attr("disabled", false);
                });
            }
            else {
                outbound_flight_number_id.removeAttr('required');
            }
        }
    });

    /**
     * Send departure MVT message button click handler
     * @return void
     */
    $("#send-departure-message-btn, #send-arrival-message-btn").on("click", function () {
        var _this = $(this), id = _this.attr("id"), request, subject, message, notification_mvt_block;
        if (id == "send-departure-message-btn") {
            message = $("#departure_message_mvt");
            subject = $("#departure_message_subject");
            notification_mvt_block = $("#departure-mvt-notification");
        } else {
            message = $("#arrival_message_mvt");
            subject = $("#arrival_message_subject");
            notification_mvt_block = $("#arrival-mvt-notification");
        }

        // todo: need to add validation for delay ID if flight was delayed

        if (!message.val()) {
            return false;
        }

        _this.attr('disabled', true).html('Processing...');
        request = $.ajax({
            headers: {
                'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/flight/ajax-send-mvt-message",
            type: "POST",
            dataType: "json",
            data: {
                subject: subject.val(),
                message: message.val()
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                message.val("");
                showMessage(data.message, data.title, MESSAGE_SUCCESS, notification_mvt_block);
            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, notification_mvt_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, notification_mvt_block);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Send Message");
        });
    });

    /**
     * Load PNL passengers list
     * @return void
     */
    function loadPNLList() {
        var request, pnl_message_block = $("#pnl-message-block"),
            pnl_table = $('#pnl-table'), pnl_container = $("#pnl-container"),
            pnl_table_body = $("#pnl-table-body"), fare;

        //if (pnl_table.attr('data-opened') == "1")
        //    return;


        pnl_message_block.empty();
        pnl_table_body.empty();

        var loading = $('<h1 class="ajax-loading-animation"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
        //pnl_table_body.append(loading);

        pnl_container.prepend(loading);

        // send AJAX request to load passengers list
        request = $.ajax({
            url: baseUrl + "/passenger/ajax-get-pnl-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                std: flight_info_modal.attr('data-std'),
                flight_id: flight_info_modal.attr('data-flight_id'),
                flight_number_id: flight_info_modal.attr('data-flight_number_id'),
            }
        });
        request.done(function (data) {
            if (typeof data.passengers !== "undefined") {
                if (data.passengers.length) {
                    pnl_table_body.empty();
                    for (var i = 0, l = data.passengers.length; i < l; i++) {
                        fare = parseFloat(data.passengers[i].fare).toFixed(0);
                        pnl_table_body.append("<tr class='text-center'>" +
                            "<td>" + (i + 1) + "</td>" +
                            "<td data-left>" + data.passengers[i].last_name + "</td>" +
                            "<td data-left>" + data.passengers[i].first_name + "</td>" +
                            "<td data-left>" + data.passengers[i].ticket_number + "</td>" +
                            "<td>" + data.passengers[i].coupon + "</td>" +
                            "<td data-left>" + (data.passengers[i].sales_date ? data.passengers[i].sales_date : "") + "</td>" +
                            "<td data-right>" + (data.passengers[i].fare ? parseFloat(data.passengers[i].fare).toFixed(0) : "") + "</td>" +
                            "<td data-left>" + (data.passengers[i].fare_basis ? data.passengers[i].fare_basis : "") + "</td>" +
                            "<td>" + (data.passengers[i].rbd ? data.passengers[i].rbd : "") + "</td>" +
                            "</tr>");
                    }
                    $("#pnl-table").show();
                    //ApplyTableFilter("#pnl-table", ASSETS_URL);

                    //ApplyTablesorter("#pnl-table");
                } else {
                    $("#pnl-table").hide();
                    showMessage("Not found any passengers in this flight", "No Result!", MESSAGE_INFO, pnl_message_block);
                }
            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, pnl_message_block);
            }
        });
        request.always(function () {
            pnl_table.attr("data-opened", "1");
            pnl_message_block.find('.ajax-loading-flight-info').remove();
            loading.remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, pnl_message_block);
        });
    }

    /**
     * Load PL passengers list
     * @return void
     */
    function loadPLList() {
        var request, pl_message_block = $("#pl-message-block"),
            pl_table = $("#pl-table"), pl_container = $("#pl-container"),
            pl_table_body = $("#pl-table-body"), fare;

        //if (pl_table.attr('data-opened') == "1")
        //    return;

        pl_message_block.empty();
        pl_table_body.empty();

        var loading = $('<h1 class="ajax-loading-animation loading"><i class="fa fa-cog fa-spin"></i> Loading...</h1>');
        //pl_table_body.prepend(loading);

        pl_container.prepend(loading);

        // send AJAX request to load passengers list
        request = $.ajax({
            url: baseUrl + "/passenger/ajax-get-pl-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                std: flight_info_modal.attr('data-std'),
                flight_id: flight_info_modal.attr('data-flight_id'),
                flight_number_id: flight_info_modal.attr('data-flight_number_id'),
            }
        });
        request.done(function (data) {
            if (typeof data.passengers !== "undefined") {
                if (data.passengers.length > 0) {
                    pl_table_body.empty();
                    for (var i = 0, l = data.passengers.length; i < l; i++) {
                        fare = parseFloat(data.passengers[i].fare).toFixed(0);
                        pl_table_body.append("<tr class='text-center'>" +
                            "<td>" + (i + 1) + "</td>" +
                            "<td data-left>" + data.passengers[i].last_name + "</td>" +
                            "<td data-left>" + data.passengers[i].first_name + "</td>" +
                            "<td>" + (data.passengers[i].gender         ? getGenderAbbr(data.passengers[i].gender) : '') + "</td>" +
                            "<td>" + (data.passengers[i].seat_number    ? data.passengers[i].seat_number    : '') + "</td>" +
                            "<td>" + (data.passengers[i].cabin          ? data.passengers[i].cabin          : '') + "</td>" +
                            "<td data-right>" + (data.passengers[i].baggage_pcs    ? data.passengers[i].baggage_pcs    : '') + "</td>" +
                            "<td data-right>" + (data.passengers[i].baggage_weight ? data.passengers[i].baggage_weight : '') + "</td>" +
                            "<td data-left>" + (data.passengers[i].dob            ? data.passengers[i].dob            : '') + "</td>" +
                            "</tr>");
                    }
                    $("#pl-table").show();
                    //ApplyTablesorter();
                } else {
                    $("#pl-table").hide();
                    showMessage("Not found any passengers in this flight", "No Result!", MESSAGE_INFO, pl_message_block);
                }
            } else {
                showMessage(data.message, data.title, MESSAGE_DANGER, pl_message_block);
            }
        });
        request.always(function () {
            pl_table.attr("data-opened", "1");
            pl_message_block.find('.ajax-loading-flight-info').remove();
            loading.remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, pl_message_block);
        });
    }





    $(document).on('click', '#flight_update_btn', function () {
       return true;
    });


    /**
     * Save Changes
     */
    $(document).on('click', '#flight_update_btn', function () {
        var std = $('#std'), ptd = $('#ptd'), etd = $('#etd'), atd = $('#atd'), abn = $('#abn'),
            sta = $('#sta'), pta = $('#pta'), eta = $('#eta'), tdn = $('#tdn'), ata = $('#ata'),
            flight_time, result;

        flight_time = {
            std : std.val(),
            ptd : ptd.val(),
            etd : etd.val(),
            atd : atd.val(),
            abn : abn.val(),
            sta : sta.val(),
            pta : pta.val(),
            eta : eta.val(),
            tdn : tdn.val(),
            ata : ata.val()
        };

        // Flight Time Validate
        result = flightTimeValidation(flight_time);

        if (!result.status) {
            window.scrollTo(0, 100);
            showMessage(result.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
            return result.status;
        }

        result = checkDuplicateCrewNames();

        if (!result.status) {
            window.scrollTo(0, 100);
            showMessage(result.message, "Error!", MESSAGE_DANGER, _form_flight_messages);
        }

        return result.status;
    });


    /**
     * Check If There are Duplication In Crew Names
     */
    function checkDuplicateCrewNames(){
        var crew = $(".fleetwatch_form").find(".crew"), id, crewIds = [], duplicateFound = false,
            duplicateCrewName = [], _this;


        crew.each(function () {
            _this = $(this);
            // Remove Has-Error Class
            _this.parent().removeClass('has-error');
            id = _this.val();
            if (id && id !== ''){
                // if In Array Then => Duplicate Found
                if ($.inArray(id, crewIds) != -1){
                    duplicateFound = true;
                    duplicateCrewName.push(_this.find(':selected').text());
                    _this.parent().addClass("has-error");
                }
                crewIds.push(id);
            }

        });

        if (duplicateFound){
            return {
                status : false,
                message: 'Crew: ' + implode(duplicateCrewName, ', ') + ' is duplicated. No duplication is Allowed.'
            };
        }

        // Return True If All Checks Passed
        return {
            status : true,
            message: 'Success'
        };

    }


    /**
     * Flight Time Validation
     * @param flight_time
     * @returns {boolean}
     */
    function flightTimeValidation(flight_time){
        // Flight MUST HAVE STD & STA
        if (flight_time.std && flight_time.sta){
            // STD, STA check
            if (moment(flight_time.sta).isBefore(flight_time.std)){ return false;}

            // STD, STA check
            if (moment(flight_time.pta).isBefore(flight_time.ptd)){ return false;}

            // ETD Check If Exists
            if (flight_time.etd){
                if (flight_time.eta || flight_time.ata){
                    if (flight_time.eta) {
                        if (moment(flight_time.eta).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > ETA (ETD should not exceed ETA)'
                            };
                        }
                    }

                    if (flight_time.ata) {
                        if (moment(flight_time.ata).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > ATA (ETD should not exceed ATA)'
                            };
                        }
                    }

                    if (flight_time.tdn) {
                        if (moment(flight_time.tdn).isBefore(flight_time.etd)) {
                            return {
                                status : false,
                                message: 'ETD > TDN (ETD should not exceed TDN)'
                            };
                        }
                    }
                }
                else {
                    if (moment(flight_time.sta).isBefore(flight_time.etd)){
                        return {
                            status : false,
                            message: 'Please Fill Out ETA'
                        };
                    }
                }
            }

            // ATD Check If Exists
            if (flight_time.atd){
                if (flight_time.eta || flight_time.ata){
                    if (flight_time.ata || flight_time.tdn){
                        if (flight_time.ata) {
                            if (moment(flight_time.ata).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > ATA (ATD should not exceed ATA)'
                                };
                            }
                        }
                        if (flight_time.tdn) {
                            if (moment(flight_time.tdn).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > TDN (ATD should not exceed TDN)'
                                };
                            }
                        }
                    }
                    else {
                        if (flight_time.eta) {
                            if (moment(flight_time.eta).isBefore(flight_time.atd)) {
                                return {
                                    status : false,
                                    message: 'ATD > ETA (ATD should not exceed ETA)'
                                };
                            }
                        }
                    }
                }
                else {
                    if (moment(flight_time.sta).isBefore(flight_time.atd)){
                        return {
                            status : false,
                            message: 'Please Fill Out ETA'
                        };
                    }
                }
            }

            // ABN Check If Exists
            if (flight_time.abn){

                // If Atd is Empty OR if ATD is After ABN -> FALSE
                if (!flight_time.atd || (moment(flight_time.atd).isAfter(flight_time.abn))){
                    if (!flight_time.atd) {
                        return {
                            status: false,
                            message: 'Please Fill Out ATD'
                        };
                    }
                    else {
                        return {
                            status: false,
                            message: 'Error! ATD cannot exceed ABN'
                        };
                    }
                }


                if ( flight_time.ata || flight_time.tdn){
                    if (flight_time.ata) {
                        if (moment(flight_time.ata).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > ATA (ABN should not exceed ATA)'
                            };
                        }
                    }
                    if (flight_time.tdn) {
                        if (moment(flight_time.tdn).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > TDN (ABN should not exceed TDN)'
                            };
                        }
                    }
                }
                else {
                    if (flight_time.eta) {
                        if (moment(flight_time.eta).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'ABN > ETA (ABN should not exceed ETA)'
                            };
                        }
                    }
                    else {
                        if (moment(flight_time.sta).isBefore(flight_time.abn)) {
                            return {
                                status : false,
                                message: 'Please Fill Out ETA'
                            };
                        }
                    }
                }
            }

            // If TDN is After ATA -> FALSE
            if (flight_time.tdn){
                if (!flight_time.atd){
                    return {
                        status : false,
                        message: 'Please Fill Out ATD'
                    };
                }
                if (!flight_time.abn){
                    return {
                        status : false,
                        message: 'Please Fill Out ABN'
                    };
                }
                if (moment(flight_time.tdn).isAfter(flight_time.ata)){
                    return {
                        status : false,
                        message: 'TDN > ATA (TDN should not exceed ATA)'
                    };
                }
            }

            // Return True If All Checks Passed
            return {
                status : true,
                message: 'Success'
            };

        }

        return {
            status : false,
            message: 'STD and STA is Mandatory Fields. Please Fill Them Out.'
        };
    }




    /**
     * Get Gender Abbr
     * @param gender
     * @returns {*}
     */
    function getGenderAbbr(gender){
        if (gender){
            if (gender.toUpperCase() == 'MALE')
                return 'M';
            else
                return 'F';
        }
        return gender;
    }

    /**
     * Load MVT flight messages
     * @return void
     */
    function loadMVTMessages() {
        var request, mvt_message_block = $("#mvt-message-block"), fare,
            mvt_container = $("#mvt-container"), email_body, i, l, readyMessage,
            departure_mvt_container = $("#departure-mvt-container"),
            arrival_mvt_container = $("#arrival-mvt-container");

        mvt_message_block.empty();
        departure_mvt_container.empty();
        arrival_mvt_container.empty();
        mvt_container.append(ajax_loading_flight_info);

        // send AJAX request to load MVT messages
        request = $.ajax({
            url: baseUrl + "/flight/ajax-get-mvt-messages-list",
            type: "GET",
            dataType: "json",
            cache: true,
            data: {
                flight_id:  $("#flight_info_modal").attr('data-flight_id')
            }
        });
        request.done(function (data) {
            if (typeof data.departureMVT !== "undefined") {
                if (data.departureMVT.length > 0 || data.arrivalMVT.length > 0 ) {

                    departure_mvt_container.empty();
                    for (i = 0; i < data.departureMVT.length; i++) {
                        departure_mvt_container.append("<div class='mvt-message-item " + data.departureMVT[i].type + "'>" +
                            "<pre>" + data.departureMVT[i].readyData + "</pre>" +
                            "</div>");
                    }

                    arrival_mvt_container.empty();
                    for (i = 0; i < data.arrivalMVT.length; i++) {
                        arrival_mvt_container.append("<div class='mvt-message-item " + data.arrivalMVT[i].type + "'>" +
                            "<pre>" + data.arrivalMVT[i].readyData + "</pre>" +
                            "</div>");
                    }
                } else {
                    showMessage("Not found any MVT messages for this flight", "No Result!", MESSAGE_INFO, mvt_message_block);
                }
            }
        });
        request.always(function () {
            mvt_container.find('.ajax-loading-flight-info').remove();
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, mvt_message_block);
        });
    }



    function getFlightId() {
    }

    function getFlightNumberId() {
    }

    /**
     * Update fuel fields
     * @return void
     */
    $("#in_tanks, #arrival_fuel, #uplifted").keyup(function (e) {
        var in_tanks = parseInt($("#in_tanks").val()),
            uplifted = parseInt($("#uplifted").val()),
            utilised = parseInt($("#utilised").val()),
            arrival_fuel = parseInt($("#arrival_fuel").val());


        if (isNaN(uplifted)) uplifted = 0;
        if (isNaN(in_tanks)) in_tanks = 0;
        if (isNaN(utilised)) utilised = 0;
        $("#departure_fuel").val(in_tanks + uplifted);
        if (arrival_fuel) {
            $("#utilised").val(in_tanks + uplifted - arrival_fuel);
        } else {
            $("#arrival_fuel").val("");
        }
    });
    /**
     * Click update fuel button
     * @return void
     */
    $("#update-fuel-btn").on("click", function () {
        var flight_id = $("#flight_id").val(), _this = $(this), request;

        _this.attr("disabled", true).html("loading...");
        request = $.ajax({
            url: baseUrl + "/flight/ajax-fuel",
            type: "GET",
            dataType: "json",
            data: {
                flight_id: flight_id
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                $("#in_tanks").val(parseInt(data.in_tanks)).trigger("keyup");
            } else {
                showMessage("Not found fuel value in previous flight", "Information!", MESSAGE_INFO, messageBlock);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error", MESSAGE_DANGER, messageBlock);
        });
        request.always(function () {
            _this.attr("disabled", false).html("Update Fuel");
        });
    });

});