/**
 * Created by Compas on 09.12.2014.
 */

$.fn.clicktoggle = function (a, b) {
    return this.each(function () {
        var clicked = false;
        $(this).click(function () {
            if (clicked) {
                clicked = false;
                return b.apply(this, arguments);
            }
            clicked = true;
            return a.apply(this, arguments);
        });
    });
};

$(function () {

    var aircraft_id = $("#aircraft_id").val();

    $(".show-history-certificates").clicktoggle(
        function () {
            var _this = $(this), certificate_id = _this.attr("data-certificate-id"), request,
                message_block = $("#message-certificate");

            _this.attr("disabled", true);
            console.log(1)
            request = $.ajax({
                url: baseUrl + "/fleet-management/ajax-certificate-history",
                type: "GET",
                dataType: "json",
                data: {
                    certificate_id: certificate_id,
                    aircraft_id: aircraft_id
                }
            });
            request.done(function (data) {
                if (typeof data.success !== "undefined") {
                    var history_log = data.history;
                    if (history_log.length) {
                        var tr = _this.parents("tr").next(".history"), i, l;
                        var table = tr.parent();
                        var history = $("<table class='table table-condensed' style='width: 50%'>" +
                        "<tr><th>User ID</th><th>From</th><th>To</th></tr>" +
                        "</table>");

                        for (i = 0 , l = history_log.length; i < l; i++) {
                            history.append("<tr>" +
                            "<td>" + history_log[i].created_by + "</td>" +
                            "<td>" + history_log[i].valid_from + "</td>" +
                            "<td>" + history_log[i].valid_to + "</td>" +
                            "</tr>");
                        }
                        tr.find("td")
                            .empty()
                            .append("<h5>Certificate History</h5>")
                            .append(history);
                            tr.show();
                        _this.html("Hide History");
                    } else {
                        //_this.trigger("click");
                    }
                } else {
                    showMessage(data.message, data.title, MESSAGE_WARNING, message_block);
                    //_this.trigger("click");
                }
            });
            request.fail(function (jqXHR, text_status) {
                showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
                //_this.trigger("click");
            });
            request.always(function () {
                _this.attr("disabled", false);
            });
        },
        function () {
            var _this = $(this), tr = _this.parents("tr").next(".history"), i, l;
            tr.find("td").empty().hide();
            _this.html("Show History");
        }
    );

    /**
     * Edit certificate button click handler
     * @return void
     */
    $(".edit-certificate").click(function () {
        var _this = $(this), parent = _this.parents("td"), from = parent.prevAll(".from"), to = parent.prevAll(".to"),
            from_value = $.trim(from.html()), to_value = $.trim(to.html());

        if (from_value == "—") {
            from_value = "";
        }
        if (to_value == "—") {
            to_value = "";
        }
        from.empty();
        to.empty();
        from.append($("<input type='text' class='form-control input-sm datepicker' style='width:120px' value='" + from_value + "' name='from' />"));
        to.append($("<input type='text' class='form-control input-sm datepicker' style='width:120px' value='" + to_value + "' name='to' />"));
        _this.hide();
        _this.next().show();
        _this.next().next().show();

        $(".datepicker").datetimepicker({
            format: "Y-m-d",
            closeOnDateSelect: true,
            yearEnd: parseInt(new Date().getFullYear() + 2),
            dayOfWeekStart: 1,
            timepicker: false
        });
    });

    /**
     * Cancel button click handler
     * @return void
     */
    $(".cancel-certificate").click(function () {
        var _this = $(this), parent = _this.parents("td"), from = parent.prevAll(".from"), to = parent.prevAll(".to"),
            from_value = _this.attr("data-from"), to_value = _this.attr("data-to");
        if (from_value == "") {
            from_value = "&mdash;";
        }
        if (to_value == "") {
            to_value = "&mdash;";
        }
        from.empty().html(from_value);
        to.empty().html(to_value);
        _this.hide();
        _this.prev().hide();
        _this.prev().prev().show();
    });

    /**
     * Save certificate button click handler
     * @return bool
     */
    $(".save-certificate").click(function () {
        var _this = $(this), parent = _this.parents("td"), from = parent.prevAll(".from"), to = parent.prevAll(".to"),
            from_value = from.find("input").val(), to_value = to.find("input").val(), request,
            message_block = $("#message-certificate");

        if (!from_value) {
            // show error
            return false;
        }

        _this.attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/fleet-management/ajax-save-certificate",
            type: "POST",
            dataType: "json",
            data: {
                aircraft_id: $("#aircraft_id").val(),
                from: from_value,
                to: to_value,
                certificate_id: _this.attr("data-certificate-id")
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, data.title, MESSAGE_SUCCESS, message_block);
                to.empty().html(to_value);
                from.empty().html(from_value);
                _this.attr("data-from", from_value).attr("data-to", to_value).hide();
                _this.prev().attr("data-from", from_value).attr("data-to", to_value).show();
                _this.next().attr("data-from", from_value).attr("data-to", to_value).hide();
            } else {
                showMessage(data.message, data.title, MESSAGE_WARNING, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
        });
    });

    /**
     * Edit button click handler
     * @return void
     */
    $(".edit-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(), value = $.trim(prev.html()),
            param_name = _this.attr("data-param");
        if (value == "—") {
            value = "";
        }
        prev.empty();
        // prev.append($("<input type='text' class='form-control input-sm' style='width:200px' name='" + param_name + "' value='" + value + "' />"));
        _this.hide();
        _this.next().show();
        _this.next().next().show();
    });

    /**
     * Cancel button click handler
     * @return void
     */
    $(".cancel-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(),
            param_value = _this.attr("data-value");

        if (param_value == "") {
            param_value = "&mdash;";
        }
        prev.html(param_value);
        _this.hide();
        _this.prev().hide();
        _this.prev().prev().show();
    });

    /**
     * Save param button click handler
     * @return void
     */
    $(".save-param").click(function () {
        var _this = $(this), parent = _this.parents("td"), prev = parent.prev(), value = prev.find("input").val(),
            param_name = _this.attr("data-param"), request, message_block = $("#message-parameters");

        if (!value) {
            // show error
            return false
        }
        _this.attr("disabled", true);
        request = $.ajax({
            url: baseUrl + "/fleet-management/ajax-parameter",
            type: "GET",
            dataType: "json",
            data: {
                aircraft_id: $("#aircraft_id").val(),
                parameter: param_name,
                value: value
            }
        });
        request.done(function (data) {
            if (typeof data.success !== "undefined") {
                showMessage(data.message, data.title, MESSAGE_SUCCESS, message_block);
                prev.html(value);
                _this.attr("data-value", value).hide();
                _this.prev().attr("data-value", value).show();
                _this.next().attr("data-value", value).hide();
            } else {
                showMessage(data.message, data.title, MESSAGE_WARNING, message_block);
            }
        });
        request.fail(function (jqXHR, text_status) {
            showMessage("Request failed: " + text_status, "Error!", MESSAGE_DANGER, message_block);
        });
        request.always(function () {
            _this.attr("disabled", false);
        });
    });

});