/**
 * Created by WebSomonair on 24.10.2014.
 */
$(document).ready(function() {

    function isArray(obj) {
        return Object.prototype.toString.call(obj) === '[object Array]';
    }

//    google.setOnLoadCallback(drawChart2);

    var chart = new google.visualization.ColumnChart(document.getElementById('chart')), options = {},
        data, header, row = {};

    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        // Get the name of active tab
        var activeTab = $(e.target).text();
        // Get the name of previous tab
        var previousTab = $(e.relatedTarget).text();
        $(".active-tab span").html(activeTab);
        $(".previous-tab span").html(previousTab);
        if (activeTab == "Graphs"){

        }

    });

    function activateTab(tab){
        $('.nav-tabs a[href="#' + tab + '"]').tab('show');
    };

    function activateTdLinks() {
        $("td a.var").on('click', function () {
            var _this = $(this), var_name = _this.attr('data-name');
            activateTab('tab2');

            var chartOriginal = $('#chart'), div_id = 'chart', chart_div, parent = chartOriginal.parent('div');
            parent.children().not('#chart').remove(), chartOriginal.hide();
            console.log(row[var_name])
            $.each(row[var_name], function (i, val) {

                if (chartOriginal.is(':hidden')){
                    chartOriginal.show();
                }
                else {
                    div_id = 'chart'+ i,
                    chart_div = chartOriginal.clone().attr('id', div_id);
                    parent.append(chart_div);
                }

                chart = new google.visualization.ColumnChart(document.getElementById(div_id));
                data = google.visualization.arrayToDataTable(prepareDataForChart(header, val));
                if (Object.keys(row[var_name]).length > 1)
                    options.title = i.replace(new RegExp("_", "g"), ' ');
                else
                    options.title = var_name;
                chart.draw(data, options);



            });
        });
    }


    function myErrorHandler(){
        console.log('IT HAPPENED')

    }

    // Listen for the 'select' event, and call my function selectHandler() when
    // the user selects something on the chart.



    function drawFinanceChart(availablePeriods, variableTypes,  records, period, year){

        var _name, final_data = [], title;

        header = ['Period'];
        year.reverse();

        $.each(year, function (i,yr) {
            header.push(yr);
        });


        $.each(records, function(name, object){
            _name = name.replace(new RegExp("_", "g"), ' ');
            row[_name] = {};
            $.each(object, function(revenue_type, _obj){
                if ($.inArray(revenue_type, variableTypes) !== -1) {
                    row[_name][revenue_type] = {};
                    $.each(_obj, function (month, _obj2) {
                        $.each(_obj2, function (yr, value) {

                            switch (period) {
                                case 0:
                                    title = yr;
                                    break;
                                case 1:
                                    title = "Quarter " + month;
                                    break;
                                case 2:
                                    title = moment(month, 'M').format('MMM');
                                    break;
                                default :
                                    title = month;
                                    break;
                            }
                            if (typeof row[_name][revenue_type][title] === 'undefined')
                                row[_name][revenue_type][title] = [title];

                            row[_name][revenue_type][title].push(value);
                        });
                    });
                }
            });
        });

        console.log(row)

        var options = {
            title : 'Finance Report',
            vAxis: {title: "Rev"},
            hAxis: {title: "Month/Year"},
            seriesType: "bars",
            series: {5: {type: "line"}},
            height: 500,
            width : 800
        };
        //chart.draw(data, options);

        //var chart = new google.charts.Line(document.getElementById('chart'));

        //chart.draw(chart_data, options);
    }

    function prepareDataForChart(header, row){
        var final_data = [];
        final_data.push(header);
        $.each(row, function (index, val) {
            final_data.push(val);
        });
        return final_data;
    }


    $('#submit_form').click(function () {

        var _this = $(this), parent_node = $('#message_div');

        var mode = $('input[type="radio"][name="mode[]"]:checked');
        if (mode.val() == 'standard'){
            var report = $('#report').val();
            var category = $("#category").val();
            var variable = $('#variable');
            var period = parseInt($('#period').val());

            var variable_val = variable.val();
            var variable_select = $('#variable option:selected');
            var variable_category = variable_select.map(function(){
                return $(this).attr('data-category_id');
            }).get();
        }
        else{

        }

        var month = $('#month').val();
        var year = $('#year').val();

        var variable_ids = [];
        var flight_numbers = [];
        $.each(variable, function(i, id){
            if (isNumber(id)){
                variable_ids.push(id);
            }
            else{

            }

        });

        var columns = parseInt(parent_node.find('table').attr('data-columns'));

        if (isNaN(columns))
            columns = 2;



        if (month === null || year === null || category === null || report === null || variable_val === null){
            if (report === null)
                getMessageDiv("Warning",parent_node,"Report is not selected. Please select report and then proceed.");
            else if (category === null)
                getMessageDiv("Warning",parent_node,"Category is not selected. Please select category and then proceed.");
            else if (variable_val === null)
                getMessageDiv("Warning",parent_node,"Variable is not selected. Please select variable and then proceed.");
            else if (month === null || year === null)
                getMessageDiv("Warning",parent_node);
        }
        else {
            var date =[];
            console.log(month);
            $.each(month, function(j, item){
                $.each(year, function(i, value){
                    //var mo = parseInt(moment(item, 'MM').month());
                    date.push(moment({year: value, month: item - 1, day: 1}).format('YYYY-MM-DD'));
                });
            });
            console.log(_this.parents('form').find('input[name=_token]').val());

            if (variable.length > 0) {
                $('#loading').show();
                var request = $.ajax({
                    headers: {
                        'x-csrf-token': _this.parents('form').find('input[name=_token]').val()
                    },
                    url: baseUrl + "/finance/ajaxsearchdata",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        report           : report,
                        category         : category,
                        variable         : variable_val,
                        variable_category: variable_category,
                        date             : date,
                        year             : year,
                        period           : period
                    }
                });

                request.done(function (data) {

                    console.log(data);

                    var availablePeriods = data.availablePeriods, variableTypes = data.variableTypes, records = data.records,
                        table = $('#table_div'), thead_elem, tbody_elem, tr_elem, td_elem, th_elem, table_elem, span_elem,
                        month_name, tr_elem2,tr_elem3, value, comparison_val, found = 0, no = 1, available_months = [],
                        periods, period_name, colspan, variable_name, var_type_name;

                    console.log(variableTypes)

                    drawFinanceChart(availablePeriods, variableTypes,  records, period, year);

                    table.children().remove();

                    switch (period){
                        case 0: // Yearly
                            periods = availablePeriods;
                            colspan = periods.length == 2 ? 3 : periods.length;
                            break;
                        case 1: // Quarterly
                            periods = availablePeriods;
                            colspan = periods.length * (year.length == 2 ? 3 : year.length);
                            break;
                        case 2: // Monthly
                            periods = availablePeriods;
                            colspan = periods.length * (year.length == 2 ? 3 : year.length);
                            break;
                        default:
                            break;
                    }

                    table_elem = $('<table></table>').addClass("table table-bordered table-striped table-hover");

                    // thead --------------------------------------
                    thead_elem = $('<thead></thead>');
                    tr_elem = $('<tr></tr>');

                    th_elem = $('<th></th>').addClass('text-center').addClass('vertical-center').attr('rowspan', 3).text('No');
                    th_elem.appendTo(tr_elem);

                    th_elem = $('<th></th>').addClass('text-center')
                                            .addClass('vertical-center')
                                            .attr('style', 'min-width:150px !important')
                                            .attr('rowspan', 3)
                                            .text('Variable');
                    th_elem.appendTo(tr_elem);

                    tr_elem2 = $('<tr></tr>');
                    tr_elem3 = $('<tr></tr>');




                    $.each(records, function(var_name, object){
                        $.each(object, function (_valueType, _obj){
                            if ($.inArray(_valueType, variableTypes) !== -1) {
                                var_type_name = _valueType.replace(new RegExp("_", "g"), ' ');
                                th_elem = $('<th></th>')
                                    .attr('colspan', colspan)
                                    .text(var_type_name);
                                th_elem.appendTo(tr_elem);

                                $.each(periods, function (k, mo) {
                                    th_elem = $('<th></th>').addClass('text-center');

                                    switch (period) {
                                        case 0: // Yearly
                                            period_name = mo;
                                            break;
                                        case 1: // Quarterly
                                            period_name = "Quarter " + mo;
                                            break;
                                        case 2: // Monthly
                                            period_name = moment(mo, 'M').format('MMMM');
                                            break;
                                        default:
                                            break;
                                    }
                                    if (period > 0) {
                                        if (year.length == 2)
                                            th_elem.attr('colspan', year.length + 1);
                                        else
                                            th_elem.attr('colspan', year.length);
                                    }

                                    tr_elem2.append(th_elem.text(period_name));

                                    if (period > 0) {
                                        $.each(year, function (y, yr) {
                                            tr_elem3.append($('<th></th>').text(yr));
                                        });

                                        if (year.length == 2) {
                                            tr_elem3.append($('<th></th>').text('VLY'));
                                        }
                                    }
                                });

                                if (period == 0 && periods.length == 2) {
                                    tr_elem2.append($('<th></th>').text('VLY'));
                                }
                            }

                        });
                        return false;
                    });

                    tr_elem.appendTo(thead_elem);
                    tr_elem2.appendTo(thead_elem);
                    tr_elem3.appendTo(thead_elem);

                    thead_elem.appendTo(table_elem);




                    // TBODY ---------------------------------------------



                    tbody_elem = $('<tbody></tbody>');
                    $.each(records, function(var_name, object){

                        tr_elem = $('<tr></tr>');
                        tr_elem.append($('<td></td>').text(no++));

                        variable_name = var_name.replace(new RegExp("_", "g"), ' ');
                        td_elem = $('<td></td>').append($('<a></a>').attr('data-name', variable_name).addClass('var').text(variable_name));
                        tr_elem.append(td_elem);


                        $.each(object, function (_valueType, _obj){
                            if ($.inArray(_valueType, variableTypes) !== -1) {
                                if (period == 0) {
                                    comparison_val = [];
                                }

                                $.each(periods, function (x, mo) {
                                    if (period > 0) {
                                        if (typeof _obj[mo] !== 'undefined') {
                                            comparison_val = [];

                                            $.each(year, function (y, yr) {
                                                td_elem = $('<td></td>');
                                                if (typeof _obj[mo][yr] !== 'undefined' && _obj[mo][yr] !== null) {
                                                    value = _obj[mo][yr];
                                                    comparison_val.push(value);
                                                    td_elem.text($.number(value, (value > 0 && value < 1 ? 2 : 0)));
                                                }

                                                td_elem.appendTo(tr_elem);
                                            });

                                            if (Object.keys(_obj[mo]).length == 2 && comparison_val.length > 0) {
                                                td_elem = $('<td></td>');
                                                td_elem.append(getVlyComparisonSign(comparison_val));
                                                td_elem.appendTo(tr_elem);
                                            }
                                            else if (year.length == 2) {
                                                $('<td></td>').appendTo(tr_elem);
                                            }
                                        }
                                        else {
                                            if (year.length == 2)
                                                td_elem = $('<td></td><td></td><td></td>');
                                            else
                                                td_elem = $('<td></td><td></td>');
                                            td_elem.appendTo(tr_elem);
                                        }
                                    }
                                    else if (period == 0) {
                                        if (typeof _obj[1][mo] !== 'undefined') {

                                            td_elem = $('<td></td>');
                                            if (typeof _obj[1][mo] !== 'undefined' && _obj[1][mo] !== null) {
                                                value = _obj[1][mo];
                                                comparison_val.push(value);
                                                td_elem.text($.number(value, (value > 0 && value < 1 ? 2 : 0)));


                                            }
                                            td_elem.appendTo(tr_elem);

                                        }
                                    }
                                });
                                if (period == 0) {

                                    if (Object.keys(_obj[1]).length == 2 && comparison_val.length > 0) {
                                        td_elem = $('<td></td>');
                                        td_elem.append(getVlyComparisonSign(comparison_val));
                                        td_elem.appendTo(tr_elem);
                                    }
                                    else if (year.length == 2) {
                                        $('<td></td>').appendTo(tr_elem);
                                    }
                                }
                            }
                        });

                        tr_elem.appendTo(tbody_elem);
                    });
                    // ---------------------------------------------------
                    tbody_elem.appendTo(table_elem);

                    table_elem.appendTo(table);
                    activateTdLinks();
                    Apply_Tablesorter();
                    getMessageDiv("Success", parent_node,  'Found: '+Object.keys(records).length+' records');
                });
                request.fail(function (jqXHR, text_status) {
                    getMessageDiv("Error", parent_node)
                });

                request.always(function () {
                    $('#loading').hide();
                });
            }
            else {
                getMessageDiv("Warning", parent_node, 'No data was saved. Please input before save.')
            }
        }

        return false;
    });


    function number_format(n) {
        n = n.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        return n;
    }


    $('#report').change(function() {
        selectType("Report", $("option:selected", this), $('#category'), 1);
        selectType("Category", $("#category option:selected"), $('#variable'), 1);
    });

    $('#category').change(function() {
        selectType("Category", $("option:selected", this), $('#variable'), 1);
    });


    function selectType(type_select, parent, child, removeOptions){

        var id = [];
        for (var i=0; i< parent.length; i++){
            id.push($(parent[i]).val());
        }

        if (id.length > 0) {
            var request = $.ajax({
                type: 'GET',
                dataType: 'json',
                url: baseUrl + "/finance/ajaxtypeselect",
                data: {
                    type_select: type_select,
                    id: id
                }
            });
            request.done(function (data) {
                var categories = data[0];
                if (typeof data[1] !== 'undefined') {
                    var category_id = data[1];
                }
                // subcategories is json, loop over it and populate the subcategory select
                var categoryItems = "", j = 0;

                $.each(categories, function (i, item) {
                    categoryItems += "<option value='" + i + "' ";
                    if (typeof category_id !== 'undefined') {
                        //console.log(item.substring(0, 2))
                       // if (item.substring(0, 2) == 'fn') item = item.substr(2);
                        categoryItems += "data-category_id='" + category_id[j++] + "' ";
                    }

                    categoryItems += ">" + item + "</option>";
                });

                if (typeof removeOptions !== 'undefined')
                    child.find('option').remove();

                child.append(categoryItems)
                    .multiselect('rebuild');

            });
        }
        else{
            console.log('No options should be selected')
            child.find('option').remove();
            child.multiselect('rebuild');
        }

    }

    function reportCategoryVariable(parent_id){
        if (typeof parent_id === 'undefined' || parent_id == 'report') {
            selectType("Report", $("#report option:selected"), $('#category'), 1);
            selectType("Category", $("#category option:selected"), $('#variable'), 1);
        }
        else if (parent_id == 'category')
            selectType("Category", $("#category option:selected"), $('#variable'), 1);
    }

    reportCategoryVariable();

    $(".multiselect_finance-toggle").click(function(e) {
        e.preventDefault();
        var _this = $(this), parent = _this.parent('div'), parent_id = parent.find('select').attr('id'),
            select = parent.find("select.multiselect_search");

        if (multiselect_selected(select)) {
            console.log(3333)
        }
        multiselect_toggle(select, _this);

        reportCategoryVariable(parent_id);

    });
});