/**
 * Created by WebSomonair on 03.10.2014.
 */



$(document).ready(function(){

    var message_box = $('#message_box');

    $(".category").click(function(){
        var details = $(this).next('.details');

        if (details.hasClass('hidden'))
            details.removeClass('hidden');
        else
            details.addClass('hidden');
    });

    var rosters = $('#rosters'), crew = $('#crew'), load_roster = $('#load_roster'),
    cancel_roster = $('#cancel_roster'), publish_roster = $('#publish_roster'),
    roster_info = $('#roster_info');

    publish_roster.confirm({
        text: "Are you sure you want to publish current generated roster?",
        title: "Publish Roster",
        confirm: function(button) {
            AjaxSaveRoster();
        },
        cancel: function(button) {
            // nothing to do
        },
        confirmButton: "Yes",
        cancelButton: "No",
        post: true,
        confirmButtonClass: "btn-primary"
    });

    cancel_roster.confirm({
        text: "Are you sure you want to cancel published generated roster?",
        title: "Publish Roster",
        confirm: function(button) {
            AjaxCancelRoster();
        },
        cancel: function(button) {
            // nothing to do
        },
        confirmButton: "Yes",
        cancelButton: "No",
        post: true,
        confirmButtonClass: "btn-primary"
    });



    crew.on('change', function () {
        AjaxLoadRosterList($(this).val());
        CrewTypeCheck();
    });

    function CrewTypeCheck(){
        if (crew.val() == ''){
            rosters.attr('disabled', 'disabled');
            load_roster.attr('disabled', 'disabled');
            cancel_roster.attr('disabled', 'disabled');
        }
        else {
            rosters.removeAttr('disabled');
            load_roster.removeAttr('disabled');
            cancel_roster.removeAttr('disabled');
        }
    }

    CrewTypeCheck();

    function AjaxLoadRosterList(crew_type){
        request = $.ajax({
            url:        baseUrl + '/crewroster/ajax-load-roster-list',
            type:       'GET',
            dataType:   'json',
            data: {
                crew_type: crew_type
            }
        });

        request.done(function (data) {

            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box, data.message);
                var roster_list = data.rosters_list;

                rosters.children().remove();
                $.each(roster_list, function(id, value){
                    rosters.append($("<option></option>").attr('value',id).text(value));
                });
            }
        });

        request.fail(function (jqXHR, text_status) {
            getMessageDiv('Error', message_box, text_status);

        });
    }




    function AjaxCancelRoster(){
        var roster_id = $('select[name ="rosters"]').val();
        request = $.ajax({
            url: baseUrl + "/crewroster/ajax-cancel-roster",
            type: 'GET',
            dataType: 'json',
            data: {
                roster_id : roster_id
            }
        });

        request.done(function (data) {

            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box,'Published Roster was Successfully Cancelled');
            }
        });
        request.fail(function (jqXHR, text_status) {

        });
    }


    function AjaxSaveRoster(){
        request = $.ajax({
            url: baseUrl + "/crewroster/ajax-publish-roster",
            type: 'POST',
            dataType: 'json',
            data: {
                from: $from,
                to: $to,
                fcm: $fcm,
                flights_scheduled: $flights_scheduled,
                other_settings: $other_settings
            }
        });


        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box,'Roster Published Successfully');
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_box,'Roster Was Not Published');
        });
    }

    $paginate_value = 10;


    function AjaxLoadRoster(roster_id){
        $('.loading_modal').modal('show');
        request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/crewroster/ajax-load-roster",
            type: 'POST',
            dataType: 'json',
            data: {
                roster_id: roster_id
            }
        });

        request.done(function (data) {

            if (typeof data.success !== 'undefined') {
                $('.loading_modal').modal('hide');
                console.log(data);

                $fcm = data.json_files[0];
                $flights_scheduled = data.json_files[1];

                $from = data.from;
                $to = data.to;
                $other_settings = data.other_settings;
                $lbd_min = data.other_settings['lbd_min'];
                $keys = data.json_files[2].keys;

                $pseudo_dyu_purser = data.json_files[2].pseudo_dyu_purser;
                $pseudo_dyu_cc = data.json_files[2].pseudo_dyu_cc;
                $pseudo_lbd_purser = data.json_files[2].pseudo_lbd_purser;
                $pseudo_lbd_cc = data.json_files[2].pseudo_lbd_cc;
                $flights_crew = data.json_files[2].flights_crew;
                $admin_settings = data.json_files[2].admin_settings;

                var roster_details = data.roster_details;
                getMessageDiv("Success", message_box,'Roster Loaded Successfully');
                Load_Roster_Details(roster_details);
                Load_Content();
                Roster_Tab_Start();
                Apply_Tablesorter();
            }
        });

        request.fail(function (jqXHR, text_status) {
            $('.loading_modal').modal('hide');
            $('#load_content').children().remove();
            getMessageDiv("Error", message_box,'Error! Could Not Load Roster');
        });
    }



    load_roster.click(function () {
        var roster_id = rosters.val();
        var crew_type = crew.val();
        AjaxLoadRoster(roster_id, crew_type);
    });


    function Load_Roster_Details(roster_details){
        console.log($admin_settings)
        var content = '';
            content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">'+
                    '<thead>'+
                        '<tr>'+
                            '<th>Roster Type</th>'+
                            '<th>From</th>'+
                            '<th>To</th>'+

                            '<th>Published Date</th>'+
                            '<th>Agent</th>'+

                            '<th>Last Update</th>'+
                            '<th>Agent</th>'+
                        '</tr>'+
                    '</thead>'+
                    '<tbody>'+
                        '<tr>'+
                            '<td>'+(roster_details.type).toUpperCase()+'</td>'+
                            '<td>'+roster_details.roster_from+'</td>'+
                            '<td>'+roster_details.roster_to+'</td>'+

                            '<td>'+roster_details.published_date+'</td>'+
                            '<td>'+roster_details.user_id+'</td>'+

                            '<td>'+roster_details.updated_at+'</td>'+
                            '<td>'+roster_details.updated_by+'</td>'+
                        '</tr>'+
                    '</tbody>'+
                '</table>';

        roster_info.html(content);
    }

    function Load_Content(){
        var crew_type = crew.val();
        var parent = $('#load_content');
        var content = '';
        content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">'+
            '<thead>'+
                '<tr>'+
                    '<th rowspan="3" class="text-center">Total CCM</th>'+
                    '<th colspan="4" class="text-center">Flights</th>'+
                    '<th colspan="9" class="text-center">Required Purser</th>'+
                    '<th colspan="9" class="text-center">Required Cabin Crew</th>'+
                    '<th colspan="9" class="text-center">Required Total</th>'+
                '</tr>'+
                '<tr>'+
                    '<th rowspan="2">Scheduled</th>'+
                    '<th rowspan="2">With No Crew</th>'+
                    '<th rowspan="2">Min Required Not Met</th>'+
                    '<th rowspan="2">Stand-by Shortage</th>'+
                    '<th colspan="3" class="text-center">DYU</th>'+
                    '<th colspan="3" class="text-center">LBD</th>'+
                    '<th colspan="3" class="text-center">TOTAL</th>'+
                    '<th colspan="3" class="text-center">DYU</th>'+
                    '<th colspan="3" class="text-center">LBD</th>'+
                    '<th colspan="3" class="text-center">TOTAL</th>'+
                    '<th colspan="3" class="text-center">DYU</th>'+
                    '<th colspan="3" class="text-center">LBD</th>'+
                    '<th colspan="3" class="text-center">TOTAL</th>'+
                '</tr>'+
                '<tr>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                    '<th>Add</th>'+
                    '<th>Req</th>'+
                    '<th>Total</th>'+
                '</tr>'+
            '</thead>'+
            '<tbody>'+
                '<tr>'+
                    '<td>'+Object.keys($keys).length+'</td>'+
                    '<td>'+$flights_scheduled.length+'</td>'+
                    '<td>'+$flights_crew['no_crew']+'</td>'+
                    '<td>'+$flights_crew['less_min']+'</td>'+
                    '<td>'+$flights_crew['standby_shortage']+'</td>';

                switch (crew_type){
                    case "fcm":
                        content +=  '<td class="add">'+$other_settings['captain_dyu_add']+'</td>'+
                                    '<td class="req">'+$other_settings['captain_dyu_req']+'</td>'+
                                    '<td>'+$other_settings['captain_dyu']+'</td>'+
                                    '<td class="add">'+$other_settings['captain_lbd_add']+'</td>'+
                                    '<td class="req">'+$other_settings['captain_lbd_req']+'</td>'+
                                    '<td>'+$other_settings['captain_lbd']+'</td>'+
                                    '<td class="add">'+$other_settings['captain_total_add']+'</td>'+
                                    '<td class="req">'+$other_settings['captain_total_req']+'</td>'+
                                    '<td>'+$other_settings['captain_total']+'</td>'+
                                    '<td class="add">'+$other_settings['fo_dyu_add']+'</td>'+
                                    '<td class="req">'+$other_settings['fo_dyu_req']+'</td>'+
                                    '<td>'+$other_settings['fo_dyu']+'</td>'+
                                    '<td class="add">'+$other_settings['fo_lbd_add']+'</td>'+
                                    '<td class="req">'+$other_settings['fo_lbd_req']+'</td>'+
                                    '<td>'+$other_settings['fo_lbd']+'</td>'+
                                    '<td class="add">'+$other_settings['fo_total_add']+'</td>'+
                                    '<td class="req">'+$other_settings['fo_total_req']+'</td>'+
                                    '<td>'+$other_settings['fo_total']+'</td>';
                        break;
                    case "ccm":
                        content +=  '<td class="add">'+$other_settings['purser_dyu_add']+'</td>'+
                                    '<td class="req">'+$other_settings['purser_dyu_req']+'</td>'+
                                    '<td>'+$other_settings['purser_dyu']+'</td>'+
                                    '<td class="add">'+$other_settings['purser_lbd_add']+'</td>'+
                                    '<td class="req">'+$other_settings['purser_lbd_req']+'</td>'+
                                    '<td>'+$other_settings['purser_lbd']+'</td>'+
                                    '<td class="add">'+$other_settings['purser_total_add']+'</td>'+
                                    '<td class="req">'+$other_settings['purser_total_req']+'</td>'+
                                    '<td>'+$other_settings['purser_total']+'</td>'+
                                    '<td class="add">'+$other_settings['cc_dyu_add']+'</td>'+
                                    '<td class="req">'+$other_settings['cc_dyu_req']+'</td>'+
                                    '<td>'+$other_settings['cc_dyu']+'</td>'+
                                    '<td class="add">'+$other_settings['cc_lbd_add']+'</td>'+
                                    '<td class="req">'+$other_settings['cc_lbd_req']+'</td>'+
                                    '<td>'+$other_settings['cc_lbd']+'</td>'+
                                    '<td class="add">'+$other_settings['cc_total_add']+'</td>'+
                                    '<td class="req">'+$other_settings['cc_total_req']+'</td>'+
                                    '<td>'+$other_settings['cc_total']+'</td>';

                        break;
                }


               content += '<td class="add">'+$other_settings['total_dyu_add']+'</td>'+
                    '<td class="req">'+$other_settings['total_dyu_req']+'</td>'+
                    '<td>'+$other_settings['total_dyu']+'</td>'+
                    '<td class="add">'+$other_settings['total_lbd_add']+'</td>'+
                    '<td class="req">'+$other_settings['total_lbd_req']+'</td>'+
                    '<td>'+$other_settings['total_lbd']+'</td>'+
                    '<td class="add">'+$other_settings['total_add']+'</td>'+
                    '<td class="req">'+$other_settings['total_req']+'</td>'+
                    '<td>'+$other_settings['total']+'</td>'+
                '</tr>'+
            '</tbody>'+
        '</table>'+

        '<h4 class="col-md-12" style="margin-bottom: 10px;">'+
        '<span class="crewroster_item"><span class="flight_color flight_without_crew"></span> Flight Without Crew</span>'+
        '<span class="crewroster_item"><span class="flight_color flight_not_min_req"></span> Flight Min Requirement Not Accomplished</span>'+
        '<span class="crewroster_item"><span class="flight_color contractor"></span> Contractor</span>'+
        '<span class="crewroster_item"><span class="flight_color flight_with_dhc"></span> DHC / Flight With DHC</span>'+
        '<span class="crewroster_item"><span class="flight_color purser"></span> Purser</span>'+
        '<span class="crewroster_item"><span class="flight_color standby"></span> Stand-by</span>'+
        '<span class="crewroster_item"><span class="flight_color not-exists"></span> Rest Requirements Are NOT Met / Stand-by NOT Assigned</span>'+
        '</h4>'+

        '<div class="tabbable">'+
            '<ul class="nav nav-tabs">'+
                '<li class="active"><a href="#tab1" data-toggle="tab">Roster</a></li>'+
                '<li><a href="#tab2" data-toggle="tab" id="flights_tab">Flights</a></li>'+
                '<li><a href="#tab3" data-toggle="tab" id="standby_tab">Stand-by</a></li>'+
                '<li><a href="#tab4" data-toggle="tab" id="report_tab">Report</a></li>'+
                '<li><a href="#tab5" data-toggle="tab" id="dhc_tab">DHC</a></li>'+
                '<li><a href="#tab6" data-toggle="tab" id="dhc_tab">Designated Flights</a></li>'+
            '</ul>'+
            '<div class="tab-content">'+
                '<div class="tab-pane active" id="tab1" style="padding-top: 10px;"></div>'+
                '<div class="tab-pane" id="tab2" style="padding-top: 10px;"></div>'+
                '<div class="tab-pane" id="tab3" style="padding-top: 10px;"></div>'+
                '<div class="tab-pane" id="tab4" style="padding-top: 10px;"></div>'+
                '<div class="tab-pane" id="tab5" style="padding-top: 10px;"></div>'+
                '<div class="tab-pane" id="tab6" style="padding-top: 10px;"></div>'+
            '</div>'+
        '</div>';

        parent.html(content);
        Apply_Tablesorter(parent);
    }

    function admin_settings() {
        var admin_form =  $('#frm_roster_admin');
        admin_form.find('input,select,button').prop('disabled', true)
    }

    admin_settings();

    function check_dhc_pseudo(){
        var lbd_dhc_option = $('#lbd_dhc_option');
        var lbd_pseudo_option = $('#lbd_pseudo_option');
        var lbd_none_option = $('#lbd_none_option');

        var dyu_pseudo_option = $('#dyu_pseudo_option');
        var dyu_none_option = $('#dyu_none_option');

        if (lbd_dhc_option.is(':checked')){
            lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', false);
            lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
        }
        else if (lbd_pseudo_option.is(':checked')){
            lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', true);
            lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', false);
        }
        else if (lbd_none_option.is(':checked')){
            lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', true);
            lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
        }

        if (dyu_pseudo_option.is(':checked')) {
            dyu_pseudo_option.parent('label').nextUntil('#dyu_none').find('input').prop('disabled', false);
        }
        else if (dyu_none_option.is(':checked')) {
            dyu_pseudo_option.parent('label').nextUntil('#dyu_none').find('input').prop('disabled', true);
        }

    }

    check_dhc_pseudo();

    $('#lbd_dhc_option').click(function () {
        $(this).parent('label').next('div').find('input').prop('disabled', false);
        $('#lbd_pseudo_option').parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
    });


    $('#lbd_pseudo_option').click(function () {
        $(this).parent('label').nextUntil('#lbd_none').find('input').prop('disabled', false);
        $('#lbd_dhc_option').parent('label').next('div').find('input').prop('disabled', true);
    });

    $('#lbd_none_option').click(function () {
        $('#lbd_pseudo_option').parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
        $('#lbd_dhc_option').parent('label').next('div').find('input').prop('disabled', true);
    });

    $('#dyu_pseudo_option').click(function () {
        $(this).parent('label').nextUntil('#dyu_none').find('input').prop('disabled', false);
    });

    $('#dyu_none_option').click(function () {
        $('#dyu_pseudo_option').parent('label').nextUntil('#dyu_none').find('input').prop('disabled', true);
    });


    $('#export_excel').click(function () {
       $('.tab-pane.active').find('.mytable[data-excel="1"]').tableExport({type:'excel',escape:'true'});
    });

    function Pagination_Range(page, group_int){
        var start = (page - 1) * group_int + 1;
        var end = page * group_int;
        return [start, end];
    }

    function Pagination_Add_Event() {
        $(".pagination a.page").click(function () {
            Paginate_Event($(this));
        });

        $('#roster_tab').click(function () {
            Paginate_Event($('.pagination').find("a.page[data-position='0']"));
        });

        $('#flights_tab').click(function () {
            Flights_Tab();
        });

        $('#standby_tab').click(function () {
            Standby_Tab();
        });

        $('#report_tab').click(function () {
            Report_Tab();
        });

        $('#dhc_tab').click(function () {
            DHC_Tab();
        });

        $('#designated_tab').click(function () {
            Designated_Tab();
        });
    }


    function Designated_Tab(){
        var parent = $('#tab6');
        var content = '';

        if(Object.keys($designated).length > 0) {
            content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">'+
            '<thead>'+
            '<tr>'+
            '<th class="text-center">Flight Id</th>'+
            '<th class="text-center">Flight No</th>'+
            '<th class="text-center">Date</th>'+
            '<th colspan="6" class="text-center">CCM</th>'+
            '</tr>'+
            '</thead>'+
            '<tbody>';
            $.each($designated['flight_number'], function($i, $flight_number) {
                content += '<tr>'+
                '<td>' + $designated['flights'][$i].join('/') + '</td>' +
                '<td>' + $flight_number + '</td>' +
                '<td>' + $designated['date'][$i] + '</td>';
                $.each($designated['crew'][$i], function ($j, $id) {
                    content += '<td ' + ($fcm[$id].purser && typeof $fcm[$id].purser !== 'undefined' ? 'class = "purser"' : '') + ' >' +
                    $fcm[$id].last_name + " " + $fcm[$id].first_name + '<span class="crew_id_small">' + $id + '</span>' +
                    '</td>';
                });
                content += '</tr>';
            });
            content += '</tbody>'+
            '</table>';


        }

        parent.html(content);
        Apply_Tablesorter(parent);
    }


    function Roster_Tab_Start(){
        var $pages;
        var content = '';
        var $keys_length = Object.keys($keys).length;

        if ($keys_length % $paginate_value == 0)
            $pages = ($keys_length / $paginate_value);
        else
            $pages =  Math.floor($keys_length / $paginate_value) + 1;

        console.log(1)
        console.log($pages)

        content += '<ul class="pagination ul_bordered" style="margin: 10px;">'+
        '<li><a href="#" class="page" data-page="1" data-position = "0">«</a></li>';

        for(var i = 1; i <= $pages; i++) {
            content += '<li '+(i == 1 ? 'class="active"' : '') +'>' +
            '<a href="#" class="page" data-page = "'+i+'" data-position = "-1">'+i+'</a>'+
            '</li>';
        }

        content += '<li '+ ($pages == 1 ? 'class="disabled"' : '') +'><a href="#" class="page" data-page = "'+$pages+'" data-position = "1">»</a></li>'+
        '</ul>'+
        '<div id="roster_details" style="margin-bottom: 20px;"></div>';

        $('#tab1').html(content);
        Pagination_Add_Event();
        Paginate_Event($('.pagination').find("a.page[data-position='0']"));

    }

    function Paginate_Event (selected_element) {
        var page = selected_element.attr('data-page');

        var page_array = Pagination_Range(page, $paginate_value);
        var start = page_array[0];
        var end = page_array[1];
        var roster_div = $("#roster_details");
        var start_page = $('.pagination').find("a.page[data-position='0']");
        var end_page = $('.pagination').find("a.page[data-position='1']");

        var start_page_value = start_page.attr('data-page');
        var end_page_value = end_page.attr('data-page');

        $(".pagination li").removeClass('active');
        var containing = selected_element.text();
        if (containing == '»') {
            selected_element.parent('li').addClass('disabled');
            var last_page = $('.pagination').find("a.page[data-position='-1'][data-page='" + page + "']");
            last_page.parent('li').addClass('active');

        }
        else if (containing == '«') {
            selected_element.parent('li').addClass('disabled');
            var first_page = $('.pagination').find("a.page[data-position='-1'][data-page='" + page + "']");
            first_page.parent('li').addClass('active');
        }
        else
            selected_element.parent('li').addClass('active');


        if (page == start_page_value)
            start_page.parent('li').addClass('disabled');
        else
            start_page.parent('li').removeClass('disabled');

        if (page == end_page_value)
            end_page.parent('li').addClass('disabled');
        else
            end_page.parent('li').removeClass('disabled');


        var content = '';
        var display_sectors_dyu = ['FRA', 'IST', 'DXB', 'URC', 'ALA', 'DME'];
        var display_sectors_dyu_rest = ['LED','SVX', 'IKT', 'KZN', 'KRR', 'KJA', 'REN'];
        var display_sectors_lbd = ['DME', 'LED', 'KZN', 'KRR', 'KJA', 'REN','AER','HMA', 'NJC','TJM'];

        var iteration = 0;
        $.each($keys, function (index, $i) {

            iteration++;
            if (iteration < start)
                return true;
            if (iteration > end)
                return false;

            if (!$fcm[$i].details || !$fcm[$i].details['thumb'])
                var $picture = baseUrl + "/assets/img/default-user-picture.png";
            else
                var $picture = baseUrl + "/storage/users//" + $fcm[$i].details['thumb'];

            var $rowspan1 = 1, $rowspan2 = 1;

            if (typeof $fcm[$i].schedule !== 'undefined')
                var $rowspan1 = ($fcm[$i].schedule).length;

            //if(typeof $fcm[$i].schedule.flights !== 'undefined')
            //var $rowspan2 = ($fcm[$i].schedule.flights).length;

            var $total_planned_hours = $fcm[$i].planned_hours;
            var $last_7_days = $fcm[$i].block_hours_7;
            var $last_28_days = $fcm[$i].block_hours_28;
            var $last_12_months = $fcm[$i].block_hours_12months;

            var $iteration = 0, $dhc = true, $error_check = [];
            $error_check['previous_release_time'] = false;

            if (iteration == end)
                content += '<div class="col-lg-12" style="margin-bottom: 50px;">';
            else
                content += '<div class="col-lg-12" style="margin-bottom: 10px;">';

            var profile_url = baseUrl+"/crew/profile?id="+$i;

            content += '<div class="col-lg-3">' +
            '<div class="panel panel-primary" style="height: 480px;">' +
            '<div class="panel-heading" style="position: relative;overflow:hidden; ">'+
            '<span style="float: left"><a class="'+($fcm[$i].details && $fcm[$i].details['is_contractor'] ? 'contract' : 'staff')+'" target="_blank" href="'+profile_url+'">'+
            $fcm[$i].last_name + ' ' + $fcm[$i].first_name+'</a></span>'+
            '<span style="float: right; font-weight: bold">' + $fcm[$i].base + '</span>'+
            '</div>'+
            '<div class="panel-body">' +
            '<div style="padding-bottom: 10px;">'+
            '<div class="profile-image" style="width: 40%; float: left">' +
            '<img src="' + $picture + '" alt="Profile Image" class="img-thumbnail" style="max-height: 180px;">' +
            '</div>' +

            '<div style="float: left; width: 60%">' +
            '<table class="table table-bordered table-striped table-hover" style="width:100%; padding: 0; margin: 0">' +
            '<tbody>' +

            '<tr>' +
            '<td class="td_header">ID</td>' +
            '<td>' + $fcm[$i].id + '</td>' +
            '</tr>';



            if ($fcm[$i].details && typeof $fcm[$i].details['doj'] !== 'undefined') {
                content += '<tr>' +
                '<td class="td_header">DOJ</td>' +
                '<td>' + $fcm[$i].details['doj'] + '</td>' +
                '</tr>';
            }

            if ($fcm[$i].details && typeof $fcm[$i].details['aircraft_types'] !== 'undefined') {
                content += '<tr>' +
                '<td class="td_header">A/C Types</td>' +
                '<td>';
                var loop = 0;
                if (!$fcm[$i].details['aircraft_types']) {
                    $.each($fcm[$i].details['aircraft_types'], function ($u, $ac) {
                        content += Aircraft_Iata_Type($ac) + ', ';
                        loop = 1;
                    });
                    if (loop == 1)
                        content = content.slice(0, -2);
                }
                content += '</td>' +
                '</tr>';
            }

            if ($fcm[$i].details && $fcm[$i].details['phone']) {

                $.each($fcm[$i].details['phone'], function ($u, $phone) {
                    content += '<tr>' +
                    '<td class="td_header">' + Ucfirst($u) +'</td>' +
                    '<td>' + $phone + '</td>'+
                    '</tr>';
                });
            }

            content += '</tbody>' +
            '</table>' +
            '</div>' +
            '<div style="clear: both">'+
            '<div style="float: left; width: 40%">'+
            '<table class="table table-bordered table-striped table-hover" style="width: 100%; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>Category</th>' +
            '<th>Hours</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>' +
            '<tr>' +
            '<td class="td_header">Planned</td>' +
            '<td>' + $total_planned_hours + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">Last 7 Days</td>' +
            '<td>' + $last_7_days + '</td>' +
            '</tr>' +

            '<tr>' +
            '<td class="td_header">Last 28 Days</td>' +
            '<td>' + $last_28_days + '</td>' +
            '</tr>' +

            '<tr>' +
            '<td class="td_header">Last 12 Months</td>' +
            '<td>' + $last_12_months + '</td>' +
            '</tr>' +

            '<tr>' +
            '<td class="td_header">Standby Count</td>' +
            '<td>' + $fcm[$i].standby_count + '</td>' +
            '</tr>' +

            '<tr>' +
            '<td class="td_header">DHC Count</td>' +
            '<td>' + $fcm[$i].dhc_count + '</td>' +
            '</tr>' +
            '</tbody>' +
            '</table>' +
            '</div>'+
            '<div style="float: left; width: 30%; padding: 0 5px">'+
            '<table class="table table-bordered table-striped table-hover" style="width: 100%; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>DYU</th>' +
            '<th>№</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';
            var counter = 0;

            $.each($fcm[$i].flight_history, function ($sector, $times) {
                if ($sector.match("^DYU") ) {
                    var airport = $sector.split('-');
                    if ($.inArray(airport[1], display_sectors_dyu ) !== -1) {
                        counter++;
                        content += '<tr>' +
                        '<td class="td_header">' + airport[1] + ':</td>' +
                        '<td>' + $times + '</td>' +
                        '</tr>';
                    }
                }
            });
            if (counter < 6){
                $.each($fcm[$i].flight_history, function ($sector, $times) {
                    if (counter == 6)
                        return false;
                    if ($sector.match("^DYU") ) {
                        var airport = $sector.split('-');
                        if ($.inArray(airport[1], display_sectors_dyu_rest ) !== -1) {
                            counter++;
                            content += '<tr>' +
                            '<td class="td_header">' + airport[1] + ':</td>' +
                            '<td>' + $times + '</td>' +
                            '</tr>';
                        }
                    }
                });
            }
            content +='</tbody>' +
            '</table>' +
            '</div>'+
            '<div style="float: left; width: 30%">'+
            '<table class="table table-bordered table-striped table-hover" style="width: 100%; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>LBD</th>' +
            '<th>№</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';
            counter = 0;
            $.each($fcm[$i].flight_history, function ($sector, $times) {
                if ($sector.match("^LBD") ) {
                    if (counter == 6)
                        return false;
                    var airport = $sector.split('-');
                    if ($.inArray(airport[1], display_sectors_lbd ) !== -1) {
                        counter++;
                        content += '<tr>' +
                        '<td class="td_header">' + airport[1] + ':</td>' +
                        '<td>' + $times + '</td>' +
                        '</tr>';
                    }
                }
            });
            content +='</tbody>' +
            '</table>' +
            '</div>'+
            '</div>'+
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>' +

            '<div class="col-lg-9" style="overflow-y: auto; height: 480px; padding: 0; border:#008cba 1px solid">' +
            '<table class="table table-bordered table-striped table-hover">' +
            '<thead>' +
            '<tr>' +
            '<th>FDP Start</th>' +
            '<th>Report Time</th>' +
            '<th>FDP Max</th>' +
            '<th>FDP Current</th>' +
            '<th>FDP Cumulative</th>' +
            '<th>Block Hours</th>' +
            '<th>Release Time</th>' +
            '<th>Required Rest</th>' +
            '<th>Sectors</th>' +
            '<th>Flights Scheduled</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>' +
            '<tr>';

            var $class;
            $.each($fcm[$i].schedule, function ($j, $schedule) {
                console.log($schedule)
                if (!$schedule.error_message){
                    if ($schedule.is_dhc == 'true')
                        $class = "class = 'flight_with_dhc'";
                    else if ($schedule.is_standby === 'true')
                        $class = "class='standby'";
                    else
                        $class = '';
                }
                else
                    $class = "class = 'not-exists'";

                content += '<tr>' +
                '<td ' + $class + ' rowspan="$rowspan2">' + moment($schedule.report_time_binded).format('DD MMM HH:mm');
                if (typeof $schedule.wocl !== 'undefined') {
                    content += '<br>' +
                    '<span class="label label-danger">WOCL</span>';
                }
                content += '</td>' +
                '<td ' + $class + ' rowspan="$rowspan2">' + moment($schedule.report_time).format('DD MMM HH:mm');

                if (typeof $schedule.additional_crew !== 'undefined') {
                    content += '<br>' +
                    '<span class="label label-warning">' + $schedule.additional_crew + ' Added</span>';
                }

                content += '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_max + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_current + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_cumulative + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.block_hours + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + moment($schedule.release_time).format('DD MMM HH:mm') + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.required_rest + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.sectors + '</td>';

                $error_check['previous_release_time'] = $schedule.release_time;

                content += '<td style="padding: 0; margin: 0">' +
                '<table class="table table-bordered table-striped table-hover" style="width: 100%; padding: 0; margin: 0">' +
                '<thead>' +
                '<tr>'+
                '<th>Flight Num</th>' +
                '<th>Sector</th>' +
                '<th>STD</th>' +
                '<th>STA</th>' +
                '<tr>'+
                '</thead>' +
                '<tbody>';

                $.each($schedule.flights, function ($u, $flight) {
                    content += '<tr>' +
                    '<td>' + $flight['flight_number'] + '</td>' +
                    '<td>' + $flight['departure_airport'] + '-' + $flight['arrival_airport'] + '</td>' +
                    '<td>' + moment($flight['std']).format('DD MMM HH:mm') + '</td>' +
                    '<td>' + moment($flight['sta']).format('DD MMM HH:mm') + '</td>' +
                    '</tr>';
                });

                content += '</tbody>' +
                '</table>' +
                '</td>' +
                '</tr>';
            });

            content += '</tbody>' +
            '</table>' +
            '</div>' +
            '</div>'+

            '</div>';


        });

        roster_div.children().remove();
        roster_div.html(content);
        Apply_Tablesorter(roster_div);
    }

    function Flights_Tab(){
        var crew_type = crew.val();
        var parent = $('#tab2');
        var content = '';
        content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">'+
            '<thead>'+
                '<tr>'+
                    '<th rowspan="2">Flight ID</th>'+
                    '<th rowspan="2">Flight Num</th>'+
                    '<th rowspan="2">Sector</th>'+
                    '<th rowspan="2">STD</th>'+
                    '<th rowspan="2">STA</th>'+
                    '<th rowspan="2">Stand-by</th>'+
                    '<th rowspan="2">DHC</th>'+
                    '<th colspan="4">Cabin Crew Requirement</th>'+
                    '<th colspan="6">Cabin Crew Full Name</th>'+
                '</tr>'+
                '<tr>'+
                    '<th>Policy</th>'+
                    '<th>Minimum</th>'+
                    '<th>Required</th>'+
                    '<th>Actual</th>'+
                    '<th>Purser</th>'+
                    '<th>CC #2</th>'+
                    '<th>CC #3</th>'+
                    '<th>CC #4</th>'+
                    '<th>CC #5</th>'+
                    '<th>CC #6</th>'+
                '</tr>'+
            '</thead>'+

            '<tbody>';

        $.each($flights_scheduled, function($j,$each) {
            var $style = '';
            if ($each.crew_planned == 0)
                $style = 'class = "flight_without_crew"';
            else {
                switch (crew_type) {
                    case "fcm":
                        if ($each.crew_planned < $each.flights[0].min_fcm) {
                            $style = 'class = "flight_not_min_req"';
                        }
                        else {
                            if ($j % 2 == 0)
                                $style = 'style="background-color: #f8f8f8;"';
                        }
                        break;
                    case "ccm":
                        if ($each.crew_planned < $each.flights[0].min_ccm) {
                            $style = 'class = "flight_not_min_req"';
                        }
                        else {
                            if ($j % 2 == 0)
                                $style = 'style="background-color: #f8f8f8;"';
                        }
                        break;
                    default :
                        break;
                }
            }

            $.each($each.flights, function ($u, $flight) {
                if ($flight.crew_dhc && $flight.crew_dhc.length > 0) {
                    $style = 'class = "flight_with_dhc"';
                }

                content += '<tr>' +
                '<td ' + $style + '>' + $flight.id + '</td>' +
                '<td ' + $style + '>' + $flight.flight_number + '</td>' +
                '<td ' + $style + '>' + $flight.departure_airport +'-'+ $flight.arrival_airport + '</td>' +
                '<td ' + $style + '>' + $flight.std + '</td>' +
                '<td ' + $style + '>' + $flight.sta + '</td>' +

                '<td ' + $style + '>';
                if ($u == 0 && $flight.crew_standby) {
                    content += '<span class="glyphicon glyphicon-ok"></span>';
                }
                content += '</td>' +
                            '<td ' + $style + '>';

                if ($u == 0 && $flight.crew_dhc) {
                    content += '<span class="glyphicon glyphicon-ok"></span>';
                }

                content += '</td>' +
                '<td ' + $style + '>' + $each.crew_policy + '</td>' +
                '<td ' + $style + '>' + $each.crew_min+ '</td>' +
                '<td ' + $style + '>' + $each.crew_required+ '</td>' +
                '<td ' + $style + '>' + $each.crew_planned + '</td>';

                var $each_length = 0;
                if ($each.crew && typeof $each.crew !== 'undefined') {
                    $.each($each.crew, function ($y, $id) {
                        switch (crew_type){
                            case "fcm":
                                content += '<td ' + ($fcm[$id].captain == 'true' ? 'class = "purser"' : '') + '>';
                                break;
                            case "ccm":
                                content += '<td ' + ($fcm[$id].purser == 'true' ? 'class = "purser"' : '') + '>';
                                break;
                            default :
                                content += '<td>';
                                break;
                        }
                        content += $fcm[$id].last_name + " " + $fcm[$id].first_name +
                        '<span class="crew_id_small">' + $id + '</span></td>';
                    });
                    $each_length = $each.crew.length;
                }

                var $diff = 6 - $each_length;
                if ($diff > 0) {
                    for (var $i = 0; $i < $diff; $i++) {
                        content += '<td></td>';
                    }
                }


                content += '</tr>';

            });
        });

        content +='</tbody>' +
        '</table>';

        parent.html(content);
        Apply_Tablesorter(parent);
    }

    function Standby_Tab(){
        var parent = $('#tab3');
        var content = '';
        content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">'+
            '<thead>'+
                '<tr>'+
                    '<th rowspan="2">Flight ID</th>'+
                    '<th rowspan="2">Flight Num</th>'+
                    '<th rowspan="2">Sector</th>'+
                    '<th rowspan="2">STD</th>'+
                    '<th rowspan="2">STA</th>'+
                    '<th colspan="3">Cabin Crew Requirement</th>'+
                    '<th rowspan="2" colspan="10">First/Last Names</th>'+
                '</tr>'+
                '<tr>'+
                    '<th>Policy</th>'+
                    '<th>Minimum</th>'+
                    '<th>Actual</th>'+
                '</tr>'+
            '</thead>'+
            '<tbody>';

            $.each($flights_scheduled, function($t, $each){
                $.each($each.flights, function($j, $flight){
                    if ($j == 0) {
                        content += '<tr>'+
                            '<td>'+ $flight.id + '</td>'+
                            '<td>'+ $flight.flight_number + '</td>'+
                            '<td>'+ $flight.departure_airport + ' - ' + $flight.arrival_airport + '</td>'+
                            '<td>'+ $flight.std + '</td>' +
                            '<td>'+ $flight.sta + '</td>' +
                            '<td>'+ $flight.policy_ccm + '</td>'+
                            '<td>'+ $flight.min_ccm + '</td>'+
                            '<td>'+ $each.crew_planned + '</td>';
                        if ($flight.crew_standby) {
                            $.each($flight.crew_standby, function ($s, $id) {
                                content += '<td class="standby">'+$fcm[$id].last_name+" "+$fcm[$id].first_name+'</td>';
                            });
                        }
                        else {
                            content += '<td class="not-exists">'+
                                    '<span class="glyphicon glyphicon-remove" style="color: #FFFFFF"></span>'+
                                '</td>';
                            }
                        content += '</tr>';
                    }
                });
            });
        content += '</tbody>'+
                    '</table>';

        parent.html(content);
        Apply_Tablesorter(parent);

    }

    function Report_Tab(){
        var parent = $('#tab4');
        var $display_sectors_dyu = ['FRA', 'IST', 'DXB', 'URC', 'ALA', 'DME', 'LED','IKT', 'KRR', 'KJA','LBD'];
        var $display_sectors_dyu_rest = ['SVX', 'KZN','REN'];
        var $display_sectors_lbd = ['DME', 'LED', 'KRR', 'KJA', 'REN', 'KZN','AER', 'DYU'];
        var $display_sectors_lbd_rest = [ 'HMA', 'NJC', 'TJM'];
        var content = '';


        content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">'+
        '<thead>'+
            '<tr>'+
                '<th rowspan="2">ID</th>'+
                '<th rowspan="2">Last Name</th>'+
                '<th rowspan="2">First Name</th>'+
                '<th rowspan="2">Base</th>'+
                '<th class="text-center" colspan="5">Hours</th>'+
                '<th class="text-center" colspan="2">Count</th>'+
                '<th class="text-center" colspan="11">Top Routes From DYU (Planned Period + 90 Days)</th>'+
                '<th class="text-center" colspan="8">Top Routes From LBD (Planned Period + 90 Days)</th>'+
            '</tr>'+
            '<tr>'+
                '<th>Last Flight Date</th>'+
                '<th>Planned (' + Ucfirst($admin_settings.roster_type)+')</th>'+
                '<th>7 Days</th>'+
                '<th>28 Days</th>'+
                '<th>365 Days</th>'+
                '<th>Stand-by</th>'+
                '<th>DHC</th>';

        $.each($display_sectors_dyu, function($t, $station) {
            content += '<th>'+$station+'</th>';
        });


        $.each($display_sectors_lbd, function($t, $station) {
            content += '<th>'+$station+'</th>';
        });

        content += '</tr>'+
        '</thead>'+

            '<tbody>';
        $.each($keys, function($t,$id) {
            var keys = Object.keys($fcm[$id].flight_hours_date);
            var $last_date = keys[keys.length-1];

            content += '<tr>' +
            '<td>' + $fcm[$id].id + '</td>' +
            '<td>' + $fcm[$id].last_name + '</td>' +
            '<td>' + $fcm[$id].first_name + '</td>' +
            '<td>' + $fcm[$id].base + '</td>' +
            '<td>' + $last_date + '</td>' +
            '<td>' + $fcm[$id].planned_hours + '</td>' +
            '<td>' + $fcm[$id].block_hours_7 + '</td>' +
            '<td>' + $fcm[$id].block_hours_28 + '</td>' +
            '<td>' + $fcm[$id].block_hours_12months + '</td>' +
            '<td>' + $fcm[$id].standby_count + '</td>' +
            '<td>' + $fcm[$id].dhc_count + '</td>';

            $.each($display_sectors_dyu, function ($o, $station) {
                var $sector = "DYU-"+$station;
                if ($fcm[$id].flight_history[$sector])
                    content += '<td>' + $fcm[$id].flight_history[$sector] + '</td>';
                else
                    content += '<td>0</td>';
            });

            $.each($display_sectors_lbd, function ($p, $station) {
                var $sector = "LBD-"+$station;
                if ($fcm[$id].flight_history[$sector])
                    content += '<td>' + $fcm[$id].flight_history[$sector] + '</td>';
                else
                    content += '<td>0</td>';
            });
            content += '</tr>';
        });

    content += '</tbody>' +
    '</table>';

        parent.html(content);
        Apply_Tablesorter(parent);
    }

    function DHC_Tab(){
        var parent = $('#tab5');
        var content = '';

        content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">'+
            '<thead>'+
                '<tr>'+
                    '<th rowspan="2">Flight ID</th>'+
                    '<th rowspan="2">Flight Num</th>'+
                    '<th rowspan="2">Sector</th>'+
                    '<th rowspan="2">STD</th>'+
                    '<th rowspan="2">STA</th>'+
                    '<th colspan="3">Cabin Crew Requirement</th>'+
                    '<th rowspan="2" colspan="10">First/Last Names</th>'+
                '</tr>'+
                '<tr>'+
                    '<th>Policy</th>'+
                    '<th>Minimum</th>'+
                    '<th>Actual</th>'+
                '</tr>'+
            '</thead>'+
            '<tbody>';

        $.each($flights_scheduled, function ($j, $each) {

            $.each($each.flights, function ($t, $flight) {
                if ($flight['crew_dhc']) {
                    content += '<tr>' +
                    '<td>' + $flight['id'] + '</td>' +
                    '<td>' + $flight['flight_number'] + '</td>' +
                    '<td>' + $flight['departure_airport'] + '-' + $flight['arrival_airport'] + '</td>' +
                    '<td>' + $flight['std'] + '</td>' +
                    '<td>' + $flight['sta'] + '</td>' +
                    '<td>' + $flight['policy_ccm'] + '</td>' +
                    '<td>' + $flight['min_ccm'] + '</td>' +
                    '<td>' + $each.crew_planned + '</td>';

                    $.each($flight['crew_dhc'], function ($u, $id) {
                        content += '<td class="flight_with_dhc">' + $fcm[$id].last_name + " " + $fcm[$id].first_name + '</td>';
                    });
                    content += '</tr>';
                }
            });
        });

        content += '</tbody>'+
        '</table>';

        parent.html(content);
        Apply_Tablesorter(parent);
    }


});

