/**
 * Created by WebSomonair on 03.10.2014.
 */

$(document).ready(function(){

    var message_box = $('#message_box'),
        roster_id = $('#roster_id'),
        crew_type = $('#crew_type'),
        load_roster = $('#load_roster'),
        cancel_roster = $('#cancel_roster'),
        publish_roster = $('#publish_roster'),
        force_publish = $('#force_publish'),
        roster_info = $('#roster_info');


    crew_type.on('change', function () {
        AjaxLoadRosterList($(this).val());
        CrewTypeCheck();
    });


    $(".category").click(function(){
        var details = $(this).next('.details');

        if (details.hasClass('hidden'))
            details.removeClass('hidden');
        else
            details.addClass('hidden');
    });

    publish_roster.confirm({
        text: "Are you sure you want to publish selected roster?",
        title: "Publish Roster",
        confirm: function() {
            if (roster_id.val() && roster_id.val() != ""){
                AjaxPublishRoster(roster_id.val());
            }
            else {
                getMessageDiv('Error', message_box, "No Selected Roster. Please Select Roster");
            }
        },
        cancel: function(button) {
            // nothing to do
        },
        confirmButton: "Yes",
        cancelButton: "No",
        post: true,
        confirmButtonClass: "btn-primary"
    });

    cancel_roster.confirm({
        text: "Are you sure you want to cancel selected roster?",
        title: "Publish Roster",
        confirm: function() {
            AjaxCancelRoster();
        },
        cancel: function(button) {
            // nothing to do
        },
        confirmButton: "Yes",
        cancelButton: "No",
        post: true,
        confirmButtonClass: "btn-primary"
    });

    function CrewTypeCheck(){
        if (crew_type.val() == ''){
            roster_id.attr('disabled', 'disabled');
            load_roster.attr('disabled', 'disabled');
            cancel_roster.attr('disabled', 'disabled');
            publish_roster.attr('disabled', 'disabled');
        }
        else {
            roster_id.removeAttr('disabled');
            load_roster.removeAttr('disabled');
            cancel_roster.removeAttr('disabled');
            publish_roster.removeAttr('disabled');
        }
    }

    CrewTypeCheck();

    function AjaxLoadRosterList(crew_type_val){
        var request = $.ajax({
            url:        baseUrl + '/crewroster/ajax-load-roster-list',
            type:       'GET',
            dataType:   'json',
            data: {
                crew_type: crew_type_val
            }
        });

        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box, data.message);
                var roster_list = data.rosters_list;

                roster_id.children().remove();
                $.each(roster_list, function(id, value){
                    roster_id.append($("<option></option>").attr('value',id).text(value));
                });
            }
        });

        request.fail(function (jqXHR, text_status) {
            getMessageDiv('Error', message_box, text_status);
        });
    }


    function AjaxCancelRoster(){
        var request = $.ajax({
            url: baseUrl + "/crewroster/ajax-cancel-roster",
            type: 'GET',
            dataType: 'json',
            data: {
                roster_id : roster_id.val()
            }
        });

        request.done(function (data) {

            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box,'Published Roster was Successfully Cancelled');
            }
        });
        request.fail(function (jqXHR, text_status) {

        });
    }


    function AjaxPublishRoster(roster_id){
        var request = $.ajax({
            headers: {
                'x-csrf-token': $(document).find('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/crewroster/ajax-publish-roster",
            type: 'POST',
            dataType: 'json',
            data: {
                roster_id: roster_id,
                force_publish : force_publish.is(":checked") ? 1 : 0
            }
        });


        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                if (data.success){
                    getMessageDiv("Success", message_box, data.message);
                }
                else {
                    getMessageDiv("Error", message_box, data.message);
                }
            }
        });
        request.fail(function () {
            getMessageDiv("Error", message_box, 'Roster Was Not Published');
        });
    }


    $('#export_excel').click(function () {
       $('.tab-pane.active').find('.mytable[data-excel="1"]').tableExport({type:'excel',escape:'true'});
    });


});

