/**
 * Created by WebSomonair on 03.10.2014.
 */



//$(document).ready(function(){


$(document).on("click", ".category", function () {
    var details = $(this).next('.details');

    if (details.hasClass('hidden'))
        details.removeClass('hidden');
    else
        details.addClass('hidden');
});

//Apply_Tablesorter();

//Add_Date_Format();

$(document).on("click", "a.add_flight", function () {
    var container = $(this).parents('div.add_container');
    var next_div = container.find('div.add_flight_div');
    if (next_div.length == 1 && next_div.is(":hidden")) {
        next_div.show();
    }
    else {
        var clone_div = next_div.last().clone(false);
        var number = clone_div.find('select.input_ccm').attr('data-number');
        number++;
        clone_div.find('select.input_ccm').attr('data-number', number)
            .attr('name', 'crew' + number + '[]');

        var date_id = 'date_add' + number, input_date = clone_div.find('input.date_format');
        input_date.removeClass('.date_format').attr('data-number', number).attr('id', date_id);
        AddDateFormatElement(input_date);

        clone_div.appendTo(container);
    }

    return false;
});

$(document).on("click", ".remove_flight", function () {
    var container = $(this).parents('div.add_container');
    var container_child = container.find('div.add_flight_div');
    if (container_child.length > 1)
        container_child.last().remove();
    else
        container_child.last().hide();

    return false;

});

$(document).on("click", ".add_flight_crew", function () {
    var crew_container = $(this).parents('.add_flight_div').find('.add_flight_crew_container');
    var first_child = crew_container.children('.add_flight_crew_div').last();
    var crew_container_length = crew_container.children('div').length;
    var add_crew = first_child.clone(true);
    if (crew_container_length < 6)
        add_crew.appendTo(crew_container);

    return false;

});

$(document).on("click", ".remove_flight_crew", function () {
    var crew_container = $(this).parents('.add_flight_div').find('.add_flight_crew_div');
    if (crew_container.length > 1)
        crew_container.last().remove();

    return false;

});

$('#save_roster').confirm({
    text: "Are you sure you want to save current generated roster?",
    title: "Save Roster",
    confirm: function (button) {
        AjaxSaveRoster(button);
    },
    cancel: function (button) {
        // nothing to do
    },
    confirmButton: "Yes",
    cancelButton: "No",
    post: true,
    confirmButtonClass: "btn-primary"
});

$('#cancel_roster').confirm({
    text: "Are you sure you want to cancel published generated roster?",
    title: "Publish Roster",
    confirm: function (button) {
        AjaxCancelRoster();
    },
    cancel: function (button) {
        // nothing to do
    },
    confirmButton: "Yes",
    cancelButton: "No",
    post: true,
    confirmButtonClass: "btn-primary"
});

var message_box = $('#message_box');

function AjaxCancelRoster() {
    var roster_id = $('select[name ="rosters"]').val();
    request = $.ajax({
        url: baseUrl + "/crewroster/ajax-cancel-roster",
        type: 'GET',
        dataType: 'json',
        data: {
            roster_id: roster_id
        }
    });

    request.done(function (data) {

        if (typeof data.success !== 'undefined') {
            getMessageDiv("Success", message_box, 'Published Roster was Successfully Cancelled');
        }
    });
    request.fail(function (jqXHR, text_status) {

    });
}


function AjaxSaveRoster(button) {
    var request = $.ajax(
        {
            headers: {
                'x-csrf-token': button.parents('form').find('input[name=_token]').val()
            },
            url: baseUrl + "/crewroster/ajax-save-roster",
            type: 'POST',
            dataType: 'json',
            data: {
                rosterId: $rosterId
            }
        });

    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            if (data.success) {
                getMessageDiv("Success", message_box, data.message);
            }
            else {
                getMessageDiv("Error", message_box, data.message);
            }
        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_box, 'Roster Was Not Saved');
    });
}


function AjaxLoadRoster(folder) {
    request = $.ajax({
        url: baseUrl + "/crewroster/ajax-load-roster",
        type: 'POST',
        dataType: 'json',
        data: {
            folder: folder
        }
    });

    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            getMessageDiv("Success", message_box, 'Roster Loaded Successfully');
        }
    });
    request.fail(function (jqXHR, text_status) {
        getMessageDiv("Error", message_box, 'Error! Could Not Load Roster');
    });
}


$(document).on("click", '#load_roster', function () {
    var folder = $('#rosters').val();
    AjaxLoadRoster(folder);

    return false;

});


function admin_settings() {
    var admin_form = $('#frm_roster_admin');
    admin_form.find('input,select,button').prop('disabled', true)
}

admin_settings();

function check_dhc_pseudo() {
    var lbd_dhc_option = $('#lbd_dhc_option');
    var lbd_pseudo_option = $('#lbd_pseudo_option');
    var lbd_none_option = $('#lbd_none_option');

    var dyu_pseudo_option = $('#dyu_pseudo_option');
    var dyu_none_option = $('#dyu_none_option');

    if (lbd_dhc_option.is(':checked')) {
        lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', false);
        lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
    }
    else if (lbd_pseudo_option.is(':checked')) {
        lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', true);
        lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', false);
    }
    else if (lbd_none_option.is(':checked')) {
        lbd_dhc_option.parent('label').next('div').find('input').prop('disabled', true);
        lbd_pseudo_option.parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
    }

    if (dyu_pseudo_option.is(':checked')) {
        dyu_pseudo_option.parent('label').nextUntil('#dyu_none').find('input').prop('disabled', false);
    }
    else if (dyu_none_option.is(':checked')) {
        dyu_pseudo_option.parent('label').nextUntil('#dyu_none').find('input').prop('disabled', true);
    }

}

check_dhc_pseudo();

$(document).on("click", '#lbd_dhc_option', function () {
    $(this).parent('label').next('div').find('input').prop('disabled', false);
    $('#lbd_pseudo_option').parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);

    return false;

});


$(document).on("click", '#lbd_pseudo_option', function () {
    $(this).parent('label').nextUntil('#lbd_none').find('input').prop('disabled', false);
    $('#lbd_dhc_option').parent('label').next('div').find('input').prop('disabled', true);

    return false;

});

$(document).on("click", '#lbd_none_option', function () {
    $('#lbd_pseudo_option').parent('label').nextUntil('#lbd_none').find('input').prop('disabled', true);
    $('#lbd_dhc_option').parent('label').next('div').find('input').prop('disabled', true);

    return false;

});

$(document).on("click", '#dyu_pseudo_option', function () {
    $(this).parent('label').nextUntil('#dyu_none').find('input').prop('disabled', false);

    return false;

});

$(document).on("click", '#dyu_none_option', function () {
    $('#dyu_pseudo_option').parent('label').nextUntil('#dyu_none').find('input').prop('disabled', true);

    return false;

});


$(document).on("click", '#export_excel', function () {
    $('.tab-pane.active').find('.mytable[data-excel="1"]').tableExport({type: 'excel', escape: 'true'});

    return false;

});


function AjaxGenerateRoster(all_variables, token) {

    modal_ajax_loading.show();

    var request = $.ajax({
        headers: {
            'x-csrf-token': token
        },
        url: baseUrl + '/crewroster/ajax-generate-crew-roster',
        type: 'POST',
        dataType: 'json',
        data: all_variables
    });
    request.done(function (data) {
        if (typeof data.success !== 'undefined') {
            $rosterId = data.data.rosterId;
            $crew = data.data.crew;
            $flights_scheduled = data.data.flights_scheduled;
            $from = data.data.from;
            $to = data.data.to;
            $pseudo = data.data.pseudo;

            $pseudo_dyu_rank1 = data.data.pseudo_dyu_rank1;
            $pseudo_dyu_rank2 = data.data.pseudo_dyu_rank2;
            $pseudo_lbd_rank1 = data.data.pseudo_lbd_rank1;
            $pseudo_lbd_rank2 = data.data.pseudo_lbd_rank2;

            $lbd_min = data.data.lbd_min;
            $keys = data.data.keys;

            $flights_crew = data.data.flights_crew;
            $admin_settings = data.data.admin_settings;
            $designated = data.data.designated;
            $paginate_value = data.data.records_number;
            $other_settings = data.data.other_settings;

            getMessageDiv("Success", message_box, data.message);
            Load_Content();
            Roster_Tab_Start();
            $('#from_date').val($from);
            $('#to_date').val($to);
        }
    })
        .fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_box, 'Error! Not generated roster. Please Try Again');
        })
        .always(function () {
            modal_ajax_loading.hide();
        });


}

$(document).on("click", '#ajax_generate', function () {
    var _this = $(this),
        from = $('#from_date').val(),
        to = $('#to_date').val(),
        parent = $('div.content'),
        lbd_dhc_pseudo = $('input[name="lbd_dhc_pseudo"]:checked'),
        lbd_dhc_pseudo_val = lbd_dhc_pseudo.val(),
        dyu_pseudo = $('input[name="dyu_pseudo"]:checked'),
        dyu_pseudo_val = dyu_pseudo.val(),
        lbd_min = false,
        pseudo_lbd_rank1 = 0,
        pseudo_lbd_rank2 = 0,
        pseudo_dyu_rank1 = 0,
        pseudo_dyu_rank2 = 0,
        records_page = $('#records_number').val(),
        token = _this.parents('form').find('input[name=_token]').val();

    switch (lbd_dhc_pseudo.val()) {
        case 'dhc':
            lbd_min = lbd_dhc_pseudo.parent('label').parents('div').find('input[name="lbd_min"]').val();
            break;
        case 'pseudo':
            pseudo_lbd_rank1 = lbd_dhc_pseudo.parent('label').parents('div').find('input[name="pseudo_lbd_rank1"]').val();
            pseudo_lbd_rank2 = lbd_dhc_pseudo.parent('label').parents('div').find('input[name="pseudo_lbd_rank2"]').val();
            break;
        case 'none':
            break;
        default :
            break;
    }

    if (dyu_pseudo.val() == 'pseudo') {
        pseudo_dyu_rank1 = lbd_dhc_pseudo.parent('label').parents('div').find('input[name="pseudo_dyu_rank1"]').val();
        pseudo_dyu_rank2 = lbd_dhc_pseudo.parent('label').parents('div').find('input[name="pseudo_dyu_rank2"]').val();
    }

    var flight_nums = parent.find('select[name="add_flight_numbers[]"]');
    var flight_numbers = [];
    if (flight_nums.length > 0) {
        flight_nums.each(function () {
            flight_numbers.push($(this).val());
        });
    }

    var date = parent.find('input[name="add_date[]"]');
    var add_date = [];
    if (date.length > 0) {
        date.each(function () {
            add_date.push($(this).val());
        });
    }

    var crewArray = [];
    for (var i = 1; i <= flight_numbers.length; i++) {
        var crew = $('select[name="crew' + i + '[]"]');
        if (crew.length > 0) {
            var crewValues = [];
            crew.each(function () {
                if ($(this).val() && typeof $(this).val() !== "undefined")
                    crewValues.push($(this).val())
            });
            crewArray.push(crewValues);
        }
    }

    var all_variables = {
        'crewType': $crewType,
        'from': from,
        'to': to,
        'lbd_min': lbd_min,
        'lbd_dhc_pseudo': lbd_dhc_pseudo_val,
        'dyu_pseudo': dyu_pseudo_val,
        'pseudo_lbd_rank1': pseudo_lbd_rank1,
        'pseudo_lbd_rank2': pseudo_lbd_rank2,
        'pseudo_dyu_rank1': pseudo_dyu_rank1,
        'pseudo_dyu_rank2': pseudo_dyu_rank2,
        'add_flight_numbers': flight_numbers,
        'add_date': add_date,
        'crew': crewArray,
        'records_number': records_page
    };

    AjaxGenerateRoster(all_variables, token);

    return false;

});

function Load_Content() {
    var parent = $('#load_content');
    var content = '';
    content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">' +
        '<thead>' +
        '<tr>' +
        '<th rowspan="3" class="text-center">Total FCM</th>' +
        '<th colspan="4" class="text-center">Flights</th>' +
            /*'<th colspan="9" class="text-center">Required Captains</th>'+
             '<th colspan="9" class="text-center">Required First Officers</th>'+*/
        '<th colspan="9" class="text-center">Required Total</th>' +
        '</tr>' +
        '<tr>' +
        '<th rowspan="2">Scheduled</th>' +
        '<th rowspan="2">With No Crew</th>' +
        '<th rowspan="2">Min Required Not Met</th>' +
        '<th rowspan="2">Stand-by Shortage</th>' +
        '<th colspan="3" class="text-center">' + $location1 + '</th>' +
        '<th colspan="3" class="text-center">' + $location2 + '</th>' +
        '<th colspan="3" class="text-center">TOTAL</th>' +
            /*'<th colspan="3" class="text-center">DYU</th>'+
             '<th colspan="3" class="text-center">LBD</th>'+
             '<th colspan="3" class="text-center">TOTAL</th>'+
             '<th colspan="3" class="text-center">DYU</th>'+
             '<th colspan="3" class="text-center">LBD</th>'+
             '<th colspan="3" class="text-center">TOTAL</th>'+*/
        '</tr>' +
        '<tr>' +
        '<th>Add</th>' +
        '<th>Req</th>' +
        '<th>Total</th>' +
        '<th>Add</th>' +
        '<th>Req</th>' +
        '<th>Total</th>' +
        '<th>Add</th>' +
        '<th>Req</th>' +
        '<th>Total</th>' +

            /*'<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+
             '<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+
             '<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+

             '<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+
             '<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+
             '<th>Add</th>'+
             '<th>Req</th>'+
             '<th>Total</th>'+*/
        '</tr>' +
        '</thead>' +
        '<tbody>' +
        '<tr>' +
        '<td>' + Object.keys($keys).length + '</td>' +
        '<td>' + $flights_scheduled.length + '</td>' +
        '<td>' + $flights_crew['no_crew'] + '</td>' +
        '<td>' + $flights_crew['less_min'] + '</td>' +
        '<td>' + $flights_crew['standby_shortage'] + '</td>' +
            /*'<td class="add">'+$pseudo['captain_dyu_add']+'</td>'+
             '<td class="req">'+$pseudo['captain_dyu_req']+'</td>'+
             '<td>'+$pseudo['captain_dyu']+'</td>'+
             '<td class="add">'+$pseudo['captain_lbd_add']+'</td>'+
             '<td class="req">'+$pseudo['captain_lbd_req']+'</td>'+
             '<td>'+$pseudo['captain_lbd']+'</td>'+
             '<td class="add">'+$pseudo['captain_total_add']+'</td>'+
             '<td class="req">'+$pseudo['captain_total_req']+'</td>'+
             '<td>'+$pseudo['captain_total']+'</td>'+
             '<td class="add">'+$pseudo['fo_dyu_add']+'</td>'+
             '<td class="req">'+$pseudo['fo_dyu_req']+'</td>'+
             '<td>'+$pseudo['fo_dyu']+'</td>'+
             '<td class="add">'+$pseudo['fo_lbd_add']+'</td>'+
             '<td class="req">'+$pseudo['fo_lbd_req']+'</td>'+
             '<td>'+$pseudo['fo_lbd']+'</td>'+
             '<td class="add">'+$pseudo['fo_total_add']+'</td>'+
             '<td class="req">'+$pseudo['fo_total_req']+'</td>'+
             '<td>'+$pseudo['fo_total']+'</td>'+*/
        '<td class="add">' + $pseudo['total_dyu_add'] + '</td>' +
        '<td class="req">' + $pseudo['total_dyu_req'] + '</td>' +
        '<td>' + $pseudo['total_dyu'] + '</td>' +
        '<td class="add">' + $pseudo['total_lbd_add'] + '</td>' +
        '<td class="req">' + $pseudo['total_lbd_req'] + '</td>' +
        '<td>' + $pseudo['total_lbd'] + '</td>' +
        '<td class="add">' + $pseudo['total_add'] + '</td>' +
        '<td class="req">' + $pseudo['total_req'] + '</td>' +
        '<td>' + $pseudo['total'] + '</td>' +
        '</tr>' +
        '</tbody>' +
        '</table>' +

        '<h4 class="col-md-12" style="margin: 0 0 15px 0; padding: 0">' +
        '<span class="crewroster_item"><span class="flight_color flight_without_crew"></span> Flight Without Crew</span>' +
        '<span class="crewroster_item"><span class="flight_color flight_not_min_req"></span> Flight Min Requirement Not Accomplished</span>' +
        '<span class="crewroster_item"><span class="flight_color contractor"></span> Contractor</span>' +
        '<span class="crewroster_item"><span class="flight_color flight_with_dhc"></span> DHC / Flight With DHC</span>' +
        '<span class="crewroster_item"><span class="flight_color purser"></span> Captain</span>' +
        '<span class="crewroster_item"><span class="flight_color standby"></span> Stand-by</span>' +
        '<span class="crewroster_item"><span class="flight_color not-exists"></span> Rest Requirements Are NOT Met / Stand-by NOT Assigned</span>' +
        '</h4>' +

        '<div class="tabbable">' +
        '<ul class="nav nav-pills">' +
        '<li class="active"><a href="#tab_roster" id="roster_tab" data-toggle="tab">Roster</a></li>' +
        '<li><a href="#tab_flights" data-toggle="tab" id="flights_tab">Flights</a></li>' +
        '<li><a href="#tab_standby" data-toggle="tab" id="standby_tab">Stand-by</a></li>' +
        '<li><a href="#tab_hours" data-toggle="tab" id="hours_report_tab">Hours Report</a></li>' +
        '<li><a href="#tab_route" data-toggle="tab" id="route_report_tab">Route Report</a></li>' +
        '<li><a href="#tab_dhc" data-toggle="tab" id="dhc_tab">DHC</a></li>' +
        '<li><a href="#tab_designated" data-toggle="tab" id="designated_tab">Designated Flights</a></li>';

    content += '</ul>' +
        '<div class="tab-content">' +
        '<div class="tab-pane active" id="tab_roster" style="padding-top: 10px;"></div>' +
        '<div class="tab-pane" id="tab_flights" style="padding-top: 10px; margin-bottom: 50px;"></div>' +
        '<div class="tab-pane" id="tab_standby" style="padding-top: 10px; margin-bottom: 50px;"></div>' +
        '<div class="tab-pane" id="tab_hours" style="padding-top: 10px; margin-bottom: 50px;"></div>' +
        '<div class="tab-pane" id="tab_route" style="padding-top: 10px; margin-bottom: 50px;"></div>' +
        '<div class="tab-pane" id="tab_dhc" style="padding-top: 10px; margin-bottom: 50px;"></div>' +
        '<div class="tab-pane" id="tab_designated" style="padding-top: 10px; margin-bottom: 50px;"></div>';

    content += '</div>' +
        '</div>';

    parent.html(content);

    //Apply_Tablesorter(parent);
}


function Roster_Tab_Start() {
    var $pages;
    var content = '';
    var $keys_length = Object.keys($keys).length;

    if ($keys_length % $paginate_value == 0)
        $pages = ($keys_length / $paginate_value);
    else
        $pages = Math.floor($keys_length / $paginate_value) + 1;

    content += '<ul class="pagination ul_bordered" style="margin: 10px;">' +
        '<li><a href="#" class="page" data-page="1" data-position = "0">«</a></li>';

    for (var i = 1; i <= $pages; i++) {
        content += '<li ' + (i == 1 ? 'class="active"' : '') + '>' +
            '<a href="#" class="page" data-page = "' + i + '" data-position = "-1">' + i + '</a>' +
            '</li>';
    }

    content += '<li ' + ($pages == 1 ? 'class="disabled"' : '') + '><a href="#" class="page" data-page = "' + $pages + '" data-position = "1">»</a></li>' +
        '</ul>' +
        '<div id="roster_details" style="margin-bottom: 20px;"></div>';

    $('#tab_roster').html(content);
    Pagination_Add_Event();
    Paginate_Event($('.pagination').find("a.page[data-position='0']"));

}

function Pagination_Range(page, group_int) {
    var start = (page - 1) * group_int + 1;
    var end = page * group_int;
    return [start, end];
}

function Pagination_Add_Event() {
    $(document).on("click", ".pagination a.page", function () {
        Paginate_Event($(this));

        return false;
    });

    $(document).on("click", '#roster_tab', function () {
        Paginate_Event($('.pagination').find("a.page[data-position='0']"));
    });

    $(document).on("click", '#flights_tab', function () {
        Flights_Tab();
    });

    $(document).on("click", '#standby_tab', function () {
        Standby_Tab();
    });

    $(document).on("click", '#hours_report_tab', function () {
        Hours_Report_Tab();
    });

    $(document).on("click", '#route_report_tab', function () {
        Route_Report_Tab();
    });

    $(document).on("click", '#dhc_tab', function () {
        DHC_Tab();
    });

    $(document).on("click", '#designated_tab', function () {
        Designated_Tab();
    });
}

function Roster_Tab_Start() {
    var $pages;
    var content = '';
    var $keys_length = Object.keys($keys).length;

    if ($keys_length % $paginate_value == 0)
        $pages = ($keys_length / $paginate_value);
    else
        $pages = Math.floor($keys_length / $paginate_value) + 1;

    content += '<ul class="pagination ul_bordered" style="margin: 10px;">' +
        '<li><a href="#" class="page" data-page="1" data-position = "0">«</a></li>';

    for (var i = 1; i <= $pages; i++) {
        content += '<li ' + (i == 1 ? 'class="active"' : '') + '>' +
            '<a href="#" class="page" data-page = "' + i + '" data-position = "-1">' + i + '</a>' +
            '</li>';
    }

    content += '<li ' + ($pages == 1 ? 'class="disabled"' : '') + '><a href="#" class="page" data-page = "' + $pages + '" data-position = "1">»</a></li>' +
        '</ul>' +
        '<div id="roster_details" style="margin-bottom: 20px;"></div>';

    $('#tab_roster').html(content);
    Pagination_Add_Event();
    Paginate_Event($('.pagination').find("a.page[data-position='0']"));

}

$(document).on("click", '#roster_tab', function () {
    Paginate_Event($('.pagination').find("a.page[data-position='0']"));
});

function Paginate_Event(selected_element) {
    var page = selected_element.attr('data-page');

    var page_array = Pagination_Range(page, $paginate_value);
    var start = page_array[0];
    var end = page_array[1];
    var roster_div = $("#roster_details");
    var start_page = $('.pagination').find("a.page[data-position='0']");
    var end_page = $('.pagination').find("a.page[data-position='1']");

    var start_page_value = start_page.attr('data-page');
    var end_page_value = end_page.attr('data-page');

    $(".pagination li").removeClass('active');
    var containing = selected_element.text();
    if (containing == '»') {
        selected_element.parent('li').addClass('disabled');
        var last_page = $('.pagination').find("a.page[data-position='-1'][data-page='" + page + "']");
        last_page.parent('li').addClass('active');

    }
    else if (containing == '«') {
        selected_element.parent('li').addClass('disabled');
        var first_page = $('.pagination').find("a.page[data-position='-1'][data-page='" + page + "']");
        first_page.parent('li').addClass('active');
    }
    else
        selected_element.parent('li').addClass('active');


    if (page == start_page_value)
        start_page.parent('li').addClass('disabled');
    else
        start_page.parent('li').removeClass('disabled');

    if (page == end_page_value)
        end_page.parent('li').addClass('disabled');
    else
        end_page.parent('li').removeClass('disabled');


    var content = '';
    var display_sectors_dyu = ['FRA', 'IST', 'DXB', 'URC', 'ALA', 'DME'];
    var display_sectors_dyu_rest = ['LED', 'SVX', 'IKT', 'KZN', 'KRR', 'KJA', 'REN'];
    var display_sectors_lbd = ['DME', 'LED', 'KZN', 'KRR', 'KJA', 'REN', 'AER', 'HMA', 'NJC', 'TJM'];

    var iteration = 0;
    $.each($keys, function (index, $i) {

        iteration++;
        if (iteration < start)
            return true;
        if (iteration > end)
            return false;

        if (!$crew[$i].details || !$crew[$i].details['picture'])
            var $picture = baseUrl + "/" + $assets + "/img/default-user-picture.png";
        else
            var $picture = baseUrl + "/storage/users/" + $crew[$i].details['picture'];

        var $rowspan1 = 1, $rowspan2 = 1;

        if (typeof $crew[$i].schedule !== 'undefined')
            var $rowspan1 = ($crew[$i].schedule).length;

        //if(typeof $crew[$i].schedule.flights !== 'undefined')
        //var $rowspan2 = ($crew[$i].schedule.flights).length;

        var $total_planned_hours = $crew[$i].planned_hours;
        var $last_7_days = $crew[$i].block_hours_7;
        var $last_28_days = $crew[$i].block_hours_28;
        var $last_12_months = $crew[$i].block_hours_12months;

        var $iteration = 0, $dhc = true, $error_check = [];
        $error_check['previous_release_time'] = false;

        if (iteration == end)
            content += '<div class="col-lg-12" style="margin-bottom: 50px;">';
        else
            content += '<div class="col-lg-12" style="margin: 0 0 10px 0; padding: 0">';

        var profile_url = baseHomeUrl + "/crew/profile?id=" + $i;

        content += '<div class="col-lg-3" style="margin: 0; padding: 0 15px 0 0">' +
            '<div class="panel panel-primary" style="height: 480px;">' +
            '<div class="panel-heading" style="position: relative;overflow:hidden; ">' +
            '<span style="float: left"><a class="' + ($crew[$i].details && $crew[$i].details['is_contractor'] ? 'contract' : 'staff') + '" target="_blank" href="' + profile_url + '">' +
            $crew[$i].first_name + ' ' + $crew[$i].last_name + '</a></span>' +
            '<span style="float: right; font-weight: bold">' + $crew[$i].base + '</span>' +
            '</div>' +
            '<div class="panel-body">' +
            '<div style="padding-bottom: 10px;">' +
            '<div class="profile-image" style="width: 40%; float: left; min-height: 150px; margin-bottom: 10px;">' +
            '<img src="' + $picture + '" alt="Profile Image" class="img-thumbnail" style="max-height: 180px;">' +
            '</div>' +
            '<div style="float: left; width: 60%">' +
            '<table class="table table-bordered table-striped table-hover" style="width:100%; padding: 0; margin: 0">' +
            '<tbody>' +

            '<tr>' +
            '<td class="td_header">ID</td>' +
            '<td>' + $crew[$i].id + '</td>' +
            '</tr>';

        if ($crew[$i].details && typeof $crew[$i].details['doj'] !== 'undefined') {
            content += '<tr>' +
                '<td class="td_header">DOJ</td>' +
                '<td>' + $crew[$i].details['doj'] + '</td>' +
                '</tr>';
        }

        if ($crew[$i].details && $crew[$i].details['aircraft_types']) {
            /* content += '<tr>' +
             '<td class="td_header">A/C Types</td>' +
             '<td>';
             var loop = 0;
             $.each($crew[$i].details['aircraft_types'], function ($u, $ac) {
             content += Aircraft_Iata_Type($ac)+', ';
             loop = 1;
             });
             if (loop == 1)
             content = content.slice(0, -2);

             content += '</td>' +
             '</tr>';*/
        }

        if ($crew[$i].details && $crew[$i].details['phone']) {

            $.each($crew[$i].details['phone'], function ($u, $phone) {
                if ($u != 'office') {
                    content += '<tr>' +
                        '<td class="td_header">' + Ucfirst($u) + '</td>' +
                        '<td>' + $phone + '</td>' +
                        '</tr>';
                }
            });
        }

        content += '</tbody>' +
            '</table>' +
            '</div>' +
            '<div style="clear: both; overflow:auto; height:230px;">' +
            '<table class="table table-bordered table-striped table-hover" style="width: 40%; float: left; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>Ind.</th>' +
            '<th>Hours</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>' +
            '<tr>' +
            '<td class="td_header">Planned</td>' +
            '<td>' + Math.round($total_planned_hours * 10) / 10 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">Last 7 Days</td>' +
            '<td>' + Math.round($last_7_days * 10) / 10 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">Last 28 Days</td>' +
            '<td>' + Math.round($last_28_days * 10) / 10 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">Last 365 Days</td>' +
            '<td>' + Math.round($last_12_months * 10) / 10 + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">Standby</td>' +
            '<td>' + $crew[$i].standby_count + '</td>' +
            '</tr>' +
            '<tr>' +
            '<td class="td_header">DHC</td>' +
            '<td>' + $crew[$i].dhc_count + '</td>' +
            '</tr>' +
            '</tbody>' +
            '</table>' +
            '<table class="table table-bordered table-striped table-hover" style="width: 30%; float: left; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>' + $location1 + '</th>' +
            '<th>№</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';
        var counter = 0;

        $.each($crew[$i].flight_history, function ($sector, $times) {
            if ($sector.match("^" + $location1)) {
                var airport = $sector.split('-');
                if ($.inArray(airport[1], display_sectors_dyu) !== -1) {
                    counter++;
                    content += '<tr>' +
                        '<td class="td_header">' + airport[1] + ':</td>' +
                        '<td>' + $times + '</td>' +
                        '</tr>';
                }
            }
        });
        if (counter < 6) {
            $.each($crew[$i].flight_history, function ($sector, $times) {
                if (counter == 6)
                    return false;
                if ($sector.match("^" + $location1)) {
                    var airport = $sector.split('-');
                    if ($.inArray(airport[1], display_sectors_dyu_rest) !== -1) {
                        counter++;
                        content += '<tr>' +
                            '<td class="td_header">' + airport[1] + ':</td>' +
                            '<td>' + $times + '</td>' +
                            '</tr>';
                    }
                }
            });
        }
        content += '</tbody>' +
            '</table>' +
            '<table class="table table-bordered table-striped table-hover" style="width: 30%; float: left; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th>' + $location2 + '</th>' +
            '<th>№</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';
        counter = 0;
        $.each($crew[$i].flight_history, function ($sector, $times) {
            if ($sector.match("^" + $location2)) {
                if (counter == 6)
                    return false;
                var airport = $sector.split('-');
                if ($.inArray(airport[1], display_sectors_lbd) !== -1) {
                    counter++;
                    content += '<tr>' +
                        '<td class="td_header">' + airport[1] + ':</td>' +
                        '<td>' + $times + '</td>' +
                        '</tr>';
                }
            }
        });
        content += '</tbody>' +
            '</table>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>' +

            '<div class="col-lg-9" style="overflow-y: auto; height: 480px; padding: 0; border:#008cba 1px solid">' +
            '<table class="table table-bordered table-striped table-hover">' +
            '<thead>' +
            '<tr>' +
            '<th><p class = "autoResize">FDP Start</p></th>' +
            '<th><p class = "autoResize">Report Time</p></th>' +
            '<th><p class = "autoResize">FDP Max</p></th>' +
            '<th><p class = "autoResize">FDP Cur.</p></th>' +
            '<th><p class = "autoResize">FDP Cum.</p></th>' +
            '<th><p class = "autoResize">Flight Hours</p></th>' +
            '<th><p class = "autoResize">Release Time</p></th>' +
            '<th><p class = "autoResize">Req. Rest</p></th>' +
            '<th><p class = "autoResize">Sectors</p></th>' +
            '<th><p class = "autoResize">Flights Scheduled</p></th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>' +
            '<tr>';

        var lastReleaseTime = false, currentReportTime, duration;

        $.each($crew[$i].schedule, function ($j, $schedule) {

            if (lastReleaseTime && typeof lastReleaseTime !== "undefined" && lastReleaseTime !== undefined) {
                currentReportTime = moment($schedule.report_time_binded);
                duration = currentReportTime.diff(lastReleaseTime, "m");

                content += '<tr style="background-color: #ebf2fa; font-weight: bold">' +
                    "<td>Rest Period</td>" +
                    "<td>";

                content += duration.toString().toDDHHMM();

                content += "</td>" +
                    "<td colspan='8'></td>" +
                    "</tr>";

            }

            lastReleaseTime = moment($schedule.release_time);

            if (typeof $schedule.error_message !== 'undefined')
                var $class = "class = 'not-exists'";
            else if ($schedule.is_dhc)
                var $class = "class = 'flight_with_dhc'";
            else if ($schedule.is_standby)
                var $class = "class='standby'";
            else
                var $class = '';

            content += '<tr>' +
                '<td ' + $class + ' rowspan="$rowspan2"><p class = "autoResize">' + moment($schedule.report_time_binded).format('DD MMM HH:mm') + '</p>';
            if (typeof $schedule.wocl !== 'undefined' && $schedule.wocl) {
                content += '<br/>' +
                    '<span class="label label-danger">WOCL</span>';
            }
            content += '</td>' +
                '<td ' + $class + ' rowspan="$rowspan2"><p class = "autoResize">' + moment($schedule.report_time).format('DD MMM HH:mm') + '</p>';

            if (typeof $schedule.additional_crew !== 'undefined') {
                content += '<br/>' +
                    '<span class="label label-warning">' + $schedule.additional_crew + ' Added</span>';
            }

            content += '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_max + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_current + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.fdp_cumulative + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + Math.round($schedule.block_hours * 10) / 10 + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + moment($schedule.release_time).format('DD MMM HH:mm') + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.required_rest + '</td>' +
                '<td ' + $class + 'rowspan="$rowspan2">' + $schedule.sectors + '</td>';

            $error_check['previous_release_time'] = $schedule.release_time;

            content += '<td style="padding: 0; margin: 0">' +
                '<table class="table table-bordered table-striped table-hover" style="width: 100%; padding: 0; margin: 0">' +
                '<thead>' +
                '<tr>' +
                '<th><p class = "autoResize">Flight Num</p></th>' +
                '<th><p class = "autoResize">Sector</p></th>' +
                '<th><p class = "autoResize">STD</p></th>' +
                '<th><p class = "autoResize">STA</p></th>' +
                '<tr>' +
                '</thead>' +
                '<tbody>';

            $.each($schedule.flights, function ($u, $flight) {
                content += '<tr>' +
                    '<td>' + $flight['flight_number'] + '</td>' +
                    '<td><p class = "autoResize">' + $flight['departure_airport'] + '-' + $flight['arrival_airport'] + '</p></td>' +
                    '<td><p class = "autoResize">' + moment($flight['std']).format('DD MMM HH:mm') + '</p></td>' +
                    '<td><p class = "autoResize">' + moment($flight['sta']).format('DD MMM HH:mm') + '</p></td>' +
                    '</tr>';
            });

            content += '</tbody>' +
                '</table>' +
                '</td>' +
                '</tr>';
        });

        content += '</tbody>' +
            '</table>' +
            '</div>' +
            '</div>' +
            '</div>';
    });

    roster_div.children().remove();
    roster_div.html(content);
    //Apply_Tablesorter(roster_div);
}

function Flights_Tab() {
    var parent = $('#tab_flights'), content = '', crewLength;
    var position, className;

    content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">' +
        '<thead>' +
        '<tr>' +
        '<th rowspan="2" title="Flight Number">Flight</th>' +
        '<th rowspan="2">Sector</th>' +
        '<th rowspan="2">STD</th>' +
        '<th rowspan="2">STA</th>' +
        '<th rowspan="2" title="Stand-by">SB</th>' +
        '<th rowspan="2">DHC</th>' +
        '<th colspan="4" class="text-center">FCM Requirement</th>' +
        '<th colspan="8" class="text-center">Full Name</th>' +
        '</tr>' +
        '<tr>' +
        '<th title="Policy">Pol</th>' +
        '<th title="Minimum">Min</th>' +
        '<th title="Requirement">Req</th>' +
        '<th title="Actual">Act</th>';

    if ($crewType == 'fcm') {
        crewLength = 4;
        content += '<th>CAPT #1</th>' +
            '<th>CAPT #2</th>' +
            '<th>F/O #1</th>' +
            '<th>F/O #2</th>';
    }
    else {
        crewLength = 8;
        content += '<th>Purser</th>' +
            '<th>CC #2</th>' +
            '<th>CC #3</th>' +
            '<th>CC #4</th>' +
            '<th>CC #5</th>' +
            '<th>CC #6</th>' +
            '<th>CC #7</th>' +
            '<th>CC #8</th>';
    }

    content += '</tr>' +
        '</thead>' +

        '<tbody>';

    $.each($flights_scheduled, function ($j, $each) {
        var $style = '';

        if ($each.crew_planned == 0)
            $style = 'class = "flight_without_crew"';
        else if ($each.crew_planned < $each.crew_required)
            $style = 'class = "flight_not_min_req"';
        else {
            if ($j % 2 == 0)
                $style = 'style="background-color: #f8f8f8;"';
        }

        $.each($each.flights, function ($u, $flight) {
            if ($flight.crew_dhc && $flight.crew_dhc.length > 0) {
                $style = 'class = "flight_with_dhc"';
            }

            content += '<tr>' +
                '<td ' + $style + '>' + $flight.flight_number + '</td>' +
                '<td ' + $style + '>' + $flight.departure_airport + '-' + $flight.arrival_airport + '</td>' +
                '<td ' + $style + '>' + moment($flight.std).format('DDMMMYY HH:mm') + '</td>' +
                '<td ' + $style + '>' + moment($flight.sta).format('DDMMMYY HH:mm') + '</td>' +

                '<td ' + $style + '>';
            if ($u == 0 && $flight.crew_standby) {
                content += '<span class="glyphicon glyphicon-ok"></span>';
            }
            content += '</td>' +
                '<td ' + $style + '>';

            if ($u == 0 && $flight.crew_dhc) {
                content += '<span class="glyphicon glyphicon-ok"></span>';
            }

            content += '</td>' +
                '<td ' + $style + '>' + $each.crew_policy + '</td>' +
                '<td ' + $style + '>' + $each.crew_min + '</td>' +
                '<td ' + $style + '>' + $each.crew_required + '</td>' +
                '<td ' + $style + '>' + $each.crew_planned + '</td>';

            var crewItems = [];
            $.each($each.crew, function ($y, $id) {

                position = GetCrewPositionAbbr($crew[$id]['details'].position);
                className = GetCrewPositionCssClass($crew[$id]['details'].position);

                crewItems[$y] = '<td class =' + className + '>' + $crew[$id].first_name + " " + $crew[$id].last_name +
                    '<span class="crew_id_small">(' + position + ') ' + $id + '</span></td>';
            });

            for (var $i = 0; $i < crewLength; $i++) {
                if ($i in crewItems) {
                    content += crewItems[$i];
                }
                else {
                    content += '<td></td>';
                }
            }

            content += '</tr>';

        });
    });

    content += '</tbody>' +
        '</table>';

    parent.html(content);
    //Apply_Tablesorter(parent);
}


function Standby_Tab() {
    var parent = $('#tab_standby');
    var content = '';
    content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">' +
        '<thead>' +
        '<tr>' +
        '<th rowspan="2">Flight ID</th>' +
        '<th rowspan="2">Flight Num</th>' +
        '<th rowspan="2">Sector</th>' +
        '<th rowspan="2">STD</th>' +
        '<th rowspan="2">STA</th>' +
        '<th colspan="3">Cabin Crew Requirement</th>' +
        '<th rowspan="2" colspan="10">First/Last Names</th>' +
        '</tr>' +
        '<tr>' +
        '<th>Policy</th>' +
        '<th>Minimum</th>' +
        '<th>Actual</th>' +
        '</tr>' +
        '</thead>' +
        '<tbody>';

    $.each($flights_scheduled, function ($t, $each) {
        $.each($each.flights, function ($j, $flight) {
            if ($j == 0) {
                content += '<tr>' +
                    '<td>' + $flight.id + '</td>' +
                    '<td>' + $flight.flight_number + '</td>' +
                    '<td>' + $flight.departure_airport + ' - ' + $flight.arrival_airport + '</td>' +
                    '<td>' + $flight.std + '</td>' +
                    '<td>' + $flight.sta + '</td>' +
                    '<td>' + $flight.policy_fcm + '</td>' +
                    '<td>' + $flight.min_fcm + '</td>' +
                    '<td>' + $each.crew_planned + '</td>';
                if ($flight.crew_standby) {
                    $.each($flight.crew_standby, function ($s, $id) {
                        content += '<td class="standby">' + $crew[$id].first_name + " " + $crew[$id].last_name + '</td>';
                    });
                }
                else {
                    content += '<td class="not-exists">' +
                        '<span class="glyphicon glyphicon-remove" style="color: #FFFFFF"></span>' +
                        '</td>';
                }
                content += '</tr>';
            }
        });
    });
    content += '</tbody>' +
        '</table>';

    parent.html(content);
    //Apply_Tablesorter(parent);

}

function Hours_Report_Tab() {
    var parent = $('#tab_hours');
    var content = '';

    content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">' +
        '<thead>' +
        '<tr>' +
        '<th rowspan="2">No</th>' +
        '<th rowspan="2">ID</th>' +
        '<th rowspan="2">First Name</th>' +
        '<th rowspan="2">Last Name</th>' +
        '<th rowspan="2">Base</th>' +
        '<th rowspan="2">Last Flight Date</th>' +
        '<th class="text-center" colspan="4">Flight Time</th>' +
        '<th class="text-center" colspan="2">Duty Period</th>' +
        '<th class="text-center" colspan="2">Count</th>' +
        '</tr>' +
        '<tr>' +
            // Flight Time
        '<th>Planned</th>' +
        '<th>7 Days</th>' +
        '<th>28 Days</th>' +
        '<th>YTD</th>' +
            // Duty Period
        '<th>7 Days</th>' +
        '<th>28 Days</th>' +
            //'<th>365 Days</th>'+
        '<th>Stand-by</th>' +
        '<th>DHC</th>';

    content += '</tr>' +
        '</thead>' +
        '<tbody>';

    var index = 1;
    $.each($keys, function ($t, $id) {
        var keys = Object.keys($crew[$id].flight_hours_date);
        var $last_date = moment(keys[keys.length - 1]);
        console.log($crew[$id])
        content += '<tr>' +
            '<td>' + (index++) + '</td>' +
            '<td>' + $crew[$id].id + '</td>' +
            '<td>' + $crew[$id].first_name + '</td>' +
            '<td>' + $crew[$id].last_name + '</td>' +
            '<td>' + $crew[$id].base + '</td>' +
            '<td>' + $last_date.format("DD-MMM-YYYY") + '</td>' +

            '<td>' + Math.round($crew[$id].planned_hours * 10) / 10 + '</td>' +
            '<td>' + Math.round($crew[$id].block_hours_7 * 10) / 10 + '</td>' +
            '<td>' + Math.round($crew[$id].block_hours_28 * 10) / 10 + '</td>' +
            '<td>' + Math.round($crew[$id].block_hours_12months * 10) / 10 + '</td>' +

            '<td>' + Math.round($crew[$id].fdp_hours_7 * 10) / 10 + '</td>' +
            '<td>' + Math.round($crew[$id].fdp_hours_28 * 10) / 10 + '</td>' +

            '<td>' + $crew[$id].standby_count + '</td>' +
            '<td>' + $crew[$id].dhc_count + '</td>';
        content += '</tr>';
    });

    content += '</tbody>' +
        '</table>';

    parent.html(content);
    //Apply_Tablesorter(parent);
}


function Route_Report_Tab() {
    var parent = $('#tab_route');
    var $display_sectors_dyu = ['FRA', 'IST', 'DXB', 'URC', 'KBL', 'LHE', 'ALA', 'DME', 'LED', 'IKT', 'KRR', 'KJA', 'SVX', 'KZN', 'REN', $location2];

    var $display_sectors_lbd = ['DME', 'LED', 'KRR', 'KJA', 'REN', 'KZN', 'AER', 'HMA', 'NJC', 'TJM', $location1];

    var content = '';

    content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">' +
        '<thead>' +
        '<tr>' +
        '<th rowspan="2">No</th>' +
        '<th rowspan="2">ID</th>' +
        '<th rowspan="2">First Name</th>' +
        '<th rowspan="2">Last Name</th>' +
        '<th rowspan="2">Base</th>' +
        '<th class="text-center" colspan="16">Top Routes From' + $location1 + '(Planned Period + 90 Days)</th>' +
        '<th class="text-center" colspan="11">Top Routes From' + $location2 + '(Planned Period + 90 Days)</th>' +
        '</tr>' +
        '<tr>';

    $.each($display_sectors_dyu, function ($t, $station) {
        content += '<th>' + $station + '</th>';
    });
    $.each($display_sectors_lbd, function ($t, $station) {
        content += '<th>' + $station + '</th>';
    });

    content += '</tr>' +
        '</thead>' +
        '<tbody>';

    var index = 1;
    $.each($keys, function ($t, $id) {
        var keys = Object.keys($crew[$id].flight_hours_date);

        content += '<tr>' +
            '<td>' + (index++) + '</td>' +
            '<td>' + $crew[$id].id + '</td>' +
            '<td>' + $crew[$id].first_name + '</td>' +
            '<td>' + $crew[$id].last_name + '</td>' +
            '<td>' + $crew[$id].base + '</td>';

        $.each($display_sectors_dyu, function ($o, $station) {
            var $sector = $location1 + "-" + $station;

            if ($crew[$id].flight_history[$sector])
                content += '<td>' + $crew[$id].flight_history[$sector] + '</td>';
            else
                content += '<td>0</td>';
        });

        $.each($display_sectors_lbd, function ($p, $station) {
            var $sector = $location2 + "-" + $station;

            if ($crew[$id].flight_history[$sector])
                content += '<td>' + $crew[$id].flight_history[$sector] + '</td>';
            else
                content += '<td>0</td>';
        });
        content += '</tr>';
    });

    content += '</tbody>' +
        '</table>';

    parent.html(content);
    //Apply_Tablesorter(parent);
}


function DHC_Tab() {
    var parent = $('#tab_dhc');
    var content = '', inner_content = "";

    $.each($flights_scheduled, function ($j, $each) {
        $.each($each.flights, function ($t, $flight) {
            if ($flight['crew_dhc']) {
                inner_content += '<tr>' +
                    '<td>' + $flight['id'] + '</td>' +
                    '<td>' + $flight['flight_number'] + '</td>' +
                    '<td>' + $flight['departure_airport'] + '-' + $flight['arrival_airport'] + '</td>' +
                    '<td>' + $flight['std'] + '</td>' +
                    '<td>' + $flight['sta'] + '</td>' +
                    '<td>' + $flight['policy_fcm'] + '</td>' +
                    '<td>' + $flight['min_fcm'] + '</td>' +
                    '<td>' + $each.crew_planned + '</td>';

                $.each($flight['crew_dhc'], function ($u, $id) {
                    inner_content += '<td class="flight_with_dhc">' + $crew[$id].first_name + " " + $crew[$id].last_name + '</td>';
                });
                inner_content += '</tr>';
            }
        });
    });

    if (inner_content) {
        content += '<table class="table table-bordered table-striped table-hover" data-excel = "1" style="width: 100%; padding: 0; margin: 0">' +
            '<thead>' +
            '<tr>' +
            '<th rowspan="2">Flight ID</th>' +
            '<th rowspan="2">Flight Num</th>' +
            '<th rowspan="2">Sector</th>' +
            '<th rowspan="2">STD</th>' +
            '<th rowspan="2">STA</th>' +
            '<th colspan="3">Cabin Crew Requirement</th>' +
            '<th rowspan="2" colspan="10">First/Last Names</th>' +
            '</tr>' +
            '<tr>' +
            '<th>Policy</th>' +
            '<th>Minimum</th>' +
            '<th>Actual</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';

        content += inner_content;

        content += '</tbody>' +
            '</table>';
    }
    else {
        content = information_box.text("No DHC Found.");
    }


    parent.html(content);
    //Apply_Tablesorter(parent);
}


function Designated_Tab() {
    var parent = $('#tab_designated');
    var content = '';

    if (Object.keys($designated).length > 0) {
        content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">' +
            '<thead>' +
            '<tr>' +
            '<th class="text-center">Flight Id</th>' +
            '<th class="text-center">Flight No</th>' +
            '<th class="text-center">Date</th>' +
            '<th colspan="6" class="text-center">Crew</th>' +
            '</tr>' +
            '</thead>' +
            '<tbody>';
        $.each($designated['flight_number'], function ($i, $flight_number) {
            content += '<tr>' +
                '<td>' + $designated['flights'][$i].join('/') + '</td>' +
                '<td>' + $flight_number + '</td>' +
                '<td>' + $designated['date'][$i] + '</td>';
            $.each($designated['crew'][$i], function ($j, $id) {
                content += '<td ' + ($crew[$id].captain ? 'class = "purser"' : '') + ' >' +
                    $crew[$id].first_name + " " + $crew[$id].last_name + '<span class="crew_id_small">' + $id + '</span>' +
                    '</td>';
            });
            content += '</tr>';
        });
        content += '</tbody>' +
            '</table>';
    }
    else {
        content = information_box.text("No Designated Flights Found.");
    }


    parent.html(content);
    //Apply_Tablesorter(parent);
}

//});

