/**
 * Created by WebSomonair on 03.10.2014.
 */
$(document).ready(function(){
    var start_date = $("#from_date"),
        end_date = $("#to_date"),
        WITHIN_LIMIT = 'withinLimit',
        CROSSED_LIMIT = 'crossedLimit';

    console.log($reportType)
    if ($reportType != 'FDP') {
        Crew_Report();
    }

    Check_Select();
    Crew_Designation($('.crew'));

    $(".category").click(function(){
        var details = $(this).next('.details');

        if (details.hasClass('hidden'))
            details.removeClass('hidden');
        else
            details.addClass('hidden');
    });


    $('#export_excel').on('click', function(){
        AjaxExportExcel()
    });

    function Check_Select(){
        var value = $(".crew").val();
        console.log(value)
        var designation = $('.crew_designation');
        var submit =  $('input[name="submit"]');
        if (value == '') {
            designation.attr('disabled', 'disabled');
            submit.attr('disabled', 'disabled');
        }
    }


    $('.crew').on('change', function () {
        Crew_Designation($(this));
    });

    function Crew_Designation(elem){
        var value = elem.val();
        var designation = $('.crew_designation');
        var submit =  $('input[name="submit"]');
        var options = '';
        switch (value){
            case "fcm":
                designation.children().remove();
                designation.append($("<option></option>")
                    .attr("value",'')
                    .text('All'))
                    .append($("<option></option>")
                        .attr("value",'capt')
                        .text('Captain'))
                    .append($("<option></option>")
                        .attr("value",'fo')
                        .text('First Officer'));
                designation.removeAttr('disabled');
                submit.removeAttr('disabled');
                break;
            case  "ccm":
                designation.children().remove();
                designation.append($("<option></option>")
                    .attr("value",'')
                    .text('All'))
                    .append($("<option></option>")
                        .attr("value",'psr')
                        .text('Purser'))
                    .append($("<option></option>")
                        .attr("value",'cc')
                        .text('Cabin Crew'));
                designation.removeAttr('disabled');
                submit.removeAttr('disabled');
                break;
            default :
                designation.children().remove();
                designation.append($("<option></option>")
                    .attr("value",'')
                    .text('Select'));
                designation.attr('disabled','disabled');
                submit.attr('disabled','disabled');
                break;
        }
    }

    $('.filter_status').on('click', function () {
        var _this = $(this);
        var id = _this.attr('id');
        var status = _this.attr('data-apply');

        //var date = moment('2014-11-12').format('DDMMMYY');

        if (status == 1){
            _this.addClass('status_on');
            _this.attr('data-apply',0);
        }
        else {
            _this.removeClass('status_on');
            _this.attr('data-apply',1);
        }

    });


    $('#apply_filter').on('click', function () {
        var filters = $('.filter_status');
        var filter_row = new Object();
        filters.each(function (i) {
            var name = $(this).attr('id');
            filter_row[name]= $(this).attr('data-apply');
        });
        Crew_Report(filter_row);
        console.log(filter_row);
    });


    function Crew_Report(filter_row){
        var content = '',cur_date = moment().format('YYYY-MM-DD'), current_leave = 0,
            exportArray = [],columnNames = [], reportName;

        console.log($crewType)

        if ($crewType){
            if ($crewType == 'fcm') {
                validationVariables = ['aruba_validation_to', 'medical_to', 'cmc_to', 'sep_12', 'sep_36', 'crm_to', 'dgr_to', 'security', 'line_check_to',
                    'flying_license_to', 'license_attachment_to', 'lpc_ir_to', 'opc_to', 'tri_sfi_to'];
                columnNames[0] = [ 'No', 'Last Name', 'First Name', 'Base', 'Staff No', {'Passport' : 2}, {'Aruba Validation' : 2}, {'Medical' : 2}, {'CMC' : 2}, {'SEP 12' : 2},
                    {'SEP 36' : 2}, {'CRM' : 2}, {'DGR' : 2}, {'Security' : 2}, {'Line Check' : 2}, {'Flying License' : 1}, {'License Attachment' : 2}, {'LPC/IR' : 2},
                    {'OPC' : 2}, {'TRI/SFI' : 2}, {'Not Available' : 3}];
            }
            else if($crewType == 'ccm') {
                validationVariables = ['license_validity', 'medical_next', 'cmc_to', 'sep_to', 'crm_to', 'dgr_to', 'security_to', 'practical_to'];
                columnNames[0] = [ 'No', 'Last Name', 'First Name', 'Base', 'Staff No', {'Passport' : 2}, {'License Validity' : 2}, {'Medical' : 2}, {'CMC' : 2}, {'SEP' : 2},
                    {'CRM' : 2}, {'DGR' : 2}, {'Security' : 2}, {'Practicals' : 2}, {'Not Available' : 3}];
            }
            else{
                return;
            }
        }
        else{
            return;
        }

        reportName = ['Expiry Summary Report'];

        columnNames[1] = [];

        if (typeof filter_row === 'undefined')
            filter_row = {'empty' : 1, 'expired' : 1, 'valid' : 1, 'valid_temp' : 1};
        
        content += '<table class="table table-bordered table-striped table-hover" style="margin: 10px 0;">'+
            '<thead>'+
                '<tr>';


        $.each(columnNames[0], function (j, variable) {
            if (variable instanceof Object){
                $.each(variable, function (varName, colspan) {
                    if (colspan == 1){
                        columnNames[1].push('Status');
                    }
                    else if (colspan == 2){
                        columnNames[1].push('Exp', 'Status');
                    }
                    else if(colspan == 3){
                        columnNames[1].push('From', 'To', 'Reason');
                    }

                    content += '<th colspan="' + colspan + '" class="text-center">' + varName + '</th>';
                    return false;
                });
            }
            else {
                columnNames[1].push('');
                content += '<th rowspan="2" class="text-center">' + variable + '</th>';
            }

            if (j == 0 || j == 3){
                content += '<th rowspan="2" class="text-center"></th>';
            }
        });

        content +='</tr><tr>';
        $.each(columnNames[1], function (j, variable) {
            if (variable && variable !== '')
                content += '<th>'+ variable +'</th>';
        });
        content +='</tr>'+
             '</thead>'+
            '<tbody>';


        var counter = 0, u = 1,  crewArray = [], hide_ids = [], variable, validationVariables, contentVar;

        var locationAirport;
        $.each($crewObject, function($i, $crew) {
                crewArray = [];
                counter = 0;

            content += '<tr class="crew_report '+ ($crew.is_contractor ? 'contractorCrew' : '') + '" data-id="'+$crew.id+'">'+
                    '<td class="original" data-number="1">' + u + '</td>';

                crewArray.push(u++);

                locationAirport = $crew.location != null ? ($crew.location.airport != null ? $crew.location.airport.iata : "") : "";

                var $empty = '<span class="label label-primary">NOT ISSUED</span>';

                var $picture = ($crew.thumb && typeof $crew.thumb !== 'undefined') ? 'users/'+$crew.thumb : 'default-user-picture.png';

            content += '<td class="original">'+
                            '<a href="'+baseUrl +'/user/crew-hours?id='+$crew.id+'" target="_blank">'+
                            '<img src="'+ baseUrl +'/assets/img/'+$picture+'" class="img-thumbnail thumb_report_prev"  /></a>'+
                        '</td>'+

                        '<td class="original"><a href="'+baseUrl +'/crew/profile?id='+$crew.id+'" target="_blank">'+$crew.last_name+'</a></td>'+
                        '<td class="original"><a href="'+baseUrl +'/crew/profile?id='+$crew.id+'" target="_blank">'+$crew.first_name+'</a></td>' +
                        '<td class="original">' + locationAirport + '</td>'+
                        '<td class="original"></td>';


                        crewArray.push($crew.last_name, $crew.first_name);

                        crewArray.push(locationAirport);

                        if (filter_row['empty'] == '1'){
                            if ($crew.staff_number && typeof $crew.staff_number !== 'undefined') {
                                content += '<td>' + $crew.staff_number + '</td>';
                                crewArray.push($crew.staff_number);
                            }
                            else {
                                counter++;
                                content += '<td>' + $empty + '</td>';
                                crewArray.push('-');
                            }
                        }
                        else {
                            if ($crew.staff_number && typeof $crew.staff_number !== 'undefined') {
                                content += '<td>' + $crew.staff_number + '</td>';
                                crewArray.push($crew.staff_number);
                            }
                            else {
                                content += '<td>' + "" + '</td>';
                                crewArray.push('-');
                            }
                        }

                        if ($crew.passport_dex && filter_row[Expiration_Date($crew.passport_dex)['filter']] == '1') {
                             variable = (typeof $crew.passport_dex !== 'undefined' && moment($crew.passport_dex).isValid()) ? moment($crew.passport_dex).format('DDMMMYY') : "";
                             content +=  '<td><p class="editable_values" data-item="passport_dex">' + variable +'</p></td>'+
                                         '<td>'+Expiration_Date($crew.passport_dex)['status']+'</td>';
                             counter++;
                             crewArray.push(variable);
                             crewArray.push(Expiration_Date($crew.passport_dex)['message']);
                        }
                        else {
                            content += '<td></td><td></td>';
                            crewArray.push('');
                        }

                    $.each(validationVariables, function (b, typeVar) {
                        contentVar = '';
                        if (filter_row[Expiration_Date($crew[typeVar])['filter']] == '1') {
                            variable = (typeof $crew[typeVar] !== 'undefined' && moment($crew[typeVar]).isValid()) ? moment($crew[typeVar]).format('DDMMMYY') : "";
                            if (typeVar == 'flying_license_to'){
                                content += '<td>' + Expiration_Date($crew[typeVar])['status'] + '</td>';
                                crewArray.push(Expiration_Date($crew[typeVar])['message']);
                            }
                            else {
                                content +='<td><p class="editable_values" data-item="' + typeVar + '">' + variable +'</p></td>' +
                                          '<td>' + Expiration_Date($crew[typeVar])['status'] + '</td>';
                                crewArray.push(variable);
                                crewArray.push(Expiration_Date($crew[typeVar])['message']);
                            }
                            counter++;

                        }
                        else {
                            content += '<td></td><td></td>';
                            crewArray.push('');
                        }
                    });


                    if (typeof $crew.user_history !== 'undefined' && $crew.user_history.length > 0) {
                        current_leave = 0; historyFrom = ''; historyTo = ''; historyCondition = '';
                        $.each($crew.user_history, function ($t, $history) {
                            if ($history.to >= cur_date) {
                                current_leave++;
                                $from = ($history.from !== 'undefined') ? moment($history.from).format('DDMMMYY') : "";
                                $to   = ($history.to !== 'undefined') ? moment($history.to).format('DDMMMYY') : "";
                                $cond = $conditions[$history.condition_id];

                                historyFrom += $from + '<br/>';
                                historyTo += $to + '<br/>';
                                historyCondition += $cond + '<br/>';

                                crewArray.push($from, $to, $cond);
                            }
                        });
                        if (current_leave == 0) {
                            content += '<td></td><td></td><td></td>';
                            crewArray.push('', '', '');
                        }
                        else {
                            content += '<td>' + historyFrom + '</td>' +
                            '<td>' + historyTo + '</td>' +
                            '<td>' + historyCondition + '</td>';
                        }

                    }
                    else {
                        content += '<td></td><td></td><td></td>';
                        crewArray.push('','','');
                    }

                    content += '</tr>';
                    if (counter == 0){
                        hide_ids.push($crew.id);
                    }

                    exportArray.push(crewArray);
                });
        content += '</tbody>'+
            '</table>';

        $('#exportArray').val(JSON.stringify(exportArray));
        $('#columnNames').val(JSON.stringify(columnNames));
        $('#reportName').val(JSON.stringify(reportName));

        console.log($crewObject)

        if (Object.keys($crewObject).length) {
            var parent = $(document).find('#report');
            parent.html(content);
            if (hide_ids.length > 0) {
                $.each(hide_ids, function (t, id) {
                    var tr = parent.find('tr[data-id="' + id + '"]');
                    //var td = tr.find('td[data-number="1"');
                    tr.hide();
                    //console.log(td)
                });
            }
            Apply_Tablesorter(parent);
        }
    }

    $("#report").on('dblclick', 'p.editable_values', function () {
        // Cancel All Others
        Cancel_Change();

        var oriVal = $(this).text();
        var item = $(this).attr('data-item');
        $(this).text("");

        var input = $("<input class = 'date_format editable' type='text' value='"+oriVal+"'>");
        var save = $('<div class="btn-group change_values"><a href="#" class="btn btn-sm btn-primary" id="save_changes">Save</a>' +
                    '<a href="#" class="btn btn-sm btn-warning" id="empty_text">Not Issued</a>'+
                    '<a href="#" class="btn btn-sm btn-danger" id="cancel_changes">Cancel</a>')
        input.appendTo(this);
        save.appendTo(this);
        Add_Date_Format();
        Load_Buttons($('#report'), oriVal, item);
        $(this).find('input.date_format.editable').focus();
    });

    /*$("#report").on('focusout', 'p.editable_values > input', function () {
        var $this = $(this);
        $this.parent().text($this.val() || oriVal); // Use current or original val.
        $this.remove();                      // Don't just hide, remove the element.
    });*/

    function Load_Buttons(parent, previous_value, item){

        parent.on('click', '#save_changes', function () {
            var token = $(this).parents('form').find('input[name=_token]').val();
            var input = $('input.date_format.editable');
            var id = $(this).parents('tr.crew_report').attr('data-id');
            console.log(item)
            if (previous_value != input.val()){
                Ajaxsavechanges(id, input.val(), item, token);
            }

        });
        $('#cancel_changes').click(function () {
            var $this = $('p.editable_values > input');
            $this.parent().text($this.val()); // Use current or original val.
            $this.remove();
        });
        $('#empty_text').click(function () {
            var $this =  $('input.date_format.editable');
            $this.val("");
        });

        $('input.date_format.editable').on('change', function () {
            $(this).addClass('edited');
        })
    }

    function Cancel_Change(){
        var $this = $('p.editable_values > input');
        $this.parent().text($this.val()); // Use current or original val.
        $this.remove();
    }

    var message_box = $('#message_box');

    function Ajaxsavechanges(id, value, item, token){
        var request = $.ajax({
            headers: {
                'x-csrf-token': token
            },
            url: baseUrl + "/crewroster/ajax-save-changes",
            type: 'POST',
            dataType: 'json',
            data: {
                type: 'fcm',
                crew_id: id,
                item: item,
                value: value
            }
        });


        request.done(function (data) {
            if (typeof data.success !== 'undefined') {
                getMessageDiv("Success", message_box, data.message);
                Cancel_Change();
            }
        });
        request.fail(function (jqXHR, text_status) {
            getMessageDiv("Error", message_box,'Roster Was Not Published');
        });
    }

    // FDP
    var parent = $("#fdpReport"),
        messageBox = $('#message-block');

    parent.on('dblclick', 'p.editable_values',  function () {
        // Cancel All Others
        cancelChanges();
        // Not Issued Message Box
        messageBox.children().remove();

        var _this = $(this), _content = _this.children(), oriVal = _this.text(), item = _this.attr('data-item'),
            table = _this.attr('data-table'), date_format = _this.attr('data-date_format'), stdValue,
            var_type = _this.attr('data-var_type'), options, selected_values, originalValue,
            parent = _this.parents('.details'), type = parent.attr('data-type'), input, save;

        _this.text("");

        if (oriVal == ''){
            stdValue = _this.parents('tr').find('.std').text();
            input = $("<input class = 'date_format editable long' type='text' value='"+stdValue+"' />");
        }
        else
            input = $("<input class = 'date_format editable long' type='text' value='"+oriVal+"' />");


        originalValue = $("<input class = 'originalValue' type='hidden' value='"+oriVal+"' />");

        save = $('<div class="btn-group change_values"><a href="#" class="btn btn-sm btn-primary calculateFdp">Calculate FDP</a>' +
                '<a href="#" class="btn btn-sm btn-warning emptyText">Not Issued</a>'+'<a href="#" class="btn btn-sm btn-success done">Done</a>' +
                '<a href="#" class="btn btn-sm btn-danger cancelChanges">Cancel</a>');

        input.appendTo(_this);
        originalValue.appendTo(_this);
        save.appendTo(_this);
        Add_Date_Format(date_format, true);
        Apply_Multiselect();
        input.focus();
        loadButtons();
    });

    function cancelChanges(){
        var _this = $('p.editable_values > input.editable[type=text]'),
            originalValue = $('p.editable_values > input.originalValue[type=hidden]'), value;
        value = originalValue.val();
        _this.parent().text(value);
        _this.remove();
    }

    function saveChanges(){
        var _this = parent.find('p.editable_values > input.editable[type=text]'),
            originalValue = parent.find('p.editable_values > input.originalValue[type=hidden]'), value;
        value = _this.val();
        _this.parent().text(value);
        if (value != originalValue.val())
            parent.find('p.editable_values').addClass('edited');

        _this.remove();
    }

    function loadButtons(){
        $('.cancelChanges').click(function () {
            cancelChanges();
        });

        $('.done').click(function () {
            saveChanges();
        });

        $('.calculateFdp').click(function () {
            var _this = $(this),  diff, parent = _this.parents('tr'), fdpEnd, fdpSystem, fdpUserDefined,
                userDefined = parent.find('.date_format'), originalValue = parent.find('.originalValue'),
                fdpStart = parent.find('.fdpStart'), editedfdpEstimate, departure = parent.find('.departure'),
                fdpEstimate = parent.find('.fdpEstimate'), fdpPlanned = parent.find('.fdpPlanned'),
                fdpMaxFcm = parent.find('.fdpMaxFcm'),fdpCalculated = parent.find('.fdpCalculated'),
                arrival = parent.find('.arrival'),
                fdpMaxCcm = parent.find('.fdpMaxCcm'), std = parent.find('.std'), departureTime,
                userDefinedTime = moment(userDefined.val()), fdpStartTime = moment(fdpStart.text());

            // Diff in Seconds Between Etd And Std
            if (userDefinedTime.isValid()) {
                if (moment(fdpStartTime).diff(userDefinedTime, 'm') > 0){
                    userDefined.val(originalValue.val());
                    showMessage('ETD Cannot Be Earlier Than Report Time', 'Error', MESSAGE_DANGER, messageBox);
                }
                else {
                    departureTime = moment(departure.text());
                    diff = userDefinedTime.diff(departureTime, 'h', true);

                    fdpEnd = moment(arrival.text()).add(30,'m');
                    // FDP Actual (in System)
                    fdpSystem= moment(fdpEnd).diff(fdpStartTime, 'h', true);

                    fdpUserDefined = (parseFloat(fdpSystem) + parseFloat(diff)).toFixed(1);

                    fdpCalculated.text(fdpUserDefined)
                                .addClass('edited');

                    if (fdpUserDefined > fdpMaxFcm.text())
                        fdpMaxFcm.parent().attr('class', 'red');
                    else
                        fdpMaxFcm.parent().attr('class', 'green');

                    if (fdpUserDefined > fdpMaxCcm.text()) {
                        fdpMaxCcm.parent().attr('class', 'red');
                    }
                    else
                        fdpMaxCcm.parent().attr('class', 'green');
                }
            }
        });

        $('.emptyText').click(function () {
            var _this =  $('input.date_format.editable');
            _this.val("");
        });

    }

    $('#applyFilter').click(function () {
        var _this = $(this), parent = _this.parents('.filters'),
            valid = parent.find('span.valid').attr('data-apply'), crossed = parent.find('span.crossed').attr('data-apply'),
            selectFilter = _this.prev('select'), tableRecords = $('#fdpReport > tbody >tr'), number, i = 1;

        tableRecords.each(function () {
            var search, searchRed;
            number = $(this).find('td:first');
            if (valid == 1 && crossed == 1) {
            }
            else if (valid == 1) {
                search = $(this).find('td.red');
            }
            else if (crossed == 1) {
                search = $(this).find('td.green');
                searchRed = $(this).find('td.red');
            }
            if (typeof search !== 'undefined' && search.length > 0){
                if (typeof searchRed !== 'undefined' && searchRed.length > 0) {
                    number.text(i++);
                    $(this).show();
                }
                else
                    $(this).hide();
            }
            else{
                number.text(i++);
                $(this).show();
            }
        })

    });

});




